var minimist = require('minimist')
var getAbi = require('node-abi').getAbi

var env = process.env

// Get `prebuild-install` arguments that were passed to the `npm` command
if (env.npm_config_argv) {
  var npmargs = ['prebuild', 'compile', 'build-from-source', 'debug']
  try {
    var npmArgv = JSON.parse(env.npm_config_argv).cooked
    for (var i = 0; i < npmargs.length; ++i) {
      if (npmArgv.indexOf('--' + npmargs[i]) !== -1) {
        process.argv.push('--' + npmargs[i])
      }
      if (npmArgv.indexOf('--no-' + npmargs[i]) !== -1) {
        process.argv.push('--no-' + npmargs[i])
      }
    }
    if ((i = npmArgv.indexOf('--download')) !== -1) {
      process.argv.push(npmArgv[i], npmArgv[i + 1])
    }
  } catch (e) { }
}

// Get the configuration
module.exports = function (pkg) {
  var pkgConf = pkg.config || {}
  var rc = require('rc')('prebuild-install', {
    target: pkgConf.target || env.npm_config_target || process.versions.node,
    runtime: pkgConf.runtime || env.npm_config_runtime || 'node',
    arch: pkgConf.arch || env.npm_config_arch || process.arch,
    libc: env.LIBC,
    platform: env.npm_config_platform || process.platform,
    debug: false,
    verbose: false,
    prebuild: true,
    compile: false,
    path: '.',
    proxy: env.npm_config_proxy || env['HTTP_PROXY'],
    'https-proxy': env.npm_config_https_proxy || env['HTTPS_PROXY'],
    'local-address': env.npm_config_local_address
  }, minimist(process.argv, {
    alias: {
      target: 't',
      runtime: 'r',
      help: 'h',
      arch: 'a',
      path: 'p',
      version: 'v',
      download: 'd',
      'build-from-source': 'compile',
      compile: 'c'
    }
  }))

  if (rc.path === true) {
    delete rc.path
  }

  rc.abi = getAbi(rc.target, rc.runtime)

  return rc
}

// Print the configuration values when executed standalone for testing purposses
if (!module.parent) {
  console.log(JSON.stringify(module.exports({}), null, 2))
}
