#ifndef _HC_NET_SDK_H_
#define _HC_NET_SDK_H_



#ifndef _WINDOWS_
    #if (defined(_WIN32) || defined(_WIN64))
        #include <winsock2.h>
        #include <windows.h>    
    #endif
#endif

#ifndef __PLAYRECT_defined
#define __PLAYRECT_defined
typedef struct __PLAYRECT
{
    int x;                               
    int y;                                  
    int uWidth;                            
    int uHeight;                            
}PLAYRECT;
#endif

#if (defined(_WIN32)) //windows
#define NET_DVR_API  extern "C" __declspec(dllimport)
typedef  unsigned __int64 UINT64;
typedef  signed __int64 INT64;
#elif defined(__linux__) || defined(__APPLE__) //linux
typedef     unsigned int    DWORD;
typedef     unsigned short  WORD;
typedef     unsigned short  USHORT;
typedef     short           SHORT;
typedef     int             LONG;
typedef      unsigned char    BYTE;
#define     BOOL int
typedef     unsigned int       UINT;
typedef     void*             LPVOID;
typedef     void*             HANDLE;
typedef     unsigned int*  LPDWORD; 
typedef  unsigned long long UINT64;
typedef  signed long long INT64;

#ifndef    TRUE
#define    TRUE    1
#endif
#ifndef    FALSE
#define       FALSE 0
#endif
#ifndef    NULL
#define       NULL 0
#endif

#define __stdcall 
#define CALLBACK  

#define NET_DVR_API extern "C"
typedef unsigned int   COLORKEY;
typedef unsigned int   COLORREF;

#ifndef __HWND_defined
#define __HWND_defined
#if defined(__linux__)
typedef unsigned int HWND;
#else
typedef void* HWND;
#endif
#endif


#ifndef __HDC_defined
#define __HDC_defined
#if defined(__linux__)
typedef struct __DC
{
    void*   surface;        //SDL Surface
    HWND    hWnd;           // HDC window handle
}DC;
typedef DC* HDC;
#else
typedef void* HDC;
#endif
#endif

typedef struct tagInitInfo
{
    int uWidth; 
    int uHeight; 
}INITINFO; 
#endif

//궨
#define MAX_NAMELEN                16        //DVRص½
#define MAX_RIGHT                32        //豸ֵ֧Ȩޣ1-12ʾȨޣ13-32ʾԶȨޣ
#define NAME_LEN                32      //û
#define PASSWD_LEN                16      //볤
#define MAX_PASSWD_LEN_EX            64      //볤64λ
#define GUID_LEN                16      //GUID
#define DEV_TYPE_NAME_LEN        24      //豸Ƴ
#define SERIALNO_LEN            48      //кų
#define MACADDR_LEN                6       //macַ
#define MAX_ETHERNET            2       //豸̫
#define MAX_NETWORK_CARD        4       //豸Ŀ
#define PATHNAME_LEN            128     //·
#define MAX_PRESET_V13          16      //Ԥõ
#define MAX_TEST_COMMAND_NUM   32      //߲Աֶγ
#define MAX_NUMBER_LEN            32        //󳤶
#define MAX_NAME_LEN            128        //豸󳤶
#define MAX_INDEX_LED           8       //LEDֵ 2013-11-19
#define    MAX_CUSTOM_DIR            64      //ԶĿ¼󳤶
#define URL_LEN_V40             256        //URL
#define CLOUD_NAME_LEN          48      //ƴ洢û
#define CLOUD_PASSWD_LEN        48      //ƴ洢볤
#define MAX_SENSORNAME_LEN      64      //Ƴ
#define MAX_SENSORCHAN_LEN      32      //ͨ
#define MAX_DESCRIPTION_LEN     32      //
#define MAX_DEVNAME_LEN_EX      64      //豸Ƴչ
#define MAX_FILE_PATH_LEN       256     //ļ· 
#define MAX_TMEVOICE_LEN        64      //TMEݳ

#define MAX_NUM_INPUT_BOARD     512     //
#define MAX_SHIPSDETE_REGION_NUM    8 // ֻбĿ

//СLED
#define  MAX_LEN_TEXT_CONTENT    128  //ַݳ
#define  MAX_NUM_INPUT_SOURCE_TEXT    32    //źԴɵӵı
#define  MAX_NUM_OUTPUT_CHANNEL  512  //LEDڸ

//2013-11-19
#define MAX_DEVNAME_LEN         32      //豸󳤶
#define MAX_LED_INFO            256     //ĻʾϢ󳤶
#define MAX_TIME_LEN            32      //ʱ󳤶
#define MAX_CARD_LEN            24      //󳤶
#define MAX_OPERATORNAME_LEN    32      //Ա󳤶

#define THERMOMETRY_ALARMRULE_NUM 40     //ȳ񱨾
#define MAX_THERMOMETRY_REGION_NUM  40  //ȶͼ֧
#define MAX_THERMOMETRY_DIFFCOMPARISON_NUM  40 //ȳ²
#define MAX_SHIPS_NUM           20      //ֻֻ
#define KEY_WORD_NUM             3 //ؼָ
#define KEY_WORD_LEN            128  //ؼֳ
//첽¼ص״̬궨
#define ASYN_LOGIN_SUCC            1        //첽¼ɹ
#define ASYN_LOGIN_FAILED        0        //첽¼ʧ


#define MAX_TIMESEGMENT_V30        8       //9000豸ʱ
#define MAX_TIMESEGMENT            4       //8000豸ʱ
#define MAX_ICR_NUM             8       //ץĻ˹ƬԤõ2013-07-09

#define MAX_SHELTERNUM            4       //8000豸ڵ
#define MAX_DAYS                7       //ÿ
#define PHONENUMBER_LEN            32      //pppoeź󳤶

#define MAX_DISKNUM_V30            33        //9000豸Ӳ/* 33Ӳ(16SATAӲ̡1eSATAӲ̺16NFS) */
#define MAX_DISKNUM                16      //8000豸Ӳ
#define MAX_DISKNUM_V10            8       //1.2汾֮ǰ汾

#define MAX_WINDOW_V30            32      //9000豸ʾ󲥷Ŵ
#define MAX_WINDOW_V40            64      //Netra 2.3.1չ
#define MAX_WINDOW                16      //8000豸Ӳ
#define MAX_VGA_V30                4       //9000豸ɽVGA
#define MAX_VGA                    1       //8000豸ɽVGA

#define MAX_USERNUM_V30            32      //9000豸û
#define MAX_USERNUM                16      //8000豸û
#define MAX_EXCEPTIONNUM_V30    32      //9000豸쳣
#define MAX_EXCEPTIONNUM        16      //8000豸쳣
#define MAX_LINK                6       //8000豸ͨƵ
#define MAX_ITC_EXCEPTIONOUT    32      //ץĻ󱨾
#define MAX_SCREEN_DISPLAY_LEN            512    //Ļʾַ

#define MAX_DECPOOLNUM            4       //·ÿͨѭ
#define MAX_DECNUM                4       //·ͨʵֻһ
#define MAX_TRANSPARENTNUM        2       //·͸ͨ
#define MAX_CYCLE_CHAN            16      //·Ѳͨ
#define MAX_CYCLE_CHAN_V30      64      //Ѳͨչ
#define MAX_DIRNAME_LENGTH        80      //Ŀ¼
#define MAX_WINDOWS                16      //󴰿


#define MAX_STRINGNUM_V30        8        //9000豸OSDַ
#define MAX_STRINGNUM            4       //8000豸OSDַ
#define MAX_STRINGNUM_EX        8       //8000չ
#define MAX_AUXOUT_V30            16      //9000豸
#define MAX_AUXOUT                4       //8000豸
#define MAX_HD_GROUP            16      //9000豸Ӳ
#define MAX_HD_GROUP_V40        32      //豸Ӳ
#define MAX_NFS_DISK            8       //8000豸NFSӲ

#define IW_ESSID_MAX_SIZE        32      //WIFISSIDų
#define IW_ENCODING_TOKEN_MAX    32      //WIFIֽ
#define MAX_SERIAL_NUM            64        //ֵ֧͸ͨ·
#define MAX_DDNS_NUMS            10      //9000豸ddns
#define MAX_DOMAIN_NAME            64        /*  */
#define MAX_EMAIL_ADDR_LEN        48      //emailַ
#define MAX_EMAIL_PWD_LEN        32      //email볤
#define MAX_SLAVECAMERA_NUM     8       //
#define MAX_CALIB_NUM           6       //궨ĸ
#define MAX_CALIB_NUM_EX        20      //չ궨ĸ   
#define MAX_LEDDISPLAYINFO_LEN  1024    //LEDʾ
#define MAX_PEOPLE_DETECTION_NUM    8  //Ա
#define MAXPROGRESS                100     //طʱٷ
#define MAX_SERIALNUM            2       //8000豸ֵ֧Ĵ 1-232 2-485
#define CARDNUM_LEN                20      //ų
#define CARDNUM_LEN_OUT            32      //ⲿṹ忨ų
#define MAX_VIDEOOUT_V30        4       //9000豸Ƶ
#define MAX_VIDEOOUT            2       //8000豸Ƶ

#define MAX_PRESET_V30            256        /* 9000豸ֵ̨֧Ԥõ */
#define MAX_TRACK_V30            256        /* 9000豸ֵ̨֧켣 */
#define MAX_CRUISE_V30            256        /* 9000豸ֵ̨֧Ѳ */
#define MAX_PRESET                128        /* 8000豸ֵ̨֧Ԥõ */
#define MAX_TRACK                128        /* 8000豸ֵ̨֧켣 */
#define MAX_CRUISE                128        /* 8000豸ֵ̨֧Ѳ */

#define MAX_PRESET_V40            300        /* ֵ̨֧Ԥõ */
#define MAX_CRUISE_POINT_NUM    128     /* ֵ֧Ѳĸ */

#define CRUISE_MAX_PRESET_NUMS    32         /* һѲѲ */
#define MAX_FACE_PIC_NUM        30      /*ͼ*/
#define LOCKGATE_TIME_NUM       4       //բʱθ

#define MAX_SERIAL_PORT         8       //9000豸֧232
#define MAX_PREVIEW_MODE        8       /* 豸֧ԤģʽĿ 1,4,9,16.... */
#define MAX_MATRIXOUT           16      /* ģ */
#define LOG_INFO_LEN            11840   /* ־Ϣ */
#define DESC_LEN                16      /* ַ̨ */
#define PTZ_PROTOCOL_NUM        200     /* 9000ֵ̨֧Э */
#define IPC_PROTOCOL_NUM        50   //ipc Э

#define MAX_AUDIO                1       //8000Խͨ
#define MAX_AUDIO_V30            2       //9000Խͨ
#define MAX_CHANNUM                16      //8000豸ͨ
#define MAX_ALARMIN                16      //8000豸󱨾
#define MAX_ALARMOUT            4       //8000豸󱨾
//9000 IPC
#define MAX_ANALOG_CHANNUM      32      //32ģͨ
#define MAX_ANALOG_ALARMOUT     32      //32·ģⱨ 
#define MAX_ANALOG_ALARMIN      32      //32·ģⱨ

#define MAX_IP_DEVICE           32      //IP豸
#define MAX_IP_DEVICE_V40       64      // IP豸 64 IVMS 2000豸
#define MAX_IP_CHANNEL          32      //IPͨ
#define MAX_IP_ALARMIN          128     //౨
#define MAX_IP_ALARMOUT         64      //౨
#define MAX_IP_ALARMIN_V40      4096    //౨
#define MAX_IP_ALARMOUT_V40     4096    //౨

#define MAX_RECORD_FILE_NUM     20      // ÿɾ߿¼ļ
//SDK_V31 ATM
#define MAX_ACTION_TYPE            12        //ԶЭӽΪΪ 
#define MAX_ATM_PROTOCOL_NUM    256   //ÿ뷽ʽӦATMЭ
#define ATM_CUSTOM_PROTO        1025   //ԶЭ ֵΪ1025
#define ATM_PROTOCOL_SORT       4       //ATMЭ 
#define ATM_DESC_LEN            32      //ATMַ
// SDK_V31 ATM


#define MAX_IPV6_LEN              64   //IPv6ַ󳤶
#define MAX_EVENTID_LEN         64   //¼ID

#define INVALID_VALUE_UINT32    0xffffffff   //Чֵ
#define MAX_CHANNUM_V40         512
#define MAX_MULTI_AREA_NUM      24

#define MAX_SINGLE_FTPPICNAME_LEN       20 //󵥸FTPͨ
#define MAX_CAMNAME_LEN                 32 //ͨ
#define MAX_FTPNAME_NUM                 12 //TFP
//SDK ¼
#define COURSE_NAME_LEN                32    //γ
#define INSTRUCTOR_NAME_LEN            16    //ڿνʦ
#define COURSE_DESCRIPTION_LEN        256    //γϢ

#define MAX_TIMESEGMENT_V40            16    //ÿڿϢ


#define MAX_MIX_CHAN_NUM        16    /*Ŀǰֵ֧ͨͨ + MIC + LINE IN + 4С*/ 
#define MAX_LINE_IN_CHAN_NUM    16    //line inͨ
#define MAX_MIC_CHAN_NUM        16    //MICͨ
#define INQUEST_CASE_NO_LEN        64    //Ѷų
#define INQUEST_CASE_NAME_LEN    64    //ѶƳ
#define CUSTOM_INFO_LEN            64    //ԶϢ
#define INQUEST_CASE_LEN        64    //ѶϢ


#define MAX_FILE_ID_LEN         128    //ͼĿļID󳤶
#define MAX_PIC_NAME_LEN        128 //ͼƬƳ

/* ֵ֧ͨ ģIP֧ */
#define MAX_CHANNUM_V30               ( MAX_ANALOG_CHANNUM + MAX_IP_CHANNEL )//64
#define MAX_ALARMOUT_V40             (MAX_IP_ALARMOUT_V40 +MAX_ANALOG_ALARMOUT) //4128
#define MAX_ALARMOUT_V30              ( MAX_ANALOG_ALARMOUT + MAX_IP_ALARMOUT )//96
#define MAX_ALARMIN_V30               ( MAX_ANALOG_ALARMIN + MAX_IP_ALARMIN )//160
#define MAX_ALARMIN_V40             (MAX_IP_ALARMIN_V40 +MAX_ANALOG_ALARMOUT) //4128
#define MAX_ANALOG_ALARM_WITH_VOLT_LIMIT    16 //ܵѹ޶ģⱨ

#define MAX_ROIDETECT_NUM       8    //ֵ֧ROI
#define MAX_LANERECT_NUM        5    //ʶ
#define MAX_FORTIFY_NUM         10   //󲼷
#define MAX_INTERVAL_NUM        4    //ʱ
#define MAX_CHJC_NUM            3    //ʡݼַ
#define MAX_VL_NUM              5    //Ȧ
#define MAX_DRIVECHAN_NUM       16   //󳵵
#define MAX_COIL_NUM            3    //Ȧ
#define MAX_SIGNALLIGHT_NUM     6   //źŵƸ
#define LEN_16                    16
#define LEN_32                    32
#define LEN_31                    31 
#define MAX_CABINET_COUNT       8    //ֻ֧
#define MAX_ID_LEN              48
#define MAX_PARKNO_LEN          16
#define MAX_ALARMREASON_LEN     32
#define MAX_UPGRADE_INFO_LEN    48 //ȡļƥϢ(ģ)
#define MAX_CUSTOMDIR_LEN       32 //ԶĿ¼
#define MAX_LED_INFO_LEN        512//LEDݳ
#define MAX_VOICE_INFO_LEN      128//ݳ
#define MAX_LITLE_INFO_LEN      64 //ֽƱݳ
#define MAX_CUSTOM_INFO_LEN     64 //ֽƱԶϢݳ
#define MAX_PHONE_NUM_LEN       16 //ϵ绰ݳ
#define MAX_APP_SERIALNUM_LEN   32 //Ӧкų

#define AUDIOTALKTYPE_G722       0
#define AUDIOTALKTYPE_G711_MU    1
#define AUDIOTALKTYPE_G711_A     2
#define AUDIOTALKTYPE_MP2L2      5
#define AUDIOTALKTYPE_G726         6
#define AUDIOTALKTYPE_AAC         7
#define AUDIOTALKTYPE_PCM         8

//packet type
#define FILE_HEAD            0 //file head
#define VIDEO_I_FRAME        1 //video I frame
#define VIDEO_B_FRAME        2 //video B frame
#define VIDEO_P_FRAME        3 //video P frame
#define AUDIO_PACKET        10 //audio packet
#define PRIVT_PACKET        11 //private packet
//E frame
#define HIK_H264_E_FRAME    (1 << 6)   // ǰE֡,P֡Ҳûõ
#define MAX_TRANSPARENT_CHAN_NUM      4   //ÿ͸ͨ
#define MAX_TRANSPARENT_ACCESS_NUM    4   //ÿ˿

//ITS
#define MAX_PARKING_STATUS       8    //λ״̬ 0޳1г2ѹ(ȼ), 3⳵λ 
#define MAX_PARKING_NUM             4    //һͨ4λ (ҳλ 03)

#define MAX_ITS_SCENE_NUM        16   //󳡾
#define MAX_SCENE_TIMESEG_NUM    16   //󳡾ʱ
#define MAX_IVMS_IP_CHANNEL      128  //IPͨ
#define DEVICE_ID_LEN            48   //豸ų
#define MONITORSITE_ID_LEN       48   //ų
#define MAX_AUXAREA_NUM          16   //Ŀ
#define MAX_SLAVE_CHANNEL_NUM    16   //ͨ
#define MAX_DEVDESC_LEN          64   //豸Ϣ󳤶



#define MAX_SECRETKEY_LEN           512     //Կ
#define MAX_INDEX_CODE_LEN          64      //ų
#define MAX_ILLEGAL_LEN          64     //Υַ
#define CODE_LEN        64  //Ȩ
#define ALIAS_LEN       32  //ֻ
#define MAX_SCH_TASKS_NUM        10

#define MAX_SERVERID_LEN            64 //IDĳ
#define MAX_SERVERDOMAIN_LEN        128 //󳤶
#define MAX_AUTHENTICATEID_LEN      64 //֤ID󳤶
#define MAX_AUTHENTICATEPASSWD_LEN  32 //֤󳤶
#define MAX_SERVERNAME_LEN          64 //û 
#define MAX_COMPRESSIONID_LEN       64 //ID󳤶
#define MAX_SIPSERVER_ADDRESS_LEN   128 //SIPַ֧IPַ
//ѹ߱
#define MAX_PlATE_NO_LEN            32   //ƺ󳤶 2013-09-27
#define UPNP_PORT_NUM                12      //upnp˿ӳ˿Ŀ

#define MAX_PEOPLE_DETECTION_NUM    8  //Ա

#define MAX_NOTICE_NUMBER_LEN       32   //󳤶
#define MAX_NOTICE_THEME_LEN        64   //󳤶
#define MAX_NOTICE_DETAIL_LEN       1024 //󳤶
#define MAX_NOTICE_PIC_NUM          6    //ϢͼƬ
#define MAX_DEV_NUMBER_LEN          32   //豸󳤶



#define HOLIDAY_GROUP_NAME_LEN          32  //Ƴ
#define MAX_HOLIDAY_PLAN_NUM            16  //ռƻ
#define TEMPLATE_NAME_LEN               32  //ƻģƳ
#define MAX_HOLIDAY_GROUP_NUM           16   //ƻģ
#define DOOR_NAME_LEN                   32  //
#define STRESS_PASSWORD_LEN             8   //в볤
#define SUPER_PASSWORD_LEN              8   //в볤
#define GROUP_NAME_LEN                  32  //ȺƳ
#define GROUP_COMBINATION_NUM           8   //Ⱥ
#define MULTI_CARD_GROUP_NUM            4   //ؿ
#define ACS_CARD_NO_LEN                 32  //Žų
#define CARD_PASSWORD_LEN               8   //볤
#define MAX_DOOR_NUM                    32  //
#define MAX_CARD_RIGHT_PLAN_NUM         4   //Ȩƻ
#define MAX_CARD_READER_NUM             64  //
#define MAX_SNEAK_PATH_NODE             8   //
#define MAX_MULTI_DOOR_INTERLOCK_GROUP  8   //Ż
#define MAX_INTER_LOCK_DOOR_NUM         8   //һŻ
#define MAX_CASE_SENSOR_NUM             8   //case sensor
#define MAX_DOOR_NUM_256                256 //
#define MAX_READER_ROUTE_NUM            16  //ˢѭ· 
#define MAX_FINGER_PRINT_NUM            10  //ָƸ
#define MAX_CARD_READER_NUM_512            512 //

#define ERROR_MSG_LEN      32 //·Ϣ

#define PER_RING_PORT_NUM                2   //ÿĶ˿
#define SENSORNAME_LEN                  32  //Ƴ
#define MAX_SENSORDESCR_LEN             64  //
#define MAX_DNS_SERVER_NUM              2 //DNS

#define WEP_KEY_MAX_SIZE                32 //WEPԿ
#define WEP_KEY_MAX_NUM                 4  //WEPԿ
#define WPA_KEY_MAX_SIZE                64 //WPAԿ



#define MAX_IDCODE_LEN      128 //  ʶ󳤶
#define MAX_VERSIIN_LEN     64  //汾󳤶
#define MAX_IDCODE_NUM      32  // ʶ
#define SDK_LEN_2048        2048

#define RECT_POINT_NUM                    4    //ν

#define MAX_PUBLIC_KEY_LEN 512 // Կ
#define CHIP_SERIALNO_LEN 32 //оƬкų
#define ENCRYPT_DEV_ID_LEN        20  //豸ID

//MCUص
#define MAX_SEARCH_ID_LEN               36  //ʶ󳤶
#define TERMINAL_NAME_LEN               64  //նƳ
#define MAX_URL_LEN                     512 //URL
#define REGISTER_NAME_LEN               64 //նעGK󳤶

//
#define MAX_PORT_NUM            64  //˿
#define MAX_SINGLE_CARD_PORT_NO 4   //շ˿
#define MAX_FUNC_CARD_NUM       32  //շܿ
#define MAX_FC_CARD_NUM         33  //շ
#define MAX_REMARKS_LEN         128 //ע󳤶
#define MAX_OUTPUT_PORT_NUM                32    //·˿
#define MAX_SINGLE_PORT_RECVCARD_NUM    64    //˿ӵտ
#define MAX_GAMMA_X_VALUE                256    //GAMMAXȡֵ


#define PLAYLIST_NAME_LEN                64            //űƳ 
#define PLAYLIST_ITEM_NUM                64            //Ŀ  
/*******************ȫִ begin**********************/    
#define NET_DVR_NOERROR                     0    //ûд
#define NET_DVR_PASSWORD_ERROR                 1    //û
#define NET_DVR_NOENOUGHPRI                 2    //Ȩ޲
#define NET_DVR_NOINIT                         3    //ûгʼ
#define NET_DVR_CHANNEL_ERROR                 4    //ͨŴ
#define NET_DVR_OVER_MAXLINK                 5    //ӵDVRĿͻ˸
#define NET_DVR_VERSIONNOMATCH                6    //汾ƥ
#define NET_DVR_NETWORK_FAIL_CONNECT        7    //ӷʧ
#define NET_DVR_NETWORK_SEND_ERROR            8    //ʧ
#define NET_DVR_NETWORK_RECV_ERROR            9    //ӷʧ
#define NET_DVR_NETWORK_RECV_TIMEOUT        10    //ӷݳʱ
#define NET_DVR_NETWORK_ERRORDATA            11    //͵
#define NET_DVR_ORDER_ERROR                    12    //ô
#define NET_DVR_OPERNOPERMIT                13    //޴Ȩ
#define NET_DVR_COMMANDTIMEOUT                14    //DVRִгʱ
#define NET_DVR_ERRORSERIALPORT                15    //ںŴ
#define NET_DVR_ERRORALARMPORT                16    //˿ڴ
#define NET_DVR_PARAMETER_ERROR             17  //
#define NET_DVR_CHAN_EXCEPTION                18    //ͨڴ״̬
#define NET_DVR_NODISK                        19    //ûӲ
#define NET_DVR_ERRORDISKNUM                20    //Ӳ̺Ŵ
#define NET_DVR_DISK_FULL                    21    //Ӳ
#define NET_DVR_DISK_ERROR                    22    //Ӳ̳
#define NET_DVR_NOSUPPORT                    23    //֧
#define NET_DVR_BUSY                        24    //æ
#define NET_DVR_MODIFY_FAIL                    25    //޸Ĳɹ
#define NET_DVR_PASSWORD_FORMAT_ERROR        26    //ʽȷ
#define NET_DVR_DISK_FORMATING                27    //Ӳڸʽ
#define NET_DVR_DVRNORESOURCE                28    //DVRԴ
#define    NET_DVR_DVROPRATEFAILED                29  //DVRʧ
#define NET_DVR_OPENHOSTSOUND_FAIL             30  //PCʧ
#define NET_DVR_DVRVOICEOPENED                 31  //Խռ
#define    NET_DVR_TIMEINPUTERROR                32  //ʱ벻ȷ
#define    NET_DVR_NOSPECFILE                    33  //طʱûָļ
#define NET_DVR_CREATEFILE_ERROR            34    //ļ
#define    NET_DVR_FILEOPENFAIL                35  //ļ
#define    NET_DVR_OPERNOTFINISH                36  //ϴεĲû
#define    NET_DVR_GETPLAYTIMEFAIL                37  //ȡǰŵʱ
#define    NET_DVR_PLAYFAIL                    38  //ų
#define NET_DVR_FILEFORMAT_ERROR            39  //ļʽȷ
#define NET_DVR_DIR_ERROR                    40    //·
#define NET_DVR_ALLOC_RESOURCE_ERROR        41  //Դ
#define NET_DVR_AUDIO_MODE_ERROR            42    //ģʽ
#define NET_DVR_NOENOUGH_BUF                43    //̫С
#define NET_DVR_CREATESOCKET_ERROR             44    //SOCKET
#define NET_DVR_SETSOCKET_ERROR                45    //SOCKET
#define NET_DVR_MAX_NUM                        46    //ﵽ
#define NET_DVR_USERNOTEXIST                47    //û
#define NET_DVR_WRITEFLASHERROR                48  //дFLASH
#define NET_DVR_UPGRADEFAIL                    49  //DVRʧ
#define NET_DVR_CARDHAVEINIT                50  //뿨Ѿʼ
#define NET_DVR_PLAYERFAILED                51    //òſĳʧ
#define NET_DVR_MAX_USERNUM                    52  //豸ûﵽ
#define NET_DVR_GETLOCALIPANDMACFAIL        53  //ÿͻ˵IPַַʧ
#define NET_DVR_NOENCODEING                    54    //ͨûб
#define NET_DVR_IPMISMATCH                    55    //IPַƥ
#define NET_DVR_MACMISMATCH                    56    //MACַƥ
#define NET_DVR_UPGRADELANGMISMATCH            57    //ļԲƥ
#define NET_DVR_MAX_PLAYERPORT                58    //·ﵽ
#define NET_DVR_NOSPACEBACKUP                59    //豸û㹻ռб
#define NET_DVR_NODEVICEBACKUP                60    //ûҵָı豸
#define NET_DVR_PICTURE_BITS_ERROR            61    //ͼλ24ɫ
#define NET_DVR_PICTURE_DIMENSION_ERROR        62    //ͼƬ*ޣ 128*256
#define NET_DVR_PICTURE_SIZ_ERROR            63    //ͼƬСޣ100K
#define NET_DVR_LOADPLAYERSDKFAILED            64    //뵱ǰĿ¼Player Sdk
#define NET_DVR_LOADPLAYERSDKPROC_ERROR        65    //ҲPlayer Sdkĳ
#define NET_DVR_LOADDSSDKFAILED                66    //뵱ǰĿ¼DSsdk
#define NET_DVR_LOADDSSDKPROC_ERROR            67    //ҲDsSdkĳ
#define NET_DVR_DSSDK_ERROR                    68    //ӲDsSdkĳʧ
#define NET_DVR_VOICEMONOPOLIZE                69    //ռ
#define NET_DVR_JOINMULTICASTFAILED            70    //ಥʧ
#define NET_DVR_CREATEDIR_ERROR                71    //־ļĿ¼ʧ
#define NET_DVR_BINDSOCKET_ERROR            72    //׽ʧ
#define NET_DVR_SOCKETCLOSE_ERROR            73    //socketжϣ˴ͨжϻĿĵزɴ
#define NET_DVR_USERID_ISUSING                74    //עʱûIDڽĳ
#define NET_DVR_SOCKETLISTEN_ERROR            75    //ʧ
#define NET_DVR_PROGRAM_EXCEPTION            76    //쳣
#define NET_DVR_WRITEFILE_FAILED            77    //дļʧ
#define NET_DVR_FORMAT_READONLY                78  //ֹʽֻӲ
#define NET_DVR_WITHSAMEUSERNAME            79  //ûýṹдͬû
#define NET_DVR_DEVICETYPE_ERROR            80  /*ʱ豸ͺŲƥ*/
#define NET_DVR_LANGUAGE_ERROR              81  /*ʱԲƥ*/
#define NET_DVR_PARAVERSION_ERROR           82  /*ʱ汾ƥ*/
#define NET_DVR_IPCHAN_NOTALIVE             83  /*ԤʱIPͨ*/
#define NET_DVR_RTSP_SDK_ERROR                84    /*ظIPCͨѶStreamTransClient.dllʧ*/
#define NET_DVR_CONVERT_SDK_ERROR            85    /*תʧ*/
#define NET_DVR_IPC_COUNT_OVERFLOW            86  /*ipͨ*/
#define NET_DVR_MAX_ADD_NUM                 87  /*ӱǩ(һļƬ64)ȸﵽ*/
#define NET_DVR_PARAMMODE_ERROR             88 //ͼǿǣģʽӲʱͻ˽ʱֵ
#define NET_DVR_CODESPITTER_OFFLINE            89 //Ƶۺƽ̨
#define NET_DVR_BACKUP_COPYING                90  //豸ڱ
#define NET_DVR_CHAN_NOTSUPPORT             91  // ָ֧ͨò
#define NET_DVR_CALLINEINVALID              92  // ߶λ̫л򳤶߲б 
#define NET_DVR_CALCANCELCONFLICT           93  // ȡ궨ͻ˹ȫֵʵʴСߴ
#define NET_DVR_CALPOINTOUTRANGE            94     // 궨㳬Χ 
#define NET_DVR_FILTERRECTINVALID           95  // ߴҪ
#define NET_DVR_DDNS_DEVOFFLINE             96  //豸ûעᵽddns
#define NET_DVR_DDNS_INTER_ERROR            97  //DDNS ڲ
#define NET_DVR_FUNCTION_NOT_SUPPORT_OS     98  //˹ָ֧ܲòϵͳ
#define NET_DVR_DEC_CHAN_REBIND             99  //ͨʾ
#define NET_DVR_INTERCOM_SDK_ERROR          100 //صǰĿ¼µԽʧ
#define NET_DVR_NO_CURRENT_UPDATEFILE       101 //ûȷ  
#define NET_DVR_USER_NOT_SUCC_LOGIN         102  //ûû½ɹ
#define NET_DVR_USE_LOG_SWITCH_FILE            103  //ʹ־ļ
#define NET_DVR_POOL_PORT_EXHAUST            104  //˿ڳڰ󶨵Ķ˿Ѻľ
#define    NET_DVR_PACKET_TYPE_NOT_SUPPORT        105    //װʽ
#define NET_DVR_IPPARA_IPID_ERROR           106  //IPʱIPID

#define NET_DVR_LOAD_HCPREVIEW_SDK_ERROR           107         //Ԥʧ
#define NET_DVR_LOAD_HCVOICETALK_SDK_ERROR         108         //ʧ
#define NET_DVR_LOAD_HCALARM_SDK_ERROR             109         //ʧ
#define NET_DVR_LOAD_HCPLAYBACK_SDK_ERROR          110         //طʧ
#define NET_DVR_LOAD_HCDISPLAY_SDK_ERROR           111         //ʾʧ
#define NET_DVR_LOAD_HCINDUSTRY_SDK_ERROR          112         //ҵӦʧ
#define NET_DVR_LOAD_HCGENERALCFGMGR_SDK_ERROR     113         //ͨùʧ
#define NET_DVR_LOAD_HCCOREDEVCFG_SDK_ERROR        114         //豸úʧ

#define NET_DVR_CORE_VER_MISMATCH                  121    //ʱcore汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCPREVIEW        122    //Ԥcore汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCVOICETALK      123    //core汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCALARM          124    //core汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCPLAYBACK       125    //طcore汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCDISPLAY        126    //ʾcore汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCINDUSTRY       127    //ҵӦcore汾ƥ
#define NET_DVR_CORE_VER_MISMATCH_HCGENERALCFGMGR  128    //ͨùcore汾ƥ

#define NET_DVR_COM_VER_MISMATCH_HCPREVIEW         136    //ԤHCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCVOICETALK       137    //HCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCALARM           138    //HCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCPLAYBACK        139    //طHCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCDISPLAY         140    //ʾHCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCINDUSTRY        141    //ҵӦHCNetSDK汾ƥ
#define NET_DVR_COM_VER_MISMATCH_HCGENERALCFGMGR   142    //ͨùHCNetSDK汾ƥ

#define NET_DVR_ALIAS_DUPLICATE                150    //ظ  //2011-08-31 ͨк豸°汾ddns
#define    NET_DVR_INVALID_COMMUNICATION        151    //Чͨ
#define    NET_DVR_USERNAME_NOT_EXIST            152    //ûڣûڣIPC5.1.7зȥˣɾĲƷòϣ
#define    NET_DVR_USER_LOCKED                    153 //û
#define NET_DVR_INVALID_USERID              154 //ЧûID
#define NET_DVR_LOW_LOGIN_VERSION           155 //¼汾
#define NET_DVR_LOAD_LIBEAY32_DLL_ERROR     156 //libeay32.dllʧ
#define NET_DVR_LOAD_SSLEAY32_DLL_ERROR     157 //ssleay32.dllʧ
#define NET_ERR_LOAD_LIBICONV           158 //libiconvʧ

#define NET_DVR_SERVER_NOT_EXIST         164 //ӦķҲ,ʱĹұŻ߷ʹ
#define NET_DVR_TEST_SERVER_FAIL_CONNECT            165    //ӲԷʧ
#define NET_DVR_NAS_SERVER_INVALID_DIR                166    //NASĿ¼ʧܣĿ¼Ч
#define NET_DVR_NAS_SERVER_NOENOUGH_PRI                167    //NASĿ¼ʧܣûȨ
#define NET_DVR_EMAIL_SERVER_NOT_CONFIG_DNS            168    //ʹûDNSЧ
#define    NET_DVR_EMAIL_SERVER_NOT_CONFIG_GATEWAY        169    //ûأɷʼʧܡ
#define    NET_DVR_TEST_SERVER_PASSWORD_ERROR            170    //û벻ȷԷû
#define    NET_DVR_EMAIL_SERVER_CONNECT_EXCEPTION_WITH_SMTP    171    //豸smtp쳣
#define    NET_DVR_FTP_SERVER_FAIL_CREATE_DIR            172    //FTPĿ¼ʧ
#define    NET_DVR_FTP_SERVER_NO_WRITE_PIR                173    //FTPûдȨ
#define    NET_DVR_IP_CONFLICT                            174    //IPͻ
#define NET_DVR_INSUFFICIENT_STORAGEPOOL_SPACE      175  //洢ؿռ
#define NET_DVR_STORAGEPOOL_INVALID      176  //Ʒ洢Ч,ûô洢ػߴ洢ID
#define NET_DVR_EFFECTIVENESS_REBOOT     177  //ЧҪ
#define NET_ERR_ANR_ARMING_EXIST         178  //Ѿ(ôHIK˽вӽ£ظĶʱء)
#define NET_ERR_UPLOADLINK_EXIST         179  //ϴѾ(EHOMEЭHIK SDKЭǲͬʱֶ֧ģһЭڵʱһӽ롣)
#define NET_ERR_INCORRECT_FILE_FORMAT    180  //ļʽȷ
#define NET_ERR_INCORRECT_FILE_CONTENT   181  //ļݲȷ

// 2010-5-28
// д
#define RAID_ERROR_INDEX                    200
#define NET_DVR_NAME_NOT_ONLY               (RAID_ERROR_INDEX + 0)  // Ѵ
#define NET_DVR_OVER_MAX_ARRAY              (RAID_ERROR_INDEX + 1 ) // дﵽ
#define NET_DVR_OVER_MAX_VD                 (RAID_ERROR_INDEX + 2 ) // ̴ﵽ
#define NET_DVR_VD_SLOT_EXCEED              (RAID_ERROR_INDEX + 3 ) // ̲λ
#define NET_DVR_PD_STATUS_INVALID           (RAID_ERROR_INDEX + 4 ) // ؽ״̬
#define NET_DVR_PD_BE_DEDICATE_SPARE        (RAID_ERROR_INDEX + 5 ) // ؽΪָȱ
#define NET_DVR_PD_NOT_FREE                 (RAID_ERROR_INDEX + 6 ) // ؽ̷ǿ
#define NET_DVR_CANNOT_MIG2NEWMODE          (RAID_ERROR_INDEX + 7 ) // ܴӵǰǨƵµ
#define NET_DVR_MIG_PAUSE                   (RAID_ERROR_INDEX + 8 ) // ǨƲͣ
#define NET_DVR_MIG_CANCEL                  (RAID_ERROR_INDEX + 9 ) // ִеǨƲȡ
#define NET_DVR_EXIST_VD                    (RAID_ERROR_INDEX + 10) // ϴ̣޷ɾ
#define NET_DVR_TARGET_IN_LD_FUNCTIONAL     (RAID_ERROR_INDEX + 11) // Ϊɲҹ
#define NET_DVR_HD_IS_ASSIGNED_ALREADY      (RAID_ERROR_INDEX + 12) // ָ̱Ϊ
#define NET_DVR_INVALID_HD_COUNT            (RAID_ERROR_INDEX + 13) // ָRAIDȼƥ
#define NET_DVR_LD_IS_FUNCTIONAL            (RAID_ERROR_INDEX + 14) // ޷ؽ
#define NET_DVR_BGA_RUNNING                 (RAID_ERROR_INDEX + 15) // ִеĺ̨
#define NET_DVR_LD_NO_ATAPI                 (RAID_ERROR_INDEX + 16) // ޷ATAPI̴
#define NET_DVR_MIGRATION_NOT_NEED          (RAID_ERROR_INDEX + 17) // Ǩ
#define NET_DVR_HD_TYPE_MISMATCH            (RAID_ERROR_INDEX + 18) // ̲ͬ
#define NET_DVR_NO_LD_IN_DG                 (RAID_ERROR_INDEX + 19) // ̣޷д
#define NET_DVR_NO_ROOM_FOR_SPARE           (RAID_ERROR_INDEX + 20) // ̿ռС޷ָΪȱ
#define NET_DVR_SPARE_IS_IN_MULTI_DG        (RAID_ERROR_INDEX + 21) // ѱΪĳȱ
#define NET_DVR_DG_HAS_MISSING_PD           (RAID_ERROR_INDEX + 22) // ȱ

// x86 64bit nvr 2012-02-04
#define NET_DVR_NAME_EMPTY                    (RAID_ERROR_INDEX + 23) /*Ϊ*/
#define NET_DVR_INPUT_PARAM                    (RAID_ERROR_INDEX + 24) /**/
#define NET_DVR_PD_NOT_AVAILABLE            (RAID_ERROR_INDEX + 25) /*̲*/
#define NET_DVR_ARRAY_NOT_AVAILABLE            (RAID_ERROR_INDEX + 26) /*в*/
#define NET_DVR_PD_COUNT                    (RAID_ERROR_INDEX + 27) /*ȷ*/
#define NET_DVR_VD_SMALL                    (RAID_ERROR_INDEX + 28) /*̫С*/
#define NET_DVR_NO_EXIST                    (RAID_ERROR_INDEX + 29) /**/
#define NET_DVR_NOT_SUPPORT                    (RAID_ERROR_INDEX + 30) /*ָ֧ò*/
#define NET_DVR_NOT_FUNCTIONAL                 (RAID_ERROR_INDEX + 31) /*״̬״̬*/
#define NET_DVR_DEV_NODE_NOT_FOUND            (RAID_ERROR_INDEX + 32) /*豸ڵ㲻*/
#define NET_DVR_SLOT_EXCEED                    (RAID_ERROR_INDEX + 33) /*λﵽ*/ 
#define NET_DVR_NO_VD_IN_ARRAY                (RAID_ERROR_INDEX + 34) /*ϲ*/
#define NET_DVR_VD_SLOT_INVALID                (RAID_ERROR_INDEX + 35) /*̲λЧ*/
#define NET_DVR_PD_NO_ENOUGH_SPACE            (RAID_ERROR_INDEX + 36) /*̿ռ䲻*/
#define NET_DVR_ARRAY_NONFUNCTION            (RAID_ERROR_INDEX + 37) /*ֻд״̬вܽǨ*/
#define NET_DVR_ARRAY_NO_ENOUGH_SPACE        (RAID_ERROR_INDEX + 38) /*пռ䲻*/
#define NET_DVR_STOPPING_SCANNING_ARRAY        (RAID_ERROR_INDEX + 39) /*ִаȫ̻ɨ*/
#define NET_DVR_NOT_SUPPORT_16T             (RAID_ERROR_INDEX + 40) /*ִ֧16T*/
#define NET_DVR_ARRAY_FORMATING             (RAID_ERROR_INDEX + 41) /*ִиʽ޷ɾ*/ 
#define NET_DVR_QUICK_SETUP_PD_COUNT        (RAID_ERROR_INDEX + 42) /*һҪ*/ 

//豸δʱ¼ʧܣش
#define    NET_DVR_ERROR_DEVICE_NOT_ACTIVATED    250//豸δ
//SDK豸û߼ʱΪʱ
#define  NET_DVR_ERROR_RISK_PASSWORD          251 //зյ
//Ѽ豸ٴμʱش
#define    NET_DVR_ERROR_DEVICE_HAS_ACTIVATED    252//豸Ѽ


// ܴ 
#define VCA_ERROR_INDEX                     300 // ܴ
#define NET_DVR_ID_ERROR                    (VCA_ERROR_INDEX + 0)   // ID
#define NET_DVR_POLYGON_ERROR               (VCA_ERROR_INDEX + 1)   // βҪ
#define NET_DVR_RULE_PARAM_ERROR            (VCA_ERROR_INDEX + 2)   // 
#define NET_DVR_RULE_CFG_CONFLICT           (VCA_ERROR_INDEX + 3)   // Ϣͻ
#define NET_DVR_CALIBRATE_NOT_READY         (VCA_ERROR_INDEX + 4)   // ǰûб궨Ϣ
#define NET_DVR_CAMERA_DATA_ERROR           (VCA_ERROR_INDEX + 5)   // 
#define NET_DVR_CALIBRATE_DATA_UNFIT        (VCA_ERROR_INDEX + 6)    // Ȳбڱ궨
#define NET_DVR_CALIBRATE_DATA_CONFLICT     (VCA_ERROR_INDEX + 7)    // 궨Ϊе㹲߻λ̫
#define NET_DVR_CALIBRATE_CALC_FAIL         (VCA_ERROR_INDEX + 8)    // 궨ֵʧ
#define    NET_DVR_CALIBRATE_LINE_OUT_RECT        (VCA_ERROR_INDEX + 9)    // 궨߳Ӿο
#define NET_DVR_ENTER_RULE_NOT_READY        (VCA_ERROR_INDEX + 10)    // ûý
#define NET_DVR_AID_RULE_NO_INCLUDE_LANE    (VCA_ERROR_INDEX + 11)    // ͨ¼ûаֵӵºУ
#define NET_DVR_LANE_NOT_READY                (VCA_ERROR_INDEX + 12)    // ǰûó
#define NET_DVR_RULE_INCLUDE_TWO_WAY        (VCA_ERROR_INDEX + 13)    // ¼а2ֲͬ
#define NET_DVR_LANE_TPS_RULE_CONFLICT      (VCA_ERROR_INDEX + 14)  // ݹͻ
#define NET_DVR_NOT_SUPPORT_EVENT_TYPE      (VCA_ERROR_INDEX + 15)  // ֵ֧¼
#define NET_DVR_LANE_NO_WAY                 (VCA_ERROR_INDEX + 16)  // ûз
#define NET_DVR_SIZE_FILTER_ERROR           (VCA_ERROR_INDEX + 17)  // ߴ˿򲻺
#define NET_DVR_LIB_FFL_NO_FACE             (VCA_ERROR_INDEX + 18) // 㶨λʱͼû
#define NET_DVR_LIB_FFL_IMG_TOO_SMALL       (VCA_ERROR_INDEX + 19) // 㶨λʱͼ̫С
#define NET_DVR_LIB_FD_IMG_NO_FACE          (VCA_ERROR_INDEX + 20) // ͼʱͼû
#define NET_DVR_LIB_FACE_TOO_SMALL          (VCA_ERROR_INDEX + 21) // ģʱ̫С
#define NET_DVR_LIB_FACE_QUALITY_TOO_BAD    (VCA_ERROR_INDEX + 22) // ģʱͼ̫
#define NET_DVR_KEY_PARAM_ERR               (VCA_ERROR_INDEX + 23) //߼ô
#define NET_DVR_CALIBRATE_DATA_ERR          (VCA_ERROR_INDEX + 24) //궨Ŀ󣬻ֵ󣬻㳬ƽ
#define NET_DVR_CALIBRATE_DISABLE_FAIL      (VCA_ERROR_INDEX + 25) //ùȡ궨
#define NET_DVR_VCA_LIB_FD_SCALE_OUTRANGE   (VCA_ERROR_INDEX + 26) //˿ĿСֵС˿Ŀֵ
#define NET_DVR_LIB_FD_REGION_TOO_LARGE     (VCA_ERROR_INDEX + 27) //ǰΧ󡣼Ϊͼ2/3
#define NET_DVR_TRIAL_OVERDUE               (VCA_ERROR_INDEX + 28) //ðѽ
#define NET_DVR_CONFIG_FILE_CONFLICT        (VCA_ERROR_INDEX + 29) //豸ļͻܹзòʾ
//㷨ش
#define NET_DVR_FR_FPL_FAIL                 (VCA_ERROR_INDEX + 30)   // 㶨λʧ
#define NET_DVR_FR_IQA_FAIL                 (VCA_ERROR_INDEX + 31)   // ʧ
#define NET_DVR_FR_FEM_FAIL                 (VCA_ERROR_INDEX + 32)   // ȡʧ
#define NET_DVR_FPL_DT_CONF_TOO_LOW         (VCA_ERROR_INDEX + 33)   // 㶨λʱŶȹ
#define NET_DVR_FPL_CONF_TOO_LOW            (VCA_ERROR_INDEX + 34)   // 㶨λŶȹ
#define NET_DVR_E_DATA_SIZE                 (VCA_ERROR_INDEX + 35)  // ݳȲƥ
#define NET_DVR_FR_MODEL_VERSION_ERR        (VCA_ERROR_INDEX + 36)  // ģеģͰ汾
#define NET_DVR_FR_FD_FAIL                  (VCA_ERROR_INDEX + 37)  // ʶʧ
#define NET_DVR_FA_NORMALIZE_ERR            (VCA_ERROR_INDEX + 38)  // һ
//
#define NET_DVR_DOG_PUSTREAM_NOT_MATCH      (VCA_ERROR_INDEX + 39)  // ܹǰȡ豸Ͳƥ
#define NET_DVR_DEV_PUSTREAM_NOT_MATCH      (VCA_ERROR_INDEX + 40)  // ǰȡ豸汾ƥ
#define NET_DVR_PUSTREAM_ALREADY_EXISTS     (VCA_ERROR_INDEX + 41)  // 豸ͨѾӹǰ豸
#define NET_DVR_SEARCH_CONNECT_FAILED       (VCA_ERROR_INDEX + 42)  // Ӽʧ
#define NET_DVR_INSUFFICIENT_DISK_SPACE     (VCA_ERROR_INDEX + 43)  // ɴ洢Ӳ̿ռ䲻
#define NET_DVR_DATABASE_CONNECTION_FAILED  (VCA_ERROR_INDEX + 44)  // ݿʧ
#define NET_DVR_DATABASE_ADM_PW_ERROR       (VCA_ERROR_INDEX + 45)  // ݿû
#define NET_DVR_DECODE_YUV                  (VCA_ERROR_INDEX + 46)  // ʧ
#define NET_DVR_IMAGE_RESOLUTION_ERROR      (VCA_ERROR_INDEX + 47)  //
#define NET_DVR_CHAN_WORKMODE_ERROR         (VCA_ERROR_INDEX + 48)  //

#define NET_DVR_RTSP_ERROR_NOENOUGHPRI          401  //Ȩޣ401ʱת
#define NET_DVR_RTSP_ERROR_ALLOC_RESOURCE       402  //Դʧ
#define NET_DVR_RTSP_ERROR_PARAMETER            403  //
#define NET_DVR_RTSP_ERROR_NO_URL               404  //ָURLַڣ404ʱת
#define NET_DVR_RTSP_ERROR_FORCE_STOP           406  //û;ǿ˳

#define NET_DVR_RTSP_GETPORTFAILED                407  //rtsp õ˿ڴ
#define NET_DVR_RTSP_DESCRIBERROR                410  //rtsp decribe 
#define NET_DVR_RTSP_DESCRIBESENDTIMEOUT        411  //rtsp decribe ͳʱ
#define NET_DVR_RTSP_DESCRIBESENDERROR            412  //rtsp decribe ʧ
#define NET_DVR_RTSP_DESCRIBERECVTIMEOUT        413  //rtsp decribe ճʱ
#define NET_DVR_RTSP_DESCRIBERECVDATALOST        414  //rtsp decribe ݴ
#define NET_DVR_RTSP_DESCRIBERECVERROR            415  //rtsp decribe ʧ
#define NET_DVR_RTSP_DESCRIBESERVERERR            416  //rtsp decribe ش״̬

#define NET_DVR_RTSP_SETUPERROR                    420  //rtsp setup 
#define NET_DVR_RTSP_SETUPSENDTIMEOUT            421  //rtsp setup ͳʱ
#define NET_DVR_RTSP_SETUPSENDERROR                422  //rtsp setup ʹ
#define NET_DVR_RTSP_SETUPRECVTIMEOUT            423  //rtsp setup ճʱ
#define NET_DVR_RTSP_SETUPRECVDATALOST            424  //rtsp setup ݴ
#define NET_DVR_RTSP_SETUPRECVERROR                425  //rtsp setup ʧ
#define NET_DVR_RTSP_OVER_MAX_CHAN                426  //߷Դ㣬453ʱת롣
#define NET_DVR_RTSP_SETUPSERVERERR                427  //rtsp setup ش״̬

#define NET_DVR_RTSP_PLAYERROR                    430  //rtsp play 
#define NET_DVR_RTSP_PLAYSENDTIMEOUT            431  //rtsp play ͳʱ
#define NET_DVR_RTSP_PLAYSENDERROR                432  //rtsp play ʹ
#define NET_DVR_RTSP_PLAYRECVTIMEOUT            433  //rtsp play ճʱ
#define NET_DVR_RTSP_PLAYRECVDATALOST            434  //rtsp play ݴ
#define NET_DVR_RTSP_PLAYRECVERROR                435  //rtsp play ʧ
#define NET_DVR_RTSP_PLAYSERVERERR                436  //rtsp play ش״̬

#define NET_DVR_RTSP_TEARDOWNERROR                440  //rtsp teardown 
#define NET_DVR_RTSP_TEARDOWNSENDTIMEOUT        441  //rtsp teardown ͳʱ
#define NET_DVR_RTSP_TEARDOWNSENDERROR            442  //rtsp teardown ʹ
#define NET_DVR_RTSP_TEARDOWNRECVTIMEOUT        443  //rtsp teardown ճʱ
#define NET_DVR_RTSP_TEARDOWNRECVDATALOST        444  //rtsp teardown ݴ
#define NET_DVR_RTSP_TEARDOWNRECVERROR            445  //rtsp teardown ʧ
#define NET_DVR_RTSP_TEARDOWNSERVERERR            446  //rtsp teardown ش״̬

#define  NET_PLAYM4_NOERROR                        500    //no error
#define     NET_PLAYM4_PARA_OVER                    501    //input parameter is invalid;
#define  NET_PLAYM4_ORDER_ERROR                    502    //The order of the function to be called is error.
#define     NET_PLAYM4_TIMER_ERROR                    503    //Create multimedia clock failed;
#define  NET_PLAYM4_DEC_VIDEO_ERROR                504    //Decode video data failed.
#define  NET_PLAYM4_DEC_AUDIO_ERROR                505    //Decode audio data failed.
#define     NET_PLAYM4_ALLOC_MEMORY_ERROR            506    //Allocate memory failed.
#define  NET_PLAYM4_OPEN_FILE_ERROR                507    //Open the file failed.
#define  NET_PLAYM4_CREATE_OBJ_ERROR            508    //Create thread or event failed
#define  NET_PLAYM4_CREATE_DDRAW_ERROR            509    //Create DirectDraw object failed.
#define  NET_PLAYM4_CREATE_OFFSCREEN_ERROR      510    //failed when creating off-screen surface.
#define  NET_PLAYM4_BUF_OVER                    511    //buffer is overflow
#define  NET_PLAYM4_CREATE_SOUND_ERROR            512    //failed when creating audio device.    
#define     NET_PLAYM4_SET_VOLUME_ERROR            513    //Set volume failed
#define  NET_PLAYM4_SUPPORT_FILE_ONLY            514    //The function only support play file.
#define  NET_PLAYM4_SUPPORT_STREAM_ONLY            515    //The function only support play stream.
#define  NET_PLAYM4_SYS_NOT_SUPPORT                516    //System not support.
#define  NET_PLAYM4_FILEHEADER_UNKNOWN          517    //No file header.
#define  NET_PLAYM4_VERSION_INCORRECT            518    //The version of decoder and encoder is not adapted.  
#define  NET_PALYM4_INIT_DECODER_ERROR          519    //Initialize decoder failed.
#define  NET_PLAYM4_CHECK_FILE_ERROR            520    //The file data is unknown.
#define  NET_PLAYM4_INIT_TIMER_ERROR            521    //Initialize multimedia clock failed.
#define     NET_PLAYM4_BLT_ERROR                    522    //Blt failed.
#define  NET_PLAYM4_UPDATE_ERROR                523    //Update failed.
#define  NET_PLAYM4_OPEN_FILE_ERROR_MULTI       524   //openfile error, streamtype is multi
#define  NET_PLAYM4_OPEN_FILE_ERROR_VIDEO       525   //openfile error, streamtype is video
#define  NET_PLAYM4_JPEG_COMPRESS_ERROR         526   //JPEG compress error
#define  NET_PLAYM4_EXTRACT_NOT_SUPPORT         527    //Don't support the version of this file.
#define  NET_PLAYM4_EXTRACT_DATA_ERROR          528    //extract video data failed.

//תװ
#define  NET_CONVERT_ERROR_NOT_SUPPORT          581  //convert not support

//Խ
#define  NET_AUDIOINTERCOM_OK                   600  //޴
#define  NET_AUDIOINTECOM_ERR_NOTSUPORT         601 //֧
#define  NET_AUDIOINTECOM_ERR_ALLOC_MEMERY      602 //ڴ
#define  NET_AUDIOINTECOM_ERR_PARAMETER            603 //
#define  NET_AUDIOINTECOM_ERR_CALL_ORDER        604 //ô
#define  NET_AUDIOINTECOM_ERR_FIND_DEVICE       605 //δ豸
#define  NET_AUDIOINTECOM_ERR_OPEN_DEVICE       606 //ܴ豸
#define  NET_AUDIOINTECOM_ERR_NO_CONTEXT        607 //豸ĳ
#define  NET_AUDIOINTECOM_ERR_NO_WAVFILE        608 //WAVļ
#define  NET_AUDIOINTECOM_ERR_INVALID_TYPE      609 //ЧWAV
#define  NET_AUDIOINTECOM_ERR_ENCODE_FAIL       610 //ʧ
#define  NET_AUDIOINTECOM_ERR_DECODE_FAIL       611 //ʧ
#define  NET_AUDIOINTECOM_ERR_NO_PLAYBACK       612 //ʧ
#define  NET_AUDIOINTECOM_ERR_DENOISE_FAIL      613 //ʧ
#define  NET_AUDIOINTECOM_ERR_UNKOWN            619 //δ֪

#define NET_QOS_OK                                 700                    //no error
#define NET_QOS_ERROR                             (NET_QOS_OK - 1)        //qos error
#define NET_QOS_ERR_INVALID_ARGUMENTS             (NET_QOS_OK - 2)        //invalid arguments 
#define NET_QOS_ERR_SESSION_NOT_FOUND             (NET_QOS_OK - 3)        //session net found
#define NET_QOS_ERR_LIB_NOT_INITIALIZED          (NET_QOS_OK - 4)        //lib not initialized
#define NET_QOS_ERR_OUTOFMEM                     (NET_QOS_OK - 5)        //outtofmem
#define NET_QOS_ERR_PACKET_UNKNOW                (NET_QOS_OK - 10)        //packet unknow
#define NET_QOS_ERR_PACKET_VERSION               (NET_QOS_OK - 11)        //packet version error
#define NET_QOS_ERR_PACKET_LENGTH                (NET_QOS_OK - 12)        //packet length error
#define NET_QOS_ERR_PACKET_TOO_BIG               (NET_QOS_OK - 13)        //packet too big
#define NET_QOS_ERR_SCHEDPARAMS_INVALID_BANDWIDTH (NET_QOS_OK - 20)        //schedparams invalid bandwidth
#define NET_QOS_ERR_SCHEDPARAMS_BAD_FRACTION      (NET_QOS_OK - 21)        //schedparams bad fraction
#define NET_QOS_ERR_SCHEDPARAMS_BAD_MINIMUM_INTERVAL (NET_QOS_OK - 22)    //schedparams bad minimum interval

#define NET_ERROR_TRUNK_LINE                        711 //ϵͳѱɸ
#define NET_ERROR_MIXED_JOINT                        712 //ܽлƴ
#define NET_ERROR_DISPLAY_SWITCH                    713 //ܽʾͨл
#define NET_ERROR_USED_BY_BIG_SCREEN                714 //Դռ
#define NET_ERROR_USE_OTHER_DEC_RESOURCE            715 //ʹϵͳԴ
#define NET_ERROR_DISP_MODE_SWITCH                  716 //ʾͨʾ״̬л
#define NET_ERROR_SCENE_USING                        717    //ʹ
#define NET_ERR_NO_ENOUGH_DEC_RESOURCE              718 //Դ
#define NET_ERR_NO_ENOUGH_FREE_SHOW_RESOURCE        719 //Դ
#define NET_ERR_NO_ENOUGH_VIDEO_MEMORY              720 //ԴԴ
#define NET_ERR_MAX_VIDEO_NUM                       721 //һ϶Դ
#define NET_ERR_WIN_COVER_FREE_SHOW_AND_NORMAL      722 //ڿԽ˳ںͷǳ
#define NET_ERR_FREE_SHOW_WIN_SPLIT                 723 //Դڲַ֧
#define NET_ERR_INAPPROPRIATE_WIN_FREE_SHOW         724 //Ĵڲֿ֧
#define NET_DVR_TRANSPARENT_WIN_NOT_SUPPORT_SPLIT   725 //͸ȵĴڲַ֧
#define NET_DVR_SPLIT_WIN_NOT_SUPPORT_TRANSPARENT   726 //Ĵڲ֧͸
#define NET_ERR_MAX_LOGO_NUM                        727 //logoﵽ
#define NET_ERR_MAX_WIN_LOOP_NUM                    728 //Ѳﵽ
#define NET_ERR_VIRTUAL_LED_VERTICAL_CROSS          729 //LED
#define NET_ERR_MAX_VIRTUAL_LED_HEIGHT              730 //LED߶ȳ
#define NET_ERR_VIRTUAL_LED_ILLEGAL_CHARACTER       731 //LEDݰǷַ
#define NET_ERR_BASEMAP_NOT_EXIST                   732 //ͼͼƬ
#define NET_ERR_LED_NOT_SUPPORT_VIRTUAL_LED         733 //LEDĻ֧LED
#define NET_ERR_LED_RESOLUTION_NOT_SUPPORT          734 //LEDֱʲ֧
#define NET_ERR_PLAN_OVERDUE                        735    //Ԥڣٵ
#define NET_ERR_PROCESSER_MAX_SCREEN_BLK            736 //źſԽĻ

#define NET_ERR_TERMINAL_BUSY                        780    //նæն˴ڻ

#define NET_ERR_DATA_RETURNED_ILLEGAL               790 //豸صݲϷ
#define NET_DVR_FUNCTION_RESOURCE_USAGE_ERROR       791 //豸ռԴ¸ù޷


#define NET_DVR_DEV_NET_OVERFLOW                    800    //豸
#define NET_DVR_STATUS_RECORDFILE_WRITING_NOT_LOCK  801 //¼ļ¼޷ 
#define NET_DVR_STATUS_CANT_FORMAT_LITTLE_DISK      802 //Ӳ̫С޷ʽ

//N+1
#define NET_SDK_ERR_REMOTE_DISCONNECT                803 //Զ޷
#define NET_SDK_ERR_RD_ADD_RD                        804 //ӱ
#define NET_SDK_ERR_BACKUP_DISK_EXCEPT                805 //쳣
#define NET_SDK_ERR_RD_LIMIT                        806 //Ѵ
#define NET_SDK_ERR_ADDED_RD_IS_WD                    807 //ӵıǹ
#define NET_SDK_ERR_ADD_ORDER_WRONG                    808 //˳ûбΪӹ
#define NET_SDK_ERR_WD_ADD_WD                        809 //ӹ
#define NET_SDK_ERR_WD_SERVICE_EXCETP                810 //CVR쳣
#define NET_SDK_ERR_RD_SERVICE_EXCETP                811 //CVR쳣
#define NET_SDK_ERR_ADDED_WD_IS_RD                    812 //ӵĹǱ
#define NET_SDK_ERR_PERFORMANCE_LIMIT                813 //ܴﵽ
#define NET_SDK_ERR_ADDED_DEVICE_EXIST                814 //ӵ豸Ѿ

//Ѷ
#define NET_SDK_ERR_INQUEST_RESUMING                815 //Ѷָ
#define NET_SDK_ERR_RECORD_BACKUPING                816 //Ѷ
#define NET_SDK_ERR_DISK_PLAYING                    817 //̻ط
#define NET_SDK_ERR_INQUEST_STARTED                    818 //Ѷѿ
#define NET_SDK_ERR_LOCAL_OPERATING                    819 //ز
#define NET_SDK_ERR_INQUEST_NOT_START                820 //Ѷδ
//Netra3.1.0                
#define NET_SDK_ERR_CHAN_AUDIO_BIND                 821  //ͨδ󶨻Խʧ
//ƴ洢
#define NET_DVR_N_PLUS_ONE_MODE                     822 //豸ǰN+1ģʽ
#define NET_DVR_CLOUD_STORAGE_OPENED                823 //ƴ洢ģʽѿ

#define NET_DVR_ERR_OPER_NOT_ALLOWED                824   //豸N+0ӹ״̬ò
#define NET_DVR_ERR_NEED_RELOCATE                    825   //豸N+0ӹ״̬ҪȡضϢ²

//ͥ
#define NET_SDK_ERR_IR_PORT_ERROR                   830 //ڴ
#define NET_SDK_ERR_IR_CMD_ERROR                    831 //ڵŴ
#define NET_SDK_ERR_NOT_INQUESTING                  832 //豸ڷѶ״̬
#define NET_SDK_ERR_INQUEST_NOT_PAUSED              833 //豸ڷͣ״̬
//2011-10-25루900-950
#define  NET_ERR_CUT_INPUTSTREAM_OVERLIMIT           900 //źԴüֵ
#define  NET_ERR_WINCHAN_IDX                        901    // ͨŴ
#define  NET_ERR_WIN_LAYER                            902    // ڲ󣬵ĻาǵĴڲ
#define  NET_ERR_WIN_BLK_NUM                        903    // ڵĿ󣬵ڿɸǵĻ
#define  NET_ERR_OUTPUT_RESOLUTION                    904    // ֱʴ
#define  NET_ERR_LAYOUT                                905    // ֺŴ
#define  NET_ERR_INPUT_RESOLUTION                    906 // ֱʲ֧
#define  NET_ERR_SUBDEVICE_OFFLINE                  907 // 豸
#define  NET_ERR_NO_DECODE_CHAN                     908 // ûпнͨ
#define  NET_ERR_MAX_WINDOW_ABILITY                 909 // , ֲʽн豸޻ʾ޵
#define  NET_ERR_ORDER_ERROR                        910 // ˳
#define  NET_ERR_PLAYING_PLAN                        911 // ִԤ
#define  NET_ERR_DECODER_USED                        912 // ʹ
#define     NET_ERR_OUTPUT_BOARD_DATA_OVERFLOW            913    // 
#define     NET_ERR_SAME_USER_NAME                        914    // ûͬ
#define     NET_ERR_INVALID_USER_NAME                    915    // Чû
#define     NET_ERR_MATRIX_USING                        916    // ʹ
#define     NET_ERR_DIFFERENT_CHAN_TYPE                917    // ͨͲͬͨͿΪͬͣ
#define     NET_ERR_INPUT_CHAN_BINDED                    918    // ͨѾ
#define     NET_ERR_BINDED_OUTPUT_CHAN_OVERFLOW        919    // ʹõľͨ󶨵ͨ
#define     NET_ERR_MAX_SIGNAL_NUM                        920    // źԴﵽ
#define  NET_ERR_INPUT_CHAN_USING                    921    // ͨʹ
#define  NET_ERR_MANAGER_LOGON                         922    // ԱѾ½ʧ
#define  NET_ERR_USERALREADY_LOGON                     923    // ûѾ½ʧ
#define  NET_ERR_LAYOUT_INIT                         924    // ڳʼʧ
#define     NET_ERR_BASEMAP_SIZE_NOT_MATCH                925    // ͼС 
#define  NET_ERR_WINDOW_OPERATING                    926    // ִβʧ
#define  NET_ERR_SIGNAL_UPLIMIT                        927 // źԴﵽ
#define  NET_ERR_SIGNAL_MAX_ENLARGE_TIMES           928 // źԴŴ 
#define  NET_ERR_ONE_SIGNAL_MULTI_CROSS             929 // źԴܶο
#define  NET_ERR_ULTRA_HD_SIGNAL_MULTI_WIN          930 // źԴظ 
#define  NET_ERR_MAX_VIRTUAL_LED_WIDTH              931 //LEDȴֵ
#define  NET_ERR_MAX_VIRTUAL_LED_WORD_LEN           932 //LEDֵַ
#define     NET_ERR_SINGLE_OUTPUTPARAM_CONFIG            933//ֵ֧ʾ
#define  NET_ERR_MULTI_WIN_BE_COVER                 934//ڱ
#define  NET_ERR_WIN_NOT_EXIST                        935 //ڲ
#define  NET_ERR_WIN_MAX_SIGNALSOURCE                936//źԴֵ
#define  NET_ERR_MULTI_WIN_MOVE                        937//Զƶ
#define  NET_ERR_MULTI_WIN_YPBPR_SDI                938 // YPBPR SDIźԴ֧9/16      
#define  NET_ERR_DIFF_TYPE_OUTPUT_MIXUSE            939  //ͬ
#define  NET_ERR_SPLIT_WIN_CROSS                    940//Կڷ
#define  NET_ERR_SPLIT_WIN_NOT_FULL_SCREEN            941  //δڷ
#define  NET_ERR_SPLIT_WIN_MANY_WIN                    942  //ԵжڵĴڷ
#define  NET_ERR_WINDOW_SIZE_OVERLIMIT              943   //ڴС
#define  NET_ERR_INPUTSTREAM_ALREADY_JOINT           944    //źԴѼƴ 
#define  NET_ERR_JOINT_INPUTSTREAM_OVERLIMIT          945    //ƴźԴ      

#define  NET_ERR_LED_RESOLUTION                        946  //LED ֱʴֱ
#define  NET_ERR_JOINT_SCALE_OVERLIMIT              947  //ƴźԴĹģ
#define  NET_ERR_INPUTSTREAM_ALREADY_DECODE            948  //źԴǽ
#define  NET_ERR_INPUTSTREAM_NOTSUPPORT_CAPTURE     949  //źԴ֧ץͼ
#define  NET_ERR_JOINT_NOTSUPPORT_SPLITWIN            950  //ƴźԴַ֧

//루951-999
#define NET_ERR_MAX_WIN_OVERLAP                        951 //ﵽ󴰿ص
#define NET_ERR_STREAMID_CHAN_BOTH_VALID            952 //stream IDͨͬʱЧ
#define NET_ERR_NO_ZERO_CHAN                        953 //豸ͨ
#define NEED_RECONNECT                                955 //Ҫضתϵͳʹã
#define NET_ERR_NO_STREAM_ID                        956 //ID
#define NET_DVR_TRANS_NOT_START                        957 //תδ
#define NET_ERR_MAXNUM_STREAM_ID                    958 //IDﵽ
#define NET_ERR_WORKMODE_MISMATCH                    959 //ģʽƥ
#define NET_ERR_MODE_IS_USING                        960 //ѹڵǰģʽ
#define NET_ERR_DEV_PROGRESSING                        961 //豸ڴ
#define NET_ERR_PASSIVE_TRANSCODING                    962 //ڱת

#define NET_ERR_RING_NOT_CONFIGURE                   964 //δ

#define NET_ERR_CLOSE_WINDOW_FIRST                    971  //лȫ֡ʳʱȹرնӦǽĴ
#define NET_ERR_SPLIT_WINDOW_NUM_NOT_SUPPORT        972  //DVI/DP/HDMI/HDBase_TԴȫ֡ʳ²֧9/16
#define NET_ERR_REACH_ONE_SIGNAL_PREVIEW_MAX_LINK   973  //źԴ
#define NET_ERR_ONLY_SPLITWND_SUPPORT_AMPLIFICATION  974  //ֻз֧ӴڷŴ
#define NET_DVR_ERR_WINDOW_SIZE_PLACE  975  //λô
#define NET_DVR_ERR_RGIONAL_RESTRICTIONS  976  //Ļ볬
#define NET_ERR_WNDZOOM_NOT_SUPPORT  977  //ڲ֧Ӵȫ
#define NET_ERR_LED_SCREEN_SIZE  978  //LED߲ȷ
#define NET_ERR_OPEN_WIN_IN_ERROR_AREA  979  //ڷǷ򿪴(LCD/LED)
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_MOVE  980  //ƽģʽ֧
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_COVER  981  //ƽģʽ֧ͼ㸲
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_SPLIT  982  //ƽģʽַ֧
#define NET_DVR_LED_WINDOWS_ALREADY_CLOSED  983  //LEDڵķֱʷ仯豸ѹرոڵLED
//
#define XML_ABILITY_NOTSUPPORT                      1000  //֧ڵȡ
#define    XML_ANALYZE_NOENOUGH_BUF                    1001        //ڴ治
#define    XML_ANALYZE_FIND_LOCALXML_ERROR                1002        //޷ҵӦıxml
#define    XML_ANALYZE_LOAD_LOCALXML_ERROR                1003        //رxml
#define    XML_NANLYZE_DVR_DATA_FORMAT_ERROR            1004        //豸ݸʽ
#define    XML_ANALYZE_TYPE_ERROR                        1005        //ʹ
#define    XML_ANALYZE_XML_NODE_ERROR                    1006        //XMLڵʽ
#define XML_INPUT_PARAM_ERROR                       1007  //XMLڵֵ

//ô루11001200
#define NET_ERR_PLT_USERID                          1100 //֤ƽ̨userid
#define NET_ERR_TRANS_CHAN_START                    1101 //͸ͨѴ򿪣ǰ޷
#define NET_ERR_DEV_UPGRADING                        1102 //豸
#define NET_ERR_MISMATCH_UPGRADE_PACK_TYPE          1103 //Ͳƥ
#define NET_ERR_DEV_FORMATTING                      1104 //豸ڸʽ
#define NET_ERR_MISMATCH_UPGRADE_PACK_VERSION       1105 //汾ƥ

//2012-10-16 豸루1200~1300
#define NET_ERR_SEARCHING_MODULE                    1201 // ģ
#define NET_ERR_REGISTERING_MODULE                  1202 // עģ
#define NET_ERR_GETTING_ZONES                        1203 // ڻȡ
#define NET_ERR_GETTING_TRIGGERS                    1204 // ڻȡ
#define NET_ERR_ARMED_STATUS                        1205 // ϵͳڲ״̬
#define    NET_ERR_PROGRAM_MODE_STATUS                    1206 // ϵͳڱģʽ
#define    NET_ERR_WALK_TEST_MODE_STATUS                1207 // ϵͳڲģʽ
#define    NET_ERR_BYPASS_STATUS                        1208 // ·״̬
#define NET_ERR_DISABLED_MODULE_STATUS                1209 // δʹ
#define    NET_ERR_NOT_SUPPORT_OPERATE_ZONE            1210 // ָ֧ò
#define NET_ERR_NOT_SUPPORT_MOD_MODULE_ADDR            1211 // ģַܱ޸
#define NET_ERR_UNREGISTERED_MODULE                    1212 // ģδע
#define NET_ERR_PUBLIC_SUBSYSTEM_ASSOCIATE_SELF        1213 // ϵͳ
#define NET_ERR_EXCEEDS_ASSOCIATE_SUBSYSTEM_NUM        1214 // ϵͳ
#define NET_ERR_BE_ASSOCIATED_BY_PUBLIC_SUBSYSTEM    1215 // ϵͳϵͳ
#define    NET_ERR_ZONE_FAULT_STATUS                    1216 // ڹ״̬
#define NET_ERR_SAME_EVENT_TYPE                    1217 // ¼¼رͬ¼    
#define NET_ERR_ZONE_ALARM_STATUS                    1218 // ڱ״̬
#define NET_ERR_EXPANSION_BUS_SHORT_CIRCUIT            1219 //չ߶·
#define NET_ERR_PWD_CONFLICT                        1220  //ͻ


//Ϣ
#define NET_ERR_GET_ALL_RETURN_OVER                    1300  //ȡзĿ
#define NET_ERR_RESOURCE_USING                      1301  //ϢԴʹã޸
#define NET_ERR_FILE_SIZE_OVERLIMIT                    1302  //ļС

//Ϣ
#define NET_ERR_MATERIAL_NAME                       1303  //زƷǷ
#define NET_ERR_MATERIAL_NAME_LEN                   1304  //زƳȷǷ
#define NET_ERR_MATERIAL_REMARK                     1305  //زǷ
#define NET_ERR_MATERIAL_REMARK_LEN                 1306  //زȷǷ
#define NET_ERR_MATERIAL_SHARE_PROPERTY             1307  //زĹԷǷ
#define NET_ERR_UNSUPPORT_MATERIAL_TYPE             1308  //زͲ֧
#define NET_ERR_MATERIAL_NOT_EXIST                  1309  //زĲ
#define NET_ERR_READ_FROM_DISK                      1310  //Ӳ̶ȡزļʧ
#define NET_ERR_WRITE_TO_DISK                       1311  //Ӳдزļʧ
#define NET_ERR_WRITE_DATA_BASE                     1312  //زдݿʧ

//
#define    NET_ERR_MAX_SCREEN_CTRL_NUM                    1351    //Ļﵽ
#define    NET_ERR_FILE_NOT_EXIST                        1352    //ļ
#define NET_ERR_THUMBNAIL_NOT_EXIST                    1353    //ͼ
#define NET_ERR_DEV_OPEN_FILE_FAIL                    1354    //豸˴ļʧ
#define NET_ERR_SERVER_READ_FILE_FAIL                1355    //豸˶ȡļʧ
#define NET_ERR_FILE_SIZE                            1356    //ļС
#define    NET_ERR_FILE_NAME                            1357    //ļƴΪջ򲻺Ϸ

//2012-12-20ץĻ루1400-1499
#define NET_DVR_ERR_LANENUM_EXCEED                  1400  //
#define NET_DVR_ERR_PRAREA_EXCEED                   1401  //ʶ
#define NET_DVR_ERR_LIGHT_PARAM                     1402  //źŵƽ
#define NET_DVR_ERR_LANE_LINE_INVALID               1403  //ô
#define NET_DVR_ERR_STOP_LINE_INVALID               1404  //ֹͣô
#define NET_DVR_ERR_LEFTORRIGHT_LINE_INVALID        1405  ///תֽô
#define NET_DVR_ERR_LANE_NO_REPEAT                  1406  //ӳظ
#define NET_DVR_ERR_PRAREA_INVALID                  1407  //ʶβҪ
#define NET_DVR_ERR_LIGHT_NUM_EXCEED                1408  //Ƶ⽻ͨźŵĿֵ
#define NET_DVR_ERR_SUBLIGHT_NUM_INVALID            1409  //Ƶ⽻ͨźŵӵĿϷ
#define NET_DVR_ERR_LIGHT_AREASIZE_INVALID          1410  //Ƶ⽻ͨźŵƿСϷ
#define NET_DVR_ERR_LIGHT_COLOR_INVALID             1411  //Ƶ⽻ͨźŵɫϷ
#define NET_DVR_ERR_LIGHT_DIRECTION_INVALID         1412  //Ƶ⽻ͨƷԲϷ
#define NET_DVR_ERR_LACK_IOABLITY                    1413  //IOʵֵ֧

#define NET_DVR_ERR_FTP_PORT                        1414  //FTP˿ںŷǷ˿ںظ쳣
#define NET_DVR_ERR_FTP_CATALOGUE                   1415  //FTPĿ¼Ƿö༶Ŀ¼༶Ŀ¼ֵΪգ
#define NET_DVR_ERR_FTP_UPLOAD_TYPE                 1416  //FTPϴͷǷftpֻ֧ȫ/˫ftpֻֿ֧ںΥ£
#define NET_DVR_ERR_FLASH_PARAM_WRITE               1417  //òʱдFLASHʧ
#define NET_DVR_ERR_FLASH_PARAM_READ                1418  //òʱFLASHʧ
#define NET_DVR_ERR_PICNAME_DELIMITER               1419  //FTPͼƬָǷ
#define NET_DVR_ERR_PICNAME_ITEM                    1420  //FTPͼƬǷ ָ
#define NET_DVR_ERR_PLATE_RECOGNIZE_TYPE            1421  //ʶͷǷ κͶЧУ飩
#define NET_DVR_ERR_CAPTURE_TIMES                   1422  //ץĴǷ Чֵ05
#define NET_DVR_ERR_LOOP_DISTANCE                   1423  //ȦǷ Чֵ02000ms
#define NET_DVR_ERR_LOOP_INPUT_STATUS               1424  //Ȧ״̬Ƿ Чֵ
#define NET_DVR_ERR_RELATE_IO_CONFLICT              1425  //IOͻ
#define NET_DVR_ERR_INTERVAL_TIME                   1426  //ļʱǷ 06000ms
#define NET_DVR_ERR_SIGN_SPEED                      1427  //־ֵǷ󳵱־ٲܴС־ 
#define NET_DVR_ERR_PIC_FLIP                        1428  //ͼ÷ת ýӰ죩
#define NET_DVR_ERR_RELATE_LANE_NUMBER              1429  // (ظ ЧֵУ199)
#define NET_DVR_ERR_TRIGGER_MODE                    1430  //ץĻģʽǷ
#define NET_DVR_ERR_DELAY_TIME                      1431  //ʱʱ(2000ms)
#define NET_DVR_ERR_EXCEED_RS485_COUNT              1432  //485
#define NET_DVR_ERR_RADAR_TYPE                      1433  //״ʹ
#define NET_DVR_ERR_RADAR_ANGLE                     1434  //״Ƕȴ
#define NET_DVR_ERR_RADAR_SPEED_VALID_TIME          1435  //״Чʱ
#define NET_DVR_ERR_RADAR_LINE_CORRECT              1436  //״Խ
#define NET_DVR_ERR_RADAR_CONST_CORRECT             1437  //״ﳣ
#define NET_DVR_ERR_RECORD_PARAM                    1438  //¼ЧԤ¼ʱ䲻10s
#define NET_DVR_ERR_LIGHT_WITHOUT_COLOR_AND_DIRECTION 1439   //ƵźŵźŵƸûйѡźŵƷɫ
#define NET_DVR_ERR_LIGHT_WITHOUT_DETECTION_REGION   1440   //ƵźŵźŵƸûл
#define NET_DVR_ERR_RECOGNIZE_PROVINCE_PARAM         1441   //ʶʡݲĺϷ

#define NET_DVR_ERR_SPEED_TIMEOUT                 1442    //IOٳʱʱǷЧֵ0
#define NET_DVR_ERR_NTP_TIMEZONE                  1443    //ntpʱ
#define NET_DVR_ERR_NTP_INTERVAL_TIME             1444    //ntpУʱ
#define NET_DVR_ERR_NETWORK_CARD_NUM              1445    //Ŀ
#define NET_DVR_ERR_DEFAULT_ROUTE                 1446    //Ĭ·ɴ
#define NET_DVR_ERR_BONDING_WORK_MODE             1447    //bondingģʽ
#define NET_DVR_ERR_SLAVE_CARD                    1448    //slave
#define NET_DVR_ERR_PRIMARY_CARD                  1449    //Primary
#define NET_DVR_ERR_DHCP_PPOE_WORK                1450    //dhcppppoEͬʱ
#define NET_DVR_ERR_NET_INTERFACE                 1451    //ӿڴ
#define NET_DVR_ERR_MTU                           1452    //MTU
#define NET_DVR_ERR_NETMASK                       1453    //
#define NET_DVR_ERR_IP_INVALID                    1454    //IPַϷ
#define NET_DVR_ERR_MULTICAST_IP_INVALID          1455    //ಥַϷ
#define NET_DVR_ERR_GATEWAY_INVALID               1456    //زϷ
#define NET_DVR_ERR_DNS_INVALID                   1457    //DNSϷ
#define NET_DVR_ERR_ALARMHOST_IP_INVALID          1458    //澯ַϷ
#define NET_DVR_ERR_IP_CONFLICT                   1459    //IPͻ
#define NET_DVR_ERR_NETWORK_SEGMENT               1460    //IP֧ͬ
#define NET_DVR_ERR_NETPORT                       1461    //˿ڴ

#define NET_DVR_ERR_PPPOE_NOSUPPORT               1462  //PPPOE֧
#define NET_DVR_ERR_DOMAINNAME_NOSUPPORT          1463  //֧
#define NET_DVR_ERR_NO_SPEED                      1464  //δòٹ 
#define NET_DVR_ERR_IOSTATUS_INVALID              1465  //IO״̬
#define NET_DVR_ERR_BURST_INTERVAL_INVALID        1466  //ļǷ    
#define NET_DVR_ERR_RESERVE_MODE                  1467  //ģʽ

#define NET_DVR_ERR_LANE_NO                       1468  //ӳŴ
#define NET_DVR_ERR_COIL_AREA_TYPE                1469  //Ȧʹ
#define NET_DVR_ERR_TRIGGER_AREA_PARAM            1470  //
#define NET_DVR_ERR_SPEED_LIMIT_PARAM             1471  //Υٲ
#define NET_DVR_ERR_LANE_PROTOCOL_TYPE            1472  //Эʹ

#define NET_DVR_ERR_INTERVAL_TYPE                 1473  //ļͷǷ
#define NET_DVR_ERR_INTERVAL_DISTANCE             1474  //ļǷ
#define NET_DVR_ERR_RS485_ASSOCIATE_DEVTYPE       1475  //RS485ͷǷ
#define NET_DVR_ERR_RS485_ASSOCIATE_LANENO        1476  //RS485ŷǷ
#define NET_DVR_ERR_LANENO_ASSOCIATE_MULTIRS485   1477  //ŹRS485
#define NET_DVR_ERR_LIGHT_DETECTION_REGION        1478  //ƵźŵźŵƸǼΪ0

#define NET_DVR_ERR_DN2D_NOSUPPORT            1479  //֧ץ֡2D
#define NET_DVR_ERR_IRISMODE_NOSUPPORT        1480  //ֵ֧ľͷ
#define NET_DVR_ERR_WB_NOSUPPORT              1481  //ֵ֧İƽģʽ
#define NET_DVR_ERR_IO_EFFECTIVENESS          1482  //IOڵЧ
#define NET_DVR_ERR_LIGHTNO_MAX               1483  //źŵƼ/ƵƳ(16)
#define NET_DVR_ERR_LIGHTNO_CONFLICT          1484  //źŵƼ/ƵƳͻ      

#define NET_DVR_ERR_CANCEL_LINE                1485  //ֱд
#define NET_DVR_ERR_STOP_LINE               1486  //ֹͣ
#define NET_DVR_ERR_RUSH_REDLIGHT_LINE      1487  //ƴ 
#define NET_DVR_ERR_IOOUTNO_MAX             1488  //IOڱԽ

#define NET_DVR_ERR_IOOUTNO_AHEADTIME_MAX    1489  //IOǰʱ䳬
#define NET_DVR_ERR_IOOUTNO_IOWORKTIME      1490  //IOЧʱ䳬
#define NET_DVR_ERR_IOOUTNO_FREQMULTI       1491  //IOģʽ±Ƶ
#define NET_DVR_ERR_IOOUTNO_DUTYRATE        1492  //IOģʽռձȳ
#define NET_DVR_ERR_VIDEO_WITH_EXPOSURE     1493  //Чʽ֧Ƶ
#define NET_DVR_ERR_PLATE_BRIGHTNESS_WITHOUT_FLASHDET   1494  //ԶʹƽڳȲģʽЧ

#define NET_DVR_ERR_RECOGNIZE_TYPE_PARAM            1495 //ʶͷǷ ʶ󳵡С򡢳ʶȣ
#define NET_DVR_ERR_PALTE_RECOGNIZE_AREA_PARAM      1496 //ʶǷ ʶʱжϳ
#define NET_DVR_ERR_PORT_CONFLICT                   1497 //˿гͻ
#define NET_DVR_ERR_LOOP_IP                         1498 //IPΪػַ
#define NET_DVR_ERR_DRIVELINE_SENSITIVE             1499 //ѹȳ(Ƶ羯ģʽ)


//2013-3-6VQD루15001550
#define NET_ERR_VQD_TIME_CONFLICT                    1500 //VQDʱγͻ
#define NET_ERR_VQD_PLAN_NO_EXIST                    1501 //VQDϼƻ
#define NET_ERR_VQD_CHAN_NO_EXIST                    1502 //VQDص㲻
#define NET_ERR_VQD_CHAN_MAX                        1503 //VQDƻѴ
#define NET_ERR_VQD_TASK_MAX                        1504 //VQDѴ

//ץĻչ(1600~1900)
#define NET_DVR_ERR_EXCEED_MAX_CAPTURE_TIMES        1600 //ץģʽΪƵʱץΪ2(IVTģʽ)
#define NET_DVR_ERR_REDAR_TYPE_CONFLICT             1601 //ͬ485ڹ״ͳͻ 
#define NET_DVR_ERR_LICENSE_PLATE_NULL              1602 //ƺΪ
#define NET_DVR_ERR_WRITE_DATABASE                  1603 //дݿʧ
#define NET_DVR_ERR_LICENSE_EFFECTIVE_TIME          1604 //Чʱ
//Ƶ羯
#define NET_DVR_ERR_PRERECORDED_STARTTIME_LONG      1605 //Ԥ¼ʼʱΥץ
//Ͽ
#define NET_DVR_ERR_TRIGGER_RULE_LINE               1606 //ߴ
#define NET_DVR_ERR_LEFTRIGHT_TRIGGERLINE_NOTVERTICAL 1607 ///Ҵֱ߲
#define NET_DVR_ERR_FLASH_LAMP_MODE                 1608 //˸ģʽ
#define NET_DVR_ERR_ILLEGAL_SNAPSHOT_NUM            1609 //Υץ
#define NET_DVR_ERR_ILLEGAL_DETECTION_TYPE          1610 //Υ¼ʹ
#define NET_DVR_ERR_POSITIVEBACK_TRIGGERLINE_HIGH   1611 //򴥷߸߶ȴ
#define NET_DVR_ERR_MIXEDMODE_CAPTYPE_ALLTARGETS    1612 //ģʽֻֻ֧ץ

#define NET_DVR_ERR_CARSIGNSPEED_GREATERTHAN_LIMITSPEED  1613//С־ٴֵ
#define NET_DVR_ERR_BIGCARSIGNSPEED_GREATERTHAN_LIMITSPEED  1614//󳵱־ٴֵ
#define NET_DVR_ERR_BIGCARSIGNSPEED_GREATERTHAN_CARSIGNSPEED  1615//󳵱־ٴС־ֵ
#define NET_DVR_ERR_BIGCARLIMITSPEED_GREATERTHAN_CARLIMITSPEED  1616//ֵСֵ
#define NET_DVR_ERR_BIGCARLOWSPEEDLIMIT_GREATERTHAN_CARLOWSPEEDLIMIT  1617//󳵵ֵСֵ
#define NET_DVR_ERR_CARLIMITSPEED_GREATERTHAN_EXCEPHIGHSPEED  1618//Сٴ쳣ֵ
#define NET_DVR_ERR_BIGCARLIMITSPEED_GREATERTHAN_EXCEPHIGHSPEED  1619//ٴ쳣ֵ
#define NET_DVR_ERR_STOPLINE_MORETHAN_TRIGGERLINE  1620//ֱֹͣ߳д

//Ž
#define NET_ERR_TIME_OVERLAP                        1900 //ʱص
#define NET_ERR_HOLIDAY_PLAN_OVERLAP                1901 //ռƻص
#define NET_ERR_CARDNO_NOT_SORT                     1902 //δ
#define NET_ERR_CARDNO_NOT_EXIST                    1903 //Ų
#define NET_ERR_ILLEGAL_CARDNO                      1904 //Ŵ
#define NET_ERR_ZONE_ALARM                          1905 //ڲ״̬(޸Ĳ)
#define NET_ERR_ZONE_OPERATION_NOT_SUPPORT          1906 //ָ֧ò
#define NET_ERR_INTERLOCK_ANTI_CONFLICT             1907 //ŻͷǱͬʱô
#define NET_ERR_DEVICE_CARD_FULL                    1908 //ﵽ10W󷵻أ


//ӶԽ
#define NET_DVR_ERR_OUTDOOR_COMMUNICATION            1950 //ſڻͨ쳣
#define NET_DVR_ERR_ROOMNO_UNDEFINED                1951 //δ÷
#define NET_DVR_ERR_NO_CALLING            1952 //޺
#define NET_DVR_ERR_RINGING                1953 //
#define NET_DVR_ERR_IS_CALLING_NOW        1954 //ͨ

//˴ 2100 - 3000
#define NET_DVR_ERR_FILE_NOT_COMPLETE               2100    //صļ
#define NET_DVR_ERR_IPC_EXIST                       2101    //IPCѾ
#define NET_DVR_ERR_ADD_IPC                         2102    //ͨIPC
#define NET_DVR_ERR_OUT_OF_RES                      2103    //
#define NET_DVR_ERR_CONFLICT_TO_LOCALIP             2104    //IPCipַDVRipַͻ
#define NET_DVR_ERR_IP_SET                          2105    //Ƿipַ
#define NET_DVR_ERR_PORT_SET                        2106    //ǷĶ˿ں

//ȳش루3001 - 3500
#define NET_DVR_ERR_NOTSUPPORT_DEICING    3001    //豸ǰ״ֳ̬֧

/*******************ȫִ end**********************/

/*************************************************
NET_DVR_IsSupport()ֵ
19λֱʾϢλTRUE)ʾ֧֣
**************************************************/
#define NET_DVR_SUPPORT_DDRAW            0x01//֧DIRECTDRAW֧֣򲥷ܹ
#define NET_DVR_SUPPORT_BLT                0x02//Կ֧BLT֧֣򲥷ܹ
#define NET_DVR_SUPPORT_BLTFOURCC        0x04//ԿBLT֧ɫת֧֣RGBת
#define NET_DVR_SUPPORT_BLTSHRINKX        0x08//ԿBLT֧XС֧֣ϵͳת
#define NET_DVR_SUPPORT_BLTSHRINKY        0x10//ԿBLT֧YС֧֣ϵͳת
#define NET_DVR_SUPPORT_BLTSTRETCHX        0x20//ԿBLT֧XŴ֧֣ϵͳת
#define NET_DVR_SUPPORT_BLTSTRETCHY        0x40//ԿBLT֧YŴ֧֣ϵͳת
#define NET_DVR_SUPPORT_SSE                0x80//CPU֧SSEָIntel Pentium3֧SSEָ
#define NET_DVR_SUPPORT_MMX                0x100//CPU֧MMXָIntel Pentium3֧SSEָ

/**********************̨ begin*************************/    
#define LIGHT_PWRON        2    /* ͨƹԴ */
#define WIPER_PWRON        3    /* ͨˢ */
#define FAN_PWRON        4    /* ͨȿ */
#define HEATER_PWRON    5    /* ͨ */
#define AUX_PWRON1        6    /* ͨ豸 */
#define AUX_PWRON2        7    /* ͨ豸 */
#define SET_PRESET        8    /* Ԥõ */
#define CLE_PRESET        9    /* Ԥõ */

#define ZOOM_IN            11    /* ٶSS(ʱ) */
#define ZOOM_OUT        12    /* ٶSSС(ʱС) */
#define FOCUS_NEAR      13  /* ٶSSǰ */
#define FOCUS_FAR       14  /* ٶSS */
#define IRIS_OPEN       15  /* ȦٶSS */
#define IRIS_CLOSE      16  /* ȦٶSSС */

#define TILT_UP            21    /* ̨SSٶ */
#define TILT_DOWN        22    /* ̨SSٶ¸ */
#define PAN_LEFT        23    /* ̨SSٶת */
#define PAN_RIGHT        24    /* ̨SSٶת */
#define UP_LEFT            25    /* ̨SSٶת */
#define UP_RIGHT        26    /* ̨SSٶת */
#define DOWN_LEFT        27    /* ̨SSٶ¸ת */
#define DOWN_RIGHT        28    /* ̨SSٶ¸ת */
#define PAN_AUTO        29    /* ̨SSٶԶɨ */

#define FILL_PRE_SEQ    30    /* ԤõѲ */
#define SET_SEQ_DWELL    31    /* Ѳͣʱ */
#define SET_SEQ_SPEED    32    /* Ѳٶ */
#define CLE_PRE_SEQ        33    /* ԤõѲɾ */
#define STA_MEM_CRUISE    34    /* ʼ¼켣 */
#define STO_MEM_CRUISE    35    /* ֹͣ¼켣 */
#define RUN_CRUISE        36    /* ʼ켣 */
#define RUN_SEQ            37    /* ʼѲ */
#define STOP_SEQ        38    /* ֹͣѲ */
#define GOTO_PRESET        39    /* תԤõ */

#define DEL_SEQ         43  /* ɾѲ· */
#define STOP_CRUISE        44    /* ֹͣ켣 */
#define DELETE_CRUISE    45    /* ɾ켣 */
#define DELETE_ALL_CRUISE 46/* ɾй켣 */

#define PAN_CIRCLE      50   /* ̨SSٶԶԲɨ */
#define DRAG_PTZ        51   /* ϶PTZ */
#define LINEAR_SCAN     52   /* ɨ */ //2014-03-15 
#define CLE_ALL_PRESET  53   /* Ԥõȫ */ 
#define CLE_ALL_SEQ     54   /* Ѳȫ */ 
#define CLE_ALL_CRUISE  55   /* 켣ȫ */ 

#define POPUP_MENU      56   /* ʾ˵ */

#define TILT_DOWN_ZOOM_IN    58    /* ̨SSٶ¸&&ٶSS(ʱ) */
#define TILT_DOWN_ZOOM_OUT  59  /* ̨SSٶ¸&&ٶSSС(ʱС) */
#define PAN_LEFT_ZOOM_IN    60  /* ̨SSٶת&&ٶSS(ʱ)*/
#define PAN_LEFT_ZOOM_OUT   61  /* ̨SSٶת&&ٶSSС(ʱС)*/
#define PAN_RIGHT_ZOOM_IN    62  /* ̨SSٶת&&ٶSS(ʱ) */
#define PAN_RIGHT_ZOOM_OUT  63  /* ̨SSٶת&&ٶSSС(ʱС) */
#define UP_LEFT_ZOOM_IN     64  /* ̨SSٶת&&ٶSS(ʱ)*/
#define UP_LEFT_ZOOM_OUT    65  /* ̨SSٶת&&ٶSSС(ʱС)*/
#define UP_RIGHT_ZOOM_IN    66  /* ̨SSٶת&&ٶSS(ʱ)*/
#define UP_RIGHT_ZOOM_OUT   67  /* ̨SSٶת&&ٶSSС(ʱС)*/
#define DOWN_LEFT_ZOOM_IN   68  /* ̨SSٶ¸ת&&ٶSS(ʱ) */
#define DOWN_LEFT_ZOOM_OUT  69  /* ̨SSٶ¸ת&&ٶSSС(ʱС) */
#define DOWN_RIGHT_ZOOM_IN    70  /* ̨SSٶ¸ת&&ٶSS(ʱ) */
#define DOWN_RIGHT_ZOOM_OUT    71  /* ̨SSٶ¸ת&&ٶSSС(ʱС) */
#define TILT_UP_ZOOM_IN        72    /* ̨SSٶ&&ٶSS(ʱ) */
#define TILT_UP_ZOOM_OUT    73    /* ̨SSٶ&&ٶSSС(ʱС) */
/**********************̨ end*************************/

#define DVR_VEHICLE_CONTROL_LIST   0x1 //ڰ(͵)2013-11-04
    

/*************************************************
طʱſ궨 
NET_DVR_PlayBackControl
NET_DVR_PlayControlLocDisplay
NET_DVR_DecPlayBackCtrlĺ궨
ֲ֧鿴˵ʹ
**************************************************/    
#define NET_DVR_PLAYSTART        1//ʼ
#define NET_DVR_PLAYSTOP        2//ֹͣ
#define NET_DVR_PLAYPAUSE        3//ͣ
#define NET_DVR_PLAYRESTART        4//ָ
#define NET_DVR_PLAYFAST        5//
#define NET_DVR_PLAYSLOW        6//
#define NET_DVR_PLAYNORMAL        7//ٶ
#define NET_DVR_PLAYFRAME        8//֡
#define NET_DVR_PLAYSTARTAUDIO    9//
#define NET_DVR_PLAYSTOPAUDIO    10//ر
#define NET_DVR_PLAYAUDIOVOLUME    11//
#define NET_DVR_PLAYSETPOS        12//ıļطŵĽ
#define NET_DVR_PLAYGETPOS        13//ȡļطŵĽ
#define NET_DVR_PLAYGETTIME        14//ȡǰѾŵʱ(ļطŵʱЧ)
#define NET_DVR_PLAYGETFRAME    15//ȡǰѾŵ֡(ļطŵʱЧ)
#define NET_DVR_GETTOTALFRAMES  16//ȡǰļܵ֡(ļطŵʱЧ)
#define NET_DVR_GETTOTALTIME    17//ȡǰļܵʱ(ļطŵʱЧ)
#define NET_DVR_THROWBFRAME        20//B֡
#define NET_DVR_SETSPEED        24//ٶ
#define NET_DVR_KEEPALIVE        25//豸(ص2뷢һ)
#define NET_DVR_PLAYSETTIME        26//ʱ䶨λ
#define NET_DVR_PLAYGETTOTALLEN    27//ȡʱطŶӦʱڵļܳ
#define NET_DVR_PLAY_FORWARD    29 //лΪ
#define NET_DVR_PLAY_REVERSE    30 //лΪ
#define NET_DVR_SET_DECODEFFRAMETYPE 31 
#define NET_DVR_SET_TRANS_TYPE    32 //תʽ
#define NET_DVR_PLAY_CONVERT    33 //طת
#define NET_DVR_START_DRAWFRAME 34 //ʼ֡ط
#define NET_DVR_STOP_DRAWFRAME  35 //ֹͣ֡ط


#define PLAYM4_DECODE_NORMAIL              0   //
#define PLAYM4_DECODE_KEY_FRAME            1   //ֻI֡
#define PLAYM4_DECODE_NONE                 2   //ȫ
#define PLAYM4_DECODE_TEMPORAL_LAYER_0     3   //1/2
#define PLAYM4_DECODE_TEMPORAL_LAYER_1     4   //1/4


//Զ̰£
/* key value send to CONFIG program */
#define KEY_CODE_1      1
#define KEY_CODE_2      2
#define KEY_CODE_3      3
#define KEY_CODE_4      4
#define KEY_CODE_5      5
#define KEY_CODE_6      6
#define KEY_CODE_7      7
#define KEY_CODE_8      8
#define KEY_CODE_9      9
#define KEY_CODE_0      10
#define KEY_CODE_POWER  11
#define KEY_CODE_MENU   12
#define KEY_CODE_ENTER  13
#define KEY_CODE_CANCEL 14
#define KEY_CODE_UP     15
#define KEY_CODE_DOWN   16
#define KEY_CODE_LEFT   17
#define KEY_CODE_RIGHT  18
#define KEY_CODE_EDIT   19
#define KEY_CODE_ADD    20
#define KEY_CODE_MINUS  21
#define KEY_CODE_PLAY   22
#define KEY_CODE_REC    23
#define KEY_CODE_PAN    24
#define KEY_CODE_M      25
#define KEY_CODE_A      26
#define KEY_CODE_F1     27
#define KEY_CODE_F2     28

/* for PTZ control */
#define KEY_PTZ_UP_START        KEY_CODE_UP
#define KEY_PTZ_UP_STOP         32

#define KEY_PTZ_DOWN_START      KEY_CODE_DOWN
#define KEY_PTZ_DOWN_STOP       33

#define KEY_PTZ_LEFT_START      KEY_CODE_LEFT
#define KEY_PTZ_LEFT_STOP       34

#define KEY_PTZ_RIGHT_START     KEY_CODE_RIGHT
#define KEY_PTZ_RIGHT_STOP      35

#define KEY_PTZ_AP1_START       KEY_CODE_EDIT /*Ȧ+*/
#define KEY_PTZ_AP1_STOP        36

#define KEY_PTZ_AP2_START       KEY_CODE_PAN /*Ȧ-*/
#define KEY_PTZ_AP2_STOP        37

#define KEY_PTZ_FOCUS1_START    KEY_CODE_A /*۽+*/
#define KEY_PTZ_FOCUS1_STOP     38

#define KEY_PTZ_FOCUS2_START    KEY_CODE_M /*۽-*/
#define KEY_PTZ_FOCUS2_STOP     39

#define KEY_PTZ_B1_START        40 /*䱶+*/
#define KEY_PTZ_B1_STOP         41

#define KEY_PTZ_B2_START        42 /*䱶-*/
#define KEY_PTZ_B2_STOP         43

//9000
#define KEY_CODE_11             44
#define KEY_CODE_12             45
#define KEY_CODE_13             46
#define KEY_CODE_14             47
#define KEY_CODE_15             48
#define KEY_CODE_16             49



/************************* begin*******************************/
//NET_DVR_SetDVRConfigNET_DVR_GetDVRConfig,עӦýṹ

#define NET_DVR_GET_DEVICECFG        100        //ȡ豸
#define NET_DVR_SET_DEVICECFG        101        //豸
#define NET_DVR_GET_NETCFG            102        //ȡ
#define NET_DVR_SET_NETCFG            103        //
#define NET_DVR_GET_PICCFG            104        //ȡͼ
#define NET_DVR_SET_PICCFG            105        //ͼ
#define NET_DVR_GET_COMPRESSCFG        106        //ȡѹ
#define NET_DVR_SET_COMPRESSCFG        107        //ѹ
#define NET_DVR_GET_RECORDCFG        108        //ȡ¼ʱ
#define NET_DVR_SET_RECORDCFG        109        //¼ʱ
#define NET_DVR_GET_DECODERCFG        110        //ȡ
#define NET_DVR_SET_DECODERCFG        111        //ý
#define NET_DVR_GET_RS232CFG         112        //ȡ232ڲ
#define NET_DVR_SET_RS232CFG        113        //232ڲ
#define NET_DVR_GET_ALARMINCFG         114        //ȡ
#define NET_DVR_SET_ALARMINCFG        115        //ñ
#define NET_DVR_GET_ALARMOUTCFG     116        //ȡ
#define NET_DVR_SET_ALARMOUTCFG        117        //ñ
#define NET_DVR_GET_TIMECFG         118        //ȡDVRʱ
#define NET_DVR_SET_TIMECFG            119        //DVRʱ
#define NET_DVR_GET_PREVIEWCFG         120        //ȡԤ
#define NET_DVR_SET_PREVIEWCFG        121        //Ԥ
#define NET_DVR_GET_VIDEOOUTCFG     122        //ȡƵ
#define NET_DVR_SET_VIDEOOUTCFG        123        //Ƶ
#define NET_DVR_GET_USERCFG         124        //ȡû
#define NET_DVR_SET_USERCFG            125        //û
#define NET_DVR_GET_EXCEPTIONCFG     126        //ȡ쳣
#define NET_DVR_SET_EXCEPTIONCFG    127        //쳣
#define NET_DVR_GET_ZONEANDDST        128        //ȡʱʱƲ
#define NET_DVR_SET_ZONEANDDST        129        //ʱʱƲ

//עֻ֧4OSDͣͨV30µ豸汾
#define NET_DVR_GET_SHOWSTRING        130        //ȡַ
#define NET_DVR_SET_SHOWSTRING        131        //õַ

#define NET_DVR_GET_EVENTCOMPCFG    132        //ȡ¼¼
#define NET_DVR_SET_EVENTCOMPCFG    133        //¼¼
#define NET_DVR_GET_FTPCFG            134        //ȡץͼFTP()
#define NET_DVR_SET_FTPCFG            135        //ץͼFTP()
#define NET_DVR_GET_AUXOUTCFG        140        //ȡ(HS豸2006-02-28)
#define NET_DVR_SET_AUXOUTCFG        141        //ñ(HS豸2006-02-28)
#define NET_DVR_GET_PREVIEWCFG_AUX     142        //ȡ-sϵ˫Ԥ(-sϵ˫2006-04-13)
#define NET_DVR_SET_PREVIEWCFG_AUX    143        //-sϵ˫Ԥ(-sϵ˫2006-04-13)

#define NET_DVR_GET_PASSWORD_MANAGE_CFG 144        //ȡ
#define NET_DVR_SET_PASSWORD_MANAGE_CFG    145        //
#define NET_DVR_UNLOCK_USER             146        //û
#define NET_DVR_GET_SECURITY_CFG         147        //ȡȫ֤
#define NET_DVR_SET_SECURITY_CFG         148        //ðȫ֤
#define    NET_DVR_GET_LOCKED_INFO_LIST    149        //ȡбϢ


/*********************************ֽܲӿ begin***************************************/
//ΪӦNET_VCA_RULECFG
#define NET_DVR_SET_RULECFG            152    //Ϊ
#define NET_DVR_GET_RULECFG            153    //ȡΪ
//궨NET_DVR_TRACK_CFG 
#define NET_DVR_SET_TRACK_CFG       160//ò 
#define NET_DVR_GET_TRACK_CFG       161//ȡò

//ܷȡýṹ
#define NET_DVR_SET_IVMS_STREAMCFG    162        //ܷȡ
#define NET_DVR_GET_IVMS_STREAMCFG    163        //ȡܷȡ
//ܿƲṹ
#define NET_DVR_SET_VCA_CTRLCFG        164     //ܿƲ
#define NET_DVR_GET_VCA_CTRLCFG        165     //ȡܿƲ
//NET_VCA_MASK_REGION_LIST
#define NET_DVR_SET_VCA_MASK_REGION    166     //
#define NET_DVR_GET_VCA_MASK_REGION    167     //ȡ

//ATM NET_VCA_ENTER_REGION
#define NET_DVR_SET_VCA_ENTER_REGION 168     //ý
#define NET_DVR_GET_VCA_ENTER_REGION 169     //ȡ

//궨NET_VCA_LINE_SEGMENT_LIST
#define NET_DVR_SET_VCA_LINE_SEGMENT 170     //ñ궨
#define NET_DVR_GET_VCA_LINE_SEGMENT 171     //ȡ궨

// ivmsNET_IVMS_MASK_REGION_LIST
#define NET_DVR_SET_IVMS_MASK_REGION 172     //IVMS
#define NET_DVR_GET_IVMS_MASK_REGION 173     //ȡIVMS
// ivmsNET_IVMS_ENTER_REGION
#define NET_DVR_SET_IVMS_ENTER_REGION 174     //IVMS
#define NET_DVR_GET_IVMS_ENTER_REGION 175     //ȡIVMS

#define NET_DVR_SET_IVMS_BEHAVIORCFG  176    //ܷΪ
#define NET_DVR_GET_IVMS_BEHAVIORCFG  177    //ȡܷΪ

// IVMS طż
#define NET_DVR_IVMS_SET_SEARCHCFG        178    //IVMSطż
#define NET_DVR_IVMS_GET_SEARCHCFG        179    //ȡIVMSطż

#define NET_DVR_SET_POSITION_TRACK      180     // óϢ
#define NET_DVR_GET_POSITION_TRACK      181     // ȡϢ

#define NET_DVR_SET_CALIBRATION         182    // ñ궨Ϣ
#define NET_DVR_GET_CALIBRATION         183    // ȡ궨Ϣ

#define NET_DVR_SET_PDC_RULECFG         184    // ͳƹ
#define NET_DVR_GET_PDC_RULECFG         185    // ȡͳƹ

#define NET_DVR_SET_PU_STREAMCFG        186     // ǰȡ豸Ϣ
#define NET_DVR_GET_PU_STREAMCFG        187     // ȡǰȡ豸Ϣ

#define NET_VCA_SET_IVMS_BEHAVIOR_CFG        192  // IVMSΪ ʱ
#define NET_VCA_GET_IVMS_BEHAVIOR_CFG        193  // ȡIVMSΪ ʱ

#define NET_VCA_SET_SIZE_FILTER         194     // ȫֳߴ
#define NET_VCA_GET_SIZE_FILTER         195     // ȡȫֳߴ

#define NET_DVR_SET_TRACK_PARAMCFG      196     // ز˵
#define NET_DVR_GET_TRACK_PARAMCFG      197     // ȡز˵

#define NET_DVR_SET_DOME_MOVEMENT_PARAM 198     // о
#define NET_DVR_GET_DOME_MOVEMENT_PARAM 199     // ȡо

#define NET_DVR_GET_PICCFG_EX        200        //ȡͼ(SDK_V14չ)
#define NET_DVR_SET_PICCFG_EX        201        //ͼ(SDK_V14չ)
#define NET_DVR_GET_USERCFG_EX         202        //ȡû(SDK_V15չ)
#define NET_DVR_SET_USERCFG_EX        203        //û(SDK_V15չ)
#define NET_DVR_GET_COMPRESSCFG_EX    204        //ȡѹ(SDK_V15չ2006-05-15)
#define NET_DVR_SET_COMPRESSCFG_EX    205        //ѹ(SDK_V15չ2006-05-15)


#define NET_DVR_GET_NETAPPCFG        222        //ȡӦò NTP/DDNS/EMAIL
#define NET_DVR_SET_NETAPPCFG        223        //Ӧò NTP/DDNS/EMAIL
#define NET_DVR_GET_NTPCFG            224        //ȡӦò NTP
#define NET_DVR_SET_NTPCFG            225        //Ӧò NTP
#define NET_DVR_GET_DDNSCFG            226        //ȡӦò DDNS
#define NET_DVR_SET_DDNSCFG            227        //Ӧò DDNS
//ӦNET_DVR_EMAILPARA
#define NET_DVR_GET_EMAILCFG        228        //ȡӦò EMAIL
#define NET_DVR_SET_EMAILCFG        229        //Ӧò EMAIL

#define NET_DVR_GET_NFSCFG            230        /* NFS disk config */
#define NET_DVR_SET_NFSCFG            231        /* NFS disk config */

/*עΪƣֻ֧8OSDͣV30豸汾֮ǰ
NET_DVR_GET_SHOWSTRING NET_DVR_SET_SHOWSTRING ʹã*/
#define NET_DVR_GET_SHOWSTRING_EX    238        //ȡַչ(֧8ַ)
#define NET_DVR_SET_SHOWSTRING_EX    239        //õַչ(֧8ַ)
#define NET_DVR_GET_NETCFG_OTHER    244        //ȡ
#define NET_DVR_SET_NETCFG_OTHER    245        //

//ӦNET_DVR_EMAILCFGṹ
#define NET_DVR_GET_EMAILPARACFG    250        //Get EMAIL parameters
#define NET_DVR_SET_EMAILPARACFG    251        //Setup EMAIL parameters


#define NET_DVR_GET_DDNSCFG_EX        274    //ȡչDDNS
#define NET_DVR_SET_DDNSCFG_EX        275    //չDDNS

#define    NET_DVR_SET_PTZPOS            292        //̨PTZλ
#define    NET_DVR_GET_PTZPOS            293        //̨ȡPTZλ
#define    NET_DVR_GET_PTZSCOPE        294        //̨ȡPTZΧ

#define NET_DVR_GET_AP_INFO_LIST    305//ȡԴ
#define NET_DVR_SET_WIFI_CFG        306    //IP豸߲
#define NET_DVR_GET_WIFI_CFG        307    //ȡIP豸߲
#define NET_DVR_SET_WIFI_WORKMODE    308    //IP豸ڹģʽ
#define NET_DVR_GET_WIFI_WORKMODE    309    //ȡIP豸ڹģʽ
#define    NET_DVR_GET_WIFI_STATUS        310    //ȡ豸ǰwifi״̬
/*********************************ܽͨ¼begin***************************************/
#define NET_DVR_GET_REFERENCE_REGION            400      //ȡο
#define NET_DVR_SET_REFERENCE_REGION            401      //òο

#define NET_DVR_GET_TRAFFIC_MASK_REGION         402     //ȡͨ¼
#define NET_DVR_SET_TRAFFIC_MASK_REGION         403     //ýͨ¼
#define NET_DVR_SET_AID_RULECFG                 404     //ýͨ¼
#define NET_DVR_GET_AID_RULECFG                 405     //ȡͨ¼

#define NET_DVR_SET_TPS_RULECFG                 406     //ýͨͳƹ
#define NET_DVR_GET_TPS_RULECFG                 407     //ȡͨͳƹ

#define NET_DVR_SET_LANECFG                        408        //ó
#define    NET_DVR_GET_LANECFG                        409        //ȡ
#define NET_DVR_GET_VCA_RULE_COLOR_CFG          410     //ȡܹɫ
#define NET_DVR_SET_VCA_RULE_COLOR_CFG          411     //ܹɫ
#define NET_DVR_GET_SWITCH_LAMP_CFG             412     //ȡصƼò
#define NET_DVR_SET_SWITCH_LAMP_CFG             413     //ÿصƼò 


/*********************************ܽͨ¼end***************************************/
#define NET_DVR_SET_FACEDETECT_RULECFG          420         // 
#define NET_DVR_GET_FACEDETECT_RULECFG          421         // ȡ

#define NET_DVR_SET_VEHICLE_RECOG_TASK          422      //ʶύ
#define NET_DVR_GET_VEHICLE_RECOG_TASK          423      //ʶȡ

#define NET_DVR_SET_TIMECORRECT                    432      //УʱãֻУʱ¼Уʱã
#define    NET_DVR_GET_CONNECT_LIST                433         //ȡ豸бϢ

/***************************DS9000(_V30) begin *****************************/
//(NET_DVR_NETCFG_V30ṹ)
#define NET_DVR_GET_NETCFG_V30                    1000        //ȡ
#define NET_DVR_SET_NETCFG_V30                    1001        //

//ͼ(NET_DVR_PICCFG_V30ṹ)
#define NET_DVR_GET_PICCFG_V30                    1002        //ȡͼ
#define NET_DVR_SET_PICCFG_V30                    1003        //ͼ

//¼ʱ(NET_DVR_RECORD_V30ṹ)
#define NET_DVR_GET_RECORDCFG_V30                1004        //ȡ¼
#define NET_DVR_SET_RECORDCFG_V30                1005        //¼

//û(NET_DVR_USER_V30ṹ)
#define NET_DVR_GET_USERCFG_V30                 1006        //ȡû
#define NET_DVR_SET_USERCFG_V30                    1007        //û

//¼ʱ(NET_DVR_RECORD_V40ṹ)
#define NET_DVR_GET_RECORDCFG_V40                1008        //ȡ¼(չ)
#define NET_DVR_SET_RECORDCFG_V40                1009        //¼(չ)

//9000DDNS(NET_DVR_DDNSPARA_V30ṹ)
#define     NET_DVR_GET_DDNSCFG_V30                1010        //ȡDDNS(9000չ)
#define     NET_DVR_SET_DDNSCFG_V30                1011        //DDNS(9000չ)

//EMAIL(NET_DVR_EMAILCFG_V30ṹ)
#define NET_DVR_GET_EMAILCFG_V30                1012     //ȡEMAIL 
#define NET_DVR_SET_EMAILCFG_V30                1013     //EMAIL 

#define NET_GET_CRUISEPOINT_V40                    1018     //ȡѲ·

//Ѳ (NET_DVR_CRUISE_PARAṹ)
#define     NET_DVR_GET_CRUISE                    1020        
#define     NET_DVR_SET_CRUISE                    1021        


//ṹ (NET_DVR_ALARMINCFG_V30ṹ)
#define     NET_DVR_GET_ALARMINCFG_V30            1024        
#define     NET_DVR_SET_ALARMINCFG_V30            1025

//ṹ (NET_DVR_ALARMOUTCFG_V30ṹ)
#define     NET_DVR_GET_ALARMOUTCFG_V30            1026        
#define     NET_DVR_SET_ALARMOUTCFG_V30            1027

//Ƶṹ (NET_DVR_VIDEOOUT_V30ṹ)
#define     NET_DVR_GET_VIDEOOUTCFG_V30            1028        
#define     NET_DVR_SET_VIDEOOUTCFG_V30            1029


/*֧8OSDͣ豸汾ΪV30ʱͨ豸汾ƥ䣬
ͬʱ֮ǰNET_DVR_GET_SHOWSTRING NET_DVR_SET_SHOWSTRING ʹã*/
//ַṹ (NET_DVR_SHOWSTRING_V30ṹ)
#define     NET_DVR_GET_SHOWSTRING_V30            1030        
#define     NET_DVR_SET_SHOWSTRING_V30            1031

//쳣ṹ (NET_DVR_EXCEPTION_V30ṹ)
#define     NET_DVR_GET_EXCEPTIONCFG_V30        1034        
#define     NET_DVR_SET_EXCEPTIONCFG_V30        1035

//232ṹ (NET_DVR_RS232CFG_V30ṹ)
#define     NET_DVR_GET_RS232CFG_V30            1036        
#define     NET_DVR_SET_RS232CFG_V30            1037

//Ӳ̽ṹ (NET_DVR_NET_DISKCFGṹ)
#define        NET_DVR_GET_NET_DISKCFG                1038        //Ӳ̽ȡ
#define        NET_DVR_SET_NET_DISKCFG                1039        //Ӳ̽
//ѹ (NET_DVR_COMPRESSIONCFG_V30ṹ)
#define     NET_DVR_GET_COMPRESSCFG_V30            1040        
#define     NET_DVR_SET_COMPRESSCFG_V30            1041        

//ȡ485 (NET_DVR_DECODERCFG_V30ṹ)
#define     NET_DVR_GET_DECODERCFG_V30            1042        //ȡ
#define     NET_DVR_SET_DECODERCFG_V30            1043        //ý

//ȡԤ (NET_DVR_PREVIEWCFG_V30ṹ)
#define     NET_DVR_GET_PREVIEWCFG_V30            1044        //ȡԤ
#define     NET_DVR_SET_PREVIEWCFG_V30            1045        //Ԥ

//Ԥ (NET_DVR_PREVIEWCFG_AUX_V30ṹ)
#define     NET_DVR_GET_PREVIEWCFG_AUX_V30        1046        //ȡԤ
#define     NET_DVR_SET_PREVIEWCFG_AUX_V30        1047        //øԤ

//IPò NET_DVR_IPPARACFGṹ
#define     NET_DVR_GET_IPPARACFG               1048        //ȡIPϢ 
#define     NET_DVR_SET_IPPARACFG               1049        //IPϢ

//IPò NET_DVR_IPALARMINCFGṹ
#define     NET_DVR_GET_IPALARMINCFG            1050        //ȡIPϢ 
#define     NET_DVR_SET_IPALARMINCFG            1051        //IPϢ

//IPò NET_DVR_IPALARMOUTCFGṹ
#define     NET_DVR_GET_IPALARMOUTCFG           1052        //ȡIPϢ 
#define     NET_DVR_SET_IPALARMOUTCFG           1053        //IPϢ

//Ӳ̹Ĳȡ (NET_DVR_HDCFGṹ)
#define     NET_DVR_GET_HDCFG                    1054        //ȡӲ̹ò
#define     NET_DVR_SET_HDCFG                    1055        //Ӳ̹ò
//Ĳȡ (NET_DVR_HDGROUP_CFGṹ)
#define     NET_DVR_GET_HDGROUP_CFG                1056        //ȡò
#define     NET_DVR_SET_HDGROUP_CFG                1057        //ò

//豸(NET_DVR_COMPRESSION_AUDIOṹ)
#define     NET_DVR_GET_COMPRESSCFG_AUD         1058        //ȡ豸Խ
#define     NET_DVR_SET_COMPRESSCFG_AUD         1059        //豸Խ

//IPò NET_DVR_IPPARACFG_V31ṹ
#define     NET_DVR_GET_IPPARACFG_V31           1060        //ȡIPϢ 
#define     NET_DVR_SET_IPPARACFG_V31           1061        //IPϢ

// ͨԴ (NET_DVR_IPPARACFG_V40ṹ)
#define NET_DVR_GET_IPPARACFG_V40               1062        // ȡIP
#define NET_DVR_SET_IPPARACFG_V40               1063        // IP

#define NET_DVR_GET_CCDPARAMCFG                 1067       //IPCȡCCD
#define NET_DVR_SET_CCDPARAMCFG                 1068       //IPCCCD

#define NET_DVR_GET_IOINCFG                        1070    //ȡץĻIO
#define NET_DVR_SET_IOINCFG                        1071     //ץĻIO

#define NET_DVR_GET_IOOUTCFG                    1072    //ȡץĻIO
#define NET_DVR_SET_IOOUTCFG                    1073     //ץĻIO

#define NET_DVR_GET_FLASHCFG                    1074    //ȡIO
#define NET_DVR_SET_FLASHCFG                    1075     //IO

#define NET_DVR_GET_LIGHTSNAPCFG                1076    //ȡץĻ̵Ʋ
#define NET_DVR_SET_LIGHTSNAPCFG                1077     //ץĻ̵Ʋ

#define NET_DVR_GET_MEASURESPEEDCFG                1078    //ȡץĻٲ
#define NET_DVR_SET_MEASURESPEEDCFG                1079     //ץĻٲ

#define NET_DVR_GET_IMAGEOVERLAYCFG                1080//ȡץĻͼϢ
#define NET_DVR_SET_IMAGEOVERLAYCFG                1081//ץĻͼϢ

#define NET_DVR_GET_SNAPCFG                        1082//ȡIOץĹ
#define NET_DVR_SET_SNAPCFG                        1083//õIOץĹ

#define NET_DVR_GET_VTPPARAM                    1084//ȡȦ
#define NET_DVR_SET_VTPPARAM                    1085//Ȧ

#define NET_DVR_GET_SNAPENABLECFG                1086//ȡץĻʹܲ
#define NET_DVR_SET_SNAPENABLECFG                1087//ץĻʹܲ

#define NET_DVR_GET_POSTEPOLICECFG              1088//ȡڵ羯
#define NET_DVR_SET_POSTEPOLICECFG              1089//ÿڵ羯

#define NET_DVR_GET_JPEGCFG_V30                    1090//ȡץͼJPEG()
#define NET_DVR_SET_JPEGCFG_V30                    1091//ץͼJPEG()

#define NET_DVR_GET_SPRCFG                        1092//ȡʶ
#define NET_DVR_SET_SPRCFG                        1093//óʶ
#define NET_DVR_GET_PLCCFG                      1094//ȡȲ
#define NET_DVR_SET_PLCCFG                      1095//óȲ

#define NET_DVR_GET_DEVICESTATECFG              1096//ȡ豸ǰ״̬
#define NET_DVR_SET_CALIBRATE_TIME              1097//չʱУʱ
#define NET_DVR_GET_CALIBRATE_TIME              1098//ȡչʱУʱ

#define NET_DVR_GET_DEVICECFG_V40                1100//ȡչ豸 
#define NET_DVR_SET_DEVICECFG_V40                1101//չ豸

#define NET_DVR_GET_ZEROCHANCFG                   1102    //ȡͨѹ 
#define NET_DVR_SET_ZEROCHANCFG                  1103    //ͨѹ

#define NET_DVR_GET_ZERO_PREVIEWCFG_V30         1104    // ȡͨԤ
#define NET_DVR_SET_ZERO_PREVIEWCFG_V30         1105    // ͨԤ

#define NET_DVR_SET_ZERO_ZOOM                    1106     //ͨ 
#define NET_DVR_GET_ZERO_ZOOM                    1107     //ȡͨ

#define    NET_DVR_NATASSOCIATECFG_GET                1110    //ȡNATϢ
#define    NET_DVR_NATASSOCIATECFG_SET                1111     //NATϢ

#define NET_DVR_GET_SNMPCFG                       1112    //ȡSNMP 
#define NET_DVR_SET_SNMPCFG                      1113    //SNMP

#define NET_DVR_GET_SNMPCFG_V30                   1114        //ȡSNMPv30 
#define NET_DVR_SET_SNMPCFG_V30                  1115        //SNMPv30

#define    NET_DVR_VIDEOPLATFORMALARMCFG_GET        1130  //ȡƵۺƽ̨
#define    NET_DVR_VIDEOPLATFORMALARMCFG_SET        1131  //Ƶۺƽ̨

#define NET_DVR_GET_RAID_ADAPTER_INFO           1134    // ȡϢ
#define NET_DVR_SET_RAID_ADAPTER_INFO           1135    // Ϣ   

#define    NET_DVR_MATRIX_BIGSCREENCFG_GET            1140//ȡƴӲ
#define    NET_DVR_MATRIX_BIGSCREENCFG_SET            1141//ôƴӲ

#define NET_DVR_GET_MB_PLATFORMPARA                1145 //ȡƽ̨¼
#define NET_DVR_SET_MB_PLATFORMPARA                1146 //ƽ̨¼
#define NET_DVR_GET_MB_DEVSTATUS                1147 //ȡƶ豸״̬

#define  NET_DVR_GET_DECODER_JOINT_CHAN            1151//ȡͨ
#define  NET_DVR_SET_DECODER_JOINT_CHAN            1152//ýͨ

//
#define NET_DVR_GET_NETCFG_MULTI                1161        //ȡ
#define NET_DVR_SET_NETCFG_MULTI                1162        //ö

#define NET_DVR_GET_CMSPARA                        1170//ȡƽ̨
#define NET_DVR_SET_CMSPARA                        1171//ƽ̨
#define NET_DVR_GET_DIALSTATUS                    1172//ȡ״̬
#define NET_DVR_GET_SMSRELATIVEPARA                1173//ȡز
#define NET_DVR_SET_SMSRELATIVEPARA                1174//öز
#define NET_DVR_GET_PINSTATUS                    1175//ȡPin״̬
#define NET_DVR_SET_PINCMD                        1176//PIN
#define NET_DVR_SET_SENSOR_CFG                    1180//ģ
#define NET_DVR_GET_SENSOR_CFG                    1181//ȡģ
#define NET_DVR_SET_ALARMIN_PARAM                1182//ñ
#define NET_DVR_GET_ALARMIN_PARAM                1183//ȡ
#define NET_DVR_SET_ALARMOUT_PARAM                1184//ñ
#define NET_DVR_GET_ALARMOUT_PARAM                1185//ȡ
#define NET_DVR_SET_SIREN_PARAM                    1186//þŲ
#define NET_DVR_GET_SIREN_PARAM                    1187//ȡŲ
#define NET_DVR_SET_ALARM_RS485CFG                1188//ñ485
#define NET_DVR_GET_ALARM_RS485CFG                1189//ȡ485
#define NET_DVR_GET_ALARMHOST_MAIN_STATUS        1190//ȡҪ״̬
#define NET_DVR_GET_ALARMHOST_OTHER_STATUS        1191//ȡ״̬
#define NET_DVR_SET_ALARMHOST_ENABLECFG            1192//ȡʹ״̬
#define NET_DVR_GET_ALARMHOST_ENABLECFG            1193//ñʹ״̬
#define NET_DVR_SET_ALARM_CAMCFG                1194//Ƶۺƽ̨CAM
#define NET_DVR_GET_ALARM_CAMCFG                1195//Ƶۺƽ̨CAM
#define NET_DVR_GET_GATEWAY_CFG                 1196//ȡŽ
#define NET_DVR_SET_GATEWAY_CFG                 1197//Ž

#define NET_DVR_GET_ALARMDIALMODECFG            1198//ȡŲ
#define NET_DVR_SET_ALARMDIALMODECFG            1199//ñŲ
#define    NET_DVR_SET_WINCFG                        1202//ڲ
#define NET_DVR_GET_ALARMHOSTDIALSETUPMODE        1204//ȡ÷ʽ
#define NET_DVR_SET_ALARMHOSTDIALSETUPMODE        1205//ñ÷ʽ

//Ƶ(Ƶ V1.3)
#define NET_DVR_SET_SUBSYSTEM_ALARM                1210    //ϵͳ/
#define NET_DVR_GET_SUBSYSTEM_ALARM                1211    //ȡϵͳ/
#define NET_DVR_GET_WHITELIST_ALARM                1215    //ȡ
#define NET_DVR_SET_WHITELIST_ALARM                1216    //ð
#define    NET_DVR_GET_ALARMHOST_MODULE_LIST        1222    //ȡģ
#define NET_DVR_SET_PRIOR_ALARM                    1223    //ϵͳ/
#define NET_DVR_GET_PRIOR_ALARM                    1224    //ȡϵͳ/    
#define NET_DVR_SET_TAMPER_ALARMIN_PARAM        1225    // ÷
#define NET_DVR_GET_TAMPER_ALARMIN_PARAM        1226    // ȡ

#define NET_DVR_GET_HOLIDAY_PARAM_CFG           1240// ȡڼղ
#define NET_DVR_SET_HOLIDAY_PARAM_CFG           1241// ýڼղ

#define NET_DVR_GET_MOTION_HOLIDAY_HANDLE       1242// ȡƶձʽ
#define NET_DVR_SET_MOTION_HOLIDAY_HANDLE       1243// ȡƶձʽ

#define NET_DVR_GET_VILOST_HOLIDAY_HANDLE       1244// ȡƵźŶʧձʽ
#define NET_DVR_SET_VILOST_HOLIDAY_HANDLE       1245// ȡƵźŶʧձʽ

#define NET_DVR_GET_HIDE_HOLIDAY_HANDLE         1246// ȡڸǼձʽ
#define NET_DVR_SET_HIDE_HOLIDAY_HANDLE         1247// ڸǼձʽ

#define NET_DVR_GET_ALARMIN_HOLIDAY_HANDLE      1248// ȡձʽ
#define NET_DVR_SET_ALARMIN_HOLIDAY_HANDLE      1249// ñձʽ
#define NET_DVR_GET_ALARMOUT_HOLIDAY_HANDLE     1250// ȡձʽ
#define NET_DVR_SET_ALARMOUT_HOLIDAY_HANDLE     1251// ñձʽ
#define NET_DVR_GET_HOLIDAY_RECORD              1252// ȡ¼
#define NET_DVR_SET_HOLIDAY_RECORD              1253// ü¼
#define NET_DVR_GET_NETWORK_BONDING             1254// ȡBONDING
#define NET_DVR_SET_NETWORK_BONDING             1255// BONDING
#define NET_DVR_GET_LINK_STATUS                 1256// ȡͨIP״̬
#define NET_DVR_GET_DISK_QUOTA_CFG              1278// ȡϢ
#define NET_DVR_SET_DISK_QUOTA_CFG              1279// ôϢ
#define NET_DVR_GET_JPEG_CAPTURE_CFG            1280// ȡDVRץͼ
#define NET_DVR_SET_JPEG_CAPTURE_CFG            1281// DVRץͼ
#define NET_DVR_GET_SCHED_CAPTURECFG            1282// ȡץͼƻ
#define NET_DVR_SET_SCHED_CAPTURECFG            1283// ץͼƻ
#define NET_DVR_GET_VGA_PREVIEWCFG              1284// ȡVGAԤ
#define NET_DVR_SET_VGA_PREVIEWCFG              1285// VGAԤ 
#define NET_DVR_GET_VIDEO_INPUT_EFFECT          1286// ȡͨƵͼ
#define NET_DVR_SET_VIDEO_INPUT_EFFECT          1287// ͨƵͼ

#define NET_DVR_GET_STORAGE_SERVER_SWITCH        1290//ȡ洢״̬
#define NET_DVR_SET_STORAGE_SERVER_SWITCH        1291//ô洢״̬


#define NET_DVR_GET_OPTICAL_CHANNEL                1300//ȡϵͳͨϢ
#define NET_DVR_SET_OPTICAL_CHANNEL                1301//ùϵͳͨϢ
#define NET_DVR_GET_FIBER_CASCADE                1302//ȡ˼ģʽ
#define NET_DVR_SET_FIBER_CASCADE                1303//ù˼ģʽ
#define NET_DVR_GET_SPARTAN_STATUS                1304//ȡ״̬
#define NET_DVR_SET_SPARTAN_STATUS                1305//ó״̬
#define NET_DVR_GET_ETHERNET_CHANNEL            1306//ȡ˿ھۺϲ
#define NET_DVR_SET_ETHERMET_CHANNEL            1307//ö˿ھۺϲ
#define NET_DVR_OPTICAL_REBOOT                    1320//˻
#define NET_DVR_SET_AUDIOCHAN_CFG                1321//Ƶл
#define NET_DVR_GET_AUDIOCHAN_CFG                1322//ȡƵл
//SDI1.0
#define NET_DVR_SET_MATRIX_BASE_CFG             1332 //þ
#define NET_DVR_GET_MATRIX_BASE_CFG             1333 //ȡ
#define NET_DVR_SWITCH_MATRIX_IO                1334 //л 
#define NET_DVR_GET_MATRIX_IO_RELATION          1335 //ȡϵ

#define    NET_DVR_V6PSUBSYSTEMARAM_GET            1501//ȡV6ϵͳ
#define    NET_DVR_V6PSUBSYSTEMARAM_SET            1502//V6ϵͳ
#define    NET_DVR_GET_ALLWINCFG                    1503 //ڲȡ

#define    NET_DVR_BIGSCREENASSOCIATECFG_GET        1511 //ȡ
#define    NET_DVR_BIGSCREENASSOCIATECFG_SET        1512 //ô

//1200
#define    NET_DVR_GETSCREENINFO                    1601 //ȡϢ
#define    NET_DVR_SETSCREENINFO                    1602 //ôϢ
#define    NET_DVR_GET_SCREEN_WINCFG                1603//ڲȡ
#define    NET_DVR_LAYOUTLIST_GET                     1605//ȡб
#define    NET_DVR_SET_LAYOUTCFG                    1606 //
#define    NET_DVR_LAYOUTCTRL                        1607//ֿƣ1-open2-close
#define    NET_DVR_INPUTLIST_GET                    1608 //ȡźԴб
#define    NET_DVR_SET_INPUTSTREAMCFG                1609 //źԴ 
#define    NET_DVR_OUTPUT_SET                        1610 //
#define    NET_DVR_OUTPUT_GET                        1611 //ȡ
#define    NET_DVR_SET_OSDCFG                        1612 //OSD
#define    NET_DVR_GET_OSDCFG                        1613 //OSDȡ
#define    NET_DVR_BIGSCREEN_GETSERIAL             1614//ȡϢ
#define    NET_DVR_GET_PLANLIST                    1615//ȡԤб
#define    NET_DVR_SET_PLAN                        1616//Ԥ
#define    NET_DVR_CTRL_PLAN                        1617//Ԥ
#define    NET_DVR_GET_DEVICE_RUN_STATUS           1618//ȡ豸״̬
#define NET_DVR_GET_EXTERNAL_MATRIX_CFG            1619//ȡϢ
#define    NET_DVR_SET_EXTERNAL_MATRIX_CFG            1620//þϢ
#define    NET_DVR_GET_OUTPUT_SCREEN_RELATION        1621//ȡĻİ󶨹ϵ
#define    NET_DVR_SET_OUTPUT_SCREEN_RELATION        1622//Ļİ󶨹ϵ
#define NET_DVR_GET_VCS_USER_CFG                1623//ȡûϢ
#define    NET_DVR_SET_VCS_USER_CFG                1624//ûϢ
#define    NET_DVR_CONTROL_SCREEN                    1625//Ļ

#define NET_DVR_GET_DEV_BASEINFO                1650//ȡ豸Ϣ
#define NET_DVR_SET_DEV_BASEINFO                1651//õ豸Ϣ
#define NET_DVR_GET_DEV_NETINFO                    1652//ȡ豸Ϣ
#define NET_DVR_SET_DEV_NETINFO                    1653//豸Ϣ
#define NET_DVR_GET_SIGNAL_SOURCE_INFO            1654//ȡźԴϢ
#define NET_DVR_SET_SIGNAL_SOURCE_INFO            1655//źԴϢ
#define NET_DVR_ADJUST_PIC_V40                    1656//ͼ΢
#define NET_DVR_RESTORE_V40                        1657//ָĬϲ
#define    NET_DVR_SET_NET_SIGNAL                    1658//źԴ
#define NET_DVR_REBOOT_V40                        1659//
#define NET_DVR_CONTROL_PICTURE_V41                1660//ͼƬV41

#define NET_DVR_GET_AUTO_REBOOT_CFG             1710//ȡԶ
#define NET_DVR_SET_AUTO_REBOOT_CFG             1711//Զ
#define NET_DVR_GET_TRUNK_USE_STATE             1713//ȡָʹ״̬
#define NET_DVR_SET_PTZ_CTRL_INFO                 1714//PTZƲ
#define NET_DVR_GET_PTZ_CTRL_INFO                 1715//ȡPTZƲ
#define NET_DVR_GET_PTZ_STATUS                     1716//ȡPTZ״̬
#define    NET_DVR_GET_DISP_ROUTE_LIST                1717//ȡʾ·б

#define NET_DVR_GET_DEC_RESOURCE_LIST            1720//ȡýԴб
#define NET_DVR_SET_DEC_RESOURCE_LIST            1721//ԤԴ 
#define NET_DVR_GET_DEC_YUV                        1722//ȡͨYUV
#define NET_DVR_SET_DEC_YUV                        1723//ýͨYUV
#define NET_DVR_GET_DEC_RESOUCE                    1724//Ƶۺƽ̨Դ
#define NET_DVR_FREE_DEC_RESOURCE                1725//ͷŽԴ

#define NET_DVR_SET_VIDEOWALLDISPLAYMODE        1730//õǽƴģʽ
#define NET_DVR_GET_VIDEOWALLDISPLAYMODE        1731//ȡǽƴģʽ
#define NET_DVR_GET_VIDEOWALLDISPLAYNO          1732//ȡ豸ʾ
#define    NET_DVR_SET_VIDEOWALLDISPLAYPOSITION    1733//ʾλò
#define    NET_DVR_GET_VIDEOWALLDISPLAYPOSITION    1734//ȡʾλò
#define NET_DVR_GET_VIDEOWALLWINDOWPOSITION     1735//ȡǽڲ
#define NET_DVR_SET_VIDEOWALLWINDOWPOSITION     1736//õǽڲ
#define    NET_DVR_VIDEOWALLWINDOW_CLOSEALL        1737//ǽرд
#define    NET_DVR_SET_VIRTUALLED                    1738//LED
#define    NET_DVR_GET_VIRTUALLED                    1739//LEDȡ
#define NET_DVR_GET_IMAGE_CUT_MODE              1740//ȡͼиģʽ
#define NET_DVR_SET_IMAGE_CUT_MODE              1741//ͼиģʽ
#define NET_DVR_GET_USING_SERIALPORT            1742//ȡǰʹô
#define NET_DVR_SET_USING_SERIALPORT            1743//õǰʹô
#define NET_DVR_SCENE_CONTROL                   1744//
#define NET_DVR_GET_CURRENT_SCENE               1745//ȡǰ
#define NET_DVR_GET_VW_SCENE_PARAM              1746//ȡǽģʽ
#define NET_DVR_SET_VW_SCENE_PARAM              1747//õǽģʽ
#define NET_DVR_DISPLAY_CHANNO_CONTROL          1748//ǽʾſ
#define NET_DVR_GET_WIN_DEC_INFO                1749//ȡڽϢ
#define NET_DVR_RESET_VIDEOWALLDISPLAYPOSITION  1750  //ǽӿڰ 
#define NET_DVR_SET_VW_AUDIO_CFG                1752    //Ƶл
#define    NET_DVR_GET_VW_AUDIO_CFG                1753    //ȡƵл
#define NET_DVR_GET_GBT28181_DECCHANINFO_CFG    1754    //ȡGBT28181Э豸ĽͨϢ
#define NET_DVR_SET_GBT28181_DECCHANINFO_CFG    1755    //GBT28181Э豸ĽͨϢ
#define    NET_DVR_SET_MAINBOARD_SERIAL            1756  //ذ崮ڲ
#define    NET_DVR_GET_MAINBOARD_SERIAL            1757  //ȡذ崮ڲ
#define NET_DVR_GET_SUBBOARD_INFO               1758  //ȡӰϢ
#define NET_DVR_GET_SUBBOARD_EXCEPTION          1759  //ȡ쳣Ӱ쳣Ϣ

#define NET_DVR_GET_CAMERACHAN_SERIALCFG    1760   //ȡCameraͨ󶨴
#define NET_DVR_SET_CAMERACHAN_SERIALCFG    1761   //Cameraͨ󶨴
#define NET_DVR_GET_MATRIX_STATUS            1762   //ȡƵۺƽ̨״̬
#define    NET_SET_MULTIFUNCTION_SERIALCFG     1763  //ö๦ܴ
#define    NET_GET_MULTIFUNCTION_SERIALCFG        1764  //ȡ๦ܴ
#define NET_DVR_PTZ_3D_SPEED                1765  // 3άٶȵ̨

#define  NET_DVR_GET_SIGNAL_JOINT            1766   //ȡźԴ
#define  NET_DVR_SET_SIGNAL_JOINT            1767   //źԴ
#define  NET_DVR_SIGNAL_CUT                    1768   //źԴü
#define  NET_DVR_DYNAMIC_DECODE_BATCH        1769     //̬
#define  NET_DVR_DECSWITCH_SET_BATCH        1770    //ýͨ
#define  NET_DVR_DECSWITCH_GET_BATCH        1771    //ȡͨ
#define  NET_DVR_GET_ALL_SIGNAL_JOINT        1772   //ȡźԴ
#define     NET_DVR_GET_PLAYING_PLAN            1773    //ȡִԤ
#define  NET_DVR_WALL_RELATION_GET            1774   //ȡ豸ǽǽĹ
#define  NET_DVR_WALL_RELATION_SET            1775   //豸ǽǽĹ
#define     NET_DVR_SET_INPUTSTREAMCFG_V40        1776   //źԴ
#define  NET_DVR_PTZCFG_INPUTSTREAM_GET        1777  //ȡԴ̨
#define  NET_DVR_PTZCFG_INPUTSTREAM_SET        1778  //Դ̨
#define  NET_DVR_SIGNAL_CUTPARAM_GET        1779  //ȡźԴü

#define NET_DVR_GET_SUBSYSTEM_NETCFG            1780    //ȡϵͳ
#define NET_DVR_SET_SUBSYSTEM_NETCFG              1781    //ϵͳ
#define    NET_DVR_DEL_SIGNAL_JOINT                1782    //ɾƴźԴ

#define NET_DVR_GET_PICTURE_INFO                1783     //ȡͼƬϢ
#define NET_DVR_SET_PICTURE_INFO                1784     //ͼƬϢ
#define NET_DVR_GET_VIDEO_INFO                    1785     //ȡƵϢ
#define NET_DVR_SET_VIDEO_INFO                    1786     //ƵϢ
#define NET_DVR_SET_PLAYLIST                    1787     //òб
#define NET_DVR_GET_PLAYLIST                    1788     //ȡб
#define NET_DVR_GET_ALL_PLAYLIST                1789     //ȡвб
#define NET_DVR_PLAYITEM_CONTROL                1790     //
#define NET_DVR_SET_PLAYPLAN_TEMPLATE            1791     //òżƻģ
#define NET_DVR_GET_PLAYPLAN_TEMPLATE            1792     //ȡżƻ
#define NET_DVR_GET_ALL_PLAYPLAN_TEMPLATE        1793     //ȡвżƻ
#define NET_DVR_SET_WINDOW_PLAYPLAN                1794     //ôڲżƻ
#define NET_DVR_GET_WINDOW_PLAYPLAN                1795     //ȡڲżƻ
#define NET_DVR_TOPLAY_ITEM                        1796     //ָ
#define NET_DVR_DEVICE_PLAY_CONTROL                1797     //豸ſ
#define NET_DVR_GET_PLAY_INFO                    1798     //ȡǰϢ
#define NET_DVR_GET_ALL_PICTURE_INFO            1799     //ȡͼƬϢ
#define NET_DVR_GET_ALL_VIDEO_INFO                1800     //ȡƵϢ
#define NET_DVR_DELETE_VIDEO_FILE                1801     //ɾƵ


#define NET_DVR_GET_ALARMHOSTSUBSYSTEM_CFG        2001//ȡϵͳ
#define NET_DVR_SET_ALARMHOSTSUBSYSTEM_CFG        2002//ϵͳ
#define NET_DVR_GETEXTENDALARMININFO            2003//ȡϢ
#define NET_DVR_MODIFYALARMINNO                 2004//޸ķϢ
#define NET_DVR_GET_ALARMHOST_WIRELESS_NETWORK_CFG    2005//ȡ
#define    NET_DVR_SET_ALARMHOST_WIRELESS_NETWORK_CFG    2006//
#define    NET_DVR_GET_ALARMHOST_NETCFG            2007//ȡ
#define    NET_DVR_SET_ALARMHOST_NETCFG            2008//
#define NET_DVR_GET_LED_SCREEN_CFG                2009// ȡLEDĻ
#define NET_DVR_SET_LED_SCREEN_CFG                2010// LEDĻ
#define NET_DVR_GET_LED_CONTENT_CFG                2011// ȡLED
#define    NET_DVR_SET_LED_CONTENT_CFG                2012// LED
#define NET_DVR_TURNON_LED                        2013// LED
#define NET_DVR_TURNOFF_LED                        2014// رLED
#define NET_DVR_GET_LED_TIMER_SWITCH            2015// ȡLEDʱز
#define NET_DVR_SET_LED_TIMER_SWITCH            2016// LEDʱز
#define NET_DVR_SET_LED_BRIGHTNESS                2017// ֶLED
#define NET_DVR_GET_LED_TIMER_BRIGHTNESS            2018//÷ʱLED
#define NET_DVR_SET_LED_TIMER_BRIGHTNESS            2019//ȡʱLED
#define NET_DVR_LED_CHECKTIME                        2020//LEDУʱ
#define NET_DVR_GET_ALARMHOST_AUDIO_ASSOCIATE_ALARM    2021//ȡƵ汨¼
#define NET_DVR_SET_ALARMHOST_AUDIO_ASSOCIATE_ALARM    2022//Ƶ汨¼
#define    NET_DVR_GET_LED_STATUS                        2023//ȡLED״̬
#define NET_DVR_CLOSE_SUBSYSTEM_FAULT_ALARM         2027//رϵͳʾ
#define NET_DVR_SET_SUBSYSTEM_BYPASS                2028//ϵͳ·
#define NET_DVR_CANCEL_SUBSYSTEM_BYPASS                2029//ϵͳ·ָ

#define NET_DVR_GET_ALARMHOST_SUBSYSTEM_CFG_EX        2030//ȡϵͳչ
#define    NET_DVR_SET_ALARMHOST_SUBSYSTEM_CFG_EX        2031//ϵͳչ
#define NET_DVR_GET_ALARMHOST_PRINTER_CFG            2032//ȡӡӡʹ
#define    NET_DVR_SET_ALARMHOST_PRINTER_CFG            2033//ôӡӡʹ
#define    NET_DVR_GET_ALARMHOST_ZONE_LIST_IN_SUBSYSTEM 2034//ȡָϵͳڵз
#define    NET_DVR_GET_ALARMHOST_TRIGGER_LIST            2035//ȡд
#define    NET_DVR_ARM_ALARMHOST_SUBSYSTEM                2036//Ͷϵͳ
#define    NET_DVR_GET_ALARMHOST_EVENT_TRIG_ALARMOUT_CFG 2037// ȡ¼
#define NET_DVR_SET_ALARMHOST_EVENT_TRIG_ALARMOUT_CFG 2038// ¼
#define    NET_DVR_GET_ALARMHOST_FAULT_CFG                2039// ȡϴ
#define NET_DVR_SET_ALARMHOST_FAULT_CFG                2040// ùϴ
#define NET_DVR_SEARCH_ARMHOST_EXTERNAL_MODULE         2041//Զ
#define    NET_DVR_REGISTER_ALARMHOST_EXTERNAL_MODULE    2042//Զע
#define NET_DVR_CLOSE_ALARMHOST_OVERALL_FAULT_ALARM 2043//رȫֹʾ

#define NET_DVR_GET_SAFETYCABIN_WORK_MODE            2044 //ȡչģʽ
#define NET_DVR_SET_SAFETYCABIN_WORK_MODE            2045 //÷չģʽ
#define NET_DVR_GET_SAFETYCABIN_PERSON_SIGNAL_CFG   2046 //ȡź̽
#define NET_DVR_SET_SAFETYCABIN_PERSON_SIGNAL_CFG   2047 //÷ź̽

#define  NET_DVR_GET_ALARMHOST_MODULE_CFG            2048//ȡģϢ
//#define  NET_DVR_SET_ALARMHOST_MODULE_CFG            2049//ģϢ(Ԥ)

#define     NET_DVR_GET_ALARMHOST_EXTERNAL_DEVICE_STATE        2050//ȡ485豸״̬
#define  NET_DVR_SET_ALARMHOST_EXTERNAL_DEVICE_LIMIT_VALUE  2051//豸ֵ
#define  NET_DVR_GET_ALARMHOST_EXTERNAL_DEVICE_LIMIT_VALUE  2052//ȡ豸ֵ
#define  NET_DVR_GET_ALARMHOST_SENSOR_JOINT_CFG                2053// ȡģ
#define  NET_DVR_SET_ALARMHOST_SENSOR_JOINT_CFG                2054// ģ
#define     NET_DVR_SET_ALARMHOST_RS485_SLOT_CFG                2055// ñ485λ
#define  NET_DVR_GET_ALARMHOST_RS485_SLOT_CFG                2056// ȡ485λ

#define NET_DVR_GET_ALL_VARIABLE_INFO      2057   // ȡбԪϢ
#define NET_DVR_GET_ALARM_POINT_CFG       2058   // ȡϢ
#define NET_DVR_SET_ALARM_POINT_CFG       2059   // õϢ
#define NET_DVR_GET_HISTORY_VALUE          2060   // ȡʷ
#define NET_DVR_GET_ALARMHOST_ALARM_MODE  2061   // ȡϴʽ
#define NET_DVR_SET_ALARMHOST_ALARM_MODE  2062   // ϴʽ
#define NET_DVR_GET_ALARMHOST_SENSOR_VALUE 2063   // ȡģʵʱ

#define NET_DVR_GET_ALARMHOST_REPORT_CENTER_V40    2064   // ȡϴʽ
#define NET_DVR_SET_ALARMHOST_REPORT_CENTER_V40    2065   // ϴʽ
#define NET_DVR_GET_OUTPUT_SCHEDULE_RULECFG        2068   // ȡʱ
#define NET_DVR_SET_OUTPUT_SCHEDULE_RULECFG     2069   // ʱ
#define NET_DVR_GET_CMS_CFG                     2070
#define    NET_DVR_SET_CMS_CFG                        2071

#define NET_DVR_GET_PASSTHROUGH_CAP  2073  //ȡ豸͸

#define NET_DVR_GET_ALARMHOST_MAIN_STATUS_V40    2072   // ȡҪ״̬V40

/*************************************Ƶ1.3 begin*************************************/
#define NET_DVR_GET_ALARM_CAPTRUE_CFG                 2074    //ȡץͼ
#define    NET_DVR_SET_ALARM_CAPTRUE_CFG                2075    //ñץͼ
#define NET_DVR_GET_ONE_OUTPUT_SCH_RULECFG_V40        2078   // ȡʱV40
#define NET_DVR_SET_ONE_OUTPUT_SCH_RULECFG_V40        2079   // õʱV40
#define NET_DVR_GET_OUTPUT_SCHEDULE_RULECFG_V40        2080   // ȡʱV40
#define NET_DVR_SET_OUTPUT_SCHEDULE_RULECFG_V40     2081   // ʱV40
/*************************************Ƶ1.3 end**************************************/


#define NET_DVR_GET_WEEK_PLAN_CFG               2100    //ȡ״̬ܼƻ
#define NET_DVR_SET_WEEK_PLAN_CFG               2101    //״̬ܼƻ
#define NET_DVR_GET_DOOR_STATUS_HOLIDAY_PLAN    2102    //ȡ״̬ռƻ
#define NET_DVR_SET_DOOR_STATUS_HOLIDAY_PLAN    2103    //״̬ռƻ
#define NET_DVR_GET_DOOR_STATUS_HOLIDAY_GROUP   2104    //ȡ״̬
#define NET_DVR_SET_DOOR_STATUS_HOLIDAY_GROUP   2105    //״̬
#define NET_DVR_GET_DOOR_STATUS_PLAN_TEMPLATE   2106    //ȡ״̬ƻģ
#define NET_DVR_SET_DOOR_STATUS_PLAN_TEMPLATE   2107    //״̬ƻģ
#define NET_DVR_GET_DOOR_CFG                    2108    //ȡŲ
#define NET_DVR_SET_DOOR_CFG                    2109    //Ų
#define NET_DVR_GET_DOOR_STATUS_PLAN            2110    //ȡ״̬ƻ
#define NET_DVR_SET_DOOR_STATUS_PLAN            2111    //״̬ƻ
#define NET_DVR_GET_GROUP_CFG                   2112    //ȡȺ
#define NET_DVR_SET_GROUP_CFG                   2113    //Ⱥ
#define NET_DVR_GET_MULTI_CARD_CFG              2114    //ȡؿ
#define NET_DVR_SET_MULTI_CARD_CFG              2115    //öؿ
#define NET_DVR_GET_CARD_CFG                    2116    //ȡ
#define NET_DVR_SET_CARD_CFG                    2117    //ÿ
#define NET_DVR_CLEAR_ACS_PARAM                    2118    //Ž
#define NET_DVR_GET_SNEAK_CFG                    2119    //ȡǱز
#define NET_DVR_SET_SNEAK_CFG                   2120    //÷Ǳز
#define NET_DVR_GET_MULTI_DOOR_INTERLOCK_CFG    2121    //ȡŻ
#define NET_DVR_SET_MULTI_DOOR_INTERLOCK_CFG    2122    //öŻ
#define NET_DVR_GET_ACS_WORK_STATUS                2123    //ȡŽ״̬
#define NET_DVR_GET_VERIFY_WEEK_PLAN            2124    //ȡ֤ʽܼƻ
#define NET_DVR_SET_VERIFY_WEEK_PLAN            2125    //ö֤ʽܼƻ
#define NET_DVR_GET_CARD_RIGHT_WEEK_PLAN        2126    //ȡȨܼƻ
#define NET_DVR_SET_CARD_RIGHT_WEEK_PLAN        2127    //ÿȨܼƻ
#define NET_DVR_GET_VERIFY_HOLIDAY_PLAN         2128    //ȡ֤ʽռƻ
#define NET_DVR_SET_VERIFY_HOLIDAY_PLAN         2129    //ö֤ʽռƻ
#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_PLAN     2130    //ȡȨ޼ռƻ
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_PLAN     2131    //ÿȨ޼ռƻ
#define NET_DVR_GET_VERIFY_HOLIDAY_GROUP        2132    //ȡ֤ʽ
#define NET_DVR_SET_VERIFY_HOLIDAY_GROUP        2133    //ö֤ʽ
#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_GROUP    2134    //ȡȨ޼
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_GROUP    2135    //ÿȨ޼
#define NET_DVR_GET_VERIFY_PLAN_TEMPLATE        2136    //ȡ֤ʽƻģ
#define NET_DVR_SET_VERIFY_PLAN_TEMPLATE        2137    //ö֤ʽƻģ
#define NET_DVR_GET_CARD_RIGHT_PLAN_TEMPLATE    2138    //ȡȨ޼ƻģ
#define NET_DVR_SET_CARD_RIGHT_PLAN_TEMPLATE    2139    //ÿȨ޼ƻģ
#define NET_DVR_GET_CARD_READER_CFG                2140    //ȡ
#define NET_DVR_SET_CARD_READER_CFG             2141    //ö
#define NET_DVR_GET_CARD_READER_PLAN            2142    //ȡ֤ƻ
#define NET_DVR_SET_CARD_READER_PLAN            2143    //ö֤ƻ
#define NET_DVR_GET_CASE_SENSOR_CFG                2144    //ȡ¼
#define NET_DVR_SET_CASE_SENSOR_CFG             2145    //¼
#define NET_DVR_GET_CARD_READER_ANTI_SNEAK_CFG  2146    //ȡǱز
#define NET_DVR_SET_CARD_READER_ANTI_SNEAK_CFG  2147    //öǱز
#define NET_DVR_GET_PHONE_DOOR_RIGHT_CFG        2148    //ȡֻȨ޲
#define NET_DVR_SET_PHONE_DOOR_RIGHT_CFG        2149    //ȡֻȨ޲
#define NET_DVR_GET_FINGERPRINT_CFG             2150    //ȡָƲ
#define NET_DVR_SET_FINGERPRINT_CFG             2151    //ָƲ
#define NET_DVR_DEL_FINGERPRINT_CFG             2152    //ɾָƲ
#define NET_DVR_GET_EVENT_CARD_LINKAGE_CFG      2153    //ȡ¼ò
#define NET_DVR_SET_EVENT_CARD_LINKAGE_CFG      2154    //¼ò
#define NET_DVR_GET_ANTI_SNEAK_HOST_CFG            2155    //ȡ鷴Ǳز
#define NET_DVR_SET_ANTI_SNEAK_HOST_CFG         2156    //鷴Ǳز
#define NET_DVR_GET_READER_ANTI_SNEAK_HOST_CFG  2157    //ȡǱز
#define NET_DVR_SET_READER_ANTI_SNEAK_HOST_CFG  2158    //Ǳز
#define NET_DVR_GET_ACS_CFG                     2159    //ȡŽ
#define NET_DVR_SET_ACS_CFG                     2160    //Ž
#define NET_DVR_GET_CARD_PASSWD_CFG                2161    //ȡ뿪ʹ
#define NET_DVR_SET_CARD_PASSWD_CFG             2162    //ÿ뿪ʹ
#define NET_DVR_GET_CARD_USERINFO_CFG           2163    //ȡŹûϢ
#define NET_DVR_SET_CARD_USERINFO_CFG           2164    //ÿŹûϢ

#define NET_DVR_GET_ACS_EXTERNAL_DEV_CFG        2165    //ȡŽ
#define NET_DVR_SET_ACS_EXTERNAL_DEV_CFG        2166    //Ž
#define NET_DVR_GET_PERSONNEL_CHANNEL_CFG       2167    //ȡԱͨ
#define NET_DVR_SET_PERSONNEL_CHANNEL_CFG       2168    //Աͨ
#define NET_DVR_SET_PLATFORM_VERIFY_CFG         2169    //·ƽ̨֤
#define NET_DVR_GET_PERSON_STATISTICS_CFG        2170   //ȡͳƲ
#define NET_DVR_SET_PERSON_STATISTICS_CFG        2171   //ͳƲ
#define NET_DVR_GET_ACS_SCREEN_DISPLAY_CFG        2172   //ȡĻַʾ
#define NET_DVR_SET_ACS_SCREEN_DISPLAY_CFG        2173   //Ļַʾ
#define NET_DVR_GET_GATE_TIME_CFG               2174  //ȡԱͨբʱ
#define NET_DVR_SET_GATE_TIME_CFG               2175  //Աͨբʱ



#define NET_DVR_GET_SAFETYCABIN_STATE            2197    //ȡ״̬
#define NET_DVR_GET_RS485_CASCADE_CFG            2198   //ȡRs485豸
#define NET_DVR_SET_RS485_CASCADE_CFG            2199   //Rs485豸

/*************************************Ƶ2.0 begin*************************************/
#define NET_DVR_GET_REMOTECONTROLLER_PERMISION_CFG        2200    //ȡңȨ޲
#define NET_DVR_SET_REMOTECONTROLLER_PERMISION_CFG        2201    //ңȨ޲
#define NET_DVR_GET_KEYBOARD_CFG                        2202    //ȡ̲
#define NET_DVR_SET_KEYBOARD_CFG                        2203    //ü̲
#define    NET_DVR_GET_ALARMHOST_WIRELESS_BUSINNESS_INFO    2204    //ҵѯ
#define    NET_DVR_GET_ALL_REMOTECONTROLLER_LIST            2205    //ȡң
#define    NET_DVR_GET_PREVIEW_DELAY_CFG                    2206    //ȡӳԤ
#define    NET_DVR_SET_PREVIEW_DELAY_CFG                    2207    //ӳԤ
#define NET_DVR_GET_ZONE_CHANNEL_LINKAGE_CFG            2208    //ȡƵͨ
#define NET_DVR_SET_ZONE_CHANNEL_LINKAGE_CFG            2209    //÷Ƶͨ
#define NET_DVR_GET_CENTER_SERVER_CFG                    2210    //ȡķ
#define NET_DVR_SET_CENTER_SERVER_CFG                    2211    //ñķ
/*************************************Ƶ2.0 end**************************************/

/********************************һʽƷV1.0.0 begin********************************/
#define NET_DVR_GET_EMERGENCE_ALARM_PRODUCT_CAP            2212    //ȡһʽƷ
#define NET_DVR_GET_CALL_WAITTING_CFG_CAP                2213    //ȡеȴ
#define NET_DVR_GET_CALL_WAITTING_CFG                    2214    //ȡеȴ
#define NET_DVR_SET_CALL_WAITTING_CFG                    2215    //úеȴ
#define NET_DVR_GET_ALARM_LAMP_CFG_CAP                    2216    //ȡƲ
#define NET_DVR_GET_ALARM_LAMP_CFG                        2217    //ȡƲ
#define NET_DVR_SET_ALARM_LAMP_CFG                        2218    //þƲ
#define NET_DVR_GET_VOICE_PROMPTION_CFG_CAP                2219    //ȡʾ
#define NET_DVR_GET_VOICE_PROMPTION_CFG                    2220    //ȡʾ
#define NET_DVR_SET_VOICE_PROMPTION_CFG                    2221    //ʾ
#define NET_DVR_GET_EMERGENCE_ALARM_RESPONSE_CAP        2222    //ȡ
#define NET_DVR_EMERGENCE_ALARM_RESPONSE_CTRL            2223    //
/********************************һʽƷV1.0.0 end**********************************/

//籨 V2.2
#define NET_DVR_GET_ALARMHOST_NETCFG_V50                2224    //ȡV50
#define NET_DVR_SET_ALARMHOST_NETCFG_V50                2225    //ñV50
#define    NET_DVR_REGISTER_ALARM_RS485                    2226    //RS485ע
/**********************************V3.0****************************************/
#define NET_DVR_GET_ALL_ALARM_RS485CFG            2705    // ȡ485
#define NET_DVR_GET_ALL_ALARMHOST_RS485_SLOT_CFG        2706        // ȡб485λ
#define NET_DVR_GET_DEVICE_SELF_CHECK_STATE        2707    //ȡ豸Լ칦
#define NET_DVR_GET_ALL_ALARM_POINT_CFG            2708    // ȡеŲ
#define NET_DVR_GET_ALL_ALARM_SENSOR_CFG        2709    // ȡģ
#define NET_DVR_GET_ALL_ALARM_SENSOR_JOINT        2710    //ȡģ
#define NET_DVR_GET_AIR_CONDITION_PARAM            2711    //ȡյ
#define NET_DVR_GET_OUT_SCALE_CFG                2712        //ȡ
#define NET_DVR_SET_OUT_SCALE_CFG                2713        //
#define NET_DVR_GET_ALARM_CHAN_ABLITITY            2714        //ȡͨ
/**********************************V3.0****************************************/

//D2000 V1.0
#define NET_DVR_GET_ALARMCENTER_NETCFG            2715        //ȡ
#define NET_DVR_SET_ALARMCENTER_NETCFG            2716        //ȡ


#define NET_ITC_GET_TRIGGERCFG                  3003  //ȡ
#define NET_ITC_SET_TRIGGERCFG                  3004  //ô
#define NET_ITC_GET_IOOUT_PARAM_CFG                3005  //ȡIO3.1֮汾
#define NET_ITC_SET_IOOUT_PARAM_CFG                3006  //IO3.1֮汾

#define NET_DVR_GET_CAMERA_SETUPCFG                3007  //ȡ
#define NET_DVR_SET_CAMERA_SETUPCFG                3008  //

#define NET_ITC_GET_TRIGGER_DEFAULTCFG          3013  //ȡģʽƼ
#define NET_DVR_GET_STATUS_DETECTCFG            3015  //ȡ״̬ʹܲ
#define NET_DVR_SET_STATUS_DETECTCFG            3016  //״̬ʹܲ
#define NET_ITC_GET_VIDEO_TRIGGERCFG            3017  //ȡƵ羯
#define NET_ITC_SET_VIDEO_TRIGGERCFG            3018  //Ƶ羯
#define NET_DVR_GET_TPS_ALARMCFG                3019  //ȡͨͳƱ
#define NET_DVR_SET_TPS_ALARMCFG                3020  //ýͨͳƱ


#define NET_DVR_GET_REDAREACFG                  3100   //ȡ̵
#define NET_DVR_SET_REDAREACFG                  3101   //ú̵
#define    NET_DVR_GET_TEST_SPOT                    3102   //ȡSPOTڲܲ͵ǰڼ
#define    NET_DVR_SET_TEST_SPOT                    3103   //SPOTڲܲ͵ǰڼ
#define NET_DVR_GET_CABINETCFG                    3104   //ûȡ
#define NET_DVR_SET_CABINETCFG                    3105   //
#define NET_DVR_VEHICLE_CHECK_START                3106   //ݻش
#define NET_DVR_SET_CAPTUREPIC_CFG                3107   //ץͼ
#define NET_DVR_GET_CAPTUREPIC_CFG                3108   //ץͼûȡ
#define NET_DVR_SET_MOBILEPLATE_RECOG_CFG        3109   //سʶ
#define NET_DVR_GET_MOBILEPLATE_RECOG_CFG        3110   //سʶûȡ
#define NET_DVR_SET_MOBILE_RADAR_CFG            3111   //״
#define NET_DVR_GET_MOBILE_RADAR_CFG            3112   //״ûȡ
#define NET_DVR_SET_MOBILE_LOCALPLATECHK_CFG    3113   //غضԱ
#define NET_DVR_GET_MOBILE_LOCALPLATECHK_CFG    3114   //غضԱûȡ

#define  NET_ITC_GET_ICRCFG                        3115   //ȡICRл
#define  NET_ITC_SET_ICRCFG                        3116   //ICRл
#define  NET_ITC_GET_RS485_ACCESSINFO            3117   //ȡRs485豸Ϣ 
#define  NET_ITC_SET_RS485_ACCESSINFO            3118   //Rs485豸Ϣ
#define  NET_ITC_GET_EXCEPTIONCFG                 3119   //ȡ쳣
#define  NET_ITC_SET_EXCEPTIONCFG                3120   //쳣
#define  NET_ITC_GET_FTPCFG                        3121   //ȡITC  FTPò
#define  NET_ITC_SET_FTPCFG                        3122   //ITC FTPò

#define  NET_DVR_VEHICLE_CONTROL_LIST_START     3123   //óڰϢ
#define  NET_DVR_GET_ALL_VEHICLE_CONTROL_LIST   3124   //ȡгڰϢ
#define  NET_DVR_VEHICLE_DELINFO_CTRL           3125   //ɾ豸ںݿϢ
#define  NET_DVR_GET_ENTRANCE_PARAMCFG            3126   //ȡڿƲ
#define  NET_DVR_SET_ENTRANCE_PARAMCFG            3127   //óڿƲ
#define  NET_DVR_BARRIERGATE_CTRL               3128   //Զ̿Ƶբ
#define  NET_DVR_GATELAMP_CTRL                  3129   //ƹ
#define  NET_DVR_GET_CURTRIGGERMODE             3130   //ȡ豸ǰģʽ
#define  NET_DVR_GET_GPSDATACFG                    3131   //ȡGPS
#define  NET_DVR_SET_GPSDATACFG                    3132   //GPS
#define  NET_DVR_VEHICLELIST_CTRL_START            3133   //óڰϢ

#define  NET_DVR_GET_GUARDCFG                   3134   //ȡʶƻ 
#define  NET_DVR_SET_GUARDCFG                   3135   //óʶƻ
#define  NET_DVR_GET_SNAPINFO_CFG               3136   //ȡץͼƬ 
#define  NET_DVR_SET_SNAPINFO_CFG               3137   //ץͼƬ
#define  NET_DVR_GET_SNAPINFO_CFG_V40           3138   //ȡץͼƬչ 
#define  NET_DVR_SET_SNAPINFO_CFG_V40           3139   //ץͼƬչ
#define  NET_DVR_SET_CURTRIGGERMODE                3140   //豸ǰģʽ(IPC/D֧)
#define     NET_DVR_GET_TRAFFIC_DATA                3141   //ӻȡͨ
#define     NET_DVR_GET_TRAFFIC_FLOW                3142   //ӻȡͨ
#define  NET_DVR_PARKING_VEHICLE_SEND           3143   //ͣϢ·
#define  NET_DVR_PARKING_CARD_SEND              3144   //ͣ·
#define     NET_DVR_PARKING_CARD_CTRL                3145   //ͣͣƽӿ

#define    NET_DVR_GET_ALARMCTRL_CAPABILITIES        3146   //ȡ
#define    NET_DVR_SET_ALARMCTRL_CFG                3147   //ñ
#define    NET_DVR_GET_ALARMCTRL_CFG                3148   //ȡ

#define NET_DVR_GET_AUDIO_INPUT                 3201   //ȡƵ
#define NET_DVR_SET_AUDIO_INPUT                 3202  //Ƶ
#define NET_DVR_GET_CAMERA_DEHAZE_CFG           3203   //ȡ͸
#define NET_DVR_SET_CAMERA_DEHAZE_CFG           3204  //͸
#define NET_DVR_REMOTECONTROL_ALARM             3205  //Զ̿ң
#define NET_DVR_REMOTECONTROL_DISALARM          3206  //Զ̿ң
#define NET_DVR_REMOTECONTROL_STUDY             3207  //Զ̿ңѧϰ
#define NET_DVR_WIRELESS_ALARM_STUDY            3208  //Զ̿߱ѧϰ
#define NET_IPC_GET_AUX_ALARMCFG                3209   //ȡ
#define NET_IPC_SET_AUX_ALARMCFG                3210  //ø
#define NET_DVR_GET_PREVIEW_DISPLAYCFG            3211  //ȡԤʾ
#define NET_DVR_SET_PREVIEW_DISPLAYCFG             3212  //Ԥʾ
#define NET_DVR_REMOTECONTROL_PTZ                3213  //Զ̿PTZ
#define NET_DVR_REMOTECONTROL_PRESETPOINT       3214   //Զ̿Ԥõ
#define NET_DVR_REMOTECONTROL_CRUISE             3215   //Զ̿Ѳ

#define NET_DVR_GET_MULTI_STREAM_COMPRESSIONCFG  3216 //Զ̻ȡѹ
#define NET_DVR_SET_MULTI_STREAM_COMPRESSIONCFG  3217 //Զöѹ 

#define NET_DVR_GET_WPSCFG                        3218  //ȡWPS
#define NET_DVR_SET_WPSCFG                        3219  //WPS
#define NET_DVR_WPS_CONNECT                     3220  //ԶWPS
#define NET_DVR_GET_DEVICE_PIN                  3221  //ȡ豸PIN
#define NET_DVR_UPDATE_PIN                      3223  //豸PIN
#define NET_DVR_GET_PRESETCFG                   3224  //ȡԤõ
#define NET_DVR_GET_PTZCRUISECFG                3225  //ȡѲ·
#define NET_DVR_GET_PRESET_NUM                    3226  //ȡԤõ
#define NET_DVR_GET_PTZCRUISE_NUM                3227  //ȡѲ·

#define NET_DVR_GET_MOTION_TRACK_CFG            3228  //ȡٲ
#define NET_DVR_SET_MOTION_TRACK_CFG            3229  //øٲ
#define NET_DVR_CLEAR_IPC_PARAM                    3230  //ǰ˲
#define NET_DVR_GET_IPADDR_FILTERCFG            3232  //ȡIPַ˲
#define NET_DVR_SET_IPADDR_FILTERCFG            3233  //IPַ˲

#define NET_DVR_GET_LOGO_OVERLAYCFG                3234  //ȡLOGOͼƬӲ 
#define NET_DVR_SET_LOGO_OVERLAYCFG                3235  //LOGOͼƬӲ

#define NET_DVR_GET_IPV6_LIST                   3236  //ȡȫIPV6ַϢ
#define NET_DVR_GET_AUDIOOUT_VOLUME             3237  //ȡƵС
#define NET_DVR_SET_AUDIOOUT_VOLUME             3238  //ƵС
#define NET_DVR_GET_FUZZY_UPGRADE               3239  //ȡģƥϢ

#define NET_DVR_GET_BV_CORRECT_PARAM            3240  //ȡУ
#define NET_DVR_SET_BV_CORRECT_PARAM            3241  //У
#define NET_DVR_GET_OUTPUT_VIDEO_TYPE           3242  //ȡƵ
#define NET_DVR_SET_OUTPUT_VIDEO_TYPE           3243  //Ƶ

#define NET_DVR_FISHEYE_CFG                     3244  //۳
#define NET_DVR_GET_PTZ_POINT                   3245  //ȡPTZ
#define NET_DVR_SET_PTZ_POINT                   3246  //PTZ
#define NET_DVR_REMOTECONTROL_DEV_PARAM         3247  //豸¼ͻ˲
#define NET_DVR_GET_FISHEYE_STREAM_STATUS       3248  //ȡ״̬

#define NET_DVR_GET_GBT28181_ACCESS_CFG            3249  //ȡGBT28181Э        
#define NET_DVR_SET_GBT28181_ACCESS_CFG            3250  //GBT28181Э
#define NET_DVR_GET_GBT28181_CHANINFO_CFG        3251  //ȡGBT28181Э豸ͨϢ
#define NET_DVR_SET_GBT28181_CHANINFO_CFG        3252  //GBT28181Э豸ͨϢ
#define NET_DVR_GET_GBT28181_ALARMINCFG            3253  //ȡGBT28181Э豸ıϢ
#define NET_DVR_SET_GBT28181_ALARMINCFG            3254  //GBT28181Э豸ıϢ
#define NET_DVR_GET_ISP_CAMERAPARAMCFG            3255  //ȡISPǰ˲
#define NET_DVR_SET_ISP_CAMERAPARAMCFG            3256  //ISPǰ˲
#define NET_DVR_GET_DEVSERVER_CFG                3257  //ȡģ
#define NET_DVR_SET_DEVSERVER_CFG                3258  //ģ

//2013-11-25
#define    NET_DVR_GET_WIPERINFO_CFG                3259     //ˢûȡ
#define    NET_DVR_SET_WIPERINFO_CFG                3260     //ˢ
#define NET_DVR_GET_TRACK_DEV_PARAM             3261   //ȡ豸
#define NET_DVR_SET_TRACK_DEV_PARAM             3262   //ø豸
#define NET_DVR_GET_PTZ_TRACK_PARAM             3263   //ȡPTZٲ
#define NET_DVR_SET_PTZ_TRACK_PARAM             3264   //PTZٲ
#define NET_DVR_GET_CENTER_POINT_CFG            3265   //ȡĵ
#define NET_DVR_SET_CENTER_POINT_CFG            3266   //ĵ
#define NET_DVR_GET_CENTER_POINT_CFG_CAPABILITIES        3267    //ȡĵ
#define NET_DVR_GET_FISHEYE_CAPABILITIES        3268        //ȡ

#define NET_DVR_GET_BASICPARAMCFG                3270 //ȡPTZûϢ        
#define NET_DVR_SET_BASICPARAMCFG                3271 //PTZûϢ
#define NET_DVR_GET_PTZOSDCFG                    3272 //ȡPTZ OSDòϢ        
#define NET_DVR_SET_PTZOSDCFG                    3273 //PTZ OSDòϢ
#define NET_DVR_GET_POWEROFFMEMCFG                3274 //ȡģʽϢ    
#define NET_DVR_SET_POWEROFFMEMCFG                3275 //õģʽϢ
#define NET_DVR_GET_LIMITCFG                    3276 //ȡλϢ    
#define NET_DVR_SET_LIMITCFG                    3277 //λϢ
#define NET_DVR_PTZLIMIT_CTRL                    3278 //λ    

#define NET_DVR_PTZ_CLEARCTRL                    3279 //Ϣƽӿ    
#define NET_DVR_GET_PRIORITIZECFG                3281 //ȡ̨Ϣ    
#define NET_DVR_SET_PRIORITIZECFG                3282 //̨Ϣ
#define NET_DVR_PTZ_INITIALPOSITIONCTRL            3283 //㷽λǿ    
#define NET_DVR_GET_PRIVACY_MASKSCFG            3285 //ȡ˽ڱβ
#define NET_DVR_SET_PRIVACY_MASKSCFG            3286 //˽ڱβ
#define NET_DVR_GET_PTZLOCKCFG                    3287 //ȡ̨Ϣ    
#define NET_DVR_SET_PTZLOCKCFG                    3288 //̨Ϣ
#define NET_DVR_PTZ_ZOOMRATIOCTRL                3289 //øٱ    
#define NET_DVR_GET_PTZLOCKINFO                    3290 //ȡ̨ʣ
#define NET_DVR_GET_PRIVACY_MASKS_ENABLECFG        3291 //ȡȫʹ    
#define NET_DVR_SET_PRIVACY_MASKS_ENABLECFG        3292 //ȫʹ
#define NET_DVR_GET_SMARTTRACKCFG                3293 //ȡ˶Ϣ    
#define NET_DVR_SET_SMARTTRACKCFG                3294 //˶Ϣ
#define NET_DVR_GET_EPTZ_CFG                    3295 //ȡEPTZ
#define NET_DVR_SET_EPTZ_CFG                    3296 //EPTZ
#define NET_DVR_GET_EPTZ_CFG_CAPABILITIES        3297 //ȡEPTZ

#define NET_DVR_GET_LOW_LIGHTCFG                3303//ȡնϢ
#define NET_DVR_SET_LOW_LIGHTCFG                3304//ÿնϢ
#define NET_DVR_GET_FOCUSMODECFG                3305//ȡ۽ģʽϢ
#define NET_DVR_SET_FOCUSMODECFG                3306//ÿ۽ģʽϢ
#define NET_DVR_GET_INFRARECFG                  3307//ȡϢ
#define NET_DVR_SET_INFRARECFG                  3308//ÿϢ
#define NET_DVR_GET_AEMODECFG                   3309//ȡϢ
#define NET_DVR_SET_AEMODECFG                   3310//ÿϢ
#define NET_DVR_CONTROL_RESTORE_SUPPORT         3311 //ָǰĬϲ(еǰ˲صĶָ)
#define NET_DVR_CONTROL_RESTART_SUPPORT         3312 //о
#define NET_DVR_CONTROL_PTZ_PATTERN             3313//̨ɨ
#define NET_DVR_GET_PTZ_PARKACTION_CFG          3314//ȡ̨
#define NET_DVR_SET_PTZ_PARKACTION_CFG          3315//̨
#define NET_DVR_CONTROL_PTZ_MANUALTRACE         3316//ֶٶλ
#define NET_DVR_GET_ROI_DETECT_NUM                3349 //ȡROIĿ
#define NET_DVR_GET_ROI_DETECT                    3350 //ȡROI
#define NET_DVR_SET_ROI_DETECT                    3351 //ROI
#define NET_DVR_GET_FACE_DETECT                    3352 //ȡ
#define NET_DVR_SET_FACE_DETECT                    3353 //
#define NET_DVR_GET_CORRIDOR_MODE                3354 //ȡģʽ
#define NET_DVR_SET_CORRIDOR_MODE                3355 //ģʽ
#define NET_DVR_GET_SCENECHANGE_DETECTIONCFG    3356 //ȡ
#define NET_DVR_SET_SCENECHANGE_DETECTIONCFG    3357 //ó
#define NET_DVR_GET_TRAVERSE_PLANE_DETECTION    3360 
#define NET_DVR_SET_TRAVERSE_PLANE_DETECTION    3361 
#define NET_DVR_GET_FIELD_DETECTION                3362 //ȡ
#define NET_DVR_SET_FIELD_DETECTION                3363 //
#define NET_DVR_GET_DEFOCUSPARAM                3364 //ȡ齹
#define NET_DVR_SET_DEFOCUSPARAM                3365 //齹
#define NET_DVR_GET_AUDIOEXCEPTIONPARAM            3366 //ȡƵ쳣
#define NET_DVR_SET_AUDIOEXCEPTIONPARAM            3367 //Ƶ쳣
#define NET_DVR_GET_CCDPARAMCFG_EX              3368 //ȡCCD
#define NET_DVR_SET_CCDPARAMCFG_EX              3369 //CCD
#define NET_DVR_START_GET_INPUTVOLUME            3370//ʼȡ
#define NET_DVR_SET_SCH_TASK                    3380 //ʱ
#define NET_DVR_GET_SCH_TASK                    3381  //ȡʱ
#define NET_DVR_SET_PRESET_NAME                    3382 //Ԥõ
#define NET_DVR_GET_PRESET_NAME                    3383 //ȡԤõ
#define NET_DVR_SET_AUDIO_NAME                    3384 //
#define NET_DVR_GET_AUDIO_NAME                    3385  //ȡ
#define NET_DVR_RESUME_INITRACKPOS              3386  //ָٳʼλ
#define NET_DVR_NTP_SERVER_TEST                    3387    //NTP
#define    NET_DVR_NAS_SERVER_TEST                    3388    //NAS
#define    NET_DVR_EMAIL_SERVER_TEST                3389    //Email
#define    NET_DVR_FTP_SERVER_TEST                    3390    //FTP
#define    NET_DVR_IP_TEST                            3391    //IP
#define NET_DVR_GET_NET_DISKCFG_V40             3392 //Ӳ̽ȡv40
#define NET_DVR_SET_NET_DISKCFG_V40                3393 //Ӳ̽v40
#define    NET_DVR_GET_IOOUT_CFG                    3394//ȡƲ
#define    NET_DVR_SET_IOOUT_CFG                    3395//òƲ
#define    NET_DVR_GET_SIGNAL_SYNC                    3396//ȡźŵͬò
#define    NET_DVR_SET_SIGNAL_SYNC                    3397//źŵͬò    

#define    NET_DVR_GET_EZVIZ_ACCESS_CFG            3398//ȡEZVIZ
#define    NET_DVR_SET_EZVIZ_ACCESS_CFG            3399//EZVIZ
#define    NET_DVR_GET_SCHEDULE_AUTO_TRACK_CFG        3400//ȡʱܸٲ
#define    NET_DVR_SET_SCHEDULE_AUTO_TRACK_CFG        3401//öʱܸٲ
#define    NET_DVR_MAKE_I_FRAME                    3402//ǿI֡
#define NET_DVR_GET_ALARM_RELATE                3403//ȡͨܲ
#define NET_DVR_SET_ALARM_RELATE                3404//ñͨܲ
#define NET_DVR_GET_PDC_RULECFG_V42             3405  //ͳƹ(չ)
#define NET_DVR_SET_PDC_RULECFG_V42             3406  //ȡͳƹ(չ)
#define NET_DVR_GET_HEATMAP_CFG                 3407  //ȶͼ
#define NET_DVR_SET_HEATMAP_CFG                 3408  //ȡȶͼ
#define NET_DVR_REMOTECONTROL_LINEARSCAN        3409   //ұ߽ 2014-03-15
#define NET_DVR_DPC_CTRL                        3410//У
#define NET_DVR_FFC_MANUAL_CTRL                 3411//ǾУ(FFC)ֶģʽ
#define NET_DVR_FFC_BACKCOMP_CTRL               3412//ǾУ(FFC)
#define NET_DVR_GET_FOCUSING_POSITION_STATE     3413//ȡ۽λ״̬
#define NET_DVR_GET_PRIVATE_PROTOCOL_CFG        3414   //ȡ ˽йؼϢϴýӿ
#define NET_DVR_SET_PRIVATE_PROTOCOL_CFG        3415   // ˽йؼϢϴýӿ
#define NET_DVR_COMPLETE_RESTORE_CTRL           3420    //ȫֵָ

#define NET_DVR_CLOUDSTORAGE_SERVER_TEST        3421  //ƴ洢
#define NET_DVR_PHONE_NUM_TEST                  3422  //绰
#define NET_DVR_GET_REMOTECONTROL_STATUS        3423  //ȡ߲״̬
#define NET_DVR_GET_MONITOR_LOCATION_INFO        3424  //ȡϢ
#define NET_DVR_SET_MONITOR_LOCATION_INFO        3425  //üϢ


#define    NET_DVR_GET_SMART_CAPABILITIES                3500    //ȡSmart
#define    NET_DVR_GET_EVENT_TRIGGERS_CAPABILITIES        3501    //ȡ¼
#define    NET_DVR_GET_REGION_ENTRANCE_CAPABILITIES    3502    //ȡ
#define    NET_DVR_GET_REGION_ENTR_DETECTION            3503    //ȡ
#define    NET_DVR_SET_REGION_ENTR_DETECTION            3504    //ý
#define    NET_DVR_GET_REGION_ENTR_REGION                3505    //ȡĵ
#define    NET_DVR_SET_REGION_ENTR_REGION                3506    //ýĵ
#define    NET_DVR_GET_REGION_ENTR_TRIGGER                3507    //ȡ
#define    NET_DVR_SET_REGION_ENTR_TRIGGER                3508    //ý
#define    NET_DVR_GET_REGION_ENTR_SCHEDULE            3509    //ȡ򲼷ʱ
#define    NET_DVR_SET_REGION_ENTR_SCHEDULE            3510    //ý򲼷ʱ
#define    NET_DVR_GET_REGION_EXITINT_CAPABILITIES        3511    //ȡ뿪
#define    NET_DVR_GET_REGION_EXITING_DETECTION        3512    //ȡ뿪
#define    NET_DVR_SET_REGION_EXITING_DETECTION        3513    //뿪
#define    NET_DVR_GET_REGION_EXITING_REGION            3514    //ȡ뿪ĵ
#define    NET_DVR_SET_REGION_EXITING_REGION            3515    //뿪ĵ
#define    NET_DVR_GET_REGION_EXIT_TRIGGER                3516    //ȡ뿪
#define    NET_DVR_SET_REGION_EXIT_TRIGGER                3517    //뿪
#define    NET_DVR_GET_REGION_EXIT_SCHEDULE            3518    //ȡ뿪򲼷ʱ
#define    NET_DVR_SET_REGION_EXIT_SCHEDULE            3519    //뿪򲼷ʱ
#define    NET_DVR_GET_LOITERING_CAPABILITIES            3520    //ȡǻ
#define    NET_DVR_GET_LOITERING_DETECTION                3521    //ȡǻ
#define    NET_DVR_SET_LOITERING_DETECTION                3522    //ǻ
#define    NET_DVR_GET_LOITERING_REGION                3523    //ȡǻĵ
#define    NET_DVR_SET_LOITERING_REGION                3524    //ǻĵ
#define    NET_DVR_GET_LOITERING_TRIGGER                3525    //ȡǻ
#define    NET_DVR_SET_LOITERING_TRIGGER                3526    //ǻ
#define    NET_DVR_GET_LOITERING_SCHEDULE                3527    //ȡǻʱ
#define    NET_DVR_SET_LOITERING_SCHEDULE                3528    //ǻʱ
#define    NET_DVR_GET_GROUPDETECTION_CAPABILITIES        3529    //ȡԱۼ
#define    NET_DVR_GET_GROUP_DETECTION                    3530    //ȡԱۼ
#define    NET_DVR_SET_GROUP_DETECTION                    3531    //Աۼ
#define    NET_DVR_GET_GROUPDETECTION_REGION            3532    //ȡԱۼĵ
#define    NET_DVR_SET_GROUPDETECTION_REGION            3533    //Աۼĵ
#define    NET_DVR_GET_GROUPDETECTION_TRIGGER            3534    //ȡԱۼ
#define    NET_DVR_SET_GROUPDETECTION_TRIGGER            3535    //Աۼ
#define    NET_DVR_GET_GROUPDETECTION_SCHEDULE            3536    //ȡԱۼʱ
#define    NET_DVR_SET_GROUPDETECTION_SCHEDULE            3537    //Աۼʱ
#define    NET_DVR_GET_RAPIDMOVE_CAPABILITIES            3538    //ȡ˶
#define    NET_DVR_GET_RAPIDMOVE_DETECTION                3539    //ȡ˶
#define    NET_DVR_SET_RAPIDMOVE_DETECTION                3540    //ÿ˶
#define    NET_DVR_GET_RAPIDMOVE_REGION                3541    //ȡ˶ĵ
#define    NET_DVR_SET_RAPIDMOVE_REGION                3542    //ÿ˶ĵ
#define    NET_DVR_GET_RAPIDMOVE_TRIGGER                3543    //ȡ˶
#define    NET_DVR_SET_RAPIDMOVE_TRIGGER                3544    //ÿ˶
#define    NET_DVR_GET_RAPIDMOVE_SCHEDULE                3545    //ȡ˶Ĳʱ
#define    NET_DVR_SET_RAPIDMOVE_SCHEDULE                3546    //ÿ˶Ĳʱ
#define    NET_DVR_GET_PATKING_CAPABILITIES            3547    //ȡͣ
#define    NET_DVR_GET_PARKING_DETECTION               3548    //ȡͣ
#define    NET_DVR_SET_PARKING_DETECTION                3549    //ͣ
#define    NET_DVR_GET_PARKING_REGION                    3550    //ȡͣĵ
#define    NET_DVR_SET_PARKING_REGION                    3551    //ͣĵ
#define    NET_DVR_GET_PARKING_TRIGGER                    3552    //ȡͣ
#define    NET_DVR_SET_PARKING_TRIGGER                    3553    //ͣ
#define    NET_DVR_GET_PARKING_SCHEDULE                3554    //ȡͣĲʱ
#define    NET_DVR_SET_PARKING_SCHEDULE                3555    //ͣĲʱ
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_CAPABILITIES    3556    //ȡƷ
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_DETECTION    3557    //ȡƷ
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_DETECTION    3558    //Ʒ
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_REGION        3559    //ȡƷĵ
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_REGION        3560    //Ʒĵ
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_TRIGGER        3561    //ȡƷ
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_TRIGGER        3562    //Ʒ
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_SCHEDULE        3563    //ȡƷĲʱ
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_SCHEDULE        3564    //ƷĲʱ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_CAPABILITIES    3565    //ȡƷȡ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_DETECTION        3566    //ȡƷȡ
#define    NET_DVR_SET_ATTENDEDBAGGAGE_DETECTION        3567    //Ʒȡ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_REGION            3568    //ȡƷȡĵ
#define    NET_DVR_SET_ATTENDEDBAGGAGE_REGION            3569    //Ʒȡĵ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_TRIGGER            3570    //ȡƷȡ
#define    NET_DVR_SET_ATTENDEDBAGGAGE_TRIGGER            3571    //Ʒȡ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_SCHEDULE        3572    //ȡƷĲʱ
#define    NET_DVR_SET_ATTENDEDBAGGAGE_SCHEDULE        3573    //ƷȡĲʱ
#define    NET_DVR_GET_REGIONCLIP_CAPABILITIES            3574    //ȡü
#define    NET_DVR_GET_REGION_CLIP                     3575    //ȡü
#define    NET_DVR_SET_REGION_CLIP                     3576    //ü
#define    NET_DVR_GET_NETWORK_CAPABILITIES            3577    //ȡ
#define    NET_DVR_GET_WIRELESS_DIAL                     3578    //ȡ߲
#define    NET_DVR_SET_WIRELESS_DIAL                     3579    //߲
#define    NET_DVR_GET_WIRELESSDIAL_CAPABILITIES        3580    //ȡ߲Ų
#define    NET_DVR_GET_WIRELESSDIAL_SCHEDULE            3581    //ȡżƻ
#define    NET_DVR_SET_WIRELESSDIAL_SCHEDULE            3582    //òżƻ
#define    NET_DVR_GET_WIRELESSDIAL_STATUS             3583    //ȡ״̬
#define    NET_DVR_GET_REGION_ENTRANCE_SCHEDULE_CAPABILITIES    3584    //ȡⲼʱ
#define    NET_DVR_GET_REGION_EXITING_SCHEDULE_CAPABILITIES    3585    //ȡ뿪Ⲽʱ
#define    NET_DVR_GET_LOITERING_SCHEDULE_CAPABILITIES    3586    //ȡǻⲼʱ
#define    NET_DVR_GET_GROUP_SCHEDULE_CAPABILITIES    3587    //ȡԱۼⲼʱ
#define    NET_DVR_GET_RAPIDMOVE_SCHEDULE_CAPABILITIES    3588    //ȡ˶Ⲽʱ
#define    NET_DVR_GET_PARKING_SCHEDULE_CAPABILITIES    3589    //ȡͣⲼʱ
#define    NET_DVR_GET_UNATTENDEDBAGGAGE_SCHEDULE_CAPABILITIES    3590    //ȡƷⲼʱ
#define    NET_DVR_GET_ATTENDEDBAGGAGE_SCHEDULE_CAPABILITIES    3591    //ȡƷȡⲼʱ
#define    NET_DVR_GET_WIRELESSDIAL_SCHEDULE_CAPABILITIES    3592    //ȡżƻ
#define    NET_DVR_WIRELESSDIAL_CONNECT    3593    //

#define    NET_DVR_GET_LITESTORAGE                    3594    //ȡ洢
#define    NET_DVR_SET_LITESTORAGE                    3595    //洢
#define    NET_DVR_GET_LITESTORAGE_CAPABILITIES    3596    //ȡ洢

#define    NET_DVR_GET_VEHICLE_CAPABILITIES    3597    //ȡ궨
#define    NET_DVR_GET_VEHICLE_CALIBRATION     3598    //ȡ궨

#define    NET_DVR_GET_SLAVECAMERA_CAPABILITIES    3599    //ȡIPϢ    
#define    NET_DVR_GET_SLAVECAMERA                    3600    //ȡIPϢ
#define    NET_DVR_SET_SLAVECAMERA                    3601    //ôIPϢ
#define    NET_DVR_GET_SLAVECAMERA_STATUS            3602    //ȡ״̬
#define    NET_DVR_GET_SLAVECAMERA_CALIB_CAPABILITIES    3603  //ȡ&&궨    
#define    NET_DVR_GET_SLAVECAMERA_CALIB            3604    //ȡ궨
#define    NET_DVR_SET_SLAVECAMERA_CALIB            3605    //ô궨
#define NET_DVR_GET_PHY_RATIO                    3606    //ȡϢ    
#define NET_DVR_SET_PHY_RATIO                    3607    //Ϣ
#define NET_DVR_GET_MASTERSLAVETRACKING_CAPABILITIES   3608  //ȡӸ
#define    NET_DVR_SET_TRACKINGRATIO                3610    //ôٱ
#define    NET_DVR_GET_TRACKING                    3611    //ȡӸٹ
#define    NET_DVR_SET_TRACKING                    3612    //Ӹٹ
#define    NET_DVR_GET_TRACKING_CAPABILITIES        3613    //ȡӸٹ

#define    NET_DVR_GET_SLAVECAMERA_CALIB_V50        3614    //ȡ궨V50
#define    NET_DVR_SET_SLAVECAMERA_CALIB_V50        3615    //ô궨V50
#define    NET_DVR_SET_TRACKINGRATIO_MANUAL        3616    //ôֶٱ
#define    NET_DVR_GET_TRACKINGRATIO_MANUAL        3617    //ȡֶٱ
#define    NET_DVR_SET_TRACK_INITPOSTION            3618    //ôʼλ
#define    NET_DVR_GET_PTZ_CAPABILITIES            3619    //ȡptz

#define    NET_DVR_GET_THERMOMETRY_BASICPARAM_CAPABILITIES    3620 //ȡ
#define    NET_DVR_GET_THERMOMETRY_BASICPARAM      3621    //ȡò
#define    NET_DVR_SET_THERMOMETRY_BASICPARAM        3622    //òò
#define    NET_DVR_GET_THERMOMETRY_SCENE_CAPABILITIES    3623 //ȡԤõ
#define    NET_DVR_GET_THERMOMETRY_PRESETINFO      3624    //ȡԤõò
#define    NET_DVR_SET_THERMOMETRY_PRESETINFO        3625    //òԤõò
#define    NET_DVR_GET_THERMOMETRY_ALARMRULE_CAPABILITIES    3626//ȡ±ʽ
#define    NET_DVR_GET_THERMOMETRY_ALARMRULE       3627    //ȡԤõ㱨ò
#define    NET_DVR_SET_THERMOMETRY_ALARMRULE        3628    //òԤõ㱨ò
#define    NET_DVR_GET_REALTIME_THERMOMETRY        3629    //ʵʱ¶ȼ
#define    NET_DVR_GET_THERMOMETRY_DIFFCOMPARISON  3630    //ȡԤõ²ò
#define    NET_DVR_SET_THERMOMETRY_DIFFCOMPARISON    3631    //òԤõ²ò
#define    NET_DVR_GET_THERMOMETRY_TRIGGER            3632    //ȡ
#define    NET_DVR_SET_THERMOMETRY_TRIGGER            3633    //ò

#define    NET_DVR_GET_THERMAL_CAPABILITIES        3634    //ȡȳThermal
#define    NET_DVR_GET_FIREDETECTION_CAPABILITIES    3635    //ȡ
#define    NET_DVR_GET_FIREDETECTION               3636    //ȡ
#define    NET_DVR_SET_FIREDETECTION               3637    //û
#define    NET_DVR_GET_FIREDETECTION_TRIGGER       3638    //ȡ
#define    NET_DVR_SET_FIREDETECTION_TRIGGER        3639    //û

#define    NET_DVR_GET_PXOFFLINE_CAPABILITIES      3652    //ȡͣƱѻ² 
#define    NET_DVR_SET_PXOFFLINE_CFG                3653    //ͣƱѻ²Ϣ
#define    NET_DVR_GET_PXOFFLINE_CFG                3654    //ȡͣƱѻ²Ϣ
#define    NET_DVR_GET_PAPERCHARGEINFO_CAPABILITIES  3655  //ȡֽͣƱϢ· 
#define    NET_DVR_SET_PAPERCHARGEINFO                3656    //ֽͣƱϢ·
#define    NET_DVR_GET_PARKINGSAPCE_CAPABILITIES    3657    //ȡͣͣλϢ· 
#define    NET_DVR_SET_PARKINGSAPCE_INFO            3658    //ͣͣλϢ·
#define    NET_DVR_GET_PXMULTICTRL_CAPABILITIES    3659    //ȡͣƱ豸ǶȲ 
#define    NET_DVR_GET_CHARGEACCOUNT_CAPABILITIES    3661    //ȡͣƱ
#define    NET_DVR_SET_CHARGE_ACCOUNTINFO          3662    //ýɷѽϢ
#define    NET_DVR_SET_PXMULTICTRL_CFG                3663    //ͣƱ豸ǶȲϢ
#define    NET_DVR_GET_PXMULTICTRL_CFG                3664    //ȡͣƱ豸ǶȲϢ
#define    NET_DVR_GET_TME_CHARGERULE              3665    //ȡͣڳշѹ
#define    NET_DVR_SET_TME_CHARGERULE                3666    //ͣڳշѹ
#define    NET_DVR_GET_TME_CHARGERULE_CAPABILITIES 3667    //ȡͣ շϢ
#define    NET_DVR_GET_ILLEGALCARDFILTERING_CAPABILITIES  3668    //ȡͣƱ
#define    NET_DVR_GET_ILLEGALCARDFILTERING_CFG    3669    //ȡͣƱ
#define    NET_DVR_SET_ILLEGALCARDFILTERING_CFG    3670    //ͣƱ
#define    NET_DVR_GET_LEDDISPLAY_CAPABILITIES        3671    //ȡLEDĻʾò
#define    NET_DVR_SET_LEDDISPLAY_CFG              3672    //LEDĻʾ
#define    NET_DVR_GET_LEDDISPLAY_CFG              3673    //ȡLEDĻʾ
#define    NET_DVR_GET_VOICEBROADCAST_CAPABILITIES    3674    //ȡƲò
#define    NET_DVR_SET_VOICEBROADCAST_CFG          3675    //Ʋ
#define    NET_DVR_GET_PAPERPRINTFORMAT_CAPABILITIES    3676//ȡֽƱӡʽ
#define    NET_DVR_GET_PAPERPRINTFORMAT_CFG        3677    //ȡֽƱӡʽ
#define    NET_DVR_SET_PAPERPRINTFORMAT_CFG        3678    //ֽƱӡʽ
#define    NET_DVR_GET_LOCkGATE_CAPABILITIES       3679    //ȡբ
#define    NET_DVR_GET_LOCKGATE_CFG                3680    //ȡբ
#define    NET_DVR_SET_LOCKGATE_CFG                3681    //բ
#define NET_DVR_GET_PARKING_DATASTATE            3682    //ȡͬ״̬
#define NET_DVR_SET_PARKING_DATASTATE           3683    //ͬ״̬
#define    NET_DVR_GET_TME_CAPABILITIES            3684    //ȡͣ豸 

#define    NET_DVR_GET_TMEVOICE_CAPABILITIES       3686    //ȡϢ
#define    NET_DVR_SET_TMEVOICE_CFG                3687    //
#define    NET_DVR_GET_TMEVOICE_CFG                3688    //ȡ

#define    NET_DVR_GET_POSITION                    3698    // ȡλò
#define    NET_DVR_SET_POSITION                    3699    // ÷λò
#define    NET_DVR_GET_CENTRALIZEDCTRL_CAPABILITIES    3700//ȡв
#define    NET_DVR_GET_CENTRALIZEDCTRL                3701//ȡвز
#define    NET_DVR_SET_CENTRALIZEDCTRL              3702//üвز
#define    NET_DVR_GET_COMPASS_CAPABILITIES        3703//ȡ
#define    NET_DVR_GET_VANDALPROOFALARM              3704//ȡƻ
#define    NET_DVR_SET_VANDALPROOFALARM            3705//÷ƻ
#define    NET_DVR_COMPASS_CALIBRATE_CTRL            3706//̽ƽӿ
#define    NET_DVR_COMPASS_NORTH_CTRL                3707//ָƽӿ
#define    NET_DVR_GET_AZIMUTHINFO                    3708//ȡλǶȲ


#define    NET_DVR_GET_SATELLITETIME                3709//ȡǶλ
#define    NET_DVR_SET_SATELLITETIME                3710//Ƕλ
#define    NET_DVR_GET_GISINFO                     3711//ȡǰGISϢ
#define    NET_DVR_GET_STREAMING_CAPABILITIES        3712//ȡƵ
#define    NET_DVR_GET_REFRESHFRAME_CAPABILITIES    3713//ȡˢ֡
#define    NET_DVR_STREAMING_REFRESH_FRAME            3714//ȡԤǿˢ֡
#define    NET_DVR_FACECAPTURE_STATISTICS            3715//Աͳ
#define    NET_DVR_GET_WIRELESSSERVER_CAPABILITIES    3716    //ȡȵ㹦Э
#define    NET_DVR_GET_WIRELESSSERVER                3717    //ȡȵ㹦Э
#define    NET_DVR_SET_WIRELESSSERVER                3718    //ȵ㹦Э
#define    NET_DVR_GET_CONNECT_LIST_CAPABILITIES    3719    //ȡ豸бϢ
#define    NET_DVR_GET_THSCREEN_CAPABILITIES        3720 //ȡʪЭ
#define    NET_DVR_GET_THSCREEN                    3721 //ȡʪЭ
#define    NET_DVR_GET_EXTERNALDEVICE_CAPABILITIES    3722//ȡЭ
#define    NET_DVR_GET_EXTERNALDEVICE              3723//ȡЭ
#define    NET_DVR_SET_EXTERNALDEVICE                3724//Э
#define    NET_DVR_GET_LEDDISPLAYINFO_CAPABILITIES     3725   //ȡLEDʾϢ
#define    NET_DVR_SET_LEDDISPLAYINFO                 3726   //LEDʾϢ
#define    NET_DVR_GET_SUPPLEMENTLIGHT_CAPABILITIES 3727   //ȡòЭ (֧֣ʵ֣豸ڲ)
#define    NET_DVR_GET_SUPPLEMENTLIGHT                 3728    //ȡòЭ
#define    NET_DVR_SET_SUPPLEMENTLIGHT                 3729    //òЭ
#define    NET_DVR_SET_THSCREEN                     3730 //ʪЭ
#define    NET_DVR_GET_LOWPOWER_CAPABILITIES        3731   //ȡ͹Э
#define    NET_DVR_GET_LOWPOWER                     3732    //ȡ͹Э
#define    NET_DVR_SET_LOWPOWER                     3733    //õ͹Э
#define    NET_DVR_GET_ZOOMLINKAGE_CAPABILITIES     3734   //ȡ䱶Э
#define    NET_DVR_GET_ZOOMLINKAGE                     3735    //ȡ䱶Э
#define    NET_DVR_SET_ZOOMLINKAGE                     3736    //ñ䱶Э
#define    NET_DVR_THSCREEN_TIMING                     3737    //ʪ
#define NET_DVR_GET_OSD_BATTERY_POWER_CFG        3741        //ȡOSDصʾ
#define NET_DVR_SET_OSD_BATTERY_POWER_CFG        3742        //OSDصʾ
#define    NET_DVR_GET_OSD_BATTERY_POWER_CFG_CAPABILITIES    3743//OSDصʾ
#define    NET_DVR_GET_VANDALPROOFALARM_TRIGGER    3744    //ȡƻ
#define    NET_DVR_SET_VANDALPROOFALARM_TRIGGER    3745    //÷ƻ
#define    NET_DVR_GET_PANORAMAIMAGE_CAPABILITIES    3746    //ȡȫͼ
#define    NET_DVR_GET_PANORAMAIMAGE                3747    //ȡȫͼЭ
#define    NET_DVR_SET_PANORAMAIMAGE                3748    //ȫͼЭ
#define    NET_DVR_GET_STREAMENCRYPTION            3749    //ȡ
#define    NET_DVR_SET_STREAMENCRYPTION            3750    //
#define    NET_DVR_GET_STREAMENCRYPTION_CAPABILITIES 3751  //ȡ
#define    NET_DVR_GET_REVISE_GPS_CAPABILITIES     3752    //ȡУ׼GPSγ
#define    NET_DVR_GET_REVISE_GPS                  3753    //ȡУ׼GPSγ
#define    NET_DVR_SET_REVISE_GPS                  3754    //У׼GPSγ
#define NET_DVR_GET_PDC_RECOMMEND                3755    //ȡͳƱʾƼֵ
#define NET_DVR_REMOVE_FLASHSTORAGE                3756    //
#define    NET_DVR_GET_COUNTING_CAPABILITIES        3757    //ȡͳ
#define    NET_DVR_SET_SENSOR_ADJUSTMENT            3758    //Sensor ڲЭ
#define    NET_DVR_GET_SENSOR_ADJUSTMENT_CAPABILITIES        3759    //ȡSensor ڲЭ
#define    NET_DVR_GET_WIRELESSSERVER_FULLVERSION_CFG         3760    //ȡwifiȵ()
#define    NET_DVR_SET_WIRELESSSERVER_FULLVERSION_CFG         3761    //wifiȵ()
#define    NET_DVR_GET_ONLINEUSER_INFO                3762    //ӻȡûϢ
#define    NET_DVR_GET_SENSOR_ADJUSTMENT_INFO        3763    //ȡָsensorڲ
#define NET_DVR_SENSOR_RESET_CTRL               3764    //Sensor ڸλ

#define    NET_DVR_GET_POSTRADAR_CAPABILITIES        3765    //ȡ״
#define    NET_DVR_GET_POSTRADARSPEED_CFG          3766    //ȡ״
#define    NET_DVR_SET_POSTRADARSPEED_CFG          3767    //״
#define    NET_DVR_GET_POSTRADARSPEED_RECOM_CFG    3768    //ȡ״Ƽֵ
#define    NET_DVR_GET_POSTRADARPARAM_CFG          3769    //ȡ״
#define    NET_DVR_SET_POSTRADARPARAM_CFG          3770    //״
#define    NET_DVR_GET_POSTRADARPARAM_RECOM_CFG    3771    //ȡ״Ƽֵ

#define NET_DVR_GET_ENCRYPT_DEVICE_INFO        3772   //ȡ豸Ϣ
#define NET_DVR_GET_ANR_ARMING_HOST            3773  //ȡϢ

/********************************IPCFF****************************/
#define    NET_DVR_GET_FTP_CAPABILITIES            3782    //ȡftp
#define    NET_DVR_GET_FTPUPLOAD_CFG                3783    //ȡftpϴϢ
#define    NET_DVR_SET_FTPUPLOAD_CFG                3784    //ftpϴϢ

#define    NET_DVR_GET_DDNS_COUNTRY_ABILITY        3800//ȡ豸ֵ֧DDNSб

/********************************ʶ****************************/
#define NET_DVR_GET_FACESNAPCFG                 5001  //ȡץĲ
#define NET_DVR_SET_FACESNAPCFG                 5002  //ץĲ
#define NET_DVR_GET_DEVACCESS_CFG               5005  //ȡ豸
#define NET_DVR_SET_DEVACCESS_CFG               5006  //ý豸
#define NET_DVR_GET_SAVE_PATH_CFG               5007  //ȡ洢Ϣ
#define NET_DVR_SET_SAVE_PATH_CFG               5008  //ô洢Ϣ
#define NET_VCA_GET_RULECFG_V41                    5011  //ȡΪ(չ)
#define NET_VCA_SET_RULECFG_V41                    5012  //Ϊ(չ)
#define NET_DVR_GET_AID_RULECFG_V41             5013  //ȡͨ¼
#define NET_DVR_SET_AID_RULECFG_V41             5014  //ýͨ¼
#define NET_DVR_GET_TPS_RULECFG_V41             5015  //ȡͨͳƹ(չ)
#define NET_DVR_SET_TPS_RULECFG_V41             5016  //ýͨͳƹ(չ)
#define NET_VCA_GET_FACEDETECT_RULECFG_V41      5017  //ȡATM(չ) 
#define NET_VCA_SET_FACEDETECT_RULECFG_V41      5018  //ATM(չ)
#define NET_DVR_GET_PDC_RULECFG_V41             5019  //ͳƹ(չ)
#define NET_DVR_SET_PDC_RULECFG_V41             5020  //ȡͳƹ(չ)
#define NET_DVR_GET_TRIAL_VERSION_CFG           5021  //ȡðϢ
#define NET_DVR_GET_VCA_CTRLINFO_CFG            5022  //ȡܿƲ
#define NET_DVR_SET_VCA_CTRLINFO_CFG            5023  //ܿƲ
#define NET_DVR_SYN_CHANNEL_NAME                5024  //ͬͨ
#define NET_DVR_GET_RESET_COUNTER               5025  //ȡͳͨͳƣ
#define NET_DVR_SET_RESET_COUNTER               5026  //ͳͨͳƣ
#define NET_DVR_GET_OBJECT_COLOR                5027  //ȡɫ
#define NET_DVR_SET_OBJECT_COLOR                5028  //ɫ
#define NET_DVR_GET_AUX_AREA                    5029  //ȡ
#define NET_DVR_SET_AUX_AREA                    5030  //ø
#define NET_DVR_GET_CHAN_WORKMODE               5031  //ȡͨģʽ
#define NET_DVR_SET_CHAN_WORKMODE               5032  //ͨģʽ
#define NET_DVR_GET_SLAVE_CHANNEL               5033  //ȡͨ
#define NET_DVR_SET_SLAVE_CHANNEL               5034  //ôͨ
#define NET_DVR_GET_VQD_EVENT_RULE              5035  //ȡƵ¼
#define NET_DVR_SET_VQD_EVENT_RULE              5036  //Ƶ¼
#define NET_DVR_GET_BASELINE_SCENE              5037  //ȡ׼
#define NET_DVR_SET_BASELINE_SCENE              5038  //û׼
#define NET_DVR_CONTROL_BASELINE_SCENE          5039  //׼
#define NET_DVR_SET_VCA_DETION_CFG                5040  //ƶ
#define NET_DVR_GET_VCA_DETION_CFG                5041  //ȡƶ
#define NET_DVR_GET_STREAM_ATTACHINFO_CFG       5042  //ȡϢ
#define NET_DVR_SET_STREAM_ATTACHINFO_CFG       5043  //Ϣ

#define NET_DVR_GET_BV_CALIB_TYPE               5044  //ȡ˫Ŀ궨
#define NET_DVR_CONTROL_BV_SAMPLE_CALIB         5045  //˫Ŀ궨
#define NET_DVR_GET_BV_SAMPLE_CALIB_CFG         5046  //ȡ˫Ŀ궨
#define NET_DVR_GET_RULECFG_V42                    5049  //ȡΪ(֧16չ)
#define NET_DVR_SET_RULECFG_V42                    5050  //Ϊ(֧16չ)
#define NET_DVR_SET_VCA_DETION_CFG_V40            5051  //ƶ
#define NET_DVR_GET_VCA_DETION_CFG_V40          5052  //ȡƶ
/********************************ʶ end****************************/

//2014-12-03  
#define    NET_DVR_GET_T1TEST_CFG   5053     //߲ýӿڣȡ
#define    NET_DVR_SET_T1TEST_CFG   5054     ////߲ýӿڣã

/********************************ITS****************************/
#define NET_ITS_GET_OVERLAP_CFG_V50                5055  //ȡַӲչ
#define NET_ITS_SET_OVERLAP_CFG_V50                5056  //ַӲչ

#define NET_DVR_GET_PARKLAMP_STATE                5057  //ȡͣźŵ״̬Ϣ
#define NET_DVR_GET_CLOUDSTORAGE_CFG            5058  //ȡƴ洢ò
#define NET_DVR_SET_CLOUDSTORAGE_CFG            5059  //ƴ洢ò

#define NET_ITS_GET_BASE_INFO                    5060  //ȡն˻Ϣ
#define NET_DVR_GET_SENSOR_INFO                 5061  //Ϣѯ
#define    NET_DVR_SET_SENSOR_SWITCH                5062  //Զ̿
#define NET_ITS_GET_IMGMERGE_CFG                5063  //ȡͼƬϳò
#define NET_ITS_SET_IMGMERGE_CFG                5064  //ͼƬϳò
#define NET_ITS_GET_UPLOAD_CFG                    5065  //ȡϴ
#define NET_ITS_SET_UPLOAD_CFG                    5066  //ϴ
#define    NET_DVR_GET_SENSOR_PORT_CAPABILITIES    5067  //ȡ
#define NET_ITS_GET_WORKSTATE                    5069  //ȡն˹״̬
#define NET_ITS_GET_IPC_CHAN_CFG                5070  //ȡͨIPCϢ
#define NET_ITS_SET_IPC_CHAN_CFG                5071  //ͨIPCϢ
#define NET_ITS_GET_OVERLAP_CFG                    5072  //ȡַӲ
#define NET_ITS_SET_OVERLAP_CFG                    5073  //ַӲ
#define NET_DVR_GET_TRIGGEREX_CFG               5074  //ȡITCչ
#define NET_DVR_SET_TRIGGEREX_CFG               5075  //ITCչ
#define NET_ITS_GET_ROAD_INFO                    5076  //ȡ·Ϣ

#define NET_ITS_REMOTE_DEVICE_CONTROL            5077//Զ豸
#define NET_ITS_GET_GATEIPC_CHAN_CFG            5078//ȡڲ
#define NET_ITS_SET_GATEIPC_CHAN_CFG            5079//óڲ
#define NET_ITS_TRANSCHAN_START                    5080//ͬݷ
#define NET_ITS_GET_ECTWORKSTATE                5081//ȡն˹״̬
#define NET_ITS_GET_ECT_CHAN_INFO                5082//ȡնͨ״̬
#define NET_DVR_GET_HEATMAP_RESULT              5083//ȶͼݲ
#define NET_DVR_SET_ITS_EXDEVCFG                5084 //ITS豸Ϣ
#define NET_DVR_GET_ITS_EXDEVCFG                5085 //ȡITS豸Ϣ
#define NET_DVR_GET_ITS_EXDEVSTATUS                5086 //ȡITS豸Ϣ
#define NET_DVR_SET_ITS_ENDEVCMD                5087 //ITSն˳ڿ
#define NET_DVR_SET_ENISSUED_DATADEL            5088 //ITSն˳ڿ
#define NET_DVR_GET_PDC_RESULT                  5089//ݲѯ 2014-03-21
#define NET_ITS_GET_LAMP_CTRLCFG                5090  //ȡõƲ
#define NET_ITS_SET_LAMP_CTRLCFG                5091  //õƲ
#define NET_ITS_GET_PARKSPACE_ATTRIBUTE_CFG     5092  //ȡ⳵λ
#define NET_ITS_SET_PARKSPACE_ATTRIBUTE_CFG     5093  //⳵λ
#define NET_ITS_SET_LAMP_EXTERNAL_CFG            5095  //ò
#define NET_ITS_SET_COMPEL_CAPTURE                5096  //óλǿץͼ
#define NET_DVR_SET_TIMESIGN_CFG                5097  //չУʱԶ
#define NET_DVR_GET_TIMESIGN_CFG                5098  //ȡչУʱԶ
#define NET_DVR_GET_SIGNALLAMP_STATUS           5099  //źŵƼ
/********************************ITS end****************************/

#define NET_DVR_GET_MONITOR_PLAN_VQD            5100  //ӻȡϷƻ
#define NET_DVR_GET_MONITORID_VQD               5101  //ӻȡӦƻڵļصϢ
#define NET_DVR_SET_MONITOR_INFO                5102  //üƻڵļصϢ 
#define NET_DVR_DEL_MONITOR_PLAN_VQD            5103  //ɾƻ
#define NET_DVR_GET_MONITOR_VQD_STATUS          5104  //ƽ̨ѯϷ״̬
#define NET_DVR_GET_RECORD_INFO                 5105  //ȡԴͼƬѯ
#define NET_DVR_GET_MONITOR_VQDCFG              5106  //ȡļصϢ
#define NET_DVR_SET_MONITOR_VQDCFG              5107  //÷ļصϢ
#define NET_DVR_SET_MONITOR_PLAN_VQDCFG         5108  //ùƻ(ļƻ)

#define NET_DVR_SCENE_CHANGE_UPDATE                5109   //ݸ

#define NET_DVR_GET_CALIBRATE_POINT             5153  //һתǹ豸 ⲿ ߴ벻ʵֹ֣ͻύߣ/*************************ܶೡ********************************/
#define NET_DVR_GET_SCENE_CFG                   5201  //ȡϢ
#define NET_DVR_SET_SCENE_CFG                   5202  //óϢ
#define NET_DVR_GET_SCENE_REFERENCE_REGION      5203  //ȡο
#define NET_DVR_SET_SCENE_REFERENCE_REGION      5204  //òο
#define NET_DVR_GET_SCENE_CALIBRATION           5205  //ȡ궨Ϣ
#define NET_DVR_SET_SCENE_CALIBRATION           5206  //ñ궨Ϣ
#define NET_DVR_GET_SCENE_MASK_REGION           5207  //ȡ
#define NET_DVR_SET_SCENE_MASK_REGION           5208  //
#define    NET_DVR_GET_SCENE_LANECFG                5209  //ȡ
#define NET_DVR_SET_SCENE_LANECFG                5210  //ó
#define NET_DVR_GET_SCENE_AID_RULECFG           5211  //ȡͨ¼
#define NET_DVR_SET_SCENE_AID_RULECFG           5212  //ýͨ¼
#define NET_DVR_GET_SCENE_TPS_RULECFG           5213  //ȡͨͳƹ
#define NET_DVR_SET_SCENE_TPS_RULECFG           5214  //ýͨͳƹ
#define NET_DVR_GET_SCENE_TIME_CFG              5215  //ȡͨĳʱ
#define NET_DVR_SET_SCENE_TIME_CFG              5216  //ͨĳʱ
#define NET_DVR_GET_FORENSICS_MODE              5217  //ȡȡ֤ʽ
#define NET_DVR_SET_FORENSICS_MODE              5218  //ȡ֤ʽ
#define NET_DVR_FORCESTOP_FORENSICS_CTRL        5219  //ǿֹͣȡ֤
#define NET_DVR_GET_ALARM_PROCESS_CFG           5220   //ȡ
#define NET_DVR_SET_ALARM_PROCESS_CFG           5221   //ñ
#define NET_DVR_GET_BLACKLIST_ALARM_INFO        5222   //ȡڰ켣
#define NET_DVR_GET_STORAGE_RESOURCE_CFG        5225   //ȡ洢Դ
#define NET_DVR_SET_STORAGE_RESOURCE_CFG        5226   //ô洢Դ
#define NET_DVR_DEL_BLACKLIST_ALARM_RECORD        5227   //Զɾ¼
#define NET_DVR_SET_BLACKLIST_GROUP_INFO        5229   //Զ̷б
#define NET_DVR_DEL_BLACKLIST_GROUP_INFO        5230   //Զɾб
#define NET_DVR_GET_BLACKLIST_GROUP_INFO        5231   //Զ̻ȡȫб
#define NET_DVR_SET_BLACKLIST_GROUP_RECORD_CFG    5232   //¼
#define NET_DVR_GET_BLACKLIST_GROUP_RECORD_CFG    5234   //Զ̻ȡ¼
#define NET_DVR_DEL_BLACKLIST_GROUP_RECORD_CFG    5235   //Զɾ¼
#define    NET_DVR_GET_AREA_MONITOR_CFG            5236   //ȡص
#define    NET_DVR_SET_AREA_MONITOR_CFG            5237   //ص
#define    NET_DVR_DEL_AREA_MONITOR_CFG            5238   //ɾص
#define NET_DVR_RETRIEVAL_SNAP_RECORD            5240   //ץĿ
#define NET_DVR_GET_ALARMLIST                    5241   //ȡб
#define NET_DVR_DETECT_IMAGE                    5242   //ͼƬ
#define NET_DVR_GET_SNAP_RECORD                 5243   //ȡץļ¼
#define NET_DVR_DEL_SNAP_RECORD                 5244   //ɾץļ¼
#define NET_DVR_GET_FACE_RECORD                 5245   //Զ̻ȡ¼б
#define NET_DVR_SET_FACE_RECORD                    5246   //¼
#define NET_DVR_DEL_FACE_RECORD                    5247   //ɾ¼
#define NET_DVR_GET_FACE_DATABASE                5248   //ȡò
#define NET_DVR_SET_FACE_DATABASE                5249   //ò
#define NET_DVR_DEL_FACE_DATABASE                5250   //ɾ
#define NET_DVR_RETRIEVAL_FACE_DATABASE            5251   //
#define NET_DVR_SET_BLACKLIST_REL_DEV_CFG        5252   //豸
#define NET_DVR_DEL_BLACKLIST_REL_DEV            5253   //ɾ 豸Ϣ
/*************************ܶೡend*****************************/

#define NET_DVR_GET_DISK_RAID_INFO              6001  //ȡRaidϢ
#define NET_DVR_SET_DISK_RAID_INFO              6002  //ôRaidϢ

#define NET_DVR_GET_DVR_SYNCHRONOUS_IPC         6005  //ȡǷΪǰIPCͬ豸
#define NET_DVR_SET_DVR_SYNCHRONOUS_IPC         6006  //ãǷΪǰIPCͬ豸

#define NET_DVR_SET_DVR_IPC_PASSWD              6008  //ãIPCû
#define NET_DVR_GET_DEVICE_NET_USING_INFO       6009  //ȡǰ豸Դʹ

#define NET_DVR_SET_DVR_IPC_NET                 6012  //ãǰIPCַ

#define NET_DVR_GET_RECORD_CHANNEL_INFO         6013  //ȡ¼ͨϢ
#define NET_DVR_SET_RECORD_CHANNEL_INFO         6014  //ã¼ͨϢ


#define NET_DVR_MOUNT_DISK                        6015     // ش
#define NET_DVR_UNMOUNT_DISK                    6016     // жش

// CVR 
#define NET_DVR_GET_STREAM_SRC_INFO                6017  //ȡԴϢ
#define NET_DVR_SET_STREAM_SRC_INFO                6018  //ãԴϢ
#define NET_DVR_GET_STREAM_RECORD_INFO            6019  //ȡ¼Ϣ
#define NET_DVR_SET_STREAM_RECORD_INFO            6020  //ã¼Ϣ
#define NET_DVR_GET_STREAM_RECORD_STATUS        6021  //ȡ¼״̬
#define NET_DVR_SET_STREAM_RECORD_STATUS        6022  //ã¼״̬
#define NET_DVR_GET_STREAM_INFO                    6023  //ȡӵIDϢ
#define NET_DVR_GET_STREAM_SRC_INFO_V40            6024  //ȡԴϢ
#define NET_DVR_SET_STREAM_SRC_INFO_V40          6025  //ãԴϢ
#define NET_DVR_GET_RELOCATE_INFO               6026  //ȡN+0ģʽضϢ
#define NET_DVR_START_GOP_INFO_PASSBACK         6032  //Ϣ
#define NET_DVR_GET_CHANS_RECORD_STATUS_CFG     6035    //ȡͨ¼״̬Ϣ
#define NET_DVR_SET_CHANS_RECORD_STATUS_CFG     6036    //ͨ¼״̬Ϣ
//NVR96xx
#define NET_DVR_GET_IP_ALARM_GROUP_NUM          6100  //ȡIPͨ
#define NET_DVR_GET_IP_ALARM_IN                 6101  //ȡIPͨϢ
#define NET_DVR_GET_IP_ALARM_OUT                6102  //ȡIPͨϢ

//9000 v2.2
#define NET_DVR_GET_FTPCFG_SECOND                6103      //ȡͼƬϴFTP
#define NET_DVR_SET_FTPCFG_SECOND                6104      //ͼƬϴFTP

#define NET_DVR_GET_DEFAULT_VIDEO_EFFECT        6105       // ȡƵЧĬֵ
#define NET_DVR_SET_VIDEO_EFFECT                6106       // ͨƵͼ
#define NET_DVR_DEL_INVALID_DISK                6107       // ɾЧ

#define NET_DVR_GET_DRAWFRAME_DISK_QUOTA_CFG    6109    //ȡ֡ͨ
#define NET_DVR_SET_DRAWFRAME_DISK_QUOTA_CFG    6110    //ó֡ͨ

#define NET_DVR_GET_NAT_CFG                     6111     //ȡNATӳ
#define NET_DVR_SET_NAT_CFG                     6112     //NATӳ  
#define NET_DVR_GET_AES_KEY                     6113     //ȡ豸AESԿ
#define NET_DVR_GET_POE_CFG                     6114     //ȡPOE
#define NET_DVR_SET_POE_CFG                     6115     //POE
#define NET_DVR_GET_CUSTOM_PRO_CFG              6116     //ȡԶЭ
#define NET_DVR_SET_CUSTOM_PRO_CFG              6117     //ԶЭ
#define NET_DVR_GET_STREAM_CABAC                6118     //ȡѹѡ
#define NET_DVR_SET_STREAM_CABAC                6119     //ѹѡ   
#define NET_DVR_GET_ESATA_MINISAS_USAGE_CFG        6120  //ȡeSATAminiSAS;
#define NET_DVR_SET_ESATA_MINISAS_USAGE_CFG        6121  //eSATAminiSAS; 

#define NET_DVR_GET_HDCFG_V40                    6122  //ȡӲϢ
#define NET_DVR_SET_HDCFG_V40                    6123  //ӲϢ
#define NET_DVR_GET_POE_CHANNEL_ADD_MODE        6124     //ȡPOEͨӷʽ
#define NET_DVR_SET_POE_CHANNEL_ADD_MODE        6125     //POEͨӷʽ
#define NET_DVR_GET_DIGITAL_CHANNEL_STATE       6126     //ȡ豸ͨ״̬
#define   NET_DVR_GET_BONJOUR_CFG               6127 // ȡBonjourϢ
#define   NET_DVR_SET_BONJOUR_CFG               6128 // BonjourϢ


#define NET_DVR_GET_SOCKS_CFG                    6130//ȡSOCKSϢ 
#define NET_DVR_SET_SOCKS_CFG                      6131//SOCKSϢ

#define    NET_DVR_GET_QOS_CFG                        6132//ȡQoSϢ
#define NET_DVR_SET_QOS_CFG                        6133//QoSϢ

#define NET_DVR_GET_HTTPS_CFG                    6134//ȡHTTPSϢ
#define NET_DVR_SET_HTTPS_CFG                    6135//HTTPSϢ

#define NET_DVR_GET_WD1_CFG                     6136//Զ̻ȡWD1ʹܿ
#define NET_DVR_SET_WD1_CFG                     6137//ԶWD1ʹܿ

#define NET_DVR_CREATE_CERT                     6138//֤
#define NET_DVR_DELETE_CERT                     6139//ɾ֤


#define NET_DVR_GET_RECORD_LOCK_PERCENTAGE        6140  //ȡ¼
#define NET_DVR_SET_RECORD_LOCK_PERCENTAGE      6141  //¼

#define NET_DVR_CMD_TRIGGER_PERIOD_RECORD        6144 //ⲿָʱ¼
#define NET_DVR_UPLOAD_CERT                     6145    //ϴ֤
#define NET_DVR_DOWNLOAD_CERT                   6146     //֤
#define NET_DVR_GET_CERT                        6147     //ȡ֤

#define NET_DVR_GET_POS_FILTER_CFG                6148    //ȡPOS˹
#define NET_DVR_SET_POS_FILTER_CFG                6149    //POS˹
#define NET_DVR_GET_CONNECT_POS_CFG                6150    //ȡDVRPOSӷʽ
#define NET_DVR_SET_CONNECT_POS_CFG                6151    //DVRPOSӷʽ
#define NET_DVR_GET_CHAN_FILTER_CFG                6152    //ȡͨϢ
#define NET_DVR_SET_CHAN_FILTER_CFG                6153    //ùͨϢ


#define NET_DVR_GET_FTPCFG_V40                    6162    //ȡFTPϢ
#define NET_DVR_SET_FTPCFG_V40                    6163    //FTPϢ

#define NET_DVR_GET_MONTHLY_RECORD_DISTRIBUTION 6164   //ȡ¼ֲ
#define NET_DVR_GET_ACCESS_DEVICE_CHANNEL_INFO  6165   //ȡ豸ͨϢ
#define NET_DVR_GET_PREVIEW_SWITCH_CFG            6166   //ȡ豸Ԥл
#define NET_DVR_SET_PREVIEW_SWITCH_CFG            6167   //豸Ԥл

//Netra3.0.0
#define NET_DVR_GET_N_PLUS_ONE_WORK_MODE            6168    //ȡN+1ģʽ
#define NET_DVR_SET_N_PLUS_ONE_WORK_MODE            6169    //N+1ģʽ

#define NET_DVR_GET_HD_STATUS                         6170    //ȡӲ״̬
#define NET_DVR_SET_HD_STATUS                         6171    //Ӳ״̬

#define NET_DVR_IMPORT_IPC_CFG_FILE                    6172    //IPCļ
#define NET_DVR_EXPORT_IPC_CFG_FILE                    6173    //IPCļ
#define NET_DVR_UPGRADE_IPC                            6174    //IPͨ

#define NET_DVR_GET_RAID_BACKGROUND_TASK_SPEED        6175    //ȡRAID̨ٶ
#define NET_DVR_SET_RAID_BACKGROUND_TASK_SPEED        6176    //RAID̨ٶ

//marvell 256·NVR
#define NET_DVR_GET_EXCEPTIONCFG_V40                6177    //ȡ쳣
#define NET_DVR_SET_EXCEPTIONCFG_V40                6178    //쳣
#define NET_DVR_GET_PICCFG_V40                      6179    //ȡͼ ֱ֧䳤    NetSDK_
#define NET_DVR_SET_PICCFG_V40                      6180    //ͼ ֱ֧䳤
#define NET_DVR_GET_ALARMINCFG_V40                  6181    //ȡֱ֧䳤
#define NET_DVR_SET_ALARMINCFG_V40                  6182    //ȡֱ֧䳤
#define NET_DVR_GET_IPALARMINCFG_V40                6183    //ȡIPϢ 
#define NET_DVR_GET_IPALARMOUTCFG_V40               6185    //ȡIPϢ 
#define NET_DVR_GET_USERCFG_V40                     6187    //ȡû
#define NET_DVR_SET_USERCFG_V40                     6188    //û
#define NET_DVR_GET_WORK_STATUS                     6189    //ȡ豸״̬
#define NET_DVR_GET_JPEG_CAPTURE_CFG_V40            6190    //ȡDVRץͼ
#define NET_DVR_SET_JPEG_CAPTURE_CFG_V40            6191    //DVRץͼ
#define NET_DVR_GET_HDGROUP_CFG_V40                 6192    //ȡò
#define NET_DVR_SET_HDGROUP_CFG_V40                 6193    //ò
#define NET_DVR_GET_SMD_HOLIDAY_HANDLE              6194    //ȡܼռƻ
#define NET_DVR_SET_SMD_HOLIDAY_HANDLE              6195    //üܼռƻ
#define NET_DVR_GET_PIC_MODEL_CFG                   6196    //ȡͼƬģò
#define NET_DVR_SET_PIC_MODEL_CFG                   6197    //ͼƬģò
#define NET_DVR_START_LOCAL_MOUSE_EVENT             6198    //豸¼¼
#define NET_DVR_START_SIMULARE_MOUSE_EVENT          6199    //Զģ¼

//91ϵHD-SDIDVR
#define NET_DVR_GET_ACCESS_CAMERA_INFO          6201 // ȡǰϢ
#define NET_DVR_SET_ACCESS_CAMERA_INFO          6202 // ǰϢ
#define NET_DVR_PULL_DISK                        6203 // ȫ
#define NET_DVR_SCAN_RAID                        6204 // ɨ
// CVR 2.0.X
#define NET_DVR_GET_USER_RIGHT_CFG                6210        // ȡûȨ
#define NET_DVR_SET_USER_RIGHT_CFG                6211        // ûȨ

#define NET_DVR_ONE_KEY_CONFIG                    6212        // һCVR
#define NET_DVR_RESTART_SERVICE                    6213        // CVR

#define NET_DVR_GET_MAX_MACHINE_NUM_CFG            6214        // ȡ
#define NET_DVR_SET_MAX_MACHINE_NUM_CFG            6215        // ñ

#define NET_DVR_ADD_DEVICE                        6216        //N+1ģʽ豸
#define NET_DVR_DEL_DEVICE                        6217        //N+1ģʽɾ豸

#define NET_DVR_GET_DATA_CALLBACK_CFG            6218        // ȡݻǨ״̬
#define NET_DVR_SET_DATA_CALLBACK_CFG            6219        // ݻǨ״̬

#define NET_DVR_CLONE_LUN                        6220    //¡LUN
#define NET_DVR_EXPAND_LUN                        6221    //չLUN

#define NET_DVR_GET_N_PLUS_ONE_DEVICE_INFO        6222    //ȡN+1豸Ϣ
#define NET_DVR_MODIFY_DVR_NET_DISK                6223    //޸DVR
//#define NET_DVR_DEL_DVR_NET_DISK                6224    //ɾDVR

#define NET_DVR_CREATE_NAS                        6225    //NAS
#define NET_DVR_DELETE_NAS                        6226    //ɾNAS 

#define NET_DVR_OPEN_ISCSI                         6227    //iSCSI
#define NET_DVR_CLOSE_ISCSI                        6228    //رiSCSI 

#define NET_DVR_GET_FC                            6229    //ȡϢ
#define NET_DVR_OPEN_FC                             6230    //FC
#define NET_DVR_CLOSE_FC                         6231    //رFC
#define NET_DVR_ONE_KEY_CONFIG_SAN                6232   // һSAN, һCVR߼һ

//CVR2.3.2
#define NET_DVR_RECORD_CHECK                        6233  //¼Լ
#define NET_DVR_ADD_RECORD_PASSBACK_TASK_MANUAL        6234  //ֶ¼ش
#define NET_DVR_GET_ALL_RECORD_PASSBACK_TASK_MANUAL    6235  //ȡֶ¼ش
#define NET_DVR_RECORD_PASSBACK_TASK_MANUAL_CTRL    6236  //ֶ¼ش
#define NET_DVR_DEL_RECORD_PASSBACK_TASK_MANUAL        6237  //ɾֶ¼ش
#define NET_DVR_GET_RECORD_PASSBACK_PLAN_CFG        6238  //ȡ¼شƻ
#define NET_DVR_SET_RECORD_PASSBACK_PLAN_CFG        6239  //¼شƻ
#define NET_DVR_GET_DEV_STORAGE_CFG                    6240  //ȡ豸洢Ϣ
#define NET_DVR_GET_ONLINE_USER_CFG                    6241  //ȡû
#define NET_DVR_GET_RECORD_SEGMENT_CFG                6242  //ȡ¼

#define NET_DVR_GET_RECORD_PACK                    6301    //ȡ¼
#define NET_DVR_SET_RECORD_PACK                    6302    //¼

#define NET_DVR_GET_CLOUD_STORAGE_CFG           6303     //ȡ豸ǰģʽ
#define NET_DVR_SET_CLOUD_STORAGE_CFG           6304    //豸ǰģʽ
#define NET_DVR_GET_GOP_INFO                    6305    //ȡGOPϢ 
#define NET_DVR_GET_PHY_DISK_INFO               6306     //ȡϢ
//¼ⲿ
#define NET_DVR_GET_RECORDING_AUTO_TRACK_CFG    6307    //ȡSDIԶϢ
#define NET_DVR_SET_RECORDING_AUTO_TRACK_CFG    6308    //SDIԶϢ

#define NET_DVR_GET_RECORDING_PUBLISH_CFG        6309  //ȡһϢ 
#define NET_DVR_SET_RECORDING_PUBLISH_CFG        6310  //һϢ


#define NET_DVR_RECORDING_ONEKEY_CONTROL        6311  //¼

#define NET_DVR_GET_RECORDING_END_TIME    6312  //ȡ¼ʣʱ

#define NET_DVR_RECORDING_PUBLISH                6313  //һ¼

#define NET_DVR_GET_CURRICULUM_CFG            6314    //ȡαϢ
#define NET_DVR_SET_CURRICULUM_CFG            6315  //ÿαϢ

#define NET_DVR_GET_COURSE_INDEX_CFG        6316    //ȡγϢ
#define NET_DVR_SET_COURSE_INDEX_CFG        6317  //ÿγϢ

#define    NET_DVR_GET_PPT_CHANNEL                6318    //ȡPPT֧ͨ
#define    NET_DVR_GET_PPT_DETECT_CFG            6319    //ȡPPT
#define    NET_DVR_SET_PPT_DETECT_CFG            6320    //PPT

#define NET_DVR_GET_RECORDINGHOST_CFG            6321    //ȡ¼Ϣ
#define NET_DVR_SET_RECORDINGHOST_CFG            6322    //¼Ϣ
#define NET_DVR_GET_BACKUP_RECORD_CFG           6323    //ȡһϢ
#define NET_DVR_SET_BACKUP_RECORD_CFG           6324    //һϢ

//ͥ
#define NET_DVR_GET_AUDIO_ACTIVATION_CFG        6326    //ȡò
#define NET_DVR_SET_AUDIO_ACTIVATION_CFG        6327    //ò
#define NET_DVR_GET_DECODERCFG_V40              6328    //ȡϢ
#define NET_DVR_SET_DECODERCFG_V40                6329    //ýϢ

#define NET_DVR_INFRARED_OUTPUT_CONTROL         6330   //
#define NET_DVR_GET_INFRARED_CMD_NAME_CFG       6331   //ȡƲ
#define NET_DVR_SET_INFRARED_CMD_NAME_CFG       6332   //úƲ
#define NET_DVR_START_INFRARED_LEARN            6333   //Զ̺ѧ

#define NET_DVR_GET_TRIAL_SYSTEM_CFG            6334   //ȡͥϵͳϢ
#define NET_DVR_SET_CASE_INFO                    6335    //Ϣ¼
#define NET_DVR_GET_TRIAL_MICROPHONE_STATUS        6336  //ȡ˷״̬Ϣ
#define NET_DVR_SET_TRIAL_MICROPHONE_STATUS        6337  //ȡ˷״̬Ϣ
#define NET_DVR_GET_TRIAL_HOST_STATUS            6338  //ȡͥ״̬Ϣ
#define NET_DVR_GET_LAMP_OUT                    6339  //ȡLAMPϢ
#define NET_DVR_SET_LAMP_OUT                    6340  //LAMPϢ
#define NET_DVR_LAMP_REMOTE_CONTROL                6341  // LAMP
#define NET_DVR_REMOTE_CONTROL_PLAY                6342  //Զ̿Ʊػط
#define NET_DVR_GET_LOCAL_INPUT_CFG                6343  //ȡͥ״̬ϢͥϢ
#define NET_DVR_SET_LOCAL_INPUT_CFG                6344  //ͥϢ
#define NET_DVR_GET_CASE_INFO                    6345  //ȡǰϢ

//Ѷⲿ
#define NET_DVR_INQUEST_GET_CDW_STATUS             6350  //ȡѶ¼״̬-
#define NET_DVR_GET_MIX_AUDIOIN_CFG             6351  //ȡڲ
#define NET_DVR_SET_MIX_AUDIOIN_CFG             6352  //ûڲ
#define NET_DVR_GET_MIX_AUDIOOUT_CFG            6353  //ȡڲ
#define NET_DVR_SET_MIX_AUDIOOUT_CFG            6354  //ûڲ
#define NET_DVR_GET_AUDIOIN_VOLUME_CFG          6355  //ȡƵڲ
#define NET_DVR_SET_AUDIOIN_VOLUME_CFG          6356  //Ƶڲ
#define NET_DVR_GET_AREA_MASK_CFG               6357  //ȡ
#define NET_DVR_SET_AREA_MASK_CFG               6358  //
#define NET_DVR_GET_AUDIO_DIACRITICAL_CFG       6359  //ȡƵ
#define NET_DVR_SET_AUDIO_DIACRITICAL_CFG       6360  //Ƶ
#define NET_DVR_GET_WIFI_DHCP_ADDR_CFG          6361  //WIFI DHCP ַΧ
#define NET_DVR_SET_WIFI_DHCP_ADDR_CFG          6362  //WIFI DHCP ַΧ
#define NET_DVR_GET_WIFI_CLIENT_LIST_INFO       6363  //ȡwifiȵӵ豸Ϣ
#define NET_DVR_REMOTECONTROL_POWER_ON            6364  //Զ̿
#define NET_DVR_GET_MULTISTREAM_RELATION_CHAN_CFG      6365  //ȡͨ
#define NET_DVR_SET_MULTISTREAM_RELATION_CHAN_CFG     6366  //öͨ
#define NET_DVR_GET_VIDEOOUT_RESOLUTION_CFG        6367  //ȡ豸Ƶڷֱ
#define NET_DVR_SET_VIDEOOUT_RESOLUTION_CFG        6368  //豸Ƶڷֱ
#define NET_DVR_GET_AUDIOOUT_VOLUME_CFG         6369  //ȡƵڲ
#define NET_DVR_SET_AUDIOOUT_VOLUME_CFG         6370  //Ƶڲ
#define NET_DVR_INQUEST_PAUSE_CDW               6371  //ͣ¼
#define NET_DVR_INQUEST_RESUME_CDW              6372  //ָ¼
#define NET_DVR_GET_INPUT_CHAN_CFG              6373  //ȡͨ
#define NET_DVR_SET_INPUT_CHAN_CFG              6374  //ͨ
#define  NET_DVR_GET_INQUEST_MIX_AUDIOIN_CFG    6375    //ȡѶƵ
#define  NET_DVR_SET_INQUEST_MIX_AUDIOIN_CFG    6376    //ѶƵ
#define     NET_DVR_CASE_INFO_CTRL                    6377    //Ϣʾ
#define  NET_DVR_GET_INQUEST_USER_RIGHT            6378    //ȡѶûȨ
#define  NET_DVR_SET_INQUEST_USER_RIGHT            6379    //ѶûȨ
#define NET_DVR_GET_INQUEST_CASE_INFO            6380    //ȡѶϢ
#define NET_DVR_SET_INQUEST_CASE_INFO            6381    //ѶϢ

#define    NET_DVR_GET_FILM_MODE_CFG               6387    //ȡӰģʽ
#define    NET_DVR_SET_FILM_MODE_CFG               6388    //õӰģʽ
#define    NET_DVR_GET_FILM_MODE_CFG_CAP            6389    //ȡӰģʽ

#define    NET_DVR_GET_DIRECTED_STRATEGY_CFG       6390    //ȡ
#define    NET_DVR_SET_DIRECTED_STRATEGY_CFG        6391    //õ
#define    NET_DVR_GET_DIRECTED_STRATEGY_CFG_CAP    6392    //ȡӰģʽ
#define    NET_DVR_GET_FRAME_CFG                    6393    //ȡ߿
#define    NET_DVR_SET_FRAME_CFG                    6394    //û߿
#define    NET_DVR_GET_FRAME_CFG_CAP                6395    //ȡ߿
#define    NET_DVR_GET_AUDIO_EFFECTIVE_CFG            6396    //ȡƵŻ
#define    NET_DVR_SET_AUDIO_EFFECTIVE_CFG            6397    //ƵЧ
#define    NET_DVR_GET_AUDIO_EFFECTIVE_CFG_CAP        6398    //ȡƵЧŻ
#define    NET_DVR_GET_RECORD_VIDEO_CFG              6399    //ȡ¼Ƶ
#define    NET_DVR_SET_RECORD_VIDEO_CFG            6400    //¼Ƶ


#define NET_DVR_GET_OUTPUT_CFG                  6401        //ȡʾ
#define NET_DVR_SET_OUTPUT_CFG                  6402        //ʾ
#define NET_DVR_CODER_DISPLAY_START             6403        //ʼ
#define NET_DVR_CODER_DISPLAY_STOP              6404        //ֹͣ
#define NET_DVR_GET_WINDOW_STATUS               6405        //ȡʾ״̬

//VQDܽӿ
#define NET_DVR_GET_VQD_LOOP_DIAGNOSE_CFG       6406        //ȡVQDѭò
#define NET_DVR_SET_VQD_LOOP_DIAGNOSE_CFG       6407        //VQDѭò
#define NET_DVR_GET_VQD_DIAGNOSE_INFO           6408        //ֶȡVQDϢ

#define    NET_DVR_RECORDING_PUBLISH_FILE            6421        //ļ
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_CAP    6422        //ȡļ
#define    NET_DVR_GET_PUBLISH_PROGRESS            6423           //ȡ
#define    NET_DVR_GET_RECORD_VIDEO_CFG_CAP        6424        //ȡ¼Ƶ
#define    NET_DVR_GET_RTMP_CFG                    6425        //ȡRTMP
#define    NET_DVR_SET_RTMP_CFG                    6426        //RTMP
#define    NET_DVR_GET_RTMP_CFG_CAP                  6427        //ȡRTMP
#define    NET_DVR_DEL_BACKGROUND_PIC                6428        //ɾͼƬļ
#define    NET_DVR_GET_BACKGROUND_PIC_CFG            6429        //ѯͼƬļ
#define    NET_DVR_GET_BACKGROUND_PIC_INFO            6430        //ȡͼƬΪͼƬ
#define    NET_DVR_SET_BACKGROUND_PIC_INFO            6431        //ͼƬΪͼƬ
#define    NET_DVR_GET_BACKGROUND_PIC_INFO_CAP      6432           //ȡͼƬΪͼƬ
#define    NET_DVR_GET_RECORD_HOST_CAP                6433        //ȡ¼
#define NET_DVR_GET_COURSE_LIST                 6434    //ȡγб
#define    NET_DVR_GET_RECORD_STATUS                6435 //ѯ¼ǰ״̬
#define    NET_DVR_MANUAL_CURRICULUM_CONTROL        6436    //ֶα
#define    NET_DVR_GET_IMAGE_DIFF_DETECTION_CFG        6437    //ȡͼּ
#define    NET_DVR_SET_IMAGE_DIFF_DETECTION_CFG        6438    //ͼּ
#define    NET_DVR_GET_IMAGE_DIFF_DETECTION_CFG_CAP    6439    //ȡͼּ
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_INFO    6440    //ȡļϢ
#define    NET_DVR_SET_RECORDING_PUBLISH_FILE_INFO    6441    //÷ļϢ
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_INFO_CAP        6442    //ȡļϢ
#define    NET_DVR_MANUAL_CURRICULUM_CONTROL_CAP        6443    //ȡֶγ¼
#define NET_DVR_GET_STATISTIC_DATA_LIST             6444    //ȡͳб

#define    NET_DVR_GET_DEVICE_LAN_ENCODE            6501        //ȡ豸Ա
#define NET_DVR_GET_GBT28181_SERVICE_CFG        6503        //ȡGB28181
#define NET_DVR_SET_GBT28181_SERVICE_CFG        6504        //GB28181
#define NET_DVR_GET_GBT28181_SERVICE_CAPABILITIES 6505      //ȡGB28181

#define NET_DVR_GET_CLOUD_URL               6506    //ȡƴ洢URL
#define NET_DVR_GET_CLOUD_URL_CAP           6507    //ȡƴ洢URL-
#define NET_DVR_GET_CLOUD_CFG               6508    //ȡƴ洢ò
#define NET_DVR_SET_CLOUD_CFG               6509    //ƴ洢ò
#define NET_DVR_GET_CLOUD_CFG_CAP           6510    //ȡƴ洢-
#define NET_DVR_GET_CLOUD_UPLOADSTRATEGY    6511    //ȡƴ洢ϴ
#define NET_DVR_SET_CLOUD_UPLOADSTRATEGY    6512    //ƴ洢ϴ
#define NET_DVR_GET_CLOUDSTORAGE_UPLOADSTRATEGY_CAP     6513    //ƴ洢ϴ-

#define    NET_DVR_GET_VIDEO_IMAGE_DB_CFG        6601        //ȡͼϢ
#define    NET_DVR_SET_VIDEO_IMAGE_DB_CFG        6602        //ͼϢ
#define    NET_DVR_GET_VIDEO_IMAGE_DB_CFG_CAP    6603        //ȡͼ
#define    NET_DVR_GET_FILE_INFO_BY_ID            6604        //ļIDȡͼļϢ
#define    NET_DVR_QUERY_FILE_INFO_CAP            6605        //ļѯļϢ
#define    NET_DVR_DEL_FILE_FROM_DB            6606        //ͼɾļ
#define    NET_DVR_GET_VIDEO_IMAGE_DB_CAP        6607        //ȡͼ

#define NET_DVR_GET_FIGURE                    6610        //ȡͼ

#define    NET_DVR_SYNC_IPC_PASSWD                  6621        //ͬIPCNVRһ

#define    NET_DVR_GET_VEHICLE_BLACKLST_SCHEDULE 6622    //ȡʱ
#define    NET_DVR_SET_VEHICLE_BLACKLST_SCHEDULE 6623    //úʱ

#define    NET_DVR_GET_VEHICLE_WHITELST_SCHEDULE 6624    //ȡʱ
#define    NET_DVR_SET_VEHICLE_WHITELST_SCHEDULE 6625    //ðʱ

#define    NET_DVR_GET_VEHICLE_BLACKLIST_EVENT_TRIGGER     6626    //ȡ
#define    NET_DVR_SET_VEHICLE_BLACKLIST_EVENT_TRIGGER     6627    //ú

#define    NET_DVR_GET_VEHICLE_WHITELIST_EVENT_TRIGGER     6628    //ȡ
#define    NET_DVR_SET_VEHICLE_WHITELIST_EVENT_TRIGGER     6629    //ð

#define    NET_DVR_GET_TRAFFIC_CAP    6630    //ȡץ
#define    NET_DVR_GET_VEHICLE_ALLLIST_EVENT_TRIGGER     6631    //ȡȫⲼ
#define    NET_DVR_SET_VEHICLE_ALLLIST_EVENT_TRIGGER     6632    //ȫⲼ
#define    NET_DVR_GET_VEHICLE_OTHERLIST_EVENT_TRIGGER     6633    //ȡ
#define    NET_DVR_SET_VEHICLE_OTHERLIST_EVENT_TRIGGER     6634    //

#define    NET_DVR_GET_STORAGEDETECTION_EVENT_TRIGGER     6635    //ȡ洢
#define    NET_DVR_SET_STORAGEDETECTION_EVENT_TRIGGER     6636    //ô洢
#define    NET_DVR_GET_STORAGEDETECTION_SCHEDULE_CAPABILITIES    6637    //ȡ洢Ⲽʱ
#define    NET_DVR_GET_STORAGEDETECTION_SCHEDULE         6638    //ȡ洢ʱ
#define    NET_DVR_SET_STORAGEDETECTION_SCHEDULE         6639    //ô洢ʱ
#define    NET_DVR_GET_STORAGEDETECTION_STATE             6640    //ȡ洢״̬


#define    NET_DVR_GET_FACECAPTURE_EVENT_TRIGGER         6641    //ȡץ
#define    NET_DVR_SET_FACECAPTURE_EVENT_TRIGGER         6642    //ץ
#define    NET_DVR_GET_FACECAPTURE_SCHEDULE_CAPABILITIES 6643    //ȡץĲʱ
#define    NET_DVR_GET_FACECAPTURE_SCHEDULE             6644    //ȡץĲʱ
#define    NET_DVR_SET_FACECAPTURE_SCHEDULE             6645    //ץĲʱ
#define    NET_DVR_GET_STORAGEDETECTION_RWLOCK             6646    //ȡ洢Ķд
#define    NET_DVR_GET_STORAGEDETECTION_RWLOCK_CAPABILITIES    6647    //ȡ洢Ķд
#define    NET_DVR_SET_STORAGEDETECTION_RWLOCK             6648    //ô洢Ķд
#define    NET_DVR_GET_PTZTRACKSTATUS                     6649    //ȡ״̬

#define    NET_DVR_SET_STORAGEDETECTION_UNLOCK             6653    //ô洢Ľ
#define    NET_DVR_GET_STORAGEDETECTION_UNLOCK_CAPABILITIES    6654    //ȡ洢Ľ

#define    NET_DVR_SET_SHIPSDETECTION_CFG                 6655    //ôֻ
#define    NET_DVR_GET_SHIPSDETECTION_CFG                 6656    //ȡֻ
#define    NET_DVR_GET_SHIPSDETECTION_CAPABILITIES         6657    //ȡֻ
#define    NET_DVR_GET_SHIPSDETECTION_COUNT               6658    //ȡֻϢ
#define    NET_DVR_SHIPSCOUNT_DELETE_CTRL                  6659   //մֻϢ

#define    NET_DVR_GET_BAREDATAOVERLAY_CAPABILITIES     6660   //ȡݵ
#define    NET_DVR_SET_BAREDATAOVERLAY_CFG                 6661    //ݵ
#define    NET_DVR_GET_BAREDATAOVERLAY_CFG                 6662    //ȡݵ
#define    NET_DVR_GET_SHIPSDETECTION_SCHEDULE             6663    //ȡֻⲼʱ
#define    NET_DVR_SET_SHIPSDETECTION_SCHEDULE             6664    //ôֻⲼʱ
#define    NET_DVR_GET_SHIPSDETECTION_EVENT_TRIGGER     6665    //ȡֻ
#define    NET_DVR_SET_SHIPSDETECTION_EVENT_TRIGGER     6666    //ôֻ
#define    NET_DVR_GET_SHIPSDETECTION_SCHEDULE_CAPABILITIES    6667    //ȡֻⲼʱ

#define    NET_DVR_FIRE_FOCUSZOOM_CTRL         6670        //ɼ⾵ͷ۽䱶

#define    NET_DVR_GET_MANUALRANGING_CAPABILITIES    6675    //ȡֶ

#define    NET_DVR_SET_MANUALRANGING           6677        //ֶ
#define    NET_DVR_GET_MANUALDEICING_CAPABILITIES    6678//ȡֶ
#define    NET_DVR_SET_MANUALDEICING           6679        //ֶ
#define    NET_DVR_GET_MANUALDEICING           6680        //ȡֶ

#define NET_DVR_GET_HIDDEN_INFORMATION_CAPABILITIES    6720 //Ϣ
#define NET_DVR_GET_HIDDEN_INFORMATION                 6721 //ȡϢ
#define NET_DVR_SET_HIDDEN_INFORMATION                 6722 //Ϣ
#define NET_DVR_GET_MB_POWERCTRLPARA            8000//ȡƲ
#define    NET_DVR_SET_MB_POWERCTRLPARA            8001 //Ʋ
#define NET_DVR_GET_AUTOBACKUPPARA                8002//ȡԶݲ
#define NET_DVR_SET_AUTOBACKUPPARA                8003 //Զݲ
#define NET_DVR_GET_MB_GPSPARA                    8004//ȡGPS
#define NET_DVR_SET_MB_GPSPARA                    8005 //GPS
#define NET_DVR_GET_MB_SENSORINPARA                8006//ȡSENSOR
#define NET_DVR_SET_MB_SENSORINPARA                8007 //SENSOR
#define NET_DVR_GET_GSENSORPARA                    8008//ȡGSENSOR
#define NET_DVR_SET_GSENSORPARA                    8009 //GSENSOR
#define NET_DVR_GET_MB_DOWNLOADSVRPARA            8010//ȡط
#define NET_DVR_SET_MB_DOWNLOADSVRPARA            8011//ط
#define NET_DVR_GET_PLATERECOG_PARA                8012//ȡʶ
#define NET_DVR_SET_PLATERECOG_PARA                8013//óʶ
#define NET_DVR_GET_ENFORCESYS_PARA                8014//ȡ
#define NET_DVR_SET_ENFORCESYS_PARA                8015//ó
#define NET_DVR_GET_GPS_DATA                    8016 //ȡGPS
#define NET_DVR_GET_ANALOG_ALARMINCFG            8017//ȡģⱨ
#define NET_DVR_SET_ANALOG_ALARMINCFG            8018//ģⱨ

/*****************************ǽ start****************************/
#define    NET_DVR_MATRIX_WALL_SET                    9001  //õǽĻ
#define    NET_DVR_MATRIX_WALL_GET                    9002  //ȡǽĻ
#define    NET_DVR_WALLWIN_GET                        9003  //ǽлȡڲ
#define    NET_DVR_WALLWIN_SET                        9004  //ǽôڲ
#define    NET_DVR_WALLWINPARAM_SET                9005  //õǽز
#define    NET_DVR_WALLWINPARAM_GET                9006  //ȡǽز
#define NET_DVR_WALLSCENEPARAM_GET                9007  //óģʽ
#define NET_DVR_WALLSCENEPARAM_SET                9008  //ȡģʽ
#define NET_DVR_MATRIX_GETWINSTATUS             9009  //ȡڽ״̬
#define    NET_DVR_GET_WINASSOCIATEDDEVINFO        9010  //ǽлȡӦԴϢ
#define    NET_DVR_WALLOUTPUT_GET                    9011  //ǽлȡʾ
#define    NET_DVR_WALLOUTPUT_SET                    9012  //ǽʾ
#define NET_DVR_GET_UNITEDMATRIXSYSTEM          9013  //ǽлȡӦԴ
#define NET_DVR_GET_WALL_CFG                    9014  //ȡǽȫֲ
#define NET_DVR_SET_WALL_CFG                    9015  //õǽȫֲ
#define NET_DVR_CLOSE_ALL_WND                    9016  //رд
#define NET_DVR_SWITCH_WIN_TOP                  9017  //ö
#define NET_DVR_SWITCH_WIN_BOTTOM               9018  //õ

#define    NET_DVR_CLOSE_ALL_WND_V41                9019  //ǽرдv41жǽ
#define    NET_DVR_GET_WALL_WINDOW_V41                9020  //ȡǽеĴv41
#define    NET_DVR_SET_WALL_WINDOW_V41                9021  //õǽеĴv41
#define    NET_DVR_GET_CURRENT_SCENE_V41            9022  //ȡǰǽʹõĳv41
#define    NET_DVR_GET_WALL_SCENE_PARAM_V41        9023  //ȡǰǽʹõĳv41
#define    NET_DVR_SET_WALL_SCENE_PARAM_V41        9024  //õǰǽʹõĳv41
#define NET_DVR_GET_MATRIX_LOGO_CFG             9025  //ȡlogo
#define NET_DVR_SET_MATRIX_LOGO_CFG             9026  //logo
#define NET_DVR_GET_WIN_LOGO_CFG                9027  //ȡlogo
#define NET_DVR_SET_WIN_LOGO_CFG                9028  //ôlogo
#define NET_DVR_DELETE_LOGO                     9029  //ɾlogo
#define NET_DVR_SET_DISPLAY_EFFECT_CFG            9030  //ʾЧv41
#define NET_DVR_GET_DISPLAY_EFFECT_CFG            9031  //ȡʾЧv41
#define NET_DVR_DEC_PLAY_REMOTE_FILE            9032  //벥Զļ
#define NET_DVR_GET_WIN_ZOOM_STATUS             9033  //ȡڵӷŴ״̬
#define NET_DVR_GET_ALL_MATRIX_LOGOCFG          9034  //ȡlogo

/*****************************ǽ end******************************/

/*******************************LCDƴ begin******************************************/
#define NET_DVR_SIMULATE_REMOTE_CONTROL         9035    //ģңذ 2013-09-05
#define NET_DVR_SET_SCREEN_SIGNAL_CFG            9036    //ĻźԴ
#define    NET_DVR_GET_SCREEN_SIGNAL_CFG            9037    //ȡĻźԴ
#define NET_DVR_SET_SCREEN_SPLICE_CFG              9038    //Ļƴ
#define    NET_DVR_GET_SCREEN_SPLICE_CFG            9039    //ȡĻƴ
#define NET_DVR_GET_SCREEN_FAN_WORK_MODE         9040    //ȡȹʽ
#define NET_DVR_SET_SCREEN_FAN_WORK_MODE         9041    //÷ȹʽ
#define NET_DVR_SHOW_SCREEN_WORK_STATUS          9044    //ʾĻ״̬
#define NET_DVR_GET_VGA_CFG                      9045    //ȡVGAź
#define NET_DVR_SET_VGA_CFG                      9046    //VGAź
#define NET_DVR_GET_SCREEN_MENU_CFG                9048   //ȡĻ˵
#define NET_DVR_SET_SCREEN_MENU_CFG              9049    //Ļ˵
#define NET_DVR_SET_SCREEN_DISPLAY_CFG          9050    //ʾ 2013-08-28
#define    NET_DVR_GET_SCREEN_DISPLAY_CFG            9051    //ȡʾ 2013-08-28

#define NET_DVR_SET_FUSION_CFG                    9052    //ͼںϲ
#define NET_DVR_GET_FUSION_CFG                    9053    //ȡͼںϲ

#define NET_DVR_SET_PIP_CFG                      9060    //ûл
#define    NET_DVR_GET_PIP_CFG                        9061    //ȡл
#define NET_DVR_SET_DEFOG_LCD                      9073    //͸
#define    NET_DVR_GET_DEFOG_LCD                    9074    //ȡ͸
#define NET_DVR_SHOW_IP                          9075    //ʾIP
#define NET_DVR_SCREEN_MAINTENANCE_WALL            9076    //Ļάǽ
#define NET_DVR_SET_SCREEN_POS                  9077    //Ļλò
#define    NET_DVR_GET_SCREEN_POS                    9078    //ȡĻλò
/*******************************LCDƴ end******************************************/

/*******************************LCDƴV1.2 begin******************************************/
#define    NET_DVR_SCREEN_INDEX_SET                9079    //Ļز
#define    NET_DVR_SCREEN_INDEX_GET                9080    //Ļزȡ
#define NET_DVR_SCREEN_SPLICE_SET               9081    //ĻƴӲ
#define NET_DVR_SCREEN_SPLICE_GET               9082    //ȡĻƴӲ
#define NET_DVR_SET_SCREEN_PARAM                9083    //Ļز
#define NET_DVR_GET_SCREEN_PARAM                9084    //ȡĻز
#define NET_DVR_SET_SWITCH_CFG                  9085    //öʱػ
#define NET_DVR_GET_SWITCH_CFG                  9086    //ȡʱػ
#define NET_DVR_SET_POWERON_DELAY_CFG           9087    //ʱ
#define NET_DVR_GET_POWERON_DELAY_CFG           9088    //ȡʱ
#define    NET_DVR_SET_SCREEN_POSITION                9089    //Ļλò
#define    NET_DVR_GET_SCREEN_POSITION                9090    //ȡĻλò
#define NET_DVR_SCREEN_SCENE_CONTROL            9091    //Ļ
#define NET_DVR_GET_CURRENT_SCREEN_SCENE        9092    //ȡǰĻ
#define NET_DVR_GET_SCREEN_SCENE_PARAM          9093    //ȡĻģʽ
#define NET_DVR_SET_SCREEN_SCENE_PARAM          9094    //Ļģʽ
#define NET_DVR_GET_EXTERNAL_MATRIX_RELATION    9095    //ȡӾϵ
#define NET_DVR_GET_LCD_AUDIO_CFG                9096     //ȡLCDĻƵ
#define NET_DVR_SET_LCD_AUDIO_CFG                9097     //LCDĻƵ
#define NET_DVR_GET_LCD_WORK_STATE                9098     //ȡLCDĻ״̬
#define NET_DVR_GET_BOOT_LOGO_CFG                9099    //ȡLCDĻlogoʾ
#define NET_DVR_SET_BOOT_LOGO_CFG                9100    //LCDĻlogoʾ

/*******************************LCDƴV1.2 end ******************************************/



#define NET_DVR_GET_STREAM_DST_COMPRESSIONINFO    9101  //ȡĿѹ
#define NET_DVR_SET_STREAM_DST_COMPRESSIONINFO  9102  //Ŀѹ
#define NET_DVR_GET_STREAM_TRANS_STATUS            9103  //ȡ״̬
#define NET_DVR_GET_DEVICE_TRANS_STATUS            9104  //ȡ豸ת״̬
#define NET_DVR_GET_ALLSTREAM_SRC_INFO          9105  //ȡϢ
#define NET_DVR_GET_BIG_SCREEN_AUDIO            9106  //ȡƵϢ
#define NET_DVR_SET_BIG_SCREEN_AUDIO            9107  //ôƵϢ
#define NET_DVR_GET_DEV_WORK_MODE                9108  //ȡת豸ģʽ
#define NET_DVR_SET_DEV_WORK_MODE                9109  //ת豸ģʽ
#define NET_DVR_APPLY_TRANS_CHAN                9110  //IDתͨ
#define NET_DVR_GET_DISPCHAN_CFG                9111  //ȡʾͨ
#define NET_DVR_SET_DISPCHAN_CFG                9112  //ʾͨ

#define NET_DVR_GET_DEC_CHAN_STATUS                9113  //ȡͨ״̬
#define NET_DVR_GET_DISP_CHAN_STATUS            9114  //ȡʾͨ״̬        
#define NET_DVR_GET_ALARMIN_STATUS                9115  //ȡ״̬
#define NET_DVR_GET_ALARMOUT_STATUS                9116  //ȡ״̬
#define NET_DVR_GET_AUDIO_CHAN_STATUS            9117  //ȡԽ״̬

#define    NET_DVR_GET_VIDEO_AUDIOIN_CFG            9118   //ȡƵƵ
#define NET_DVR_SET_VIDEO_AUDIOIN_CFG            9119   //ƵƵ

#define    NET_DVR_SET_BASEMAP_CFG                    9120  //õͼ
#define NET_DVR_GET_BASEMAP_CFG                    9121  //ȡͼ
#define NET_DVR_GET_VIRTUAL_SCREEN_CFG          9122  //ȡϵͳ
#define NET_DVR_SET_VIRTUAL_SCREEN_CFG          9123  //óϵͳ
#define NET_DVR_GET_BASEMAP_WIN_CFG                9124  //ȡͼڲ
#define NET_DVR_SET_BASEMAP_WIN_CFG                9125  //õͼڲ
#define NET_DVR_DELETE_PICTURE                    9126  //ɾͼ
#define NET_DVR_GET_BASEMAP_PIC_INFO            9127  //ȡͼͼƬϢ
#define    NET_DVR_SET_BASEMAP_WIN_CFG_V40         9128  //õͼڲV40
#define NET_DVR_GET_BASEMAP_WIN_CFG_V40         9129  //ȡͼڲV40

#define NET_DVR_GET_DEC_VCA_CFG                    9130    //ȡܱ
#define NET_DVR_SET_DEC_VCA_CFG                    9131    //ýܱ

#define NET_DVR_GET_TERMINAL_CONFERENCE_STATUS    9136    //ȡն˻״̬
#define NET_DVR_GET_TERMINAL_INPUT_CFG_CAP        9137    //ȡն
#define NET_DVR_GET_TERMINAL_INPUT_CFG            9138    //ȡնƵ
#define NET_DVR_SET_TERMINAL_INPUT_CFG            9139    //նƵ

#define NET_DVR_GET_CONFERENCE_REGION_CAP        9140    //ȡն˻
#define NET_DVR_GET_CONFERENCE_REGION            9141    //ȡն˻
#define NET_DVR_SET_CONFERENCE_REGION            9142    //ն˻
#define NET_DVR_GET_TERMINAL_CALL_CFG_CAP        9143    //ȡն˺
#define NET_DVR_GET_TERMINAL_CALL_CFG            9144    //ȡն˺в
#define NET_DVR_SET_TERMINAL_CALL_CFG            9145    //ն˺в
#define NET_DVR_GET_TERMINAL_CTRL_CAP            9146    //ȡն˺п
#define NET_DVR_TERMINAL_CTRL                    9147    //ն˺п
#define    NET_DVR_GET_CALL_QUERY_CAP                9148    //ȡ
#define NET_DVR_GET_CALLINFO_BY_COND            9149    //ѯм¼

#define    NET_DVR_SET_FUSION_SCALE                9150    //ͼںϹģ
#define NET_DVR_GET_FUSION_SCALE                9151    //ȡͼںϹģ

#define NET_DVR_GET_VCS_CAP                        9152    //ȡMCU


#define NET_DVR_GET_TERMINAL_GK_CFG_CAP            9153    //ȡնעGK
#define NET_DVR_GET_TERMINAL_GK_CFG                9154    //ȡնעGK
#define NET_DVR_SET_TERMINAL_GK_CFG                9155    //նעGK
#define NET_DVR_GET_MCU_CONFERENCESEARCH_CAP    9156    //ȡMCU豸

#define    NET_DVR_GET_LLDP_CFG                    9160    //ȡLLDP
#define    NET_DVR_SET_LLDP_CFG                    9161    //LLDP
#define NET_DVR_GET_LLDP_CAP                    9162    //ȡLLDP
#define    NET_DVR_GET_FIBER_CONVERT_BASIC_INFO    9163    //ȡշϢ
#define    NET_DVR_GET_FIBER_CONVERT_WORK_STATE    9164    //ȡշ״
#define    NET_DVR_GET_FIBER_CONVERT_TOPOLOGY      9165    //ȡշϢ
#define    NET_DVR_GET_FC_PORT_REMARKS                9166    //ȡշ˿עͲ
#define    NET_DVR_SET_FC_PORT_REMARKS                9167    //ùշ˿עͲ
#define NET_DVR_GET_PORT_REMARKS_CAP            9168    //ȡշ˿ע

#define NET_DVR_GET_MCU_CONFERENCECONTROL_CAP   9169    //ȡ
#define NET_DVR_GET_MCU_TERMINALCONTROL_CAP     9170    //ȡն˿
#define NET_DVR_GET_MCU_TERIMINALGROUP_CAP      9171    //ȡն˷
#define NET_DVR_GET_MCU_TERMINAL_CAP            9174    //ȡն˹
#define NET_DVR_GET_MCU_CONFERENCE_CAP          9175    //ȡ
#define NET_DVR_GET_MCU_GK_CFG_CAP              9176    //ȡMCUGK
#define NET_DVR_GET_MCU_GK_SERVER_CAP           9177    //ȡMCUGK

#define NET_DVR_GET_OUTPUT_PIC_INFO             9200    //ȡͼƬ
#define NET_DVR_SET_OUTPUT_PIC_INFO             9201    //ͼƬ
#define NET_DVR_GET_OUTPUT_PIC_WIN_CFG          9202    //ȡͼƬڲ
#define NET_DVR_SET_OUTPUT_PIC_WIN_CFG          9203    //ͼƬڲ
#define NET_DVR_GET_OUTPUT_ALL_PIC_WIN_CFG      9204    //ȡͼƬڲ
#define NET_DVR_DELETE_OUPUT_PIC                9205    //ɾͼƬ
#define NET_DVR_GET_OUTPUT_OSD_CFG              9206    //ȡOSD
#define NET_DVR_SET_OUTPUT_OSD_CFG              9207    //OSD
#define NET_DVR_GET_OUTPUT_ALL_OSD_CFG          9208    //ȡOSD
#define NET_DVR_GET_CHAN_RELATION               9209    //ȡͨԴ
#define NET_DVR_SET_CHAN_RELATION               9210    //ñͨԴ
#define NET_DVR_GET_ALL_CHAN_RELATION           9211    //ȡбͨԴ
#define NET_DVR_GET_NS_RING_CFG                    9212    //ȡ˰廷
#define NET_DVR_SET_NS_RING_CFG                   9213    //ù˰廷
#define NET_DVR_GET_NS_RING_STATUS              9214    //ȡ˰廷״̬
#define NET_DVR_GET_OPTICAL_PORT_INFO            9220    //ȡϢ
#define NET_DVR_SET_OPTICAL_PORT_INFO            9221    //ùϢ
#define NET_DVR_GET_OPTICAL_CHAN_RELATE_CFG        9222    //ȡͨԴ
#define NET_DVR_SET_OPTICAL_CHAN_RELATE_CFG        9223    //ñͨԴ
#define  NET_DVR_GET_WIN_ROAM_SWITCH_CFG        9224    //ȡοز
#define  NET_DVR_SET_WIN_ROAM_SWITCH_CFG        9225    //ýοز
#define    NET_DVR_START_SCREEN_CRTL                9226    //ʼĻ
#define    NET_DVR_GET_SCREEN_FLIE_LIST            9227    //ȡĻļб
#define    NET_DVR_GET_SCREEN_FILEINFO                9228    //ȡĻļϢ
#define    NET_DVR_SET_SCREEN_FILEINFO             9229    //ĻļϢ

/*******************************СLEDʾ begin***************************************/
#define NET_DVR_GET_LED_OUTPUT_CFG                9230    //ȡͿ
#define NET_DVR_SET_LED_OUTPUT_CFG                9231    //÷Ϳ
#define NET_DVR_GET_LED_OUTPUT_PORT_CFG            9232    //ȡLEDͿ˿ڲ
#define NET_DVR_SET_LED_OUTPUT_PORT_CFG            9233    //LEDͿ˿ڲ
#define NET_DVR_GET_LED_DISPLAY_AREA_CFG        9234    //ȡLEDͿʾ
#define NET_DVR_SET_LED_DISPLAY_AREA_CFG        9235    //LEDͿʾ
#define NET_DVR_GET_LED_PORT_CFG                9236    //ȡLEDͿ˿ڲ
#define NET_DVR_SET_LED_PORT_CFG                9237    //LEDͿ˿ڲ
#define NET_DVR_GET_LED_DISPLAY_CFG                9238    //ȡLEDͿʾ
#define NET_DVR_SET_LED_DISPLAY_CFG                9239    //LEDͿʾ
#define NET_DVR_GET_ALL_LED_PORT_CFG            9240    //ȡLEDͿĳӦ
#define NET_DVR_SAVE_LED_CONFIGURATION            9241    //̻
#define NET_DVR_GET_LED_TEST_SIGNAL_CFG            9242    //ȡLEDźŲ
#define NET_DVR_SET_LED_TEST_SIGNAL_CFG            9243    //LEDźŲ
#define NET_DVR_GET_LED_NOSIGNAL_CFG            9244    //ȡLEDźʾģʽ
#define NET_DVR_SET_LED_NOSIGNAL_CFG            9245    //LEDźʾģʽ
#define NET_DVR_GET_LED_INPUT_CFG                9246    //ȡLEDͿ
#define NET_DVR_SET_LED_INPUT_CFG                9247    //LEDͿ
#define NET_DVR_GET_LED_RECV_GAMMA_CFG            9248    //ȡտGAMMA
#define NET_DVR_SET_LED_RECV_GAMMA_CFG            9249    //ýտGAMMA
#define NET_DVR_GET_LED_RECV_CFG                9250    //ȡտ
#define NET_DVR_SET_LED_RECV_CFG                9251    //ýտ
#define NET_DVR_GET_LED_RECV_ADVANCED_CFG        9252    //ȡտ߼
#define NET_DVR_SET_LED_RECV_ADVANCED_CFG        9253    //ýտ߼
#define NET_DVR_GET_LED_SCREEN_DISPLAY_CFG        9254    //ȡLEDʾ
#define NET_DVR_SET_LED_SCREEN_DISPLAY_CFG        9255    //LEDʾ
/*******************************СLEDʾ end*****************************************/

#define    NET_DVR_GET_SCREEN_CONFIG               9260    //ȡĻ
#define    NET_DVR_SET_SCREEN_CONFIG               9261    //Ļ
#define NET_DVR_GET_SCREEN_CONFIG_CAP              9262    //ȡĻ

#define    NET_DVR_GET_SCHEDULE_PUBLISH_PROGRESS    9271    //ȡճ̷
#define    NET_DVR_GET_PUBLISH_UPGRADE_PROGRESS    9272    //ȡϢն

#define NET_DVR_GET_INPUT_BOARD_CFG                9281    //ȡϢ
#define NET_DVR_GET_INPUT_BOARD_CFG_LIST        9282    //ȡϢб
#define NET_DVR_SET_INPUT_BOARD_CFG                9283    //Ϣ

#define NET_DVR_GET_INPUT_SOURCE_TEXT_CAP    9284            //ȡԴַ
#define NET_DVR_GET_INPUT_SOURCE_TEXT_CFG    9285            //ȡԴַӲ
#define NET_DVR_GET_INPUT_SOURCE_TEXT_CFG_LSIT 9286        //ȡԴַӲб
#define NET_DVR_SET_INPUT_SOURCE_TEXT_CFG    9287            //ԴַӲ
#define NET_DVR_SET_INPUT_SOURCE_TEXT_CFG_LIST 9288        //ԴַӲб
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CAP    9289    //ȡԴԶֱ
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CFG    9290    //ȡԴԶֱʲ
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CFG_LIST    9291 //ȡԴԶֱб
#define NET_DVR_SET_INPUT_SOURCE_RESOLUTION_CFG    9292    //ԴԶֱʲ
#define NET_DVR_SET_INPUT_SOURCE_RESOLUTION_CFG_LIST  9293  //ԴԶֱʲ
#define NET_DVR_GET_LED_AREA_INFO_LIST  9295  //ȡLEDб

#define NET_DVR_GET_CURRENT_VALID_PORT          9300    //ȡǰЧ,ӵĶ˿

#define    NET_DVR_SET_ONLINE_UPGRADE                9301    //
#define NET_DVR_GET_ONLINEUPGRADE_PROGRESS      9302    //ȡ
#define    NET_DVR_GET_FIRMWARECODE                9303    //ȡʶ
#define NET_DVR_GET_ONLINEUPGRADE_SERVER        9304    //ȡ״̬
#define NET_DVR_GET_ONLINEUPGRADE_VERSION       9305    //ȡ°汾Ϣ
#define NET_DVR_GET_RECOMMEN_VERSION            9306    //ǷƼ˰汾
#define NET_DVR_GET_ONLINEUPGRADE_ABILITY       9309    //ȡ

#define NET_DVR_GET_RS485_WORK_MODE             10001 //ȡRS485ڹģʽ
#define NET_DVR_SET_RS485_WORK_MODE             10002 //RS485ڹģʽ
#define NET_DVR_GET_SPLITTER_TRANS_CHAN_CFG     10003 //ȡ͸ͨ
#define NET_DVR_SET_SPLITTER_TRANS_CHAN_CFG     10004 //͸ͨ

#define  NET_DVR_GET_SIP_CFG                    11001   //IPӻȡSIP
#define  NET_DVR_SET_SIP_CFG                    11002   //IPӻSIP
#define  NET_DVR_GET_IP_VIEW_DEVCFG                11003   //ȡIPԽֻ
#define  NET_DVR_SET_IP_VIEW_DEVCFG                11004   //IPԽֻ
#define  NET_DVR_GET_IP_VIEW_AUDIO_CFG            11005   //ȡIPԽֻƵ
#define  NET_DVR_SET_IP_VIEW_AUDIO_CFG            11006   //IPԽֻƵ
#define     NET_DVR_GET_IP_VIEW_CALL_CFG            11007   //ȡIPԽֻв
#define  NET_DVR_SET_IP_VIEW_CALL_CFG            11008   //IPԽֻв
#define     NET_DVR_GET_AUDIO_LIMIT_ALARM_CFG        11009    //ȡò
#define     NET_DVR_SET_AUDIO_LIMIT_ALARM_CFG        11010    //ò
#define     NET_DVR_GET_BUTTON_DOWN_ALARM_CFG        11011    //ȡť¸澯ò
#define     NET_DVR_SET_BUTTON_DOWN_ALARM_CFG        11012    //ðť¸澯ò

#define  NET_DVR_GET_ISCSI_CFG                  11070   // ȡISCSI洢Э 
#define  NET_DVR_SET_ISCSI_CFG                  11071   // ȡISCSI洢Э 

#define NET_DVR_GET_SECURITYMODE                12004   //ȡǰȫģʽ
//2013-11-21 ȡ豸ǰ¶Ⱥʪ
#define  NET_DVR_GET_TEMP_HUMI                  12005

//2014-02-15 IPCԶĿ
#define  NET_DVR_SET_ALARMSOUNDMODE             12006   //ñģʽ
#define  NET_DVR_GET_ALARMSOUNDMODE             12007   //ȡģʽ

#define    NET_DVR_SET_IPDEVICE_ACTIVATED       13000//ͨNVRǰ豸
#define NET_DVR_GET_DIGITAL_CHAN_SECURITY_STATUS    13001   //ȡͨӦ豸ȫ״̬
#define    NET_DVR_GET_ACTIVATE_IPC_ABILITY     13003    //ȡNVRIPC


/*******************************¥ӶԽ start***********************************/
#define NET_DVR_GET_VIDEO_INTERCOM_DEVICEID_CFG  16001  //ȡӶԽ豸
#define NET_DVR_SET_VIDEO_INTERCOM_DEVICEID_CFG  16002  //ÿӶԽ豸
#define NET_DVR_SET_PRIVILEGE_PASSWORD           16003  //ȨϢ
#define NET_DVR_GET_OPERATION_TIME_CFG           16004  //ȡʱ
#define NET_DVR_SET_OPERATION_TIME_CFG           16005  //òʱ
#define NET_DVR_GET_VIDEO_INTERCOM_RELATEDEV_CFG 16006  //ȡ豸
#define NET_DVR_SET_VIDEO_INTERCOM_RELATEDEV_CFG 16007  //ù豸
#define NET_DVR_REMOTECONTROL_NOTICE_DATA        16008  //Ϣ·
#define NET_DVR_REMOTECONTROL_GATEWAY            16009  //Զ̿
#define NET_DVR_REMOTECONTROL_OPERATION_AUTH     16010  //Ȩ֤

#define NET_DVR_GET_VIDEO_INTERCOM_IOIN_CFG      16016  //ȡIO
#define NET_DVR_SET_VIDEO_INTERCOM_IOIN_CFG      16017  //IO
#define NET_DVR_GET_VIDEO_INTERCOM_IOOUT_CFG     16018  //ȡIO
#define NET_DVR_SET_VIDEO_INTERCOM_IOOUT_CFG     16019  //IO
#define NET_DVR_GET_ELEVATORCONTROL_CFG          16020  //ȡݿ
#define NET_DVR_SET_ELEVATORCONTROL_CFG          16021  //ݿ
#define NET_DVR_GET_VIDEOINTERCOM_STREAM         16022  //ȡӶԽͨ
#define NET_DVR_SET_VIDEOINTERCOM_STREAM         16023  //ÿӶԽͨ
#define NET_DVR_GET_WDR_CFG                      16024  //ȡ̬
#define NET_DVR_SET_WDR_CFG                      16025  //ÿ̬
#define NET_DVR_GET_VIS_DEVINFO                  16026  //ȡ豸Ϣ
#define NET_DVR_GET_VIS_REGISTER_INFO            16027  //ȡ豸ע豸Ϣ
#define NET_DVR_GET_ELEVATORCONTROL_CFG_V40      16028  //ȡݿ-չ
#define NET_DVR_SET_ELEVATORCONTROL_CFG_V40      16029  //ݿ-չ
#define NET_DVR_GET_CALL_ROOM_CFG                 16030  //ȡס
#define NET_DVR_SET_CALL_ROOM_CFG                 16031  //ðס
#define NET_DVR_VIDEO_CALL_SIGNAL_PROCESS        16032  //ӻԽ
#define NET_DVR_GET_CALLER_INFO                  16033  //ȡгϢ
#define NET_DVR_GET_CALL_STATUS                  16034  //ȡͨ״̬
#define NET_DVR_GET_SERVER_DEVICE_INFO           16035  //ȡ豸б
#define NET_DVR_SET_CALL_SIGNAL                  16036  //ӶԽֻ˷
#define NET_DVR_GET_VIDEO_INTERCOM_ALARM_CFG       16037    //ȡӶԽ¼
#define NET_DVR_SET_VIDEO_INTERCOM_ALARM_CFG       16038    //ÿӶԽ¼
#define NET_DVR_GET_RING_LIST                    16039    //ѯб
/*******************************¥ӶԽ end***********************************/

#define    NET_DVR_DEBUGINFO_START                     18000    //豸Ϣ
#define    NET_DVR_AUTO_TEST_START                     18001    //ԶԳӻȡ

#define NET_DVR_GET_SELFCHECK_RESULT        20000    //ȡ豸Լ
#define NET_DVR_SET_TEST_COMMAND            20001    //òԿ
#define NET_DVR_SET_TEST_DEVMODULE          20002    //òӲģ
#define NET_DVR_GET_TEST_DEVMODULE          20003    //ȡӲģ

#define NET_DVR_SET_AUTOFOCUS_TEST          20004    //ԶԽ 2013-10-26
#define NET_DVR_CHECK_USER_STATUS           20005    //ûǷ
#define NET_DVR_GET_TEST_COMMAND            20010    //ȡԿ
#define NET_DVR_GET_DIAL_SWITCH_CFG         20200    //ȡ뿪Ϣ
#define NET_DVR_SET_AGING_TRICK_SCAN          20201  //ϻǰ󹤾߲
#define NET_DVR_GET_ECCENTRIC_CORRECT_STATE   20202  //ȡȡƫУ״̬


#define NET_DVR_T1_TEST_CMD                    131073 //ãͨı־ʲô.ݳȲô1024
//ʽΪ<T1TestCmd type="0"/>//ָ豸Ĭϲػ

// ֶƲ˵ģʽⲿ
#define NET_DVR_GET_MEMU_OUTPUT_MODE            155649            // ȡ˵ģʽ
#define NET_DVR_SET_MEMU_OUTPUT_MODE            155650            // ò˵ģʽ

/***************************DS9000(_V30) end *****************************/

#define NET_DVR_GET_TEST_VERSION_HEAD           268435441   //ȡ԰汾ͷ
#define NET_DVR_SET_TEST_VERSION_HEAD           268435442   //ò԰汾ͷ
#define NET_DVR_GET_TEST_VERSION_HEAD_V1        268435443   //ȡ԰汾ͷ-ڶ
#define NET_DVR_SET_TEST_VERSION_HEAD_V1        268435444   //ò԰汾ͷ-ڶ
#define NET_DVR_GET_TEST_VERSION_HEAD_V2        268435445   //ȡ԰汾ͷ-
#define NET_DVR_SET_TEST_VERSION_HEAD_V2        268435446   //ò԰汾ͷ-

#define NET_DVR_GET_TEST_VERSION_HEAD_ONLY_0    268435447   //ȡ԰汾ͷ,ǰһ汾
#define NET_DVR_SET_TEST_VERSION_HEAD_ONLY_0    268435448   //ò԰汾ͷ,ǰһ汾


#define MAX_LOCAL_ADDR_LEN             96        //SOCKS󱾵θ
#define    MAX_COUNTRY_NAME_LEN          4        //ҼдƳ

/************************DVR־ begin***************************/

/*  */
//
#define MAJOR_ALARM                        0x1
//
#define MINOR_ALARM_IN                    0x1        /*  */
#define MINOR_ALARM_OUT                    0x2        /*  */
#define MINOR_MOTDET_START                0x3        /* ƶⱨʼ */
#define MINOR_MOTDET_STOP                0x4        /* ƶⱨ */
#define MINOR_HIDE_ALARM_START            0x5        /* ڵʼ */
#define MINOR_HIDE_ALARM_STOP            0x6        /* ڵ */
#define MINOR_VCA_ALARM_START            0x7        /*ܱʼ*/
#define MINOR_VCA_ALARM_STOP            0x8        /*ֹܱͣ*/
#define MINOR_ITS_ALARM_START           0x09    // ͨ¼ʼ
#define MINOR_ITS_ALARM_STOP            0x0A    // ͨ¼
//2010-11-10 籨־
#define MINOR_NETALARM_START            0x0b    /*籨ʼ*/
#define MINOR_NETALARM_STOP             0x0c    /*籨*/
//2010-12-16 ־"MINOR_ALARM_IN"ʹ
#define MINOR_NETALARM_RESUME            0x0d    /*籨ָ*/
//2012-4-5 IPC PIRߡȱ
#define MINOR_WIRELESS_ALARM_START      0x0e  /* ߱ʼ */
#define MINOR_WIRELESS_ALARM_STOP          0x0f /* ߱ */
#define MINOR_PIR_ALARM_START           0x10  /* Ӧʼ */
#define MINOR_PIR_ALARM_STOP               0x11  /* Ӧ */
#define MINOR_CALLHELP_ALARM_START      0x12  /* ȱʼ */
#define MINOR_CALLHELP_ALARM_STOP          0x13  /* ȱ */
#define MINOR_IPCHANNEL_ALARMIN_START   0x14  //ͨ뿪ʼPCNVRڽյͨMINOR_ALARM_INͨ뿪ʼ10sղMINOR_ALARM_INͨ
#define MINOR_IPCHANNEL_ALARMIN_STOP    0x15  //ͨ뿪ʼͬ
#define MINOR_DETECTFACE_ALARM_START    0x16  /* ⱨʼ */
#define MINOR_DETECTFACE_ALARM_STOP      0x17  /* ⱨ */
#define MINOR_VQD_ALARM_START           0x18  //VQD
#define MINOR_VQD_ALARM_STOP            0x19  //VQD 
#define MINOR_VCA_SECNECHANGE_DETECTION 0x1a  //ⱨ 2013-07-16

#define MINOR_SMART_REGION_EXITING_BEGIN            0x1b  //뿪⿪ʼ
#define MINOR_SMART_REGION_EXITING_END              0x1c  //뿪
#define MINOR_SMART_LOITERING_BEGIN                 0x1d  //ǻ⿪ʼ
#define MINOR_SMART_LOITERING_END                   0x1e  //ǻ

#define MINOR_VCA_ALARM_LINE_DETECTION_BEGIN        0x20  
#define MINOR_VCA_ALARM_LINE_DETECTION_END          0x21  
#define MINOR_VCA_ALARM_INTRUDE_BEGIN                0x22  //⿪ʼ    
#define MINOR_VCA_ALARM_INTRUDE_END                       0x23  //    
#define MINOR_VCA_ALARM_AUDIOINPUT                    0x24   //Ƶ쳣
#define MINOR_VCA_ALARM_AUDIOABNORMAL                 0x25   //ǿͻ
#define MINOR_VCA_DEFOCUS_DETECTION_BEGIN           0x26  //齹⿪ʼ
#define MINOR_VCA_DEFOCUS_DETECTION_END                0x27  //齹

//NVR
#define MINOR_EXT_ALARM                             0x28/*IPCⲿ*/
#define MINOR_VCA_FACE_ALARM_BEGIN                    0x29    /*⿪ʼ*/
#define MINOR_SMART_REGION_ENTRANCE_BEGIN           0x2a  //⿪ʼ
#define MINOR_SMART_REGION_ENTRANCE_END             0x2b  //
#define MINOR_SMART_PEOPLE_GATHERING_BEGIN          0x2c  //Աۼ⿪ʼ
#define MINOR_SMART_PEOPLE_GATHERING_END            0x2d  //Աۼ
#define MINOR_SMART_FAST_MOVING_BEGIN               0x2e  //˶⿪ʼ
#define MINOR_SMART_FAST_MOVING_END                 0x2f  //˶

#define MINOR_VCA_FACE_ALARM_END                    0x30    /**/
#define MINOR_VCA_SCENE_CHANGE_ALARM_BEGIN            0x31   /*⿪ʼ*/
#define MINOR_VCA_SCENE_CHANGE_ALARM_END            0x32   /**/
#define MINOR_VCA_ALARM_AUDIOINPUT_BEGIN            0x33   /*Ƶ쳣뿪ʼ*/
#define MINOR_VCA_ALARM_AUDIOINPUT_END                0x34   /*Ƶ쳣*/
#define MINOR_VCA_ALARM_AUDIOABNORMAL_BEGIN            0x35  /*ǿͻ⿪ʼ*/
#define MINOR_VCA_ALARM_AUDIOABNORMAL_END            0x36  /*ǿͻ*/

#define MINOR_VCA_LECTURE_DETECTION_BEGIN           0x37  //ڿ⿪ʼ
#define MINOR_VCA_LECTURE_DETECTION_END             0x38  //ڿ
#define MINOR_VCA_ALARM_AUDIOSTEEPDROP              0x39  //ǿ 2014-03-21
#define MINOR_VCA_ANSWER_DETECTION_BEGIN            0x3a  //ش⿪ʼ
#define MINOR_VCA_ANSWER_DETECTION_END              0x3b  //ش

#define MINOR_SMART_PARKING_BEGIN                   0x3c   //ͣ⿪ʼ
#define MINOR_SMART_PARKING_END                     0x3d   //ͣ
#define MINOR_SMART_UNATTENDED_BAGGAGE_BEGIN        0x3e   //Ʒ⿪ʼ
#define MINOR_SMART_UNATTENDED_BAGGAGE_END          0x3f   //Ʒ
#define MINOR_SMART_OBJECT_REMOVAL_BEGIN            0x40   //Ʒȡ⿪ʼ
#define MINOR_SMART_OBJECT_REMOVAL_END              0x41   //Ʒȡ
#define MINOR_SMART_VEHICLE_ALARM_START             0x46   //Ƽ⿪ʼ
#define MINOR_SMART_VEHICLE_ALARM_STOP              0x47   //Ƽ
#define MINOR_THERMAL_FIREDETECTION                 0x48   //ȳ⿪ʼ
#define MINOR_THERMAL_FIREDETECTION_END             0x49   //ȳ
#define MINOR_SMART_VANDALPROOF_BEGIN               0x50   //ƻ⿪ʼ
#define MINOR_SMART_VANDALPROOF_END                 0x51   //ƻ

#define MINOR_THERMAL_SHIPSDETECTION                0x5a   //ȳֻ
#define MINOR_THERMAL_THERMOMETRY_EARLYWARNING_BEGIN 0x5b  //ȳԤʼ
#define MINOR_THERMAL_THERMOMETRY_EARLYWARNING_END  0x5c   //ȳԤ
#define MINOR_THERMAL_THERMOMETRY_ALARM_BEGIN       0x5d   //ȳ±ʼ
#define MINOR_THERMAL_THERMOMETRY_ALARM_END         0x5e   //ȳ±
#define MINOR_THERMAL_THERMOMETRY_DIFF_ALARM_BEGIN  0x5f   //ȳ²ʼ
#define MINOR_THERMAL_THERMOMETRY_DIFF_ALARM_END    0x60   //ȳ²
//0x400-0x1000 Ž
#define MINOR_ALARMIN_SHORT_CIRCUIT                 0x400  //·
#define MINOR_ALARMIN_BROKEN_CIRCUIT                0x401  //·
#define MINOR_ALARMIN_EXCEPTION                     0x402  //쳣
#define MINOR_ALARMIN_RESUME                        0x403  //ָ
#define MINOR_HOST_DESMANTLE_ALARM                  0x404  //𱨾
#define MINOR_HOST_DESMANTLE_RESUME                 0x405  //ָ
#define MINOR_CARD_READER_DESMANTLE_ALARM           0x406  //𱨾
#define MINOR_CARD_READER_DESMANTLE_RESUME          0x407  //ָ
#define MINOR_CASE_SENSOR_ALARM                     0x408  //¼뱨
#define MINOR_CASE_SENSOR_RESUME                    0x409  //¼ָ
#define MINOR_STRESS_ALARM                          0x40a  //вȱ
#define MINOR_OFFLINE_ECENT_NEARLY_FULL             0x40b  //¼90%
#define MINOR_CARD_MAX_AUTHENTICATE_FAIL            0x40c  //֤ʧܳα
#define MINOR_SD_CARD_FULL                          0x40d  //SD洢
#define MINOR_LINKAGE_CAPTURE_PIC                   0x40e  //ץ¼
#define MINOR_SECURITY_MODULE_DESMANTLE_ALARM        0x40f  //ſذȫģ𱨾
#define MINOR_SECURITY_MODULE_DESMANTLE_RESUME        0x410  //ſذȫģָ

#define MINOR_POS_START_ALARM                       0x411  //POS
#define MINOR_POS_END_ALARM                         0x412  //POS
/* 쳣 */
//
#define MAJOR_EXCEPTION                    0x2
//
#define MINOR_RAID_ERROR                0x20    /* 쳣 */
#define MINOR_VI_LOST                    0x21    /* ƵźŶʧ */
#define MINOR_ILLEGAL_ACCESS            0x22    /* Ƿ */
#define MINOR_HD_FULL                    0x23    /* Ӳ */
#define MINOR_HD_ERROR                    0x24    /* Ӳ̴ */
#define MINOR_DCD_LOST                    0x25    /* MODEM (ʹ) */
#define MINOR_IP_CONFLICT                0x26    /* IPַͻ */
#define MINOR_NET_BROKEN                0x27    /* Ͽ*/
#define MINOR_REC_ERROR                 0x28    /* ¼ */
#define MINOR_IPC_NO_LINK               0x29    /* IPC쳣 */
#define MINOR_VI_EXCEPTION              0x2a    /* Ƶ쳣(ֻģͨ) */
#define MINOR_IPC_IP_CONFLICT           0x2b    /*ipc ip ַ ͻ*/
#define MINOR_SENCE_EXCEPTION           0x2c    // 쳣

#define MINOR_PIC_REC_ERROR              0x2d    /* ץͼ--ȡͼƬļʧ*/
#define MINOR_VI_MISMATCH                0x2e    /* Ƶʽƥ*/
#define MINOR_RESOLUTION_MISMATCH        0x2f    /*ǰ/¼ֱʲƥ  */

//2009-12-16 Ƶۺƽ̨־
#define MINOR_FANABNORMAL                0x31    /* Ƶۺƽ̨״̬쳣 */
#define MINOR_FANRESUME                    0x32    /* Ƶۺƽ̨״ָ̬ */
#define MINOR_SUBSYSTEM_ABNORMALREBOOT    0x33    /* Ƶۺƽ̨6467쳣 */
#define MINOR_MATRIX_STARTBUZZER        0x34    /* Ƶۺƽ̨dm6467쳣 */

//2010-01-22 Ƶۺƽ̨쳣־
#define MINOR_NET_ABNORMAL                0x35    /*״̬쳣*/
#define MINOR_MEM_ABNORMAL                0x36    /*ڴ״̬쳣*/
#define MINOR_FILE_ABNORMAL                0x37    /*ļ״̬쳣*/
#define MINOR_PANEL_ABNORMAL            0x38 /*ǰ쳣*/
#define MINOR_PANEL_RESUME                0x39 /*ǰָ*/    
#define MINOR_RS485_DEVICE_ABNORMAL        0x3a     /*RS485״̬쳣*/
#define MINOR_RS485_DEVICE_REVERT        0x3b    /*RS485״̬쳣ָ*/

//2012-2-18 Ӵ쳣־
#define MINOR_SCREEN_SUBSYSTEM_ABNORMALREBOOT   0x3c            //Ӱ쳣
#define    MINOR_SCREEN_SUBSYSTEM_ABNORMALINSERT    0x3d            //Ӱ
#define    MINOR_SCREEN_SUBSYSTEM_ABNORMALPULLOUT    0x3e            //Ӱγ
#define    MINOR_SCREEN_ABNARMALTEMPERATURE        0x3f            //¶쳣
//2012-07-26 Ƶۺƽ̨v2.1
#define MINOR_HIGH_TEMPERATURE_PROTECT          0x40 //Ӱȱ

//Netra 2.2.2
#define MINOR_RECORD_OVERFLOW                   0x41              /**/  
#define MINOR_DSP_ABNORMAL                      0x42              //DSP쳣 

//Netra 3.0.0
#define MINOR_ANR_RECORD_FAIED                 0x43         /*ANR¼ʧ*/ 
#define MINOR_SPARE_WORK_DEVICE_EXCEPT         0x44            /*ȱ豸쳣*/
#define MINOR_START_IPC_MAS_FAILED             0x45            /*IPC MASʧ*/ 
// 256·NVR
#define MINOR_IPCM_CRASH                       0x46         /*IPCM쳣*/
#define MINOR_POE_POWER_EXCEPTION              0x47         /*POE 쳣*/
#define MINOR_UPLOAD_DATA_CS_EXCEPTION         0x48          //ƴ洢ϴʧ/
#define MINOR_DIAL_EXCEPTION                   0x49         /*쳣*/
#define MINOR_DEV_EXCEPTION_OFFLINE            0x50  //豸쳣
#define MINOR_UPGRADEFAIL                      0x51 //Զ豸ʧ
#define MINOR_AI_LOST                           0x52    /* ƵźŶʧ */
#define MINOR_SYNC_IPC_PASSWD                   0x53    /* ͬIPC쳣 */
#define MINOR_EZVIZ_OFFLINE                        0x54    /* өʯ쳣*/
#define MINOR_VQD_ABNORMAL                        0x55 //VQD쳣
#define MINOR_ACCESSORIES_PLATE                0x57 //쳣

//0x400-0x1000 Ž쳣
#define MINOR_DEV_POWER_ON                     0x400  //豸ϵ
#define MINOR_DEV_POWER_OFF                    0x401  //豸ر
#define MINOR_WATCH_DOG_RESET                  0x402  //Źλ
#define MINOR_LOW_BATTERY                      0x403  //صѹ
#define MINOR_BATTERY_RESUME                   0x404  //صѹָ
#define MINOR_AC_OFF                           0x405  //ϵ
#define MINOR_AC_RESUME                        0x406  //ָ
#define MINOR_NET_RESUME                       0x407  //ָ
#define MINOR_FLASH_ABNORMAL                   0x408  //FLASHд쳣
#define MINOR_CARD_READER_OFFLINE              0x409  //
#define MINOR_CARD_READER_RESUME               0x40a  //߻ָ                   
#define MINOR_INDICATOR_LIGHT_OFF              0x40b  //ָʾƹر
#define MINOR_INDICATOR_LIGHT_RESUME           0x40c  //ָʾƻָ
#define MINOR_CHANNEL_CONTROLLER_OFF           0x40d  //ͨ
#define MINOR_CHANNEL_CONTROLLER_RESUME        0x40e  //ָͨ
#define MINOR_SECURITY_MODULE_OFF               0x40f  //ſذȫģ
#define MINOR_SECURITY_MODULE_RESUME           0x410  //ſذȫģ
//[add]by silujie 2013-3-22 14:16
//0x2000~0x3fff Ϊ豸־
//0x4000~0x5000 Ϊ豸쳣־
#define MINOR_SUBSYSTEM_IP_CONFLICT        0x4000        //ӰIPͻ
#define MINOR_SUBSYSTEM_NET_BROKEN        0x4001        //Ӱ
#define    MINOR_FAN_ABNORMAL                0x4002        //쳣
#define    MINOR_BACKPANEL_TEMPERATURE_ABNORMAL        0x4003        //¶쳣

#define    MINOR_SDCARD_ABNORMAL            0x4004        //SD
#define    MINOR_SDCARD_DAMAGE                0x4005        //SD


/*  */
//
#define MAJOR_OPERATION                    0x3

//
#define MINOR_VCA_MOTIONEXCEPTION        0x29  //쳣
#define MINOR_START_DVR                    0x41    /*  */
#define MINOR_STOP_DVR                    0x42    /* ػ */
#define MINOR_STOP_ABNORMAL                0x43    /* 쳣ػ */
#define MINOR_REBOOT_DVR                0x44    /*豸*/

#define MINOR_LOCAL_LOGIN                0x50    /* ص½ */
#define MINOR_LOCAL_LOGOUT                0x51    /* ע½ */
#define MINOR_LOCAL_CFG_PARM            0x52    /* ò */
#define MINOR_LOCAL_PLAYBYFILE          0x53    /* ذļطŻ */
#define MINOR_LOCAL_PLAYBYTIME          0x54    /* ذʱطŻ*/
#define MINOR_LOCAL_START_REC            0x55    /* ؿʼ¼ */
#define MINOR_LOCAL_STOP_REC            0x56    /* ֹͣ¼ */
#define MINOR_LOCAL_PTZCTRL                0x57    /* ̨ */
#define MINOR_LOCAL_PREVIEW                0x58    /* Ԥ (ʹ)*/
#define MINOR_LOCAL_MODIFY_TIME         0x59    /* ޸ʱ(ʹ) */
#define MINOR_LOCAL_UPGRADE             0x5a    /*  */
#define MINOR_LOCAL_RECFILE_OUTPUT      0x5b    /* ر¼ļ */
#define MINOR_LOCAL_FORMAT_HDD          0x5c    /* سʼӲ */
#define MINOR_LOCAL_CFGFILE_OUTPUT      0x5d    /* ļ */
#define MINOR_LOCAL_CFGFILE_INPUT       0x5e    /* 뱾ļ */
#define MINOR_LOCAL_COPYFILE            0x5f    /* رļ */
#define MINOR_LOCAL_LOCKFILE            0x60    /* ¼ļ */
#define MINOR_LOCAL_UNLOCKFILE          0x61    /* ؽ¼ļ */
#define MINOR_LOCAL_DVR_ALARM           0x62    /* ֶʹ*/
#define MINOR_IPC_ADD                   0x63    /* IPC */
#define MINOR_IPC_DEL                   0x64    /* ɾIPC */
#define MINOR_IPC_SET                   0x65    /* IPC */
#define MINOR_LOCAL_START_BACKUP        0x66    /* ؿʼ */
#define MINOR_LOCAL_STOP_BACKUP            0x67    /* ֹͣ*/
#define MINOR_LOCAL_COPYFILE_START_TIME 0x68    /* رݿʼʱ*/
#define MINOR_LOCAL_COPYFILE_END_TIME    0x69    /* رݽʱ*/
#define MINOR_LOCAL_ADD_NAS             0x6a    /*Ӳ nfsiscsi*/
#define MINOR_LOCAL_DEL_NAS             0x6b    /* ɾnas nfsiscsi*/
#define MINOR_LOCAL_SET_NAS             0x6c    /* nas nfsiscsi*/
#define MINOR_LOCAL_RESET_PASSWD        0x6d    /* ػָԱĬ*/ 

#define MINOR_REMOTE_LOGIN                0x70    /* Զ̵¼ */
#define MINOR_REMOTE_LOGOUT                0x71    /* Զע½ */
#define MINOR_REMOTE_START_REC            0x72    /* Զ̿ʼ¼ */
#define MINOR_REMOTE_STOP_REC            0x73    /* Զֹͣ¼ */
#define MINOR_START_TRANS_CHAN            0x74    /* ʼ͸ */
#define MINOR_STOP_TRANS_CHAN            0x75    /* ֹͣ͸ */
#define MINOR_REMOTE_GET_PARM            0x76    /* Զ̻ȡ */
#define MINOR_REMOTE_CFG_PARM            0x77    /* Զò */
#define MINOR_REMOTE_GET_STATUS         0x78    /* Զ̻ȡ״̬ */
#define MINOR_REMOTE_ARM                0x79    /* Զ̲ */
#define MINOR_REMOTE_DISARM                0x7a    /* Զ̳ */
#define MINOR_REMOTE_REBOOT                0x7b    /* Զ */
#define MINOR_START_VT                    0x7c    /* ʼԽ */
#define MINOR_STOP_VT                    0x7d    /* ֹͣԽ */
#define MINOR_REMOTE_UPGRADE            0x7e    /* Զ */
#define MINOR_REMOTE_PLAYBYFILE         0x7f    /* Զ̰ļط */
#define MINOR_REMOTE_PLAYBYTIME         0x80    /* Զ̰ʱط */
#define MINOR_REMOTE_PTZCTRL            0x81    /* Զ̨ */
#define MINOR_REMOTE_FORMAT_HDD         0x82    /* Զ̸ʽӲ */
#define MINOR_REMOTE_STOP               0x83    /* Զ̹ػ */
#define MINOR_REMOTE_LOCKFILE            0x84    /* Զļ */
#define MINOR_REMOTE_UNLOCKFILE         0x85    /* Զ̽ļ */
#define MINOR_REMOTE_CFGFILE_OUTPUT     0x86    /* Զ̵ļ */
#define MINOR_REMOTE_CFGFILE_INTPUT     0x87    /* Զ̵ļ */
#define MINOR_REMOTE_RECFILE_OUTPUT     0x88    /* Զ̵¼ļ */
#define MINOR_REMOTE_DVR_ALARM          0x89    /* Զֶʹ*/
#define MINOR_REMOTE_IPC_ADD            0x8a    /* ԶIPC */
#define MINOR_REMOTE_IPC_DEL            0x8b    /* ԶɾIPC */
#define MINOR_REMOTE_IPC_SET            0x8c    /* ԶIPC */
#define MINOR_REBOOT_VCA_LIB            0x8d    /*ܿ*/
#define MINOR_REMOTE_ADD_NAS            0x8e   /* Զnas nfsiscsi*/
#define MINOR_REMOTE_DEL_NAS            0x8f   /* Զɾnas nfsiscsi*/
#define MINOR_REMOTE_SET_NAS            0x90   /* Զnas nfsiscsi*/
#define MINOR_LOCAL_OPERATE_LOCK        0x9d            /* ز             */
#define MINOR_LOCAL_OPERATE_UNLOCK      0x9e            /* ز         */
#define MINOR_REMOTE_DELETE_HDISK       0x9a            /* Զɾ쳣ڵӲ */
#define MINOR_REMOTE_LOAD_HDISK         0x9b            /* Զ̼Ӳ             */
#define MINOR_REMOTE_UNLOAD_HDISK       0x9c            /* ԶжӲ   */


//2010-05-26 ѶDVR־
#define MINOR_LOCAL_START_REC_CDRW      0x91   /* ؿʼѶ */
#define MINOR_LOCAL_STOP_REC_CDRW       0x92   /* ֹͣѶ */
#define MINOR_REMOTE_START_REC_CDRW     0x93   /* Զ̿ʼѶ */
#define MINOR_REMOTE_STOP_REC_CDRW      0x94   /* ԶֹͣѶ */

#define MINOR_LOCAL_PIC_OUTPUT            0x95   /* رͼƬļ */ 
#define MINOR_REMOTE_PIC_OUTPUT            0x96   /* Զ̱ͼƬļ */

//2011-07-26 81ѶDVR־
#define MINOR_LOCAL_INQUEST_RESUME      0x97   /* ػָѶ¼*/
#define MINOR_REMOTE_INQUEST_RESUME     0x98   /* Զָ̻Ѷ¼*/

//2013-01-23 86ѶNVR־
#define MINOR_LOCAL_ADD_FILE            0x99        /*صļ*/
#define MINOR_LOCAL_DEL_FILE            0x9f        /*ɾѶ*/
#define MINOR_REMOTE_INQUEST_ADD_FILE   0x100       /*Զ̵ļ*/ 
#define MINOR_REMOTE_INQUEST_DEL_FILE   0x101       /*Զɾļ*/

//2009-12-16 Ƶۺƽ̨־
#define MINOR_SUBSYSTEMREBOOT           0xa0    /*Ƶۺƽ̨dm6467 */
#define MINOR_MATRIX_STARTTRANSFERVIDEO 0xa1    /*Ƶۺƽ̨лʼͼ*/
#define MINOR_MATRIX_STOPTRANSFERVIDEO    0xa2    /*Ƶۺƽ̨лֹͣͼ*/
#define MINOR_REMOTE_SET_ALLSUBSYSTEM   0xa3    /*Ƶۺƽ̨6467ϵͳϢ*/
#define MINOR_REMOTE_GET_ALLSUBSYSTEM   0xa4    /*Ƶۺƽ̨ȡ6467ϵͳϢ*/
#define MINOR_REMOTE_SET_PLANARRAY      0xa5    /*Ƶۺƽ̨üƻѲ*/
#define MINOR_REMOTE_GET_PLANARRAY      0xa6    /*Ƶۺƽ̨ȡƻѲ*/
#define MINOR_MATRIX_STARTTRANSFERAUDIO 0xa7    /*Ƶۺƽ̨лʼƵ*/
#define MINOR_MATRIX_STOPRANSFERAUDIO   0xa8    /*Ƶۺƽ̨лֹͣƵ*/
#define MINOR_LOGON_CODESPITTER         0xa9    /*Ƶۺƽ̨½*/
#define MINOR_LOGOFF_CODESPITTER        0xaa    /*Ƶۺƽ̨˳*/

//2010-01-22 Ƶۺƽ̨н־
#define MINOR_START_DYNAMIC_DECODE         0xb0    /*ʼ̬*/
#define MINOR_STOP_DYNAMIC_DECODE        0xb1    /*ֹ̬ͣ*/
#define MINOR_GET_CYC_CFG                0xb2    /*ȡͨѲ*/
#define MINOR_SET_CYC_CFG                0xb3    /*ýͨѲ*/
#define MINOR_START_CYC_DECODE            0xb4    /*ʼѲ*/
#define MINOR_STOP_CYC_DECODE            0xb5    /*ֹͣѲ*/
#define MINOR_GET_DECCHAN_STATUS        0xb6    /*ȡͨ״̬*/
#define MINOR_GET_DECCHAN_INFO            0xb7    /*ȡͨǰϢ*/
#define MINOR_START_PASSIVE_DEC            0xb8    /*ʼ*/
#define MINOR_STOP_PASSIVE_DEC            0xb9    /*ֹͣ*/
#define MINOR_CTRL_PASSIVE_DEC            0xba    /*Ʊ*/
#define MINOR_RECON_PASSIVE_DEC            0xbb    /**/
#define MINOR_GET_DEC_CHAN_SW            0xbc    /*ȡͨܿ*/
#define MINOR_SET_DEC_CHAN_SW            0xbd    /*ýͨܿ*/
#define MINOR_CTRL_DEC_CHAN_SCALE        0xbe    /*ͨſ*/
#define MINOR_SET_REMOTE_REPLAY            0xbf    /*Զ̻ط*/
#define MINOR_GET_REMOTE_REPLAY            0xc0    /*ȡԶ̻ط״̬*/
#define MINOR_CTRL_REMOTE_REPLAY        0xc1    /*Զ̻طſ*/
#define MINOR_SET_DISP_CFG                0xc2    /*ʾͨ*/
#define MINOR_GET_DISP_CFG                0xc3    /*ȡʾͨ*/
#define MINOR_SET_PLANTABLE                0xc4    /*üƻѲ*/
#define MINOR_GET_PLANTABLE                0xc5    /*ȡƻѲ*/
#define MINOR_START_PPPPOE                0xc6    /*ʼPPPoE*/
#define MINOR_STOP_PPPPOE                0xc7    /*PPPoE*/
#define MINOR_UPLOAD_LOGO                0xc8    /*ϴLOGO*/
//ģʽ־
#define MINOR_LOCAL_PIN                    0xc9    /* PINܲ */
#define MINOR_LOCAL_DIAL                0xca    /* ֶϿ */    
#define MINOR_SMS_CONTROL                0xcb    /* ſ */    
#define MINOR_CALL_ONLINE                0xcc    /* п */    
#define MINOR_REMOTE_PIN                0xcd    /* ԶPINܲ */

//2010-12-16 ־
#define MINOR_REMOTE_BYPASS             0xd0    /* Զ·*/
#define MINOR_REMOTE_UNBYPASS           0xd1    /* Զ·ָ*/
#define MINOR_REMOTE_SET_ALARMIN_CFG    0xd2    /* Զñ*/
#define MINOR_REMOTE_GET_ALARMIN_CFG    0xd3    /* Զ̻ȡ*/
#define MINOR_REMOTE_SET_ALARMOUT_CFG   0xd4    /* Զñ*/
#define MINOR_REMOTE_GET_ALARMOUT_CFG   0xd5    /* Զ̻ȡ*/
#define MINOR_REMOTE_ALARMOUT_OPEN_MAN  0xd6    /* Զֶ*/
#define MINOR_REMOTE_ALARMOUT_CLOSE_MAN 0xd7    /* Զֶرձ*/
#define MINOR_REMOTE_ALARM_ENABLE_CFG   0xd8    /* ԶñRS485ʹ״̬*/
#define MINOR_DBDATA_OUTPUT                0xd9    /* ݿ¼ */
#define MINOR_DBDATA_INPUT                0xda    /* ݿ¼ */
#define MINOR_MU_SWITCH                    0xdb    /* л */
#define MINOR_MU_PTZ                    0xdc    /* PTZ */
#define MINOR_DELETE_LOGO               0xdd    /* ɾlogo */

#define MINOR_LOCAL_CONF_REB_RAID       0x101           /*Զؽ*/
#define MINOR_LOCAL_CONF_SPARE          0x102           /*ȱ*/
#define MINOR_LOCAL_ADD_RAID            0x103           /*ش*/
#define MINOR_LOCAL_DEL_RAID            0x104           /*ɾ*/
#define MINOR_LOCAL_MIG_RAID            0x105           /*Ǩ*/
#define MINOR_LOCAL_REB_RAID            0x106           /* ֶؽ*/
#define MINOR_LOCAL_QUICK_CONF_RAID     0x107           /*һ*/
#define MINOR_LOCAL_ADD_VD              0x108           /*ش*/
#define MINOR_LOCAL_DEL_VD              0x109           /*ɾ*/
#define MINOR_LOCAL_RP_VD               0x10a           /*޸*/
#define MINOR_LOCAL_FORMAT_EXPANDVD     0X10b           /*չ*/
#define MINOR_LOCAL_RAID_UPGRADE        0X10c           /*raid*/  
#define MINOR_LOCAL_STOP_RAID           0x10d           /*ͣRAID(ȫ)*/  
#define MINOR_REMOTE_CONF_REB_RAID      0x111           /*ԶԶؽ*/
#define MINOR_REMOTE_CONF_SPARE         0x112            /*Զȱ*/
#define MINOR_REMOTE_ADD_RAID           0x113           /*Զ̴*/
#define MINOR_REMOTE_DEL_RAID           0x114           /*Զɾ*/
#define MINOR_REMOTE_MIG_RAID           0x115           /*ԶǨ*/
#define MINOR_REMOTE_REB_RAID           0x116           /* Զֶؽ*/
#define MINOR_REMOTE_QUICK_CONF_RAID    0x117           /*Զһ*/
#define MINOR_REMOTE_ADD_VD             0x118           /*Զ̴*/
#define MINOR_REMOTE_DEL_VD             0x119           /*Զɾ*/
#define MINOR_REMOTE_RP_VD              0x11a           /*Զ޸*/
#define MINOR_REMOTE_FORMAT_EXPANDVD    0X11b           /*Զ*/
#define MINOR_REMOTE_RAID_UPGRADE       0X11c           /*Զraid*/  
#define MINOR_REMOTE_STOP_RAID          0x11d           /*ԶͣRAID(ȫ)*/
#define MINOR_LOCAL_START_PIC_REC       0x121          /*ؿʼץͼ*/ 
#define MINOR_LOCAL_STOP_PIC_REC        0x122          /*ֹͣץͼ*/
#define MINOR_LOCAL_SET_SNMP            0x125           /*SNMP*/
#define MINOR_LOCAL_TAG_OPT             0x126          /*رǩ*/
#define MINOR_REMOTE_START_PIC_REC      0x131          /*Զ̿ʼץͼ*/
#define MINOR_REMOTE_STOP_PIC_REC       0x132           /*Զֹͣץͼ*/
#define MINOR_REMOTE_SET_SNMP           0x135            /*ԶSNMP*/
#define MINOR_REMOTE_TAG_OPT            0x136             /*Զ̱ǩ*/  

// 9000 v2.2.0
#define MINOR_LOCAL_VOUT_SWITCH         0x140   /* л*/
#define MINOR_STREAM_CABAC                 0x141   /* ѹѡò*/

//Netra 3.0.0
#define MINOR_LOCAL_SPARE_OPT           0x142   /*N+1 ȱز*/
#define MINOR_REMOTE_SPARE_OPT            0x143   /*ԶN+1 ȱز*/
#define MINOR_LOCAL_IPCCFGFILE_OUTPUT    0x144      /* صipcļ*/
#define MINOR_LOCAL_IPCCFGFILE_INPUT      0x145   /* صipcļ */
#define MINOR_LOCAL_IPC_UPGRADE         0x146   /* IPC */
#define MINOR_REMOTE_IPCCFGFILE_OUTPUT  0x147   /* Զ̵ipcļ*/
#define MINOR_REMOTE_IPCCFGFILE_INPUT   0x148   /* Զ̵ipcļ*/
#define MINOR_REMOTE_IPC_UPGRADE        0x149   /* ԶIPC */
//NVR 96000
#define MINOR_VQD_CFG                   0x150    //ƵϣVQD



#define MINOR_SET_MULTI_MASTER          0x201    /*ô*/
#define MINOR_SET_MULTI_SLAVE           0x202    /*ô*/
#define MINOR_CANCEL_MULTI_MASTER       0x203    /*ȡ*/
#define MINOR_CANCEL_MULTI_SLAVE        0x204    /*ȡ*/

#define MINOR_DISPLAY_LOGO                0x205    /*ʾLOGO*/
#define MINOR_HIDE_LOGO                 0x206    /*LOGO*/
#define MINOR_SET_DEC_DELAY_LEVEL       0x207    /*ͨʱ*/
#define MINOR_SET_BIGSCREEN_DIPLAY_AREA 0x208    /*ôʾ*/
#define MINOR_CUT_VIDEO_SOURCE          0x209    /*ƵԴи*/
#define MINOR_SET_BASEMAP_AREA          0x210    /*ͼ*/
#define MINOR_DOWNLOAD_BASEMAP          0x211    /*شͼ*/
#define MINOR_CUT_BASEMAP               0x212    /*ͼи*/
#define MINOR_CONTROL_ELEC_ENLARGE      0x213    /*ӷŴ(Ŵԭ)*/
#define MINOR_SET_OUTPUT_RESOLUTION     0x214    /*ʾֱ*/
#define MINOR_SET_TRANCSPARENCY         0X215    /*ͼ͸*/
#define MINOR_SET_OSD                   0x216    /*ʾOSD*/
#define MINOR_RESTORE_DEC_STATUS        0x217    /*ָʼ״̬(лʱָʼ״̬)*/

//2011-11-11 Ӵ־
#define MINOR_SCREEN_SET_INPUT            0x251    /*޸Դ*/
#define MINOR_SCREEN_SET_OUTPUT            0x252    /*޸ͨ*/
#define MINOR_SCREEN_SET_OSD            0x253    /*޸LED*/
#define MINOR_SCREEN_SET_LOGO            0x254    /*޸LOGO*/
#define MINOR_SCREEN_SET_LAYOUT            0x255    /*ò*/
#define    MINOR_SCREEN_PICTUREPREVIEW        0x256     /*Բ*/

//2012-06-14 CVCS2.0, õȲV1.0 V1.1Ѿˣʱ豸־ûж 
#define MINOR_SCREEN_GET_OSD            0x257   /*ȡLED*/
#define MINOR_SCREEN_GET_LAYOUT            0x258   /*ȡ*/
#define MINOR_SCREEN_LAYOUT_CTRL        0x259   /*ֿ*/
#define MINOR_GET_ALL_VALID_WND            0x260    /*ȡЧ*/
#define MINOR_GET_SIGNAL_WND            0x261    /*ȡϢ*/
#define MINOR_WINDOW_CTRL                0x262    /*ڿ*/
#define MINOR_GET_LAYOUT_LIST            0x263    /*ȡб*/
#define MINOR_LAYOUT_CTRL                0x264    /*ֿ*/
#define MINOR_SET_LAYOUT                0x265    /*ò*/
#define MINOR_GET_SIGNAL_LIST            0x266    /*ȡźԴб*/
#define MINOR_GET_PLAN_LIST                0x267    /*ȡԤб*/
#define MINOR_SET_PLAN                    0x268    /*޸Ԥ*/
#define MINOR_CTRL_PLAN                    0x269    /*Ԥ*/
#define MINOR_CTRL_SCREEN                0x270    /*Ļ*/
#define MINOR_ADD_NETSIG                0x271    /*źԴ*/
#define MINOR_SET_NETSIG                0x272    /*޸źԴ*/
#define MINOR_SET_DECBDCFG                0x273    /*ý*/
#define MINOR_GET_DECBDCFG                0x274    /*ȡ*/
#define MINOR_GET_DEVICE_STATUS            0x275    /*ȡ豸Ϣ*/
#define MINOR_UPLOAD_PICTURE            0x276    /*ͼϴ*/
#define MINOR_SET_USERPWD                0x277    /*û*/
#define MINOR_ADD_LAYOUT                0x278    /*Ӳ*/
#define MINOR_DEL_LAYOUT                0x279    /*ɾ*/
#define MINOR_DEL_NETSIG                0x280    /*ɾźԴ*/
#define MINOR_ADD_PLAN                    0x281    /*Ԥ*/
#define MINOR_DEL_PLAN                    0x282    /*ɾԤ*/
#define MINOR_GET_EXTERNAL_MATRIX_CFG    0x283    //ȡӾ
#define MINOR_SET_EXTERNAL_MATRIX_CFG    0x284    //Ӿ
#define    MINOR_GET_USER_CFG                0x285    //ȡû
#define    MINOR_SET_USER_CFG                0x286    //û
#define    MINOR_GET_DISPLAY_PANEL_LINK_CFG 0x287    //ȡʾǽ
#define    MINOR_SET_DISPLAY_PANEL_LINK_CFG 0x288    //ʾǽ

#define    MINOR_GET_WALLSCENE_PARAM        0x289        //ȡǽ
#define    MINOR_SET_WALLSCENE_PARAM        0x28a        //õǽ
#define    MINOR_GET_CURRENT_WALLSCENE        0x28b        //ȡǰʹó
#define    MINOR_SWITCH_WALLSCENE            0x28c        //л
#define    MINOR_SIP_LOGIN                    0x28d        //SIPעɹ
#define MINOR_VOIP_START                0x28e        //VOIPԽʼ
#define MINOR_VOIP_STOP                    0x28f        //VOIPԽֹͣ
#define MINOR_WIN_TOP                   0x290       //ǽö
#define MINOR_WIN_BOTTOM                0x291       //ǽõ

// Netra 2.2.2
#define MINOR_LOCAL_LOAD_HDISK          0x300            //ؼӲ             
#define MINOR_LOCAL_DELETE_HDISK        0x301            //ɾ쳣ڵӲ

//KY2013 3.0.0
#define MINOR_LOCAL_MAIN_AUXILIARY_PORT_SWITCH    0X302 //л
#define MINOR_LOCAL_HARD_DISK_CHECK                0x303 //ӲԼ

//Netra3.1.0
#define MINOR_LOCAL_CFG_DEVICE_TYPE        0x310    //豸
#define MINOR_REMOTE_CFG_DEVICE_TYPE    0x311    //Զ豸
#define MINOR_LOCAL_CFG_WORK_HOT_SERVER    0x312    //ùȱ
#define MINOR_REMOTE_CFG_WORK_HOT_SERVER 0x313    //Զùȱ
#define MINOR_LOCAL_DELETE_WORK            0x314    //ɾ
#define MINOR_REMOTE_DELETE_WORK        0x315    //Զɾ
#define    MINOR_LOCAL_ADD_WORK            0x316    //ӹ
#define MINOR_REMOTE_ADD_WORK            0x317    //Զӹ
#define MINOR_LOCAL_IPCHEATMAP_OUTPUT   0x318            /* صȶͼļ      */
#define MINOR_LOCAL_IPCHEATFLOW_OUTPUT  0x319          /* صȶļ      */
#define MINOR_REMOTE_SMS_SEND           0x350    /*Զ̷Ͷ*/
#define MINOR_LOCAL_SMS_SEND            0x351   /*طͶ*/
#define MINOR_ALARM_SMS_SEND            0x352    /*Ͷű*/
#define MINOR_SMS_RECV                  0x353     /*ն*/
//ע0x3500x351ָ˹GUIIEؼϱ༭Ͷţ
#define MINOR_LOCAL_SMS_SEARCH          0x354  /**/
#define MINOR_REMOTE_SMS_SEARCH         0x355   /*Զ*/
#define MINOR_LOCAL_SMS_READ            0x356   /*ز鿴*/
#define MINOR_REMOTE_SMS_READ           0x357   /*Զ̲鿴*/
#define MINOR_REMOTE_DIAL_CONNECT       0x358   /*Զֶ̿*/
#define MINOR_REMOTE_DIAL_DISCONN       0x359   /*Զֶֹͣ*/
#define MINOR_LOCAL_WHITELIST_SET       0x35A   /*ð*/
#define MINOR_REMOTE_WHITELIST_SET      0x35B   /*Զð*/
#define MINOR_LOCAL_DIAL_PARA_SET       0x35C   /*òŲ*/
#define MINOR_REMOTE_DIAL_PARA_SET      0x35D   /*ԶòŲ*/
#define MINOR_LOCAL_DIAL_SCHEDULE_SET   0x35E   /*òżƻ*/
#define MINOR_REMOTE_DIAL_SCHEDULE_SET  0x35F   /*Զòżƻ*/
#define MINOR_PLAT_OPER                 0x360   /* ƽ̨*/

//0x400-0x1000 Ž
#define MINOR_REMOTE_OPEN_DOOR          0x400   //Զ̿
#define MINOR_REMOTE_CLOSE_DOOR         0x401   //Զ̹
#define MINOR_REMOTE_ALWAYS_OPEN        0x402   //Զ̳
#define MINOR_REMOTE_ALWAYS_CLOSE       0x403   //Զ̳
#define MINOR_REMOTE_CHECK_TIME         0x404   //ԶֶУʱ
#define MINOR_NTP_CHECK_TIME            0x405   //NTPԶУʱ
#define MINOR_REMOTE_CLEAR_CARD         0x406   //Զտ
#define MINOR_REMOTE_RESTORE_CFG        0x407   //Զָ̻Ĭϲ
#define MINOR_ALARMIN_ARM               0x408   //
#define MINOR_ALARMIN_DISARM            0x409   //
#define MINOR_LOCAL_RESTORE_CFG         0x40a   //ػָĬϲ 
#define MINOR_REMOTE_CAPTURE_PIC        0x40b  //Զץ
#define MINOR_MOD_NET_REPORT_CFG        0x40c   //޸Ĳ
#define MINOR_MOD_GPRS_REPORT_PARAM     0x40d   //޸GPRSĲ
#define MINOR_MOD_REPORT_GROUP_PARAM    0x40e   //޸
#define    MINOR_UNLOCK_PASSWORD_OPEN_DOOR  0x40f  //

//2012-03-05 ITC־
#define MINOR_SET_TRIGGERMODE_CFG          0x1001    /*ôģʽ*/
#define MINOR_GET_TRIGGERMODE_CFG          0x1002    /*ȡģʽ*/
#define MINOR_SET_IOOUT_CFG                0x1003    /*IO*/
#define MINOR_GET_IOOUT_CFG                0x1004    /*ȡIO*/
#define MINOR_GET_TRIGGERMODE_DEFAULT      0x1005    /*ȡģʽƼ*/
#define MINOR_GET_ITCSTATUS                0x1006    /*ȡ״̬*/
#define MINOR_SET_STATUS_DETECT_CFG        0x1007    /*״̬*/
#define MINOR_GET_STATUS_DETECT_CFG        0x1008    /*ȡ״̬*/
#define MINOR_SET_VIDEO_TRIGGERMODE_CFG    0x1009  /*Ƶģʽ*/
#define MINOR_GET_VIDEO_TRIGGERMODE_CFG    0x100a   /*ȡƵģʽ*/

//2013-04-19 ITS־
#define MINOR_LOCAL_ADD_CAR_INFO            0x2001  /*ӳϢ*/
#define MINOR_LOCAL_MOD_CAR_INFO            0x2002  /*޸ĳϢ*/
#define MINOR_LOCAL_DEL_CAR_INFO            0x2003  /*ɾϢ*/
#define MINOR_LOCAL_FIND_CAR_INFO           0x2004  /*زҳϢ*/
#define MINOR_LOCAL_ADD_MONITOR_INFO        0x2005  /*ӲϢ*/
#define MINOR_LOCAL_MOD_MONITOR_INFO        0x2006  /*޸ĲϢ*/
#define MINOR_LOCAL_DEL_MONITOR_INFO        0x2007  /*ɾϢ*/
#define MINOR_LOCAL_FIND_MONITOR_INFO       0x2008  /*زѯϢ*/
#define MINOR_LOCAL_FIND_NORMAL_PASS_INFO   0x2009  /*زѯͨϢ*/
#define MINOR_LOCAL_FIND_ABNORMAL_PASS_INFO 0x200a  /*زѯ쳣ͨϢ*/
#define MINOR_LOCAL_FIND_PEDESTRIAN_PASS_INFO   0x200b  /*زѯͨϢ*/
#define MINOR_LOCAL_PIC_PREVIEW             0x200c  /*ͼƬԤ*/
#define MINOR_LOCAL_SET_GATE_PARM_CFG       0x200d  /*ñóڲ*/
#define MINOR_LOCAL_GET_GATE_PARM_CFG       0x200e  /*ȡóڲ*/
#define MINOR_LOCAL_SET_DATAUPLOAD_PARM_CFG 0x200f  /*ñϴ*/
#define MINOR_LOCAL_GET_DATAUPLOAD_PARM_CFG 0x2010  /*ȡϴ*/

//2013-11-19־
#define MINOR_LOCAL_DEVICE_CONTROL                         0x2011   /*豸(ؿբ)*/
#define MINOR_LOCAL_ADD_EXTERNAL_DEVICE_INFO               0x2012   /*豸Ϣ */
#define MINOR_LOCAL_MOD_EXTERNAL_DEVICE_INFO               0x2013   /*޸豸Ϣ */
#define MINOR_LOCAL_DEL_EXTERNAL_DEVICE_INFO               0x2014   /*ɾ豸Ϣ */
#define MINOR_LOCAL_FIND_EXTERNAL_DEVICE_INFO              0x2015   /*زѯ豸Ϣ */
#define MINOR_LOCAL_ADD_CHARGE_RULE                        0x2016   /*շѹ */
#define MINOR_LOCAL_MOD_CHARGE_RULE                        0x2017   /*޸շѹ */
#define MINOR_LOCAL_DEL_CHARGE_RULE                        0x2018   /*ɾշѹ */
#define MINOR_LOCAL_FIND_CHARGE_RULE                       0x2019   /*زѯշѹ */
#define MINOR_LOCAL_COUNT_NORMAL_CURRENTINFO               0x2020   /*ͳͨϢ */
#define MINOR_LOCAL_EXPORT_NORMAL_CURRENTINFO_REPORT       0x2021   /*صͨϢͳƱ */
#define MINOR_LOCAL_COUNT_ABNORMAL_CURRENTINFO             0x2022   /*ͳ쳣ͨϢ */
#define MINOR_LOCAL_EXPORT_ABNORMAL_CURRENTINFO_REPORT     0x2023   /*ص쳣ͨϢͳƱ */
#define MINOR_LOCAL_COUNT_PEDESTRIAN_CURRENTINFO           0x2024   /*ͳͨϢ */
#define MINOR_LOCAL_EXPORT_PEDESTRIAN_CURRENTINFO_REPORT   0x2025   /*صͨϢͳƱ */
#define MINOR_LOCAL_FIND_CAR_CHARGEINFO                    0x2026   /*زѯշϢ */
#define MINOR_LOCAL_COUNT_CAR_CHARGEINFO                   0x2027   /*ͳƹշϢ */
#define MINOR_LOCAL_EXPORT_CAR_CHARGEINFO_REPORT           0x2028   /*صշϢͳƱ */
#define MINOR_LOCAL_FIND_SHIFTINFO                         0x2029   /*زѯӰϢ */
#define MINOR_LOCAL_FIND_CARDINFO                          0x2030   /*زѯƬϢ */
#define MINOR_LOCAL_ADD_RELIEF_RULE                        0x2031   /*Ӽ */
#define MINOR_LOCAL_MOD_RELIEF_RULE                        0x2032   /*޸ļ */
#define MINOR_LOCAL_DEL_RELIEF_RULE                        0x2033   /*ɾ */
#define MINOR_LOCAL_FIND_RELIEF_RULE                       0x2034   /*زѯ */
#define MINOR_LOCAL_GET_ENDETCFG                           0x2035   /*ػȡڿƻ߼ */ 
#define MINOR_LOCAL_SET_ENDETCFG                           0x2036   /*óڿƻ߼*/
#define MINOR_LOCAL_SET_ENDEV_ISSUEDDATA                   0x2037   /*óڿƻ·ƬϢ */
#define MINOR_LOCAL_DEL_ENDEV_ISSUEDDATA                   0x2038   /*ճڿƻ·ƬϢ */

#define MINOR_REMOTE_DEVICE_CONTROL                        0x2101   /*Զ豸*/
#define MINOR_REMOTE_SET_GATE_PARM_CFG                     0x2102   /*Զóڲ*/
#define MINOR_REMOTE_GET_GATE_PARM_CFG                     0x2103   /*ȡԶóڲ*/
#define MINOR_REMOTE_SET_DATAUPLOAD_PARM_CFG               0x2104   /*Զϴ*/
#define MINOR_REMOTE_GET_DATAUPLOAD_PARM_CFG               0x2105   /*ȡԶϴ*/
#define MINOR_REMOTE_GET_BASE_INFO                         0x2106   /*Զ̻ȡն˻Ϣ*/
#define MINOR_REMOTE_GET_OVERLAP_CFG                       0x2107   /*Զ̻ȡַӲ*/              
#define MINOR_REMOTE_SET_OVERLAP_CFG                       0x2108   /*ԶַӲ*/ 
#define MINOR_REMOTE_GET_ROAD_INFO                         0x2109   /*Զ̻ȡ·Ϣ*/
#define MINOR_REMOTE_START_TRANSCHAN                       0x210a   /*Զ̽ͬݷ*/
#define MINOR_REMOTE_GET_ECTWORKSTATE                      0x210b   /*Զ̻ȡն˹״̬*/
#define MINOR_REMOTE_GET_ECTCHANINFO                       0x210c   /*Զ̻ȡնͨ״̬*/

//Զ̿ 2013-11-19
#define MINOR_REMOTE_ADD_EXTERNAL_DEVICE_INFO              0x210d   /*Զ豸Ϣ */
#define MINOR_REMOTE_MOD_EXTERNAL_DEVICE_INFO              0x210e   /*Զ޸豸Ϣ */
#define MINOR_REMOTE_GET_ENDETCFG                          0x210f   /*Զ̻ȡڿƻ߼ */ 
#define MINOR_REMOTE_SET_ENDETCFG                          0x2110   /*Զóڿƻ߼*/
#define MINOR_REMOTE_ENDEV_ISSUEDDATA                      0x2111   /*Զóڿƻ·ƬϢ */
#define MINOR_REMOTE_DEL_ENDEV_ISSUEDDATA                  0x2112   /*Զճڿƻ·ƬϢ */

//ITS 0x2115~0x2120 ͣλĿ
#define MINOR_REMOTE_ON_CTRL_LAMP           0x2115  /*Զ̿Ƴλָʾ*/       
#define MINOR_REMOTE_OFF_CTRL_LAMP          0x2116  /*رԶ̿Ƴλָʾ*/
//Netra3.1.0
#define MINOR_SET_VOICE_LEVEL_PARAM         0x2117  /*С */
#define MINOR_SET_VOICE_INTERCOM_PARAM      0x2118  /*¼ */
#define MINOR_SET_INTELLIGENT_PARAM         0x2119  /**/ 
#define MINOR_LOCAL_SET_RAID_SPEED          0x211a  /*raidٶ*/
#define MINOR_REMOTE_SET_RAID_SPEED         0x211b /*Զraidٶ*/
//Nerta3.1.2
#define MINOR_REMOTE_CREATE_STORAGE_POOL    0x211c   //ԶӴ洢
#define MINOR_REMOTE_DEL_STORAGE_POOL       0x211d    //Զɾ洢

#define MINOR_REMOTE_DEL_PIC                0x2120   //ԶɾͼƬ
#define MINOR_REMOTE_DEL_RECORD             0x2121   //Զɾ¼
#define MINOR_REMOTE_CLOUD_ENABLE           0x2123  //Զϵͳ
#define MINOR_REMOTE_CLOUD_DISABLE          0x2124  //Զϵͳ
#define MINOR_REMOTE_CLOUD_MODIFY_PARAM     0x2125  //Զ޸Ĵ洢ز
#define MINOR_REMOTE_CLOUD_MODIFY_VOLUME    0x2126  //Զ޸Ĵ洢
#define MINOR_REMOTE_GET_GB28181_SERVICE_PARAM    0x2127  //Զ̻ȡGB28181
#define MINOR_REMOTE_SET_GB28181_SERVICE_PARAM    0x2128  //ԶGB28181
#define MINOR_LOCAL_GET_GB28181_SERVICE_PARAM     0x2129  //ػȡGB28181
#define MINOR_LOCAL_SET_GB28181_SERVICE_PARAM     0x212a  //B28181
#define MINOR_REMOTE_SET_SIP_SERVER               0x212b  //ԶSIP SERVER
#define MINOR_LOCAL_SET_SIP_SERVER                0x212c  //SIP SERVER
#define MINOR_LOCAL_BLACKWHITEFILE_OUTPUT         0x212d  //غڰ
#define MINOR_LOCAL_BLACKWHITEFILE_INPUT          0x212e  //غڰ
#define MINOR_REMOTE_BALCKWHITECFGFILE_OUTPUT     0x212f  //Զ̺ڰ
#define MINOR_REMOTE_BALCKWHITECFGFILE_INPUT      0x2130  //Զ̺ڰ


#define MINOR_REMOTE_CREATE_MOD_VIEWLIB_SPACE        0x2200    /*Զ̴/޸ͼռ*/
#define MINOR_REMOTE_DELETE_VIEWLIB_FILE            0x2201    /*Զɾͼļ*/
#define MINOR_REMOTE_DOWNLOAD_VIEWLIB_FILE            0x2202    /*Զͼļ*/
#define MINOR_REMOTE_UPLOAD_VIEWLIB_FILE            0x2203    /*Զϴͼļ*/
#define MINOR_LOCAL_CREATE_MOD_VIEWLIB_SPACE        0x2204    /*ش/޸ͼռ*/

#define MINOR_LOCAL_SET_DEVICE_ACTIVE   0x3000  //ؼ豸
#define MINOR_REMOTE_SET_DEVICE_ACTIVE  0x3001  //Զ̼豸
#define MINOR_LOCAL_PARA_FACTORY_DEFAULT    0x3002  //ػظ
#define MINOR_REMOTE_PARA_FACTORY_DEFAULT   0x3003  //Զָ̻

/*Ϣ־*/
#define MINOR_UPLAOD_STATIC_MATERIAL                0x2401  //̬زϴ
#define MINOR_UPLOAD_DYNAMIC_MATERIAL               0x2402  //̬زϴ
#define MINOR_DELETE_MATERIAL                       0x2403  //ɾز
#define MINOR_DOWNLOAD_STATIC_MATERIAL              0x2404  //̬ز
#define MINOR_COVER_STATIC_MATERIAL                 0x2405  //̬زĸ
#define MINOR_APPROVE_MATERIAL                      0x2406  //ز
#define MINOR_UPLAOD_PROGRAM                        0x2407  //ϴĿ
#define MINOR_DOWNLOAD_PROGRAM                      0x2408  //ؽĿ
#define MINOR_DELETE_PROGRAM                        0x2409  //ɾĿ
#define MINOR_MODIFY_PROGRAM                        0x240a  //Ŀ޸
#define MINOR_APPROVE_PRAGRAM                       0x240b  //Ŀ
#define MINOR_UPLAOD_SCHEDULE                       0x240c  //ϴճ
#define MINOR_DOWNLOAD_SCHEDULE                     0x240d  //ճ
#define MINOR_DELETE_SCHEDULE                       0x240e  //ɾճ
#define MINOR_MODIFY_SCHEDULE                       0x240f  //޸ճ
#define MINOR_RELEASE_SCHEDULE                      0x2410  //ճ
#define MINOR_ADD_TERMINAL                          0x2411  //ն
#define MINOR_DELETE_TERMINAL                       0x2412  //ɾն
#define MINOR_MODIFY_TERMIANL_PARAM                 0x2413  //޸ն˲            
#define MINOR_MODIFY_TERMIANL_PLAY_PARAM            0x2414  //ն˲Ų
#define MINOR_ADD_TERMIANL_GROUP                    0x2415  //ն
#define MINOR_MODIFY_TERMINAL_GROUP_PARAM           0x2416  //޸ն
#define MINOR_DELETE_TERMIANL_GROUP                 0x2417  //ɾն
#define MINOR_TERMINAL_PLAY_CONTROL                 0x2418  //ն˲ſ
#define MINOR_TERMINAL_ON_OFF_LINE                  0x2419  //ն
#define MINOR_SET_SWITCH_PLAN                       0x241a  //ն˶ʱػƻ
#define MINOR_SET_VOLUME_PLAN                       0x241b  //ն˶ʱƻ
#define MINOR_TERMINAL_SCREENSHOT                   0x241c  //ն˽


#define MINOR_REMOTE_CONFERENCE_CONFIG             0x2501  //MCU
#define MINOR_REMOTE_TERMINAL_CONFIG               0x2502  //MCUն
#define MINOR_REMOTE_GROUP_CONFIG                  0x2503  //MCU
#define MINOR_REMOTE_CONFERENCE_CTRL               0x2504  //MCU
#define MINOR_REMOTE_TERMINAL_CTRL                 0x2505  //MCUն˿
/*־Ϣ*/
//
#define MAJOR_INFORMATION               0x4     /*Ϣ*/
//
#define MINOR_HDD_INFO                  0xa1 /*ӲϢ*/
#define MINOR_SMART_INFO                0xa2 /*SMARTϢ*/
#define MINOR_REC_START                 0xa3 /*ʼ¼*/
#define MINOR_REC_STOP                  0xa4 /*ֹͣ¼*/
#define MINOR_REC_OVERDUE                0xa5 /*¼ɾ*/
#define MINOR_LINK_START                0xa6 //ǰ豸
#define MINOR_LINK_STOP                    0xa7 //Ͽǰ豸
#define MINOR_NET_DISK_INFO                0xa8 //ӲϢ
#define MINOR_RAID_INFO                 0xa9 //raidϢ
#define MINOR_RUN_STATUS_INFO           0xaa /*ϵͳ״̬Ϣ*/

//Netra3.0.0
#define MINOR_SPARE_START_BACKUP        0xab   /*ȱϵͳʼָ*/
#define MINOR_SPARE_STOP_BACKUP            0xac   /*ȱϵͳָֹͣ*/
#define MINOR_SPARE_CLIENT_INFO         0xad   /*ȱͻϢ*/
#define MINOR_ANR_RECORD_START            0xae   /*ANR¼ʼ*/
#define MINOR_ANR_RECORD_END            0xaf   /*ANR¼*/
#define MINOR_ANR_ADD_TIME_QUANTUM        0xb0    /*ANRʱ*/
#define MINOR_ANR_DEL_TIME_QUANTUM        0xb1    /*ANRɾʱ*/

#define MINOR_PIC_REC_START             0xb3  /* ʼץͼ*/    
#define MINOR_PIC_REC_STOP              0xb4  /* ֹͣץͼ*/
#define MINOR_PIC_REC_OVERDUE           0xb5  /* ͼƬļɾ */
//Netra3.1.0
#define  MINOR_CLIENT_LOGIN             0xb6   /*¼ɹ*/
#define  MINOR_CLIENT_RELOGIN            0xb7   /*µ¼*/
#define  MINOR_CLIENT_LOGOUT            0xb8   /*˳ɹ*/
#define  MINOR_CLIENT_SYNC_START        0xb9   /*¼ͬʼ*/
#define  MINOR_CLIENT_SYNC_STOP            0xba   /*¼ֹͬ*/
#define  MINOR_CLIENT_SYNC_SUCC            0xbb   /*¼ͬɹ*/
#define  MINOR_CLIENT_SYNC_EXCP            0xbc   /*¼ͬ쳣*/
#define  MINOR_GLOBAL_RECORD_ERR_INFO   0xbd   /*ȫִ¼Ϣ*/
#define  MINOR_BUFFER_STATE             0xbe   /*״̬־¼*/
#define  MINOR_DISK_ERRORINFO_V2        0xbf   /*Ӳ̴ϸϢV2*/
#define  MINOR_CS_DATA_EXPIRED          0xc0   //ƴ洢ݹ
#define  MINOR_PLAT_INFO                0xc1   //ƽ̨Ϣ
#define  MINOR_DIAL_STAT                0xc2   /*״̬*/

#define MINOR_UNLOCK_RECORD             0xc3   //¼
#define MINOR_VIS_ALARM                 0xc4   //
#define MINOR_TALK_RECORD               0xc5   //ͨ¼
#define MINOR_ACCESSORIES_MESSAGE       0xc6 //Ϣ
/*¼*/
//
#define MAJOR_EVENT                             0x5     /*¼*/
//
#define MINOR_LEGAL_CARD_PASS                   0x01    //Ϸ֤ͨ
#define MINOR_CARD_AND_PSW_PASS                 0x02    //ˢ֤ͨ
#define MINOR_CARD_AND_PSW_FAIL                 0x03    //ˢ֤ʧ
#define MINOR_CARD_AND_PSW_TIMEOUT              0x04    //֤ʱ
#define MINOR_CARD_AND_PSW_OVER_TIME            0x05    //ˢ볬
#define MINOR_CARD_NO_RIGHT                     0x06    //δȨ
#define MINOR_CARD_INVALID_PERIOD               0x07    //Чʱ
#define MINOR_CARD_OUT_OF_DATE                  0x08    //Ź
#define MINOR_INVALID_CARD                      0x09    //޴˿
#define MINOR_ANTI_SNEAK_FAIL                   0x0a    //Ǳ֤ʧ
#define MINOR_INTERLOCK_DOOR_NOT_CLOSE          0x0b    //δر
#define MINOR_NOT_BELONG_MULTI_GROUP            0x0c    //ڶ֤Ⱥ
#define MINOR_INVALID_MULTI_VERIFY_PERIOD       0x0d    //ڶ֤ʱ
#define MINOR_MULTI_VERIFY_SUPER_RIGHT_FAIL     0x0e    //֤ģʽȨ֤ʧ
#define MINOR_MULTI_VERIFY_REMOTE_RIGHT_FAIL    0x0f    //֤ģʽԶ֤ʧ
#define MINOR_MULTI_VERIFY_SUCCESS              0x10    //֤ɹ
#define MINOR_LEADER_CARD_OPEN_BEGIN            0x11    //׿ſʼ
#define MINOR_LEADER_CARD_OPEN_END              0x12    //׿Ž
#define MINOR_ALWAYS_OPEN_BEGIN                 0x13    //״̬ʼ
#define MINOR_ALWAYS_OPEN_END                   0x14    //״̬
#define MINOR_LOCK_OPEN                         0x15    //
#define MINOR_LOCK_CLOSE                        0x16    //ر
#define MINOR_DOOR_BUTTON_PRESS                 0x17    //Űť
#define MINOR_DOOR_BUTTON_RELEASE               0x18    //Űťſ
#define MINOR_DOOR_OPEN_NORMAL                  0x19    //ţŴţ
#define MINOR_DOOR_CLOSE_NORMAL                 0x1a    //ţŴţ
#define MINOR_DOOR_OPEN_ABNORMAL                0x1b    //쳣򿪣Ŵţ
#define MINOR_DOOR_OPEN_TIMEOUT                 0x1c    //Ŵ򿪳ʱŴţ
#define MINOR_ALARMOUT_ON                       0x1d    //
#define MINOR_ALARMOUT_OFF                      0x1e    //ر
#define MINOR_ALWAYS_CLOSE_BEGIN                0x1f    //״̬ʼ
#define MINOR_ALWAYS_CLOSE_END                  0x20    //״̬                          
#define MINOR_MULTI_VERIFY_NEED_REMOTE_OPEN     0x21    //ض֤ҪԶ̿
#define MINOR_MULTI_VERIFY_SUPERPASSWD_VERIFY_SUCCESS  0x22  //֤֤ɹ¼
#define MINOR_MULTI_VERIFY_REPEAT_VERIFY        0x23    //֤ظ֤¼
#define MINOR_MULTI_VERIFY_TIMEOUT               0x24    //֤ظ֤¼
#define MINOR_DOORBELL_RINGING                  0x25    //
#define MINOR_FINGERPRINT_COMPARE_PASS          0x26    //ָƱȶͨ
#define MINOR_FINGERPRINT_COMPARE_FAIL          0x27    //ָƱȶʧ
#define MINOR_CARD_FINGERPRINT_VERIFY_PASS              0x28    //ˢָ֤ͨ
#define MINOR_CARD_FINGERPRINT_VERIFY_FAIL              0x29    //ˢָ֤ʧ
#define MINOR_CARD_FINGERPRINT_VERIFY_TIMEOUT           0x2a    //ˢָ֤ʱ
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_PASS       0x2b    //ˢָƼ֤ͨ
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_FAIL       0x2c    //ˢָƼ֤ʧ
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_TIMEOUT    0x2d    //ˢָƼ֤ʱ
#define MINOR_FINGERPRINT_PASSWD_VERIFY_PASS            0x2e    //ָƼ֤ͨ
#define MINOR_FINGERPRINT_PASSWD_VERIFY_FAIL            0x2f    //ָƼ֤ʧ
#define MINOR_FINGERPRINT_PASSWD_VERIFY_TIMEOUT         0x30    //ָƼ֤ʱ
#define MINOR_FINGERPRINT_INEXISTENCE                   0x31    //ָƲ
#define MINOR_CARD_PLATFORM_VERIFY                      0x32    //ˢƽ̨֤


typedef enum tagALARMHOST_MAJOR_TYPE
{
    MAJOR_ALARMHOST_ALARM = 1,
        MAJOR_ALARMHOST_EXCEPTION,
        MAJOR_ALARMHOST_OPERATION,
        MAJ0R_ALARMHOST_EVENT
}ALARMHOST_MAJOR_TYPE;

typedef enum tagALARMHOST_MINOR_TYPE
{
    //  
    MINOR_SHORT_CIRCUIT =0x01,      // ·
        MINOR_BROKEN_CIRCUIT,           // ·
        MINOR_ALARM_RESET,              // λ
        MINOR_ALARM_NORMAL,                // ָ
        MINOR_PASSWORD_ERROR,            // 3
        MINOR_ID_CARD_ILLEGALLY,        // ǷӦID
        MINOR_KEYPAD_REMOVE,            // ̷
        MINOR_KEYPAD_REMOVE_RESTORE,    // ̷λ
        MINOR_DEV_REMOVE,                // 豸
        MINOR_DEV_REMOVE_RESTORE,        // 豸λ
        MINOR_BELOW_ALARM_LIMIT1,        // ģڱ1
        MINOR_BELOW_ALARM_LIMIT2,        // ģڱ2
        MINOR_BELOW_ALARM_LIMIT3,        // ģڱ3
        MINOR_BELOW_ALARM_LIMIT4,        // ģڱ4
        MINOR_ABOVE_ALARM_LIMIT1,        // ģڱ1
        MINOR_ABOVE_ALARM_LIMIT2,        // ģڱ2
        MINOR_ABOVE_ALARM_LIMIT3,        // ģڱ3
        MINOR_ABOVE_ALARM_LIMIT4,        // ģڱ4
        MINOR_URGENCYBTN_ON,            // ť
        MINOR_URGENCYBTN_OFF,            // ťλ
        MINOR_VIRTUAL_DEFENCE_BANDIT,            //˾
        MINOR_VIRTUAL_DEFENCE_FIRE,                //
        MINOR_VIRTUAL_DEFENCE_URGENT,            //
        MINOR_ALARMHOST_MOTDET_START,            //ƶⱨʼ
        MINOR_ALARMHOST_MOTDET_STOP,            //ƶⱨ
        MINOR_ALARMHOST_HIDE_ALARM_START,        //ڵʼ
        MINOR_ALARMHOST_HIDE_ALARM_STOP,        //ڵ
        MINOR_ALARMHOST_UPS_ALARM,                //UPS
        MINOR_ALARMHOST_ELECTRICITY_METER_ALARM, //
        MINOR_ALARMHOST_SWITCH_POWER_ALARM,        //صԴ
        MINOR_ALARMHOST_GAS_DETECT_SYS_ALARM,      //ϵͳ
        MINOR_ALARMHOST_TRANSFORMER_TEMPRATURE_ALARM, //Ա
        MINOR_ALARMHOST_TEMP_HUMI_ALARM,            //ʪȴ
        MINOR_ALARMHOST_UPS_ALARM_RESTORE,    //UPSָ
        MINOR_ALARMHOST_ELECTRICITY_METER_ALARM_RESTORE, //ָ
        MINOR_ALARMHOST_SWITCH_POWER_ALARM_RESTORE,      //صԴָ
        MINOR_ALARMHOST_GAS_DETECT_SYS_ALARM_RESTORE,      //ϵͳָ
        MINOR_ALARMHOST_TRANSFORMER_TEMPRATURE_ALARM_RESTORE, //Աָ
        MINOR_ALARMHOST_TEMP_HUMI_ALARM_RESTORE,          //ʪȴָ
        MINOR_ALARMHOST_WATER_LEVEL_SENSOR_ALARM,            //ˮλ
        MINOR_ALARMHOST_WATER_LEVEL_SENSOR_ALARM_RESTORE,    //ˮλָ
        MINOR_ALARMHOST_DUST_NOISE_ALARM,                    //ﳾ
        MINOR_ALARMHOST_DUST_NOISE_ALARM_RESTORE,            //ﳾָ
        MINOR_ALARMHOST_ENVIRONMENTAL_LOGGER_ALARM,            //ɼǱ
        MINOR_ALARMHOST_ENVIRONMENTAL_LOGGER_ALARM_RESTORE,    //ɼǱָ
        
        MINOR_ALARMHOST_TRIGGER_TAMPER,                //̽
        MINOR_ALARMHOST_TRIGGER_TAMPER_RESTORE,                //ָ̽
        MINOR_ALARMHOST_EMERGENCY_CALL_HELP_ALARM,            //
        MINOR_ALARMHOST_EMERGENCY_CALL_HELP_ALARM_RESTORE,    //ָ
        
        // 쳣
        MINOR_POWER_ON      = 0x01,    // ϵ
        MINOR_POWER_OFF,                // 
        MINOR_WDT_RESET,                // WDT λ
        MINOR_LOW_BATTERY_VOLTAGE,        // صѹ
        MINOR_AC_LOSS,                    // ϵ
        MINOR_AC_RESTORE,                // ָ
        MINOR_RTC_EXCEPTION,            // RTCʵʱʱ쳣
        MINOR_NETWORK_CONNECT_FAILURE,    // Ӷ
        MINOR_NETWORK_CONNECT_RESTORE,    // ӻָ
        MINOR_TEL_LINE_CONNECT_FAILURE,    // 绰Ӷ
        MINOR_TEL_LINE_CONNECT_RESTORE,    // 绰ӻָ
        MINOR_EXPANDER_BUS_LOSS,        // չģ
        MINOR_EXPANDER_BUS_RESTORE,        // չģ߻ָ
        MINOR_KEYPAD_BUS_LOSS,            // ģ
        MINOR_KEYPAD_BUS_RESTORE,        // ģ߻ָ
        MINOR_SENSOR_FAILURE,            // ģ
        MINOR_SENSOR_RESTORE,            // ģָ
        MINOR_RS485_CONNECT_FAILURE,    // RS485ͨӶ
        MINOR_RS485_CONNECT_RESTORE,    // RS485ͨӶϻָ
        MINOR_BATTERT_VOLTAGE_RESTORE,  // صѹָ 
        MINOR_WIRED_NETWORK_ABNORMAL,    //쳣
        MINOR_WIRED_NETWORK_RESTORE,    //ָ
        MINOR_GPRS_ABNORMAL,            //GPRSͨ쳣
        MINOR_GPRS_RESTORE,                //GPRSָ
        MINOR_3G_ABNORMAL,                //3Gͨ쳣
        MINOR_3G_RESTORE,                //3Gָ
        MINOR_SIM_CARD_ABNORMAL,        //SIM쳣
        MINOR_SIM_CARD_RESTORE,            //SIMָ
        MINOR_ALARMHOST_VI_LOST,        // ƵźŶʧ
        MINOR_ALARMHOST_ILLEGAL_ACCESS,    // Ƿ
        MINOR_ALARMHOST_HD_FULL,        // Ӳ
        MINOR_ALARMHOST_HD_ERROR,        // Ӳ̴
        MINOR_ALARMHOST_DCD_LOST,        // MODEM (ʹ)
        MINOR_ALARMHOST_IP_CONFLICT,    // IPַͻ
        MINOR_ALARMHOST_NET_BROKEN,        // Ͽ
        MINOR_ALARMHOST_REC_ERROR,      // ¼
        MINOR_ALARMHOST_VI_EXCEPTION,   // Ƶ쳣(ֻģͨ)
        MINOR_ALARMHOST_FORMAT_HDD_ERROR, //Զ̸ʽӲʧ
        MINOR_ALARMHOST_USB_ERROR,        //USBͨŹ
        MINOR_ALARMHOST_USB_RESTORE,    //USBͨŹϻָ
        MINOR_ALARMHOST_PRINT_ERROR,    //ӡ
        MINOR_ALARMHOST_PRINT_RESTORE,    //ӡϻָ
        MINOR_SUBSYSTEM_COMMUNICATION_ERROR, //ӰͨѶ
        MINOR_ALARMHOST_IPC_NO_LINK,                /* IPCӶϿ  */
        MINOR_ALARMHOST_IPC_IP_CONFLICT,            /*ipc ip ַ ͻ*/
        MINOR_ALARMHOST_VI_MISMATCH,                /*Ƶʽƥ*/
        MINOR_ALARMHOST_MCU_RESTART,                //MCU
        MINOR_ALARMHOST_GPRS_MODULE_FAULT,                     /*GPRSģ*/
        MINOR_ALARMHOST_TELEPHONE_MODULE_FAULT,                 /*绰ģ*/
        
        //  
        MINOR_GUARD         = 0x01,        // ͨ
        MINOR_UNGUARD,                    // ͨ
        MINOR_BYPASS,                    // ·
        MINOR_DURESS_ACCESS,            // Ю
        MINOR_ALARMHOST_LOCAL_REBOOT,    // 
        MINOR_ALARMHOST_REMOTE_REBOOT,    // Զ
        MINOR_ALARMHOST_LOCAL_UPGRADE,    // 
        MINOR_ALARMHOST_REMOTE_UPGRADE,    // Զ
        MINOR_RECOVERY_DEFAULT_PARAM,    // ָĬϲ
        MINOR_ALARM_OUTPUT,                // Ʊ
        MINOR_ACCESS_OPEN,                // Ž
        MINOR_ACCESS_CLOSE,                // Ž
        MINOR_SIREN_OPEN,                // ƾſ
        MINOR_SIREN_CLOSE,                // ƾŹ
        MINOR_MOD_ZONE_CONFIG,            // ޸ķ
        MINOR_MOD_ALARMOUT_CONIFG,        // Ʊ
        MINOR_MOD_ANALOG_CONFIG,        // ޸ģ
        MINOR_RS485_CONFIG,                // ޸485ͨ
        MINOR_PHONE_CONFIG,                // ޸Ĳ
        MINOR_ADD_ADMIN,                // ӹԱ
        MINOR_MOD_ADMIN_PARAM,            // ޸ĹԱ
        MINOR_DEL_ADMIN,                // ɾԱ
        MINOR_ADD_NETUSER,                // Ӻ˲Ա
        MINOR_MOD_NETUSER_PARAM,        // ޸ĺ˲Ա
        MINOR_DEL_NETUSER,                // ɾ˲Ա
        MINOR_ADD_OPERATORUSER,            // ǰ˲Ա
        MINOR_MOD_OPERATORUSER_PW,        // ޸ǰ˲Ա
        MINOR_DEL_OPERATORUSER,            // ɾǰ˲Ա
        MINOR_ADD_KEYPADUSER,            // Ӽ/û    
        MINOR_DEL_KEYPADUSER,            // ɾ/û    
        MINOR_REMOTEUSER_LOGIN,            // Զû½
        MINOR_REMOTEUSER_LOGOUT,        // Զûע
        MINOR_REMOTE_GUARD,                // Զ̲
        MINOR_REMOTE_UNGUARD,            // Զ̳
        MINOR_MOD_HOST_CONFIG,          // ޸
        MINOR_RESTORE_BYPASS,            // ·ָ
        MINOR_ALARMOUT_OPEN,            // 
        MINOR_ALARMOUT_CLOSE,            // ر
        MINOR_MOD_SUBSYSTEM_PARAM,        // ޸ϵͳ
        MINOR_GROUP_BYPASS,                // ·
        MINOR_RESTORE_GROUP_BYPASS,        // ·ָ
        MINOR_MOD_GRPS_PARAM,            // ޸GPRS
        MINOR_MOD_NET_REPORT_PARAM,        // ޸ϱ
        MINOR_MOD_REPORT_MOD,            // ޸ϴʽ
        MINOR_MOD_GATEWAY_PARAM,        // ޸Ž
        MINOR_ALARMHOST_REMOTE_START_REC,        // Զ̿ʼ¼
        MINOR_ALARMHOST_REMOTE_STOP_REC,        // Զֹͣ¼
        MINOR_ALARMHOST_START_TRANS_CHAN,        // ʼ͸
        MINOR_ALARMHOST_STOP_TRANS_CHAN,        // ֹͣ͸
        MINOR_ALARMHOST_START_VT,                // ʼԽ
        MINOR_ALARMHOST_STOP_VTM,                // ֹͣԽ
        MINOR_ALARMHOST_REMOTE_PLAYBYFILE,        // Զ̰ļط
        MINOR_ALARMHOST_REMOTE_PLAYBYTIME,      // Զ̰ʱط
        MINOR_ALARMHOST_REMOTE_PTZCTRL,            // Զ̨
        MINOR_ALARMHOST_REMOTE_FORMAT_HDD,      // Զ̸ʽӲ
        MINOR_ALARMHOST_REMOTE_LOCKFILE,        // Զļ
        MINOR_ALARMHOST_REMOTE_UNLOCKFILE,      // Զ̽ļ
        MINOR_ALARMHOST_REMOTE_CFGFILE_OUTPUT,  // Զ̵ļ
        MINOR_ALARMHOST_REMOTE_CFGFILE_INTPUT,  // Զ̵ļ
        MINOR_ALARMHOST_REMOTE_RECFILE_OUTPUT,  // Զ̵¼ļ
        
        MINOR_ALARMHOST_STAY_ARM,                        //ز
        MINOR_ALARMHOST_QUICK_ARM,                        //ʱ
        MINOR_ALARMHOST_AUTOMATIC_ARM,                    //Զ
        MINOR_ALARMHOST_AUTOMATIC_DISARM,                //Զ
        MINOR_ALARMHOST_KEYSWITCH_ARM,                    //Կ׷
        MINOR_ALARMHOST_KEYSWITCH_DISARM,                //Կ׷
        MINOR_ALARMHOST_CLEAR_ALARM,                    //
        MINOR_ALARMHOST_MOD_FAULT_CFG,                    //޸ϵͳ
        MINOR_ALARMHOST_MOD_EVENT_TRIGGER_ALARMOUT_CFG,    //޸¼
        MINOR_ALARMHOST_SEARCH_EXTERNAL_MODULE,            //ģ
        MINOR_ALARMHOST_REGISTER_EXTERNAL_MODULE,        //עģ
        MINOR_ALARMHOST_CLOSE_KEYBOARD_ALARM,            //رռ̱ʾ
        MINOR_ALARMHOST_MOD_3G_PARAM,                    //޸3G
        MINOR_ALARMHOST_MOD_PRINT_PARAM, //޸Ĵӡ
        MINOR_SD_CARD_FORMAT,        //SDʽ
        MINOR_SUBSYSTEM_UPGRADE,        //Ӱ̼
        
        MINOR_ALARMHOST_PLAN_ARM_CFG,    //ƻ
        MINOR_ALARMHOST_PHONE_ARM,        //ֻ
        MINOR_ALARMHOST_PHONE_STAY_ARM,    //ֻز
        MINOR_ALARMHOST_PHONE_QUICK_ARM,//ֻʱ
        MINOR_ALARMHOST_PHONE_DISARM,    //ֻ
        MINOR_ALARMHOST_PHONE_CLEAR_ALARM,    //ֻ
        MINOR_ALARMHOST_WHITELIST_CFG,    //
        MINOR_ALARMHOST_TIME_TRIGGER_CFG,            //ʱش
        MINOR_ALARMHOST_CAPTRUE_CFG,                //ץͼ
        MINOR_ALARMHOST_TAMPER_CFG,                //

        MINOR_ALARMHOST_REMOTE_KEYPAD_UPGRADE,               //Զ
        MINOR_ALARMHOST_ONETOUCH_AWAY_ARMING,                //һ 
        MINOR_ALARMHOST_ONETOUCH_STAY_ARMING,                //һز
        MINOR_ALARMHOST_SINGLE_PARTITION_ARMING_OR_DISARMING,    // 
        MINOR_ALARMHOST_CARD_CONFIGURATION,         //
        MINOR_ALARMHOST_CARD_ARMING_OR_DISARMING,         //ˢ
        MINOR_ALARMHOST_EXPENDING_NETCENTER_CONFIGURATION,         //չ
        MINOR_ALARMHOST_NETCARD_CONFIGURATION,         //
        MINOR_ALARMHOST_DDNS_CONFIGURATION,         //DDNS
        MINOR_ALARMHOST_RS485BUS_CONFIGURATION,        // 485߲
         MINOR_ALARMHOST_RS485BUS_RE_REGISTRATION,            //485ע

        MINOR_ALARMHOST_REMOTE_OPEN_ELECTRIC_LOCK,    //Զ̴򿪵
        MINOR_ALARMHOST_REMOTE_CLOSE_ELECTRIC_LOCK,    //Զ̹رյ
        MINOR_ALARMHOST_LOCAL_OPEN_ELECTRIC_LOCK,    //ش򿪵
        MINOR_ALARMHOST_LOCAL_CLOSE_ELECTRIC_LOCK,    //عرյ
        MINOR_ALARMHOST_OPEN_ALARM_LAMP,            //򿪾(Զ)
        MINOR_ALARMHOST_CLOSE_ALARM_LAMP,            //رվ(Զ)
        
        MINOR_ALARMHOST_LOCAL_SET_DEVICE_ACTIVE = 0xf0,        //ؼ豸
        MINOR_ALARMHOST_REMOTE_SET_DEVICE_ACTIVE = 0xf1,        //Զ̼豸
        MINOR_ALARMHOST_LOCAL_PARA_FACTORY_DEFAULT = 0xf2,    //ػظ
        MINOR_ALARMHOST_REMOTE_PARA_FACTORY_DEFAULT = 0xf3,    //Զָ̻

        
        // ¼ 
        MINOR_SCHOOLTIME_IRGI_B = 0x01,        // BУʱ
        MINOR_SCHOOLTIME_SDK,                // SDKУʱ
        MINOR_SCHOOLTIME_SELFTEST,            // ʱԼУʱ
        MINOR_SUBSYSTEM_ABNORMALINSERT,        //Ӱ 
        MINOR_SUBSYSTEM_ABNORMALPULLOUT,        //Ӱγ
        
        MINOR_AUTO_ARM,                    //Զ
        MINOR_AUTO_DISARM,                //Զ
        MINOR_TIME_TIGGER_ON,            //ʱ
        MINOR_TIME_TIGGER_OFF,            //ʱرմ
        MINOR_AUTO_ARM_FAILD,            //Զʧ
        MINOR_AUTO_DISARM_FAILD,        //Զʧ
        MINOR_TIME_TIGGER_ON_FAILD,        //ʱʧ
        MINOR_TIME_TIGGER_OFF_FAILD,    //ʱرմʧ
        MINOR_MANDATORY_ALARM,            //ǿƲ
        MINOR_KEYPAD_LOCKED,            //

}ALARMHOST_MINOR_TYPE;


//־ΪMAJOR_OPERATION=03ΪMINOR_LOCAL_CFG_PARM=0x52MINOR_REMOTE_GET_PARM=0x76
//MINOR_REMOTE_CFG_PARM=0x77ʱdwParaType:Ч京£
#define PARA_VIDEOOUT    0x1
#define PARA_IMAGE        0x2
#define PARA_ENCODE        0x4
#define PARA_NETWORK    0x8
#define PARA_ALARM        0x10
#define PARA_EXCEPTION    0x20
#define PARA_DECODER    0x40    /**/
#define PARA_RS232        0x80
#define PARA_PREVIEW    0x100
#define PARA_SECURITY    0x200
#define PARA_DATETIME    0x400
#define PARA_FRAMETYPE    0x800    /*֡ʽ*/
#define PARA_DETECTION  0x1000   //
#define PARA_VCA_RULE   0x1001  //Ϊ 
#define PARA_VCA_CTRL   0x1002  //ܿϢ
#define PARA_VCA_PLATE  0x1003 // ʶ

#define PARA_CODESPLITTER 0x2000 /**/
//2010-01-22 Ƶۺƽ̨־Ϣ
#define PARA_RS485          0x2001            /* RS485Ϣ*/
#define PARA_DEVICE          0x2002            /* 豸Ϣ*/
#define PARA_HARDDISK      0x2003            /* ӲϢ */
#define PARA_AUTOBOOT      0x2004            /* ԶϢ*/
#define PARA_HOLIDAY      0x2005            /* ڼϢ*/            
#define PARA_IPC          0x2006            /* IPͨ */    
/************************* end*******************************/


/*******************ļ־ֵ*************************/
#define NET_DVR_FILE_SUCCESS            1000    //ļϢ
#define NET_DVR_FILE_NOFIND                1001    //ûļ
#define NET_DVR_ISFINDING                1002    //ڲļ
#define    NET_DVR_NOMOREFILE                1003    //ļʱûиļ
#define    NET_DVR_FILE_EXCEPTION            1004    //ļʱ쳣

/*********************ص begin************************/

//ص
#define COMM_ALARM                           0x1100    //8000Ϣϴ

//ӦNET_VCA_RULE_ALARM
#define COMM_ALARM_RULE                      0x1102     //ΪϢ
#define COMM_ALARM_PDC                       0x1103  //ͳƱϢ
#define COMM_ALARM_VIDEOPLATFORM             0x1104  //Ƶۺƽ̨
#define COMM_ALARM_ALARMHOST                 0x1105  //籨
#define COMM_ALARM_FACE                      0x1106  //ʶ𱨾Ϣ
#define COMM_RULE_INFO_UPLOAD                0x1107  // ¼Ϣϴ
#define COMM_ALARM_AID                       0x1110  //ͨ¼Ϣ
#define COMM_ALARM_TPS                       0x1111  //ͨͳƱϢ
//ץĽϴ
#define COMM_UPLOAD_FACESNAP_RESULT          0x1112  //ʶϴ
#define COMM_ALARM_TFS                       0x1113  //ͨȡ֤Ϣ
#define COMM_ALARM_TPS_V41                   0x1114  //ͨͳƱϢչ
#define COMM_ALARM_AID_V41                   0x1115  //ͨ¼Ϣչ
#define COMM_ALARM_VQD_EX                    0x1116     //Ƶϱ
#define COMM_SENSOR_VALUE_UPLOAD             0x1120  //ģʵʱϴ
#define COMM_SENSOR_ALARM                    0x1121  //ģϴ
#define COMM_SWITCH_ALARM                    0x1122     //
#define COMM_ALARMHOST_EXCEPTION             0x1123  //ϱ
#define COMM_ALARMHOST_OPERATEEVENT_ALARM    0x1124  //¼ϴ
#define COMM_ALARMHOST_SAFETYCABINSTATE      0x1125     //״̬
#define COMM_ALARMHOST_ALARMOUTSTATUS        0x1126     ///״̬
#define COMM_ALARMHOST_CID_ALARM               0x1127     //汨ϴ
#define    COMM_ALARMHOST_EXTERNAL_DEVICE_ALARM 0x1128     //豸ϴ
#define COMM_ALARMHOST_DATA_UPLOAD           0x1129     //ϴ
#define COMM_FACECAPTURE_STATISTICS_RESULT   0x112a  //ץͳϴ
#define COMM_SCENECHANGE_DETECTION_UPLOAD     0x1130     //ϴ()2013-7-16
#define COMM_CROSSLINE_ALARM                 0x1131    //ѹ߱() 2013-09-27
#define COMM_UPLOAD_VIDEO_INTERCOM_EVENT     0x1132  //ӶԽ¼¼ϴ
#define COMM_ALARM_VIDEO_INTERCOM               0x1133  //ӶԽϴ
#define COMM_ALARM_AUDIOEXCEPTION             0x1150     //Ϣ
#define COMM_ALARM_DEFOCUS                   0x1151     //齹Ϣ
#define COMM_ALARM_BUTTON_DOWN_EXCEPTION     0x1152     //ť±Ϣ
#define COMM_ALARM_ALARMGPS                  0x1202  //GPSϢϴ
#define    COMM_TRADEINFO                       0x1500  //ATMDVRϴϢ
#define COMM_UPLOAD_PLATE_RESULT             0x2800     //ϴϢ
#define COMM_ITC_STATUS_DETECT_RESULT        0x2810  //ʵʱ״̬ϴ(ܸIPC)
#define COMM_IPC_AUXALARM_RESULT             0x2820  //PIR߱ȱϴ
#define COMM_UPLOAD_PICTUREINFO              0x2900     //ϴͼƬϢ
#define COMM_SNAP_MATCH_ALARM                0x2902  //ȶԽϴ
#define COMM_ITS_PLATE_RESULT                0x3050  //նͼƬϴ
#define    COMM_ITS_TRAFFIC_COLLECT             0x3051  //նͳϴ
#define COMM_ITS_GATE_VEHICLE                0x3052  //ڳץϴ
#define COMM_ITS_GATE_FACE                   0x3053  //ץϴ
#define COMM_ITS_GATE_COSTITEM                 0x3054  //ڹշϸ 2013-11-19
#define COMM_ITS_GATE_HANDOVER                 0x3055  //ڽӰ 2013-11-19
#define COMM_ITS_PARK_VEHICLE                0x3056  //ͣϴ
#define COMM_ITS_BLACKLIST_ALARM             0x3057  //ϴ

#define COMM_VEHICLE_CONTROL_LIST_DSALARM    0x3058  //ڰҪͬ2013-11-04
#define COMM_VEHICLE_CONTROL_ALARM           0x3059  //2013-11-04
#define COMM_FIRE_ALARM                      0x3060  //2013-11-04

#define COMM_ITS_GATE_ALARMINFO              0x3061  //ڿƻϴ

#define COMM_VEHICLE_RECOG_RESULT            0x3062  //ʶϴ 2014-11-12 
#define COMM_PLATE_RESULT_V50                0x3063  //ϴ V50

#define COMM_GATE_CHARGEINFO_UPLOAD          0x3064  //ڸϢϴ
#define COMM_TME_VEHICLE_INDENTIFICATION     0x3065  //TMEץͼϴ
#define COMM_GATE_CARDINFO_UPLOAD            0x3066  //ڿƬϢϴ

#define COMM_ALARM_SENSORINFO_UPLOAD         0x3077     //ϴϢ
#define COMM_ALARM_CAPTURE_UPLOAD             0x3078     //ץͼƬϴ

#define COMM_ITS_RADARINFO                   0x3079  //״ﱨϴ

#define COMM_SIGNAL_LAMP_ABNORMAL            0x3080  //źŵ쳣ϴ

#define COMM_ALARM_TPS_REAL_TIME             0x3081  //TPSʵʱϴ
#define COMM_ALARM_TPS_STATISTICS            0x3082  //TPSͳƹϴ

#define COMM_ALARM_V30                         0x4000     //9000Ϣϴ
#define COMM_IPCCFG                             0x4001     //9000豸IPCøı䱨Ϣϴ
#define COMM_IPCCFG_V31                         0x4002     //9000豸IPCøı䱨Ϣϴչ 9000_1.1
#define COMM_IPCCFG_V40                      0x4003  // IVMS 2000  NVR IPCøıʱϢϴ
#define COMM_ALARM_DEVICE                    0x4004  //豸ݣֵͨ256չ
#define COMM_ALARM_CVR                         0x4005  //CVR 2.0.Xⲿ
#define COMM_ALARM_HOT_SPARE                 0x4006  //ȱ쳣N+1ģʽ쳣
#define COMM_ALARM_V40                         0x4007    //ƶ⣬ƵʧڵIOźȱϢϴΪɱ䳤

#define COMM_UPLOAD_HEATMAP_RESULT           0x4008 //ȶͼϴ 2014-03-21
#define COMM_ALARM_DEVICE_V40                0x4009  //豸չ
#define COMM_ALARM_FACE_DETECTION            0x4010 //ⱨ
#define COMM_ALARM_TARGET_LEFT_REGION        0x4011 //Ŀ뿪򱨾(ʦѧ(л¼Ƽѧ))
#define COMM_GISINFO_UPLOAD                  0x4012 //GISϢϴ
#define COMM_VANDALPROOF_ALARM               0x4013 //ϴƻϢ
#define COMM_PEOPLE_DETECTION_UPLOAD         0x4014 //ԱϢϴ
#define COMM_ALARM_STORAGE_DETECTION         0x4015 //洢ܼⱨϴ
#define    COMM_ITS_ROAD_EXCEPTION                 0x4500     //·豸쳣
#define    COMM_ITS_EXTERNAL_CONTROL_ALARM         0x4520  //ر
#define COMM_ALARM_SHIPSDETECTION             0x4521    // ֻⱨϢ
#define COMM_FIREDETECTION_ALARM             0x4991 //ⱨ

#define    COMM_SCREEN_ALARM                    0x5000  //
#define COMM_DVCS_STATE_ALARM                 0x5001  //ֲʽϴ
#define COMM_ALARM_ACS                         0x5002  //Ž
#define COMM_ALARM_FIBER_CONVERT             0x5003  //շ
#define COMM_ALARM_SWITCH_CONVERT             0x5004  //
#define COMM_ALARM_DEC_VCA                   0x5010  //ܽ뱨
#define COMM_ALARM_LCD                         0x5011     //Ļ
#define COMM_CONFERENCE_CALL_ALARM             0x5012     //и澯

#define COMM_DIAGNOSIS_UPLOAD                0x5100  //ϷVQDϴ
#define COMM_HIGH_DENSITY_UPLOAD             0x5101  //Աۼܶϴ

#define COMM_ID_INFO_ALARM                   0x5200  //֤Ϣϴ
#define COMM_PASSNUM_INFO_ALARM              0x5201  //ͨϱ

#define COMM_THERMOMETRY_DIFF_ALARM          0x5211  //²ϴ
#define COMM_THERMOMETRY_ALARM               0x5212  //¶ȱϴ

#define COMM_ALARM_VQD                         0x6000  //VQDϴ 
#define COMM_PUSH_UPDATE_RECORD_INFO          0x6001  //ģʽ¼Ϣϴ
#define COMM_SWITCH_LAMP_ALARM               0x6002  //صƼ


/*************쳣(Ϣʽ, صʽ())****************/
#define EXCEPTION_EXCHANGE                0x8000    //ûʱ쳣
#define EXCEPTION_AUDIOEXCHANGE            0x8001    //Խ쳣
#define EXCEPTION_ALARM                    0x8002    //쳣
#define EXCEPTION_PREVIEW                0x8003    //Ԥ쳣
#define EXCEPTION_SERIAL                0x8004    //͸ͨ쳣
#define EXCEPTION_RECONNECT                0x8005    //Ԥʱ
#define EXCEPTION_ALARMRECONNECT        0x8006    //ʱ
#define EXCEPTION_SERIALRECONNECT        0x8007    //͸ͨ
#define SERIAL_RECONNECTSUCCESS         0x8008    //͸ͨɹ
#define EXCEPTION_PLAYBACK                0x8010    //ط쳣
#define EXCEPTION_DISKFMT                0x8011    //Ӳ̸ʽ
#define EXCEPTION_PASSIVEDECODE         0x8012  //쳣
#define EXCEPTION_EMAILTEST             0x8013  //ʼ쳣    
#define EXCEPTION_BACKUP                0x8014  //쳣
#define PREVIEW_RECONNECTSUCCESS        0x8015  //Ԥʱɹ
#define ALARM_RECONNECTSUCCESS          0x8016  //ʱɹ
#define RESUME_EXCHANGE                    0x8017    //ûָ
#define NETWORK_FLOWTEST_EXCEPTION      0x8018  //쳣
#define EXCEPTION_PICPREVIEWRECONNECT    0x8019    //ͼƬԤ
#define PICPREVIEW_RECONNECTSUCCESS        0x8020    //ͼƬԤɹ
#define EXCEPTION_PICPREVIEW            0x8021    //ͼƬԤ쳣
#define    EXCEPTION_MAX_ALARM_INFO        0x8022    //ϢѴ
#define    EXCEPTION_LOST_ALARM            0x8023  //ʧ
#define EXCEPTION_PASSIVETRANSRECONNECT 0x8024  //ת
#define PASSIVETRANS_RECONNECTSUCCESS   0x8025  //תɹ
#define EXCEPTION_PASSIVETRANS          0x8026  //ת쳣
#define SUCCESS_PUSHDEVLOGON            0x8030  //ģʽ豸עɹ
#define EXCEPTION_RELOGIN                0x8040    //ûص½
#define RELOGIN_SUCCESS                    0x8041    //ûص½ɹ
#define EXCEPTION_PASSIVEDECODE_RECONNNECT  0x8042  //

#define EXCEPTION_RELOGIN_FAILED                0x8044   //ص½ʧܣֹͣص½
#define EXCEPTION_PREVIEW_RECONNECT_CLOSED      0x8045   //رԤ
#define EXCEPTION_ALARM_RECONNECT_CLOSED        0x8046   //رձ
#define EXCEPTION_SERIAL_RECONNECT_CLOSED       0x8047   //ر͸ͨ
#define EXCEPTION_PIC_RECONNECT_CLOSED          0x8048   //رջ
#define EXCEPTION_PASSIVE_DECODE_RECONNECT_CLOSED 0x8049 //رձ
#define EXCEPTION_PASSIVE_TRANS_RECONNECT_CLOSED 0x804a  //رձת 

/********************Ԥص*********************/
#define NET_DVR_SYSHEAD            1    //ϵͳͷ
#define NET_DVR_STREAMDATA        2    //ƵݣƵֿƵݣ
#define NET_DVR_AUDIOSTREAMDATA    3    //Ƶ
#define NET_DVR_STD_VIDEODATA    4    //׼Ƶ
#define NET_DVR_STD_AUDIODATA    5    //׼Ƶ
#define NET_DVR_SDP             6   //SDPϢ(RstpʱЧ)
#define NET_DVR_CHANGE_FORWARD  10  //ıΪ  
#define NET_DVR_CHANGE_REVERSE  11  //ıΪ
#define NET_DVR_PLAYBACK_ALLFILEEND      12  //طļ
#define NET_DVR_PRIVATE_DATA    112 //˽,Ϣ

//豸ͺ(DVR)
/* 豸 */
#define DVR                            1                /*δdvrͷDVR*/
#define ATMDVR                        2                /*atm dvr*/
#define DVS                            3                /*DVS*/
#define DEC                            4                /* 6001D */
#define ENC_DEC                        5                /* 6001F */
#define DVR_HC                        6                /*8000HC*/
#define DVR_HT                        7                /*8000HT*/
#define DVR_HF                        8                /*8000HF*/
#define DVR_HS                        9                /* 8000HS DVR(no audio) */
#define DVR_HTS                        10              /* 8016HTS DVR(no audio) */
#define DVR_HB                        11              /* HB DVR(SATA HD) */
#define DVR_HCS                        12              /* 8000HCS DVR */
#define DVS_A                        13              /* ATAӲ̵DVS */
#define DVR_HC_S                    14              /* 8000HC-S */
#define DVR_HT_S                    15              /* 8000HT-S */
#define DVR_HF_S                    16              /* 8000HF-S */
#define DVR_HS_S                    17              /* 8000HS-S */
#define ATMDVR_S                    18              /* ATM-S */
#define DVR_7000H                    19                /*7000Hϵ*/
#define DEC_MAT                        20              /*·*/
#define DVR_MOBILE                    21                /* mobile DVR */                 
#define DVR_HD_S                    22              /* 8000HD-S */
#define DVR_HD_SL                    23                /* 8000HD-SL */
#define DVR_HC_SL                    24                /* 8000HC-SL */
#define DVR_HS_ST                    25                /* 8000HS_ST */
#define DVS_HW                        26              /* 6000HW */
#define DS630X_D                    27              /* · */
#define DS640X_HD                    28                /*640X*/
#define DS610X_D                    29              /*610X*/
#define IPCAM                        30                /*IP */
#define MEGA_IPCAM                    31                /*IP*/
#define IPCAM_X62MF                    32                /*862MFԽ9000豸*/
#define ITCCAM                      35              /*ܸ*/
#define IVS_IPCAM                   36              /*ܷ*/
#define ZOOMCAM                     38              /*һ*/
#define IPDOME                      40              /*IP */
#define IPDOME_MEGA200              41              /*IP 200*/
#define IPDOME_MEGA130              42              /*IP 130*/
#define IPDOME_AI                   43              /*IP ܿ*/
#define TII_IPCAM                   44              /*ȳ*/
#define IPTC_DOME                   45              /*ȳ˫Ŀ*/
#define DS_2DP_Z                    46              /*ӥۣ*/
#define DS_2DP                       47              /*ӥۣС*/
#define ITS_WMS                      48              /*ݹ*/
#define IPMOD                        50                /*IP ģ*/
#define TRAFFIC_YTDOME              51              //̨ͨ״٣
#define TRAFFIC_RDDOME              52              //̨ͨ״٣
#define IDS6501_HF_P                60              // 6501  
#define IDS6101_HF_A                61              //ATM
#define IDS6002_HF_B                62          //˫٣DS6002-HF/B
#define IDS6101_HF_B                63              //ΪDS6101-HF/B DS6101-HF/B_SATA
#define IDS52XX                        64          //ܷIVMS
#define IDS90XX                        65                // 9000
#define IDS8104_AHL_S_HX            66          // ʶ ATM
#define IDS8104_AHL_S_H             67              // ˽ʶ ATM
#define IDS91XX                        68                // 9100
#define IIP_CAM_B                   69              // ΪIP
#define IIP_CAM_F                   70              //IP
#define DS71XX_H                    71                /* DS71XXH_S */
#define DS72XX_H_S                    72                /* DS72XXH_S */
#define DS73XX_H_S                    73                /* DS73XXH_S */
#define DS72XX_HF_S                 74              //DS72XX_HF_S
#define DS73XX_HFI_S                75              //DS73XX_HFI_S
#define DS76XX_H_S                    76                /* DVR,e.g. DS7604_HI_S */
#define DS76XX_N_S                    77                /* NVR,e.g. DS7604_NI_S */
#define DS_TP3200_EC                   78              /*ܼ*/
#define DS81XX_HS_S                    81                /* DS81XX_HS_S */
#define DS81XX_HL_S                    82                /* DS81XX_HL_S */
#define DS81XX_HC_S                    83                /* DS81XX_HC_S */
#define DS81XX_HD_S                    84                /* DS81XX_HD_S */
#define DS81XX_HE_S                    85                /* DS81XX_HE_S */
#define DS81XX_HF_S                    86                /* DS81XX_HF_S */
#define DS81XX_AH_S                    87                /* DS81XX_AH_S */
#define DS81XX_AHF_S                88                /* DS81XX_AHF_S */
#define DS90XX_HF_S                    90              /*DS90XX_HF_S*/
#define DS91XX_HF_S                    91              /*DS91XX_HF_S*/
#define DS91XX_HD_S                    92              /*91XXHD-S(MD)*/
#define IDS90XX_A                    93                // 9000 ATM
#define IDS91XX_A                    94                // 9100 ATM
#define DS95XX_N_S                    95              /*DS95XX_N_S NVR κ*/
#define DS96XX_N_SH                    96              /*DS96XX_N_SH NVR*/
#define DS90XX_HF_SH                97              /*DS90XX_HF_SH */   
#define DS91XX_HF_SH                98              /*DS91XX_HF_SH */
#define DS_B10_XY                   100             /*Ƶۺƽ̨豸ͺ(X:ƬY:Ƭ)*/
#define DS_6504HF_B10               101             /*Ƶۺƽ̨ڲ*/
#define DS_6504D_B10                102             /*Ƶۺƽ̨ڲ*/
#define DS_1832_B10                 103             /*Ƶۺƽ̨ڲ*/
#define DS_6401HFH_B10              104             /*Ƶۺƽ̨ڲ˰*/
#define DS_65XXHC                    105                //65XXHC DVS
#define DS_65XXHC_S                    106                //65XXHC-SATA DVS
#define DS_65XXHF                    107                //65XXHF DVS
#define DS_65XXHF_S                    108                //65XXHF-SATA DVS
#define DS_6500HF_B                 109             //65 rack DVS
#define IVMS_6200_C                 110             // iVMS-6200(/C)  
#define IVMS_6200_B                 111             // iVMS-6200(/B)
#define DS_72XXHV_ST15                112                //72XXHV_ST  ˼3515ƽ̨ DVR
#define DS_72XXHV_ST20                113                //72XXHV_ST  ˼3520ƽ̨ DVR
#define IVMS_6200_T                    114             // IVMS-6200(/T)
#define IVMS_6200_BP                115             // IVMS-6200(/BP)
#define DS_81XXHC_ST                116                //DS_81XXHC_ST
#define DS_81XXHS_ST                117                //DS_81XXHS_ST
#define DS_81XXAH_ST                118                //DS_81XXAH_ST
#define DS_81XXAHF_ST                119                //DS_81XXAHF_ST
#define DS_66XXDVS                    120                //66XX DVS

#define DS_1964_B10                 121             /*Ƶۺƽ̨ڲ*/
#define DS_B10N04_IN                122             /*Ƶۺƽ̨ڲ*/
#define DS_B10N04_OUT                123             /*Ƶۺƽ̨ڲ*/
#define DS_B10N04_INTEL             124             /*Ƶۺƽ̨ڲ*/
#define DS_6408HFH_B10E_RM          125             //V6
#define DS_B10N64F1_RTM             126             //V6DSP
#define DS_B10N64F1D_RTM            127             //V6DSP
#define DS_B10_SDS                  128             //Ƶۺƽ̨
#define DS_B10_DS                   129             //Ƶۺƽ̨
#define DS_6401HFH_B10V                130             //VGA
#define DS_6504D_B10B               131             /*Ƶۺƽ̨ڲ*/
#define DS_6504D_B10H               132             /*Ƶۺƽ̨ڲ*/
#define DS_6504D_B10V               133             /*Ƶۺƽ̨ڲVGA*/
#define DS_6408HFH_B10S                134             //Ƶۺƽ̨SDIӰ 
#define DS_18XX_N                      135             /* */ 
#define DS_6504HF_B10F_CLASS        136                //˻SD
#define DS_18XX_PTZ                    141                /*Ʒ*/
#define DS_19AXX                    142                /*ͨñƷ*/
#define DS_19BXX                    143                /*ñ*/
#define DS_19CXX                    144                /*б*/
#define DS_19DXX                    145                /*ر*/    
#define DS_19XX                     146             /*1900ϵб*/ 
#define DS_19SXX                    147                /*Ƶ*/
#define DS_1HXX                        148                /*CSƷ*/ //
#define DS_PEAXX                    149                /*һʽƷ*/

//2011-11-30
#define    DS_C10H                        161                /**/
#define DS_C10N_BI                    162                //BNC
#define DS_C10N_DI                    163                //rbg
#define DS_C10N_SI                    164                //
#define DS_C10N_DO                    165                //ʾ
#define DS_C10N_SERVER                166                //ֲʽ


#define IDS_8104_AHFL_S_H           171             // 8104ATM 
#define IDS_65XX_HF_A               172             // 65 ATM
#define IDS90XX_HF_RH               173             // 9000 RH
#define IDS91XX_HF_RH               174             // 9100 RH豸
#define IDS_65XX_HF_B               175             // 65 Ϊ
#define IDS_65XX_HF_P               176             // 65 ʶ
#define IVMS_6200_F                 177             // IVMS-6200(/F)
#define IVMS_6200_A                 178             //iVMS-6200(/A)
#define IVMS_6200_F_S                 179             // IVMS-6200(/F_S)

#define DS90XX_HF_RH                181             // 9000 RH    648
#define DS91XX_HF_RH                182             // 9100 RH豸 648
#define DS78XX_S                    183             // 78ϵ豸 6446
#define DS81XXHW_S                    185                // 81 Resolution 960 KY2011
#define DS81XXHW_ST                    186             // DS81XXHW_ST  KY2011
#define DS91XXHW_ST                    187             // DS91XXHW_ST  KY2011
#define DS91XX_ST                    188             // DS91XX_ST netra
#define DS81XX_ST                    189             // DS81XX_ST netra
#define DS81XXHX_ST                    190             // DS81XXHDI_ST,DS81XXHE_ST ky2012
#define DS73XXHX_ST                    191             // DS73XXHI_ST ky2012
#define DS81XX_SH                   192             // Ѷ81SH,81SHF
#define DS81XX_SN                   193             // Ѷ81SNL

#define DS96XXN_ST                  194             //NVR:DS96xxN_ST
#define DS86XXN_ST                  195             //NVR:DS86xxN_ST
#define DS80XXHF_ST                 196             //DVR:DS80xxHF_ST
#define DS90XXHF_ST                 197             //DVR:DS90xxHF_ST
#define DS76XXN_ST                  198             //NVR:DS76xxN_ST

#define DS_9664N_RX                 199         //NVR:DS_9664N_RX
#define ENCODER_SERVER                200            // 뿨
#define DECODER_SERVER              201         // 뿨
#define PCNVR_SERVER                202         // PCNVR洢
#define CVR_SERVER                  203         // ŵCVRԼΪDVR_S-1
#define DS_91XXHFH_ST                204         // 91ϵHD-SDIDVR
#define DS_66XXHFH                    205         // 66
#define    TRAFFIC_TS_SERVER            210           //ն˷
#define    TRAFFIC_VAR                    211           //Ƶ¼
#define IPCALL                      212        //IPӶԽֻ
#define SAN_SERVER                  213         //CVR_SERVERͬĳֻģʽͬ

#define DS_B11_M_CLASS                 301             /*Ƶۺƽ̨豸ͺ*/
#define DS_B12_M_CLASS                  302             /*Ƶۺƽ̨豸ͺ*/
#define DS_6504HF_B11_CLASS         303             /*Ƶۺƽ̨ڲ*/
#define DS_6504HF_B12_CLASS         304              /*Ƶۺƽ̨ڲ*/
#define  DS_6401HFH_B11V_CLASS         305     //VGA
#define  DS_6401HFH_B12V_CLASS         306     //VGA
#define  DS_6408HFH_B11S_CLASS         307     //SDI
#define  DS_6408HFH_B12S_CLASS      308     //SDI
#define  DS_6504D_B11H_CLASS        309   /*Ƶۺƽ̨ڲ*/
#define  DS_6504D_B11B_CLASS        310    /*Ƶۺƽ̨ڲ*/
#define  DS_6504D_B12B_CLASS        311       /*Ƶۺƽ̨ڲ*/
#define  DS_6504D_B11V_CLASS        312      /*Ƶۺƽ̨ڲVGA*/
#define  DS_6504D_B12V_CLASS        313     /*Ƶۺƽ̨ڲVGA*/
//B10
#define  DS_6401HFH_B10R_CLASS         314     //B10 RGB
#define  DS_6401HFH_B10D_CLASS         315     //B10 DVI
#define  DS_6401HFH_B10H_CLASS         316     //B10 HDMI
//B11
#define  DS_6401HFH_B11R_CLASS         317     //B11 RGB
#define  DS_6401HFH_B11D_CLASS         318     //B11 DVI
#define  DS_6401HFH_B11H_CLASS         319     //B11 HDMI
//B12
#define  DS_6401HFH_B12R_CLASS         320     //B12 RGB
#define  DS_6401HFH_B12D_CLASS         321     //B12 DVI
#define  DS_6401HFH_B12H_CLASS         322     //B12 HDMI
#define  DS_65XXD_B10Ex_CLASS        323     //netra 

//B10 V2.1
#define  DS_6516HW_B10_CLASS        324     //netra߱
#define  DS_6401HFH_B10F_RX_CLASS   326        //˻루֧1/2·˻룩
#define  DS_6502HW_B10F_RX_CLASS    327        //960H˻루֧1/4/8·˻룩
//2012-5-16
#define  DS_6504D_B11Ex_CLASS        328     //netra
#define  DS_6504D_B12Ex_CLASS        329     //netra
#define  DS_6512_B11_CLASS            330     //netra߱
#define  DS_6512_B12_CLASS            331     //netra߱
#define  DS_6504D_B10H_CLASS        332     //Ƶۺƽ̨ڲ

#define  DS_65XXT_B10_CLASS         333     //Ƶۺƽ̨תϵͳ
#define  DS_65XXD_B10_CLASS         335     //Ƶۺƽ̨ܽ
#define  DS_IVMSE_B10X_CLASS        336     //X86ϵͳ
#define  DS_6532D_B10ES_CLASS        337     //ǿͽ_SDI(B10)
#define  DS_6508HFH_B10ES_CLASS        338     //SDIϵͳ
#define  DS_82NCG_CLASS                340     //еϵͳ
#define  DS_82VAG_CLASS                341     //еϵͳ 
#define  DS_1802XXF_B10_CLASS       342     //ڽϵͳ
#define  iDS_6504_B10EVAC_CLASS     343     //ϵͳ
#define  iDS_6504_B10EDEC_CLASS     344     //ϵͳ
#define  DS_6402HFH_B10EV_CLASS     345     //netra(VGA)
#define  DS_6402HFH_B10ED_CLASS     346     //netra(DVI)
#define  DS_6402HFH_B10EH_CLASS     347     //netra(HDMI)
#define  DS_6404HFH_B10T_RX_CLASS   348     //˽
#define  DS_6504D_AIO_CLASS         349        //netra
#define  DS_IVMST_B10_CLASS            350        //X86תϵͳ
#define  DS_6402_AIO_CLASS          351     //netra
#define  DS_iVMSE_AIO_CLASS         352     //x86ϵͳ
#define  DS_AIO_M_CLASS             353     //һ


#define  DS_6508HF_B10E_CLASS        355        //BNCϵͳ
#define  DS_6404HFH_B10ES_CLASS        356        //SDIϵͳ
#define  DS_6402HFH_B10ER_CLASS        358        //RGBϵͳ
#define  DS_6404HFH_B10T_RM_CLASS    361        //ϵͳ
#define  DS_6516D_B10EB_CLASS        362        //BNCϵͳ
#define  DS_6516D_B10ES_CLASS        363        //SDIϵͳ

//DVI/HDMI/VGAԽ빫һ
#define  DS_6508D_B10FH_CLASS        364
#define  DS_6508D_B10FD_CLASS        364
#define  DS_6508D_B10FV_CLASS        364

#define  DS_6508_B11E_CLASS            365        //BNCϵͳ
#define  DS_6402_B11ES_CLASS        366        //SDIϵͳ
#define  DS_6402_B11EV_CLASS        367        //VGAϵͳ
#define  DS_6402_B11ER_CLASS        368        //RGBϵͳ
#define  DS_6402_B11ED_CLASS        369        //DVIϵͳ
#define  DS_6402_B11EH_CLASS        370        //HDMIϵͳ
#define  DS_6516D_B11EB_CLASS        371        //BNCϵͳ
#define  DS_6516D_B11ES_CLASS        372        //SDIϵͳ

#define  DS_6508_B12E_CLASS         373     //BNCϵͳ
#define     DS_6402_B12ES_CLASS        375        //SDIϵͳ
#define  DS_6402_B12EV_CLASS        376        //VGAϵͳ
#define  DS_6402_B12ER_CLASS        377        //RGBϵͳ
#define  DS_6402_B12ED_CLASS        378        //DVIϵͳ
#define  DS_6402_B12EH_CLASS        379        //HDMIϵͳ
#define  DS_6516D_B12EB_CLASS        380        //BNCϵͳ

#define  DS_iVMSE_AIO_8100x_CLASS   381     //ҵһX86ϵͳ
#define  DS_iVMSE_AIO_87x_CLASS     382     //¥һX86ϵͳ
#define  DS_6532D_B11ES_CLASS        384        //ǿͽ_SDI(B11)
#define  DS_6532D_B12ES_CLASS        385        //ǿͽ_SDI(B12)
//B20
#define  DS_B20_MSU_NP              400     //B20ذ
#define  DS_6416HFH_B20S            401     //SDI
#define  DS_6416HFH_B20_RM          402     //
#define  DS_6564D_B20D              403     //DVI
#define  DS_6564D_B20H              404     //HDMI
#define  DS_6564D_B20V              405     //VGA
#define  DS_B20_6516D_DEV_CLASS     406     //B20ϵͳ
#define  DS_6408HFH_B20V            407     //VGA
#define  DS_MMC_B20_CLASS           408     //B20
#define  DS_CARD_CHIP_B20_CLASS     409     //B20Ӱ
#define  DS_6564D_B20B_DEV_CLASS    410     //BNCϵͳ
#define  DS_6564D_B20S_DEV_CLASS    411     //SDIϵͳ
#define  DS_6532HF_B20B_DEV_CLASS   412     //BNCϵͳ
#define  DS_6408HFH_B20D_DEV_CLASS  413     //DVIϵͳ
#define  DS_6408HFH_B20H_DEV_CLASS  414     //HDMIϵͳ
#define  DS_IVMSE_B20_CLASS            415     //X86ϵͳ
#define  DS_6402HFH_B20Y_DEV_CLASS  416     //YUVϵͳ
#define  DS_6508HW_B20_DEV_CLASS    417     //HWϵͳ
#define  DS_B20N128Fx_B20_DEV_CLASS 418     //DS_B20N128Fx_M
#define  DS_AIO_MCU_NP_DEV_CLASS    419     //IOذ
#define  DS_6402_AIO_EV_DEV_CLASS   420     //VGA
#define  DS_6508D_AIO_EV_DEV_CLASS  421     //VGA
#define  DS_6508D_AIO_ED_DEV_CLASS  422     //DVI
#define  DS_6508D_AIO_EH_DEV_CLASS  423     //HDMI
#define  DS_6508HD_B20F_DEV_CLASS    424     //Ƶǿ
#define  DS_6402HFH_B20ES_DEV_CLASS 425     //3G SID
#define  DS_6532D_B20_DEV_CLASS     426     //B20ϵͳ            
#define  DS_IVMST_B20_DEV_CLASS     427     //X86ϵͳ
#define  DS_6416HFH_B20DD_DEV_CLASS 428     //DVI˫·
#define  DS_6441VS_B20_DEV_CLASS    429        //ƴ
#define  DS_6404HFH_B20T_CLASS         431        //TVI
#define  DS_FS22_B20_DEV_CLASS         432        //ϵͳ
#define  DS_IVMSE_B20UH_DEV_CLASS   433     //X86
#define  IDS_6524J_B20_DEV_CLASS    434
#define  IDS_6532B_B20_DEV_CLASS    435
#define DS_6404HFH_B20Fx_DEV_CLASS  436        //˻ϵͳ
#define DS_N128x_B20Fy_CLASS        437     //ϵͳ
#define DS_181600F_B20_CLASS        438     //ϵͳ
#define  DS_6904UD_B20H_CLASS       439     //ϵͳ

#define DS_B21_MCU_NP_CLASS         440        //B21
#define DS_B21_S10_x_CLASS          441        //B21 x = A/S/D
#define DS_6402HFH_B21D_CLASS        442     //B21ϵͳ
#define DS_6508HD_B21D_CLASS        443     //B21ϵͳ
#define DS_iVMSE_B21HW_CLASS        444     //B21 X86ϵͳ

#define  DS_C10S                    501     //C10S ʽ

#define  DS_C10N_SDI                551        //SDI
#define  DS_C10N_BIW                552        //8·BNC
#define  DS_C10N_DON                553        //ʾ
#define  DS_C10N_TVI                554     //TVI
#define  DS_C10N_DI2                555     //DVI 2·
#define  DS_C10N_AUDIO_OUT          556     //DVIHDMIVGAƵ
#define  DS_C10N_AUDIO_IN           557     //DVIHDMIVGAƵ

#define  DS_C20N                    570     //ֲʽ
#define  DS_C20N_BNC                571     //BNC豸
#define  DS_C20N_DVI                572     //DVI豸
#define  DS_C20N_DP                 573     //DP豸
#define  DS_C20N_OUT                574     //豸


//豸
#define DS_19M00_MN                    601     //ģ 
#define DS_KH8302_A                 602  //ڻ
#define DS_KD8101_2                 603  //ſڻ
#define DS_KM8301                   604  //
#define DS_KVXXXX_XX                605  //ſڻ


#define DS64XXHD_T                    701        //64-T
#define DS_65XXD                    703     //65ܽ
#define DS63XXD_T                    704        //63-T
#define SCE_SERVER                  705     //ץ
#define DS_64XXHD_S                 706     //64XXHD-S
#define DS_68XXT                    707     //๦Ƶת
#define DS_65XXD_T                  708     //65D-Tܽ
#define DS_65XXHD_T                 709     //65HD-Tܽ
#define DS_69XXUD                   710     //69XXUD
#define DS_65XXUD                   711     //65XXUD
#define DS_65XXUD_L                 712     //65XXUD_L
#define DS_65XXUD_T                 713     //65XXUD_T

#define DS_D20XX                    750     //LCDĻ 뿨
//SDI
#define DS_C50S                     751     //SDI
#define DS_D50XX                    752     //LCDĻ 뿨

#define DS_D40                        760        //LEDͿ
#define DS_65VMXX                   770     //Ƶ
#define DS_65VTXX                   771     //Ƶն
#define    DS_65VTA                    772        //Ƶһʽն
#define DS_65VT_RX                  773     //ѧն
#define DS_CS_SERVER                800     //
#define DS_K260X                    850     //Ž
#define DS_K1TXXX                   851     //ָһ
#define DS_K280X                    852     //Ž
#define DS_K1T80X                   854     //Žһ
#define RAC_6X00                    856     //ָŽһ
#define DS_K2602_AX                 857     //Աͨ
#define DS_6800M                    900     //68M
#define DS_68NTH                    901     //Ϣ
#define DS_D60S                     902     //Ϣ
#define    DS_D10                        931        //Ͷʾ豸
#define DS_3K0X_NM                    951        //շ
#define DS_3E2328                    952     //׽
#define SCREEN_LINK_SERVER          971     //Ļ
#define DS_D51OPSXX             972  //OPSԺ
//һ廯̨
#define IP_PTSYS_MEGA200            1001   //IP 200һ廯̨
#define IPCAM_FISHEYE               1002   //
#define IPCAM_FISHEYE_E             1003   //

//68xxϵ˫Ŀ3D
#define IPCAM_BINOCULAR             1004   //˫Ŀ

#define IPCAM_365                    1010    //֧365ƽ̨IPC CAM
#define IPCAM_R0                    1011    //֧A5Sƽ̨IPC CAM
#define IPCAM_R1                    1012    //֧385ƽ̨IPC CAM
#define IPCAM_R2                    1013    //֧R2ƽ̨IPC CAM
#define IPCAM_R3                    1014    //֧8127ƽ̨IPC CAM
#define IPCAM_R4                    1015    //֧S2ƽ̨IPC CAM

#define IPDOME_365                    1110    //֧365ƽ̨IPD CAM
#define IPDOME_R0                    1111    //֧A5Sƽ̨IPD CAM
#define IPDOME_R1                    1112    //֧385ƽ̨IPD CAM
#define IPDOME_R2                    1113    //֧R2ƽ̨IPD CAM
#define IPDOME_R3                    1114    //֧8127ƽ̨IPD CAM
#define IPDOME_R4                    1115    //֧S2ƽ̨IPD CAM
#define ITCCAM_R3                    1211    //֧8127ƽ̨ITCCAM

//豸 2013-11-19
#define TRAFFIC_ECT                    1400  //ECT豸
#define TRAFFIC_PARKING_SERVER        1401  //ͣ
#define TRAFFIC_TME                    1402  //ڿƻ
// DVR
#define DS90XXHW_ST                    2001    // DS90XXHW_STDVR
#define DS72XXHX_SH                 2002    // DS-72xxHV_SH, DS-72xxHF-SH 
#define DS_92XX_HF_ST                2003    // DS-92XX-HF-ST 
#define DS_91XX_HF_XT                2004    // 9100DVR_HF_XT
#define DS_90XX_HF_XT               2005    // 9000DVR_HF_XT 
#define DS_73XXHX_SH                2006    // 7300DVR_HX_SH  
#define DS_72XXHFH_ST                2007    // 7200DVR_HFH_ST
//DS_67ϵ

#define DS_67XXHF_SATA              2008 // DS-67XXHF-SATA
#define DS_67XXHW                   2009 // DS-67XXHW 
#define DS_67XXHW_SATA              2010 // DS-67XXHW-SATA
#define DS_67XXHF                   2011 // DS-67XXHF

//Netra2.3
#define DS_72XXHF_SV                2012  // DS-72xxHF-SV 
#define DS_72XXHW_SV                2013   // DS-72xxHW-SV

#define DS_81XXHX_SH                2014   // 8100DVR_HX_SH

#define DS_71XXHX_SL                2015    //СDVR

#define DS_76XXH_ST                    2016    //DS_76XXH_ST


#define DS_73XXHFH_ST               2017   //73HFHϵ
#define DS_81XXHFH_ST               2018   //81HFHϵ ST

#define DS_72XXHFH_SL                2019    //hi3521 
#define DS_FDXXCGA_FLT                2020    //2λATM

#define IDS_91XX_HF_ST_A            2100    //iDS-9100HF-ST/A
#define IDS_91XX_HF_ST_B            2101    //iDS-9100HF-ST/B
#define IDS_90XX_HF_ST_A            2102    //iDS-9000HF-ST/A
#define IDS_90XX_HF_ST_B            2103    //iDS-9000HF-ST/B
#define IDS_81XX_HF_ST_A            2104    //iDS-8100HF-ST/A
#define IDS_81XX_HF_ST_B            2105    //iDS-8100HF-ST/B
#define IDS_80XX_HF_ST_A            2106    //iDS-8000HF-ST/A
#define IDS_80XX_HF_ST_B            2107    //iDS-8000HF-ST/B
#define IDS_8104_AHFL_ST            2108    //ܻATM

#define DS_72XXHXH_SH_21            2220   // 72HXH_SHϵ_21
#define DS_72XXHXH_SH_31            2221  // 72XXHXH_SH_31
#define DS_73XXHXH_SH_31            2222  // 73XXHXH_SH_31
#define DS_81XXHXH_SH_31            2223  // 81XXHXH_SH_31


// NVR
#define DS_77XXN_ST                    2201    //  NVR DS-77XXHF-ST
#define DS_95XX_N_ST                2202    //  95XXN_ST NVR          
#define DS_85XX_N_ST                2203    //  85XXN_ST NVR
#define DS_96XX_N_XT                2204    // 9600NVR_N_XT
#define DS_76XX_N_SE                2205    // 7600NVR_N_SE

//Ѷ
#define DS_86XXSN_SX                2206    // 8608NVR_SX4DS-8608SNL-SPDS-8608SNL-STDS-8608SN-SPDS-8608SN-STLʾLCDPPOE

//#define DS_96XX_N_RX                2207  //DS-96XX-N-RX
#define DS_71XXN_SL                    2208  //DS-71XXN-SL òƷ
#define CS_N1_1XX                    2209  //CS_N1_1XXҵ

#define DS_71XXN_SN                    2210    //71XX_N_SN  òƷ 
#define CS_N1_2XX                    2211    //N1_2XX        ҵ
#define DS_76XX_N_SHT                2212    //76XX_N_SHT  ˻߲Ʒ
#define DS_96XXX_N_E                2213    //NVR(256) 

#define    DS_76XXN_EX                    2214 /* 76 78ϵNVRע 4 8 16·E1һλ 8 16 32· E2λ /N /P豸*/
#define DS_77XXN_E4                    2215/* 77ϵNVR   ע8 16 32· /N /P豸*/
#define DS_86XXN_E8                    2216/* 86ϵNVR   ע8 16 32· /N /P豸*/
#define DS_9616N_H8                 2217   //DS_9616N_H8
#define DS_72XXHX_EX_GXY            2218   //ʾ72ϵDVRƷ72xxʾͨHXĿǰHW,Ϊ˺չEXʾλG XYʾ
#define DS_76XXN_EX_GXY             2219   //ʾ76ϵNVRƷ76xxʾͨEXʾλG XYʾ
#define DS_72XXHXH_SH_21            2220   //  72XXHXH_SH_21
#define DS_72XXHXH_SH_31            2221  //  72XXHXH_SH_31
#define DS_73XXHXH_SH_31            2222  // 73XXHXH_SH_31
#define DS_81XXHXH_SH_31            2223  //  81XXHXH_SH_31
#define DS_96XXN_FX                 2230
#define DS_86XXN_FX                 2231
#define DS_96XXXN_HX                2232  //96ϵи豸


#define DS_86XXN_I                    2233    //DS_86XXN_I
#define DS_77XX_N_I                    2234    //DS_77XX_N_I
#define DS_76XX_N_I                    2235    //DS_76XX_N_I
#define DS_78XX_N_I                    2236    //DS_78XX_N_I

//PCNVR
#define PCNVR_IVMS_4200             2301    // PCNVR_IVMS_4200


//ܷ
#define IVMS_6200_TP                2401   //IVMS-6200 ͨյ
#define IVMS_6200_TF                2402   //IVMS-6200 ͨȡ֤
#define IVMS_6200_D                 2403   //iVMS-6200(/D)
#define IDS_81XXAHW_ST              2405   //iDS-81xxAHW-ST
#define IDS_81XXAHW_SP              2406   //iDS-81xxAHW-SP
#define IDS_81XXAHWL_ST             2407   //iDS-81xxAHWL-ST 
#define IDS_81XXAHWL_SP             2408   //iDS-81xxAHWL-SP
#define IDS_9616N_H8                2409   //iDS_9616N_H8
#define IVMS_6200_SMD               2500   //IVMS_6200_SMD
//HISI3531ƽ̨ATM DVR LʾҺPʾpoe
#define DS_81XXAHW_ST                2501
#define DS_81XXAHW_SP                2502
#define DS_81XXAHWL_ST                2503
#define DS_81XXAHWL_SP                2504

//TVI ATM
#define DS_81XXAHGH_E4                2601    //DS_81XXAHGH_E4

#define DS_6904UD_AIOE_H_CLASS      4002    //B20һ
#define DS_6402HFH_B21B_CLASS       4005    //B21 
#define DS_6902UD_B21H_CLASS        4006    //B21 HDMI
#define DS_6902UD_B21D_CLASS        4007    //B21 DVI
#define DS_6902UD_B21V_CLASS        4008    //B21 VGA
#define DS_6904UD_B20D_CLASS        4010    //B20 DVI
#define DS_6904UD_B20V_CLASS        4011    //B20 VGA



/**********************豸 end***********************/

/**********************豸 begin**********************/

/* dvr 1-50 */
#define DEV_CLASS_DVR      1          //ͨdvr
#define DEV_CLASS_INTERROGATION  2    //Ѷ
#define DEV_CLASS_SIMPLE_TRAIL  3    //ͥ
#define DEV_CLASS_TRAIL  4           //׼ͥ
#define DEV_CLASS_RECORD_PLAY  5     //¼
#define DEV_CLASS_ATM 6           //ATM

/* dvs 51-100 */
#define DEV_CLASS_DVS 51          //ͨdvs

/* nvr 101-150 */
#define DEV_CLASS_NVR 101          //ͨnvr

/* ipc 151-200 */
#define DEV_CLASS_GUN 151          //ipcǹ
#define DEV_CLASS_BALL 152          //ipc
#define DEV_CLASS_SNAP 153          //ץĻ
#define DEV_CLASS_INTELLI_TILT 154   //̨

/* 豸 65534 */
#define DEV_CLASS_DEFAULT 65534   //Ĭ豸
/**********************豸 end**********************/

/******************************ȡ*********************************/
//ȡ
#define DEVICE_SOFTHARDWARE_ABILITY         0x001  //豸Ӳ
#define DEVICE_NETWORK_ABILITY              0x002  //豸
#define DEVICE_ENCODE_ALL_ABILITY           0x003  //豸б
#define    DEVICE_ENCODE_CURRENT               0x004  //豸ǰ
#define IPC_FRONT_PARAMETER                    0x005     //ipcǰ˲1.0
#define IPC_UPGRADE_DESCRIPTION                0x006     //ipcϢ
#define DEVICE_RAID_ABILITY                 0x007  //RAID
#define DEVICE_ENCODE_ALL_ABILITY_V20       0x008     //豸б2.0
#define IPC_FRONT_PARAMETER_V20                0x009     //ipcǰ˲2.0
#define DEVICE_ALARM_ABILITY                0x00a  //
#define DEVICE_DYNCHAN_ABILITY                0x00b  //豸ͨ
#define DEVICE_USER_ABILITY                 0x00c  //豸û
#define DEVICE_NETAPP_ABILITY               0x00d  //豸Ӧò
#define DEVICE_VIDEOPIC_ABILITY             0x00e  //豸ͼ
#define DEVICE_JPEG_CAP_ABILITY             0x00f  //豸JPEGץͼ
#define DEVICE_SERIAL_ABILITY               0x010  //RS232RS485
#define DEVICE_ABILITY_INFO                    0x011     //豸ͨͣݷ͵ڵ
#define STREAM_ABILITY                      0x012  //
#define SYSTEM_MANAGEMENT_ABILITY           0x013  //豸ϵͳ
#define IP_VIEW_DEV_ABILITY                    0x014  //IPӶԽֻ
#define VCA_DEV_ABILITY                     0x100  //豸ܷ
#define VCA_CHAN_ABILITY                    0x110  //Ϊ
#define MATRIXDECODER_ABILITY               0x200  //·ʾ
#define VIDEOPLATFORM_ABILITY               0x210 //Ƶۺƽ̨
#define VIDEOPLATFORM_SBUCODESYSTEM_ABILITY 0x211 //Ƶۺƽ̨ϵͳ
#define WALL_ABILITY                        0x212  //ǽ
#define MATRIX_ABILITY                      0x213  //SDI 
#define DECODECARD_ABILITY                  0x220 //뿨
#define VIDEOPLATFORM_ABILITY_V40           0x230 //Ƶۺƽ̨
#define MATRIXMANAGEDEVICE_ABILITY          0x240 //
#define MATRIXDECODER_ABILITY_V41           0x260 //
#define DECODER_ABILITY                     0x261 //xml
#define DECODECARD_ABILITY_V41              0x270 //뿨V41
#define CODECARD_ABILITY                    0x271  //뿨
#define SNAPCAMERA_ABILITY                  0x300  //ץĻ
#define ITC_TRIGGER_MODE_ABILITY            0x301  //IPC豸Ĵģʽ
#define COMPRESSIONCFG_ABILITY              0x400  //ȡѹ
#define COMPRESSION_LIMIT                   0x401  //ȡѹ
#define PIC_CAPTURE_ABILITY                    0x402  //ͼƬֱ
#define ALARMHOST_ABILITY                   0x500 //籨 
#define IT_DEVICE_ABILITY                   0x501  //ܽͨ
#define    SCREENCONTROL_ABILITY                0x600     //
#define    SCREENSERVER_ABILITY                0x610     //
#define FISHEYE_ABILITY                     0x700   //
#define LCD_SCREEN_ABILITY                    0x800    //LCDĻ 2013-10-12
#define ACS_ABILITY                         0x801   //Ž
#define MERGEDEV_ABILITY                    0x802   //
#define CAM_FUSION_ABILITY                  0x803   //ƴ
#define OPTICAL_DEV_ACCESS_ABILITY          0x805   //˻
#define NET_RING_ABILITY                    0x806    //
#define LED_ABILITY                            0x807    //LED
#define PUBLISHDEV_ABILITY                    0x80a    //Ϣ
#define SCREEN_EXCHANGE_ABILITY             0x80b   //Ļ
/*************************************************
ýṹ(_V30Ϊ9000)
**************************************************/

//Ӱ쳣Ϣ
//
#define EXCEPTION_MAJOR_MAINBOARD_BOOT                    0x1  //
//
#define EXCEPTION_MINOR_PCIE_SCAN                        0x1  // pcie·ɨ쳣  
#define EXCEPTION_MINOR_DOWNLOAD_SUBBOARD                 0xa  //Ӱ쳣

//
#define EXCEPTION_MAJOR_SUBBOARD_BOOT                    0x2  //Ӱ
//
#define EXCEPTION_MINOR_INEXISTENCE                       0x1  //PCI-EɨǰӰ岻
#define EXCEPTION_MINOR_UBOOT_DOWNLOAD                  0xa  // uboot쳣
#define EXCEPTION_MINOR_UBOOT_INIT                      0xe  //ubootʼ쳣
#define EXCEPTION_MINOR_ROOTFS_DOWNLOAD                 0x14  //rootfs.img쳣
#define EXCEPTION_MINOR_UIMAGE_DOWNLOAD                 0x19  //uImage쳣
#define EXCEPTION_MINOR_UBOOT_SETBOOTFLAG               0x1e  // uboot־λλ쳣    
#define EXCEPTION_MINOR_ROOTFS_BOOT_SUBBOARD            0x23  // rootfs쳣
#define EXCEPTION_MINOR_NEED_FILE_FINISH                0x28  //Ӱļ쳣

//
#define EXCEPTION_MAJOR_SUBBOARD_HARDWARE                0x3  //ӰӲ
//
#define EXCEPTION_MINOR_AD                               0x1  //AD쳣  
#define EXCEPTION_MINOR_DA                                 0xa  // DA쳣
#define EXCEPTION_MINOR_TIMER                            0xb     //ʱ쳣

//
#define EXCEPTION_MAJOR_FPGA                            0x4  //FPGA
//
#define EXCEPTION_MINOR_IDLE                              0x1  //޷IDLE  
#define EXCEPTION_MINOR_LANE                             0xa  // LANE OKʧ
#define EXCEPTION_MINOR_REGISTER_ALL_F                     0xe  //FPGAĴȫF
#define EXCEPTION_MINOR_MEMORY_INIT_FAIL                 0x14 //FPGAڴʼʧ
//
#define EXCEPTION_MAJOR_DSP                                0x5  //DSP

//
#define EXCEPTION_MAJOR_ARM                                0x6  //ARM

//
#define EXCEPTION_MAJOR_BACKBOARD                        0x7  //
//
#define EXCEPTION_MINOR_BLACKBOARD_TYPE                   0x1  //ȡ쳣
#define EXCEPTION_MINOR_SERDES                           0xa  //ƵоƬ  
#define EXCEPTION_MINOR_CLOCK                             0xe  //ʱӹ
#define EXCEPTION_MINOR_SYNCH                             0x14  //ͬźŹ

//
#define EXCEPTION_MAJOR_SUBBOARD_NET                    0x8  //Ӱ
//
#define EXCEPTION_MINOR_IP_CONFLICT                       0x1  //IPͻ 
#define EXCEPTION_MINOR_DISCONNECT                         0x14  // 



typedef enum tagCharEncodeType
{
    ENUM_MEM_CHAR_ENCODE_ERR  = -1,         //Error   
    ENUM_MEM_CHAR_ENCODE_NO   = 0,          //Don't know.
    ENUM_MEM_CHAR_ENCODE_CN   = 1,          //EUC-CN, GB2312
    ENUM_MEM_CHAR_ENCODE_GBK  = 2,          //GBK
    ENUM_MEM_CHAR_ENCODE_BIG5 = 3,          //BIG5
    ENUM_MEM_CHAR_ENCODE_JP   = 4,          //JISX0208-1, EUC-JP
    ENUM_MEM_CHAR_ENCODE_KR   = 5,          //EUC-KR
    ENUM_MEM_CHAR_ENCODE_UTF8 = 6,          //UTF-8
    ENUM_MEM_CHAR_ENCODE_ISO8859_1  = 7,    //ISO-8859-n: ENUM_MEM_CHAR_ENCODE_ISO8859_1 + n -1
}CHAR_ENCODE_TYPE;


/////////////////////////////////////////////////////////////////////////
//Уʱṹ
typedef struct
{
    DWORD dwYear;        //
    DWORD dwMonth;        //
    DWORD dwDay;        //
    DWORD dwHour;        //ʱ
    DWORD dwMinute;        //
    DWORD dwSecond;        //
}NET_DVR_TIME, *LPNET_DVR_TIME;

typedef struct tagNET_DVR_TIME_V30
{
    WORD wYear;
    BYTE byMonth;
    BYTE byDay;
    BYTE byHour;
    BYTE byMinute;
    BYTE bySecond;
    BYTE byRes;
    WORD wMilliSec;
    BYTE byRes1[2];
}NET_DVR_TIME_V30, *LPNET_DVR_TIME_V30;

typedef struct  tagNET_DVR_CALIBRATE_TIME
{
    DWORD  dwSize;
    NET_DVR_TIME struTime;
    WORD wMilliSec;
    BYTE byRes[14];
}NET_DVR_CALIBRATE_TIME,*LPNET_DVR_CALIBRATE_TIME;

#define    MAX_TIMESIGN_LEN    32 //ԶУʱϢ
typedef  struct tagNET_DVR_TIMESIGN_CFG
{
    DWORD  dwSize;
    BYTE  byCustomSetTimeSign[MAX_TIMESIGN_LEN/*32*/];//ԶУʱ
    BYTE  byRes[96]; 
}NET_DVR_TIMESIGN_CFG,*LPNET_DVR_TIMESIGN_CFG;


typedef struct tagNET_DVR_TIME_EX
{
    WORD wYear;
    BYTE byMonth;
    BYTE byDay;
    BYTE byHour;
    BYTE byMinute;
    BYTE bySecond;
    BYTE byRes;
}NET_DVR_TIME_EX,*LPNET_DVR_TIME_EX;

//ʱ(ӽṹ)
typedef struct
{
    //ʼʱ
    BYTE byStartHour;
    BYTE byStartMin;
    //ʱ
    BYTE byStopHour;
    BYTE byStopMin;
}NET_DVR_SCHEDTIME, *LPNET_DVR_SCHEDTIME;

/*豸쳣ʽ*/
/*豸쳣ʽ*/
#define NOACTION            0x0                /*Ӧ*/
#define WARNONMONITOR        0x1                /*Ͼ*/
#define WARNONAUDIOOUT        0x2                /**/
#define UPTOCENTER            0x4                /*ϴ*/
#define TRIGGERALARMOUT        0x8                /**/
#define TRIGGERCATPIC        0x10            /*ץͼϴE-mail*/
#define SEND_PIC_FTP        0x200           /*ץͼϴftp*/

typedef struct tagNET_DVR_STRUCTHEAD
{
    WORD    wLength;        //ṹ
    BYTE    byVersion ;    /*ߵ4λֱߵͰ汾ݰ汾ͳȽչͬİ汾ĳȽ*/
    BYTE    byRes;
}NET_DVR_STRUCTHEAD, *LPNET_DVR_STRUCTHEAD;

typedef struct tagNET_DVR_HANDLEEXCEPTION_V41
{    
    DWORD   dwHandleType;        //쳣,쳣ʽ""   
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: */
    /*0x10: JPRGץͼϴEmail*/
    /*0x20: ⱨ*/
    /*0x40: ӵͼ(ĿǰֻPCNVR֧)*/
    /*0x200: ץͼϴFTP*/
    /*0x400: 齻  ۽ģʽṩԭ豸ԶɣIPC5.1.0*/
    /*0x800: PTZ(Ŀ)*/
    DWORD   dwMaxRelAlarmOutChanNum ; //ıֻ֧ͨ
    DWORD   dwRelAlarmOut[MAX_ALARMOUT_V40]; //ͨ  
    BYTE    byRes[64];           //
}NET_DVR_HANDLEEXCEPTION_V41, *LPNET_DVR_HANDLEEXCEPTION_V41;

typedef struct tagNET_DVR_HANDLEEXCEPTION_V40
{    
    DWORD   dwHandleType;        //쳣,쳣ʽ""   
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: */
    /*0x10: JPRGץͼϴEmail*/
    /*0x20: ⱨ*/
    /*0x40: ӵͼ(ĿǰֻPCNVR֧)*/
    /*0x80: ¼(ĿǰֻPCNVR֧) */
    /*0x100: ̨Ԥõ (ĿǰֻPCNVR֧)*/
    /*0x200: ץͼϴFTP*/ 
    /*0x400: 齻  ۽ģʽṩԭ豸ԶɣIPC5.1.0*/
    /*0x800: PTZ(Ŀ)*/ 
    /*0x1000:ץͼϴ*/
    DWORD   dwMaxRelAlarmOutChanNum ; //ıֻ֧ͨ
    DWORD   dwRelAlarmOutChanNum; //ıͨ ʵ֧
    DWORD   dwRelAlarmOut[MAX_CHANNUM_V30]; //ͨ  
    BYTE    byRes[64];           //
}NET_DVR_HANDLEEXCEPTION_V40, *LPNET_DVR_HANDLEEXCEPTION_V40;

//쳣ṹ(ӽṹ)(ദʹ)(9000չ)
typedef struct
{
    DWORD    dwHandleType;    /*ʽ,ʽ""*/
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: */
    /*0x10: JPRGץͼϴEmail*/
    /*0x20: ⱨ*/
    /*0x40: ӵͼ(ĿǰֻPCNVR֧)*/
    /*0x200: ץͼϴFTP*/
    BYTE byRelAlarmOut[MAX_ALARMOUT_V30];  
    //ͨ,,Ϊ1ʾ
}NET_DVR_HANDLEEXCEPTION_V30, *LPNET_DVR_HANDLEEXCEPTION_V30;

//쳣ṹ(ӽṹ)(ദʹ)
typedef struct
{
    DWORD    dwHandleType;            /*ʽ,ʽ""*/
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: */
    /*0x10: JpegץͼϴEMail*/
    BYTE byRelAlarmOut[MAX_ALARMOUT];  //ͨ,,Ϊ1ʾ
}NET_DVR_HANDLEEXCEPTION, *LPNET_DVR_HANDLEEXCEPTION;

//DVR豸
typedef struct
{
    DWORD dwSize;
    BYTE sDVRName[NAME_LEN];     //DVR
    DWORD dwDVRID;                //DVR ID,ң //V1.4(0-99), V1.5(0-255)
    DWORD dwRecycleRecord;        //Ƿѭ¼,0:; 1:
    //²ɸ
    BYTE sSerialNumber[SERIALNO_LEN];  //к
    DWORD dwSoftwareVersion;            //汾,16λ汾,16λǴΰ汾
    DWORD dwSoftwareBuildDate;            //,0xYYYYMMDD
    DWORD dwDSPSoftwareVersion;            //DSP汾,16λ汾,16λǴΰ汾
    DWORD dwDSPSoftwareBuildDate;        // DSP,0xYYYYMMDD
    DWORD dwPanelVersion;                // ǰ汾,16λ汾,16λǴΰ汾
    DWORD dwHardwareVersion;    // Ӳ汾,16λ汾,16λǴΰ汾
    BYTE byAlarmInPortNum;        //DVR
    BYTE byAlarmOutPortNum;        //DVR
    BYTE byRS232Num;            //DVR 232ڸ
    BYTE byRS485Num;            //DVR 485ڸ
    BYTE byNetworkPortNum;        //ڸ
    BYTE byDiskCtrlNum;            //DVR Ӳ̿
    BYTE byDiskNum;                //DVR Ӳ̸
    BYTE byDVRType;                //DVR, 1:DVR 2:ATM DVR 3:DVS ......
    BYTE byChanNum;                //DVR ͨ
    BYTE byStartChan;            //ʼͨ,DVS-1,DVR - 1
    BYTE byDecordChans;            //DVR ·
    BYTE byVGANum;                //VGAڵĸ
    BYTE byUSBNum;                //USBڵĸ
    BYTE byAuxoutNum;            //ڵĸ
    BYTE byAudioNum;            //ڵĸ
    BYTE byIPChanNum;            //ͨ
}NET_DVR_DEVICECFG, *LPNET_DVR_DEVICECFG;

/*
IPַ
*/
typedef struct
{        
    char    sIpV4[16];                        /* IPv4ַ */
    BYTE    byIPv6[128];                        /*  */
}NET_DVR_IPADDR, *LPNET_DVR_IPADDR;

/*
ݽṹ(ӽṹ)(9000չ)
*/
typedef struct 
{
    NET_DVR_IPADDR    struDVRIP;                              //DVR IPַ
    NET_DVR_IPADDR    struDVRIPMask;  //DVR IPַ
    DWORD    dwNetInterface;                                   //ӿ1-10MBase-T 2-10MBase-Tȫ˫ 3-100MBase-TX 4-100Mȫ˫ 5-10M/100MӦ
    WORD    wDVRPort;                                        //˿ں
    WORD    wMTU;                                            //MTUãĬ1500
    BYTE    byMACAddr[MACADDR_LEN];                            // ַ
    BYTE    byRes[2];              //
}NET_DVR_ETHERNET_V30, *LPNET_DVR_ETHERNET_V30;

/*
ݽṹ(ӽṹ)
*/
typedef struct
{
    char sDVRIP[16];          //DVR IPַ
    char sDVRIPMask[16];      //DVR IPַ
    DWORD dwNetInterface;     //ӿ 1-10MBase-T 2-10MBase-Tȫ˫ 3-100MBase-TX 4-100Mȫ˫ 5-10M/100MӦ
    WORD wDVRPort;              //˿ں
    BYTE byMACAddr[MACADDR_LEN];        //ַ
}NET_DVR_ETHERNET;

//pppoeṹ
typedef struct 
{
    DWORD    dwPPPOE;                                        //0-,1-
    BYTE    sPPPoEUser[NAME_LEN];                            //PPPoEû
    char    sPPPoEPassword[PASSWD_LEN];                        // PPPoE
    NET_DVR_IPADDR    struPPPoEIP;                            //PPPoE IPַ
}NET_DVR_PPPOECFG, *LPNET_DVR_PPPOECFG;

//ýṹ(9000չ)
typedef struct
{    
    DWORD dwSize;
    NET_DVR_ETHERNET_V30    struEtherNet[MAX_ETHERNET];        //̫
    NET_DVR_IPADDR    struRes1[2];                    /**/
    NET_DVR_IPADDR    struAlarmHostIpAddr;                    /* IPַ */
    BYTE    byRes2[4];                                /*  */
    WORD    wAlarmHostIpPort;                                /* ˿ں */
    BYTE    byUseDhcp;                                      /* ǷDHCP 0xff-Ч 0- 1-*/
    BYTE    byIPv6Mode;                                //IPv6䷽ʽ0-·ɹ棬1-ֶã2-DHCP
    NET_DVR_IPADDR    struDnsServer1IpAddr;                    /* 1IPַ */
    NET_DVR_IPADDR    struDnsServer2IpAddr;                    /* 2IPַ */
    BYTE    byIpResolver[MAX_DOMAIN_NAME];                    /* IPIPַ */
    WORD    wIpResolverPort;                                /* IP˿ں */
    WORD    wHttpPortNo;                                    /* HTTP˿ں */
    NET_DVR_IPADDR    struMulticastIpAddr;                    /* ಥַ */
    NET_DVR_IPADDR    struGatewayIpAddr;                        /* صַ */
    NET_DVR_PPPOECFG struPPPoE;    
    BYTE    byEnablePrivateMulticastDiscovery;  //˽жಥ0~Ĭϣ1~ã2-
    BYTE    byEnableOnvifMulticastDiscovery;  //Onvifಥ0~Ĭϣ1~ã2-
    BYTE    byRes[62];
} NET_DVR_NETCFG_V30, *LPNET_DVR_NETCFG_V30;

//ṹ
typedef struct 
{
    NET_DVR_IPADDR struDVRIP;           //DVR IPַ
    NET_DVR_IPADDR struDVRIPMask;           //DVR IPַ
    DWORD dwNetInterface;    //ӿ1-10MBase-T 2-10MBase-Tȫ˫ 3-100MBase-TX 4-100Mȫ˫ 5-10M/100M/1000MӦ
    BYTE byCardType;  //ͣ0-ͨ1-2-
    BYTE byRes1; 
    WORD wMTU;             //MTUãĬ1500
    BYTE byMACAddr[MACADDR_LEN]; //ַֻʾ
    BYTE byRes2[2]; //
    BYTE byUseDhcp;                          /* ǷDHCP */
    BYTE byRes3[3];
    NET_DVR_IPADDR struGatewayIpAddr;     /* صַ */
    NET_DVR_IPADDR struDnsServer1IpAddr; /* 1IPַ */
    NET_DVR_IPADDR struDnsServer2IpAddr; /* 2IPַ */
}NET_DVR_ETHERNET_MULTI, *LPNET_DVR_ETHERNET_MULTI;

//ýṹ
typedef struct
{
    DWORD  dwSize;
    BYTE   byDefaultRoute;        //Ĭ·ɣ0ʾstruEtherNet[0]1ʾstruEtherNet[1]
    BYTE   byNetworkCardNum;      //豸ʵʿõĿ
    BYTE   byWorkMode;   //0-ͨģʽ1-ģʽ
    BYTE   byRes; //
    NET_DVR_ETHERNET_MULTI struEtherNet[MAX_NETWORK_CARD]; //̫
    NET_DVR_IPADDR         struManageHost1IpAddr;     /* IPַ */
    NET_DVR_IPADDR         struManageHost2IpAddr;     /* IPַ */
    NET_DVR_IPADDR           struAlarmHostIpAddr; /* IPַ */
    WORD wManageHost1Port;     /* ˿ں */
    WORD wManageHost2Port;     /* ˿ں */
    WORD wAlarmHostIpPort;     /* ˿ں */
    BYTE  byIpResolver[MAX_DOMAIN_NAME];     /* IPIPַ */
    WORD wIpResolverPort; /* IP˿ں */
    WORD wDvrPort; //ͨѶ˿ Ĭ8000 
    WORD wHttpPortNo; /* HTTP˿ں */
    WORD wDvrPort2; //ͨѶ˿2
    BYTE byRes2[4];
    NET_DVR_IPADDR   struMulticastIpAddr; /* ಥַ */
    NET_DVR_PPPOECFG struPPPoE;
    BYTE byRes3[24];
}NET_DVR_NETCFG_MULTI, *LPNET_DVR_NETCFG_MULTI;

//ýṹ
typedef struct
{
    DWORD dwSize;
    NET_DVR_ETHERNET struEtherNet[MAX_ETHERNET];        /* ̫ */
    char sManageHostIP[16];        //Զַ̹
    WORD wManageHostPort;        //Զ̹˿ں
    char sIPServerIP[16];            //IPServerַ
    char sMultiCastIP[16];     //ಥַ
    char sGatewayIP[16];           //صַ
    char sNFSIP[16];            //NFSIPַ
    BYTE sNFSDirectory[PATHNAME_LEN];//NFSĿ¼
    DWORD dwPPPOE;                //0-,1-
    BYTE sPPPoEUser[NAME_LEN];    //PPPoEû
    char sPPPoEPassword[PASSWD_LEN];// PPPoE
    char sPPPoEIP[16];            //PPPoE IPַ(ֻ)
    WORD wHttpPort;                //HTTP˿ں
}NET_DVR_NETCFG, *LPNET_DVR_NETCFG;

//sip
typedef struct tagNET_DVR_SIP_CFG
{
    DWORD dwSize;
    BYTE byEnableAutoLogin;    //ʹԶעᣬ0-ʹܣ1-ʹ
    BYTE byLoginStatus;  //ע״̬0-δעᣬ1-עᣬ˲ֻܻȡ
    BYTE byRes1[2];
    NET_DVR_IPADDR stuServerIP;  //SIPIP
    WORD wServerPort;    //SIP˿
    BYTE byRes2[2];
    BYTE byUserName[NAME_LEN];  //עû
    BYTE byPassWord[PASSWD_LEN]; //ע
    BYTE byLocalNo[MAX_NUMBER_LEN];
    BYTE byDispalyName[MAX_NAME_LEN]; //豸ʾ
    WORD wLocalPort;     //ض˿
    BYTE byLoginCycle;   //עڣ1-99
    BYTE byRes[129];
}NET_DVR_SIP_CFG, *LPNET_DVR_SIP_CFG;

//IPӶԽֻ
typedef struct tagNET_DVR_IP_VIEW_DEVCFG
{
    DWORD dwSize;
    BYTE  byDefaultRing; //ĬΧ1-6
    BYTE  byRingVolume;  //Χ0-9
    BYTE  byInputVolume; //ֵΧ0-6
    BYTE  byOutputVolume; //ֵΧ0-9    
    WORD  wRtpPort;  //Rtp˿
    BYTE  byRes1[2];
    DWORD dwPreviewDelayTime; //Ԥʱã0-30
    BYTE  byRes2[64];
}NET_DVR_IP_VIEW_DEVCFG,*LPNET_DVR_IP_VIEW_DEVCFG;

//IpӶԽƵز
typedef struct tagNET_DVR_IP_VIEW_AUDIO_CFG
{
    DWORD dwSize;    
    BYTE  byAudioEncPri1; //Ƶȼ10-G7221-G711_U2-G711_A 5-MPEG2,6-G7267-AAC
    BYTE  byAudioEncPri2; //Ƶȼ2sip֧Ƶ1ʱʹƵ20-G7221-G711_U2-G711_A 5-MPEG2,6-G7267-AAC
    WORD  wAudioPacketLen1; //Ƶ1ݰ
    WORD  wAudioPacketLen2; //Ƶ2ݰ
    BYTE  byRes[30];
}NET_DVR_IP_VIEW_AUDIO_CFG,*LPNET_DVR_IP_VIEW_AUDIO_CFG;

//IPֻжԽýṹ
typedef struct tagNET_DVR_IP_VIEW_CALL_CFG
{
    DWORD dwSize ;
    BYTE  byEnableAutoResponse; //ʹԶӦ,0-ʹܣ1-ʹ
    BYTE  byAudoResponseTime; //ԶӦʱ䣬0-30
    BYTE  byRes1[2];
    BYTE  byEnableAlarmNumber1; //10-1-
    BYTE  byRes2[3];
    BYTE  byAlarmNumber1[MAX_NUMBER_LEN]; //к1
    BYTE  byEnableAlarmNumber2; //20-1-
    BYTE  byRes3[3];
    BYTE  byAlarmNumber2[MAX_NUMBER_LEN]; //к2к1ʧ᳢ܻԺк2
    BYTE  byRes4[72];
}NET_DVR_IP_VIEW_CALL_CFG,*LPNET_DVR_IP_VIEW_CALL_CFG;

//ͨͼṹ
//ƶ(ӽṹ)(鷽ʽչ)
typedef struct
{    
    DWORD     dwMaxRecordChanNum;   //豸ֵ֧¼ͨ-ֻ
    DWORD     dwCurRecordChanNum;    //ǰʵõĹ¼ͨ
    DWORD     dwRelRecordChan[MAX_CHANNUM_V30];     /* ʵʴ¼ֵͨʾ,ýУ±0 - MAX_CHANNUM_V30-1Чм0xffffffff,Ч*/  
    BYTE       byRes[64];          //
}NET_DVR_RECORDCHAN, *LPNET_DVR_RECORDCHAN;

//ƶ(ӽṹ)(9000չ)
typedef struct 
{
    BYTE byMotionScope[64][96];                                    /*,0-96λ,ʾ64,96*64С,Ϊ1ʾƶ,0-ʾ*/
    BYTE byMotionSensitive;                                        /*ƶ, 0 - 5,ԽԽ,oxffر*/
    BYTE byEnableHandleMotion;                                    /* Ƿƶ 0 1*/ 
    BYTE byEnableDisplay;    /*ƶʾ0-1-*/
    char reservedData;    
    NET_DVR_HANDLEEXCEPTION_V30 struMotionHandleType;                /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /*ʱ*/
    BYTE byRelRecordChan[MAX_CHANNUM_V30];                                    /* ¼ͨ*/
}NET_DVR_MOTION_V30, *LPNET_DVR_MOTION_V30;

//ƶ(ӽṹ)
typedef struct 
{
    BYTE byMotionScope[18][22];    /*,22*18С,Ϊ1ʾĺƶ,0-ʾ*/
    BYTE byMotionSensitive;        /*ƶ, 0 - 5,ԽԽ,0xffر*/
    BYTE byEnableHandleMotion;    /* Ƿƶ */
    BYTE byEnableDisplay;    /*ƶʾ0-1-*/
    char reservedData;
    NET_DVR_HANDLEEXCEPTION strMotionHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];//ʱ
    BYTE byRelRecordChan[MAX_CHANNUM]; //¼ͨ,Ϊ1ʾͨ
}NET_DVR_MOTION, *LPNET_DVR_MOTION;

//ڵ(ӽṹ)(9000չ)  С704*576
typedef struct 
{
    DWORD dwEnableHideAlarm;                /* Ƿڵ ,0-,1- 2- 3-*/
    WORD wHideAlarmAreaTopLeftX;            /* ڵx */
    WORD wHideAlarmAreaTopLeftY;            /* ڵy */
    WORD wHideAlarmAreaWidth;                /* ڵĿ */
    WORD wHideAlarmAreaHeight;                /*ڵĸ*/
    NET_DVR_HANDLEEXCEPTION_V30 strHideAlarmHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
}NET_DVR_HIDEALARM_V30, *LPNET_DVR_HIDEALARM_V30;
//ڵ(ӽṹ)  С704*576
typedef struct 
{
    DWORD dwEnableHideAlarm;                /* Ƿڵ ,0-,1- 2- 3-*/
    WORD wHideAlarmAreaTopLeftX;            /* ڵx */
    WORD wHideAlarmAreaTopLeftY;            /* ڵy */
    WORD wHideAlarmAreaWidth;                /* ڵĿ */
    WORD wHideAlarmAreaHeight;                /*ڵĸ*/
    NET_DVR_HANDLEEXCEPTION strHideAlarmHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];//ʱ
}NET_DVR_HIDEALARM, *LPNET_DVR_HIDEALARM;

//źŶʧ(ӽṹ)(9000չ)
typedef struct 
{
    BYTE byEnableHandleVILost;    /* ǷźŶʧ */
    NET_DVR_HANDLEEXCEPTION_V30 strVILostHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
}NET_DVR_VILOST_V30, *LPNET_DVR_VILOST_V30;

//źŶʧ(ӽṹ)
typedef struct 
{
    BYTE byEnableHandleVILost;    /* ǷźŶʧ */
    NET_DVR_HANDLEEXCEPTION strVILostHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];//ʱ
}NET_DVR_VILOST, *LPNET_DVR_VILOST;

//ڵ(ӽṹ)
typedef struct 
{
    WORD wHideAreaTopLeftX;                /* ڵx */
    WORD wHideAreaTopLeftY;                /* ڵy */
    WORD wHideAreaWidth;                /* ڵĿ */
    WORD wHideAreaHeight;                /*ڵĸ*/
}NET_DVR_SHELTER, *LPNET_DVR_SHELTER;

typedef struct
{
    BYTE byBrightness;      /*,0-255*/
    BYTE byContrast;        /*Աȶ,0-255*/    
    BYTE bySaturation;      /*Ͷ,0-255*/
    BYTE byHue;                /*ɫ,0-255*/
}NET_DVR_COLOR, *LPNET_DVR_COLOR;

typedef struct
{
    BYTE byRed;        //RGBɫеĺɫ
    BYTE byGreen;    //RGBɫеɫ
    BYTE byBlue;    //RGBɫеɫ
    BYTE byRes;        //
}NET_DVR_RGB_COLOR, *LPNET_DVR_RGB_COLOR;

//ֵһ,ֵΪǰİٷֱȴС, ΪСλ
//ṹ
typedef struct tagNET_VCA_POINT
{    
    float fX;                                // X, 0.001~1
    float fY;                                //Y, 0.001~1
}NET_VCA_POINT, *LPNET_VCA_POINT;

//ͨͼṹ(9000չ)
typedef struct
{
    DWORD dwSize;
    BYTE  sChanName[NAME_LEN];
    DWORD dwVideoFormat;    /* ֻ Ƶʽ 1-NTSC 2-PAL*/
    BYTE  byReservedData[64];/**/
    DWORD dwShowChanName; // ԤͼǷʾͨ,0-ʾ,1-ʾ С704*576
    WORD wShowNameTopLeftX;                /* ͨʾλõx */
    WORD wShowNameTopLeftY;                /* ͨʾλõy */
    //ƵźŶʧ
    NET_DVR_VILOST_V30 struVILost;
    NET_DVR_VILOST_V30 struRes;        /**/
    //    BYTE byRes1[328];
    //ƶ
    NET_DVR_MOTION_V30 struMotion;
    //ڵ
    NET_DVR_HIDEALARM_V30 struHideAlarm;
    //ڵ  С704*576
    DWORD dwEnableHide;        /* Ƿڵ ,0-,1-*/
    NET_DVR_SHELTER struShelter[MAX_SHELTERNUM];
    //OSD
    DWORD dwShowOsd;// ԤͼǷʾOSD,0-ʾ,1-ʾ С704*576
    WORD wOSDTopLeftX;                /* OSDx */
    WORD wOSDTopLeftY;                /* OSDy */
    BYTE byOSDType;                    /* OSD(Ҫոʽ) */
    /* 0: XXXX-XX-XX  */
    /* 1: XX-XX-XXXX  */
    /* 2: XXXXXXXX */
    /* 3: XXXXXXXX */
    /* 4: XX-XX-XXXX */
    /* 5: XXXXXXXX */
    /*6: xx/xx/xxxx(//) */
    /*7: xxxx/xx/xx(//) */
    /*8: xx/xx/xxxx(//)*/
    BYTE byDispWeek;                /* Ƿʾ */
    BYTE byOSDAttrib;                /* OSD:͸˸ */
    /* 1: ͸,˸ */
    /* 2: ͸,˸ */
    /* 3: ˸,͸ */
    /* 4: ͸,˸ */
    BYTE byHourOSDType;                /* OSDСʱ:0-24Сʱ,1-12Сʱ */
    BYTE byFontSize;//С16*16()/8*16(Ӣ)1-32*32()/16*32(Ӣ)2-64*64()/32*64(Ӣ)  3-48*48()/24*48(Ӣ) 4-24*24()/12*24(Ӣ) 5-96*96()/48*96(Ӣ) 6-128*128()/64*128(Ӣ) 0xff-Ӧ(adaptive)
    BYTE byOSDColorType;    //0-Ĭϣڰף1-Զ
    BYTE byAlignment;//뷽ʽ 0-Ӧ1-Ҷ, 2-
    BYTE byOSDMilliSecondEnable;//Ƶʱֺ֧룻0~, 1-
    NET_DVR_RGB_COLOR struOsdColor;//OSDɫ
    BYTE byRes[56];
}NET_DVR_PICCFG_V30, *LPNET_DVR_PICCFG_V30;

//ͨͼṹSDK_V14չ
typedef struct 
{
    DWORD dwSize;
    BYTE sChanName[NAME_LEN];
    DWORD dwVideoFormat;    /* ֻ Ƶʽ 1-NTSC 2-PAL*/
    BYTE byBrightness;      /*,0-255*/
    BYTE byContrast;        /*Աȶ,0-255*/    
    BYTE bySaturation;      /*Ͷ,0-255 */
    BYTE byHue;                /*ɫ,0-255*/
    //ʾͨ
    DWORD dwShowChanName; // ԤͼǷʾͨ,0-ʾ,1-ʾ С704*576
    WORD wShowNameTopLeftX;                /* ͨʾλõx */
    WORD wShowNameTopLeftY;                /* ͨʾλõy */
    //źŶʧ
    NET_DVR_VILOST struVILost;
    //ƶ
    NET_DVR_MOTION struMotion;
    //ڵ
    NET_DVR_HIDEALARM struHideAlarm;
    //ڵ  С704*576
    DWORD dwEnableHide;        /* Ƿڵ ,0-,1-*/
    NET_DVR_SHELTER struShelter[MAX_SHELTERNUM];
    //OSD
    DWORD dwShowOsd;// ԤͼǷʾOSD,0-ʾ,1-ʾ С704*576
    WORD wOSDTopLeftX;                /* OSDx */
    WORD wOSDTopLeftY;                /* OSDy */
    BYTE byOSDType;                    /* OSD(Ҫոʽ) */
    /* 0: XXXX-XX-XX  */
    /* 1: XX-XX-XXXX  */
    /* 2: XXXXXXXX */
    /* 3: XXXXXXXX */
    /* 4: XX-XX-XXXX */
    /* 5: XXXXXXXX */
    /*6: xx/xx/xxxx(//) */
    /*7: xxxx/xx/xx(//) */
    /*8: xx/xx/xxxx(//)*/
    BYTE byDispWeek;                /* Ƿʾ */
    BYTE byOSDAttrib;                /* OSD:͸˸ */
    /* 1: ͸,˸ */
    /* 2: ͸,˸ */
    /* 3: ˸,͸ */
    /* 4: ͸,˸ */
    BYTE byHourOsdType;        /* OSDСʱ:0-24Сʱ,1-12Сʱ */
}NET_DVR_PICCFG_EX, *LPNET_DVR_PICCFG_EX;

//ͨͼṹ(SDK_V13֮ǰ汾)
typedef struct 
{
    DWORD dwSize;
    BYTE sChanName[NAME_LEN];
    DWORD dwVideoFormat;    /* ֻ Ƶʽ 1-NTSC 2-PAL*/
    BYTE byBrightness;      /*,0-255*/
    BYTE byContrast;        /*Աȶ,0-255*/    
    BYTE bySaturation;      /*Ͷ,0-255 */
    BYTE byHue;                /*ɫ,0-255*/
    //ʾͨ
    DWORD dwShowChanName; // ԤͼǷʾͨ,0-ʾ,1-ʾ С704*576
    WORD wShowNameTopLeftX;                /* ͨʾλõx */
    WORD wShowNameTopLeftY;                /* ͨʾλõy */
    //źŶʧ
    NET_DVR_VILOST struVILost;
    //ƶ
    NET_DVR_MOTION struMotion;
    //ڵ
    NET_DVR_HIDEALARM struHideAlarm;
    //ڵ  С704*576
    DWORD dwEnableHide;        /* Ƿڵ ,0-,1-*/
    WORD wHideAreaTopLeftX;                /* ڵx */
    WORD wHideAreaTopLeftY;                /* ڵy */
    WORD wHideAreaWidth;                /* ڵĿ */
    WORD wHideAreaHeight;                /*ڵĸ*/
    //OSD
    DWORD dwShowOsd;// ԤͼǷʾOSD,0-ʾ,1-ʾ С704*576
    WORD wOSDTopLeftX;                /* OSDx */
    WORD wOSDTopLeftY;                /* OSDy */
    BYTE byOSDType;                    /* OSD(Ҫոʽ) */
    /* 0: XXXX-XX-XX  */
    /* 1: XX-XX-XXXX  */
    /* 2: XXXXXXXX */
    /* 3: XXXXXXXX */
    /* 4: XX-XX-XXXX */
    /* 5: XXXXXXXX */
    /*6: xx/xx/xxxx(//) */
    /*7: xxxx/xx/xx(//) */
    /*8: xx/xx/xxxx(//)*/
    BYTE byDispWeek;                /* Ƿʾ */
    BYTE byOSDAttrib;                /* OSD:͸˸ */
    /* 1: ͸,˸ */
    /* 2: ͸,˸ */
    /* 3: ˸,͸ */
    /* 4: ͸,˸ */
    char reservedData2;
}NET_DVR_PICCFG, *LPNET_DVR_PICCFG;

typedef enum _BITRATE_ENCODE_INDEX_
{
    BITRATE_ENCODE_def = 0,
        BITRATE_ENCODE_8kps = 1,
        BITRATE_ENCODE_16kps = 2,
        BITRATE_ENCODE_32kps = 3,
        BITRATE_ENCODE_64kps = 4,
        BITRATE_ENCODE_128kps = 5,
        BITRATE_ENCODE_192kps = 6,
        BITRATE_ENCODE_40kps = 7,
        BITRATE_ENCODE_48kps = 8,
        BITRATE_ENCODE_56kps = 9,
        BITRATE_ENCODE_80kps = 10,
        BITRATE_ENCODE_96kps = 11,
        BITRATE_ENCODE_112kps = 12,
        BITRATE_ENCODE_144kps = 13,
        BITRATE_ENCODE_160kps = 14
}BITRATE_ENCODE_INDEX;

//ѹ(ӽṹ)(9000չ)
typedef struct 
{
    BYTE byStreamType;        // 0-Ƶ, 1-, ʾ¼ѹʱλʾǷѹ
                            /*ֱ0-DCIF                      1-CIF,                     2-QCIF,                 3-4CIF,             
                            4-2CIF                      5,                 6-QVGA(320*240),        7-QQVGA(160*120),  
                            12-384*288                  13-576*576,                   
                            16-VGA640*480,          17-UXGA1600*1200,      18-SVGA(800*600),       19-HD720p(1280*720,   
                            20-XVGA,                    21-HD900p,                 22-1360*1024,           23-1536*1536,              
                            24-1920*1920,               27-HD1080i,                   
                            28-2560*1920,               29-1600*304,               30-2048*1536,           31-2448*2048,                
                            32-2448*1200,               33-2448*800,               34-XGA1024*768    35-SXGA1280*1024,         
                            36-WD1(960*576/960*480),    37-1080i,                  38-WSXGA(1440*900),     39-HD_F(1920*1080/1280*720),  
                            40-HD_H(1920*540/1280*360), 41-HD_Q(960*540/630*360),  42-2336*1744,           43-1920*1456,                 
                            44-2592*2048,               45-3296*2472,              46-1376*768,            47-1366*768,                 
                            48-1360*768,                49-WSXGA+,                 50-720*720,             51-1280*1280,                 
                            52-2048*768,                53-2048*2048,              54-2560*2048,           55-3072*2048,
                            56-2304*1296                57-WXGA(1280*800),         58-1600*600,               59-1600*900,
                            60-2752*2208,                61-,                   62-4000*3000,           63-4096*2160,
                            64-3840*2160,                65-4000*2250,              66-3072*1728,           67-2592*1944,
                            68-2464*1520,               69-1280*1920,              70-2560*1440,           71-1024*1024,
                            72-160*128,                 73-324*240,                74-324*256,             75-336*256,             
                            76-640*512,                 77-2720*2048,              78-384*256,             79-384*216, 
                            80-320*256,                 81-320*180,                82-320*192,             83-512*384,
                            84-325*256,                 85-256*192,                86-640*360,               87-1776x1340,
                            88-1936x1092,                89-2080x784,               90-2144x604,            91-1920*1200,
                            92-4064*3040,               93-3040*3040,              94-3072*2304,           95-3072*1152,
                            96-2560*2560,               97-2688*1536,              98-2688*1520,           99-3072*3072,
                            100-3392*2008,              101-4000*3080,             102-960*720,            103-1024*1536,
                            104-704*1056,               105-352*528,               106-2048*1530,          107-2560*1600,
                            108-2800*2100,              109-4088*4088,             110-4000*3072,           111-960*1080(1080p Lite)
                            112-640*720(half 720p),     113-640*960,               114-320*480,             115-3840*2400,
                            116-3840*1680,              117-2560*1120,             118-704*320,             119-1200*1920,
                            120-480*768,                121-768*480,               122-320*512,             123-512*320,
                            124-4096*1800,              125-1280*560,              126-2400*3840,          127-480*272,
                            128-512*272,                129-2592*2592,             130-1792*2880,          131-1600*2560,
                            132-2720*1192,              133-3MP(1920*1536/2048*1536)                     134-5MP(2560*1944)
                            132-2720*1192,
                            0xff-Auto(ʹõǰֱ)
    */
    BYTE byResolution;      
    BYTE byBitrateType;        // 0:, 1:,0xfe:ԶԴһ
    BYTE byPicQuality;        //ͼ 0- 1-κ 2-Ϻ 3-һ 4-ϲ 5-,ԶԴһ
                            /*Ƶ:0-1-16K()2-32K3-48k4-64K5-80K6-96K7-128K8-160k9-192K10-224K
                            11-256K12-320K13-384K14-448K15-512K16-640K17-768K18-896K19-1024K20-1280K21-1536K22-1792K23-2048K
    24-3072K25-4096K26-8192K27-16384Kλ(31λ)ó1ʾԶ030λʾֵСֵ16k,0xfffffffeԶԴһ*/
    DWORD dwVideoBitrate;      
    DWORD dwVideoFrameRate;    //֡ 0-ȫ; 1-1/16; 2-1/8; 3-1/4; 4-1/2; 5-1; 6-2; 7-4; 8-6; 9-8; 10-10; 11-12; 12-16; 13-20; V2.0汾¼14-15; 15-18; 16-22;
    //17-2518-3019-3520-4021-4522-5023-5524-6025-3;26-5;27-7;28-9;29-100; 30-120;31-24;32-48,0xfffffffe-ԶԴһ
    WORD  wIntervalFrameI;  //I֡,0xfffe ԶԴһ
    BYTE  byIntervalBPFrame;//0-BBP֡; 1-BP֡; 2-P֡(2006-08-11 ӵP֡ýӿڣԸʵʱʱ)0xfe-ԶԴһ
    BYTE  byres1;        //
    BYTE  byVideoEncType;   //Ƶ 0-˽2641-׼h2642-׼mpeg47-M-JPEG8-MPEG29-SVAC, 10-׼h265, 0xfe-ԶԴһ£0xff-Ч 
    BYTE  byAudioEncType;   //Ƶ 0-G722;1-G711_U;2-G711_A;5-MP2L2;6-G276;7-AAC;8-PCM;0xff-Ч
    BYTE  byVideoEncComplexity; //Ƶ븴Ӷȣ0-ͣ1-У2,0xfe:ԶԴһ
    BYTE  byEnableSvc; //0 - SVCܣ1- SVC; 2-ԶSVC
    BYTE  byFormatType; //װͣ1-2-RTPװ3-PSװ4-TSװ5-˽У6-FLV7-ASF8-3GP,9-RTP+PS꣺GB281810xff-Ч
    BYTE  byAudioBitRate; //Ƶ ο BITRATE_ENCODE_INDEX
    BYTE  byStreamSmooth;//ƽ 11001ȼʾ(Clear)100ʾƽ(Smooth)
    BYTE  byAudioSamplingRate;//Ƶ0-Ĭ,1- 16kHZ, 2-32kHZ, 3-48kHZ, 4- 44.1kHZ,5-8kHZ
    BYTE  bySmartCodec;//ܱ 0-رգ1-
    BYTE  byres;
    //ƽʣSmartCodecʹܿЧ, 0-0K 1-16K 2-32K 3-48k 4-64K 5-80K 6-96K 7-128K 8-160k 9-192K 10-224K 11-256K 12-320K 13-384K 14-448K 15-512K 16-640K 17-768K 18-896K 19-1024K 20-1280K 21-1536K 22-1792K 23-2048K 24-2560K 25-3072K 26-4096K 27-5120K 28-6144K 29-7168K 30-8192K
    //λ(15λ)ó1ʾԶ, 0-14λʾֵ(MIN- 0 K)
    WORD  wAverageVideoBitrate; 
}NET_DVR_COMPRESSION_INFO_V30, *LPNET_DVR_COMPRESSION_INFO_V30;

//ͨѹ(9000չ)
typedef struct
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_V30 struNormHighRecordPara;    //¼ Ӧ8000ͨ
    NET_DVR_COMPRESSION_INFO_V30 struRes;// char reserveData[28];
    NET_DVR_COMPRESSION_INFO_V30 struEventRecordPara;       //¼ѹ
    NET_DVR_COMPRESSION_INFO_V30 struNetPara;               //()
}NET_DVR_COMPRESSIONCFG_V30, *LPNET_DVR_COMPRESSIONCFG_V30;

//ѹ(ӽṹ)
typedef struct 
{
    BYTE byStreamType;        //0-Ƶ,1-,ʾѹʱλʾǷѹ
    BYTE byResolution;      //ֱ0-DCIF 1-CIF, 2-QCIF, 3-4CIF, 4-2CIF, 5-2QCIF(352X144)(ר)
    BYTE byBitrateType;        //0:ʣ1:
    BYTE  byPicQuality;        //ͼ 0- 1-κ 2-Ϻ 3-һ 4-ϲ 5-
    DWORD dwVideoBitrate;     //Ƶ 0- 1-16K() 2-32K 3-48k 4-64K 5-80K 6-96K 7-128K 8-160k 9-192K 10-224K 11-256K 12-320K
    // 13-384K 14-448K 15-512K 16-640K 17-768K 18-896K 19-1024K 20-1280K 21-1536K 22-1792K 23-2048K
    //λ(31λ)ó1ʾԶ, 0-30λʾֵ(MIN-32K MAX-8192K)
    DWORD dwVideoFrameRate;    //֡ 0-ȫ; 1-1/16; 2-1/8; 3-1/4; 4-1/2; 5-1; 6-2; 7-4; 8-6; 9-8; 10-10; 11-12; 12-16; 13-20;
}NET_DVR_COMPRESSION_INFO, *LPNET_DVR_COMPRESSION_INFO;

//ͨѹ
typedef struct 
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO struRecordPara; //¼/¼¼
    NET_DVR_COMPRESSION_INFO struNetPara;    ///
}NET_DVR_COMPRESSIONCFG, *LPNET_DVR_COMPRESSIONCFG;

//ѹ(ӽṹ)(չ) I֡
typedef struct 
{
    BYTE byStreamType;        //0-Ƶ, 1-
    BYTE byResolution;      //ֱ0-DCIF 1-CIF, 2-QCIF, 3-4CIF, 4-2CIF, 5-2QCIF(352X144)(ר)
    BYTE byBitrateType;        //0:ʣ1:
    BYTE  byPicQuality;        //ͼ 0- 1-κ 2-Ϻ 3-һ 4-ϲ 5-
    DWORD dwVideoBitrate;     //Ƶ 0- 1-16K() 2-32K 3-48k 4-64K 5-80K 6-96K 7-128K 8-160k 9-192K 10-224K 11-256K 12-320K
    // 13-384K 14-448K 15-512K 16-640K 17-768K 18-896K 19-1024K 20-1280K 21-1536K 22-1792K 23-2048K
    //λ(31λ)ó1ʾԶ, 0-30λʾֵ(MIN-32K MAX-8192K)
    DWORD dwVideoFrameRate;    //֡ 0-ȫ; 1-1/16; 2-1/8; 3-1/4; 4-1/2; 5-1; 6-2; 7-4; 8-6; 9-8; 10-10; 11-12; 12-16; 13-20, //V2.014-15, 15-18, 16-22;
    WORD  wIntervalFrameI;  //I֡
    //2006-08-11 ӵP֡ýӿڣԸʵʱʱ
    BYTE  byIntervalBPFrame;//0-BBP֡; 1-BP֡; 2-P֡
    BYTE  byRes;
}NET_DVR_COMPRESSION_INFO_EX, *LPNET_DVR_COMPRESSION_INFO_EX;

//ͨѹ(չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_EX struRecordPara; //¼
    NET_DVR_COMPRESSION_INFO_EX struNetPara;    //
}NET_DVR_COMPRESSIONCFG_EX, *LPNET_DVR_COMPRESSIONCFG_EX;


//ʱ¼(ӽṹ)
typedef struct 
{
    NET_DVR_SCHEDTIME struRecordTime;
    BYTE byRecordType;    //0:ʱ¼1:ƶ⣬2:¼3:|4:&, 5:, 6: ¼,10-PIR11-߱12-ȱ13-б,14-ܽͨ¼15Խ⣬16⣬17Ƶ쳣
    char reservedData[3];
}NET_DVR_RECORDSCHED, *LPNET_DVR_RECORDSCHED;

//ȫ¼(ӽṹ)
typedef struct 
{
    WORD wAllDayRecord;                /* Ƿȫ¼ 0- 1-*/
                                    BYTE byRecordType;                /* ¼ 0:ʱ¼1:ƶ⣬2:¼3:|4:& 5:, 6: ¼,
                                                                    10-PIR11-߱12-ȱ13-ƶ||PIR|߱|ȱ,14-ܽͨ¼,15-Խ,16-,17-쳣,
                                    18-,19-⣨Խ|||뿪|ʶ,20, 21-POS¼*/
                                    char reservedData;
}NET_DVR_RECORDDAY, *LPNET_DVR_RECORDDAY;

//ͨ¼(9000չ)
typedef struct 
{
    DWORD    dwSize;
    DWORD    dwRecord;                          /*Ƿ¼ 0- 1-*/
    NET_DVR_RECORDDAY    struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED    struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
    DWORD    dwRecordTime;                    /* ¼ʱ 0-5룬 1-10룬 2-30룬 3-1ӣ 4-2ӣ 5-5ӣ 6-10*/
    DWORD    dwPreRecordTime;                /* Ԥ¼ʱ 0-Ԥ¼ 1-5 2-10 3-15 4-20 5-25 6-30 7-0xffffffff(Ԥ¼) */
    DWORD    dwRecorderDuration;                /* ¼񱣴ʱ */
    BYTE    byRedundancyRec;    /*Ƿ¼,Ҫ˫ݣ0/1*/
    BYTE    byAudioRec;        /*¼ʱʱǷ¼Ƶݣд˷*/
    BYTE    byStreamType;  // 0-1-2-ͬʱ 3-
    BYTE    byPassbackRecord;  // 0:ش¼ 1ش¼
    WORD    wLockDuration;  // ¼ʱλСʱ 0ʾ0xffffʾ¼εʱĳʱ¼񣬽
    BYTE    byRecordBackup;  // 0:¼񲻴浵 1¼浵
    BYTE     bySVCLevel;    //SVC֡ͣ0-飬1-֮һ 2-ķ֮
    BYTE    byRecordManage;   //¼ȣ0-ã 1-; ʱжʱ¼񣻲ʱжʱ¼񣬵¼ƻʹãƶ⣬شڰ¼ƻ
    BYTE    byExtraSaveAudio;        //Ƶ0-ǵ棬1-
    BYTE    byReserve[2]; 
}NET_DVR_RECORD_V30, *LPNET_DVR_RECORD_V30;

//ʱ¼(ӽṹ)
typedef struct 
{
    NET_DVR_SCHEDTIME  struRecordTime;
    /*¼ͣ0:ʱ¼1:ƶ⣬2:¼3:|4:& 5:, 
    6-ܱ¼10-PIR11-߱12-ȱ13-ȫ¼,14-ܽͨ¼, 
    15-Խ,16-,17-쳣,18-,
    19-(Խ|||쳣|),20,21-POS¼,
    22-, 23-뿪,24-ǻ,25-Աۼ,26-˶,27-ͣ,
    28-Ʒ,29-Ʒȡ,30-⣬31-ƻ,32-ܶŹ¼(˾),33-¼(˾), 34-˯¼(˾)
    35-ֻ, 36-Ԥ37-±38-²*/    
    BYTE byRecordType; 
    BYTE byRes[31];
}NET_DVR_RECORDSCHED_V40, *LPNET_DVR_RECORDSCHED_V40;

//ȫ¼(ӽṹ)
typedef struct 
{
    BYTE byAllDayRecord; /* Ƿȫ¼ 0- 1-*/
                         /*¼ͣ0:ʱ¼1:ƶ⣬2:¼3:|4:& 5:, 
                         6-ܱ¼10-PIR11-߱12-ȱ13-ȫ¼,14-ܽͨ¼, 
                         15-Խ,16-,17-쳣,18-,
                         19-(Խ|||쳣|),20,21-POS¼,
                         22-, 23-뿪,24-ǻ,25-Աۼ,26-˶,27-ͣ,
                         28-Ʒ,29-Ʒȡ,30-⣬31-ƻ,32-ܶŹ¼(˾),33-¼(˾), 34-˯¼(˾)
                         35-ֻ, 36-Ԥ37-±38-²*/
    BYTE byRecordType; 
    BYTE byRes[62];
}NET_DVR_RECORDDAY_V40, *LPNET_DVR_RECORDDAY_V40;

typedef struct 
{
    DWORD    dwSize;
    DWORD    dwRecord;                          /*Ƿ¼ 0- 1-*/
    NET_DVR_RECORDDAY_V40    struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED_V40 struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
    DWORD    dwRecordTime;                    /* ¼ʱ 0-5룬 1-10룬 2-30룬 3-1ӣ 4-2ӣ 5-5ӣ 6-10*/
    DWORD    dwPreRecordTime;                /* Ԥ¼ʱ 0-Ԥ¼ 1-5 2-10 3-15 4-20 5-25 6-30 7-0xffffffff(Ԥ¼) */
    DWORD    dwRecorderDuration;                /* ¼񱣴ʱ */
    BYTE    byRedundancyRec;    /*Ƿ¼,Ҫ˫ݣ0/1*/
    BYTE    byAudioRec;        /*¼ʱʱǷ¼Ƶݣд˷*/
    BYTE    byStreamType;  // 0-1-2-ͬʱ 3-
    BYTE    byPassbackRecord;  // 0:ش¼ 1ش¼
    WORD    wLockDuration;  // ¼ʱλСʱ 0ʾ0xffffʾ¼εʱĳʱ¼񣬽
    BYTE    byRecordBackup;  // 0:¼񲻴浵 1¼浵
    BYTE     bySVCLevel;    //SVC֡ͣ0-飬1-֮һ 2-ķ֮
    BYTE    byRecordManage;   //¼ȣ0-ã 1-; ʱжʱ¼񣻲ʱжʱ¼񣬵¼ƻʹãƶ⣬شڰ¼ƻ
    BYTE    byExtraSaveAudio;//Ƶ洢
    BYTE    byRes[126]; 
}NET_DVR_RECORD_V40, *LPNET_DVR_RECORD_V40;

//ͨ¼
typedef struct 
{
    DWORD dwSize;
    DWORD dwRecord;  /*Ƿ¼ 0- 1-*/
    NET_DVR_RECORDDAY struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED struRecordSched[MAX_DAYS][MAX_TIMESEGMENT];
    DWORD dwRecordTime;    /* ¼ʱ䳤 */
    DWORD dwPreRecordTime;    /* Ԥ¼ʱ 0-Ԥ¼ 1-5 2-10 3-15 4-20 5-25 6-30 7-0xffffffff(Ԥ¼) */
}NET_DVR_RECORD, *LPNET_DVR_RECORD;

//̨Эṹ
typedef struct
{ 
    DWORD dwType;               /*ֵ*/    
    BYTE  byDescribe[DESC_LEN]; /*8000еһ*/    
}NET_DVR_PTZ_PROTOCOL;

typedef struct
{    
    DWORD   dwSize;    
    NET_DVR_PTZ_PROTOCOL struPtz[PTZ_PROTOCOL_NUM];/*200PTZЭ*/    
    DWORD   dwPtzNum;           /*ЧptzЭĿ0ʼ(ʱ1)*/
    BYTE    byRes[8];
}NET_DVR_PTZCFG, *LPNET_DVR_PTZCFG;

/***************************̨(end)******************************/
typedef struct tagNET_DVR_SERIALSTART_V40   //͸ͨ
{
    DWORD  dwSize;         //ṹС
    DWORD  dwSerialType;    //ںţ1-232ڣ2-485ڣ
    BYTE   bySerialNum;   //ڱ
    BYTE   byRes[255];
}NET_DVR_SERIALSTART_V40,*LPNET_DVR_SERIALSTART_V40;

//ͨ(̨) չ
typedef struct tagNET_DVR_DECODERCFG_V40
{
    DWORD    dwSize;       //ṹС
    DWORD     dwBaudRate;       // 0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k; 
    BYTE     byDataBit;       //мλ 05λ16λ27λ38λ;
    BYTE     byStopBit;       //ֹͣλ 01λ12λ
    BYTE     byParity;       //У 0У飬1У飬2żУ
    BYTE     byFlowcontrol;  //0ޣ1,2-Ӳ
    WORD     wDecoderType;    //*/
    WORD     wDecoderAddress;    //ַ0-255
    BYTE     bySetPreset [MAX_PRESET_V30];  //ԤõǷ,0-û,1-
    BYTE     bySetCruise[MAX_CRUISE_V30];  //ѲǷ: 0-û,1-
    BYTE     bySetTrack [MAX_TRACK_V30];    //켣Ƿ,0-û,1-
    BYTE     bySerialNO;          //ڱ
    BYTE     byWorkMode;        /*ģʽ 1-󴮿ڿƣ2-Ļƣ3-͸ͨģʽ 4-PPPģʽ 5-̨ģʽ 6-ֱ 7-̿ 8-ذ 9-̨*/
    BYTE     byRes[254];         //
}NET_DVR_DECODERCFG_V40,*LPNET_DVR_DECODERCFG_V40;

//ͨ(̨)(9000չ)
typedef struct 
{
    DWORD dwSize;
    DWORD dwBaudRate;//(bps)0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k;
    BYTE byDataBit;// мλ 05λ16λ27λ38λ;
    BYTE byStopBit;// ֹͣλ 01λ12λ;
    BYTE byParity;// У 0У飬1У飬2żУ;
    BYTE byFlowcontrol;// 0ޣ1,2-Ӳ
    WORD wDecoderType;//, 0ʼӦptzЭбNET_DVR_IPC_PROTO_LISTõ
    WORD wDecoderAddress;    /*ַ:0 - 255*/
    BYTE bySetPreset[MAX_PRESET_V30];        /* ԤõǷ,0-û,1-*/
    BYTE bySetCruise[MAX_CRUISE_V30];        /* ѲǷ: 0-û,1- */
    BYTE bySetTrack[MAX_TRACK_V30];            /* 켣Ƿ,0-û,1-*/
}NET_DVR_DECODERCFG_V30, *LPNET_DVR_DECODERCFG_V30;

//ͨ(̨)
typedef struct 
{
    DWORD dwSize;
    DWORD dwBaudRate;       //(bps)0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k;
    BYTE byDataBit;         // мλ 05λ16λ27λ38λ;
    BYTE byStopBit;         // ֹͣλ 01λ12λ;
    BYTE byParity;          // У 0У飬1У飬2żУ;
    BYTE byFlowcontrol;     // 0ޣ1,2-Ӳ
    WORD wDecoderType;      //  NET_DVR_IPC_PROTO_LISTеõ
    WORD wDecoderAddress;    /*ַ:0 - 255*/
    BYTE bySetPreset[MAX_PRESET];        /* ԤõǷ,0-û,1-*/
    BYTE bySetCruise[MAX_CRUISE];        /* ѲǷ: 0-û,1- */
    BYTE bySetTrack[MAX_TRACK];        /* 켣Ƿ,0-û,1-*/
}NET_DVR_DECODERCFG, *LPNET_DVR_DECODERCFG;

//ppp(ӽṹ)
typedef struct 
{
    NET_DVR_IPADDR struRemoteIP;    //ԶIPַ
    NET_DVR_IPADDR struLocalIP;        //IPַ
    char sLocalIPMask[16];            //IPַ
    BYTE sUsername[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    BYTE byPPPMode;                    //PPPģʽ, 01
    BYTE byRedial;                    //Ƿز 0-,1-
    BYTE byRedialMode;                //زģʽ,0-ɲָ,1-Ԥûز
    BYTE byDataEncrypt;                //ݼ,0-,1-
    DWORD dwMTU;                    //MTU
    char sTelephoneNumber[PHONENUMBER_LEN];   //绰
}NET_DVR_PPPCFG_V30, *LPNET_DVR_PPPCFG_V30;

//ppp(ӽṹ)
typedef struct 
{
    char sRemoteIP[16];                //ԶIPַ
    char sLocalIP[16];                //IPַ
    char sLocalIPMask[16];            //IPַ
    BYTE sUsername[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    BYTE byPPPMode;                    //PPPģʽ, 01
    BYTE byRedial;                    //Ƿز 0-,1-
    BYTE byRedialMode;                //زģʽ,0-ɲָ,1-Ԥûز
    BYTE byDataEncrypt;                //ݼ,0-,1-
    DWORD dwMTU;                    //MTU
    char sTelephoneNumber[PHONENUMBER_LEN];   //绰
}NET_DVR_PPPCFG, *LPNET_DVR_PPPCFG;

//RS232ڲ(9000չ)
typedef struct
{
    DWORD dwBaudRate;   /*(bps)0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k;*/
    BYTE byDataBit;     /* мλ 05λ16λ27λ38λ */
    BYTE byStopBit;     /* ֹͣλ 01λ12λ */
    BYTE byParity;      /* У 0У飬1У飬2żУ */
    BYTE byFlowcontrol; /* 0ޣ1,2-Ӳ */
    DWORD dwWorkMode;   //ģʽ0232PPPţ1232ڲƣ2͸ͨ 3- ptzģʽ,Ѷʪȴ, 4-ģʽ  5-󴮿ڿ 6-Ļ 7-ֱ 8-̿ 9-ذ 10-̨
}NET_DVR_SINGLE_RS232;

typedef struct tagNET_DVR_USB_RS232
{
    DWORD dwBaudRate;   /*(bps)0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k;*/
    BYTE byDataBit;     /* мλ 05λ16λ27λ38λ */
    BYTE byStopBit;     /* ֹͣλ 01λ12λ */
    BYTE byParity;      /* У 0У飬1У飬2żУ */
    BYTE byFlowcontrol; /* 0ޣ1,2-Ӳ */
    BYTE byVirtualSerialPort;  //⴮ڱ
    BYTE byRes[3];
}NET_DVR_USB_RS232,*LPNET_DVR_USB_RS232;

//RS232ڲ(9000չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_SINGLE_RS232 struRs232[MAX_SERIAL_PORT];/*ע⣺˽ṹ޸ˣԭǵṹ޸Ϊṹ*/
    NET_DVR_PPPCFG_V30 struPPPConfig;
}NET_DVR_RS232CFG_V30, *LPNET_DVR_RS232CFG_V30;

//RS232ڲ
typedef struct 
{
    DWORD dwSize;
    DWORD dwBaudRate;//(bps)0501752110315043005600612007240084800996001019200 11384001257600137680014115.2k;
    BYTE byDataBit;// мλ 05λ16λ27λ38λ;
    BYTE byStopBit;// ֹͣλ 01λ12λ;
    BYTE byParity;// У 0У飬1У飬2żУ;
    BYTE byFlowcontrol;// 0ޣ1,2-Ӳ
    DWORD dwWorkMode;// ģʽ0խ(232PPP)1̨(232ڲ)2͸ͨ
    NET_DVR_PPPCFG struPPPConfig;
}NET_DVR_RS232CFG, *LPNET_DVR_RS232CFG;


typedef struct 
{
    DWORD dwEnablePresetChan;    /*Ԥõͨ, 0xfffffffʾԤõ*/
    DWORD dwPresetPointNo;        /*ԤõͨӦԤõ, 0xfffffffʾԤõ㡣*/
}NET_DVR_PRESETCHAN_INFO, LPNET_DVR_PRESETCHAN_INFO;

typedef struct 
{
    DWORD dwEnableCruiseChan;    /*Ѳͨ*/
    DWORD dwCruiseNo;        /*ѲͨӦѲ, 0xfffffffʾЧ*/
}NET_DVR_CRUISECHAN_INFO, LPNET_DVR_CRUISECHAN_INFO;

typedef struct 
{
    DWORD dwEnablePtzTrackChan;    /*̨켣ͨ*/
    DWORD dwPtzTrackNo;        /*̨켣ͨӦı, 0xfffffffʾЧ*/
}NET_DVR_PTZTRACKCHAN_INFO, LPNET_DVR_PTZTRACKCHAN_INFO;


//(256·NVRչ)
typedef struct tagNET_DVR_ALARMINCFG_V40
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];    /*  */
    BYTE byAlarmType;                //,0,1
    BYTE byAlarmInHandle;            /* Ƿ 0- 1-*/
    BYTE byChannel;                 // 봥ʶͨ
    BYTE byRes1;                    //            
    DWORD   dwHandleType;        //쳣,쳣ʽ""   
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: */
    /*0x10: JPRGץͼϴEmail*/
    /*0x20: ⱨ*/
    /*0x40: ӵͼ(ĿǰֻPCNVR֧)*/
    /*0x200: ץͼϴFTP*/ 
    /*0x1000:ץͼϴ*/
    DWORD   dwMaxRelAlarmOutChanNum ; //ıֻ֧ͨ
    DWORD   dwRelAlarmOutChanNum; //ıͨ ʵ֧
    DWORD   dwRelAlarmOut[MAX_ALARMOUT_V40]; //ͨ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    /*¼ͨ*/
    DWORD   dwMaxRecordChanNum;   //豸ֵ֧¼ͨ-ֻ
    DWORD   dwCurRecordChanNum;    //ǰʵõĹ¼ͨ
    DWORD   dwRelRecordChan[MAX_CHANNUM_V40];     /* ʵʴ¼ֵͨʾ,ýУ±0 - dwCurRecordChanNum -1Чм0xffffffff,Ч*/ 
    DWORD   dwMaxEnablePtzCtrlNun; //ǫ̃(ֻ)
    DWORD   dwEnablePresetChanNum;  //ǰԤõĿ
    NET_DVR_PRESETCHAN_INFO struPresetChanInfo[MAX_CHANNUM_V40]; //õԤõϢ
    BYTE    byRes2[516];                    /**/
    DWORD   dwEnableCruiseChanNum;  //ǰѲͨĿ
    NET_DVR_CRUISECHAN_INFO struCruiseChanInfo[MAX_CHANNUM_V40]; //ѲͨϢ
    DWORD   dwEnablePtzTrackChanNum;  //ǰѲͨĿ
    NET_DVR_PTZTRACKCHAN_INFO struPtzTrackInfo[MAX_CHANNUM_V40]; //̨켣ͨϢ
    BYTE    byRes[256];
}NET_DVR_ALARMINCFG_V40, *LPNET_DVR_ALARMINCFG_V40;

//(9000չ)
typedef struct 
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];    /*  */
    BYTE byAlarmType;                //,0,1
    BYTE byAlarmInHandle;            /* Ƿ 0- 1-*/
    BYTE byChannel;                 // 봥ʶͨ
    BYTE byRes1;            
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    BYTE byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ
    BYTE byEnablePreset[MAX_CHANNUM_V30];        /* ǷԤõ 0-,1-*/
    BYTE byPresetNo[MAX_CHANNUM_V30];            /* ǫ̃Ԥõ,һԵǫ̈ͨԤõ, 0xffʾԤõ㡣*/
    BYTE byRes2[192];                    /**/
    BYTE byEnableCruise[MAX_CHANNUM_V30];        /* ǷѲ 0-,1-*/
    BYTE byCruiseNo[MAX_CHANNUM_V30];            /* Ѳ */
    BYTE byEnablePtzTrack[MAX_CHANNUM_V30];        /* Ƿù켣 0-,1-*/
    BYTE byPTZTrack[MAX_CHANNUM_V30];            /* ǫ̃Ĺ켣 */
    BYTE byRes3[16];
}NET_DVR_ALARMINCFG_V30, *LPNET_DVR_ALARMINCFG_V30;


typedef struct tagNET_DVR_ALARMINFO_FIXED_HEADER
{
    /*0-ź,1-Ӳ,2-źŶʧ3ƶ⣬4Ӳδʽ,5-дӲ̳,6-ڵ
    7-ʽƥ, 8-Ƿʣ9-Ƶź쳣10-¼쳣11-ܳ仯12-쳣13-ǰ/¼ֱʲƥ, 
    14-Դʧ,15-ⱨ, 16-ȱ쳣17-¼18-Խ󱨾*/
    DWORD dwAlarmType;//
    NET_DVR_TIME_EX struAlarmTime;    //ʱ
    union
    {
        BYTE    byUnionLen[128];
        struct
        {
            DWORD    dwAlarmInputNo;        //ıͨţһֻһ
            DWORD    dwTrigerAlarmOutNum;    /*ıں䳤ݲдıͨţֽڱʾһ*/
            DWORD    dwTrigerRecordChanNum;    /*¼ͨں䳤ݲд¼ͨţֽڱʾһ*/
        }struIOAlarm;    // dwAlarmTypeΪ0ʱЧ
        struct
        {
            DWORD    dwAlarmChanNum;    /*ͨݸں䳤ݲзıͨţֽڱʾһ*/
        }struAlarmChannel;    // dwAlarmTypeΪ23691013ʱЧ
        struct
        {
            DWORD    dwAlarmHardDiskNum;    /*Ӳݳȣں䳤ݲзӲ̺ţĽڱʾһ*/
        }struAlarmHardDisk;    // dwAlarmTypeΪ1,4,5ʱЧ
        struct
        {
            BYTE       bySubAlarmType;  //ͣ1-һӳ¼ 
            BYTE       byRes1[3]; //
            NET_DVR_TIME_EX  struRecordEndTime; //¼ʱ
            BYTE    byRes[116]; //
        }struRecordingHost;  //¼רñ
    }uStruAlarm;
}NET_DVR_ALRAM_FIXED_HEADER, *LPNET_DVR_ALARM_FIXED_HEADER;

//ϴϢ(256·NVRչ)
typedef struct NET_DVR_ALARMINFO_V40
{
    NET_DVR_ALRAM_FIXED_HEADER     struAlarmFixedHeader;    //̶
    DWORD*                        pAlarmData;    //ɱ䲿
}NET_DVR_ALARMINFO_V40, *LPNET_DVR_ALARMINFO_V40;

//
typedef struct 
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];    /*  */
    BYTE byAlarmType;    //,0,1
    BYTE byAlarmInHandle;    /* Ƿ 0- 1-*/
    BYTE byChannel;                 // 봥ʶͨ
    BYTE byRes;                     
    NET_DVR_HANDLEEXCEPTION struAlarmHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];//ʱ
    BYTE byRelRecordChan[MAX_CHANNUM]; //¼ͨ,Ϊ1ʾͨ
    BYTE byEnablePreset[MAX_CHANNUM];        /* ǷԤõ 0-,1-*/
    BYTE byPresetNo[MAX_CHANNUM];            /* ǫ̃Ԥõ,һԵǫ̈ͨԤõ, 0xffʾԤõ㡣*/
    BYTE byEnableCruise[MAX_CHANNUM];        /* ǷѲ 0-,1-*/
    BYTE byCruiseNo[MAX_CHANNUM];            /* Ѳ */
    BYTE byEnablePtzTrack[MAX_CHANNUM];        /* Ƿù켣 0-,1-*/
    BYTE byPTZTrack[MAX_CHANNUM];            /* ǫ̃Ĺ켣 */
}NET_DVR_ALARMINCFG, *LPNET_DVR_ALARMINCFG;

//ģⱨ
typedef struct
{
    DWORD     dwSize;
    BYTE        byEnableAlarmHandle; //
    BYTE        byRes1[3];
    BYTE        byAlarmInName[NAME_LEN]; //ģⱨ
    WORD        wAlarmInUpper; //ģѹޣʵֵ10Χ0~360
    WORD        wAlarmInLower; //ģѹޣʵֵ10Χ0~360 
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */ 
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    BYTE        byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ
    BYTE        byRes2[100];
}NET_DVR_ANALOG_ALARMINCFG, *LPNET_DVR_ANALOG_ALARMINCFG;

//ϴϢ(9000չ)
typedef struct 
{
    DWORD dwAlarmType;/*0-ź,1-Ӳ,2-źŶʧ,3ƶ,4Ӳδʽ,5-дӲ̳,6-ڵ,7-ʽƥ, 8-Ƿ, 9-Ƶź쳣,
                      10-¼쳣,11- ܳ仯,12-쳣,13-ǰ/¼ֱʲƥ,14-Դʧ,15-, 16-POE쳣,17-쳣,
    18-쳣,19-Ƶʧ*/
    DWORD dwAlarmInputNumber;/*˿*/
    BYTE byAlarmOutputNumber[MAX_ALARMOUT_V30];/*˿ڣΪ1ʾӦ*/
    BYTE byAlarmRelateChannel[MAX_CHANNUM_V30];/*¼ͨΪ1ʾӦ¼, dwAlarmRelateChannel[0]Ӧ1ͨ*/
    BYTE byChannel[MAX_CHANNUM_V30];/*dwAlarmTypeΪ23,6,9,10,14,19ʱʾĸͨdwChannel[0]Ӧ1ͨ*/
    BYTE byDiskNumber[MAX_DISKNUM_V30];/*dwAlarmTypeΪ1,4,5ʱ,ʾĸӲ, dwDiskNumber[0]Ӧ1Ӳ*/
    #ifdef SDK_CHEZAI
    NET_DVR_ADDIT_POSITION GPS_pos;  /* GPSλϢ */
    #endif
}NET_DVR_ALARMINFO_V30, *LPNET_DVR_ALARMINFO_V30;

typedef struct tagNET_DVR_ALARM_HOT_SPARE
{
    DWORD  dwSize;   //ṹ
    DWORD  dwExceptionCase;   //ԭ   0-쳣
    NET_DVR_IPADDR  struDeviceIP;    //쳣豸IPַ
    BYTE    byRes[256];         //
}NET_DVR_ALARM_HOT_SPARE, *LPNET_DVR_ALARM_HOT_SPARE;

typedef struct 
{
    DWORD dwAlarmType;/*0-ź,1-Ӳ,2-źŶʧ,3ƶ,4Ӳδʽ,5-дӲ̳,6-ڵ,7-ʽƥ, 8-Ƿ, 9-Ƶź쳣10-¼쳣 11- ܳ仯*/
    DWORD dwAlarmInputNumber;/*˿*/
    DWORD dwAlarmOutputNumber[MAX_ALARMOUT];/*˿ڣһλΪ1ʾӦһ*/
    DWORD dwAlarmRelateChannel[MAX_CHANNUM];/*¼ͨһλΪ1ʾӦһ·¼, dwAlarmRelateChannel[0]Ӧ1ͨ*/
    DWORD dwChannel[MAX_CHANNUM];/*dwAlarmTypeΪ23,6,9,10ʱʾĸͨdwChannel[0]λӦ1ͨ*/
    DWORD dwDiskNumber[MAX_DISKNUM];/*dwAlarmTypeΪ1,4,5ʱ,ʾĸӲ, dwDiskNumber[0]λӦ1Ӳ*/
}NET_DVR_ALARMINFO, *LPNET_DVR_ALARMINFO;

//////////////////////////////////////////////////////////////////////////////////////
//IPC
/* IP豸ṹ */
typedef struct 
{
    DWORD dwEnable;                    /* IP豸Ƿ */
    BYTE sUserName[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */ 
    NET_DVR_IPADDR struIP;            /* IPַ */
    WORD wDVRPort;                     /* ˿ں */
    BYTE byRes[34];                /*  */
}NET_DVR_IPDEVINFO, *LPNET_DVR_IPDEVINFO;

#define  DEV_ID_LEN           32    //豸ID

//ipc豸Ϣչ֧ip豸
typedef struct tagNET_DVR_IPDEVINFO_V31
{
    BYTE byEnable;                    //IP豸ǷЧ
    BYTE byProType;                    //Эͣ0-˽Э飬1-Э飬2-
    BYTE byEnableQuickAdd;        // 0 ֿ֧  1 ʹÿ 
    // Ҫ豸IPЭͣϢ豸Ĭָ
    BYTE byRes1;                    //ֶΣ0
    BYTE sUserName[NAME_LEN];        //û
    BYTE sPassword[PASSWD_LEN];        //
    BYTE byDomain[MAX_DOMAIN_NAME];    //豸
    NET_DVR_IPADDR struIP;            //IPַ
    WORD wDVRPort;                     // ˿ں
    BYTE  szDeviceID[DEV_ID_LEN];  //豸ID
    BYTE byRes2[2];                //ֶΣ0
}NET_DVR_IPDEVINFO_V31, *LPNET_DVR_IPDEVINFO_V31;

/* IPͨƥ */
typedef struct 
{
    BYTE byEnable;                    /* ͨǷ */
    BYTE byIPID;                    //IP豸ID8λ豸IDΪ0ʱʾͨ
    BYTE byChannel;                    /* ͨ */
    BYTE byIPIDHigh;                // IP豸IDĸ8λ
    BYTE byTransProtocol;            //Э0-TCP/auto(豸)1-UDP 2-ಥ 3-TCP 4-auto
    BYTE byres[31];                    /*  */
} NET_DVR_IPCHANINFO, *LPNET_DVR_IPCHANINFO;

/* IPýṹ */
typedef struct 
{
    DWORD dwSize;                                        /* ṹС */
    NET_DVR_IPDEVINFO  struIPDevInfo[MAX_IP_DEVICE];    /* IP豸 */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];        /* ģͨǷãӵ͵߱ʾ1-32ͨ0ʾЧ 1Ч */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];    /* IPͨ */    
}NET_DVR_IPPARACFG, *LPNET_DVR_IPPARACFG;
/* չIPýṹ */
typedef struct tagNET_DVR_IPPARACFG_V31
{
    DWORD dwSize;                                        /* ṹС */
    NET_DVR_IPDEVINFO_V31  struIPDevInfo[MAX_IP_DEVICE];    /* IP豸 */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];        /* ģͨǷãӵ͵߱ʾ1-32ͨ0ʾЧ 1Ч */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];    /* IPͨ */    
}NET_DVR_IPPARACFG_V31, *LPNET_DVR_IPPARACFG_V31;

typedef  struct tagNET_DVR_IPSERVER_STREAM
{
    BYTE    byEnable;   // Ƿ
    BYTE    byRes[3];               // ֽ
    NET_DVR_IPADDR struIPServer;    //IPServer ַ
    WORD    wPort;                  //IPServer ˿
    WORD    wDvrNameLen;            // DVR Ƴ
    BYTE    byDVRName[NAME_LEN];    // DVR
    WORD    wDVRSerialLen;          // кų
    WORD    byRes1[2];              // ֽ
    BYTE    byDVRSerialNumber[SERIALNO_LEN];    // DVRкų
    BYTE    byUserName[NAME_LEN];   // DVR ½û
    BYTE    byPassWord[PASSWD_LEN]; // DVR½
    BYTE    byChannel;              // DVR ͨ
    BYTE    byRes2[11];             //  ֽ
}NET_DVR_IPSERVER_STREAM, *LPNET_DVR_IPSERVER_STREAM;

//ý
typedef struct tagNET_DVR_STREAM_MEDIA_SERVER_CFG
{
    BYTE    byValid;            /*Ƿ*/
    BYTE    byRes1[3];
    NET_DVR_IPADDR  struDevIP;      
    WORD    wDevPort;            /*ý˿*/    
    BYTE    byTransmitType;        /*Э 0-TCP1-UDP*/
    BYTE    byRes2[69];
}NET_DVR_STREAM_MEDIA_SERVER_CFG,*LPNET_DVR_STREAM_MEDIA_SERVER_CFG;

//豸ͨϢ
typedef struct tagNET_DVR_DEV_CHAN_INFO
{
    NET_DVR_IPADDR     struIP;            //DVR IPַ
    WORD     wDVRPort;                 //˿ں
    BYTE     byChannel;                //ͨ
    BYTE    byTransProtocol;        //Э0-TCP1-UDP
    BYTE    byTransMode;            //ģʽ 0 1
    BYTE    byFactoryType;            /*ǰ豸,ͨӿڻȡ*/
    BYTE    byDeviceType; //豸(Ƶۺƽ̨ܰʹ)1-ʱƵۺƽ̨byVcaSupportChanModeֶʹýͨʾͨ2-
    BYTE    byDispChan;//ʾͨ,ʹ
    BYTE    bySubDispChan;//ʾͨͨţʱʹ
    BYTE    byResolution;    //; 1-CIF 2-4CIF 3-720P 4-1080P 5-500wʹãݸòԴ
    BYTE    byRes[2];
    BYTE    byDomain[MAX_DOMAIN_NAME];    //豸
    BYTE    sUserName[NAME_LEN];    //½ʺ
    BYTE    sPassword[PASSWD_LEN];    //
}NET_DVR_DEV_CHAN_INFO,*LPNET_DVR_DEV_CHAN_INFO;

//ֱͨýȡ
typedef struct tagNET_DVR_PU_STREAM_CFG
{
    DWORD                                dwSize;
    NET_DVR_STREAM_MEDIA_SERVER_CFG    struStreamMediaSvrCfg;
    NET_DVR_DEV_CHAN_INFO                struDevChanInfo;
}NET_DVR_PU_STREAM_CFG,*LPNET_DVR_PU_STREAM_CFG;

typedef struct tagNET_DVR_DDNS_STREAM_CFG
{
    BYTE   byEnable;   // Ƿ
    BYTE   byRes1[3];
    NET_DVR_IPADDR  struStreamServer;            //ýַ
    WORD   wStreamServerPort;           //ý˿   
    BYTE   byStreamServerTransmitType;  //ý崫Э 0-TCP1-UDP
    BYTE   byRes2;
    NET_DVR_IPADDR   struIPServer;          //IPSERVERַ
    WORD   wIPServerPort;        //IPserver˿ں
    BYTE   byRes3[2];           
    BYTE   sDVRName[NAME_LEN];   //DVR
    WORD   wDVRNameLen;            // DVRƳ
    WORD   wDVRSerialLen;          // кų
    BYTE   sDVRSerialNumber[SERIALNO_LEN];    // DVRк
    BYTE   sUserName[NAME_LEN];   // DVR ½û
    BYTE   sPassWord[PASSWD_LEN]; // DVR½
    WORD   wDVRPort;   //DVR˿ں
    BYTE   byRes4[2];    
    BYTE   byChannel;              // DVR ͨ
    BYTE   byTransProtocol; //Э0-TCP1-UDP
    BYTE   byTransMode; //ģʽ 0 1
    BYTE   byFactoryType; //ǰ豸,ͨӿڻȡ
}NET_DVR_DDNS_STREAM_CFG, *LPNET_DVR_DDNS_STREAM_CFG;

#define URL_LEN     240   //URL
typedef struct tagNET_DVR_PU_STREAM_URL
{
    BYTE    byEnable; 
    BYTE    strURL[URL_LEN];
    BYTE    byTransPortocol ; // Э 0-tcp  1-UDP
    WORD    wIPID;  //豸IDţwIPID = iDevInfoIndex + iGroupNO*64 +1
    BYTE    byChannel;  //ͨ
    BYTE    byRes[7];   
}NET_DVR_PU_STREAM_URL, *LPNET_DVR_PU_STREAM_URL;

typedef struct tagNET_DVR_HKDDNS_STREAM
{
    BYTE    byEnable;                 // Ƿ
    BYTE    byRes[3];               // ֽ
    BYTE    byDDNSDomain[64];        // hiDDNS
    WORD    wPort;                  // hiDDNS ˿
    WORD    wAliasLen;              // 
    BYTE    byAlias[NAME_LEN];         // 
    WORD    wDVRSerialLen;          // кų
    BYTE    byRes1[2];              // ֽ
    BYTE    byDVRSerialNumber[SERIALNO_LEN];    // DVRк
    BYTE    byUserName[NAME_LEN];   // DVR ½û
    BYTE    byPassWord[PASSWD_LEN]; // DVR½
    BYTE    byChannel;              // DVRͨ
    BYTE    byRes2[11];             //     
}NET_DVR_HKDDNS_STREAM, *LPNET_DVR_HKDDNS_STREAM;

typedef struct tagNET_DVR_IPCHANINFO_V40
{
    BYTE    byEnable;                /* ͨǷ */
    BYTE    byRes1;
    WORD    wIPID;                  //IP豸ID
    DWORD     dwChannel;                //ͨ
    BYTE    byTransProtocol;        //Э0-TCP1-UDP
    BYTE    byTransMode;            //ģʽ 0 1
    BYTE    byFactoryType;            /*ǰ豸,ͨӿڻȡ*/
    BYTE    byRes[241];
}NET_DVR_IPCHANINFO_V40,*LPNET_DVR_IPCHANINFO_V40;

// ŵCVR
#define MAX_ID_COUNT    256
#define MAX_STREAM_ID_COUNT    1024
#define STREAM_ID_LEN   32
#define PLAN_ID_LEN  32
#define DEVICE_NO_LEN  24
#define MAX_VOLUMENAME_LEN 32  //¼
#define MAX_VAG_CHANNO_LEN  32  //VAGЭȡʱͨű볤

#define MAX_STREAM_ID_NUM    30        //IDĿ

// Ϣ - 72ֽڳ
typedef struct tagNET_DVR_STREAM_INFO 
{
    DWORD dwSize;
    BYTE  byID[STREAM_ID_LEN];      //ID
    DWORD dwChannel;                //豸ͨ0xffffffffʱʾ
    BYTE  byRes[32];                //
}NET_DVR_STREAM_INFO, *LPNET_DVR_STREAM_INFO;

typedef struct tagNET_DVR_RTSP_PROTOCAL_CFG
{ 
    BYTE    byEnable;
    BYTE    byLocalBackUp; //Ƿ񱾵ر 
    BYTE    byRes[2]; 
    BYTE    strURL[URL_LEN_V40];
    DWORD   dwProtocalType;   //Э
    BYTE    sUserName[NAME_LEN];   //豸½û
    BYTE    sPassWord[PASSWD_LEN]; // 豸½
    BYTE    byAddress[MAX_DOMAIN_NAME];  //ǰIP,Ҫ豸
    //ʽΪĸ'.'Ϊ,ΪIPַ
    WORD    wPort;
    BYTE    byRes1[122];             //
}NET_DVR_RTSP_PROTOCAL_CFG, *LPNET_DVR_RTSP_PROTOCAL_CFG;

typedef union tagNET_DVR_GET_STREAM_UNION
{
    NET_DVR_IPCHANINFO      struChanInfo;    /*IPͨϢ*/
    NET_DVR_IPSERVER_STREAM struIPServerStream;  // IPServerȥ
    NET_DVR_PU_STREAM_CFG   struPUStream;     //  ͨǰ豸ȡýȥ
    NET_DVR_DDNS_STREAM_CFG struDDNSStream;     //ͨIPServerýȡ
    NET_DVR_PU_STREAM_URL   struStreamUrl;        //ͨý嵽urlȡ
    NET_DVR_HKDDNS_STREAM    struHkDDNSStream;   //ͨhiDDNSȥȡ
    NET_DVR_IPCHANINFO_V40 struIPChan; //ֱӴ豸ȡչ
}NET_DVR_GET_STREAM_UNION, *LPNET_DVR_GET_STREAM_UNION;

typedef enum
{
    NET_SDK_IP_DEVICE = 0,
        NET_SDK_STREAM_MEDIA,
        NET_SDK_IPSERVER,
        NET_SDK_DDNS_STREAM_CFG,
        NET_SDK_STREAM_MEDIA_URL,
        NET_SDK_HKDDNS,
        NET_SDK_IP_DEVICE_ADV,
        NET_SDK_IP_DEVICE_V40, 
        NET_SDK_RTSP  
}GET_STREAM_TYPE;

typedef struct tagNET_DVR_STREAM_MODE
{
    BYTE    byGetStreamType; //ȡʽGET_STREAM_TYPE0-ֱӴ豸ȡ1-ýȡ2-ͨIPServeripַȡ,3.ͨIPServerҵ豸ͨýȥ豸
    //4-ͨýURLȥȡ,5-ͨhkDDNSȡ6-ֱӴ豸ȡ(չ)ʹNET_DVR_IPCHANINFO_V40ṹ, 7-ͨRTSPЭ鷽ʽȡ
    BYTE    byRes[3];        //ֽ
    NET_DVR_GET_STREAM_UNION uGetStream;    // ͬȡʽṹ
}NET_DVR_STREAM_MODE, *LPNET_DVR_STREAM_MODE;

//չIP豸
typedef struct tagNET_DVR_IPPARACFG_V40
{
    DWORD      dwSize;                            /* ṹС */
    DWORD       dwGroupNum;                    //     豸ֵ֧    
    DWORD      dwAChanNum;                    //ģͨ
    DWORD      dwDChanNum;                  //ͨ
    DWORD      dwStartDChan;                    //ʼͨ
    BYTE       byAnalogChanEnable[MAX_CHANNUM_V30];    /* ģͨǷãӵ͵߱ʾ1-64ͨ0ʾЧ 1Ч */
    NET_DVR_IPDEVINFO_V31   struIPDevInfo[MAX_IP_DEVICE_V40];      /* IP豸 */
    NET_DVR_STREAM_MODE  struStreamMode[MAX_CHANNUM_V30];
    BYTE            byRes2[20];                 // ֽ
}NET_DVR_IPPARACFG_V40, *LPNET_DVR_IPPARACFG_V40;


//ΪCVRչı
typedef struct tagNET_DVR_ALARMINFO_DEV
{
    DWORD     dwAlarmType;  //0-(ͨ)ź1-˽о𻵣2- NVR˳
    //3-״̬쳣4-ϵͳʱ쳣5-¼ʣͣ
    //6-(ͨ)ƶⱨ7-(ͨ)ڵ8-¼ʧ; 9-Ƶʵʱⱨ; 10-Դʹʸ澯; 11- CVRԶ޸쳣 12-¼쳣
    NET_DVR_TIME   struTime;     //ʱ
    BYTE       byRes[32];    //
    DWORD      dwNumber;     //Ŀ
    WORD       *pNO;         //dwNumberWORD; ÿWORDʾһͨţߴ̺, ЧʱΪ0
}NET_DVR_ALARMINFO_DEV, *LPNET_DVR_ALARMINFO_DEV;

/*  */
typedef struct 
{
    BYTE byIPID;                    /* IP豸IDȡֵ1- MAX_IP_DEVICE */
    BYTE byAlarmOut;                /*  */
    BYTE byRes[18];                    /*  */
}NET_DVR_IPALARMOUTINFO, *LPNET_DVR_IPALARMOUTINFO;

/* IPýṹ */
typedef struct 
{
    DWORD dwSize;                                    /* ṹС */    
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT];/* IP */
}NET_DVR_IPALARMOUTCFG, *LPNET_DVR_IPALARMOUTCFG;

/* IP */
typedef struct tagNET_DVR_IPALARMOUTINFO_V40
{
    DWORD dwIPID;                    /* IP豸ID */
    DWORD dwAlarmOut;                /* IP豸IDӦı */
    BYTE  byRes[32];                /*  */
}NET_DVR_IPALARMOUTINFO_V40, *LPNET_DVR_IPALARMOUTINFO_V40;/**/

typedef struct tagNET_DVR_IPALARMOUTCFG_V40
{
    DWORD   dwSize;  //ṹ峤
    DWORD   dwCurIPAlarmOutNum;
    NET_DVR_IPALARMOUTINFO_V40 struIPAlarmOutInfo[MAX_IP_ALARMOUT_V40];/*IP*/
    BYTE     byRes[256];
}NET_DVR_IPALARMOUTCFG_V40, *LPNET_DVR_IPALARMOUTCFG_V40; /*IP*/

/*  */
typedef struct 
{
    BYTE byIPID;                    /* IP豸IDȡֵ1- MAX_IP_DEVICE */
    BYTE byAlarmIn;                    /*  */
    BYTE byRes[18];                    /*  */
}NET_DVR_IPALARMININFO, *LPNET_DVR_IPALARMININFO;

/* IPýṹ */
typedef struct 
{
    DWORD dwSize;                                    /* ṹС */    
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];/* IP */
}NET_DVR_IPALARMINCFG, *LPNET_DVR_IPALARMINCFG;

/* IP */
typedef struct tagNET_DVR_IPALARMININFO_V40
{
    DWORD dwIPID;                    /* IP豸ID */
    DWORD dwAlarmIn;                /* IP豸IDӦı */
    BYTE  byRes[32];                /*  */
}NET_DVR_IPALARMININFO_V40, *LPNET_DVR_IPALARMININFO_V40;   /*  */

typedef struct tagNET_DVR_IPALARMINCFG_V40
{
    DWORD   dwSize;  //ṹ峤
    DWORD   dwCurIPAlarmInNum;  //ǰ
    NET_DVR_IPALARMININFO_V40 struIPAlarmInInfo[MAX_IP_ALARMIN_V40];/* IP*/
    BYTE     byRes[256];
}NET_DVR_IPALARMINCFG_V40, *LPNET_DVR_IPALARMINCFG_V40; /*IPԴ*/

//ipc alarm info
typedef struct tagNET_DVR_IPALARMINFO
{
    NET_DVR_IPDEVINFO  struIPDevInfo[MAX_IP_DEVICE];            /* IP豸 */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];                /* ģͨǷã0-δ 1- */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];            /* IPͨ */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];    /* IP */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT]; /* IP */
}NET_DVR_IPALARMINFO, *LPNET_DVR_IPALARMINFO;

//ipcøı䱨Ϣչ 9000_1.1
typedef struct tagNET_DVR_IPALARMINFO_V31
{
    NET_DVR_IPDEVINFO_V31  struIPDevInfo[MAX_IP_DEVICE];            /* IP豸 */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];                /* ģͨǷã0-δ 1- */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];            /* IPͨ */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];    /* IP */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT]; /* IP */   
}NET_DVR_IPALARMINFO_V31, *LPNET_DVR_IPALARMINFO_V31;

typedef struct tagNET_DVR_IPALARMINFO_V40
{
    NET_DVR_IPDEVINFO_V31 struIPDevInfo[MAX_IP_DEVICE_V40];           // IP豸
    BYTE     byAnalogChanEnable[MAX_CHANNUM_V30];           /* ģͨǷã0-δ 1- */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_CHANNUM_V30];            /* IPͨ */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];    /* IP */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT]; /* IP */   
    BYTE                    byRes[20];                          // ֽ
}NET_DVR_IPALARMINFO_V40, *LPNET_DVR_IPALARMINFO_V40;

typedef enum _HD_STAT_
{
    HD_STAT_OK                    =    0,    /*  */
        HD_STAT_UNFORMATTED            =    1,    /* δʽ */
        HD_STAT_ERROR               =    2,    /*  */
        HD_STAT_SMART_FAILED        =    3,    /* SMART״̬ */
        HD_STAT_MISMATCH            =    4,    /* ƥ */
        HD_STAT_IDLE                =    5,    /* */
        NET_HD_STAT_OFFLINE         =    6,    /* ̴δ״̬ */
        HD_RIADVD_EXPAND            =   7,    /* ̿ */
        HD_STAT_REPARING            =   10,   /* Ӳ޸(9000 2.0) */
        HD_STAT_FORMATING           =   11,   /* Ӳڸʽ(9000 2.0) */ 
}HD_STAT;


//ӲϢ
typedef struct
{
    DWORD dwHDNo;         /*Ӳ̺, ȡֵ0~MAX_DISKNUM_V30-1*/
    DWORD dwCapacity;     /*Ӳ()*/
    DWORD dwFreeSpace;    /*Ӳʣռ()*/
    DWORD dwHdStatus;     //Ӳ״̬() HD_STAT 0-, 1-δʽ, 2-, 3-SMART״̬, 
    //4-ƥ, 5- 6-Ӳ̲ 7-̿ 10-Ӳ޸
    //11-Ӳڸʽ 12-Ӳڵȴʽ 13-Ӳж 14-Ӳ̲
    //15-ɾ(Ӳ),16-
    BYTE  byHDAttr;       /*0-ͨ, 1-; 2-ֻ 3-浵CVRרã4-ɶд*/
    BYTE  byHDType;          /*0-Ӳ,1-ESATAӲ,2-NASӲ,3-iSCSIӲ 4-Array,5-SD*/
    BYTE  byDiskDriver;   // ֵ ASCIIַ 
    BYTE  byRes1;
    DWORD dwHdGroup;      /*ĸ 1-MAX_HD_GROUP*/
    BYTE  byRecycling;   // Ƿѭ 0ѭã1ѭ
    BYTE  byRes2[3];
    DWORD  dwStorageType;    //λʾ 0-֧ 0-֧
    // dwStorageType & 0x1 ʾǷͨ¼רô洢     
    // dwStorageType & 0x2  ʾǷǳ֡¼רô洢
    // dwStorageType & 0x4 ʾǷͼƬ¼רô洢
    
    DWORD dwPictureCapacity; //ӲͼƬ()λ:MB
    DWORD dwFreePictureSpace; //ʣͼƬռ()λ:MB
    BYTE  byRes3[104];
}NET_DVR_SINGLE_HD, *LPNET_DVR_SINGLE_HD;

typedef struct
{
    DWORD dwSize;
    DWORD dwHDCount;          /*Ӳ()*/
    NET_DVR_SINGLE_HD struHDInfo[MAX_DISKNUM_V30];//ӲزҪЧ
}NET_DVR_HDCFG, *LPNET_DVR_HDCFG;

//Ϣչ
typedef struct tagNET_DVR_SINGLE_HDGROUP_V40
{
    DWORD     dwHDGroupNo;       /*() 1-MAX_HD_GROUP*/        
    DWORD      dwRelRecordChan[MAX_CHANNUM_V40];  //¼ֵͨʾ0xffffffffʱΪЧ     
    BYTE       byRes[64];                /*  */
}NET_DVR_SINGLE_HDGROUP_V40, *LPNET_DVR_SINGLE_HDGROUP_V40;

typedef struct tagNET_DVR_HDGROUP_CFG_V40
{
    DWORD      dwSize;                //ṹС
    DWORD     dwMaxHDGroupNum;           //豸ֵ֧-ֻ
    DWORD     dwCurHDGroupNum;       /*ǰõ*/
    NET_DVR_SINGLE_HDGROUP_V40 struHDGroupAttr[MAX_HD_GROUP]; //ӲزҪЧ
    BYTE       byRes[128]; //
}NET_DVR_HDGROUP_CFG_V40, *LPNET_DVR_HDGROUP_CFG_V40;

//Ϣ
typedef struct
{
    DWORD dwHDGroupNo;       /*() 1-MAX_HD_GROUP*/        
    BYTE byHDGroupChans[MAX_CHANNUM_V30]; /*Ӧ¼ͨ, 0-ʾͨ¼󵽸飬1-ʾ¼󵽸*/
    BYTE byRes[8];
}NET_DVR_SINGLE_HDGROUP, *LPNET_DVR_SINGLE_HDGROUP;

typedef struct
{
    DWORD dwSize;
    DWORD dwHDGroupCount;        /*()*/
    NET_DVR_SINGLE_HDGROUP struHDGroupAttr[MAX_HD_GROUP];//ӲزҪЧ
}NET_DVR_HDGROUP_CFG, *LPNET_DVR_HDGROUP_CFG;


//ŲĽṹ
typedef struct
{
    DWORD dwSize;
    DWORD dwMajorScale;    /* ʾ 0-ţ1-*/
    DWORD dwMinorScale;    /* ʾ 0-ţ1-*/
    DWORD dwRes[2];
}NET_DVR_SCALECFG, *LPNET_DVR_SCALECFG;



//DVR(9000չ)
typedef struct 
{
    DWORD dwSize;
    BYTE sAlarmOutName[NAME_LEN];    /*  */
    DWORD dwAlarmOutDelay;    /* ʱ(-1Ϊޣֶر) */
    //0-5,1-10,2-30,3-1,4-2,5-5,6-10,7-ֶ
    NET_DVR_SCHEDTIME struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT_V30];/* ʱ */
    BYTE byRes[16];
}NET_DVR_ALARMOUTCFG_V30, *LPNET_DVR_ALARMOUTCFG_V30;

//DVR
typedef struct 
{
    DWORD dwSize;
    BYTE sAlarmOutName[NAME_LEN];    /*  */
    DWORD dwAlarmOutDelay;    /* ʱ(-1Ϊޣֶر) */
    //0-5,1-10,2-30,3-1,4-2,5-5,6-10,7-ֶ, 8-1, 9-3
    NET_DVR_SCHEDTIME struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT];/* ʱ */
}NET_DVR_ALARMOUTCFG, *LPNET_DVR_ALARMOUTCFG;

//DVRԤ(9000չ)
/*лָڵǰԤģʽлʾ棬лԤģʽbyPreviewNumberΪ01棩bySwitchSeq[0][0] = 1,bySwitchSeq[0][1] = 2,bySwitchSeq[0][2] = 3 
򱾵ػһֱ1棬Ȼ水1,2,3ͨ˳л*/
typedef struct 
{
    DWORD dwSize;
    BYTE byPreviewNumber;//Ԥģʽ,0-1,1-4,2-9,3-16,0xff:
    BYTE byEnableAudio;//ǷԤ,0-Ԥ,1-Ԥ
    WORD wSwitchTime;//лʱ,0-л,1-5s,2-10s,3-20s,4-30s,5-60s,6-120s,7-300s
    BYTE bySwitchSeq[MAX_PREVIEW_MODE][MAX_WINDOW_V30];//л˳,lSwitchSeq[i]Ϊ 0xffʾ
    BYTE byRes[24];
}NET_DVR_PREVIEWCFG_V30, *LPNET_DVR_PREVIEWCFG_V30;

//DVRԤ
typedef struct 
{
    DWORD dwSize;
    BYTE byPreviewNumber;//ԤĿ,0-1,1-4,2-9,3-16,0xff:
    BYTE byEnableAudio;//ǷԤ,0-Ԥ,1-Ԥ
    WORD wSwitchTime;//лʱ,0-л,1-5s,2-10s,3-20s,4-30s,5-60s,6-120s,7-300s
    BYTE bySwitchSeq[MAX_WINDOW];//л˳,lSwitchSeq[i]Ϊ 0xffʾ
}NET_DVR_PREVIEWCFG, *LPNET_DVR_PREVIEWCFG;

//DVRƵ
typedef struct 
{
    WORD wResolution;                            /* ֱ */
    WORD wFreq;                                    /* ˢƵ */
    DWORD dwBrightness;                            /*  */
}NET_DVR_VGAPARA;

/*
* MATRIXṹ
*/
typedef struct
{        
    WORD    wOrder[MAX_ANALOG_CHANNUM];        /* Ԥ˳, 0xffʾӦĴڲԤ */
    WORD    wSwitchTime;                /* Ԥлʱ */
    BYTE    res[14];
}NET_DVR_MATRIXPARA_V30, *LPNET_DVR_MATRIXPARA_V30;

typedef struct 
{
    WORD wDisplayLogo;                        /* ʾƵͨ */
    WORD wDisplayOsd;                        /* ʾʱ */
}NET_DVR_MATRIXPARA;

typedef struct 
{
    BYTE byVideoFormat;                        /* ʽ,0-PAL,1-NTSC */
    BYTE byMenuAlphaValue;                    /* ˵뱳ͼԱȶ */
    WORD wScreenSaveTime;                    /* Ļʱ 0-Ӳ,1-1,2-2,3-5,4-10,5-20,6-30 */
    WORD wVOffset;                            /* Ƶƫ */
    WORD wBrightness;                        /* Ƶ */
    BYTE byStartMode;                        /* Ƶģʽ(0:˵,1:Ԥ)*/
    BYTE byEnableScaler;                    /* Ƿ (0-, 1-)*/
}NET_DVR_VOOUT;

//DVRƵ(9000չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_VOOUT struVOOut[MAX_VIDEOOUT_V30];
    NET_DVR_VGAPARA struVGAPara[MAX_VGA_V30];    /* VGA */
    NET_DVR_MATRIXPARA_V30 struMatrixPara[MAX_MATRIXOUT];        /* MATRIX */
    BYTE byRes[16];
}NET_DVR_VIDEOOUT_V30, *LPNET_DVR_VIDEOOUT_V30;

//DVRƵ
typedef struct 
{
    DWORD dwSize;
    NET_DVR_VOOUT struVOOut[MAX_VIDEOOUT];
    NET_DVR_VGAPARA struVGAPara[MAX_VGA];    /* VGA */
    NET_DVR_MATRIXPARA struMatrixPara;        /* MATRIX */
}NET_DVR_VIDEOOUT, *LPNET_DVR_VIDEOOUT;


//û(ӽṹ)(չ)
typedef struct tagNET_DVR_USER_INFO_V40
{
    BYTE    sUserName[NAME_LEN];            /* ûֻ16ֽ */
    BYTE    sPassword[PASSWD_LEN];            /*  */
    BYTE    byLocalRight[MAX_RIGHT];    /* Ȩ */
    /*0: ؿ̨*/
    /*1: ֶ¼*/
    /*2: ػط*/
    /*3: ò*/
    /*4: ز鿴״̬־*/
    /*5: ظ߼(ʽػ)*/
    /*6: ز鿴 */
    /*7: عģIP camera */
    /*8: ر */
    /*9: عػ/ */    
    BYTE    byRemoteRight[MAX_RIGHT];/* ԶȨ */    
    /*0: Զ̨̿*/
    /*1: Զֶ¼*/
    /*2: Զ̻ط */
    /*3: Զò*/
    /*4: Զ̲鿴״̬־*/
    /*5: Զ̸߼(ʽػ)*/
    /*6: Զ̷Խ*/
    /*7: ԶԤ*/
    /*8: Զ󱨾ϴ*/
    /*9: Զ̿ƣ*/
    /*10: Զ̿ƴ*/    
    /*11: Զ̲鿴 */
    /*12: Զ̹ģIP camera */
    /*13: Զ̹ػ/ */    
    DWORD    dwNetPreviewRight[MAX_CHANNUM_V40];            /* Զ̿Ԥͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwLocalRecordRight[MAX_CHANNUM_V40];            /* ؿ¼ͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwNetRecordRight[MAX_CHANNUM_V40];            /* Զ̿¼ͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwLocalPlaybackRight[MAX_CHANNUM_V40];            /* ؿԻطŵͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwNetPlaybackRight[MAX_CHANNUM_V40];            /* Զ̿Իطŵͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwLocalPTZRight[MAX_CHANNUM_V40];                /* ؿPTZͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwNetPTZRight[MAX_CHANNUM_V40];                /* Զ̿PTZͨǰ˳У0xffffffffΪЧ*/
    DWORD    dwLocalBackupRight[MAX_CHANNUM_V40];            /* رȨͨǰ˳У0xffffffffΪЧ*/
    NET_DVR_IPADDR    struUserIP;                /* ûIPַ(Ϊ0ʱʾκεַ) */
    BYTE     byMACAddr[MACADDR_LEN];    /* ַ */
    BYTE     byPriority;                /* ȼ0xff-ޣ0--ͣ1--У2-- */
                                        /* ޡʾ֧ȼ
                                        ͡ĬȨ:غԶ̻ط,غԶ̲鿴־
                                        ״̬,غԶ̹ػ/
                                        СغԶ̨̿,غԶֶ¼,غ
                                        Զ̻ط,ԽԶԤر,/Զ̹ػ/
    ߡԱ */
    BYTE    byAlarmOnRight;         // ڲȨ 1-Ȩޣ0-Ȩ
    BYTE    byAlarmOffRight;         // ڳȨ 1-Ȩޣ0-Ȩ
    BYTE    byBypassRight;           // ·Ȩ 1-Ȩޣ0-Ȩ 
    BYTE    byRes1[2];               //ֽڶ
    BYTE    byPublishRight[MAX_RIGHT];  //ϢרȨ
    /*0: زȨ*/
    /*1: ĿȨ*/
    /*2: ճȨ*/
    /*3: ϴزȨ*/
    /*4: ½ĿȨ*/
    /*5: ½ճȨ*/
    /*6: ϢȨ*/
    /*7: ն˹Ȩ*/
    /*8: ҵȨ*/    
    BYTE    byRes[84];    
}NET_DVR_USER_INFO_V40, *LPNET_DVR_USER_INFO_V40;


//û(ӽṹ)(9000չ)
typedef struct
{
    BYTE sUserName[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    BYTE byLocalRight[MAX_RIGHT];    /* Ȩ */
    /*0: ؿ̨*/
    /*1: ֶ¼*/
    /*2: ػط*/
    /*3: ò*/
    /*4: ز鿴״̬־*/
    /*5: ظ߼(ʽػ)*/
    /*6: ز鿴 */
    /*7: عģIP camera */
    /*8: ر */
    /*9: عػ/ */    
    BYTE byRemoteRight[MAX_RIGHT];/* ԶȨ */    
    /*0: Զ̨̿*/
    /*1: Զֶ¼*/
    /*2: Զ̻ط */
    /*3: Զò*/
    /*4: Զ̲鿴״̬־*/
    /*5: Զ̸߼(ʽػ)*/
    /*6: Զ̷Խ*/
    /*7: ԶԤ*/
    /*8: Զ󱨾ϴ*/
    /*9: Զ̿ƣ*/
    /*10: Զ̿ƴ*/    
    /*11: Զ̲鿴 */
    /*12: Զ̹ģIP camera */
    /*13: Զ̹ػ/ */
    BYTE byNetPreviewRight[MAX_CHANNUM_V30];        /* Զ̿Ԥͨ 0-Ȩޣ1-Ȩ*/
    BYTE byLocalPlaybackRight[MAX_CHANNUM_V30];    /* ؿԻطŵͨ 0-Ȩޣ1-Ȩ*/
    BYTE byNetPlaybackRight[MAX_CHANNUM_V30];    /* Զ̿Իطŵͨ 0-Ȩޣ1-Ȩ*/
    BYTE byLocalRecordRight[MAX_CHANNUM_V30];        /* ؿ¼ͨ 0-Ȩޣ1-Ȩ*/
    BYTE byNetRecordRight[MAX_CHANNUM_V30];        /* Զ̿¼ͨ 0-Ȩޣ1-Ȩ*/
    BYTE byLocalPTZRight[MAX_CHANNUM_V30];        /* ؿPTZͨ 0-Ȩޣ1-Ȩ*/
    BYTE byNetPTZRight[MAX_CHANNUM_V30];            /* Զ̿PTZͨ 0-Ȩޣ1-Ȩ*/
    BYTE byLocalBackupRight[MAX_CHANNUM_V30];        /* رȨͨ 0-Ȩޣ1-Ȩ*/
    NET_DVR_IPADDR struUserIP;        /* ûIPַ(Ϊ0ʱʾκεַ) */
    BYTE byMACAddr[MACADDR_LEN];    /* ַ */
    BYTE byPriority;                /* ȼ0xff-ޣ0--ͣ1--У2-- */
                                    /*
                                    ޡʾ֧ȼ
                                    ͡ĬȨ:غԶ̻ط,غԶ̲鿴־״̬,غԶ̹ػ/
                                    СغԶ̨̿,غԶֶ¼,غԶ̻ط,ԽԶԤ
                                    ر,/Զ̹ػ/
                                    ߡԱ
    */
    BYTE    byAlarmOnRight;         // ڲȨ
    BYTE    byAlarmOffRight;        // ڳȨ
    BYTE    byBypassRight;          // ·Ȩ
    BYTE    byRes[14];    
}NET_DVR_USER_INFO_V30, *LPNET_DVR_USER_INFO_V30;

//û(SDK_V15չ)(ӽṹ)
typedef struct 
{
    BYTE sUserName[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    DWORD dwLocalRight[MAX_RIGHT];    /* Ȩ */
    /*0: ؿ̨*/
    /*1: ֶ¼*/
    /*2: ػط*/
    /*3: ò*/
    /*4: ز鿴״̬־*/
    /*5: ظ߼(ʽػ)*/
    DWORD dwLocalPlaybackRight;        /* ؿԻطŵͨ bit0 -- channel 1*/
    DWORD dwRemoteRight[MAX_RIGHT];    /* Ȩ */
    /*0: Զ̨̿*/
    /*1: Զֶ¼*/
    /*2: Զ̻ط */
    /*3: Զò*/
    /*4: Զ̲鿴״̬־*/
    /*5: Զ̸߼(ʽػ)*/
    /*6: Զ̷Խ*/
    /*7: ԶԤ*/
    /*8: Զ󱨾ϴ*/
    /*9: Զ̿ƣ*/
    /*10: Զ̿ƴ*/
    DWORD dwNetPreviewRight;        /* Զ̿Ԥͨ bit0 -- channel 1*/
    DWORD dwNetPlaybackRight;        /* Զ̿Իطŵͨ bit0 -- channel 1*/
    char sUserIP[16];                /* ûIPַ(Ϊ0ʱʾκεַ) */
    BYTE byMACAddr[MACADDR_LEN];    /* ַ */
}NET_DVR_USER_INFO_EX, *LPNET_DVR_USER_INFO_EX;

//û(ӽṹ)
typedef struct 
{
    BYTE sUserName[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    DWORD dwLocalRight[MAX_RIGHT];    /* Ȩ */
    /*0: ؿ̨*/
    /*1: ֶ¼*/
    /*2: ػط*/
    /*3: ò*/
    /*4: ز鿴״̬־*/
    /*5: ظ߼(ʽػ)*/
    DWORD dwRemoteRight[MAX_RIGHT];    /* Ȩ */
    /*0: Զ̨̿*/
    /*1: Զֶ¼*/
    /*2: Զ̻ط */
    /*3: Զò*/
    /*4: Զ̲鿴״̬־*/
    /*5: Զ̸߼(ʽػ)*/
    /*6: Զ̷Խ*/
    /*7: ԶԤ*/
    /*8: Զ󱨾ϴ*/
    /*9: Զ̿ƣ*/
    /*10: Զ̿ƴ*/
    char sUserIP[16];                /* ûIPַ(Ϊ0ʱʾκεַ) */
    BYTE byMACAddr[MACADDR_LEN];    /* ַ */
}NET_DVR_USER_INFO, *LPNET_DVR_USER_INFO;

//DVRû(չ)
typedef struct  tagNET_DVR_USER_V40
{
    DWORD dwSize;  //ṹС
    DWORD dwMaxUserNum; //豸ֵ֧û-ֻ
    NET_DVR_USER_INFO_V40 struUser[MAX_USERNUM_V30];  /* û */
}NET_DVR_USER_V40,*LPNET_DVR_USER_V40;

//DVRû(9000չ)
typedef struct
{
    DWORD dwSize;
    NET_DVR_USER_INFO_V30 struUser[MAX_USERNUM_V30];
}NET_DVR_USER_V30, *LPNET_DVR_USER_V30;

//DVRû(SDK_V15չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_USER_INFO_EX struUser[MAX_USERNUM];
}NET_DVR_USER_EX, *LPNET_DVR_USER_EX;

//DVRû
typedef struct 
{
    DWORD dwSize;
    NET_DVR_USER_INFO struUser[MAX_USERNUM];
}NET_DVR_USER, *LPNET_DVR_USER;

typedef struct tagNET_DVR_EXCEPTION_V40
{
    DWORD             dwSize ;             //ṹС
    DWORD             dwMaxGroupNum ;    //豸ֵ֧
    NET_DVR_HANDLEEXCEPTION_V41 struExceptionHandle[MAX_EXCEPTIONNUM_V30];    
    BYTE                byRes[128];          //
}NET_DVR_EXCEPTION_V40,*LPNET_DVR_EXCEPTION_V40; /*쳣չṹ*/

//DVR쳣(9000չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_HANDLEEXCEPTION_V30 struExceptionHandleType[MAX_EXCEPTIONNUM_V30];
    /*0-,1- Ӳ̳,2-߶,3-IP ַͻ, 4-Ƿ, 5-/Ƶʽƥ, 6-Ƶź쳣, 7-¼쳣 8-쳣9-ǰ/¼ֱʲƥ쳣10-г(ר) 11-ȱ쳣N+1ʹã12-¶ȣ13-ϵͳ쳣14-쳣, 15-POE쳣*/
}NET_DVR_EXCEPTION_V30, *LPNET_DVR_EXCEPTION_V30;



//DVR쳣
typedef struct 
{
    DWORD dwSize;
    NET_DVR_HANDLEEXCEPTION struExceptionHandleType[MAX_EXCEPTIONNUM];
    /*0-,1- Ӳ̳,2-߶,3-IP ַͻ,4-Ƿ, 5-/Ƶʽƥ, 6-Ƶź쳣*/
}NET_DVR_EXCEPTION, *LPNET_DVR_EXCEPTION;

//ͨ״̬(9000չ)
typedef struct 
{
    BYTE byRecordStatic; //ͨǷ¼,0-¼,1-¼
    BYTE bySignalStatic; //ӵź״̬,0-,1-źŶʧ
    BYTE byHardwareStatic;//ͨӲ״̬,0-,1-쳣,DSP
    BYTE byRes1;        //
    DWORD dwBitRate;//ʵ
    DWORD dwLinkNum;//ͻӵĸ
    NET_DVR_IPADDR struClientIP[MAX_LINK];//ͻ˵IPַ
    DWORD dwIPLinkNum;//ͨΪIP룬ôʾIP뵱ǰ
    BYTE byExceedMaxLink;        // Ƿ񳬳˵·6· 0 - δ, 1-
    BYTE byRes[3];        // ֽ
    DWORD dwAllBitRate;      //ʵ֮
    DWORD dwChannelNo;    //ǰͨţ0xffffffffʾЧ
}NET_DVR_CHANNELSTATE_V30, *LPNET_DVR_CHANNELSTATE_V30;

//ͨ״̬
typedef struct 
{
    BYTE byRecordStatic; //ͨǷ¼,0-¼,1-¼
    BYTE bySignalStatic; //ӵź״̬,0-,1-źŶʧ
    BYTE byHardwareStatic;//ͨӲ״̬,0-,1-쳣,DSP
    char reservedData;        //
    DWORD dwBitRate;//ʵ
    DWORD dwLinkNum;//ͻӵĸ
    DWORD dwClientIP[MAX_LINK];//ͻ˵IPַ
}NET_DVR_CHANNELSTATE, *LPNET_DVR_CHANNELSTATE;

//Ӳ״̬
typedef struct 
{
    DWORD dwVolume;//Ӳ̵
    DWORD dwFreeSpace;//Ӳ̵ʣռ
    DWORD dwHardDiskStatic; //Ӳ̵״̬,λ:1-,2-,3-Ӳ̳,4-δʽ, 5-δ״̬(Ӳ),6-Ӳڸʽ
}NET_DVR_DISKSTATE, *LPNET_DVR_DISKSTATE;

typedef struct tagNET_DVR_WORKSTATE_V40
{ 
    DWORD   dwSize ;            //ṹС
    DWORD   dwDeviceStatic;      //豸״̬,0-,1-CPUռ̫,85%,2-Ӳ,紮
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM_V30];   //Ӳ״̬,һֻܻȡ33ӲϢ
    NET_DVR_CHANNELSTATE_V30 struChanStatic[MAX_CHANNUM_V40/*512*/];//ͨ״̬ǰ˳
    DWORD   dwHasAlarmInStatic[MAX_ALARMIN_V40/*512*/]; //бıڣֵʾ±ֵ˳УֵΪ0xffffffffʱǰֵЧ
    DWORD   dwHasAlarmOutStatic[MAX_ALARMOUT_V40/*512*/]; //бıڣֵʾ±ֵ˳УֵΪ0xffffffffʱǰֵЧ
    DWORD   dwLocalDisplay;            //ʾ״̬,0-,1-
    BYTE    byAudioInChanStatus[MAX_AUDIO_V30/*2*/];        //λʾͨ״̬ 0-δʹã1-ʹУ0λʾ1ͨ
    BYTE    byRes1[2];
    float    fHumidity;    //֪ʪ,Χ:0.0 ~100.0
    float    fTemperature;    //֪¶ȣΧ-20.0 ~ 90.0
    BYTE    byRes[116];                 //
}NET_DVR_WORKSTATE_V40, *LPNET_DVR_WORKSTATE_V40; /*豸״̬չṹ*/

typedef struct tagNET_DVR_GETWORKSTATE_COND
{
    DWORD   dwSize ;  //ṹ峤
    BYTE    byFindHardByCond; /*0-ȫ(һֻܲ33)ʱdwFindHardStatusNumЧ*/
    BYTE    byFindChanByCond ;  /*0-ȫͨʱdwFindChanNumЧ*/
    BYTE    byRes1[2] ;//    
    DWORD   dwFindHardStatus[MAX_DISKNUM_V30/*33*/] ; /*ҪҵӲ̺ţֵʾֵ˳У 0xffffffffΪЧ */
    DWORD   dwFindChanNo[MAX_CHANNUM_V40/*512*/] ; /*Ҫҵͨţֵʾֵ˳У 0xffffffffΪЧ */
    BYTE     byRes[64] ; //
}NET_DVR_GETWORKSTATE_COND, *LPNET_DVR_GETWORKSTATE_COND;

//DVR״̬(9000չ)
typedef struct 
{
    DWORD dwDeviceStatic;     //豸״̬,0-,1-CPUռ̫,85%,2-Ӳ,紮
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM_V30];
    NET_DVR_CHANNELSTATE_V30 struChanStatic[MAX_CHANNUM_V30];//ͨ״̬
    BYTE  byAlarmInStatic[MAX_ALARMIN_V30]; //˿ڵ״̬,0-ûб,1-б
    BYTE  byAlarmOutStatic[MAX_ALARMOUT_V30]; //˿ڵ״̬,0-û,1-б
    DWORD  dwLocalDisplay;//ʾ״̬,0-,1-
    BYTE  byAudioChanStatus[MAX_AUDIO_V30];//ʾͨ״̬ 0-δʹã1-ʹ, 0xffЧ
    BYTE  byRes[10];
}NET_DVR_WORKSTATE_V30, *LPNET_DVR_WORKSTATE_V30;

//DVR״̬
typedef struct 
{
    DWORD dwDeviceStatic;     //豸״̬,0-,1-CPUռ̫,85%,2-Ӳ,紮
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM];
    NET_DVR_CHANNELSTATE struChanStatic[MAX_CHANNUM];//ͨ״̬
    BYTE  byAlarmInStatic[MAX_ALARMIN]; //˿ڵ״̬,0-ûб,1-б
    BYTE  byAlarmOutStatic[MAX_ALARMOUT]; //˿ڵ״̬,0-û,1-б
    DWORD  dwLocalDisplay;//ʾ״̬,0-,1-
}NET_DVR_WORKSTATE, *LPNET_DVR_WORKSTATE;



//־Ϣ(9000չ)
typedef struct 
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;    // 1-; 2-쳣; 3-; 0xff-ȫ
    DWORD    dwMinorType;// 0-ȫ;
    BYTE    sPanelUser[MAX_NAMELEN]; //û
    BYTE    sNetUser[MAX_NAMELEN];//û
    NET_DVR_IPADDR    struRemoteHostAddr;//Զַ
    DWORD    dwParaType;//,9000豸MINOR_START_VT/MINOR_STOP_VTʱʾԽĶӺ
    DWORD    dwChannel;//ͨ
    DWORD    dwDiskNumber;//Ӳ̺
    DWORD    dwAlarmInPort;//˿
    DWORD    dwAlarmOutPort;//˿
    DWORD   dwInfoLen;
    char    sInfo[LOG_INFO_LEN];
}NET_DVR_LOG_V30, *LPNET_DVR_LOG_V30;

//־Ϣ
typedef struct 
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;    // 1-; 2-쳣; 3-; 0xff-ȫ
    DWORD    dwMinorType;// 0-ȫ;
    BYTE    sPanelUser[MAX_NAMELEN]; //û
    BYTE    sNetUser[MAX_NAMELEN];//û
    char    sRemoteHostAddr[16];//Զַ
    DWORD    dwParaType;//
    DWORD    dwChannel;//ͨ
    DWORD    dwDiskNumber;//Ӳ̺
    DWORD    dwAlarmInPort;//˿
    DWORD    dwAlarmOutPort;//˿
}NET_DVR_LOG, *LPNET_DVR_LOG;

/************************DVR־ end***************************/

/************************־ begin************************************************/
typedef struct tagNET_DVR_ALARMHOST_SEARCH_LOG_PARAM
{
    WORD            wMajorType;        // 
    WORD            wMinorType;        //  
    NET_DVR_TIME    struStartTime;    // ʼʱ 
    NET_DVR_TIME    struEndTime;    // ʱ
    BYTE            byRes[8];        // ֽ
}NET_DVR_ALARMHOST_SEARCH_LOG_PARAM, LPNET_DVR_ALARMHOST_SEARCH_LOG_PARAM;

typedef struct tagNET_DVR_ALARMHOST_LOG_RET
{
    NET_DVR_TIME    struLogTime;                //  ־ʱ
    BYTE            sUserName[NAME_LEN];     // û
    NET_DVR_IPADDR    struIPAddr;                 // IPַ
    WORD            wMajorType;                 //  
    WORD            wMinorType;                 // 
    WORD            wParam;                        // 
    BYTE            byRes[10];
    DWORD            dwInfoLen;                    // Ϣ
    char            sInfo[LOG_INFO_LEN];       // Ϣ
}NET_DVR_ALARMHOST_LOG_RET, *LPNET_DVR_ALARMHOST_LOG_RET;

/*************************־ end***********************************************/

//״̬(9000չ)
typedef struct 
{
    BYTE Output[MAX_ALARMOUT_V30];
}NET_DVR_ALARMOUTSTATUS_V30, *LPNET_DVR_ALARMOUTSTATUS_V30;

//״̬
typedef struct 
{
    BYTE Output[MAX_ALARMOUT];
}NET_DVR_ALARMOUTSTATUS, *LPNET_DVR_ALARMOUTSTATUS;

//Ϣ
typedef struct 
{
    USHORT m_Year;
    USHORT m_Month;
    USHORT m_Day;
    USHORT m_Hour;
    USHORT m_Minute;
    USHORT m_Second;
    BYTE DeviceName[24];    //豸
    DWORD dwChannelNumer;    //ͨ
    BYTE CardNumber[32];    //
    char cTradeType[12];    //
    DWORD dwCash;            //׽
}NET_DVR_TRADEINFO, *LPNET_DVR_TRADEINFO;


//ATMר
/****************************ATM(begin)***************************/
#define NCR        0
#define DIEBOLD    1
#define WINCOR_NIXDORF    2
#define SIEMENS    3
#define OLIVETTI    4
#define FUJITSU    5
#define HITACHI    6
#define SMI        7
#define IBM        8
#define BULL    9
#define YiHua    10
#define LiDe    11
#define GDYT    12
#define Mini_Banl    13
#define GuangLi    14
#define DongXin    15
#define ChenTong    16
#define NanTian    17
#define XiaoXing    18
#define GZYY    19
#define QHTLT    20
#define DRS918    21
#define KALATEL    22
#define NCR_2    23    
#define NXS        24


/*֡ʽ*/
typedef struct 
{
    BYTE code[12];        /*  */
}NET_DVR_FRAMETYPECODE;


//ATM
typedef struct 
{
    DWORD dwSize;
    char sATMIP[16];                        /* ATM IPַ */
    DWORD dwATMType;                        /* ATM */
    DWORD dwInputMode;                        /* 뷽ʽ    0- 1- 2-ֱ 3-ATM*/
    DWORD dwFrameSignBeginPos;              /* ı־λʼλ*/
    DWORD dwFrameSignLength;                /* ı־λĳ */
    BYTE  byFrameSignContent[12];            /* ı־λ */
    DWORD dwCardLengthInfoBeginPos;            /* ųϢʼλ */
    DWORD dwCardLengthInfoLength;            /* ųϢĳ */
    DWORD dwCardNumberInfoBeginPos;            /* Ϣʼλ */
    DWORD dwCardNumberInfoLength;            /* Ϣĳ */
    DWORD dwBusinessTypeBeginPos;           /* ͵ʼλ */
    DWORD dwBusinessTypeLength;                /* ͵ĳ */
    NET_DVR_FRAMETYPECODE frameTypeCode[10];/*  */
}NET_DVR_FRAMEFORMAT, *LPNET_DVR_FRAMEFORMAT;
//SDK_V31 ATM

/**/
typedef struct    tagNET_DVR_FILTER
{    
    BYTE                    byEnable;            //0,;1,
    BYTE                    byMode;                //0,ASCII;1,HEX    
    BYTE                    byFrameBeginPos;    // ҪĿַʼλ     
    BYTE                    byRes;           // ֽ
    BYTE                     byFilterText[16];    //ַ
    BYTE                    byRes2[12];         // ֽ
}NET_DVR_FILTER, *LPNET_DVR_FILTER;

//ݰ ݰʶ
typedef struct    tagNET_DVR_IDENTIFICAT
{    
    BYTE                    byStartMode;        //ʼַģʽ:0,ASCII;1,HEX
    BYTE                    byEndMode;            //ַģʽ0,ASCII;1,HEX
    BYTE                    byRes[2];           //ֽ
    NET_DVR_FRAMETYPECODE    struStartCode;        //ݰʼʶַ
    NET_DVR_FRAMETYPECODE    struEndCode;        //ݰʶַ
    BYTE                    byRes1[12];         //ֽ
}NET_DVR_IDENTIFICAT, *LPNET_DVR_IDENTIFICAT;

typedef struct    tagNET_DVR_PACKAGE_LOCATION/*Ϣλ*/
{    
    BYTE                     byOffsetMode;            /*λϢģʽ 0,token(ַ־ģʽ);1,fix̶ģʽ*/
    BYTE                    byRes1[3];                // ֽ
    DWORD                      dwOffsetPos;            /*modeΪ1ʱʹ,̶ƫƴС*/
    NET_DVR_FRAMETYPECODE    struTokenCode;            /*־λ*/
    BYTE                    byMultiplierValue;        /*־λٴγ*/
    BYTE                    byEternOffset;            /*ַƫ*/
    BYTE                    byCodeMode;                /*0,ASCII;1,HEX*/
    BYTE                     byRes2[9];                //ֽ
}NET_DVR_PACKAGE_LOCATION, *LPNET_DVR_PACKAGE_LOCATION;


typedef struct    tagNET_DVR_PACKAGE_LENGTH//Ϣ
{    
    BYTE                    byLengthMode;            //ͣ0,ɱ䳤;1,̶;2,(ӿлȡ)
    BYTE                    byRes1[3];              // ֽ
    DWORD                      dwFixLength;                //modeΪ1ʱʹ,̶ȴС
    DWORD                    dwMaxLength;            //Ϣ󳤶  byLengthModeΪ0ʱʹ
    DWORD                    dwMinLength;            //ϢС  byLengthModeΪ0ʱʹ
    BYTE                    byEndMode;                //ɱ䳤 սģʽ 0,ASCII;1,HEX    
    BYTE                    byRes2[3];              //ֽ
    NET_DVR_FRAMETYPECODE    struEndCode;        //ɱ䳤ս
    DWORD                    dwLengthPos;            //lengthModeΪ2ʱʹãųڱеλ
    DWORD                    dwLengthLen;            //lengthModeΪ2ʱʹãųȵĳ
    BYTE                    byRes3[8];              // ֽ
}NET_DVR_PACKAGE_LENGTH,* LPNET_DVR_PACKAGE_LENGTH;

typedef struct    tagNET_DVR_OSD_POSITION//OSD ӵλ
{    
    BYTE                    byPositionMode;        //ӷ񣬹2֣0ʾ1Զ
    BYTE                    byRes1[3];          // ֽ
    DWORD                     dwPosX;                //x꣬ӷΪԶʱʹ
    DWORD                    dwPosY;                //y꣬ӷΪԶʱʹ
    BYTE                    byRes2[8];          //ֽ
}NET_DVR_OSD_POSITION, *LPNET_DVR_OSD_POSITION;

typedef struct    tagNET_DVR_DATE_FORMAT//ʾʽ
{    
    BYTE                    byMonth;                //Month,0.mm;1.mmm;2.mmmm                            
    BYTE                     byDay;                    //Day,0.dd;                                    
    BYTE                     byYear;                    //Year,0.yy;1.yyyy    
    BYTE                    byDateForm;                //0~5յ
    BYTE                    byRes[20];              // ֽ
    char                    chSeprator[4];            //ָ
    char                    chDisplaySeprator[4];    //ʾָ
    BYTE                    byDisplayForm;            //0~53item
    BYTE                    res[27];                // ֽ
}NET_DVR_DATE_FORMAT, *LPNET_DVR_DATE_FORMAT;
typedef struct    tagNET_DVRT_TIME_FORMAT//ʱʾʽ
{    
    BYTE                    byTimeForm;                //1. HH MM SS;0. HH MM
    BYTE                     byRes1[23];             // ֽ
    BYTE                    byHourMode;             //0,12;1,24 
    BYTE                    byRes2[3];              // ֽ
    char                    chSeprator[4];             //ķָʱû
    char                    chDisplaySeprator[4];    //ʾָ
    BYTE                    byDisplayForm;            //0~53item
    BYTE                    byRes3[3];              // ֽ
    BYTE                    byDisplayHourMode;        //0,12;1,24 
    BYTE                    byRes4[19];             // ֽ
}NET_DVR_TIME_FORMAT, *LPNET_DVR_TIME_FORMAT;

typedef struct tagNET_DVR_OVERLAY_CHANNEL
{    
    BYTE                    byChannel[64];//ӵͨ ÿֽڱʶһͨ byChannel[0]ֵΪ1Ӧͨ10ʾͨ1
    DWORD                    dwDelayTime;            //ʱʱ
    BYTE                    byEnableDelayTime;        //Ƿõʱ
    BYTE                    byRes[11];          // ֽ
}NET_DVR_OVERLAY_CHANNEL, *LPNET_DVR_OVERLAY_CHANNEL;

// ATM ΪϢ
typedef struct tagNET_DVR_ATM_PACKAGE_ACTION
{    
    NET_DVR_PACKAGE_LOCATION    struPackageLocation;// λϢ
    NET_DVR_OSD_POSITION        struOsdPosition;    // OSD λ
    NET_DVR_FRAMETYPECODE        struActionCode;        //Ϊ
    NET_DVR_FRAMETYPECODE        struPreCode;        //ַǰַ
    BYTE                    byActionCodeMode;        //Ϊģʽ0,ASCII;1,HEX
    BYTE                    byRes[7];               // ֽ
}NET_DVR_ATM_PACKAGE_ACTION, *LPNET_DVR_ATM_PACKAGE_ACTION;

// ATM DATAϢ
typedef struct tagNET_DVR_ATM_PACKAGE_DATE
{    
    NET_DVR_PACKAGE_LOCATION    struPackageLocation;// ڱеλϢ
    NET_DVR_DATE_FORMAT            struDateForm;        //ʾʽ
    NET_DVR_OSD_POSITION        struOsdPosition;    // OSDλϢ
    BYTE                        res[8];             // ֽ
}NET_DVR_ATM_PACKAGE_DATE, *LPNET_DVR_ATM_PACKAGE_DATE;


//ATMʱϢ
typedef struct tagNET_DVR_ATM_PACKAGE_TIME
{    
    NET_DVR_PACKAGE_LOCATION    location;        // ʱڱеλϢ
    NET_DVR_TIME_FORMAT            struTimeForm;    // ʱʾʽ
    NET_DVR_OSD_POSITION        struOsdPosition;// OSD λϢ
    BYTE                        byRes[8];        // ֽ
}NET_DVR_ATM_PACKAGE_TIME, *LPNET_DVR_ATM_PACKAGE_TIME;


// ATM Ϣţ׽ţ
typedef struct tagNET_DVR_ATM_PACKAGE_OTHERS
{    
    NET_DVR_PACKAGE_LOCATION    struPackageLocation; //λϢ
    NET_DVR_PACKAGE_LENGTH    struPackageLength;        //Ϣ
    NET_DVR_OSD_POSITION        struOsdPosition;    // OSDλϢ
    NET_DVR_FRAMETYPECODE        struPreCode;        //ַǰַ
    BYTE                    res[8];                    //ֽ
}NET_DVR_ATM_PACKAGE_OTHERS, *LPNET_DVR_ATM_PACKAGE_OTHERS;


//ûԶЭ
typedef struct tagNET_DVR_ATM_USER_DEFINE_PROTOCOL
{
    NET_DVR_IDENTIFICAT        struIdentification;  //ı־
    NET_DVR_FILTER             struFilter; //ݰ
    NET_DVR_ATM_PACKAGE_OTHERS struCardNoPara; //ӿ
    NET_DVR_ATM_PACKAGE_ACTION struTradeActionPara[MAX_ACTION_TYPE]; //ӽΪ 0-9 ζӦInCard OutCard OverLay SetTime GetStatus Query WithDraw Deposit ChanPass Transfer
    NET_DVR_ATM_PACKAGE_OTHERS struAmountPara; //ӽ׽
    NET_DVR_ATM_PACKAGE_OTHERS struSerialNoPara; //ӽ
    NET_DVR_OVERLAY_CHANNEL    struOverlayChan; //ͨ
    NET_DVR_ATM_PACKAGE_DATE   struRes1; //ڣ
    NET_DVR_ATM_PACKAGE_TIME   struRes2; //ʱ䣬
    BYTE                       byRes3[124];        //
}NET_DVR_ATM_USER_DEFINE_PROTOCOL, *LPNET_DVR_ATM_USER_DEFINE_PROTOCOL;

typedef struct tagNET_DVR_ATM_FRAMEFORMAT_V30
{        
    DWORD                        dwSize;                 //ṹС
    BYTE                        byEnable;                /*Ƿ0,;1,*/
    BYTE                        byInputMode;            /**뷽ʽ:0-1Э顢2-ڼ3-Э*/
    BYTE                        byRes1[34];              //ֽ 
    NET_DVR_IPADDR                struAtmIp;                /*ATM IP ʱʹ */
    WORD                        wAtmPort;                /* Э鷽ʽʱʹ*/
    BYTE                        byRes2[2];              // ֽ
    DWORD                        dwAtmType;                /*ATMЭͣNET_DVR_ATM_PROTOCOLṹлȡΪԶʱʹûԶЭ*/
    NET_DVR_ATM_USER_DEFINE_PROTOCOL   struAtmUserDefineProtocol; //ûԶЭ飬ATMΪԶʱҪʹøö
    BYTE                        byRes3[8];
}NET_DVR_ATM_FRAMEFORMAT_V30, *LPNET_DVR_ATM_FRAMEFORMAT_V30;


typedef struct  tagNET_DVR_ATM_PROTO_TYPE
{
    DWORD dwAtmType; //ATMЭͣͬʱΪ ATM еdwAtmType ԶʱΪ1025
    char chDesc[ATM_DESC_LEN]; //ATMЭ
}NET_DVR_ATM_PROTO_TYPE, *LPNET_DVR_ATM_PROTO_TYPE; //ЭϢݽṹ

typedef struct tagNET_DVR_ATM_PROTO_LIST    //ATM Эб
{
    DWORD                  dwAtmProtoNum;           // Эбĸ
    NET_DVR_ATM_PROTO_TYPE struAtmProtoType[MAX_ATM_PROTOCOL_NUM]; //ЭбϢ
}NET_DVR_ATM_PROTO_LIST, *LPNET_DVR_ATM_PROTO_LIST;

typedef struct tagNET_DVR_ATM_PROTOCOL
{
    DWORD dwSize;
    NET_DVR_ATM_PROTO_LIST struNetListenList; // Э
    NET_DVR_ATM_PROTO_LIST struSerialListenList; //ڼЭ
    NET_DVR_ATM_PROTO_LIST struNetProtoList;     //Э
    NET_DVR_ATM_PROTO_LIST struSerialProtoList;   //Э
    NET_DVR_ATM_PROTO_TYPE struCustomProto;        //ԶЭ
}NET_DVR_ATM_PROTOCOL, *LPNET_DVR_ATM_PROTOCOL;
// SDK_V31

/*****************************DS-6001D/F(begin)***************************/
//DS-6001D Decoder
typedef struct 
{
    BYTE byEncoderIP[16];        //豸ӵķIP
    BYTE byEncoderUser[16];        //豸ӵķû
    BYTE byEncoderPasswd[16];    //豸ӵķ
    BYTE bySendMode;            //豸ӷģʽ
    BYTE byEncoderChannel;        //豸ӵķͨ
    WORD wEncoderPort;            //豸ӵķĶ˿ں
    BYTE reservedData[4];        //
}NET_DVR_DECODERINFO, *LPNET_DVR_DECODERINFO;

typedef struct 
{
    BYTE byEncoderIP[16];        //豸ӵķIP
    BYTE byEncoderUser[16];        //豸ӵķû
    BYTE byEncoderPasswd[16];    //豸ӵķ
    BYTE byEncoderChannel;        //豸ӵķͨ
    BYTE bySendMode;            //豸ӵķģʽ
    WORD wEncoderPort;            //豸ӵķĶ˿ں
    DWORD dwConnectState;        //豸ӷ״̬
    BYTE reservedData[4];        //
}NET_DVR_DECODERSTATE, *LPNET_DVR_DECODERSTATE;

/*豸붨*/
#define NET_DEC_STARTDEC        1
#define NET_DEC_STOPDEC            2
#define NET_DEC_STOPCYCLE        3
#define NET_DEC_CONTINUECYCLE    4
/*ӵͨ*/
typedef struct 
{
    char sDVRIP[16];                /* DVR IPַ */
    WORD wDVRPort;                     /* ˿ں */
    BYTE sUserName[NAME_LEN];        /* û */
    BYTE sPassword[PASSWD_LEN];        /*  */
    BYTE byChannel;                    /* ͨ */
    BYTE byLinkMode;                /* ģʽ */
    BYTE byLinkType;                /*  0 1 */
}NET_DVR_DECCHANINFO, *LPNET_DVR_DECCHANINFO;

/*ÿͨ*/
typedef struct 
{
    BYTE    byPoolChans;            /*ÿ·ͨϵѭͨ, 4ͨ 0ʾûн*/
    NET_DVR_DECCHANINFO struchanConInfo[MAX_DECPOOLNUM];
    BYTE    byEnablePoll;            /*ǷѲ 0- 1-*/
    BYTE    byPoolTime;                /*Ѳʱ 0- 1-10 2-15 3-20 4-30 5-45 6-1 7-2 8-5 */
}NET_DVR_DECINFO, *LPNET_DVR_DECINFO;

/*豸*/
typedef struct 
{
    DWORD    dwSize;
    DWORD    dwDecChanNum;         /*ͨ*/
    NET_DVR_DECINFO struDecInfo[MAX_DECNUM];
}NET_DVR_DECCFG, *LPNET_DVR_DECCFG;

//2005-08-01
/* 豸͸ͨ */
typedef struct 
{
    DWORD dwEnableTransPort;    /* Ƿ͸ͨ 0 1*/
    char sDecoderIP[16];        /* DVR IPַ */
    WORD wDecoderPort;            /* ˿ں */
    WORD wDVRTransPort;            /* ǰDVRǴ485/2321ʾ232,2ʾ485 */
    char cReserve[4];
}NET_DVR_PORTINFO, *LPNET_DVR_PORTINFO;

typedef struct 
{
    DWORD dwSize;
    NET_DVR_PORTINFO struTransPortInfo[MAX_TRANSPARENTNUM]; /* 0ʾ232 1ʾ485 */
}NET_DVR_PORTCFG, *LPNET_DVR_PORTCFG;

/* ļط */
typedef struct 
{
    DWORD dwSize;
    char sDecoderIP[16];        /* DVR IPַ */
    WORD wDecoderPort;            /* ˿ں */
    WORD wLoadMode;                /* طģʽ 1 2ʱ */
    union
    {
        BYTE byFile[100];        /* طŵļ */
        struct
        {
            DWORD dwChannel;
            BYTE sUserName[NAME_LEN];    /*Ƶû*/
            BYTE sPassword[PASSWD_LEN];    /*  */
            NET_DVR_TIME struStartTime;    /* ʱطŵĿʼʱ */
            NET_DVR_TIME struStopTime;    /* ʱطŵĽʱ */
        }bytime;
    }mode_size;
}NET_DVR_PLAYREMOTEFILE, *LPNET_DVR_PLAYREMOTEFILE;

/*ǰ豸״̬*/
typedef struct 
{
    DWORD dwWorkType;        /*ʽ1Ѳ2̬ӽ롢3ļط 4ʱط*/
    char sDVRIP[16];        /*ӵ豸ip*/
    WORD wDVRPort;            /*Ӷ˿ں*/
    BYTE byChannel;            /* ͨ */
    BYTE byLinkMode;        /* ģʽ */
    DWORD    dwLinkType;        /* 0 1*/
    union
    {
        struct
        {
            BYTE sUserName[NAME_LEN];    /*Ƶû*/
            BYTE sPassword[PASSWD_LEN];    /*  */
            char cReserve[52];
        }userInfo;
        struct
        {
            BYTE   fileName[100];
        }fileInfo;
        struct
        {
            DWORD    dwChannel;
            BYTE    sUserName[NAME_LEN];    /*Ƶû*/
            BYTE    sPassword[PASSWD_LEN];    /*  */
            NET_DVR_TIME struStartTime;        /* ʱطŵĿʼʱ */
            NET_DVR_TIME struStopTime;        /* ʱطŵĽʱ */
        }timeInfo;
    }objectInfo;
}NET_DVR_DECCHANSTATUS, *LPNET_DVR_DECCHANSTATUS;

typedef struct 
{
    DWORD   dwSize;
    NET_DVR_DECCHANSTATUS struDecState[MAX_DECNUM];
}NET_DVR_DECSTATUS, *LPNET_DVR_DECSTATUS;
/*****************************DS-6001D/F(end)***************************/

//ַ(ӽṹ)
typedef struct 
{
    WORD wShowString;                // ԤͼǷʾַ,0-ʾ,1-ʾ С704*576,ַĴСΪ32*32
    WORD wStringSize;                /* ַĳȣܴ44ַ */
    WORD wShowStringTopLeftX;        /* ַʾλõx */
    WORD wShowStringTopLeftY;        /* ַʾλõy */
    char sString[44];                /* Ҫʾַ */
}NET_DVR_SHOWSTRINGINFO, *LPNET_DVR_SHOWSTRINGINFO;

//ַ(9000չ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM_V30];                /* Ҫʾַ */
}NET_DVR_SHOWSTRING_V30, *LPNET_DVR_SHOWSTRING_V30;

//ַչ(8ַ)
typedef struct 
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM_EX];                /* Ҫʾַ */
}NET_DVR_SHOWSTRING_EX, *LPNET_DVR_SHOWSTRING_EX;

//ַ
typedef struct 
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM];                /* Ҫʾַ */
}NET_DVR_SHOWSTRING, *LPNET_DVR_SHOWSTRING;

/****************************DS9000ṹ(begin)******************************/
/*
EMAILṹ
*/
typedef struct
{        
    DWORD        dwSize;
    BYTE        sAccount[NAME_LEN];                /* ˺*/ 
    BYTE        sPassword[MAX_EMAIL_PWD_LEN];            /* */
    struct
    {
        BYTE    sName[NAME_LEN];                /*  */
        BYTE    sAddress[MAX_EMAIL_ADDR_LEN];        /* ˵ַ */
    }struSender;
    BYTE        sSmtpServer[MAX_EMAIL_ADDR_LEN];    /* smtp */
    BYTE        sPop3Server[MAX_EMAIL_ADDR_LEN];    /* pop3 */
    struct
    {
        BYTE    sName[NAME_LEN];                /* ռ */
        BYTE    sAddress[MAX_EMAIL_ADDR_LEN];        /* ռ˵ַ */
    }struReceiver[3];                            /* 3ռ */
    BYTE        byAttachment;                    /* Ƿ */
    BYTE        bySmtpServerVerify;                /* ͷҪ֤ */
    BYTE        byMailInterval;                 /* mail interval */
    BYTE        byEnableSSL;                    //sslǷ9000_1.1
    WORD        wSmtpPort;                        //gmail465ͨΪ25 
    BYTE        byEnableTLS;                    /*TLSǷ*/
    BYTE        byStartTLS;                     /*ǷStartTLS*/
    BYTE        byRes[72];                        /**/
} NET_DVR_EMAILCFG_V30, *LPNET_DVR_EMAILCFG_V30;

/*
DVRʵѲݽṹ
*/
typedef struct
{    
    DWORD     dwSize;
    BYTE    byPresetNo[CRUISE_MAX_PRESET_NUMS];        /* Ԥõ */
    BYTE     byCruiseSpeed[CRUISE_MAX_PRESET_NUMS];    /* Ѳٶ */
    WORD    wDwellTime[CRUISE_MAX_PRESET_NUMS];        /* ͣʱ */
    BYTE    byEnableThisCruise;                        /* Ƿ */
    BYTE    res[15];
}NET_DVR_CRUISE_PARA, *LPNET_DVR_CRUISE_PARA; 
/****************************DS9000ṹ(end)******************************/

//ʱ
typedef struct 
{
    DWORD dwMonth;        // 0-11ʾ1-12
    DWORD dwWeekNo;        //ڼ 01 12 23 34 4һ
    DWORD dwWeekDate;    //ڼ 0 1һ 2ڶ 3 4 5 6
    DWORD dwHour;        //Сʱ    ʼʱ023 ʱ123
    DWORD dwMin;        //    059
}NET_DVR_TIMEPOINT;

//ʱ
typedef struct 
{
    DWORD dwSize;
    DWORD dwZoneIndex; //ӦòʹNET_DVR_NTPPARA еcTimeDifferenceH cTimeDifferenceM ʱ˴ûȡֵ䣬ûṩ༭
    BYTE byRes1[12];            //
    DWORD dwEnableDST;        //Ƿʱ 0 1
    BYTE byDSTBias;    //ʱƫֵ30min, 60min, 90min, 120min, ԷӼƣԭʼֵ
    BYTE byRes2[3];
    NET_DVR_TIMEPOINT struBeginPoint;    //ʱƿʼʱ
    NET_DVR_TIMEPOINT struEndPoint;    //ʱֹͣʱ
}NET_DVR_ZONEANDDST, *LPNET_DVR_ZONEANDDST;

//ͼƬ
typedef struct 
{
/*ע⣺ͼѹֱΪVGAʱ֧0=CIF, 1=QCIF, 2=D1ץͼ
ֱΪ3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA,7=XVGA, 8=HD900p
    ֵ֧ǰֱʵץͼ*/
    
    /* ͨȡ
       0-CIF           1-QCIF           2-D1         3-UXGA(1600x1200), 4-SVGA(800x600),5-HD720p(1280x720)
       6-VGA           7-XVGA           8-HD900p     9-HD1080     10-2560*1920
       11-1600*304     12-2048*1536     13-2448*2048,  14-2448*1200 15-2448*800
       16-XGA(1024*768), 17-SXGA(1280*1024),18-WD1(960*576/960*480),      19-1080i,      20-576*576     
       21-1536*1536,     22-1920*1920,      23-320*240,    24-720*720,    25-1024*768,
       26-1280*1280,     27-1600*600,       28-2048*768,   29-160*120,    75-336*256,
       78-384*256,         79-384*216,        80-320*256,    82-320*192,    83-512*384,
       127-480*272,      128-512*272,       500-384*288,
       0xff-Auto(ʹõǰֱ)
    */
    WORD    wPicSize;            
    WORD    wPicQuality;            /* ͼƬϵ 0- 1-Ϻ 2-һ */
}NET_DVR_JPEGPARA, *LPNET_DVR_JPEGPARA;

/* aux video out parameter */
//
typedef struct 
{
    DWORD dwSize;
    DWORD dwAlarmOutChan;                       /* ѡ񱨾󱨾ͨлʱ䣺1ͨ: 0:/1:1/2:2/3:3/4:4 */
    DWORD dwAlarmChanSwitchTime;                /* :1 - 10:10 */
    DWORD dwAuxSwitchTime[MAX_AUXOUT];            /* лʱ: 0-л,1-5s,2-10s,3-20s,4-30s,5-60s,6-120s,7-300s */
    BYTE  byAuxOrder[MAX_AUXOUT][MAX_WINDOW];    /* Ԥ˳, 0xffʾӦĴڲԤ */
}NET_DVR_AUXOUTCFG, *LPNET_DVR_AUXOUTCFG;


//ntp
typedef struct 
{
    BYTE sNTPServer[64];   /* Domain Name or IP addr of NTP server */
    WORD wInterval;         /* adjust time interval(hours) */
    BYTE byEnableNTP;    /* enable NPT client 0-no1-yes*/
    signed char cTimeDifferenceH; /* ʱ׼ʱ Сʱƫ-12 ... +13 */
    signed char cTimeDifferenceM;/* ʱ׼ʱ ƫ0, 30, 45*/
    BYTE res1;
    WORD wNtpPort;         /* ntp server port 9000 豸ĬΪ123*/
    BYTE res2[8];
}NET_DVR_NTPPARA, *LPNET_DVR_NTPPARA;

//ddns
typedef struct 
{
    BYTE sUsername[NAME_LEN];  /* DDNS˺û/ */
    BYTE sPassword[PASSWD_LEN];
    BYTE sDomainName[64];       /*  */
    BYTE byEnableDDNS;            /*ǷӦ 0-1-*/
    BYTE res[15];
}NET_DVR_DDNSPARA, *LPNET_DVR_DDNSPARA;


typedef struct
{
    BYTE byHostIndex;                    /* 0-˽DDNS 1Dyndns 2PeanutHull()*/
    BYTE byEnableDDNS;                    /*ǷӦDDNS 0-1-*/
    WORD wDDNSPort;                        /* DDNS˿ں */
    BYTE sUsername[NAME_LEN];            /* DDNSû*/
    BYTE sPassword[PASSWD_LEN];            /* DDNS */
    BYTE sDomainName[MAX_DOMAIN_NAME];    /* 豸䱸ַ */
    BYTE sServerName[MAX_DOMAIN_NAME];    /* DDNS ӦķַIPַ */
    BYTE byRes[16];
}NET_DVR_DDNSPARA_EX, *LPNET_DVR_DDNSPARA_EX;

//9000չ
typedef struct
{
    BYTE byEnableDDNS;
    BYTE byHostIndex;/*0-IPServer 1Dyndns 2PeanutHull()3- NO-IP, 4- hiDDNS*/
    BYTE byRes1[2];
    struct
    {    
        BYTE sUsername[NAME_LEN];            /* DDNS˺û*/
        BYTE sPassword[PASSWD_LEN];            /*  */
        BYTE sDomainName[MAX_DOMAIN_NAME];    /* 豸䱸ַ */
        BYTE sServerName[MAX_DOMAIN_NAME];    /* DDNSЭӦķַIPַ */
        WORD wDDNSPort;                        /* ˿ں */
        WORD    wCountryID;        //ұţbyHostIndex = 4ʱЧ0ʾĬ
                                BYTE byStatus;                      /* DDNS״ֻ̬
                                                                    0-
                                                                    1-ӷʧ(connServerfail)
                                                                    2-Ϣʧ(solveServerMesFail)
                                                                    3-ʧ(connHeartSrvfail)
                                                                    4-Ϣʧ(solveHeartSrvMesFail)
                                                                    5-ʧ(connHostSrvfail)
                                                                    6-Ϣʧ(solveHostSrvMesFail)
                                                                    7-DDNS״̬(updateSuccess)
                                                                    8-δ(disable)
                                                                    9-עɹ(registHostSuccess)
                                                                    10-DNSô(DNSSrvError)
                                                                    11-ռ(DomainConflict)
                                                                    12-()Ϸ(invalidAlias)
                                                                    13-Ȩʧ(authenticationFail)
                                                                    14-ע(registServerError)
                                                                    15-עʧ(registFail)
                                */
                                BYTE byRes[7];
    } struDDNS[MAX_DDNS_NUMS];
    BYTE byRes2[16];
}NET_DVR_DDNSPARA_V30, *LPNET_DVR_DDNSPARA_V30;

//email
typedef struct 
{
    BYTE sUsername[64];  /* ʼ˺/ */
    BYTE sPassword[64];
    BYTE sSmtpServer[64];
    BYTE sPop3Server[64];
    BYTE sMailAddr[64];   /* email */
    BYTE sEventMailAddr1[64];  /* ϴ/쳣ȵemail */
    BYTE sEventMailAddr2[64];
    BYTE res[16];
}NET_DVR_EMAILPARA, *LPNET_DVR_EMAILPARA;

//
typedef struct 
{
    DWORD  dwSize;
    char  sDNSIp[16];                /* DNSַ */
    NET_DVR_NTPPARA  struNtpClientParam;      /* NTP */
    NET_DVR_DDNSPARA struDDNSClientParam;     /* DDNS */
    BYTE res[464];            /*  */
}NET_DVR_NETAPPCFG, *LPNET_DVR_NETAPPCFG;

//nfsṹ
typedef struct
{
    char sNfsHostIPAddr[16];
    BYTE sNfsDirectory[PATHNAME_LEN];        // PATHNAME_LEN = 128
}NET_DVR_SINGLE_NFS, *LPNET_DVR_SINGLE_NFS;

typedef struct 
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NFS struNfsDiskParam[MAX_NFS_DISK];
}NET_DVR_NFSCFG, *LPNET_DVR_NFSCFG;

typedef struct tagNET_DVR_ISCSI_CFG
{   
    DWORD dwSize;                   // ṹС
    WORD wVrmPort;                  // VRM ˿
    BYTE byEnable;                  // Ƿ ISCSI洢
    BYTE byRes[69];                 // ֽ
    NET_DVR_IPADDR struVrmAddr;          // VRM ipַ 16λ
    char chNvtIndexCode[64];        //nvt index Code 
}NET_DVR_ISCSI_CFG, *LPNET_DVR_ISCSI_CFG;  

//Ѳ(˽IPר)
typedef struct
{
    BYTE    PresetNum;    //Ԥõ
    BYTE    Dwell;        //ͣʱ
    BYTE    Speed;        //ٶ
    BYTE    Reserve;    //
}NET_DVR_CRUISE_POINT, *LPNET_DVR_CRUISE_POINT;

typedef struct 
{
    NET_DVR_CRUISE_POINT struCruisePoint[32];            //֧32Ѳ
}NET_DVR_CRUISE_RET, *LPNET_DVR_CRUISE_RET;

/************************************·(begin)***************************************/
typedef struct 
{
    DWORD    dwSize;
    char    sFirstDNSIP[16];
    char    sSecondDNSIP[16];
    char    sRes[32];
}NET_DVR_NETCFG_OTHER, *LPNET_DVR_NETCFG_OTHER;

typedef struct 
{
    char     sDVRIP[16];                /* DVR IPַ */
    WORD     wDVRPort;                 /* ˿ں */
    BYTE     byChannel;                /* ͨ */
    BYTE    byTransProtocol;            /* Э 0-TCP, 1-UDP */
    BYTE    byTransMode;                /* ģʽ 0 1*/
    BYTE    byRes[3];
    BYTE    sUserName[NAME_LEN];            /* ½ʺ */
    BYTE    sPassword[PASSWD_LEN];            /*  */
}NET_DVR_MATRIX_DECINFO, *LPNET_DVR_MATRIX_DECINFO;

///ֹ̬ͣ
typedef struct 
{
    DWORD    dwSize;                
    NET_DVR_MATRIX_DECINFO struDecChanInfo;        /* ̬ͨϢ */
}NET_DVR_MATRIX_DYNAMIC_DEC, *LPNET_DVR_MATRIX_DYNAMIC_DEC;

typedef struct  
{
    DWORD     dwSize;
    DWORD   dwIsLinked;         /* ͨ״̬ 0 1 2 3-ڽ */
    DWORD   dwStreamCpRate;     /* Stream copy rate, X kbits/second */
    char    cRes[64];        /*  */
}NET_DVR_MATRIX_DEC_CHAN_STATUS, *LPNET_DVR_MATRIX_DEC_CHAN_STATUS;

typedef struct 
{
    DWORD    dwSize;
    NET_DVR_MATRIX_DECINFO struDecChanInfo;        /* ͨϢ */
    DWORD    dwDecState;    /* 0-̬ 1ѭ 2ʱط 3ļط */
    NET_DVR_TIME StartTime;        /* ʱطſʼʱ */
    NET_DVR_TIME StopTime;        /* ʱطֹͣʱ */
    char    sFileName[128];        /* ļطļ */
}NET_DVR_MATRIX_DEC_CHAN_INFO, *LPNET_DVR_MATRIX_DEC_CHAN_INFO;

//ӵͨ 2007-11-05
typedef struct 
{
    DWORD dwEnable;                    /* Ƿ 0 1*/
    NET_DVR_MATRIX_DECINFO struDecChanInfo;        /* ѲͨϢ */
}NET_DVR_MATRIX_DECCHANINFO, *LPNET_DVR_MATRIX_DECCHANINFO;

//2007-11-05 ÿͨ
typedef struct 
{
    DWORD    dwSize;
    DWORD    dwPoolTime;            /*Ѳʱ */
    NET_DVR_MATRIX_DECCHANINFO struchanConInfo[MAX_CYCLE_CHAN];
}NET_DVR_MATRIX_LOOP_DECINFO, *LPNET_DVR_MATRIX_LOOP_DECINFO;

//2007-12-22
typedef struct 
{
    BYTE    baudrate;     /*  */
    BYTE    databits;        /* λ */
    BYTE    stopbits;        /* ֹͣλ */
    BYTE    parity;        /* żУλ */
    BYTE    flowcontrol;    /*  */
    BYTE    res[3];
}TTY_CONFIG, *LPTTY_CONFIG;

typedef struct  
{                    
    BYTE byTranChanEnable;    /* ǰ͸ͨǷ 0ر 1 */    
                            /*
                            *    ·1485ڣ1232ڶΪ͸ͨ,豸ŷ£
                            *    0 RS485
                            *    1 RS232 Console
    */
    BYTE    byLocalSerialDevice;            /* Local serial device */
                                            /*
                                            *    Զ̴,һRS232һRS485
                                            *    1ʾ232
                                            *    2ʾ485
    */
    BYTE    byRemoteSerialDevice;            /* Remote output serial device */
    BYTE    res1;                            /*  */
    char    sRemoteDevIP[16];                /* Remote Device IP */
    WORD    wRemoteDevPort;                /* Remote Net Communication Port */
    BYTE    res2[2];                        /*  */
    TTY_CONFIG RemoteSerialDevCfg;
}NET_DVR_MATRIX_TRAN_CHAN_INFO, *LPNET_DVR_MATRIX_TRAN_CHAN_INFO;

typedef struct  
{
    DWORD dwSize;
    BYTE     by232IsDualChan; /* ·232͸ͨȫ˫ ȡֵ1MAX_SERIAL_NUM */
    BYTE    by485IsDualChan; /* ·485͸ͨȫ˫ ȡֵ1MAX_SERIAL_NUM */
    BYTE    res[2];    /*  */
    NET_DVR_MATRIX_TRAN_CHAN_INFO struTranInfo[MAX_SERIAL_NUM];/*ͬʱֽ֧MAX_SERIAL_NUM͸ͨ*/
}NET_DVR_MATRIX_TRAN_CHAN_CONFIG, *LPNET_DVR_MATRIX_TRAN_CHAN_CONFIG;

//2007-12-24 Merry Christmas Eve...
typedef struct 
{
    DWORD    dwSize;
    char    sDVRIP[16];        /* DVR IPַ */    
    WORD    wDVRPort;            /* ˿ں */    
    BYTE    byChannel;            /* ͨ */
    BYTE     byReserve;
    BYTE    sUserName[NAME_LEN];        /* û */
    BYTE    sPassword[PASSWD_LEN];        /*  */
    DWORD    dwPlayMode;       /* 0ļ 1ʱ*/            
    NET_DVR_TIME StartTime;
    NET_DVR_TIME StopTime;
    char    sFileName[128];
}NET_DVR_MATRIX_DEC_REMOTE_PLAY, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY;

/* ļ */
#define NET_DVR_PLAYSTART        1//ʼ
#define NET_DVR_PLAYSTOP        2//ֹͣ
#define NET_DVR_PLAYPAUSE        3//ͣ
#define NET_DVR_PLAYRESTART        4//ָ
#define NET_DVR_PLAYFAST        5//
#define NET_DVR_PLAYSLOW        6//
#define NET_DVR_PLAYNORMAL        7//ٶ
#define NET_DVR_PLAYSTARTAUDIO    9//
#define NET_DVR_PLAYSTOPAUDIO    10//ر
#define NET_DVR_PLAYSETPOS        12//ıļطŵĽ

typedef struct 
{
    DWORD    dwSize;
    DWORD    dwPlayCmd;        /*  ļ*/
    DWORD    dwCmdParam;        /*  */
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_CONTROL, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_CONTROL;

typedef struct  
{
    DWORD dwSize;
    DWORD dwCurMediaFileLen;        /* ǰŵýļ */       
    DWORD dwCurMediaFilePosition;    /* ǰļĲλ */        
    DWORD dwCurMediaFileDuration;    /* ǰļʱ */        
    DWORD dwCurPlayTime;            /* ǰѾŵʱ */        
    DWORD dwCurMediaFIleFrames;        /* ǰļ֡ */        
    DWORD dwCurDataType;            /* ǰͣ19-ļͷ20-ݣ 21-Ž־ */        
    BYTE res[72];    
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_STATUS, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_STATUS;

//2009-4-11 added by likui ·new
typedef struct tagNET_MATRIX_PASSIVEMODE
{
    WORD    wTransProtol;        //Э飬0-TCP, 1-UDP, 2-MCAST
    WORD    wPassivePort;        //UDP˿, TCPʱĬ
    NET_DVR_IPADDR  struMcastIP;    //TCP,UDPʱЧ, MCASTʱΪಥַ
    BYTE    byStreamType;/* ݲģʽ:REAL_TIME_STREAM(1)ʵʱ,RECORD_STREAM(2)ļ */
    BYTE    byRes[7];
}NET_DVR_MATRIX_PASSIVEMODE, *LPNET_DVR_MATRIX_PASSIVEMODE;

typedef struct tagNET_DVR_MATRIX_TRAN_CHAN_INFO_V30 
{                    
    BYTE  byTranChanEnable;            /* ǰ͸ͨǷ 0ر 1 */    
    BYTE  byLocalSerialDevice;      /* Local serial device */
                                    /*
                                    *  ·1485ڣ1232ڶΪ͸ͨ,豸ŷ£
                                    *  0 RS485
                                    *  1 RS232 Console
                                    *  2 Dual Scom
                                    */
    BYTE  byRemoteSerialDevice;        /* Remote output serial device */
                                    /*
                                    *  Զ̴,һRS232һRS485
                                    *  1 ʾ232
                                    *  2 ʾ485
                                    */
    BYTE  byRes1;                    /*  */        
    NET_DVR_IPADDR struRemoteDevIP; /* Remote Device IP */
    WORD  wRemoteDevPort;            /* Remote Net Communication Port */
    BYTE  byIsEstablished;            /* ͸ͨɹ־0-ûгɹ1-ɹ */
    BYTE  byRes2;                    /*  */
    TTY_CONFIG RemoteSerialDevCfg;
    BYTE  byUsername[NAME_LEN];
    BYTE  byPassword[PASSWD_LEN];
    DWORD dwLocalSerialNo;          /* ش */
    DWORD dwRemoteSerialNo;         /* Զ̴ */
    BYTE  byRes3[8];
} NET_DVR_MATRIX_TRAN_CHAN_INFO_V30,*LPNET_DVR_MATRIX_TRAN_CHAN_INFO_V30;

typedef struct tagMATRIX_TRAN_CHAN_CONFIG 
{
    DWORD dwSize;
    BYTE  by232IsDualChan; /* ·232͸ͨȫ˫ ȡֵ1MAX_SERIAL_NUM */
    BYTE  by485IsDualChan; /* ·485͸ͨȫ˫ ȡֵ1MAX_SERIAL_NUM */
    BYTE  byRes[2];           /*  */
    NET_DVR_MATRIX_TRAN_CHAN_INFO_V30 struTranInfo[MAX_SERIAL_NUM]; /*ͬʱֽ֧MAX_SERIAL_NUM͸ͨ*/
}NET_DVR_MATRIX_TRAN_CHAN_CONFIG_V30,*LPNET_DVR_MATRIX_TRAN_CHAN_CONFIG_V30;

typedef struct  
{
    DWORD                                dwEnable;    /* Ƿ 0 1*/
    NET_DVR_STREAM_MEDIA_SERVER_CFG    streamMediaServerCfg;    
    NET_DVR_DEV_CHAN_INFO         struDevChanInfo;        /* ѲͨϢ */
}NET_DVR_MATRIX_CHAN_INFO_V30,*LPNET_DVR_CYC_SUR_CHAN_ELE_V30;

typedef struct  tagMATRIX_LOOP_DECINFO_V30
{
    DWORD                            dwSize;
    DWORD                            dwPoolTime;        /*Ѳ*/
    NET_DVR_MATRIX_CHAN_INFO_V30    struchanConInfo[MAX_CYCLE_CHAN_V30];
    BYTE                               byRes[16];
} NET_DVR_MATRIX_LOOP_DECINFO_V30,*LPNET_DVR_MATRIX_LOOP_DECINFO_V30;


typedef struct tagDEC_MATRIX_CHAN_INFO_V30
{
    DWORD    dwSize;
    NET_DVR_STREAM_MEDIA_SERVER_CFG streamMediaServerCfg;    /*ý*/
    NET_DVR_DEV_CHAN_INFO               struDevChanInfo;        /* ͨϢ */
    DWORD    dwDecState;        /* 0-̬ 1ѭ 2ʱط 3ļط */
    NET_DVR_TIME StartTime;        /* ʱطſʼʱ */
    NET_DVR_TIME StopTime;        /* ʱطֹͣʱ */
    char    sFileName[128];        /* ļطļ */
    DWORD   dwGetStreamMode;    /*ȡģʽ:1-2-*/
    NET_DVR_MATRIX_PASSIVEMODE      struPassiveMode;
    BYTE    byRes[32];
}NET_DVR_MATRIX_DEC_CHAN_INFO_V30,*LPNET_DVR_MATRIX_DEC_CHAN_INFO_V30;

#define MAX_RESOLUTIONNUM    64 //ֱֵ֧Ŀ
typedef struct tagNET_DVR_MATRIX_ABILITY
{
    DWORD dwSize;
    BYTE  byDecNums;
    BYTE  byStartChan;
    BYTE  byVGANums;
    BYTE  byBNCNums;
    BYTE  byVGAWindowMode[8][12];     /*VGAֵ֧ĴģʽVGA1ɻ*/
    BYTE  byBNCWindowMode[4];           /*BNCֵ֧Ĵģʽ*/
    BYTE  byDspNums;   
    BYTE  byHDMINums;//HDMIʾͨ25ʼ
    BYTE  byDVINums;//DVIʾͨ29ʼ
    BYTE  byRes1[13];
    BYTE  bySupportResolution[MAX_RESOLUTIONNUM];//öٶ,һֽڴһֱ//֧֣1֧֣0֧
    BYTE  byHDMIWindowMode[4][8];//HDMIֵ֧Ĵģʽ
    BYTE  byDVIWindowMode[4][8];//DVIֵ֧Ĵģʽ
    BYTE  byRes2[24];
}NET_DVR_MATRIX_ABILITY, *LPNET_DVR_MATRIX_ABILITY;
//ϴlogoṹ
typedef struct tagNET_DVR_DISP_LOGOCFG
{
    DWORD        dwCorordinateX;    //ͼƬʾX
    DWORD        dwCorordinateY;    //ͼƬʾY
    WORD        wPicWidth; //ͼƬ
    WORD        wPicHeight; //ͼƬ
    BYTE        byRes1[4];
    BYTE        byFlash;  //Ƿ˸1-˸0-˸
    BYTE        byTranslucent; //Ƿ͸1-͸0-͸
    BYTE        byRes2[6];                //
    DWORD        dwLogoSize;//LOGOСBMPļͷ
}NET_DVR_DISP_LOGOCFG,*LPNET_DVR_DISP_LOGOCFG;

/**/
#define NET_DVR_ENCODER_UNKOWN 0 /*δ֪ʽ*/
#define NET_DVR_ENCODER_H264   1 /*˽ 264*/
#define NET_DVR_ENCODER_S264   2 /*Standard H264*/
#define NET_DVR_ENCODER_MPEG4  3 /*MPEG4*/
#define NET_DVR_ORIGINALSTREAM 4 /*Original Stream*/
#define NET_DVR_PICTURE           5/*Picture*/
#define NET_DVR_ENCODER_MJPEG  6
#define NET_DVR_ENCODER_MPEG2  7
#define NET_DVR_ENCODER_H265   8
/* ʽ */
#define NET_DVR_STREAM_TYPE_UNKOWN   0     /*δ֪ʽ*/
#define NET_DVR_STREAM_TYPE_PRIVT    1     /*˽иʽ*/
#define NET_DVR_STREAM_TYPE_TS       7   /* TS */
#define NET_DVR_STREAM_TYPE_PS       8   /* PS */
#define NET_DVR_STREAM_TYPE_RTP      9    /* RTP */
#define NET_DVR_STREAM_TYPE_ORIGIN   10 //δ(Ƶۺƽ̨ϵͳ)

/*ͨ״̬*/
typedef struct
{
    BYTE  byDecodeStatus; /*ǰ״̬:0:δ1*/
    BYTE  byStreamType;    /**/
    BYTE  byPacketType;     /*ʽ*/
    BYTE  byRecvBufUsage; /*ջʹ*/
    BYTE  byDecBufUsage; /*뻺ʹ*/
    BYTE  byFpsDecV; /*Ƶ֡*/
    BYTE  byFpsDecA; /*Ƶ֡*/
    BYTE  byCpuLoad;     /*DSP CPUʹ*/ 
    BYTE  byRes1[4];    
    DWORD dwDecodedV; /*Ƶ֡*/
    DWORD dwDecodedA; /*Ƶ֡*/
    WORD wImgW; /*ǰͼС,*/
    WORD wImgH; //
    BYTE byVideoFormat; /*Ƶʽ:0-NON,NTSC--1,PAL--2*/
    BYTE  byRes2[3];
    DWORD  dwDecChan;       /*ȡȫͨ״̬ʱЧʱ0*/
    BYTE  byRes3[20]; 
}NET_DVR_MATRIX_CHAN_STATUS, *LPNET_DVR_MATRIX_CHAN_STATUS;

/*ʾͨ״̬*/
#define NET_DVR_MAX_DISPREGION 16         /*ÿʾͨʾĴ*/
//ֱ
//
typedef enum
{
    /*VGA*/
    VGA_NOT_AVALIABLE,
        VGA_THS8200_MODE_SVGA_60HZ,    //(800*600)
        VGA_THS8200_MODE_SVGA_75HZ,    //(800*600)
        VGA_THS8200_MODE_XGA_60HZ,     //(1024*768)
        VGA_THS8200_MODE_XGA_75HZ,     //(1024*768)
        VGA_THS8200_MODE_SXGA_60HZ,    //(1280*1024)
        VGA_THS8200_MODE_720P_60HZ,    //(1280*720)
        VGA_THS8200_MODE_1080I_60HZ,   //(1920*1080)
        VGA_THS8200_MODE_1080P_30HZ,   //(1920*1080)
        VGA_THS8200_MODE_UXGA_30HZ,    //(1600*1200)
        /*HDMI*/    
        HDMI_SII9134_MODE_XGA_60HZ,       //(1024*768)
        HDMI_SII9134_MODE_SXGA_60HZ,   //(1280*1024)
        HDMI_SII9134_MODE_SXGA2_60HZ,  //(1280*960)
        HDMI_SII9134_MODE_720P_60HZ,   //(1280*720)    
        HDMI_SII9134_MODE_720P_50HZ,   //(1280*720)        
        HDMI_SII9134_MODE_1080I_60HZ,  //(1920*1080)
        HDMI_SII9134_MODE_1080I_50HZ,  //(1920*1080)    
        HDMI_SII9134_MODE_1080P_25HZ,  //(1920*1080)
        HDMI_SII9134_MODE_1080P_30HZ,  //(1920*1080)
        HDMI_SII9134_MODE_1080P_50HZ,  //(1920*1080)
        HDMI_SII9134_MODE_1080P_60HZ,  //(1920*1080)
        HDMI_SII9134_MODE_UXGA_60HZ,   //(1600*1200)
        /*DVI*/    
        DVI_SII9134_MODE_XGA_60HZ,       //(1024*768)
        DVI_SII9134_MODE_SXGA_60HZ,       //(1280*1024)
        DVI_SII9134_MODE_SXGA2_60HZ,   //(1280*960)
        DVI_SII9134_MODE_720P_60HZ,       //(1280*720)    
        DVI_SII9134_MODE_720P_50HZ,    //(1280*720)        
        DVI_SII9134_MODE_1080I_60HZ,   //(1920*1080)
        DVI_SII9134_MODE_1080I_50HZ,   //(1920*1080)
        DVI_SII9134_MODE_1080P_25HZ,   //(1920*1080)
        DVI_SII9134_MODE_1080P_30HZ,   //(1920*1080)
        DVI_SII9134_MODE_1080P_50HZ,   //(1920*1080)
        DVI_SII9134_MODE_1080P_60HZ,   //(1920*1080)
        DVI_SII9134_MODE_UXGA_60HZ,     //(1600*1200)
        VGA_DECSVR_MODE_SXGA2_60HZ,
        HDMI_DECSVR_MODE_1080P_24HZ,
        DVI_DECSVR_MODE_1080P_24HZ,
        YPbPr_DECSVR_MODE_720P_60HZ,
        YPbPr_DECSVR_MODE_1080I_60HZ
}VGA_MODE;

//֡ʶ
#define           LOW_DEC_FPS_1_2                51
#define           LOW_DEC_FPS_1_4                52
#define           LOW_DEC_FPS_1_8                53
#define           LOW_DEC_FPS_1_16               54

/*Ƶʽ׼*/
typedef enum
{
    VS_NON = 0,
        VS_NTSC = 1,
        VS_PAL = 2
}VIDEO_STANDARD;

typedef struct tagNET_DVR_VGA_DISP_CHAN_CFG
{        
    DWORD    dwSize; 
    BYTE    byAudio;            /*ƵǷ,0-1-*/
    BYTE    byAudioWindowIdx;      /*ƵӴ*/
    BYTE     byVgaResolution;      /*VGAķֱ*/
    BYTE    byVedioFormat;         /*1:NTSC,2:PAL,0-NULL*/
    DWORD    dwWindowMode;        /*ģʽ,ȡ,Ŀǰ֧1,2,4,9,16*/       
    BYTE    byJoinDecChan[MAX_WINDOWS];/*ӴڹĽͨ*/
    BYTE    byEnlargeStatus;          /*ǷڷŴ״̬0Ŵ1Ŵ*/
    BYTE    byEnlargeSubWindowIndex;//ŴӴں
    union
    {
        BYTE byRes[16];
        struct
        {
            /*ӴڶӦͨӦĽϵͳĲλ(Ƶۺƽ̨нϵͳЧ)*/
            BYTE     byJoinDecoderId[MAX_WINDOWS];
        }struVideoPlatform;
        struct
        {
            BYTE     byRes[16];
        }struNotVideoPlatform;
    }struDiff;
    /*ֹ壬0-Ƶۺƽ̨ڲʾͨã1-ʾͨ*/
    BYTE        byUnionType;
    BYTE        byScale; /*ʾģʽ0---ʵʾ1---ʾ( BNC )*/
}NET_DVR_VGA_DISP_CHAN_CFG,*LPNET_DVR_VGA_DISP_CHAN_CFG;


/*ʾͨ״̬*/
#define NET_DVR_MAX_DISPREGION 16 /*ÿʾͨʾĴ*/
typedef struct
{
    BYTE  byDispStatus;          /*ʾ״̬0δʾ1ʾ*/
    BYTE  byBVGA;                /*0-BNC1-VGA 2-HDMI3-DVI*/
    BYTE  byVideoFormat;        /*Ƶʽ:1:NTSC,2:PAL,0-NON*/
    BYTE  byWindowMode;        /*ǰģʽ*/
    BYTE  byJoinDecChan[MAX_WINDOWS];        /*ӴڹĽͨ*/
    BYTE  byFpsDisp[NET_DVR_MAX_DISPREGION]; /*ÿӻʾ֡*/
    BYTE  byScreenMode;            //Ļģʽ0-ͨ 1-
    BYTE  byRes2[31];
}NET_DVR_DISP_CHAN_STATUS, *LPNET_DVR_DISP_CHAN_STATUS;

#define MAX_DECODECHANNUM   32//·ͨ
#define MAX_DISPCHANNUM   24//·ʾͨ

/*豸״̬*/
typedef struct tagNET_DVR_DECODER_WORK_STATUS
{
    DWORD dwSize;
    NET_DVR_MATRIX_CHAN_STATUS struDecChanStatus[MAX_DECODECHANNUM]; /*ͨ״̬*/
    NET_DVR_DISP_CHAN_STATUS   struDispChanStatus[MAX_DISPCHANNUM];  /*ʾͨ״̬*/
    BYTE byAlarmInStatus[MAX_ANALOG_ALARMIN];         /*״̬*/
    BYTE byAlarmOutStatus[MAX_ANALOG_ALARMOUT];       /*״̬*/
    BYTE byAudioInChanStatus;          /*Խ״̬*/
    BYTE byRes[127];
}NET_DVR_DECODER_WORK_STATUS,*LPNET_DVR_DECODER_WORK_STATUS;

//2009-12-1 ӱ벥ſ
typedef struct tagNET_DVR_PASSIVEDECODE_CONTROL
{
    DWORD    dwSize;
    DWORD    dwPlayCmd;        /*  ļ*/
    DWORD    dwCmdParam;        /*  */
    BYTE    byRes[16];//Reverse
}NET_DVR_PASSIVEDECODE_CONTROL,*LPNET_DVR_PASSIVEDECODE_CONTROL;

#define        PASSIVE_DEC_PAUSE            1    /*ͣ(ļЧ)*/
#define        PASSIVE_DEC_RESUME            2    /*ָ(ļЧ)*/
#define     PASSIVE_DEC_FAST              3   /*ٱ(ļЧ)*/
#define     PASSIVE_DEC_SLOW            4   /*ٱ(ļЧ)*/
#define     PASSIVE_DEC_NORMAL          5   /*(ļЧ)*/
#define     PASSIVE_DEC_ONEBYONE          6  /*뵥֡()*/
#define     PASSIVE_DEC_AUDIO_ON         7   /*Ƶ*/
#define     PASSIVE_DEC_AUDIO_OFF        8       /*Ƶر*/
#define        PASSIVE_DEC_RESETBUFFER        9    /*ջ*/
//2009-12-16 ӿƽͨ
typedef struct tagNET_DVR_MATRIX_DECCHAN_CONTROL
{        
    DWORD    dwSize;
    BYTE    byDecChanScaleStatus;/*ͨʾſ,1ʾʾ0ʾʵʾ*/
    BYTE    byDecodeDelay;//ʱ0-Ĭϣ1-ʵʱԺã2-ʵʱԽϺã3-ʵʱУУ4-ԽϺã5-Ժã0xff-Զ   
    BYTE    byEnableSpartan;//ʹܣ0-أ1-
    BYTE    byLowLight;      //նȡ0-أ1-8նȵȼȼԽǿԽ
    BYTE    byNoiseReduction; //3D룬0-أ1-2-Զ
    BYTE    byDefog;         //͸0-أ1-7͸ȼȼԽǿԽ
    BYTE    byEnableVcaDec; //Ƿܽ룬0-ã0-
    BYTE    byRes1;
    DWORD   dwAllCtrlType;    //ӴһͣʱЧλʾ
    //dwAllCtrlType & 0x01,رܽ
    BYTE    byRes[56];
}NET_DVR_MATRIX_DECCHAN_CONTROL,*LPNET_DVR_MATRIX_DECCHAN_CONTROL;

/************************************·(end)***************************************/
//2009-8-19 Ƶۺƽ̨ӿں
/************************************Ƶۺƽ̨(begin)***************************************/
#define MAX_SUBSYSTEM_NUM    80   //һϵͳϵͳ
#define MAX_SERIALLEN        36  //кų
#define MAX_LOOPPLANNUM        16//ƻл
#define DECODE_TIMESEGMENT 4//ƻÿʱ
typedef struct tagNET_DVR_SUBSYSTEMINFO
{
    BYTE        bySubSystemType;//ϵͳͣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ5-ϵͳ6-ϵͳ7-ϵͳ0-NULL˲ֻܻȡ        
    BYTE        byChan;//ϵͳͨϵͳ485˲ֻܻȡ                    
    BYTE        byLoginType;//עͣ1-ֱ2-DNS3-
    BYTE        byRes1[5];
    NET_DVR_IPADDR   struSubSystemIP;        /*IPַ޸ģ*/
    WORD        wSubSystemPort;        //ϵͳ˿ںţ޸ģ
    BYTE        byRes2[6];
    NET_DVR_IPADDR  struSubSystemIPMask;//
    NET_DVR_IPADDR    struGatewayIpAddr;    /* صַ*/   
    BYTE        sUserName[NAME_LEN];    /* û ˲ֻܻȡ*/
    BYTE        sPassword[PASSWD_LEN];    /*루˲ֻܻȡ*/
    char        sDomainName[MAX_DOMAIN_NAME];//(޸)
    char         sDnsAddress[MAX_DOMAIN_NAME];/*DNSIPַ*/
    BYTE        sSerialNumber[SERIALNO_LEN];//кţ˲ֻܻȡ
}NET_DVR_SUBSYSTEMINFO, *LPNET_DVR_SUBSYSTEMINFO;

typedef struct tagNET_DVR_ALLSUBSYSTEMINFO
{
    DWORD dwSize;
    NET_DVR_SUBSYSTEMINFO struSubSystemInfo[MAX_SUBSYSTEM_NUM];
    BYTE byRes[8];
}NET_DVR_ALLSUBSYSTEMINFO, *LPNET_DVR_ALLSUBSYSTEMINFO;

typedef struct  tagNET_DVR_LOOPPLAN_SUBCFG
{
    DWORD                             dwSize;
    DWORD                            dwPoolTime;        /*Ѳλ*/      
    NET_DVR_MATRIX_CHAN_INFO_V30 struChanConInfo[MAX_CYCLE_CHAN_V30];
    BYTE                               byRes[16];
}NET_DVR_LOOPPLAN_SUBCFG,*LPNET_DVR_LOOPPLAN_SUBCFG;

typedef struct tagNET_DVR_ALARMMODECFG
{
    DWORD     dwSize;
    BYTE    byAlarmMode;//ͣ1-Ѳ2-        
    WORD    wLoopTime;//Ѳʱ, λ            
    BYTE    byRes[9];
}NET_DVR_ALARMMODECFG,*LPNET_DVR_ALARMMODECFG;

typedef struct  tagNET_DVR_CODESPLITTERINFO
{
    DWORD            dwSize;
    NET_DVR_IPADDR   struIP;        /*IPַ*/
    WORD        wPort;                    //˿ں
    BYTE        byRes1[6];
    BYTE        sUserName[NAME_LEN];    /* û */
    BYTE        sPassword[PASSWD_LEN];    /* */
    BYTE        byChan;//485
    BYTE        by485Port;//485ڵַ
    BYTE        byRes2[14];
} NET_DVR_CODESPLITTERINFO, *LPNET_DVR_CODESPLITTERINFO;

typedef struct tagNET_DVR_ASSOCIATECFG
{
    BYTE    byAssociateType;//ͣ1-
    WORD    wAlarmDelay;//ʱ05룻110룻230룻31ӣ42ӣ55ӣ610ӣ
    BYTE    byAlarmNum;//ţֵӦøͬıֵͬ
    BYTE    byRes[8];
} NET_DVR_ASSOCIATECFG,*LPNET_DVR_ASSOCIATECFG;

typedef struct tagNET_DVR_DYNAMICDECODE
{
    DWORD                            dwSize;
    NET_DVR_ASSOCIATECFG           struAssociateCfg;//̬ṹ
    NET_DVR_PU_STREAM_CFG        struPuStreamCfg;//̬ṹ
    BYTE                            byRes[8];
}NET_DVR_DYNAMICDECODE,*LPNET_DVR_DYNAMICDECODE;

typedef struct  tagNET_DVR_DECODESCHED
{
    NET_DVR_SCHEDTIME  struSchedTime;//
    BYTE  byDecodeType;/*0-ޣ1-Ѳ룬2-̬*/
    BYTE  byLoopGroup;//Ѳ
    BYTE  byRes[6];
    NET_DVR_PU_STREAM_CFG struDynamicDec;//̬
} NET_DVR_DECODESCHED, *LPNET_DVR_DECODESCHED;

typedef struct tagNET_DVR_PLANDECODE
{
    DWORD dwSize;
    NET_DVR_DECODESCHED struDecodeSched[MAX_DAYS][DECODE_TIMESEGMENT];//һΪʼ9000һ
    BYTE byRes[8];
} NET_DVR_PLANDECODE,*LPNET_DVR_PLANDECODE;

//end
/************************************Ƶۺƽ̨(end)***************************************/
typedef struct 
{    /* 12 bytes */
    DWORD    dwSize;
    char    sUserName[32];
    char     sPassWord[32];
    char     sFromName[32];            /* Sender *///ַеĵһַһַ"@",ַҪ"@"ַ
    char     sFromAddr[48];            /* Sender address */
    char     sToName1[32];            /* Receiver1 */
    char     sToName2[32];            /* Receiver2 */
    char     sToAddr1[48];            /* Receiver address1 */
    char     sToAddr2[48];            /* Receiver address2 */
    char    sEmailServer[32];        /* Email server address */
    BYTE    byServerType;            /* Email server type: 0-SMTP, 1-POP, 2-IMTP*/
    BYTE    byUseAuthen;            /* Email server authentication method: 1-enable, 0-disable */
    BYTE    byAttachment;            /* enable attachment */
    BYTE    byMailinterval;            /* mail interval 0-2s, 1-3s, 2-4s. 3-5s*/
} NET_DVR_EMAILCFG, *LPNET_DVR_EMAILCFG;

typedef struct 
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_EX  struLowCompression;    //ʱ¼
    NET_DVR_COMPRESSION_INFO_EX  struEventCompression;    //¼¼
}NET_DVR_COMPRESSIONCFG_NEW, *LPNET_DVR_COMPRESSIONCFG_NEW;

//λϢ
typedef struct
{
    WORD wAction;//ȡʱֶЧ
    WORD wPanPos;//ˮƽ
    WORD wTiltPos;//ֱ
    WORD wZoomPos;//䱶
}NET_DVR_PTZPOS, *LPNET_DVR_PTZPOS;

//ΧϢ
typedef struct
{
    WORD wPanPosMin;//ˮƽmin
    WORD wPanPosMax;//ˮƽmax
    WORD wTiltPosMin;//ֱmin
    WORD wTiltPosMax;//ֱmax
    WORD wZoomPosMin;//䱶min
    WORD wZoomPosMax;//䱶max
}NET_DVR_PTZSCOPE, *LPNET_DVR_PTZSCOPE;

//rtsp ipcameraר
typedef struct
{
    DWORD dwSize;         //
    WORD  wPort;          //rtsp˿
    BYTE  byReserve[54];  //Ԥ
}NET_DVR_RTSPCFG, *LPNET_DVR_RTSPCFG;

/********************************ӿڲṹ(begin)*********************************/

//NET_DVR_Login()ṹ
typedef struct
{
    BYTE sSerialNumber[SERIALNO_LEN];   //к
    BYTE byAlarmInPortNum;                //DVR
    BYTE byAlarmOutPortNum;                //DVR
    BYTE byDiskNum;                        //DVRӲ̸
    BYTE byDVRType;                        //DVR, 1:DVR 2:ATM DVR 3:DVS ......
    BYTE byChanNum;                        //DVR ͨ
    BYTE byStartChan;                    //ʼͨ,DVS-1,DVR - 1
}NET_DVR_DEVICEINFO, *LPNET_DVR_DEVICEINFO;

//NET_DVR_Login_V30()ṹ
typedef struct
{
    BYTE sSerialNumber[SERIALNO_LEN];  //к
    BYTE byAlarmInPortNum;                //
    BYTE byAlarmOutPortNum;                //
    BYTE byDiskNum;                    //Ӳ̸
    BYTE byDVRType;                    //豸, 1:DVR 2:ATM DVR 3:DVS ......
    BYTE byChanNum;                    //ģͨ
    BYTE byStartChan;                    //ʼͨ,DVS-1,DVR - 1
    BYTE byAudioChanNum;                //ͨ
    BYTE byIPChanNum;                    //ͨλ  
    BYTE byZeroChanNum;            //ͨ //2010-01-16
    BYTE byMainProto;            //Э 0-private, 1-rtsp,2-ͬʱ֧privatertsp
    BYTE bySubProto;                //Э0-private, 1-rtsp,2-ͬʱ֧privatertsp
    BYTE bySupport;        //λΪ0ʾ֧֣1ʾ֧֣
    //bySupport & 0x1, ʾǷ֧
    //bySupport & 0x2, ʾǷֱ֧
    //bySupport & 0x4, ʾǷ֧ѹȡ
    //bySupport & 0x8, ʾǷֶ֧
    //bySupport & 0x10, ʾ֧ԶSADP
    //bySupport & 0x20, ʾ֧Raid
    //bySupport & 0x40, ʾ֧IPSAN Ŀ¼
    //bySupport & 0x80, ʾ֧rtp over rtsp
    BYTE bySupport1;        // 䣬λΪ0ʾ֧֣1ʾ֧
    //bySupport1 & 0x1, ʾǷ֧snmp v30
    //bySupport1 & 0x2, ֻ֧طź
    //bySupport1 & 0x4, Ƿֲ֧ȼ    
    //bySupport1 & 0x8, 豸Ƿֲ֧ʱչ
    //bySupport1 & 0x10, ʾǷֶ֧33
    //bySupport1 & 0x20, ʾǷ֧rtsp over http    
    //bySupport1 & 0x80, ʾǷֳ֧±Ϣ2012-9-28, һʾǷ֧NET_DVR_IPPARACFG_V40ṹ
    BYTE bySupport2; /*λΪ0ʾ֧֣0ʾ֧                            
                     bySupport2 & 0x1, ʾǷ֧ͨURLȡ
                     bySupport2 & 0x2,  ʾ֧FTPV40
                     bySupport2 & 0x4,  ʾ֧ANR
                     bySupport2 & 0x8,  ʾ֧CCDͨ
                     bySupport2 & 0x10,  ʾֲ֧شϢ֧ץĻ ϱṹ
                     bySupport2 & 0x20,  ʾǷֵ֧ȡ豸״̬
    bySupport2 & 0x40,  ʾǷ豸*/
    WORD wDevType;              //豸ͺ
    BYTE bySupport3; //չλΪ0ʾ֧֣1ʾ֧
    //bySupport3 & 0x1, ʾǷ
    // bySupport3 & 0x4 ʾְ֧ã  ͨͼIP롢
    // û豸״̬JPEGץͼʱʱץͼӲ 
    //bySupport3 & 0x8Ϊ1 ʾ֧ʹTCPԤUDPԤಥԤе"ʱԤ"ֶʱԤʹַʽʱԤbySupport3 & 0x8Ϊ0ʱʹ "˽ʱԤ"Э顣
    //bySupport3 & 0x10 ʾ֧"ȡҪ״̬V40"
    //bySupport3 & 0x20 ʾǷ֧ͨDDNSȡ
    
    BYTE byMultiStreamProto;//Ƿֶ֧,λʾ,0-֧,1-֧,bit1-3,bit2-4,bit7-bit-8
    BYTE byStartDChan;        //ʼͨ,0ʾЧ
    BYTE byStartDTalkChan;    //ʼֶԽͨţģԽͨţ0ʾЧ
    BYTE byHighDChanNum;        //ͨλ
    BYTE bySupport4;        //չλΪ0ʾ֧֣1ʾ֧
    //bySupport4 & 0x4ʾǷ֧ƴͳһӿ
    // bySupport4 & 0x80 ֧豸ϴıʹܡʾжϵýӿ NET_DVR_PDC_RULE_CFG_V42 NET_DVR_PDC_RULE_CFG_V41
    BYTE byLanguageType;// ֧,λʾ,ÿһλ0-֧,1-֧  
    //  byLanguageType 0 ʾ 豸
    //  byLanguageType & 0x1ʾ֧
    //  byLanguageType & 0x2ʾ֧Ӣ
    BYTE byVoiceInChanNum;   //Ƶͨ 
    BYTE byStartVoiceInChanNo; //Ƶʼͨ 0ʾЧ
    BYTE  bySupport5;  //λʾ,0-֧,1-֧,bit0-ֶ֧
    //bySupport5 &0x01ʾ֧wEventTypeEx ,dwEventType ¼֧ͣΪ¼չ--ռסֹͻ
    //bySupport5 &0x04ʾǷ֧ʹչĳģʽӿ
    /*
       bySupport5 &0x08 豸ظֵʾǷּ֧ƻ¼V40ӿЭ(DVR_SET_RECORDCFG_V40/ DVR_GET_RECORDCFG_V40)(ڸЭ豸֧13)
       ֮ǰĲַ豸֧¼13¼13֧֣ͳһת¼3ݴSDKͨ̽⴦)
    */
    BYTE  bySupport6;   //λʾ0-֧,1-֧
    //bySupport6 0x1  ʾ豸Ƿ֧ѹ 
    //bySupport6 0x2 ʾǷ֧IDʽԴչDVR_SET_STREAM_SRC_INFO_V40
    //bySupport6 0x4 ʾǷ֧¼V40ӿ
    //bySupport6 0x8 ʾǷ֧չ
    //bySupport6 0x40ʾͼƬѯV40չ
    BYTE  byMirrorChanNum;    //ͨ<¼ڱʾͨ>
    WORD wStartMirrorChanNo;  //ʼͨ
    BYTE bySupport7;   //,λʾ,0-֧,1-֧
    // bySupport7 & 0x1  ʾ豸Ƿ֧ INTER_VCA_RULECFG_V42 չ
    // bySupport7 & 0x2  ʾ豸Ƿ֧ IPC HVT ģʽչ
    // bySupport7 & 0x04  ʾ豸Ƿ֧ ʱ
    // bySupport7 & 0x08  ʾ̨PTZλʱǷִ֧ͨ
    // bySupport7 & 0x10  ʾ豸Ƿ֧˫ϵͳ
    // bySupport7 & 0x20  ʾ豸Ƿ֧ OSDַ V50
    // bySupport7 & 0x40  ʾ豸Ƿ֧ Ӹ٣
    // bySupport7 & 0x80  ʾ豸Ƿ֧ ļ
    BYTE  byRes2;        //
}NET_DVR_DEVICEINFO_V30, *LPNET_DVR_DEVICEINFO_V30;

typedef struct tagNET_DVR_DEVICEINFO_V40
{
    NET_DVR_DEVICEINFO_V30 struDeviceV30;
    BYTE  bySupportLock;        //豸֧ܣֶSDK豸ֵֵġbySupportLockΪ1ʱdwSurplusLockTimebyRetryLoginTimeЧ
    BYTE  byRetryLoginTime;        //ʣɳԵ½Ĵûʱ˲Ч
    BYTE  byPasswordLevel;      //admin밲ȫȼ0-Ч1-Ĭ룬2-Ч,3-սϸߵ롣ûΪĬ루12345߷սϸߵʱϲͻҪʾû롣      
    BYTE  byRes1;
    DWORD dwSurplusLockTime;    //ʣʱ䣬λ룬ûʱ˲Ч
    BYTE  byCharEncodeType;     //ַ
    BYTE byRes2[255];
}NET_DVR_DEVICEINFO_V40, *LPNET_DVR_DEVICEINFO_V40;

typedef void (CALLBACK *fLoginResultCallBack) (LONG lUserID, DWORD dwResult, LPNET_DVR_DEVICEINFO_V30 lpDeviceInfo , void* pUser);

#define NET_DVR_DEV_ADDRESS_MAX_LEN 129
#define NET_DVR_LOGIN_USERNAME_MAX_LEN 64
#define NET_DVR_LOGIN_PASSWD_MAX_LEN 64


typedef struct  
{
    char sDeviceAddress[NET_DVR_DEV_ADDRESS_MAX_LEN];
    BYTE byRes1;
    WORD wPort;
    char sUserName[NET_DVR_LOGIN_USERNAME_MAX_LEN];
    char sPassword[NET_DVR_LOGIN_PASSWD_MAX_LEN];
    fLoginResultCallBack cbLoginResult;
    void *pUser;
    BOOL bUseAsynLogin;
    BYTE byProxyType; //0:ʹô1ʹñ׼2ʹEHome
    BYTE byUseUTCTime;    //0-תĬ,1-ӿȫʹUTCʱ,SDKUTCʱ豸ʱת,2-ӿȫʹƽ̨ʱ䣬SDKƽ̨ʱ豸ʱת
    BYTE byRes2[2];
    LONG iProxyID;    //ţӴϢʱӦķ±ֵ    
    BYTE byRes3[120];
}NET_DVR_USER_LOGIN_INFO,*LPNET_DVR_USER_LOGIN_INFO;

//sdk绷öٱԶ
typedef enum _SDK_NET_ENV
{
    LOCAL_AREA_NETWORK = 0,
        WIDE_AREA_NETWORK
}SDK_NETWORK_ENVIRONMENT;

//ʾģʽ
typedef enum
{
    NORMALMODE = 0,
        OVERLAYMODE
}DISPLAY_MODE;

//ģʽ
typedef enum
{
    PTOPTCPMODE = 0,
        PTOPUDPMODE,
        MULTIMODE,
        RTPMODE,
        RESERVEDMODE
}SEND_MODE;

//ץͼģʽ
typedef enum 
{
    BMP_MODE = 0,        //BMPģʽ
        JPEG_MODE = 1        //JPEGģʽ 
}CAPTURE_MODE;

//ʵʱģʽ
typedef enum
{
    MONOPOLIZE_MODE = 1,//ռģʽ
        SHARE_MODE = 2        //ģʽ
}REALSOUND_MODE;

//Ԥ
typedef struct
{
    LONG lChannel;//ͨ
    LONG lLinkMode;//λ(31)Ϊ0ʾΪ1ʾӣ030λʾӷʽ: 0TCPʽ,1UDPʽ,2ಥʽ,3 - RTPʽ4-RTP/RTSP,5-RSTP/HTTP 
    HWND hPlayWnd;//Ŵڵľ,ΪNULLʾͼ
    char* sMultiCastIP;//ಥַ
    BYTE byProtoType; //ӦòȡЭ飬0-˽Э飬1-RTSPЭ
    BYTE byRes[3];
}NET_DVR_CLIENTINFO, *LPNET_DVR_CLIENTINFO;

//SDK״̬Ϣ(9000)
typedef struct 
{
    DWORD dwTotalLoginNum;        //ǰloginû
    DWORD dwTotalRealPlayNum;    //ǰrealplay·
    DWORD dwTotalPlayBackNum;    //ǰطŻ·
    DWORD dwTotalAlarmChanNum;    //ǰͨ·
    DWORD dwTotalFormatNum;        //ǰӲ̸ʽ·
    DWORD dwTotalFileSearchNum;    //ǰ־ļ·
    DWORD dwTotalLogSearchNum;    //ǰ־ļ·
    DWORD dwTotalSerialNum;        //ǰ͸ͨ·
    DWORD dwTotalUpgradeNum;    //ǰ·
    DWORD dwTotalVoiceComNum;    //ǰת·
    DWORD dwTotalBroadCastNum;    //ǰ㲥·
    DWORD dwTotalListenNum;        //ǰ·
    DWORD dwEmailTestNum;       //ǰʼ·
    DWORD dwBackupNum;          // ǰļ·
    DWORD dwTotalInquestUploadNum; //ǰѶϴ·
    DWORD dwRes[6];
}NET_DVR_SDKSTATE, *LPNET_DVR_SDKSTATE;

//SDK֧Ϣ(9000)
typedef struct 
{
    DWORD dwMaxLoginNum;        //loginû MAX_LOGIN_USERS
    DWORD dwMaxRealPlayNum;        //realplay· WATCH_NUM
    DWORD dwMaxPlayBackNum;        //طŻ· WATCH_NUM
    DWORD dwMaxAlarmChanNum;    //ͨ· ALARM_NUM
    DWORD dwMaxFormatNum;        //Ӳ̸ʽ· SERVER_NUM
    DWORD dwMaxFileSearchNum;    //ļ· SERVER_NUM
    DWORD dwMaxLogSearchNum;    //־· SERVER_NUM
    DWORD dwMaxSerialNum;        //͸ͨ· SERVER_NUM
    DWORD dwMaxUpgradeNum;        //· SERVER_NUM
    DWORD dwMaxVoiceComNum;        //ת· SERVER_NUM
    DWORD dwMaxBroadCastNum;    //㲥· MAX_CASTNUM
    DWORD dwRes[10];
}NET_DVR_SDKABL, *LPNET_DVR_SDKABL;

//豸Ϣ
typedef struct
{   
    BYTE byUserIDValid;                 /* useridǷЧ 0-Ч1-Ч */
    BYTE bySerialValid;                 /* кǷЧ 0-Ч1-Ч */
    BYTE byVersionValid;                /* 汾ǷЧ 0-Ч1-Ч */
    BYTE byDeviceNameValid;             /* 豸ǷЧ 0-Ч1-Ч */
    BYTE byMacAddrValid;                /* MACַǷЧ 0-Ч1-Ч */    
    BYTE byLinkPortValid;               /* login˿ǷЧ 0-Ч1-Ч */
    BYTE byDeviceIPValid;               /* 豸IPǷЧ 0-Ч1-Ч */
    BYTE bySocketIPValid;               /* socket ipǷЧ 0-Ч1-Ч */
    LONG lUserID;                       /* NET_DVR_Login()ֵ, ʱЧ */
    BYTE sSerialNumber[SERIALNO_LEN];    /* к */
    DWORD dwDeviceVersion;                /* 汾Ϣ 16λʾ汾16λʾΰ汾*/
    char sDeviceName[NAME_LEN];            /* 豸 */
    BYTE byMacAddr[MACADDR_LEN];        /* MACַ */    
    WORD wLinkPort;                     /* link port */
    char sDeviceIP[128];                /* IPַ */
    char sSocketIP[128];                /* ϴʱsocket IPַ */
    BYTE byIpProtocol;                  /* IpЭ 0-IPV4, 1-IPV6 */
    BYTE byRes2[11];
}NET_DVR_ALARMER, *LPNET_DVR_ALARMER;

//Ӳʾ(ӽṹ)
typedef struct
{
    long bToScreen;
    long bToVideoOut;
    long nLeft;
    long nTop;
    long nWidth;
    long nHeight;
    long nReserved;
}NET_DVR_DISPLAY_PARA, *LPNET_DVR_DISPLAY_PARA;

//ӲԤ
typedef struct
{
    LONG lChannel;//ͨ
    LONG lLinkMode; //λ(31)Ϊ0ʾΪ1ʾӣ030λʾӷʽ:0TCPʽ,1UDPʽ,2ಥʽ,3 - RTPʽ4-绰ߣ5128k6256k7384k8512k
    char* sMultiCastIP;
    NET_DVR_DISPLAY_PARA struDisplayPara;
}NET_DVR_CARDINFO, *LPNET_DVR_CARDINFO;

//¼ļ
typedef struct 
{
    char sFileName[100];//ļ
    NET_DVR_TIME struStartTime;//ļĿʼʱ
    NET_DVR_TIME struStopTime;//ļĽʱ
    DWORD dwFileSize;//ļĴС
}NET_DVR_FIND_DATA, *LPNET_DVR_FIND_DATA;

//¼ļ(9000)
typedef struct 
{
    char sFileName[100];//ļ
    NET_DVR_TIME struStartTime;//ļĿʼʱ
    NET_DVR_TIME struStopTime;//ļĽʱ
    DWORD dwFileSize;//ļĴС
    char sCardNum[32];
    BYTE byLocked;//9000豸֧,1ʾļѾ,0ʾļ
    BYTE byFileType;  //ļ:0ʱ¼,1-ƶ 2
    //3-|ƶ 4-&ƶ 5- 6-ֶ¼,7𶯱8-9-ܱ10-PIR11-߱12-ȱ,14-ܽͨ¼
    BYTE byRes[2];
}NET_DVR_FINDDATA_V30, *LPNET_DVR_FINDDATA_V30;

//¼ļ(cvr)
typedef struct 
{
    char sFileName[100];//ļ
    NET_DVR_TIME struStartTime;//ļĿʼʱ
    NET_DVR_TIME struStopTime;//ļĽʱ
    DWORD dwFileSize;//ļĴС
    char sCardNum[32];
    BYTE byLocked;//9000豸֧,1ʾļѾ,0ʾļ
    BYTE byFileType;  //ļ:0ʱ¼,1-ƶ 2
    //3-|ƶ 4-&ƶ 5- 6-ֶ¼,7𶯱8-9-ܱ10-PIR11-߱12-ȱ,14-ܽͨ¼
    BYTE byQuickSearch; //0:ͨѯ1٣ѯ
    BYTE byRes;
    DWORD dwFileIndex; //ļ
    BYTE byStreamType;
    BYTE byRes1[127];    
}NET_DVR_FINDDATA_V40, *LPNET_DVR_FINDDATA_V40;

//¼ļ()
typedef struct 
{
    char sFileName[100];//ļ
    NET_DVR_TIME struStartTime;//ļĿʼʱ
    NET_DVR_TIME struStopTime;//ļĽʱ
    DWORD dwFileSize;//ļĴС
    char sCardNum[32];
}NET_DVR_FINDDATA_CARD, *LPNET_DVR_FINDDATA_CARD;


//¼ļṹ
typedef struct 
{
    LONG lChannel;//ͨ
    DWORD dwFileType;//¼ļ
       //ţ0xffȫ0ʱ¼,1-ƶ 23-|ƶ 4-&ƶ 5- 6-ֶ¼,7-¼10-PIR11-߱12-ȱ13-ȫ¼14-ܽͨ¼
    //ţ0xffȫ0ʱ¼1-ƶ⣬2ӽ345-6ֶ¼7𶯱8-9-ܱ10-PIR11-߱12-ȱ13-ȫ¼14-ܽͨ¼
    DWORD dwIsLocked;//Ƿ 0-ļ,1-ļ, 0xffʾļ
    DWORD dwUseCardNo;//Ƿʹÿ
    BYTE sCardNumber[32];//
    NET_DVR_TIME struStartTime;//ʼʱ
    NET_DVR_TIME struStopTime;//ʱ
}NET_DVR_FILECOND, *LPNET_DVR_FILECOND;

//̨ѡŴС(˽ ר)
typedef struct 
{
    int xTop;     //ʼx
    int yTop;     //y
    int xBottom;  //x
    int yBottom;  //y
    int bCounter; //
}NET_DVR_POINT_FRAME, *LPNET_DVR_POINT_FRAME;

//Խ
typedef struct tagNET_DVR_COMPRESSION_AUDIO
{
    BYTE  byAudioEncType;   //Ƶ 0-OggVorbis;1-G711_U;2-G711_A;5-MP2L2;6-G726;7-AAC,8-PCM
    BYTE  byAudioSamplingRate;//Ƶ 0-Ĭϣ1-16kHZ2-32kHZ3-48kHZ, 4- 44.1kHZ,5-8kHZ
    BYTE  byAudioBitRate;// Ƶ ο BITRATE_ENCODE_INDEX
    BYTE  byres[4];//ﱣƵѹ  
    BYTE  bySupport;//bySupport Bit0ʾ Mp2l2ǰ4ֽڵĺʾƵݳ 
}NET_DVR_COMPRESSION_AUDIO, *LPNET_DVR_COMPRESSION_AUDIO;

//2009-7-22


#define IW_ESSID_MAX_SIZE                         32
#define WIFI_WEP_MAX_KEY_COUNT                     4
#define WIFI_WEP_MAX_KEY_LENGTH                     33
#define WIFI_WPA_PSK_MAX_KEY_LENGTH                 63
#define WIFI_WPA_PSK_MIN_KEY_LENGTH                 8
#define WIFI_MAX_AP_COUNT                         20
#define WIFI_WPA_PSK_MAX_HEXKEY_LENGTH           68   //WPA16Կ󳤶

typedef struct tagNET_DVR_AP_INFO
{
    char  sSsid[IW_ESSID_MAX_SIZE];
    DWORD  dwMode;                        /* 0 mange ģʽ;1 ad-hocģʽμNICMODE */
    DWORD  dwSecurity;           /*0 ܣ1 wepܣ2 wpa-psk;3 wpa-Enterprise;4-WPA2_PSKμWIFISECURITY*/
    DWORD  dwChannel;            /*1-11ʾ11ͨ*/
    DWORD  dwSignalStrength;    /*0-100źΪǿ*/
    DWORD  dwSpeed;               /*,λ0.01mbps*/
}NET_DVR_AP_INFO,*LPNET_DVR_AP_INFO;

typedef struct tagNET_DVR_AP_INFO_LIST
{
    DWORD dwSize;
    DWORD dwCount;        /*AP20*/
    NET_DVR_AP_INFO struApInfo[WIFI_MAX_AP_COUNT];
}NET_DVR_AP_INFO_LIST,*LPNET_DVR_AP_INFO_LIST;

typedef struct tagNET_DVR_WIFIETHERNET
{    
    char sIpAddress[16];                /*IPַ*/
    char sIpMask[16];                    /**/    
    BYTE    byMACAddr[MACADDR_LEN];        /*ַֻʾ*/
    BYTE    byCloseWifi;        //Ƿرwifiӣ0-رգ1-ر
    BYTE    bRes;
    DWORD    dwEnableDhcp;                /*Ƿdhcp  0 1*/
    DWORD    dwAutoDns;                    /*dhcpǷԶȡdns,0Զȡ 1ԶȡdhcpĿǰԶȡdns*/    
    char sFirstDns[16];                         /*һdns*/
    char sSecondDns[16];                     /*ڶdns*/
    char sGatewayIpAddr[16];                 /* صַ*/
    BYTE   bRes2[8];
}NET_DVR_WIFIETHERNET,*LPNET_DVR_WIFIETHERNET;

typedef struct tagNET_DVR_WIFI_CFG_EX
{
    NET_DVR_WIFIETHERNET struEtherNet;        /*wifi*/
    char sEssid[IW_ESSID_MAX_SIZE];     /*SSID*/
    DWORD dwMode;      /* 0 mange ģʽ;1 ad-hocģʽμ*/
    DWORD dwSecurity; /*0-;1-WEP;2-WPA-personal; 3-WPA-enterprise;4-WPA2-personal;5-WPA2-enterprise */
    union 
    {
        struct 
        {
            DWORD dwAuthentication;/*0 -ʽ 1-ʽ*/
            DWORD dwKeyLength;/* 0 -64λ1- 128λ2-152λ*/
            DWORD dwKeyType;/*0 16;1 ASCI */
            DWORD dwActive;/*0 0---3ʾһԿ*/
            char sKeyInfo[WIFI_WEP_MAX_KEY_COUNT][WIFI_WEP_MAX_KEY_LENGTH];
        }wep;
        struct 
        {
            DWORD dwKeyLength;/*8-63ASCIIַ*/
            char sKeyInfo[WIFI_WPA_PSK_MAX_KEY_LENGTH];
            BYTE byEncryptType;  /*WPA/WPA2ģʽ¼,0-AES, 1-TKIP*/
            char sNewKeyInfo[WIFI_WPA_PSK_MAX_HEXKEY_LENGTH/*68*/];//Կ֧8-63ASCIIַԼ64ʮַԿ
            //byKeyTypeΪ0ʱsKeyInfobyKeyTypeΪ1ʱsNewKeyInfo
            //Կͣ0 ~ Կֻ֧ͣ8-63ASCIIַ1 ~Կ֧ͣ8-63ASCIIַԼ64ʮַԿ
            BYTE byKeyType; 
            BYTE byRes[7];
        }wpa_psk;
        struct 
        {
            BYTE byEncryptType;  /*,0-AES, 1-TKIP*/
            BYTE byAuthType; //֤ͣ0-EAP_TTLS,1-EAP_PEAP,2-EAP_TLS
            BYTE byRes[2];
            union
            {
                struct 
                {
                    BYTE byEapolVersion; //EAPOL汾0-汾11-汾2
                    BYTE byAuthType; //ڲ֤ʽ0-PAP1-MSCHAPV2
                    BYTE byRes1[2];
                    BYTE byAnonyIdentity [NAME_LEN]; //
                    BYTE byUserName[NAME_LEN]; //û
                    BYTE byPassword[NAME_LEN]; //
                    BYTE byRes[44];
                }EAP_TTLS; //WPA-enterprise/WPA2-enterprisģʽ
                struct 
                {
                    BYTE byEapolVersion; //EAPOL汾0-汾11-汾2
                    BYTE byAuthType; //ڲ֤ʽ0-GTC1-MD52-MSCHAPV2
                    BYTE byPeapVersion; //PEAP汾0-汾01-汾1
                    BYTE byPeapLabel; //PEAPǩ0-ϱǩ1-±ǩ
                    BYTE byAnonyIdentity[NAME_LEN]; //
                    BYTE byUserName[NAME_LEN]; //û
                    BYTE byPassword[NAME_LEN]; //
                    BYTE byRes[44]; 
                }EAP_PEAP; //WPA-enterprise/WPA2-enterprisģʽ
                struct 
                {
                    BYTE byEapolVersion; //EAPOL汾0-汾11-汾2
                    BYTE byRes1[3]; 
                    BYTE byIdentity[NAME_LEN]; //
                    BYTE byPrivateKeyPswd[NAME_LEN]; //˽Կ
                    BYTE byRes[76]; 
                }EAP_TLS; 
            }auth_param;
        }wpa_wpa2; //WPA-enterprise/WPA2-enterprisģʽ
    }key;    
}NET_DVR_WIFI_CFG_EX,*LPNET_DVR_WIFI_CFG_EX;

//wifiýṹ
typedef struct tagNET_DVR_WIFI_CFG
{
    DWORD dwSize;
    NET_DVR_WIFI_CFG_EX struWifiCfg;
}NET_DVR_WIFI_CFG,*LPNET_DVR_WIFI_CFG;

//wifi״̬
typedef     struct  tagNET_DVR_WIFI_CONNECT_STATUS
{
    DWORD        dwSize;
    BYTE        byCurStatus;    //1-ӣ2-δӣ3-
    BYTE        byRes1[3];        //
    DWORD        dwErrorCode;    // byCurStatus = 2ʱЧ,1-û,2-޴·,3-δ֪
    BYTE        byRes[244];
}NET_DVR_WIFI_CONNECT_STATUS,*LPNET_DVR_WIFI_CONNECT_STATUS;

//wifiģʽ
typedef struct tagNET_DVR_WIFI_WORKMODE
{
    DWORD dwSize;
    DWORD dwNetworkInterfaceMode; /*0 Զлģʽ1 ģʽ*/
}NET_DVR_WIFI_WORKMODE,*LPNET_DVR_WIFI_WORKMODE;

//ṹ궨 
#define VCA_MAX_POLYGON_POINT_NUM        10        //֧10Ķ
#define MAX_RULE_NUM                    8        //
#define MAX_RULE_NUM_V42                16      //չ
#define MAX_TARGET_NUM                    30        //Ŀ
#define MAX_CALIB_PT                     6        //궨
#define MIN_CALIB_PT                     4        //С궨
#define MAX_TIMESEGMENT_2                2        //ʱ
#define DATA_INDEX_LEN                  64      //ˮ
#define MAX_TRAFFIC_PICTURE_NUM         8      //ͨͼƬ
#define MAX_LICENSE_LEN                    16        //ƺ󳤶
#define MAX_CARDNO_LEN                  48      //󳤶 2013-11-04
#define MAX_OPERATE_INDEX_LEN           32      //󳤶2014-03-03
#define MAX_PLATE_NUM                    3        //Ƹ
#define MAX_MASK_REGION_NUM                4       //ĸ
#define MAX_SEGMENT_NUM                    6       //궨Ŀ
#define MIN_SEGMENT_NUM                    3       //궨СĿ
#define MAX_REL_SNAPCHAN_NUM            3       //ץͼͨ
#define MAX_PIC_SWITCH_STORAGE_SERVER   64      //ƴ洢洢ͼƬ
#define MAX_INFO_SWITCH_STORAGE_SERVER  64      //ƴ洢洢󸽼Ϣ
#define RTMP_URL_LEN                    128     //RTMP URL 
#define MAX_ID_LEN_128                  128     //ļID
#define MAX_DEBUGCMD_LEN                1024    //豸󳤶
#define MAX_DEBUGINFO_LEN               1400    //豸Ϣ󳤶
#define MAX_VEHICLE_ID_LEN              32      //ʶ

//ܿϢ
#define MAX_VCA_CHAN  16//ͨ
typedef struct tagNET_VCA_CTRLINFO
{
    BYTE   byVCAEnable;        //Ƿ
    BYTE   byVCAType;        //ͣVCA_CHAN_ABILITY_TYPE 
    BYTE   byStreamWithVCA; //ǷϢ
    BYTE   byMode;            //ģʽATMʱVCA_CHAN_MODE_TYPE ,TFSʱTFS_CHAN_MODE_TYPE
    BYTE   byControlType;   //ͣλʾ0-1-
    // byControlType &1 ǷץĹ
    BYTE   byPicWithVCA ;// ץͼĿϢ(Ŀ)0-ӣĬϣ1-ӣ
    BYTE   byRes[2];         //Ϊ0 
}NET_VCA_CTRLINFO, * LPNET_VCA_CTRLINFO;

//ܿϢṹ
typedef struct tagNET_VCA_CTRLCFG
{
    DWORD dwSize;
    NET_VCA_CTRLINFO  struCtrlInfo[MAX_VCA_CHAN];     //Ϣ,0Ӧ豸ʼͨ
    BYTE byRes[16];
}NET_VCA_CTRLCFG, * LPNET_VCA_CTRLCFG;

//豸
typedef struct tagNET_VCA_DEV_ABILITY
{
    DWORD dwSize;              //ṹ
    BYTE byVCAChanNum;         //ͨ
    BYTE byPlateChanNum;       //ͨ
    BYTE byBBaseChanNum;       //Ϊ
    BYTE byBAdvanceChanNum;    //Ϊ߼
    BYTE byBFullChanNum;       //Ϊ
    BYTE byATMChanNum;           //ATM
    BYTE byPDCChanNum;         //ͳͨ
    BYTE byITSChanNum;         //ͨ¼ͨ
    BYTE byBPrisonChanNum;     //Ϊ()ͨ
    BYTE byFSnapChanNum;       //ץͨ
    BYTE byFSnapRecogChanNum;  //ץĺʶͨ
    BYTE byFRetrievalChanNum;  //
    BYTE bySupport;            //λΪ0ʾ֧֣1ʾ֧
    //bySupport & 0x1ʾǷ֧ܸ 2012-3-22
    //bySupport & 0x2ʾǷ֧128·ȡչ2012-12-27
    BYTE byFRecogChanNum;      //ʶͨ
    BYTE byBPPerimeterChanNum; //Ϊ(ܽ)ͨ
    BYTE byTPSChanNum;         //ͨյͨ
    BYTE byTFSChanNum;         //·Υȡ֤ͨ
    BYTE byFSnapBFullChanNum;  //ץĺΪͨ
    BYTE byHeatMapChanNum;     //ȶͼͨ
    BYTE bySmartVehicleNum;    //SMART¼+ͨ
    BYTE bySmartHVTNum;       //SMART¼+мͨ
    BYTE bySmartNum;          //SMART¼
    BYTE byVehicleNum;        //ͨ
    BYTE bySmartRoadDetectionNum ; // SMART¼+·ͨ
    BYTE bySmartFaceDetectionNum ; // SMART¼+ͨ
    BYTE bySmartHeatMapNum ; // SMART¼+ȶͼͨ
    BYTE byRes[14];
}NET_VCA_DEV_ABILITY, *LPNET_VCA_DEV_ABILITY;


//Ϊ
typedef enum _VCA_ABILITY_TYPE_
{
    TRAVERSE_PLANE_ABILITY      = 0x01,       //Խ
        ENTER_AREA_ABILITY          = 0x02,       //
        EXIT_AREA_ABILITY           = 0x04,       //뿪
        INTRUSION_ABILITY           = 0x08,       //
        LOITER_ABILITY              = 0x10,       //ǻ
        LEFT_TAKE_ABILITY           = 0x20,       //Ʒȡ
        PARKING_ABILITY             = 0x40,       //ͣ
        RUN_ABILITY                 = 0x80,       //ƶ
        HIGH_DENSITY_ABILITY        = 0x100,      //Աۼ
        LF_TRACK_ABILITY            = 0x200,      //
        VIOLENT_MOTION_ABILITY        = 0x400,      //˶
        REACH_HIGHT_ABILITY            = 0x800,      //ʸ߼
        GET_UP_ABILITY                = 0x1000,     //
        LEFT_ABILITY                = 0x2000,     //Ʒ
        TAKE_ABILITY                = 0x4000,     //Ʒȡ
        LEAVE_POSITION              = 0x8000,     //
        TRAIL_ABILITY               = 0x10000,    //β 
        KEY_PERSON_GET_UP_ABILITY   = 0x20000,    //صԱ
        STANDUP_ABILITY             = 0x40000,   //
        FALL_DOWN_ABILITY           = 0x80000,    //
        AUDIO_ABNORMAL_ABILITY      = 0x100000,   //ǿͻ
        ADV_REACH_HEIGHT_ABILITY    = 0x200000,   //ʸ
        TOILET_TARRY_ABILITY        = 0x400000,   //޳ʱ
        YARD_TARRY_ABILITY          = 0x800000,   //ŷ糡
        ADV_TRAVERSE_PLANE_ABILITY  = 0x1000000,  //߾
        LECTURE_ABILITY                = 0x2000000,  //ڿ
        ANSWER_ABILITY                = 0x4000000,  //ش
        HUMAN_ENTER_ABILITY         = 0x10000000, //˿ATM ,ֻATM_PANELģʽ֧
        OVER_TIME_ABILITY           = 0x20000000, //ʱ,ֻATM_PANELģʽ֧
        STICK_UP_ABILITY            = 0x40000000, //ֽ
        INSTALL_SCANNER_ABILITY     = 0x80000000  //װ
}VCA_ABILITY_TYPE;

typedef enum _VCA_ABILITY_TYPE_EX_
{ 
    PEOPLENUM_CHANGE_ABILITY = 0x00000002, //仯
    SPACING_CHANGE_ABILITY = 0x00000004,    //仯
    EVENT_COMBINED_ABILITY = 0x00000008,    //¼
    EVENT_SIT_QUIETLY =        0x00000010,    //
    EVENT_HIGH_DENSITY_STATUS_ABILITY = 0x00000020    //Աۼ״̬
}VCA_ABILITY_TYPE_EX;

//ͨ
typedef enum _VCA_CHAN_ABILITY_TYPE_
{
    VCA_BEHAVIOR_BASE     =  1,          //Ϊ
    VCA_BEHAVIOR_ADVANCE  =  2,          //Ϊ߼
    VCA_BEHAVIOR_FULL     =  3,          //Ϊ
    VCA_PLATE               =  4,          //
    VCA_ATM               =  5,          //ATM
    VCA_PDC               =  6,          //ͳ
    VCA_ITS               =  7,          // ͨ¼
    VCA_BEHAVIOR_PRISON   =  8,          //Ϊ() 
    VCA_FACE_SNAP         =  9,          //ץ
    VCA_FACE_SNAPRECOG    = 10,          //ץĺʶ
    VCA_FACE_RETRIEVAL    = 11,          //
    VCA_FACE_RECOG        = 12,          //ʶ
    VCA_BEHAVIOR_PRISON_PERIMETER =  13, // Ϊ (ܽ)
    VCA_TPS               = 14,          //ͨյ
    VCA_TFS               = 15,          //·Υȡ֤
    VCA_BEHAVIOR_FACESNAP = 16,          //ץĺΪ
    VCA_HEATMAP           =  17,         //ȶͼ
    VCA_SMART_VEHICLE_DETECTION  =  18,  // SMART¼+
    VCA_SMART_HVT_DETECTION      =  19,  // SMART¼+м
    VCA_SMART_EVENT          =  20,      // SMART¼
    VCA_VEHICLE_DETECTION    =  21,      // 
    VCA_SMART_ROAD_DETECTION =  22,      // SMART¼+·
    VCA_SMART_FACE_DETECTION =  23,      // SMART¼+
    VCA_SMART_HEATMAP        =  24       // SMART¼+ȶͼ
}VCA_CHAN_ABILITY_TYPE;

//ATMģʽ(ATM)
typedef enum _VCA_CHAN_MODE_TYPE_
{
    VCA_ATM_PANEL     =  0,  //ATM
        VCA_ATM_SURROUND  =  1,  //ATM
        VCA_ATM_FACE      =  2,     //ATM
        VCA_ATM_SAFETYCABIN = 3  //ATM
}VCA_CHAN_MODE_TYPE;

//ͨȡ֤TFSͨģʽ(TFS)
typedef enum _TFS_CHAN_MODE_TYPE_
{
    TFS_CITYROAD    =  0,  //TFS е·
        TFS_FREEWAY     =  1   //TFS ٵ·
}TFS_CHAN_MODE_TYPE;

//Ϊģʽ
typedef enum _BEHAVIOR_SCENE_MODE_TYPE_
{
    BEHAVIOR_SCENE_DEFAULT = 0, //ϵͳĬ
        BEHAVIOR_SCENE_WALL = 1,    //Χǽ
        BEHAVIOR_SCENE_INDOOR = 2   //
}BEHAVIOR_SCENE_MODE_TYPE;

//ģʽ
typedef enum _BEHAVIOR_PRISON_MODE_TYPE_
{
    BEHAVIOR_PRISON                 = 0, //
        BEHAVIOR_HEARING                  = 1, //Ѷ
        BEHAVIOR_RECFIELD                 = 2  //ŷ糡
}BEHAVIOR_PRISON_MODE_TYPE,LPBEHAVIOR_PRISON_MODE_TYPE;


//ͨ
typedef struct tagNET_VCA_CHAN_IN_PARAM
{
    BYTE byVCAType;        //VCA_CHAN_ABILITY_TYPEöֵ
    BYTE byMode;        //ģʽATM ʱVCA_CHAN_MODE_TYPE,TFSʱTFS_CHAN_MODE_TYPE,VCA_TYPE Ϊͨ¼ʱTRAFFIC_SCENE_MODE
    BYTE byRes[2];         //Ϊ0 
}NET_VCA_CHAN_IN_PARAM, *LPNET_VCA_CHAN_IN_PARAM;


//Ϊṹ
typedef struct tagNET_VCA_BEHAVIOR_ABILITY
{
    DWORD dwSize;         //ṹ
    DWORD dwAbilityType; //ֵ֧ͣλʾVCA_ABILITY_TYPE
    BYTE  byMaxRuleNum;     //
    BYTE  byMaxTargetNum; //Ŀ
    BYTE  bySupport;        // ֵ֧Ĺ   λʾ  
    // bySupport & 0x01 ֱ֧궨
    BYTE  byRes[5];         //Ϊ0 
    DWORD dwAbilityTypeEx;  //ֵ֧ͣλʾVCA_ABILITY_TYPE_EX
}NET_VCA_BEHAVIOR_ABILITY, *LPNET_VCA_BEHAVIOR_ABILITY;

//ݸ²
typedef struct tagNET_DVR_SCENE_CHANGE_UPDATE_PARAM
{
    DWORD    dwSize;
    BYTE    byIDCount;    //ʵID
    BYTE    byRes1[3];
    BYTE    byStreamID[MAX_STREAM_ID_NUM][STREAM_ID_LEN];
    BYTE    byRes[256];
}NET_DVR_SCENE_CHANGE_UPDATE_PARAM, *LPNET_DVR_SCENE_CHANGE_UPDATE_PARAM;

// ͨṹ
typedef struct tagNET_DVR_ITS_ABILITY
{
    DWORD     dwSize;             // ṹС
    DWORD     dwAbilityType;      // ֵ֧б  ITS_ABILITY_TYPE
    BYTE     byMaxRuleNum;         //
    BYTE     byMaxTargetNum;     //Ŀ
       BYTE    byRes[10];            // 
}NET_DVR_ITS_ABILITY, *LPNET_DVR_ITS_ABILITY;

/***********************************end*******************************************/

/************************************ܲṹ*********************************/
//ܹýṹ
//ֵһ,ֵΪǰİٷֱȴС, ΪСλ

//ṹ
typedef struct tagNET_VCA_RECT
{
    float fX;               //߽ϽǵX, 0.001~1
    float fY;               //߽ϽǵY, 0.001~1
    float fWidth;           //߽Ŀ, 0.001~1
    float fHeight;          //߽ĸ߶, 0.001~1
}NET_VCA_RECT, *LPNET_VCA_RECT;

//Ϊ¼
typedef enum _VCA_EVENT_TYPE_
{
    VCA_TRAVERSE_PLANE     = 0x1,        //Խ
        VCA_ENTER_AREA         = 0x2,        //Ŀ,֧
        VCA_EXIT_AREA           = 0x4,        //Ŀ뿪,֧
        VCA_INTRUSION          = 0x8,        //ܽ,֧
        VCA_LOITER             = 0x10,       //ǻ,֧
        VCA_LEFT_TAKE          = 0x20,       //Ʒȡ,֧
        VCA_PARKING               = 0x40,       //ͣ,֧
        VCA_RUN                   = 0x80,       //ƶ,֧
        VCA_HIGH_DENSITY       = 0x100,      //Աۼ,֧
        VCA_VIOLENT_MOTION     = 0x200,         //˶
        VCA_REACH_HIGHT        = 0x400,         //ʸ߼
        VCA_GET_UP             = 0x800,         //
        VCA_LEFT               = 0x1000,     //Ʒ
        VCA_TAKE               = 0x2000,     //Ʒȡ
        VCA_LEAVE_POSITION     = 0x4000,     //
        VCA_TRAIL              = 0x8000,     //β
        VCA_KEY_PERSON_GET_UP  = 0x10000,    //صԱ
        VCA_STANDUP            = 0x20000,    //
        VCA_FALL_DOWN          = 0x80000,    //ؼ
        VCA_AUDIO_ABNORMAL     = 0x100000,   //ǿͻ
        VCA_ADV_REACH_HEIGHT   = 0x200000,   //ʸ
        VCA_TOILET_TARRY       = 0x400000,   //޳ʱ
        VCA_YARD_TARRY         = 0x800000,   //ŷ糡
        VCA_ADV_TRAVERSE_PLANE = 0x1000000,  //߾
        VCA_LECTURE            = 0x2000000,  //ڿ
        VCA_ANSWER             = 0x4000000,  //ش
        VCA_HUMAN_ENTER        = 0x10000000, //˿ATM           ֻATM_PANELģʽ֧
        VCA_OVER_TIME          = 0x20000000, //ʱ            ֻATM_PANELģʽ֧
        VCA_STICK_UP           = 0x40000000, //ֽ,֧
        VCA_INSTALL_SCANNER    = 0x80000000  //װ,֧
}VCA_EVENT_TYPE;

//Ϊ¼չ
typedef enum _VCA_RULE_EVENT_TYPE_EX_
{
    ENUM_VCA_EVENT_TRAVERSE_PLANE     = 1,   //Խ
        ENUM_VCA_EVENT_ENTER_AREA         = 2,   //Ŀ,֧
        ENUM_VCA_EVENT_EXIT_AREA          = 3,   //Ŀ뿪,֧
        ENUM_VCA_EVENT_INTRUSION          = 4,   //ܽ,֧
        ENUM_VCA_EVENT_LOITER             = 5,   //ǻ,֧
        ENUM_VCA_EVENT_LEFT_TAKE          = 6,   //Ʒȡ,֧
        ENUM_VCA_EVENT_PARKING            = 7,   //ͣ,֧
        ENUM_VCA_EVENT_RUN                = 8,   //ƶ,֧
        ENUM_VCA_EVENT_HIGH_DENSITY       = 9,   //Աۼ,֧
        ENUM_VCA_EVENT_VIOLENT_MOTION     = 10,  //˶
        ENUM_VCA_EVENT_REACH_HIGHT        = 11,  //ʸ߼
        ENUM_VCA_EVENT_GET_UP             = 12,  //
        ENUM_VCA_EVENT_LEFT               = 13,  //Ʒ
        ENUM_VCA_EVENT_TAKE               = 14,  //Ʒȡ
        ENUM_VCA_EVENT_LEAVE_POSITION     = 15,  //
        ENUM_VCA_EVENT_TRAIL              = 16,  //β
        ENUM_VCA_EVENT_KEY_PERSON_GET_UP  = 17,  //صԱ
        ENUM_VCA_EVENT_STANDUP            = 18,  //
        ENUM_VCA_EVENT_FALL_DOWN          = 20,  //ؼ
        ENUM_VCA_EVENT_AUDIO_ABNORMAL     = 21,  //ǿͻ
        ENUM_VCA_EVENT_ADV_REACH_HEIGHT   = 22,  //ʸ
        ENUM_VCA_EVENT_TOILET_TARRY       = 23,  //޳ʱ
        ENUM_VCA_EVENT_YARD_TARRY         = 24,  //ŷ糡
        ENUM_VCA_EVENT_ADV_TRAVERSE_PLANE = 25,  //߾
        ENUM_VCA_EVENT_LECTURE            = 26,  //ڿΣḶ̌
        ENUM_VCA_EVENT_ANSWER             = 27,  //ش⣨Ḷ̌
        ENUM_VCA_EVENT_HUMAN_ENTER        = 29,  //˿ATM,ֻATM_PANELģʽ֧   
        ENUM_VCA_EVENT_OVER_TIME          = 30,  //ʱ,ֻATM_PANELģʽ֧
        ENUM_VCA_EVENT_STICK_UP           = 31,  //ֽ,֧
        ENUM_VCA_EVENT_INSTALL_SCANNER    = 32,  //װ,֧
        ENUM_VCA_EVENT_PEOPLENUM_CHANGE   = 35,  //仯¼
        ENUM_VCA_EVENT_SPACING_CHANGE     = 36,  //仯¼
        ENUM_VCA_EVENT_COMBINED_RULE      = 37,   //Ϲ¼
        ENUM_VCA_EVENT_SIT_QUIETLY        = 38,   //һ    ¼
        ENUM_VCA_EVENT_HIGH_DENSITY_STATUS= 39   //Աۼ״̬
} VCA_RULE_EVENT_TYPE_EX;

//洩Խ
typedef enum _VCA_CROSS_DIRECTION_
{
    VCA_BOTH_DIRECTION,  // ˫ 
        VCA_LEFT_GO_RIGHT,   //  
        VCA_RIGHT_GO_LEFT    //  
}VCA_CROSS_DIRECTION;

//߽ṹ
typedef struct tagNET_VCA_LINE
{
    NET_VCA_POINT struStart;    // 
    NET_VCA_POINT struEnd;      //յ
}NET_VCA_LINE, *LPNET_VCA_LINE;

//ͽṹ
typedef struct tagNET_VCA_POLYGON
{
    DWORD dwPointNum;                                  //Ч ڵ33һΪЧ߽ΪЧ 
    NET_VCA_POINT  struPos[VCA_MAX_POLYGON_POINT_NUM]; //α߽,ʮ 
}NET_VCA_POLYGON, *LPNET_VCA_POLYGON;

//
typedef struct tagNET_VCA_TRAVERSE_PLANE
{    
    NET_VCA_LINE struPlaneBottom;          //ױ
    VCA_CROSS_DIRECTION dwCrossDirection;  //Խ: 0-˫1-ң2-ҵ
    BYTE bySensitivity;                    //ȲΧ[1,5]
    BYTE byPlaneHeight;                    //߶
    BYTE byDetectionTarget;    //0-Ŀ꣬1-ˣ2-
    BYTE byRes2[37];                       //
}NET_VCA_TRAVERSE_PLANE, *LPNET_VCA_TRAVERSE_PLANE;

typedef struct tagNET_VCA_SIT_QUIETLY
{
    NET_VCA_POLYGON struRegion;//Χ
    //򴥷˳0-˳򴥷1-˳򴥷
    DWORD   dwDuration;         //ʱ  λs Χ1-3600
    BYTE    byRes[4];
} NET_VCA_SIT_QUIETLY, *LPNET_VCA_SIT_QUIETLY;

///뿪
typedef struct tagNET_VCA_AREA
{
    NET_VCA_POLYGON struRegion;//Χ
    BYTE bySensitivity;        //ȲΧ[1,5]
    BYTE byDetectionTarget;    //0-Ŀ꣬1-ˣ2-
    BYTE byRes[6];
}NET_VCA_AREA, *LPNET_VCA_AREA;

//ݱӳʱʶдͼƬIOһ£1뷢һ
//ֲ
typedef struct tagNET_VCA_INTRUSION
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration;            //Ϊ¼ʱֵ: 1-120룬5룬жЧʱ  ATMϵͳдļֵΪ 1-1000
    BYTE bySensitivity;        //ȲΧ[1-100]
    BYTE byRate;               //ռȣδĿߴĿռıأһΪ
    BYTE byDetectionTarget;    //0-Ŀ꣬1-ˣ2-
    BYTE byRes[3];             //
}NET_VCA_INTRUSION, *LPNET_VCA_INTRUSION;

//ǻ
typedef struct tagNET_VCA_LOITER
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration; //ʱֵ1-120룬10
    BYTE bySensitivity;            //ȲΧ[1,5]
    BYTE byRes[5];
}NET_VCA_LOITER, *LPNET_VCA_LOITER;

//Ʒ/Ʒȡ
typedef struct tagNET_VCA_TAKE_LEFT
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration; //ʱֵ1-120룬10
    BYTE bySensitivity;            //ȲΧ[1,5]
    BYTE byRes[5];
}NET_VCA_TAKE_LEFT, *LPNET_VCA_TAKE_LEFT;

//ͣ
typedef struct tagNET_VCA_PARKING
{
    NET_VCA_POLYGON struRegion;    //Χ
    WORD wDuration;                //ʱֵ1-100룬10
    BYTE bySensitivity;            //ȲΧ[1,5]
    BYTE byRes[5];
}NET_VCA_PARKING, *LPNET_VCA_PARKING;

//ƶ
typedef struct tagNET_VCA_RUN
{
    NET_VCA_POLYGON struRegion;    //Χ
    float  fRunDistance;        //˿ƶ, Χ: [0.1, 1.00] ģʽ ʵģʽ(1,20)m/s
    BYTE bySensitivity;            //ȲΧ[1,5]
    BYTE byMode;     // 0 ģʽ  1 ʵģʽ
    BYTE byDetectionTarget;    //0-Ŀ꣬1-ˣ2-
    BYTE byRes;
}NET_VCA_RUN, *LPNET_VCA_RUN;

//Աۼ
typedef struct tagNET_VCA_HIGH_DENSITY
{
    NET_VCA_POLYGON struRegion;        //Χ
    float           fDensity;       //ۼ, Χ: [0.1, 1.0]
    BYTE            bySensitivity;    //ȲΧ[1,5]
    BYTE            byRes;          // ֽ
    WORD            wDuration;      // Աۼֵ 20-360s
}NET_VCA_HIGH_DENSITY, *LPNET_VCA_HIGH_DENSITY; 

//˶
typedef struct tagNET_VCA_VIOLENT_MOTION
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD  wDuration;           //˶ֵ1-50
    BYTE  bySensitivity;       //ȲΧ[1,5]
    BYTE  byMode;              //0-Ƶģʽ1-Ƶģʽ2-Ƶģʽ
    BYTE  byRes[4];            //
}NET_VCA_VIOLENT_MOTION, *LPNET_VCA_VIOLENT_MOTION; 

// ʸ߲
typedef struct tagNET_VCA_REACH_HIGHT
{
    NET_VCA_LINE struVcaLine;   //ʸ߾
    WORD wDuration; //ʸֵ߱1-120
    BYTE    byRes[6];           // ֽ
}NET_VCA_REACH_HIGHT, *LPNET_VCA_REACH_HIGHT;

// 𴲲
typedef struct tagNET_VCA_GET_UP
{
    NET_VCA_POLYGON struRegion; //Χ
    WORD    wDuration;            //𴲱ֵ1-100 
    BYTE    byMode;             //ģʽ,0-ͨģʽ,1-ߵģʽ,2-ͨģʽ
    BYTE    bySensitivity;      //ȲΧ[1,10]
    BYTE    byRes[4];            //ֽ
}NET_VCA_GET_UP, * LPNET_VCA_GET_UP;

// Ʒ
typedef struct tagNET_VCA_LEFT
{
    NET_VCA_POLYGON struRegion; // Χ
    WORD       wDuration;       // Ʒֵ 10-100
    BYTE       bySensitivity;   // ȲΧ[1,5] 
    BYTE       byRes[5];        // ֽ
}NET_VCA_LEFT, *LPNET_VCA_LEFT;

// Ʒȡ
typedef struct tagNET_VCA_TAKE
{
    NET_VCA_POLYGON struRegion;     // Χ
    WORD            wDuration;      // Ʒȡֵ10-100
    BYTE            bySensitivity;  // ȲΧ[1,5] 
    BYTE            byRes[5];       // ֽ
}NET_VCA_TAKE, *LPNET_VCA_TAKE;

typedef struct tagNET_VCA_OVER_TIME
{
    NET_VCA_POLYGON     struRegion;    // Χ
    WORD               wDuration;  // ʱֵ 4s-60000s
    BYTE   byRes[6];   // ֽ
}NET_VCA_OVER_TIME, *LPNET_VCA_OVER_TIME;

typedef struct tagNET_VCA_HUMAN_ENTER
{
    DWORD                dwRes[23];            //ֽ
}NET_VCA_HUMAN_ENTER, *LPNET_VCA_HUMAN_ENTER;

//ֽ
typedef struct tagNET_VCA_STICK_UP
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration; //ʱֵ4-60룬10
    BYTE  bySensitivity;       //ȲΧ[1,5]
    BYTE byRes[5];
}NET_VCA_STICK_UP, *LPNET_VCA_STICK_UP; 

//
typedef struct tagNET_VCA_SCANNER
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration; //ʱ䣺4-60
    BYTE bySensitivity;       //ȲΧ[1,5]
    BYTE byRes[5];
}NET_VCA_SCANNER, *LPNET_VCA_SCANNER; 

//¼
typedef struct tagNET_VCA_LEAVE_POSITION
{
    NET_VCA_POLYGON   struRegion; //Χ
    WORD   wLeaveDelay;  //˱ʱ䣬λsȡֵ1-1800
    WORD   wStaticDelay; //˯ʱ䣬λsȡֵ1-1800
    BYTE   byMode;       //ģʽ0-¼1-˯¼2-˯¼
    BYTE   byPersonType; //ֵͣ0-ֵڣ1-˫ֵ
    BYTE   byRes[2];     //
}NET_VCA_LEAVE_POSITION, *LPNET_VCA_LEAVE_POSITION;

//β
typedef struct tagNET_VCA_TRAIL
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD  wRes;      /*  */
    BYTE  bySensitivity;       /* ȲΧ[1,5] */
    BYTE  byRes[5];
}NET_VCA_TRAIL, *LPNET_VCA_TRAIL;

//ز
typedef struct tagNET_VCA_FALL_DOWN
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD  wDuration;      /* ¼ֵ 1-60s*/
    BYTE  bySensitivity;       /* ȲΧ[1,5] */
    BYTE  byHeightThreshold; //߶ֵΧ[0,250]Ĭ90λ
    BYTE  byRes[4];
}NET_VCA_FALL_DOWN, *LPNET_VCA_FALL_DOWN;

//
typedef struct tagNET_VCA_STANDUP
{
    NET_VCA_POLYGON  struRegion; //Χ
    BYTE  bySensitivity;     //ȲΧ[1,100]
    BYTE  byHeightThreshold; //߶ֵΧ[0,250]Ĭ130λ
    WORD  wDuration;         //¼ֵ[1,3600]Ĭ2λ
    BYTE  byRes[4];          //
}NET_VCA_STANDUP, *LPNET_VCA_STANDUP;


//仯
typedef struct tagNET_VCA_PEOPLENUM_CHANGE
{
    NET_VCA_POLYGON  struRegion; //Χ
    BYTE  bySensitivity;  //ȲΧ[1,100]
    BYTE  byPeopleNumThreshold; //ֵΧ[0,5]Ĭ1 
    BYTE  byDetectMode; //ⷽʽֵȽϡ1-ڣ2-Сڣ3-ڣ4-
    BYTE  byNoneStateEffective; //״̬ǷЧ0-Ч1-Ч
    WORD  wDuration;  //ʱֵ[1,3600]Ĭ2λ
    BYTE  byRes[2];   //
}NET_VCA_PEOPLENUM_CHANGE, *LPNET_VCA_PEOPLENUM_CHANGE;

//仯
typedef struct tagNET_VCA_SPACING_CHANGE
{
    NET_VCA_POLYGON  struRegion; //Χ
    float fSpacingThreshold; //ֵΧ[0,10.0]Ĭ1.0λ
    BYTE  bySensitivity;  //ȲΧ[1,100]
    BYTE  byDetectMode; //ⷽʽֵȽϡ1-ڣ2-С
    WORD  wDuration;  //ʱֵ[1,3600]Ĭ2λ
}NET_VCA_SPACING_CHANGE, *LPNET_VCA_SPACING_CHANGE;


//ǿͻ
typedef struct tagNET_VCA_AUDIO_ABNORMAL
{
    WORD wDecibel;       //ǿ
    BYTE bySensitivity;  //ȲΧ[1,100] 
    BYTE byAudioMode;    //ģʽ0-ȼ⣬1-ֱֵ⣬2-ֱֵ 
    BYTE byEnable;       //ʹܣǷ(ǿͻ䣬)
    BYTE byThreshold;    //ֵ[1,100]
    BYTE byRes[54];      //   
}NET_VCA_AUDIO_ABNORMAL, *LPNET_VCA_AUDIO_ABNORMAL;

//ǿ 2014-03-21
typedef struct tagNET_DVR_AUDIO_STEEP_DROP
{
    BYTE  bySensitivity;   /* ȲΧ[1,100] */
    BYTE  byEnable;        //ʹܣǷ(ǿͻ䣬)
    BYTE  byRes[6];    
}NET_DVR_AUDIO_STEEP_DROP, *LPNET_DVR_AUDIO_STEEP_DROP;


typedef struct tagNET_DVR_AUDIO_EXCEPTION
{
    DWORD                       dwSize;
    BYTE                        byEnableAudioInException;//ʹܣǷ
    BYTE                        byRes1[3];
    NET_VCA_AUDIO_ABNORMAL      struAudioAbnormal;  
    NET_DVR_SCHEDTIME            struAlarmSched[MAX_DAYS][MAX_TIMESEGMENT_V30]; //ʱ
    NET_DVR_HANDLEEXCEPTION_V40 struHandleException;     //쳣ʽ
    DWORD                       dwMaxRelRecordChanNum ;  //¼ͨ ֻ֧
    DWORD                       dwRelRecordChanNum ;     //¼ͨ  ʵֵ֧
    DWORD                       byRelRecordChan[MAX_CHANNUM_V30];
    NET_DVR_AUDIO_STEEP_DROP    struAudioSteepDrop;      //ǿ
    BYTE                        byRes2[24];
}NET_DVR_AUDIO_EXCEPTION, *LPNET_DVR_AUDIO_EXCEPTION;

typedef struct tagNET_VCA_TOILET_TARRY
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDelay;        //޳ʱʱ[1,3600]λ
    BYTE byRes[6];    
}NET_VCA_TOILET_TARRY, *LPNET_VCA_TOILET_TARRY;

typedef struct tagNET_VCA_YARD_TARRY
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDelay;        //ŷ糡ʱ[1,120]λ
    BYTE byRes[6];    
}NET_VCA_YARD_TARRY, *LPNET_VCA_YARD_TARRY;

typedef struct tagNET_VCA_ADV_REACH_HEIGHT
{
    NET_VCA_POLYGON struRegion; //ʸ
    DWORD   dwCrossDirection;   //Խ(VCA_CROSS_DIRECTION): 0-˫1-2-ҵ
    BYTE    byRes[4];            // ֽ
}NET_VCA_ADV_REACH_HEIGHT, * LPNET_VCA_ADV_REACH_HEIGHT;

typedef struct tagNET_VCA_ADV_TRAVERSE_PLANE
{
    NET_VCA_POLYGON struRegion; //
    DWORD   dwCrossDirection;   //Խ(VCA_CROSS_DIRECTION): 0-˫1-2-ҵ
    BYTE    bySensitivity;      //ȲΧ[1,5] 
    BYTE    byRes[3];            //ֽ
} NET_VCA_ADV_TRAVERSE_PLANE,*LPNET_VCA_ADV_TRAVERSE_PLANE;

typedef struct tagNET_VCA_LECTURE
{
    NET_VCA_POLYGON struRegion;//Χ
    WORD wDuration; //Ϊ¼ʱֵ: 1-10룬1룬жЧʱ
    BYTE bySensitivity; //ȲΧ[1-100]
    BYTE byAlarmState;//ֶֻν治ʾ0-,1-ʼ,2- 
    BYTE byTrackingMode ;//ģʽ0-Զ(Ĭ) , 1-ˮƽ, 2-ֱ
    BYTE byZoomMode;//䱶ģʽ, 0-̶(Ĭ), 1-Զ
    BYTE byZoomOver;//0-,1-䱶λ(ϴ¼Ϊлж)
    BYTE byRes;
}NET_VCA_LECTURE, *LPNET_VCA_LECTURE;

typedef struct tagNET_VCA_ANSWER
{
    NET_VCA_POLYGON struRegion;//Χ
    BYTE bySensitivity;//ȲΧ[1-100]
    BYTE byAlarmState;//ֶֻν治ʾ0-,1-ʼ,2-
    BYTE byZoomOver;//0-,1-䱶λ(ϴ¼Ϊлж)
    BYTE byRes[5];             //
}NET_VCA_ANSWER, *LPNET_VCA_ANSWER;

//ṹ
typedef struct tagNET_VCA_RELATE_RULE_PARAM
{   
    BYTE  byRuleID;  // 0-ʾ
    BYTE  byRes;  //
    WORD  wEventType;        //Ϊ¼ͣοVCA_RULE_EVENT_TYPE_EX
}NET_VCA_RELATE_RULE_PARAM,*LPNET_VCA_RELATE_RULE_PARAM;

typedef struct tagNET_VCA_COMBINED_RULE_
{
    //򴥷˳0-˳򴥷1-˳򴥷
    BYTE    byRuleSequence; 
    BYTE    byRes[7];
    DWORD  dwMinInterval;    //Сʱλ
    DWORD  dwMaxInterval;  //ʱλ
    NET_VCA_RELATE_RULE_PARAM  struRule1Raram;//1
    NET_VCA_RELATE_RULE_PARAM  struRule2Raram;//2
    BYTE    byRes1[36];
} NET_VCA_COMBINED_RULE, *LPNET_VCA_COMBINED_RULE;

//Աۼ״̬
typedef struct tagNET_VCA_HIGH_DENSITY_STATUS
{
    NET_VCA_POLYGON struRegion;        //Χ
    float           fDensity;       //ۼ, Χ: [0.1, 1.0]
    BYTE            bySensitivity;    //ȲΧ[1,5]
    BYTE            byRes[3];          // ֽ
}NET_VCA_HIGH_DENSITY_STATUS, *LPNET_VCA_HIGH_DENSITY_STATUS; 


//¼
typedef union tagNET_VCA_EVENT_UNION
{
    DWORD                      uLen[23];            //
    NET_VCA_TRAVERSE_PLANE     struTraversePlane;   //Խ 
    NET_VCA_AREA               struArea;            ///뿪
    NET_VCA_INTRUSION          struIntrusion;       //ֲ
    NET_VCA_LOITER             struLoiter;          //ǻ
    NET_VCA_TAKE_LEFT          struTakeTeft;        //Ʒ/Ʒȡ
    NET_VCA_PARKING            struParking;            //ͣ
    NET_VCA_RUN                struRun;                //ƶ
    NET_VCA_HIGH_DENSITY       struHighDensity;        //Աۼ  
    NET_VCA_VIOLENT_MOTION     struViolentMotion;    //˶
    NET_VCA_REACH_HIGHT           struReachHight;      //ʸ
    NET_VCA_GET_UP               struGetUp;           //
    NET_VCA_LEFT               struLeft;            //Ʒ
    NET_VCA_TAKE               struTake;            // Ʒȡ
    NET_VCA_HUMAN_ENTER        struHumanEnter;      //Ա
    NET_VCA_OVER_TIME          struOvertime;        //ʱ
    NET_VCA_STICK_UP            struStickUp;            //ֽ
    NET_VCA_SCANNER            struScanner;            //     
    NET_VCA_LEAVE_POSITION     struLeavePos;        //ڲ
    NET_VCA_TRAIL              struTrail;           //β
    NET_VCA_FALL_DOWN          struFallDown;        //ز
    NET_VCA_AUDIO_ABNORMAL     struAudioAbnormal;   //ǿͻ
    NET_VCA_ADV_REACH_HEIGHT   struReachHeight;     //ʸ߲
    NET_VCA_TOILET_TARRY       struToiletTarry;     //޳ʱ
    NET_VCA_YARD_TARRY         struYardTarry;       //ŷ糡
    NET_VCA_ADV_TRAVERSE_PLANE struAdvTraversePlane;//߾
    NET_VCA_LECTURE            struLecture;            //ڿ¼
    NET_VCA_ANSWER             struAnswer;            //ش¼
    NET_VCA_STANDUP               struStandUp;         //
    NET_VCA_PEOPLENUM_CHANGE   struPeopleNumChange; //仯
    NET_VCA_SPACING_CHANGE     struSpacingChange;   //仯
    NET_VCA_COMBINED_RULE      struCombinedRule;    //Ϲ
    NET_VCA_SIT_QUIETLY        struSitQuietly;      //
    NET_VCA_HIGH_DENSITY_STATUS       struHighDensityStatus;        //Աۼ״̬ 
}NET_VCA_EVENT_UNION, *LPNET_VCA_EVENT_UNION;

// ߴ
typedef enum _VCA_SIZE_FILTER_MODE_
{
    IMAGE_PIX_MODE, //شС
        REAL_WORLD_MODE, //ʵʴС
        DEFAULT_MODE     // Ĭģʽ
}SIZE_FILTER_MODE;
//ߴ
typedef struct tagNET_VCA_SIZE_FILTER
{
    BYTE    byActive;            //Ƿ񼤻ߴ 0- 0-
    BYTE    byMode;         //ģʽSIZE_FILTER_MODE
    BYTE    byRes[2];        //0
    NET_VCA_RECT struMiniRect;    //СĿ,ȫ0ʾ
    NET_VCA_RECT struMaxRect;      //Ŀ,ȫ0ʾ
}NET_VCA_SIZE_FILTER, *LPNET_VCA_SIZE_FILTER;

//ṹ
typedef struct tagNET_VCA_ONE_RULE
{
    BYTE   byActive;                    //Ƿ񼤻,0-,0-
    BYTE   byRes[7];                     //Ϊ0ֶ
    BYTE   byRuleName[NAME_LEN];        //
    VCA_EVENT_TYPE dwEventType;            //Ϊ¼
    NET_VCA_EVENT_UNION uEventParam;    //Ϊ¼
    NET_VCA_SIZE_FILTER  struSizeFilter;  //ߴ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //ʽ 
    BYTE byRelRecordChan[MAX_CHANNUM_V30];            //¼ͨ,Ϊ1ʾͨ
}NET_VCA_ONE_RULE, *LPNET_VCA_ONE_RULE;

//Ϊýṹ
typedef struct tagNET_VCA_RULECFG
{
    DWORD  dwSize;            //ṹ
    BYTE   byPicProType;    //ʱͼƬʽ 0- 0-ϴ
    BYTE   byUpLastAlarm; //2011-04-06 Ƿϴһεı
    BYTE   byPicRecordEnable;  /*2012-3-1ǷͼƬ洢, 0-, 1-*/
    BYTE   byRes;
    NET_DVR_JPEGPARA  struPictureParam;         //ͼƬṹ
    NET_VCA_ONE_RULE  struRule[MAX_RULE_NUM];  //
}NET_VCA_RULECFG, *LPNET_VCA_RULECFG;

//ǰ豸ַϢܷǱʾǰ豸ĵַϢ豸ʾĵַ
/*
豸ģͨ(IPC/DVR/DVS/IVMS)ʱֶд豸IPַ˿ڣbyChannelbyIvmsChannel Ϊǰģͨ
eg:
struDevIP =  ģͨӦ豸IPַ
wPort  =  ģͨӦ豸Ķ˿
byChannel =  Ӧģͨͨ
byIvmsChannel = Ӧģͨͨ

  豸ͨ(DVR/DVS/IVMS)ʱֶдͨ豸IPַ˿ڣbyChannelΪͨ豸ͨţbyIvmsChannelΪͨ
  eg:
  struDevIP =  ͨ豸IPַ
  wPort  =  ͨ豸Ķ˿
  byChannel =  ͨ豸ͨ
  byIvmsChannel = ͨ    
*/
typedef struct tagNET_VCA_DEV_INFO
{
    NET_DVR_IPADDR  struDevIP; //ǰ豸ַ 
    WORD wPort;             //ǰ豸˿ںţ 
    BYTE byChannel;          //ǰ豸ͨ 
    BYTE byIvmsChannel;        // Ivms ͨ 
}NET_VCA_DEV_INFO, *LPNET_VCA_DEV_INFO;

typedef struct tagNET_DVR_TARGET_LEFT_REGION_ALARM
{
    DWORD     dwSize; //ṹС
    DWORD     dwRelativeTime; //ʱ
    DWORD        dwAbsTime; //ʱ
    NET_VCA_DEV_INFO  struDevInfo;   //ǰ豸Ϣ
    BYTE     byTargetType;//Ŀ 0-ЧĿ꣬1-ʦ    
    BYTE     byLeftDirection;//Ŀ뿪0-,1-,2-,3-,4-
    BYTE     byRes[126];
}NET_DVR_TARGET_LEFT_REGION_ALARM,*LPNET_DVR_TARGET_LEFT_REGION_ALARM;

//ߴ˲
typedef struct tagNET_VCA_FILTER_STRATEGY
{
    BYTE    byStrategy;      //ߴ˲ 0 -  1-߶ȺͿȹ,2-
    BYTE    byRes[11];       //
}NET_VCA_FILTER_STRATEGY,*LPNET_VCA_FILTER_STRATEGY;

//򴥷
typedef struct tagNET_VCA_RULE_TRIGGER_PARAM
{
    BYTE   byTriggerMode;   //Ĵʽ0- ã1- 켣 2- Ŀ 
    BYTE   byTriggerPoint;  //㣬ʽΪ켣ʱЧ 0- ,1-,2-
    BYTE   byRes1[2];       //
    float  fTriggerArea;    //Ŀٷֱ [0,100]ʽΪĿʱЧ
    BYTE   byRes2[4];       //
}NET_VCA_RULE_TRIGGER_PARAM,*LPNET_VCA_RULE_TRIGGER_PARAM;

//ṹ
typedef struct tagNET_VCA_ONE_RULE_V41
{
    BYTE   byActive; //Ƿ񼤻,0-,0-
    BYTE   byRes1[4];  //Ϊ0ֶ
    BYTE   byEventTypeFlag;  //־Ϊ¼ֶεЧԣ0-dwEventTypeЧ1-wEventTypeExЧ
    //עֶbyEventTypeFlagֻòʱЧ豸ȡʱֱӴwEventTypeExȡ¼ͣжϴֶεֵ
    WORD   wEventTypeEx; //Ϊ¼չڴֶdwEventTypeοVCA_RULE_EVENT_TYPE_EX
    BYTE   byRuleName[NAME_LEN]; //
    VCA_EVENT_TYPE dwEventType;    //Ϊ¼ͣΪ˼ݣʹwEventTypeExȡ¼
    NET_VCA_EVENT_UNION uEventParam; //Ϊ¼
    NET_VCA_SIZE_FILTER  struSizeFilter;  //ߴ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;    //ʽ 
    BYTE   byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ
    WORD   wAlarmDelay; //ܱʱ0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    BYTE   byRes2[2]; //
    NET_VCA_FILTER_STRATEGY     struFilterStrategy; //ߴ˲
    NET_VCA_RULE_TRIGGER_PARAM  struTriggerParam;   //򴥷
    BYTE   byRes[32];
}NET_VCA_ONE_RULE_V41, *LPNET_VCA_ONE_RULE_V41;

//Ϊýṹ
typedef struct tagNET_VCA_RULECFG_V41
{
    DWORD  dwSize;            //ṹ
    BYTE    byPicProType;    //ʱͼƬʽ 0- 0-ϴ
    BYTE    byUpLastAlarm; //2011-04-06 Ƿϴһεı
    BYTE    byPicRecordEnable;  /*2012-3-1ǷͼƬ洢, 0-, 1-*/
    BYTE    byRes1;
    NET_DVR_JPEGPARA struPictureParam;         //ͼƬṹ
    NET_VCA_ONE_RULE_V41  struRule[MAX_RULE_NUM];  //
    WORD   wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; //ץͼͨͨʱͬʱϴͨץͼƬ0ʾֵΪͨ
    BYTE   byRes[26];
}NET_VCA_RULECFG_V41, *LPNET_VCA_RULECFG_V41;

//ṹ
typedef struct NET_VCA_ONE_RULE_V42_  
{
    BYTE           byActive;       //Ƿ񼤻, 0-񣬷0-
    BYTE        byEventPriority;//¼ȼ 0-ͣ1-У2-
    BYTE           byRes1[4];           //Ϊ0ֶ
    WORD          wEventType;        //Ϊ¼ͣοVCA_RULE_EVENT_TYPE_EX
    BYTE        byRuleName[NAME_LEN/*32*/];        //
    NET_VCA_EVENT_UNION  uEventParam;            //Ϊ¼
    NET_VCA_SIZE_FILTER  struSizeFilter;          //ߴ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_HANDLEEXCEPTION_V40  struAlarmHandleType; /*ʽ*/
    //쳣ʽбŰ󶨣Ϊ0ʱʾıŷΧΪ1-64Ϊ1ʱʾıŷΧΪ65-128 ڽУ0xffffffffʾ ǰļںıЧ
    DWORD       dwRelRecordChan[MAX_CHANNUM_V30];    /* ¼ֽͨڵͨţʼֵ 0xffffffff*/
    //¼ͨŰ󶨣Ϊ0ʱʾͨŷΧΪ1-64Ϊ1ʱʾͨŷΧΪ65-128 ڽУ0xffffffffʾ ǰļںĹͨЧ
    WORD          wAlarmDelay; //ܱʱ0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    BYTE           byRes2[2];           //
    NET_VCA_FILTER_STRATEGY     struFilterStrategy;  //ߴ˲
    NET_VCA_RULE_TRIGGER_PARAM     struTriggerParam; //򴥷
    BYTE byRes[32];
}NET_VCA_ONE_RULE_V42, *LPNET_VCA_ONE_RULE_V42;


typedef struct    tagNET_DVR_PTZ_POSITION
{
    // ǷóóΪʱֶЧóλϢʱΪʹλ
    BYTE byEnable;
    BYTE byRes1[3];  //
    BYTE byPtzPositionName[NAME_LEN]; //λ
    NET_DVR_PTZPOS struPtzPos; //ptz 
    BYTE byRes2[40];
}NET_DVR_PTZ_POSITION, *LPNET_DVR_PTZ_POSITION;

//Ϊýṹ
typedef struct tagNET_VCA_RULECFG_V42
{
    DWORD            dwSize;             //ṹͼС
    BYTE                byPicProType;            //ʱͼƬʽ 0- 1-ϴ
    BYTE            byUpLastAlarm;         //Ƿϴһεı0-1-
    BYTE             byPicRecordEnable;   //ǷͼƬ洢, 0-, 1-
    BYTE            byRes1;
    NET_DVR_JPEGPARA     struPicParam;         //ͼƬṹ
    NET_VCA_ONE_RULE_V42  struRule[MAX_RULE_NUM_V42 /*16*/];       /* */
    WORD            wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; //ץͼͨͨʱͬʱϴͨץͼƬ0ʾֵΪͨ
    BYTE            byTrackEnable; //Ƿø
    BYTE            byRes2;
    NET_DVR_PTZ_POSITION  struPTZPosition;  //λϢ
    WORD            wTrackDuration; //ٳʱ䣬λs
    BYTE            byRes[62];//
}NET_VCA_RULECFG_V42, *LPNET_VCA_RULECFG_V42;


//Ŀṹ
typedef struct tagNET_VCA_TARGET_INFO
{
    DWORD    dwID;                //ĿID ,Աۼ߱ʱΪ0
    NET_VCA_RECT struRect;      //Ŀ߽ 
    BYTE      byRes[4];            //
}NET_VCA_TARGET_INFO, *LPNET_VCA_TARGET_INFO;

//򻯵ĹϢ, ĻϢ
typedef struct tagNET_VCA_RULE_INFO
{
    BYTE   byRuleID;                //ID,0-7
    BYTE   byRes;                //
    WORD   wEventTypeEx;            //Ϊ¼չڴֶdwEventTypeοVCA_RULE_EVENT_TYPE_EX
    BYTE   byRuleName[NAME_LEN];    //
    VCA_EVENT_TYPE  dwEventType;    //Ϊ¼ͣΪ˼ݣʹwEventTypeExȡ¼
    NET_VCA_EVENT_UNION uEventParam;//¼
}NET_VCA_RULE_INFO, *LPNET_VCA_RULE_INFO;

//Ϊϱṹ
typedef struct  tagNET_VCA_RULE_ALARM
{
    DWORD    dwSize;                        //ṹ
    DWORD    dwRelativeTime;                //ʱ
    DWORD    dwAbsTime;                        //ʱ
    NET_VCA_RULE_INFO     struRuleInfo;        //¼Ϣ
    NET_VCA_TARGET_INFO  struTargetInfo;    //ĿϢ
    NET_VCA_DEV_INFO       struDevInfo;        //ǰ豸Ϣ
    DWORD dwPicDataLen;                        //ͼƬĳ Ϊ0ʾûͼƬ0ʾýṹͼƬ*/
    BYTE       byPicType;        //  0-ͨͼƬ 1-ԱͼƬ
    BYTE       byRelAlarmPicNum; //ͨͼƬ
    BYTE       bySmart;//IDS豸0(Ĭֵ)Smart Functiom Return 1
    BYTE       byRes;        // ֽ
    DWORD      dwAlarmID;     //IDԱʶͨϱ0ʾЧ
    BYTE       byRes2[8];        //
    BYTE       *pImage;       //ָͼƬָ
}NET_VCA_RULE_ALARM, *LPNET_VCA_RULE_ALARM;

//ΪDSPϢӽṹ
typedef struct tagNET_VCA_DRAW_MODE
{ 
    DWORD  dwSize;
    BYTE    byDspAddTarget;            //ǷĿ
    BYTE    byDspAddRule;            //Ƿӹ
    BYTE    byDspPicAddTarget;        //ץͼǷĿ
    BYTE    byDspPicAddRule;        //ץͼǷӹ
    BYTE    byRes[4];            
}NET_VCA_DRAW_MODE, *LPNET_VCA_DRAW_MODE;

//
typedef enum tagOBJECT_TYPE_ENUM
{    
    ENUM_OBJECT_TYPE_COAT  = 1  //
}OBJECT_TYPE_ENUM;

//ɫṹ
typedef struct tagNET_DVR_OBJECT_COLOR_COND
{   
    DWORD  dwChannel;   //ͨ
    DWORD  dwObjType;   //ͣμOBJECT_TYPE_ENUM
    BYTE   byRes[64];   //
}NET_DVR_OBJECT_COLOR_COND,*LPNET_DVR_OBJECT_COLOR_COND;

//ͼƬ
typedef struct tagNET_DVR_PIC
{
    BYTE   byPicType;        //ͼƬͣ1-jpg
    BYTE   byRes1[3];        //
    DWORD  dwPicWidth;       //ͼƬ
    DWORD  dwPicHeight;      //ͼƬ߶
    DWORD  dwPicDataLen;     //ͼƬʵʴС
    DWORD  dwPicDataBuffLen; //ͼƬݻС
    BYTE*  byPicDataBuff;    //ͼƬݻ
    BYTE   byRes2[40];       //
}NET_DVR_PIC,*LPNET_DVR_PIC;

//ɫ
typedef union tagNET_DVR_OBJECT_COLOR_UNION
{    
    NET_DVR_COLOR  struColor;   //ɫֵ
    NET_DVR_PIC    struPicture; //ͼƬ
    BYTE           byRes[64];   //
}NET_DVR_OBJECT_COLOR_UNION,*LPNET_DVR_OBJECT_COLOR_UNION;

//ɫṹ
typedef struct tagNET_DVR_OBJECT_COLOR
{    
    DWORD  dwSize;       //ṹС
    BYTE   byEnable;     //0-ã1-
    BYTE   byColorMode;  //ȡɫʽ1-ɫֵ2-ͼƬ
    BYTE   byRes1[2];    //
    NET_DVR_OBJECT_COLOR_UNION uObjColor; //ɫ壬ȡֵȡɫʽ
    BYTE   byRes2[64];   //
}NET_DVR_OBJECT_COLOR, *LPNET_DVR_OBJECT_COLOR;

//
typedef enum tagAREA_TYPE_ENUM
{    
    ENUM_OVERLAP_REGION  = 1,//ͬ
        ENUM_BED_LOCATION  = 2   //λ
}AREA_TYPE_ENUM;

//
typedef struct tagNET_DVR_AUXAREA
{
    DWORD  dwAreaType;   //ͣμAREA_TYPE_ENUM
    BYTE   byEnable;     //0-ã1-
    BYTE   byRes1[3];     //
    NET_VCA_POLYGON struPolygon; //
    BYTE   byRes2[16];   //
}NET_DVR_AUXAREA,*LPNET_DVR_AUXAREA;

//б
typedef struct tagNET_DVR_AUXAREA_LIST
{
    DWORD     dwSize;    // ṹС
    NET_DVR_AUXAREA struArea[MAX_AUXAREA_NUM]; //
    BYTE    byRes2[64];    // 
}NET_DVR_AUXAREA_LIST,*LPNET_DVR_AUXAREA_LIST;

//ͨģʽ
typedef enum tagCHAN_WORKMODE_ENUM
{    
    ENUM_CHAN_WORKMODE_INDEPENDENT = 1,  //ģʽ
        ENUM_CHAN_WORKMODE_MASTER  = 2,      //ģʽ
        ENUM_CHAN_WORKMODE_SLAVE  = 3        //ģʽ
}CHAN_WORKMODE_ENUM;

//ͨģʽṹ
typedef struct tagNET_DVR_CHANNEL_WORKMODE
{   
    DWORD dwSize;        //ṹС
    BYTE  byWorkMode;    //ģʽμCHAN_WORKMODE_ENUM
    BYTE  byRes[63];     //
}NET_DVR_CHANNEL_WORKMODE,*LPNET_DVR_CHANNEL_WORKMODE;

//豸ͨṹ
typedef struct tagNET_DVR_CHANNEL
{
    BYTE   byAddress[MAX_DOMAIN_NAME];    //豸IP
    WORD   wDVRPort;                     //˿ں
    BYTE   byRes1[2];                   //
    BYTE   sUserName[NAME_LEN];            //û
    BYTE   sPassword[PASSWD_LEN];       //
    DWORD  dwChannel;                   //ͨ
    BYTE   byRes2[32];                  //
}NET_DVR_CHANNEL,*LPNET_DVR_CHANNEL;

//ͨϢ
typedef union tagNET_DVR_SLAVE_CHANNEL_UNION
{
    BYTE            byRes[152];        //С
    DWORD           dwLocalChannel;    //ͨ
    NET_DVR_CHANNEL struRemoteChannel; //Զͨ
}NET_DVR_SLAVE_CHANNEL_UNION,*LPNET_DVR_SLAVE_CHANNEL_UNION;

//ͨṹ
typedef struct tagNET_DVR_SLAVE_CHANNEL_PARAM
{
    BYTE   byChanType;   //ͨͣ1-ͨ2-Զͨ 
    BYTE   byRes1[3];    //
    NET_DVR_SLAVE_CHANNEL_UNION uSlaveChannel; //ͨ壬ȡֵbyChanType
    BYTE   byRes2[64];   //
}NET_DVR_SLAVE_CHANNEL_PARAM,*LPNET_DVR_SLAVE_CHANNEL_PARAM;


//ͨýṹ
typedef struct tagNET_DVR_SLAVE_CHANNEL_CFG
{   
    DWORD dwSize;   //ṹС
    NET_DVR_SLAVE_CHANNEL_PARAM struChanParam[MAX_SLAVE_CHANNEL_NUM];//ͨ
    BYTE  byRes[64];  //
}NET_DVR_SLAVE_CHANNEL_CFG,*LPNET_DVR_SLAVE_CHANNEL_CFG;

//Ƶϼ¼
typedef enum tagVQD_EVENT_ENUM
{    
    ENUM_VQD_EVENT_BLUR           = 1,  //ͼģ
        ENUM_VQD_EVENT_LUMA           = 2,  //쳣
        ENUM_VQD_EVENT_CHROMA         = 3,  //ͼƫɫ
        ENUM_VQD_EVENT_SNOW           = 4,  //ѩ
        ENUM_VQD_EVENT_STREAK         = 5,  //Ƹ
        ENUM_VQD_EVENT_FREEZE         = 6,  //涳
        ENUM_VQD_EVENT_SIGNAL_LOSS    = 7,  //źŶʧ
        ENUM_VQD_EVENT_PTZ            = 8,  //̨ʧ
        ENUM_VQD_EVENT_SCNENE_CHANGE  = 9,  //ͻ
        ENUM_VQD_EVENT_VIDEO_ABNORMAL = 10, //Ƶ쳣
        ENUM_VQD_EVENT_VIDEO_BLOCK    = 11, //Ƶڵ
}VQD_EVENT_ENUM;

//Ƶ¼ṹ
typedef struct tagNET_DVR_VQD_EVENT_COND
{
    DWORD dwChannel;   //ͨ
    DWORD dwEventType; //¼ͣμVQD_EVENT_ENUM
    BYTE  byRes[64];   //
}NET_DVR_VQD_EVENT_COND,*LPNET_DVR_VQD_EVENT_COND;

//Ƶ¼
typedef struct tagNET_DVR_VQD_EVENT_PARAM
{ 
    BYTE   byThreshold;    //ֵΧ[0,100]
    BYTE   byTriggerMode;  //1-2-δ
    BYTE   byUploadPic;    //0-ϴͼƬ1-ϴͼƬǷϴͼƬº󶼿Դ豸ȡ¼ӦµһűͼƬμӿNET_DVR_StartDownload
    BYTE   byRes1;         //
    DWORD  dwTimeInterval; //ʱΧ[0,3600] λ
    BYTE   byRes2[64];     //
}NET_DVR_VQD_EVENT_PARAM,*LPNET_DVR_VQD_EVENT_PARAM;

//Ƶ¼
typedef struct tagNET_DVR_VQD_EVENT_RULE
{   
    DWORD  dwSize;       //ṹС 
    BYTE   byEnable;     //0-ã1-
    BYTE   byRes1[3];    //
    NET_DVR_VQD_EVENT_PARAM struEventParam; //Ƶ¼
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;  //ʽ
    BYTE   byRelRecordChan[MAX_IVMS_IP_CHANNEL]; //¼ͨ1ʾͨ0ʾ 
    BYTE   byRes2[128];    //
}NET_DVR_VQD_EVENT_RULE,*LPNET_DVR_VQD_EVENT_RULE;

//׼
typedef struct tagNET_DVR_BASELINE_SCENE
{   
    DWORD dwSize;     //ṹС
    BYTE  byEnable;   //0-ã1-
    BYTE  byRes[63];  //
}NET_DVR_BASELINE_SCENE,*LPNET_DVR_BASELINE_SCENE;

//׼ṹ
typedef struct tagNET_DVR_CONTROL_BASELINE_SCENE_PARAM
{   
    DWORD dwSize;     //ṹС
    DWORD dwChannel;  //ͨ
    BYTE  byCommand;  //ͣ1-ֶαݲʹã2-»׼
    BYTE  byRes[127];  //
}NET_DVR_CONTROL_BASELINE_SCENE_PARAM,*LPNET_DVR_CONTROL_BASELINE_SCENE_PARAM;

//Ƶϱṹ
typedef struct tagNET_DVR_VQD_ALARM
{   
    DWORD  dwSize;                //ṹС
    DWORD  dwRelativeTime;        //ʱ
    DWORD  dwAbsTime;              //ʱ
    NET_VCA_DEV_INFO struDevInfo; //ǰ豸Ϣ 
    DWORD  dwEventType;           //¼ͣοVQD_EVENT_ENUM
    float  fThreshold;            //ֵ[0.000,1.000]
    DWORD  dwPicDataLen;          //ͼƬȣΪ0ʾûͼƬ
    BYTE   *pImage;               //ָͼƬָ           
    BYTE   byRes[128];            //
}NET_DVR_VQD_ALARM,*LPNET_DVR_VQD_ALARM;

//궨ӽṹ
typedef struct tagNET_DVR_CB_POINT
{
    NET_VCA_POINT struPoint;     //궨㣬ǹ
    NET_DVR_PTZPOS struPtzPos;  //PTZ
    BYTE    byRes[8];
}NET_DVR_CB_POINT, LPNET_DVR_CB_POINT;

//궨ýṹ
typedef struct tagNET_DVR_TRACK_CALIBRATION_PARAM
{    
    BYTE byPointNum;            //Ч궨
    BYTE byRes[3];                
    NET_DVR_CB_POINT  struCBPoint[MAX_CALIB_PT]; //궨
}NET_DVR_TRACK_CALIBRATION_PARAM, *LPNET_DVR_TRACK_CALIBRATION_PARAM;

//ýṹ
typedef struct tagNET_DVR_TRACK_CFG 
{    
    DWORD dwSize;                //ṹ    
    BYTE byEnable;                //궨ʹ
    BYTE byFollowChan;          // ƵĴͨ
    BYTE byDomeCalibrate;            //ܸ궨1 0 
    BYTE byRes;                    // ֽ
    NET_DVR_TRACK_CALIBRATION_PARAM  struCalParam; //궨
}NET_DVR_TRACK_CFG, *LPNET_DVR_TRACK_CFG ;

//ģʽ
typedef enum _TRACK_MODE_
{
    MANUAL_CTRL = 0,  //ֶ
        ALARM_TRACK    //
}TRACK_MODE;

//ֶƽṹ
typedef struct tagNET_DVR_MANUAL_CTRL_INFO 
{
    NET_VCA_POINT struCtrlPoint;
    BYTE  byRes[8];
}NET_DVR_MANUAL_CTRL_INFO, *LPNET_DVR_MANUAL_CTRL_INFO ;

//ģʽṹ
typedef struct tagNET_DVR_TRACK_MODE
{
    DWORD dwSize;        //ṹ
    BYTE byTrackMode;   //ģʽ
    BYTE byRuleConfMode;   //øģʽ0-ø٣1-Զø
    BYTE byRes[2];   //0
    union
    {
        DWORD dwULen[4];
        NET_DVR_MANUAL_CTRL_INFO  struManualCtrl;//ֶٽṹ
    }uModeParam;
}NET_DVR_TRACK_MODE,*LPNET_DVR_TRACK_MODE;

typedef struct tagNET_DVR_ALARM_JPEG
{
    BYTE    byPicProType;        /*ʱͼƬʽ 0- 1-ϴ*/
    BYTE    byRes[3];           //ֽ
    NET_DVR_JPEGPARA struPicParam;                 /*ͼƬṹ*/
}NET_DVR_ALARM_JPEG, *LPNET_DVR_ALARM_JPEG;

/**********************ipc/d5.3.0********************************/
typedef struct tagNET_DVR_PHY_RATIO
{
    DWORD  dwSize;
    DWORD  dwPhysicsRatio;//
    BYTE   byRes[60];
}NET_DVR_PHY_RATIO, *LPNET_DVR_PHY_RATIO;

typedef struct tagNET_DVR_SLAVECAMERA_COND
{
    DWORD            dwSize;
    DWORD            dwChannel;
    BYTE             byID;//Ӹ ID[1,4]
    BYTE             byRes[63];
}NET_DVR_SLAVECAMERA_COND, *LPNET_DVR_SLAVECAMERA_COND;

typedef struct tagNET_DVR_SLAVECAMERA_CFG
{
    DWORD            dwSize;
    BYTE                 byAddressType;   //0-ʵipv4 ipv6ַ 1-
    // unionServerʹʵʵַ
    WORD                wPort;            /*˿*/
    BYTE               byLoginStatus; /*豸ĵ½״̬ 0-logout,1-login*/
    union
    {
        struct
        {
            BYTE            szDomain[MAX_DOMAIN_NAME/*64*/];//ַ 
            BYTE            byRes1[80];
        }struDomain;
        struct
        {
            NET_DVR_IPADDR     struIp;/*IPַ*/        //IPv4 IPv6ַ, 144ֽ
        } struAddrIP;
    }unionServer;  //ʹṹͨbyAddressTypeֶαʾIPַ 64    
    BYTE                szUserName[NAME_LEN/*32*/];        /*û*/
    BYTE                szPassWord[PASSWD_LEN/*16*/];        /**/
    BYTE        byRes1[128];
}NET_DVR_SLAVECAMERA_CFG, *LPNET_DVR_SLAVECAMERA_CFG;

typedef struct tagNET_DVR_SLAVECAMERA_PARAM
{
    BYTE             byLinkStatus ;//״̬ 0- δӣ1-
    BYTE             byRes[15];
}NET_DVR_SLAVECAMERA_PARAM, *LPNET_DVR_SLAVECAMERA_PARAM;

typedef struct tagNET_DVR_SLAVECAMERA_STATUS
{
    DWORD            dwSize;
    NET_DVR_SLAVECAMERA_PARAM  struSlaveCamera[MAX_SLAVECAMERA_NUM/*8*/];//±0ʾID 1,
    BYTE             byRes[64];
}NET_DVR_SLAVECAMERA_STATUS, *LPNET_DVR_SLAVECAMERA_STATUS;

typedef struct tagNET_PTZ_INFO
{    
    float fPan;
    float fTilt;
    float fZoom;
    BYTE  byRes[8];
}NET_PTZ_INFO, *LPNET_PTZ_INFO;

typedef struct tagNET_DVR_CALIB_PARAM
{
    NET_PTZ_INFO   struPtzInfo;
    NET_VCA_POINT  struCalibCoordinates;//궨
    BYTE      byRes[16];
}NET_DVR_CALIB_PARAM, *LPNET_DVR_CALIB_PARAM;

typedef struct tagNET_DVR_SLAVECAMERA_CALIB_CFG
{
    DWORD            dwSize;
    BYTE              byCalibMode;//궨ģʽ: 0-,1-Զ궨, 2-ֶ궨
    BYTE             byRes[3]; 
    //±0ʾID 1
    //ֶ궨ģʽ֧ã&&ȡԶģʽֻ֧ȡ
    NET_DVR_CALIB_PARAM  struCalibParam[MAX_CALIB_NUM/*6*/];//ֶֻ궨ģʽЧ
    BYTE             byRes1[64];
}NET_DVR_SLAVECAMERA_CALIB_CFG, *LPNET_DVR_SLAVECAMERA_CALIB_CFG;

typedef struct tagNET_DVR_TRACKING
{
    DWORD dwSize;        //ṹ
    BYTE byEnable;      //ʹ 0-false,1-true
    BYTE byMode;        //ģʽ 0-رգ1-ֶ2-Զ
    WORD  wTrackingTime;//ʱ䣺[0,60]s
    NET_VCA_POLYGON struRegion;//ֶĿΧ
    BYTE byRes[64];
}NET_DVR_TRACKING,*LPNET_DVR_TRACKING;

typedef struct tagNET_DVR_SLAVECAMERA_CALIB_V50
{
    DWORD            dwSize;
    BYTE               byCalibMode;//궨ģʽ: 0-,1-Զ궨, 2-ֶ궨
    BYTE             byRes[3]; 
    //±0ʾID 1
    //ֶ궨ģʽ֧ã&&ȡԶģʽֻ֧ȡ
    NET_DVR_CALIB_PARAM  struCalibParam[MAX_CALIB_NUM_EX/*20*/]; 
    BYTE             byRes1[64];
}NET_DVR_SLAVECAMERA_CALIB_V50, *LPNET_DVR_SLAVECAMERA_CALIB_V50;

typedef struct tagNET_DVR_TRACK_INITPOSTION
{
    DWORD            dwSize;
    DWORD            dwChannel;
    BYTE             byID;//Ӹ ID[1,4]
    BYTE             byRes[127];
}NET_DVR_TRACK_INITPOSTION, *LPNET_DVR_TRACK_INITPOSTION;

typedef struct tagNET_DVR_MANUAL_TRACKRATIO
{
    DWORD            dwSize;
    BYTE             byCoefficient;//ϵ[1,60]
    BYTE             byRes[127];
}NET_DVR_MANUAL_TRACKRATIO, *LPNET_DVR_MANUAL_TRACKRATIO;

/**********************ipc/d5.3.0********************************/

//Ϊṹ
//ṹ
typedef struct tagNET_IVMS_ONE_RULE_
{
    BYTE    byActive;           /* Ƿ񼤻,0-, 0- */
    BYTE    byRes1[7];    //Ϊ0ֶ
    BYTE   byRuleName[NAME_LEN]; //
    VCA_EVENT_TYPE dwEventType;   //Ϊ¼
    NET_VCA_EVENT_UNION uEventParam;//Ϊ¼
    NET_VCA_SIZE_FILTER  struSizeFilter;  //ߴ
    BYTE byRes2[68]; /*Ϊ0*/
}NET_IVMS_ONE_RULE, *LPNET_IVMS_ONE_RULE;

// ǹṹ
typedef struct tagNET_IVMS_RULECFG
{
    NET_IVMS_ONE_RULE  struRule[MAX_RULE_NUM];   //
}NET_IVMS_RULECFG, *LPNET_IVMS_RULECFG;

// IVMSΪýṹ
typedef struct tagNET_IVMS_BEHAVIORCFG
{
    DWORD dwSize;
    BYTE    byPicProType;        //ʱͼƬʽ 0- 0-ϴ
    BYTE    byRes[3];
    NET_DVR_JPEGPARA struPicParam;                 //ͼƬṹ
    NET_IVMS_RULECFG struRuleCfg[MAX_DAYS][MAX_TIMESEGMENT];//ÿʱζӦ
} NET_IVMS_BEHAVIORCFG, *LPNET_IVMS_BEHAVIORCFG;

//ܷȡƻӽṹ
typedef struct tagNET_IVMS_DEVSCHED
{
    NET_DVR_SCHEDTIME     struTime;       //ʱ
    NET_DVR_PU_STREAM_CFG struPUStream; //ǰȡ
}NET_IVMS_DEVSCHED, *LPNET_IVMS_DEVSCHED;

//ܷǲýṹ
typedef struct tagNET_IVMS_STREAMCFG
{
    DWORD dwSize;
    NET_IVMS_DEVSCHED    struDevSched[MAX_DAYS][MAX_TIMESEGMENT];//ʱǰȡԼϢ
} NET_IVMS_STREAMCFG, *LPNET_IVMS_STREAMCFG;

//
typedef struct tagNET_VCA_MASK_REGION
{
    BYTE byEnable;            //Ƿ񼤻, 0-񣬷0-
    BYTE byRes[3];         //0
    NET_VCA_POLYGON  struPolygon; //ζ
}NET_VCA_MASK_REGION, * LPNET_VCA_MASK_REGION;

//ṹ
typedef struct tagNET_VCA_MASK_REGION_LIST
{
    DWORD dwSize;     //ṹ
    BYTE byRes[4];     //0
    NET_VCA_MASK_REGION  struMask[MAX_MASK_REGION_NUM]; //
}NET_VCA_MASK_REGION_LIST, *LPNET_VCA_MASK_REGION_LIST;


//ATM
typedef struct tagNET_VCA_ENTER_REGION//ֹATM
{
    DWORD dwSize;
    BYTE byEnable;            //Ƿ񼤻0-񣬷0-
    BYTE byRes1[3];
    NET_VCA_POLYGON  struPolygon; //
    BYTE byRes2[16];
}NET_VCA_ENTER_REGION, * LPNET_VCA_ENTER_REGION;

//IVMS
typedef struct tagNET_IVMS_MASK_REGION_LIST
{
    DWORD dwSize;    //ṹ
    NET_VCA_MASK_REGION_LIST struList[MAX_DAYS][ MAX_TIMESEGMENT];
}NET_IVMS_MASK_REGION_LIST, *LPNET_IVMS_MASK_REGION_LIST;

//IVMSATM
typedef struct tagNET_IVMS_ENTER_REGION
{
    DWORD dwSize;
    NET_VCA_ENTER_REGION  struEnter[MAX_DAYS][ MAX_TIMESEGMENT]; //
}NET_IVMS_ENTER_REGION, *LPNET_IVMS_ENTER_REGION;

// ivms ͼƬϴṹ
typedef struct tagNET_IVMS_ALARM_JPEG
{
    BYTE                byPicProType;               
    BYTE                byRes[3];
    NET_DVR_JPEGPARA      struPicParam;     
}NET_IVMS_ALARM_JPEG, *LPNET_IVMS_ALARM_JPEG;

// IVMS 
typedef struct tagNET_IVMS_SEARCHCFG
{
    DWORD                        dwSize;
    NET_DVR_MATRIX_DEC_REMOTE_PLAY struRemotePlay;// Զ̻ط
    NET_IVMS_ALARM_JPEG         struAlarmJpeg; // ϴͼƬ
    NET_IVMS_RULECFG           struRuleCfg;   //IVMS Ϊ
}NET_IVMS_SEARCHCFG, *LPNET_IVMS_SEARCHCFG;

//궨ṹ
typedef struct tagNET_DVR_TRACK_CALIBRATION_PARAM_V41
{    
    BYTE byPointNum;    //Ч궨
    BYTE byRes[3];        //
    NET_DVR_CB_POINT  struCBPoint[MAX_CALIB_PT]; //궨
    NET_DVR_PTZPOS struHorizonPtzPos;  //ˮƽPTZ
    BYTE byRes2[256];    //
}NET_DVR_TRACK_CALIBRATION_PARAM_V41, *LPNET_DVR_TRACK_CALIBRATION_PARAM_V41;

//豸ò
typedef struct tagNET_DVR_TRACK_DEV_PARAM_
{    
    DWORD  dwSize;         //ṹС
    BYTE   byEnable;       //ô˸豸, 0-, 1 -
    BYTE   byTransMode;    //ͨѶʽ0-SDK1-485
    BYTE   byRes1[2];       //    
    NET_DVR_CHANNEL  struTrackDevChan; //豸    
    NET_DVR_TRACK_CALIBRATION_PARAM_V41 struCalParam; //豸궨    
    BYTE    byRes2[256];    //    
}NET_DVR_TRACK_DEV_PARAM, *LPNET_DVR_TRACK_DEV_PARAM;
/************************************end******************************************/
//NAS֤
typedef struct tagNET_DVR_IDENTIFICATION_PARAM
{
    BYTE    sUserName[NAME_LEN];        /* û 32*/
    BYTE    sPassword[PASSWD_LEN];        /*  16*/
    BYTE    byRes1[4];    //
}NET_DVR_IDENTIFICATION_PARAM, *LPNET_DVR_IDENTIFICATION_PARAM;

typedef union tagNET_DVR_MOUNT_PARAM_UNION
{
    BYTE  uLen[52];                    //ṹС
    NET_DVR_IDENTIFICATION_PARAM struIdentificationParam;//(SMB/CIFSʱЧ)
} NET_DVR_MOUNT_PARAM_UNION, *LPNET_DVR_MOUNT_PARAM_UNION;

typedef struct tagNET_DVR_NAS_MOUNT_PARAM
{
    BYTE  byMountType; //0,1~NFS, 2~ SMB/CIFS
    BYTE  byRes[3];
    NET_DVR_MOUNT_PARAM_UNION uMountParam;
}NET_DVR_NAS_MOUNT_PARAM, *LPNET_DVR_NAS_MOUNT_PARAM;

typedef union tagNET_DVR_MOUNTMETHOD_PARAM_UNION
{
    BYTE  uLen[56]; //ṹС                    
    NET_DVR_NAS_MOUNT_PARAM struNasMountParam;//NASطʽ (byNetDiskTypeΪNFS(NAS)ʱЧ) 
}NET_DVR_MOUNTMETHOD_PARAM_UNION, *LPNET_DVR_MOUNTMETHOD_PARAM_UNION;

//Ӳ̽ṹ
typedef struct tagNET_DVR_SINGLE_NET_DISK_INFO
{
    BYTE byNetDiskType;                        //Ӳ, 0-NFS(NAS),1-iSCSI
    BYTE byRes1[3];                            //
    NET_DVR_IPADDR struNetDiskAddr;            //Ӳ̵ַ
    BYTE sDirectory[PATHNAME_LEN];            // PATHNAME_LEN = 128
    WORD wPort;                                //iscsiж˿ڣΪĬ
    BYTE  byRes2[2];
    NET_DVR_MOUNTMETHOD_PARAM_UNION  uMountMethodParam;
    BYTE  byRes3[8];                //
}NET_DVR_SINGLE_NET_DISK_INFO, *LPNET_DVR_SINGLE_NET_DISK_INFO;

#define MAX_NET_DISK    16//Ӳ̸

typedef struct tagNET_DVR_NET_DISKCFG 
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NET_DISK_INFO struNetDiskParam[MAX_NET_DISK];
}NET_DVR_NET_DISKCFG, *LPNET_DVR_NET_DISKCFG;

typedef struct tagNET_DVR_SINGLE_NET_DISK_INFO_V40
{
    BYTE byNetDiskType;                        //Ӳ, 0-NFS(NAS),1-iSCSI
    BYTE byRes1[3];                            //
    BYTE sDirectory[PATHNAME_LEN];            // PATHNAME_LEN = 128
    BYTE byDevAddr[MAX_DOMAIN_NAME];    /* 64*/
    WORD wPort;                                //iscsiж˿ڣΪĬ
    BYTE  byRes2[2];
    NET_DVR_MOUNTMETHOD_PARAM_UNION  uMountMethodParam;
    BYTE    byRes4[80];
}NET_DVR_SINGLE_NET_DISK_INFO_V40, *LPNET_DVR_SINGLE_NET_DISK_INFO_V40;

typedef struct tagNET_DVR_NET_DISKCFG_V40 
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NET_DISK_INFO_V40 struNetDiskParam[MAX_NET_DISK];
}NET_DVR_NET_DISKCFG_V40, *LPNET_DVR_NET_DISKCFG_V40;
//¼
//
typedef enum _MAIN_EVENT_TYPE_
{
    EVENT_MOT_DET = 0,        //ƶ
        EVENT_ALARM_IN = 1,        //
        EVENT_VCA_BEHAVIOR = 2,    // Ϊ
        EVENT_INQUEST = 3,       //Ѷ¼
        EVENT_VCA_DETECTION = 4, //
        EVENT_POS = 5,
        EVENT_TRIAL_CASE = 6,//ͥ󰸼Ϣ
        EVENT_STREAM_INFO = 100  //IDϢ
}MAIN_EVENT_TYPE;

#define INQUEST_START_INFO        0x1001       /*ѶʿʼϢ*/
#define INQUEST_STOP_INFO         0x1002       /*ѶֹͣϢ*/
#define INQUEST_TAG_INFO          0x1003       /*صϢ*/
#define INQUEST_SEGMENT_INFO      0x1004       /*ѶƬ״̬Ϣ*/
#define INQUEST_CASE_INFO          0x1005        // Ϣ

typedef enum _VCA_DETECTION_MINOR_TYPE_
{
    EVENT_VCA_TRAVERSE_PLANE     = 1,           //Խ
        EVENT_FIELD_DETECTION,                        //
        EVENT_AUDIO_INPUT_ALARM,                    //Ƶ쳣
        EVENT_SOUND_INTENSITY_ALARM,                //ǿͻ
        EVENT_FACE_DETECTION,                       //
        EVENT_VIRTUAL_FOCUS_ALARM,                  //齹
        EVENT_SCENE_CHANGE_ALARM,                   //
        EVENT_PIR_ALARM,                            //PIR
        EVENT_ENTER_REGION,                           //
        EVENT_EXIT_REGION,                            //Ŀ뿪
        EVENT_LOITERING,                               //ǻ
        EVENT_GROUPDETECTION,                       //Աۼ,֧
        EVENT_RAPIDMOVE,                            //ƶ
        EVENT_PARK,                              //ͣ
        EVENT_UNATTENDED_BAGGAGE,                   //Ʒ
        EVENT_ATTENDEDBAGGAGE,                      //Ʒȡ
        EVENT_VEHICLE_DETECTION,                     //
        EVENT_ALL = 0xffffffff                        //ʾȫ
}VCA_DETECTION_MINOR_TYPE;



//ΪͶӦĴͣ 0xffffʾȫ
typedef enum _BEHAVIOR_MINOR_TYPE_
{
    EVENT_TRAVERSE_PLANE     = 0,    // Խ
        EVENT_ENTER_AREA,                //Ŀ,֧
        EVENT_EXIT_AREA,                //Ŀ뿪,֧
        EVENT_INTRUSION,                 // ܽ,֧
        EVENT_LOITER,                 //ǻ,֧
        EVENT_LEFT_TAKE,                //Ʒȡ,֧
        EVENT_PARKING,                    //ͣ,֧
        EVENT_RUN,                    //ƶ,֧
        EVENT_HIGH_DENSITY,                 //Աۼ,֧
        EVENT_STICK_UP,                //ֽ,֧
        EVENT_INSTALL_SCANNER,                //װ,֧
        EVENT_OPERATE_OVER_TIME,        // ʱ
        EVENT_FACE_DETECT,              // 쳣
        EVENT_LEFT,                     // Ʒ
        EVENT_TAKE,                      // Ʒȡ
        EVENT_LEAVE_POSITION,         //¼
        EVENT_TRAIL_INFO = 16,            //β
        EVENT_FALL_DOWN_INFO = 19,                 //
        EVENT_OBJECT_PASTE        =20,        // ճ
        EVENT_FACE_CAPTURE_INFO = 21,                //
        EVENT_MULTI_FACES_INFO = 22,                  //
        EVENT_AUDIO_ABNORMAL_INFO = 23             //ǿͻ
}BEHAVIOR_MINOR_TYPE;

//6ӦĴ
typedef enum _TRIAL_CASE_MINOR_TYPE_
{
    TRIAL_START_INFO  = 0x1001,    // ͥʼ¼
        TRIAL_STOP_INFO   = 0x1002,        //ͥ¼
        TRIAL_TAG_INFO    = 0x1003,        //ͥصע¼
        TRIAL_SEGMENT_INFO = 0x1004,    // ͥƬ״̬Ϣ
        TRIAL_JUDGE_CASE_INFO=0x1005 //ͥ󰸼Ϣ
}TRIAL_CASE_MINOR_TYPE;

// 100ӦС
typedef enum _STREAM_INFO_MINOR_TYPE_
{
    EVENT_STREAM_ID  = 0,                    // ID
        EVENT_TIMING = 1,                    // ʱ¼
        EVENT_MOTION_DETECT = 2,            // ƶ
        EVENT_ALARM = 3,                    // ¼
        EVENT_ALARM_OR_MOTION_DETECT = 4,    // ƶ
        EVENT_ALARM_AND_MOTION_DETECT = 5,    // ƶ
        EVENT_COMMAND_TRIGGER = 6,            // 
        EVENT_MANNUAL = 7,                    // ֶ¼
        EVENT_BACKUP_VOLUME = 8,            // 浵¼
        STREAM_EVENT_SEMAPHORE,                //ź
        STREAM_EVENT_HIDE,                    //ڵ
        STREAM_EVENT_INVERSE,                //
        STREAM_EVENT_VIDEO_LOST,            //Ƶʧ
        STREAM_EVENT_WIRELESS_ALARM,        //߱
        STREAM_EVENT_PIR_ALARM,                //PIR
        STREAM_EVENT_CALLHELP_ALARM,        //ȱ
        
        STREAM_EVENT_FACESNAP,                //ץ
        STREAM_EVENT_FACE_DETECTION,        //
        STREAM_EVENT_ITS_PLATE,                //
        STREAM_EVENT_PDC,                    //ͳ
        STREAM_EVENT_SCENECHANGE_DETECTION,    //
        STREAM_EVENT_DEFOCUS_DETECTION,        //齹
        STREAM_EVENT_AUDIOEXCEPTION,        //Ƶ쳣
        
        //ΪΪCOMM_ALARM_RULEͣVCA_EVENT_TYPE
        VCA_EVENT_TRAVERSE_PLANE,            //Խ
        VCA_EVENT_INTRUSION,                //ܽ
        VCA_EVENT_ENTER_AREA,                //
        VCA_EVENT_EXIT_AREA,                //뿪
        VCA_EVENT_LOITER,                    //ǻ
        VCA_EVENT_HIGH_DENSITY,                //Աۼ
        VCA_EVENT_RUN,                        //ƶ
        VCA_EVENT_PARKING,                    //Ƿͣ
        VCA_EVENT_LEFT,                        //Ʒ
    VCA_EVENT_TAKE                            //Ʒȡ
}STREAM_INFO_MINOR_TYPE;

// typedef enum tagITS_MINOR_TYPE
// {
//     ITS_EVENT_CONGESTION    = 0,    // ӵ
//     ITS_EVENT_PARKING,              // ͣ
//     ITS_EVENT_INVERSE,              // 
//     ITS_EVENT_PEDESTRIAN,           // 
//     ITS_EVENT_DEBRIS                // Ƭ
// }ITS_MINOR_TYPE;


#define SEARCH_EVENT_INFO_LEN   300    //¼Ϣ
#define CASE_NO_LEN                64
#define CASE_NAME_LEN            128
#define LITIGANT_LEN            32
#define CHIEF_JUDGE_LEN         32
#define     SEARCH_CASE_NO_LEN        56
#define  SEARCH_CASE_NAME_LEN    100
#define  SEARCH_LITIGANT_LEN    32
#define  SEARCH_CHIEF_JUDGE_LEN 32
#define     CASE_NO_RET_LEN        52
#define  CASE_NAME_RET_LEN        64
#define     LITIGANT_RET_LEN        24
#define     CHIEF_JUDGE_RET_LEN    24
//¼
typedef struct tagNET_DVR_SEARCH_EVENT_PARAM
{
    WORD wMajorType;            //0-ƶ⣬1-, 2-¼
    WORD wMinorType;            //- ͱ仯0xffffʾȫ
    NET_DVR_TIME struStartTime;    //Ŀʼʱ䣬ֹͣʱ: ͬʱΪ(0, 0) ʾʱ俪ʼǰ4000¼
    NET_DVR_TIME struEndTime;    //
    BYTE            byLockType;        // 0xff-ȫ0-δ1-
    BYTE             byValue;            //0-λʾ1-ֵʾ
    BYTE             byRes[130];        // 
    union    
    {
        BYTE byLen[SEARCH_EVENT_INFO_LEN];          
        struct//
        {
            BYTE byAlarmInNo[MAX_ALARMIN_V30];    //ţbyAlarmInNo[0]1ʾɱ1¼
            BYTE byRes[SEARCH_EVENT_INFO_LEN - MAX_ALARMIN_V30];
        }struAlarmParam;
        
        struct//--ֵ
        {
            WORD wAlarmInNo[128];     /*ţֵʾ,ý*/
            BYTE byRes[44]; //
        }struAlarmParamByValue;
        
        struct//ƶ
        {
            BYTE byMotDetChanNo[MAX_CHANNUM_V30];//ƶͨbyMotDetChanNo[0]1ʾͨ1ƶⴥ¼
            BYTE byRes[SEARCH_EVENT_INFO_LEN - MAX_CHANNUM_V30];
        }struMotionParam;
        
        struct//ƶ--ֵ
        {
            WORD wMotDetChanNo[64];        /* ƶֵͨʾ ,ý*/
            BYTE byRes[172];                /**/
        }struMotionParamByValue;
        
        struct//Ϊ
        {
            BYTE byChanNo[MAX_CHANNUM_V30];    //¼ͨ
            BYTE byRuleID;                    //ID0xffʾȫ
            BYTE byRes1[43];                //
        }struVcaParam;
        
        struct //Ϊ--ֵʽ 
        {
            WORD wChanNo[64];     //ΪӦֵͨʾ,ý
            BYTE byRuleID;      //Ϊͣ0xffʾȫ0ʼ
            BYTE byRes[171];     /**/           
        }struVcaParamByValue;
        
        struct//Ѷ¼
        {            
            BYTE byRoomIndex;    //Ѷұ,ֵʾ1ʼ
            BYTE byRes1[3];
            BYTE sInquestInfo[INQUEST_CASE_LEN];
            BYTE byRes2[232];     //
        } struInquestParam;
        struct  //
        {
            BYTE byChan [256];//ͨţ±ʾbyChan[0]1ʾͨ1ƶⴥ¼ 
        }struVCADetectByBit;
        
        struct// ͨŰֵʾ
        {
            DWORD dwChanNo[MAX_CHANNUM_V30-1];// ͨ,ֵʾ0xffffffffЧҺҲʾЧֵ
            BYTE byAll;//0-ʾȫ1-ʾȫ
            BYTE byres[3];
        }struVCADetectByValue;
        struct
        {
            NET_DVR_STREAM_INFO struIDInfo; // idϢ72ֽڳ
            DWORD                dwCmdType;  // ⲿͣNVRƴ洢ʹ
            BYTE                byBackupVolumeNum; //浵ţCVRʹ
            BYTE                byRes[223];
        }struStreamIDParam;
        struct
        {
            BYTE    byCaseNo[SEARCH_CASE_NO_LEN];  //
            BYTE    byCaseName[SEARCH_CASE_NAME_LEN]; //ƣ
            BYTE    byLitigant1[SEARCH_LITIGANT_LEN]; //1
            BYTE    byLitigant2[SEARCH_LITIGANT_LEN]; //2
            BYTE    byChiefJudge[SEARCH_CHIEF_JUDGE_LEN];//г
            BYTE    byCaseType; //ͣ0-ȫ1-°2-°
            BYTE    byRes[47];
        }struTrialParam;
    }uSeniorParam;
}NET_DVR_SEARCH_EVENT_PARAM, *LPNET_DVR_SEARCH_EVENT_PARAM;

#define  MAX_POS_KEYWORDS_NUM               3          //ֹ֧ؼֲ
#define  MAX_POS_KEYWORD_LEN                128         //ÿؼֳ
#define  SEARCH_EVENT_INFO_LEN_V40             800

//¼
typedef struct tagNET_DVR_SEARCH_EVENT_PARAM_V40
{
    WORD wMajorType;            //0-ƶ⣬1-, 2-¼ 5-pos¼
    WORD wMinorType;            //- ͱ仯0xffffʾȫ
    NET_DVR_TIME struStartTime;    //Ŀʼʱ䣬ֹͣʱ: ͬʱΪ(0, 0) ʾʱ俪ʼǰ4000¼
    NET_DVR_TIME struEndTime;    //
    BYTE            byLockType;        // 0xff-ȫ0-δ1-
    BYTE             byRes[131];        // 
    union    
    {
        BYTE byLen[SEARCH_EVENT_INFO_LEN_V40/*800*/];          
        struct//
        {
            /*ţֵʾ,ýУ0xffffʾЧ*/
            WORD wAlarmInNo[128];     
            BYTE byRes[544]; //
        }struAlarmParam;
        
        struct//ƶ
        {
            /* ƶֵͨʾ ,ýУ0xffffʾЧ*/
            WORD wMotDetChanNo[MAX_CHANNUM_V30];        
            BYTE byRes[672];                /**/
        }struMotionParam;
        
        struct //Ϊ 
        {
            //ΪӦֵͨʾ,ýУ0xffffʾЧ
            WORD wChanNo[MAX_CHANNUM_V30];
            BYTE byRuleID;      //Ϊͣ0xffʾȫ0ʼ
            BYTE byRes[671];     /**/           
        }struVcaParam;
        
        struct//Ѷ¼
        {            
            BYTE byRoomIndex;    //Ѷұ,1ʼ
            BYTE byRes[799];     //
        } struInquestParam;
        
        struct// ͨŰֵʾ
        {
            BYTE byAll;                //ȫͨ0-񣬴ʱdwChanNoЧ
            //1-ȫͨʱdwChanNoЧ
            BYTE byRes1[3];
            WORD wChanNo[MAX_CHANNUM_V30];// ͨ,ֵʾ0xffffЧҺҲʾЧֵ
            BYTE byRes[668];
        }struVCADetect;
        
        struct
        {
            NET_DVR_STREAM_INFO struIDInfo; // idϢ72ֽڳ
            DWORD                dwCmdType;  // ⲿͣNVRƴ洢ʹ
            BYTE                byBackupVolumeNum; //浵ţCVRʹ
            BYTE                byRes[723];
        }struStreamIDParam;
        
        struct //pos¼
        {
            WORD   wChannel[MAX_CHANNUM_V30];        //ֵͨʾ,У0xffffʱʾֵЧ
            BYTE     byAllChan;        //Ƿȫͨ0-񣬴ʱwChannelЧ1-ȫͨʱwChannelЧ
            BYTE      byCaseSensitive;      //0-ִСд 1-ִСд
            BYTE      byCombinateMode;  //ؼϷʽ0-1-
            BYTE      byRes1;              //
            char     sKeyWord[MAX_POS_KEYWORDS_NUM][MAX_POS_KEYWORD_LEN]; 
                                             //ؼֲʱ
            BYTE    byRes[284];          //
        }struPosAlarm;
        
        struct
        {
            BYTE    byCaseNo[SEARCH_CASE_NO_LEN];       //
            BYTE    byCaseName[SEARCH_CASE_NAME_LEN];   //
            BYTE    byLitigant1[SEARCH_LITIGANT_LEN];   //1
            BYTE    byLitigant2[SEARCH_LITIGANT_LEN];   //2
            BYTE    byChiefJudge[SEARCH_CHIEF_JUDGE_LEN];   //г
            BYTE    byCaseType;
            BYTE    byRes[47];
        }struTrialParam;
    }uSeniorParam;
}NET_DVR_SEARCH_EVENT_PARAM_V40, *LPNET_DVR_SEARCH_EVENT_PARAM_V40;


//ҷؽ
typedef struct tagNET_DVR_SEARCH_EVENT_RET
{
    WORD wMajorType;            //
    WORD wMinorType;            //
    NET_DVR_TIME struStartTime;    //¼ʼʱ
    NET_DVR_TIME struEndTime;   //¼ֹͣʱ䣬¼ʱͿʼʱһ
    BYTE byChan[MAX_CHANNUM_V30];    
    BYTE byChanEx[32];   //ͨλʾʹøֶκbyChanԲʹ
    BYTE byRes[4];
    union        
    {
        struct//
        {
            DWORD dwAlarmInNo;     //
            BYTE byRes[SEARCH_EVENT_INFO_LEN];
        }struAlarmRet;
        struct//ƶ
        {
            DWORD dwMotDetNo;    //ƶͨ
            BYTE byRes[SEARCH_EVENT_INFO_LEN];
        }struMotionRet;
        struct//Ϊ  
        {
            DWORD dwChanNo;                    //¼ͨ
            BYTE byRuleID;                    //ID
            BYTE byRes1[3];                    //
            BYTE byRuleName[NAME_LEN];        //
            NET_VCA_EVENT_UNION uEvent;     //Ϊ¼
        }struVcaRet;
        struct//Ѷ¼
        {
            BYTE  byRoomIndex;     //Ѷұ,1ʼ
            BYTE  byDriveIndex;    //¼,1ʼ
            BYTE  byRes1[6];       //
            DWORD dwSegmentNo;     //ƬڱѶе,1ʼ 
            WORD  wSegmetSize;     //ƬϵĴС, λM 
            WORD  wSegmentState;   //Ƭ״̬ 0 ¼1 ¼쳣2 ¼Ѷ
            BYTE  byRes2[288];     //
        }struInquestRet;
        struct //id¼ѯ
        {
            DWORD dwRecordType;    //¼ 0-ʱ¼ 1-ƶ 2-¼ 3-|ƶ 4-&ƶ 5- 6-ֶ¼ 7-𶯱 8- 9-ܱ 10-ش¼
            DWORD dwRecordLength;    //¼С
            BYTE  byLockFlag;    // ־ 0û 1
            BYTE  byDrawFrameType;    // 0ǳ֡¼ 1֡¼
            BYTE  byRes1[2];
            BYTE  byFileName[NAME_LEN];     //ļ
            DWORD dwFileIndex;            // 浵ϵļ
            BYTE  byRes[256];
        }struStreamIDRet;
        struct
        {
            BYTE    byRoomIndex;     //Ѷұ,1ʼ
            BYTE    byDriveIndex;    //¼,1ʼ
            WORD    wSegmetSize;     //ƬϵĴС, λM
            DWORD    dwSegmentNo;    //ƬڱѶе,1ʼ
            BYTE    bySegmentState;   //Ƭ״̬0-¼1-¼쳣2-¼Ѷ
            BYTE    byCaseType; //ͣ0-ȫ1-°2-°
            BYTE    byRes[2];
            BYTE    byCaseNo[CASE_NO_RET_LEN];  //
            BYTE    byCaseName[CASE_NAME_RET_LEN]; //ƣ
            BYTE    byLitigant1[LITIGANT_RET_LEN]; //1
            BYTE    byLitigant2[LITIGANT_RET_LEN]; //2
            BYTE    byChiefJudge[CHIEF_JUDGE_RET_LEN];//г
            BYTE    byRes1[104];
        }struTrialRet;
    }uSeniorRet;
}NET_DVR_SEARCH_EVENT_RET, *LPNET_DVR_SEARCH_EVENT_RET;

//ҷؽ
typedef struct tagNET_DVR_SEARCH_EVENT_RET_V40
{
    WORD wMajorType;            //
    WORD wMinorType;            //
    NET_DVR_TIME struStartTime;    //¼ʼʱ
    NET_DVR_TIME struEndTime;   //¼ֹͣʱ䣬¼ʱͿʼʱһ
    WORD  wChan[MAX_CHANNUM_V40/*512*/];    //ͨţ0xffffʾЧ
    BYTE byRes[36];
    union        
    {
        BYTE  byLen[800];               //峤
        struct//
        {
            DWORD dwAlarmInNo;     //
            BYTE byRes[796];
        }struAlarmRet;
        struct//ƶ
        {
            DWORD dwMotDetNo;    //ƶͨ
            BYTE byRes[796];
        }struMotionRet;
        struct//Ϊ  
        {
            DWORD dwChanNo;                    //¼ͨ
            BYTE byRuleID;                    //ID
            BYTE byRes1[3];                    //
            BYTE byRuleName[NAME_LEN];        //
            NET_VCA_EVENT_UNION uEvent;     //Ϊ¼
            BYTE byRes[668];                    //
        }struVcaRet;
        
        struct//Ѷ¼
        {
            BYTE  byRoomIndex;     //Ѷұ,1ʼ
            BYTE  byDriveIndex;    //¼,1ʼ
            BYTE  byRes1[6];       //
            DWORD dwSegmentNo;     //ƬڱѶе,1ʼ 
            WORD  wSegmetSize;     //ƬϵĴС, λM 
            WORD  wSegmentState;   //Ƭ״̬ 0 ¼1 ¼쳣2 ¼Ѷ
            BYTE  byRes2[784];     //
        }struInquestRet;
        
        struct //id¼ѯ
        {
            DWORD dwRecordType;    //¼ 0-ʱ¼ 1-ƶ 2-¼ 3-|ƶ 4-&ƶ 5- 6-ֶ¼ 7-𶯱 8- 9-ܱ 10-ش¼
            DWORD dwRecordLength;    //¼С
            BYTE  byLockFlag;    // ־ 0û 1
            BYTE  byDrawFrameType;    // 0ǳ֡¼ 1֡¼
            BYTE  byRes1[2];
            BYTE  byFileName[NAME_LEN];     //ļ
            DWORD dwFileIndex;            // 浵ϵļ
            BYTE  byRes[752];
        }struStreamIDRet;
        
        struct//POS¼ѯ
        {
            DWORD dwChanNo;        //pos¼ͨ
            BYTE  byRes[796];
        }struPosRet;
        
        struct
        {
            BYTE    byRoomIndex;     //Ѷұ,1ʼ
            BYTE    byDriveIndex;    //¼,1ʼ
            WORD    wSegmetSize;     //ƬϵĴС, λM
            DWORD    dwSegmentNo;    //ƬڱѶе,1ʼ
            BYTE    bySegmentState;   //Ƭ״̬0-¼1-¼쳣2-¼Ѷ
            BYTE    byCaseType; //ͣ0-ȫ1-°2-°
            BYTE    byRes[2];
            BYTE    byCaseNo[CASE_NO_RET_LEN];  //
            BYTE    byCaseName[CASE_NAME_RET_LEN]; //ƣ
            BYTE    byLitigant1[LITIGANT_RET_LEN]; //1
            BYTE    byLitigant2[LITIGANT_RET_LEN]; //2
            BYTE    byChiefJudge[CHIEF_JUDGE_RET_LEN];//г
            BYTE    byRes1[600];
        }struTrialRet;
    }uSeniorRet;
}NET_DVR_SEARCH_EVENT_RET_V40, *LPNET_DVR_SEARCH_EVENT_RET_V40;


//SDK_V35  2009-10-26

// 궨
typedef enum tagCALIBRATE_TYPE
{
    PDC_CALIBRATE  = 0x01,  // PDC 궨
        BEHAVIOR_OUT_CALIBRATE  = 0x02, //Ϊⳡ궨  
        BEHAVIOR_IN_CALIBRATE = 0x03,    // Ϊڳ궨 
        ITS_CALBIRETE       = 0x04,      //  ͨ¼궨
        BV_DIRECT_CALIBRATE      = 0x05,   //˫Ŀֱӱ궨
        PDC_LINE_CALIBRATE  = 0x06  //PDC  궨
}CALIBRATE_TYPE;

#define MAX_RECT_NUM  6
typedef struct tagNET_DVR_RECT_LIST
{    
    BYTE    byRectNum;    // οĸ
    BYTE    byRes1[11];  //ֽ 
    NET_VCA_RECT struVcaRect[MAX_RECT_NUM]; // Ϊ6Rect 
}NET_DVR_RECT_LIST, *LPNET_DVR_RECT_LIST;

// PDC 궨
typedef struct tagNET_DVR_PDC_CALIBRATION
{
    NET_DVR_RECT_LIST struRectList;       // 궨οб
    BYTE           byRes[120];       // ֽ 
}NET_DVR_PDC_CALIBRATION, *LPNET_DVR_PDC_CALIBRATION;


// 궨ߵʾǰ궨ʵʱʾǸ߶߻ǳߡ
typedef enum tagLINE_MODE
{
    HEIGHT_LINE,        //߶
        LENGTH_LINE        //
}LINE_MODE;
/*
ñ궨ϢʱӦλʹܣز
ûʹܣ궨Իȡص
*/
typedef struct tagNET_DVR_CAMERA_PARAM
{
    BYTE    byEnableHeight;     // Ƿʹ߶
    BYTE    byEnableAngle;      // ǷʹǶ
    BYTE    byEnableHorizon;    // Ƿʹƽ
    BYTE    byRes[5];   // ֽ 
    float   fCameraHeight;    // ߶
    float   fCameraAngle;     // Ƕ
    float   fHorizon;         // еĵƽ
}NET_DVR_CAMERA_PARAM, *LPNET_DVR_CAMERA_PARAM;
/*
fValueʾĿ߶ȵʱstruStartPointstruEndPointֱʾĿͷͽŲ㡣
fValueʾ߶γȵʱstruStartPointstruEndPointֱʾ߶ʼյ㣬
modeʾǰ߱ʾ߶߻ǳߡ
*/
typedef struct tagNET_DVR_LINE_SEGMENT
{
    BYTE            byLineMode;     //  LINE_MODE
    BYTE            byRes[3];       // ֽ 
    NET_VCA_POINT   struStartPoint;  
    NET_VCA_POINT   struEndPoint;
    float           fValue;
}NET_DVR_LINE_SEGMENT, *LPNET_DVR_LINE_SEGMENT;

#define  MAX_LINE_SEG_NUM 8

/*
궨ĿǰҪ4-8ߣԻȡز
*/
typedef struct tagNET_DVR_BEHAVIOR_OUT_CALIBRATION
{
    DWORD                   dwLineSegNum;          // ߸
    NET_DVR_LINE_SEGMENT    struLineSegment[MAX_LINE_SEG_NUM];    // 
    NET_DVR_CAMERA_PARAM    struCameraParam;    // 
    BYTE byRes[20];
}NET_DVR_BEHAVIOR_OUT_CALIBRATION, *LPNET_DVR_BEHAVIOR_OUT_CALIBRATION;

/*
ýṹʾIASܿ궨
аһĿһӦĸ߶ȱ궨ߣ
ĿΪվӾο򣻸߶ʶͷ㵽ŵı궨ߣ
ùһʾ
*/
typedef struct tagNET_DVR_IN_CAL_SAMPLE
{
    NET_VCA_RECT struVcaRect;   // Ŀ
    NET_DVR_LINE_SEGMENT struLineSegment;    // ߶ȱ궨
}NET_DVR_IN_CAL_SAMPLE, *LPNET_DVR_IN_CAL_SAMPLE;

#define  MAX_SAMPLE_NUM 5

typedef struct tagNET_DVR_BEHAVIOR_IN_CALIBRATION 
{
    DWORD    dwCalSampleNum;      //  궨
    NET_DVR_IN_CAL_SAMPLE  struCalSample[MAX_SAMPLE_NUM]; // 궨
    NET_DVR_CAMERA_PARAM    struCameraParam;    // 
    BYTE byRes[16];
}NET_DVR_BEHAVIOR_IN_CALIBRATION, *LPNET_DVR_BEHAVIOR_IN_CALIBRATION;

#define  CALIB_PT_NUM 4
typedef struct tagNET_DVR_ITS_CALIBRATION
{
    DWORD dwPointNum; //궨
    NET_VCA_POINT struPoint[CALIB_PT_NUM]; //ͼ
    float       fWidth;
    float       fHeight;
    BYTE        byRes1[100];        // ֽ
}NET_DVR_ITS_CALIBRATION, *LPNET_DVR_ITS_CALIBRATION;

typedef struct tagNET_DVR_BV_DIRECT_CALIBRATION
{   
    DWORD  dwCameraHeight;  //߶ȣλcm
    float  fPitchAngle;     //ӽǶ[0, 60],
    float  fInclineAngle;   //бǶ[-20,20]
    BYTE   byRes1[228];     //
}NET_DVR_BV_DIRECT_CALIBRATION,*LPNET_DVR_BV_DIRECT_CALIBRATION;

// PDC 궨
typedef struct  tagNET_DVR_PDC_LINE_CALIBRATION
{
    NET_VCA_LINE  struCalibrationLine;
    BYTE       byRes[224];// ֽ 
} NET_DVR_PDC_LINE_CALIBRATION, *LPNET_DVR_PDC_LINE_CALIBRATION;

// 궨
// ر궨Էڸýṹ
typedef union tagNET_DVR_CALIBRATION_PRARM_UNION
{
    BYTE byRes[240];                    //ṹС
    NET_DVR_PDC_CALIBRATION struPDCCalibration;  //PDC 궨
    NET_DVR_BEHAVIOR_OUT_CALIBRATION  struBehaviorOutCalibration;  //  Ϊⳡ궨  ҪӦIVS
    NET_DVR_BEHAVIOR_IN_CALIBRATION  struBehaviorInCalibration;     // Ϊڳ궨ҪӦIAS 
    NET_DVR_ITS_CALIBRATION struITSCalibration;
    NET_DVR_BV_DIRECT_CALIBRATION struBvDirectCalibration; //˫Ŀֱӱ궨
    NET_DVR_PDC_LINE_CALIBRATION struPDCLineCalibration; //PDC ߱궨
}NET_DVR_CALIBRATION_PRARM_UNION, *LPNET_DVR_CALIBRATION_PRARM_UNION;


// 궨ýṹ
typedef struct tagNET_DVR_CALIBRATION_CFG
{
    DWORD   dwSize;               //궨ṹС
    BYTE    byEnable;           // Ƿñ궨
    BYTE    byCalibrationType;    // 궨 ݲͬѡͬı궨 οCALIBRATE_TYPE
    BYTE    byRes1[2];
    NET_DVR_CALIBRATION_PRARM_UNION uCalibrateParam;  // 궨
    BYTE    byRes2[12];
}NET_DVR_CALIBRATION_CFG, *LPNET_DVR_CALIBRATION_CFG; 

//ͳƷṹ
typedef struct  tagNET_DVR_PDC_ENTER_DIRECTION
{
    NET_VCA_POINT struStartPoint; //ͳƷʼ
    NET_VCA_POINT struEndPoint;    // ͳƷ 
}NET_DVR_PDC_ENTER_DIRECTION, *LPNET_DVR_PDC_ENTER_DIRECTION;

typedef struct tagNET_DVR_PDC_RULE_CFG
{
    DWORD           dwSize;              //ṹС
    BYTE            byEnable;             // Ƿ񼤻;
    BYTE            byRes1[23];       // ֽ 
    NET_VCA_POLYGON          struPolygon;            // 
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection;    // 뷽
} NET_DVR_PDC_RULE_CFG, *LPNET_DVR_PDC_RULE_CFG;

typedef struct tagNET_DVR_PDC_RULE_CFG_V41
{
    DWORD           dwSize;              //ṹС
    BYTE            byEnable;             // Ƿ񼤻;
    BYTE            byRes1[23];       // ֽ 
    NET_VCA_POLYGON struPolygon;            // 
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection;    // 뷽
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_TIME_EX struDayStartTime; //쿪ʼʱ䣬ʱЧ
    NET_DVR_TIME_EX struNightStartTime; //ҹʼʱ䣬ʱЧ
    BYTE            byRes[100];       // ֽ
}NET_DVR_PDC_RULE_CFG_V41, *LPNET_DVR_PDC_RULE_CFG_V41;

/********* IPC5.1.7 ͳƹ Begin 2014-03-21***********/
//ṹ
typedef struct tagNET_DVR_PDC_RULE_COND
{
    DWORD  dwSize; //ṹС
    DWORD  dwChannel; //ͨ
    //DWORD dwID;  ೡ
    BYTE  byRes[64]; 
}NET_DVR_PDC_RULE_COND, *LPNET_DVR_PDC_RULE_COND;

//ýṹ
typedef struct tagNET_DVR_PDC_RULE_CFG_V42
{
    DWORD  dwSize; //ṹС
    BYTE   byEnable; //Ƿ񼤻;
    BYTE   byOSDEnable;//ͳOSDʾǷ,  0-1-
    BYTE   byCurDetectType;//ǰͣ0-Σ1-
    BYTE   byRes1; // ֽ
    NET_VCA_POINT   struOSDPoint;//ͳʾOSDʾϽ
    //ϴڣ0-151-12-53-104-205-306-60λ
    BYTE   byDataUploadCycle; 
    //ÿϴʹܣ0-رգ1-
    BYTE   bySECUploadEnable;
    BYTE   byRes2[10];// ֽ      
    NET_VCA_POLYGON          struPolygon; // 
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection; // 뷽
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_TIME_EX struDayStartTime; //쿪ʼʱ䣬ʱЧ
    NET_DVR_TIME_EX struNightStartTime; //ҹʼʱ䣬ʱЧ
    NET_DVR_HANDLEEXCEPTION_V40 struAlarmHandleType; /*ʽ ֧ϴ*/
    BYTE   byDetecteSensitivity;//ĿȣΧ1-100Ĭ50
    BYTE   byGenerateSpeedSpace;//Ŀٶȣ򣩣Χ1-100Ĭ50
    BYTE   byGenerateSpeedTime;// Ŀٶȣʱ򣩣Χ1-100Ĭ50
    BYTE   byCountSpeed;// ٶȣΧ1-100Ĭ50
    BYTE   byDetecteType;// Ŀͣ0-Զ1-ͷ2-ͷ磬Ĭ0-ԶԶģʽDSP㷨Ĳø㷨
    BYTE   byTargetSizeCorrect;//ĿߴΧ1-100Ĭ50
    BYTE   byRes3[2];// ֽ
    NET_VCA_LINE  struLine;//
    BYTE   byRes[236]; //ֽ
}NET_DVR_PDC_RULE_CFG_V42, *LPNET_DVR_PDC_RULE_CFG_V42;
/********* IPC5.1.7 ͳƹ End 2014-03-21***********/

//ðϢṹ
typedef struct tagNET_DVR_TRIAL_VERSION_CFG
{
    DWORD dwSize;
    WORD wReserveTime; //ʣʱ䣬0xffffʾЧλ
    BYTE byRes[62];
}NET_DVR_TRIAL_VERSION_CFG, *LPNET_DVR_TRIAL_VERSION_CFG;

typedef struct tagNET_DVR_SYN_CHANNEL_NAME_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    BYTE  byRes[64]; 
}NET_DVR_SYN_CHANNEL_NAME_PARAM, *LPNET_DVR_SYN_CHANNEL_NAME_PARAM;

typedef struct tagNET_DVR_RESET_COUNTER_CFG
{
    DWORD dwSize;
    BYTE  byEnable; //Ƿã0-ã1-
    BYTE  byMode; //Чģʽ0-ʱ1-ֶ
    BYTE  byRes1[2];
    NET_DVR_TIME_EX struTime[MAX_DAYS];//ʱ䣬ʱЧ
    BYTE  byRes[64]; 
}NET_DVR_RESET_COUNTER_CFG, *LPNET_DVR_RESET_COUNTER_CFG;

typedef struct tagNET_DVR_VCA_CTRLINFO_COND
{
    DWORD dwSize;
    NET_DVR_STREAM_INFO  struStreamInfo;
    BYTE byRes[64];
}NET_DVR_VCA_CTRLINFO_COND, *LPNET_DVR_VCA_CTRLINFO_COND;

typedef struct tagNET_DVR_VCA_CTRLINFO_CFG
{
    DWORD  dwSize;
    BYTE   byVCAEnable;     //Ƿ
    BYTE   byVCAType;       //ͣVCA_CHAN_ABILITY_TYPE 
    BYTE   byStreamWithVCA; //ǷϢ
    BYTE   byMode;            //ģʽATM ʱVCA_CHAN_MODE_TYPE ,TFS ʱ TFS_CHAN_MODE_TYPEΪʱBEHAVIOR_SCENE_MODE_TYPE
    BYTE   byControlType;   //ͣλʾ0-1-
    //byControlType &1 ǷץĹ
    //byControlType &2 Ƿǰ豸
    BYTE   byRes[83];         //Ϊ0
}NET_DVR_VCA_CTRLINFO_CFG, *LPNET_DVR_VCA_CTRLINFO_CFG;

//ͳƲ  Ϊڲؼֲ 
// HUMAN_GENERATE_RATE
// ĿٶȲPDCĿٶȡٶԽ죬ĿԽɡƵϲԱȶȽϵʱõĹСʱӦӿĿٶȣ Ŀ©죻ƵжԱȶȽϸʱ߹ϴʱӦýĿٶȣԼ졣ĿٶȲ51ٶ5죬ĬϲΪ3
// 
// DETECT_SENSITIVE
// ĿȿƲPDCһ򱻼ΪĿȡԽߣԽױΪĿ꣬ԽԽѼΪĿꡣƵϲԱȶȽϵʱӦ߼ȣ Ŀ©죻ƵжԱȶȽϸʱӦýͼȣԼ졣Ӧ51ͣ5ߣĬϼΪ3
// TRAJECTORY_LEN
// 켣ɳȿƲʾɹ켣ʱҪĿλءӦ51ɳ켣5ɳ̣켣죬ĬϼΪ3
// TRAJECT_CNT_LEN
// 켣ȿƲʾ켣ʱҪĿλءӦ51Ҫ󳤶켣5Ҫ󳤶̣켣죬ĬϼΪ3
// PREPROCESS
// ͼԤƲ0 - 1 - ĬΪ0
// CAMERA_ANGLE
// Ƕ 0 - б 1 - ֱĬΪ0
typedef enum tagPDC_PARAM_KEY
{
    HUMAN_GENERATE_RATE = 50,              // Ŀٶ 50ʼ
        DETECT_SENSITIVE    = 51,               // 
}PDC_PARAM_KEY;

typedef struct tagNET_DVR_PDC_TARGET_INFO
{
    DWORD       dwTargetID;                 // Ŀid 
    NET_VCA_RECT struTargetRect;               // Ŀ
    BYTE      byRes1[8];        // ֽ
}NET_DVR_PDC_TARGET_INFO, *LPNET_DVR_PDC_TARGET_INFO;

typedef struct tagNET_DVR_PDC_TARGET_IN_FRAME
{
    BYTE           byTargetNum;                   //Ŀ
    BYTE            byRes1[3];
    NET_DVR_PDC_TARGET_INFO  struTargetInfo[MAX_TARGET_NUM];   //ĿϢ
    BYTE    byRes2[8];                  // ֽ
}NET_DVR_PDC_TARGET_IN_FRAME, *LPNET_DVR_PDC_TARGET_IN_FRAME;

typedef struct tagNET_DVR_PDC_ALRAM_INFO
{
    DWORD                       dwSize;          // PDCϴṹС
    BYTE                        byMode;          // 0 ֡ͳƽ 1Сʱͳƽ  
    BYTE                        byChannel;       // ϴͨ
    /********* IPC5.1.7  Begin 2014-03-21***********/
    BYTE                        bySmart;         //רҵܷ0Smart  1
    BYTE                        byRes1;          // ֽ    
    /********* IPC5.1.7  End 2014-03-21***********/
    NET_VCA_DEV_INFO       struDevInfo;             //ǰ豸Ϣ
    union        
    {
        struct   // ֡ͳƽʱʹ
        {
            DWORD   dwRelativeTime;     // ʱ
            DWORD   dwAbsTime;          // ʱ
            BYTE    byRes[92];            
        }struStatFrame;
        struct
        {
            NET_DVR_TIME                      tmStart; // ͳʼʱ 
            NET_DVR_TIME                      tmEnd;  //  ͳƽʱ 
            BYTE byRes[92];
        }struStatTime;
    }uStatModeParam;  // Ϊһ ֡ʱ֡ĿϢ СʱͳƽҪͳʱ 
    DWORD                       dwLeaveNum;        // 뿪
    DWORD                       dwEnterNum;        // 
    BYTE                        byRes2[40];           // ֽ
}NET_DVR_PDC_ALRAM_INFO, *LPNET_DVR_PDC_ALRAM_INFO;


//  Ϣѯ 
typedef struct tagNET_DVR_PDC_QUERY
{
    NET_DVR_TIME tmStart;
    NET_DVR_TIME tmEnd;
    DWORD       dwLeaveNum;
    DWORD       dwEnterNum; 
    BYTE        byRes1[256];
}NET_DVR_PDC_QUERY, *LPNET_DVR_PDC_QUERY;

typedef struct tagNET_DVR_POSITION_RULE_CFG
{
    DWORD                   dwSize;             // ṹС 
    NET_DVR_PTZ_POSITION    struPtzPosition;    // λϢ
    NET_VCA_RULECFG         struVcaRuleCfg;     //Ϊ
    BYTE                    byRes2[80];         // ֽ
}NET_DVR_POSITION_RULE_CFG, *LPNET_DVR_POSITION_RULE_CFG;

typedef struct tagNET_DVR_POSITION_RULE_CFG_V41
{
    DWORD                   dwSize;             // ṹС 
    NET_DVR_PTZ_POSITION    struPtzPosition;    // λϢ
    NET_VCA_RULECFG_V41         struVcaRuleCfg;     //Ϊ
    BYTE  byTrackEnable; //Ƿø
    BYTE  byRes1;
    WORD wTrackDuration; //ٳʱ䣬λs
    BYTE                    byRes2[76];         // ֽ
}NET_DVR_POSITION_RULE_CFG_V41, *LPNET_DVR_POSITION_RULE_CFG_V41;


typedef struct tagNET_DVR_LIMIT_ANGLE
{
    BYTE                byEnable;    // Ƿóλ
    BYTE                byRes1[3];
    NET_DVR_PTZPOS      struUp;     // λ
    NET_DVR_PTZPOS      struDown;   // λ
    NET_DVR_PTZPOS      struLeft;   // λ
    NET_DVR_PTZPOS      struRight;  // λ
    BYTE                byRes2[20];
}NET_DVR_LIMIT_ANGLE, *LPNET_DVR_LIMIT_ANGLE;

typedef struct tagNET_DVR_POSITION_INDEX
{
    BYTE    byIndex;    // 
    BYTE    byRes1;
    WORD    wDwell;    // ͣʱ 
    BYTE    byRes2[4];   // ֽ
}NET_DVR_POSITION_INDEX, *LPNET_DVR_POSITION_INDEX;

#define  MAX_POSITION_NUM 10
typedef struct tagNET_DVR_POSITION_TRACK_CFG
{
    DWORD dwSize;
    BYTE    byNum; // 
    BYTE    byRes1[3];
    NET_DVR_POSITION_INDEX   struPositionIndex[MAX_POSITION_NUM];
    BYTE    byRes2[8];
}NET_DVR_POSITION_TRACK_CFG, *LPNET_DVR_POSITION_TRACK_CFG;

//Ѳ·Ϣ
typedef struct tagNET_DVR_PATROL_SCENE_INFO
{
    WORD   wDwell;         // ͣʱ 30-300
    BYTE   byPositionID;   // 1-10Ĭ0ʾѲ㲻ӳ
    BYTE   byRes[5];
}NET_DVR_PATROL_SCENE_INFO, *LPNET_DVR_PATROL_SCENE_INFO;

// ѲϢ
typedef struct tagNET_DVR_PATROL_TRACKCFG
{
    DWORD  dwSize;                                 // ṹС
    NET_DVR_PATROL_SCENE_INFO struPatrolSceneInfo[10];    // Ѳ·
    BYTE   byRes[16];                              // ֽ
}NET_DVR_PATROL_TRACKCFG, *LPNET_DVR_PATROL_TRACKCFG;

//ع˵ýṹ
typedef struct tagNET_DVR_TRACK_PARAMCFG
{
    DWORD   dwSize;             // ṹС
    WORD    wAlarmDelayTime;    // ʱʱ䣬Ŀǰֻ֧ȫ Χ1-120
    WORD    wTrackHoldTime;     // ٳʱ  Χ0-300
    BYTE    byTrackMode;        //   IPDOME_TRACK_MODE
    BYTE     byPreDirection;    // ٷԤ 0- 1-
    BYTE      byTrackSmooth;        //   0- 1-
    BYTE     byZoomAdjust;    // ϵ μ±
    BYTE    byMaxTrackZoom;    //ٱϵ,0-ʾĬϱϵ,ȼ6-궨ֵ*1.0(Ĭ),1-5ΪС궨ֵֵԽССıԽ,7-15ΪŴֵԽ󣬷ŴıԽ
    BYTE   byStopTrackWhenFindFace;  //⵽Ƿֹͣ 0- 1-
    BYTE   byStopTrackThreshold;   //ֵֹ
    BYTE   byRes[9];          //  ֽ                
}NET_DVR_TRACK_PARAMCFG, *LPNET_DVR_TRACK_PARAMCFG;

// о
typedef struct tagNET_DVR_DOME_MOVEMENT_PARAM
{
    WORD wMaxZoom;   // ϵ
    BYTE    byRes[42];  // ֽ
}NET_DVR_DOME_MOVEMENT_PARAM, *LPNET_DVR_DOME_MOVEMENT_PARAM;

/********************************ܽͨ¼ begin****************************************/
#define  MAX_REGION_NUM            8       // бĿ
#define  MAX_TPS_RULE            8       // Ŀ
#define  MAX_AID_RULE            8      // ¼Ŀ
#define  MAX_LANE_NUM            8        // 󳵵Ŀ

//ͨ¼ͣ
typedef enum tagTRAFFIC_AID_TYPE
{
    CONGESTION          = 0x01,    //ӵ
        PARKING             = 0x02,    //ͣ  
        INVERSE             = 0x04,    //
        PEDESTRIAN          = 0x08,    //                      
        DEBRIS              = 0x10,    // Ƭ 
        SMOKE               = 0x20,    //  
        OVERLINE            = 0x40,     //ѹ
        VEHICLE_CONTROL_LIST  = 0x80,  //
        SPEED                 = 0x100,  //
        LANECHANGE         = 0x200,      //
        TURNAROUND         = 0x400,     //ͷ
        VEHICLE_OCCUPANCY_NONVEHICLE = 0x800, //ռ÷ǻλ
        GASSER            = 0x1000    //
}TRAFFIC_AID_TYPE;

typedef enum tagTRAFFIC_SCENE_MODE
{
    FREEWAY = 0,    //  ٻⳡ
        TUNNEL,         //  
        BRIDGE          //  
}TRAFFIC_SCENE_MODE;

typedef enum tagITS_ABILITY_TYPE
{
    ITS_CONGESTION_ABILITY             = 0x01,      //ӵ
        ITS_PARKING_ABILITY                = 0x02,      //ͣ  
        ITS_INVERSE_ABILITY                = 0x04,      //
        ITS_PEDESTRIAN_ABILITY             = 0x08,      //                      
        ITS_DEBRIS_ABILITY                 = 0x10,      // Ƭ
        ITS_SMOKE_ABILITY                  = 0x20,      //-
        ITS_OVERLINE_ABILITY               = 0x40,      //ѹ
        ITS_VEHICLE_CONTROL_LIST_ABILITY   = 0x80,        //
        ITS_SPEED_ABILITY                   = 0x100,        //        
        ITS_LANECHANGE_ABILITY             = 0x200,     //
        ITS_TURNAROUND_ABILITY             = 0x400,      //ͷ
        ITS_LANE_VOLUME_ABILITY            = 0x010000,  //
        ITS_LANE_VELOCITY_ABILITY          = 0x020000,  //ƽٶ
        ITS_TIME_HEADWAY_ABILITY           = 0x040000,  //ͷʱ
        ITS_SPACE_HEADWAY_ABILITY          = 0x080000,  //ͷ
        ITS_TIME_OCCUPANCY_RATIO_ABILITY   = 0x100000,  //ռʣʱ)
        ITS_SPACE_OCCUPANCY_RATIO_ABILITY  = 0x200000,  //ռʣٷֱȼ㣨ռ)
        ITS_LANE_QUEUE_ABILITY             = 0x400000,  //Ŷӳ
        ITS_VEHICLE_TYPE_ABILITY           = 0x800000,  //
        ITS_TRAFFIC_STATE_ABILITY          = 0x1000000  //ͨ״̬
}ITS_ABILITY_TYPE;

// ͨͳƲ
typedef enum tagITS_TPS_TYPE
{
    LANE_VOLUME           = 0x01,    //
        LANE_VELOCITY         = 0x02,    //ٶ
        TIME_HEADWAY          = 0x04,    //ͷʱ
        SPACE_HEADWAY         = 0x08,    //ͷ
        TIME_OCCUPANCY_RATIO  = 0x10,    //ռ (ʱ)
        SPACE_OCCUPANCY_RATIO = 0x20,    //ռʣٷֱȼ(ռ)
        QUEUE                 = 0x40,    //Ŷӳ
        VEHICLE_TYPE          = 0x80,    //
        TRAFFIC_STATE         = 0x100    //ͨ״̬
}ITS_TPS_TYPE; 

typedef struct tagNET_DVR_REGION_LIST 
{
    DWORD    dwSize;    // ṹС
    BYTE    byNum;      // 
    BYTE    byRes1[3];    // ֽ
    NET_VCA_POLYGON struPolygon[MAX_REGION_NUM]; // 
    BYTE    byRes2[20];    // ֽ
}NET_DVR_REGION_LIST,*LPNET_DVR_REGION_LIST;


// ṹ
typedef struct tagNET_DVR_DIRECTION
{
    NET_VCA_POINT struStartPoint;   // ʼ
    NET_VCA_POINT struEndPoint;     //  
}NET_DVR_DIRECTION, *LPNET_DVR_DIRECTION;

// 
typedef struct tagNET_DVR_ONE_LANE
{
    BYTE    byEnable;                   // Ƿ
    BYTE    byRes1[11];                    // ֽ
    BYTE    byLaneName[NAME_LEN];       // 
    NET_DVR_DIRECTION struFlowDirection;// ڳ
    NET_VCA_POLYGON struPolygon;        // 
}NET_DVR_ONE_LANE, *LPNET_DVR_ONE_LANE;

// 
typedef struct tagNET_DVR_LANE_CFG
{
    DWORD    dwSize;    // ṹС
    NET_DVR_ONE_LANE struLane[MAX_LANE_NUM];    //  ±ΪID
    BYTE    byRes1[40];     // ֽ
}NET_DVR_LANE_CFG, *LPNET_DVR_LANE_CFG;

// ͨ¼
typedef struct tagNET_DVR_AID_PARAM
{
    WORD    wParkingDuration;       // Υͣ  10-120s
    WORD    wPedestrianDuration;    // ˳ʱ    1-120s
    WORD    wDebrisDuration;        // ʱ  10-120s
    WORD    wCongestionLength;      // ӵ³ֵ    5-200ף
    WORD    wCongestionDuration;    // ӵ³    10-120s
    WORD    wInverseDuration;       // гʱ    1-10s
    WORD    wInverseDistance;       // оֵ λm Χ[2-100] Ĭ 10
    WORD    wInverseAngleTolerance; // Ƕƫ 90-180,ļн
    WORD    wIllegalParkingTime;    // Υͣʱ[4,60]λ ,TFS(ͨΥȡ֤) ģʽ
    WORD    wIllegalParkingPicNum;  // ΥͣͼƬ[1,6], TFS(ͨΥȡ֤) ģʽ
    BYTE    byMergePic;             // ͼƬƴ,TFS ģʽ 0- ƴ 1- ƴ
    BYTE    byRes1[23];             // ֽ
}NET_DVR_AID_PARAM, *LPNET_DVR_AID_PARAM;

// ͨ¼ṹ
typedef struct tagNET_DVR_ONE_AID_RULE
{   
    BYTE    byEnable;                   // Ƿ¼
    BYTE    byRes1[3];                  // ֽ
    BYTE    byRuleName[NAME_LEN];       //  
    DWORD   dwEventType;                // ͨ¼ TRAFFIC_AID_TYPE
    NET_VCA_SIZE_FILTER struSizeFilter; // ߴ
    NET_VCA_POLYGON     struPolygon;    // 
    NET_DVR_AID_PARAM   struAIDParam;   //  ¼
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //ʽ 
    BYTE byRelRecordChan[MAX_CHANNUM_V30];        //¼ͨ,Ϊ1ʾͨ
    BYTE byRes2[20];
}NET_DVR_ONE_AID_RULE, *LPNET_DVR_ONE_AID_RULE;

// ͨ¼
typedef struct tagNET_DVR_AID_RULECFG
{
    DWORD   dwSize;                    // ṹС 
    BYTE    byPicProType;              //ʱͼƬʽ 0- 0-ϴ
    BYTE    byRes1[3];                 // ֽ
    NET_DVR_JPEGPARA struPictureParam; //ͼƬṹ
    NET_DVR_ONE_AID_RULE  struOneAIDRule[MAX_AID_RULE];
    BYTE    byRes2[32];
}NET_DVR_AID_RULECFG, *LPNET_DVR_AID_RULECFG;

// ͨ¼ṹ(չ)
typedef struct tagNET_DVR_ONE_AID_RULE_V41
{   
    BYTE                        byEnable;                 // Ƿ¼
    BYTE                        byLaneNo;                 // 
    BYTE                        byRes1[2];                // ֽ
    BYTE                        byRuleName[NAME_LEN];     //  
    DWORD                       dwEventType;              // ͨ¼ TRAFFIC_AID_TYPE
    NET_VCA_SIZE_FILTER         struSizeFilter;           // ߴ
    NET_VCA_POLYGON             struPolygon;              // 
    NET_DVR_AID_PARAM           struAIDParam;             // ¼
    NET_DVR_SCHEDTIME           struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];// ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;              //ʽ 
    BYTE                        byRelRecordChan[MAX_IVMS_IP_CHANNEL]; //¼ͨ1ʾͨ0ʾ 
    BYTE                        byRes2[60];               //
}NET_DVR_ONE_AID_RULE_V41, *LPNET_DVR_ONE_AID_RULE_V41;

// ͨ¼(չ)
typedef struct tagNET_DVR_AID_RULECFG_V41
{
    DWORD   dwSize;                     // ṹС 
    BYTE    byPicProType;               // ʱͼƬʽ 0- 0-ϴ
    BYTE    byRes1[3];                  // ֽ
    NET_DVR_JPEGPARA struPictureParam;     // ͼƬṹ
    NET_DVR_ONE_AID_RULE_V41  struAIDRule[MAX_AID_RULE];  //
    BYTE    byRes2[128];                //
} NET_DVR_AID_RULECFG_V41, *LPNET_DVR_AID_RULECFG_V41;

// ͨͳƲṹ
typedef struct tagNET_DVR_ONE_TPS_RULE
{
    BYTE    byEnable;                   //Ƿʹܳͨ
    BYTE    byLaneID;                    //ID
    BYTE    byRes1[2];
    DWORD   dwCalcType;                 //ͳƲITS_TPS_TYPE
    NET_VCA_SIZE_FILTER struSizeFilter; //ߴ 
    NET_VCA_POLYGON struVitrualLoop;    //Ȧ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;    //ʽ,һΪǷϴģܲҪ
    BYTE    byRes2[20];                         //ֽ
}NET_DVR_ONE_TPS_RULE, *LPNET_DVR_ONE_TPS_RULE;

// ͨͳƹýṹ
typedef struct tagNET_DVR_TPS_RULECFG
{
    DWORD   dwSize;              // ṹС
    NET_DVR_ONE_TPS_RULE struOneTpsRule[MAX_TPS_RULE]; // ±ӦͨID
    BYTE    byRes2[40];         // ֽ
}NET_DVR_TPS_RULECFG, *LPNET_DVR_TPS_RULECFG;

// ͨͳƲṹ(չ)
typedef struct tagNET_DVR_ONE_TPS_RULE_V41
{
    BYTE    byEnable;                     //Ƿʹܳͨ
    BYTE    byLaneID;                      //ID
    BYTE    byRes1[2];                    //
    DWORD   dwCalcType;                   // ͳƲITS_TPS_TYPE
    NET_VCA_SIZE_FILTER  struSizeFilter;  //ߴ 
    NET_VCA_POLYGON      struVitrualLoop; //Ȧ
    NET_DVR_SCHEDTIME    struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;       //ʽ 
    BYTE    byRes2[60];                   // ֽ
}NET_DVR_ONE_TPS_RULE_V41, *LPNET_DVR_ONE_TPS_RULE_V41;


// ͨͳƹýṹ(չ)
typedef struct tagNET_DVR_TPS_RULECFG_V41
{
    DWORD   dwSize;         // ṹС
    NET_DVR_ONE_TPS_RULE_V41 struOneTpsRule[MAX_TPS_RULE]; // ±ӦͨID
    BYTE    byRes[128];     // 
}NET_DVR_TPS_RULECFG_V41, *LPNET_DVR_TPS_RULECFG_V41;

// ͨ¼Ϣ
typedef struct tagNET_DVR_AID_INFO
{
    BYTE            byRuleID;   // ţΪýṹ±꣬0-16
    BYTE            byRes1[3];
    BYTE            byRuleName[NAME_LEN]; //  
    DWORD           dwAIDType;  // ¼
    NET_DVR_DIRECTION   struDirect; // ָ  
    BYTE    bySpeedLimit; //ֵλkm/h[0,255]
    BYTE    byCurrentSpeed; //ǰٶֵλkm/h[0,255]
    BYTE            byRes2[38];  // ֽ 
}NET_DVR_AID_INFO, *LPNET_DVR_AID_INFO;

// ͨ¼ 
typedef struct tagNET_DVR_AID_ALARM
{
    DWORD               dwSize;         // ṹ
    DWORD               dwRelativeTime;    // ʱ
    DWORD               dwAbsTime;        // ʱ
    NET_VCA_DEV_INFO      struDevInfo;    // ǰ豸Ϣ
    NET_DVR_AID_INFO    struAIDInfo;    // ͨ¼Ϣ
    DWORD               dwPicDataLen;   // ͼƬĳ Ϊ0ʾûͼƬ0ʾýṹͼƬ
    BYTE                *pImage;        // ָͼƬָ 
    BYTE                byRes[40];      // ֽ  
}NET_DVR_AID_ALARM, *LPNET_DVR_AID_ALARM;

// нṹ 
typedef struct tagNET_DVR_LANE_QUEUE
{
    NET_VCA_POINT   struHead;       //ͷ
    NET_VCA_POINT   struTail;       //β
    DWORD           dwLength;      //ʵʶг λΪ [0-500]
}NET_DVR_LANE_QUEUE, *LPNET_DVR_LANE_QUEUE; 

typedef enum tagTRAFFIC_DATA_VARY_TYPE
{
    NO_VARY,         //ޱ仯 
        VEHICLE_ENTER,   //Ȧ
        VEHICLE_LEAVE,   //뿪Ȧ 
        UEUE_VARY        //б仯             
}TRAFFIC_DATA_VARY_TYPE; 

typedef struct tagNET_DVR_LANE_PARAM
{
    BYTE    byRuleName[NAME_LEN];  // 
    BYTE    byRuleID;              //ţΪýṹ±꣬0-7 
    BYTE    byVaryType;            //ͨ仯  TRAFFIC_DATA_VARY_TYPE
    BYTE    byLaneType;               //л
    BYTE    byRes1;
    DWORD    dwLaneVolume;         // ͳжٳͨ
    DWORD   dwLaneVelocity;        //ٶȣ
    DWORD   dwTimeHeadway;         //ͷʱ࣬
    DWORD   dwSpaceHeadway;        //ͷ࣬
    float   fSpaceOccupyRation;    //ռʣٷֱȼ㣨ռ)
    NET_DVR_LANE_QUEUE  struLaneQueue;    //г
    NET_VCA_POINT       struRuleLocation; //Ȧĵλ
    BYTE    byRes2[32];
}NET_DVR_LANE_PARAM, *LPNET_DVR_LANE_PARAM;


typedef struct tagNET_DVR_TPS_INFO
{
    DWORD   dwLanNum;   // ͨĳĿ
    NET_DVR_LANE_PARAM  struLaneParam[MAX_TPS_RULE];
}NET_DVR_TPS_INFO, *LPNET_DVR_TPS_INFO;

typedef struct tagNET_DVR_TPS_ALARM
{
    DWORD             dwSize;          //ṹС
    DWORD             dwRelativeTime;  //ʱ
    DWORD             dwAbsTime;       //ʱ
    NET_VCA_DEV_INFO  struDevInfo;     //ǰ豸Ϣ
    NET_DVR_TPS_INFO  struTPSInfo;     //ͨ¼Ϣ
    BYTE              byRes1[32];      //ֽ
}NET_DVR_TPS_ALARM, *LPNET_DVR_TPS_ALARM;

typedef enum tagTRAFFIC_DATA_VARY_TYPE_EX_ENUM
{    
    ENUM_TRAFFIC_VARY_NO             = 0x00,   //ޱ仯
        ENUM_TRAFFIC_VARY_VEHICLE_ENTER  = 0x01,   //Ȧ
        ENUM_TRAFFIC_VARY_VEHICLE_LEAVE  = 0x02,   //뿪Ȧ
        ENUM_TRAFFIC_VARY_QUEUE          = 0x04,   //б仯
        ENUM_TRAFFIC_VARY_STATISTIC      = 0x08,   //ͳݱ仯ÿӱ仯һΰƽٶȣռ/ʱռʣͨ״̬        
}TRAFFIC_DATA_VARY_TYPE_EX_ENUM;  

typedef struct tagNET_DVR_LANE_PARAM_V41
{
    BYTE               byRuleName[NAME_LEN]; // 
    BYTE               byRuleID;             // ţΪýṹ±꣬0-7 
    BYTE               byLaneType;             // л
    BYTE               byTrafficState;       // Ľͨ״̬0-Ч1-ͨ2-ӵ3-
    BYTE               byLaneNo;            //
    DWORD              dwVaryType;           // ͨ仯Ͳ  TRAFFIC_DATA_VARY_TYPE_EX_ENUMλ
    DWORD              dwTpsType;            // ݱ仯ͱ־ʾǰϴͳƲУЩЧITS_TPS_TYPE,λ
    DWORD              dwLaneVolume;         // ͳжٳͨ
    DWORD              dwLaneVelocity;       // ٶȣ
    DWORD              dwTimeHeadway ;       // ͷʱ࣬
    DWORD              dwSpaceHeadway;       // ͷ࣬
    float              fSpaceOccupyRation;   // ռʣٷֱȼ㣨ռ)
    float              fTimeOccupyRation;    // ʱռʣٷֱȼ
    DWORD              dwLightVehicle;       // Сͳ
    DWORD              dwMidVehicle;         // ͳ
    DWORD              dwHeavyVehicle;       // ͳ
    NET_DVR_LANE_QUEUE struLaneQueue;        // г
    NET_VCA_POINT      struRuleLocation;     // λȦ
    DWORD               dwOversizeVehicle;    // ͳ
    BYTE               byRes2[60];           // 
}NET_DVR_LANE_PARAM_V41, *LPNET_DVR_LANE_PARAM_V41;


typedef struct tagNET_DVR_TPS_INFO_V41
{
    DWORD                   dwLanNum;          // ͨĳĿ
    NET_DVR_LANE_PARAM_V41  struLaneParam[MAX_TPS_RULE];
    BYTE                    byRes[32];         //
}NET_DVR_TPS_INFO_V41, *LPNET_DVR_TPS_INFO_V41;

//  
typedef struct tagNET_DVR_FACEDETECT_RULECFG
{
    DWORD          dwSize;              // ṹС
    BYTE           byEnable;            // Ƿ
    BYTE           byEventType;            //¼ͣ 0-쳣; 1-;2-쳣&;
    BYTE           byUpLastAlarm;       //2011-04-06 Ƿϴһεı
    BYTE           byUpFacePic; //Ƿϴͼ0-1-    
    BYTE           byRuleName[NAME_LEN];
    NET_VCA_POLYGON     struVcaPolygon;    // 
    BYTE           byPicProType;    //ʱͼƬʽ 0- 0-ϴ
    BYTE           bySensitivity;   // 
    WORD            wDuration;      // ʱֵ
    NET_DVR_JPEGPARA    struPictureParam;         //ͼƬṹ
    NET_VCA_SIZE_FILTER struSizeFilter;         //ߴ
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //ʽ 
    BYTE           byRelRecordChan[MAX_CHANNUM_V30];            //¼ͨ,Ϊ1ʾͨ
    BYTE           byPicRecordEnable;  /*2012-3-1ǷͼƬ洢, 0-, 1-*/
    BYTE            byRes2[39];         //ֽ
}NET_DVR_FACEDETECT_RULECFG, *LPNET_DVR_FACEDETECT_RULECFG;

typedef struct tagNET_DVR_FACE_PIPCFG
{    
    BYTE byEnable; //Ƿл
    BYTE byBackChannel; //ͨţͨ
    BYTE byPosition; //λã0-,1-,2-,3-
    BYTE byPIPDiv; //ϵ(:廭)0-1:4,1-1:9,2-1:16
    BYTE byRes[4];
}NET_DVR_FACE_PIPCFG, *LPNET_DVR_FACE_PIPCFG;

typedef struct tagNET_DVR_FACEDETECT_RULECFG_V41
{
    DWORD dwSize;              // ṹС
    BYTE  byEnable;            // Ƿ
    BYTE  byEventType;            //¼ͣ 0-쳣; 1-;2-쳣&;
    BYTE  byUpLastAlarm;       //2011-04-06 Ƿϴһεı
    BYTE  byUpFacePic; //Ƿϴͼ0-1-    
    BYTE  byRuleName[NAME_LEN];
    NET_VCA_POLYGON struVcaPolygon;    // 
    BYTE  byPicProType;    //ʱͼƬʽ 0- 0-ϴ
    BYTE  bySensitivity;   // 
    WORD  wDuration;      // ʱֵ
    NET_DVR_JPEGPARA    struPictureParam;         //ͼƬṹ
    NET_VCA_SIZE_FILTER struSizeFilter;         //ߴ
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//ʱ
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //ʽ 
    BYTE  byRelRecordChan[MAX_CHANNUM_V30];            //¼ͨ,Ϊ1ʾͨ
    BYTE  byPicRecordEnable;  /*2012-10-22ǷͼƬ洢, 0-, 1-*/
    BYTE  byRes1;
    WORD  wAlarmDelay; //2012-10-22ܱʱ0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    NET_DVR_FACE_PIPCFG struFacePIP; //2012-11-7л
    WORD  wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; //ץͼͨͨʱͬʱϴͨץͼƬ0ʾֵΪͨ
    BYTE  byRes[22];         //ֽ
}NET_DVR_FACEDETECT_RULECFG_V41, *LPNET_DVR_FACEDETECT_RULECFG_V41;

typedef struct tagNET_DVR_FACEDETECT_ALARM
{
    DWORD   dwSize;         //ṹС
    DWORD     dwRelativeTime; //ʱ
    DWORD    dwAbsTime;        //ʱ
    BYTE    byRuleName[NAME_LEN];   //
    NET_VCA_TARGET_INFO  struTargetInfo;//ĿϢ
    NET_VCA_DEV_INFO       struDevInfo;//ǰ豸Ϣ
    DWORD   dwPicDataLen;    //ͼƬĳ Ϊ0ʾûͼƬ0ʾýṹͼƬ*/
    BYTE    byAlarmPicType;    // 0-쳣ͼƬ 1- ͼƬ,2- 
    BYTE    byPanelChan;    /*2012-3-1ͨͨ*/
    BYTE    byRelAlarmPicNum; //ͨͼƬ
    BYTE    byRes1;
    DWORD   dwFacePicDataLen;//ͼƬĳ Ϊ0ʾûͼƬ0ʾýṹͼƬ*/
    DWORD   dwAlarmID;    //IDԱʶͨϱ0ʾЧ
    BYTE    byRes2[44];   // ֽ
    BYTE    *pFaceImage; //ָͼָ
    BYTE    *pImage;                           //ָͼƬָ
}NET_DVR_FACEDETECT_ALARM, *LPNET_DVR_FACEDETECT_ALARM;

typedef struct tagNET_DVR_EVENT_PARAM_UNION
{
    DWORD   uLen[3];            // СΪ12ֽ
    DWORD  dwHumanIn;      //˽ӽ 0 -  1-   
    float       fCrowdDensity;  // Աۼֵ
}NET_DVR_EVENT_PARAM_UNION, *LPNET_DVR_EVENT_PARAM_UNION;

// Ŀǰֻ¼Աۼ¼ʵʱϴ
typedef struct tagNET_DVR_EVENT_INFO
{
    BYTE   byRuleID;                // Rule ID
    BYTE   byRes[3];                // ֽ
    BYTE   byRuleName[NAME_LEN];    // 
    DWORD       dwEventType;            // VCA_EVENT_TYPE
    NET_DVR_EVENT_PARAM_UNION uEventParam;  // 
}NET_DVR_EVENT_INFO, *LPNET_DVR_EVENT_INFO;

typedef struct tagNET_DVR_EVENT_INFO_LIST
{
    BYTE            byNum;        // ¼ʵʱϢ
    BYTE            byRes1[3];            // ֽ
    NET_DVR_EVENT_INFO struEventInfo[MAX_RULE_NUM];    // ¼ʵʱϢ
}NET_DVR_EVENT_INFO_LIST,*LPNET_DVR_EVENT_INFO_LIST;

typedef struct tagNET_DVR_RULE_INFO_ALARM
{
    DWORD             dwSize;                // ṹС
    DWORD         dwRelativeTime;     // ʱ
    DWORD        dwAbsTime;            // ʱ
    NET_VCA_DEV_INFO      struDevInfo;        // ǰ豸Ϣ
    NET_DVR_EVENT_INFO_LIST struEventInfoList;    //¼Ϣб
    BYTE            byRes2[40];            // ֽ
}NET_DVR_RULE_INFO_ALARM, *LPNET_DVR_RULE_INFO_ALARM;

//ʱ
typedef struct tagNET_DVR_ONE_SCENE_TIME
{
    BYTE     byActive;                     //0 -Ч,1CЧ
    BYTE     byRes1[3];                    //
    DWORD    dwSceneID;                    //ID
    NET_DVR_SCHEDTIME struEffectiveTime;   //Чʱ
    BYTE     byRes2[16];                   //
}NET_DVR_ONE_SCENE_TIME, *LPNET_DVR_ONE_SCENE_TIME ;

//Чʱ
typedef struct tagNET_DVR_SCENE_TIME_CFG
{   
    DWORD  dwSize;                                               //ṹС
    NET_DVR_ONE_SCENE_TIME struSceneTime[MAX_SCENE_TIMESEG_NUM]; //ʱ
    BYTE   byRes[64];                                            //
}NET_DVR_SCENE_TIME_CFG, *LPNET_DVR_SCENE_TIME_CFG;


//Ϣ
typedef struct  tagNET_DVR_ONE_SCENE_CFG_
{    
    BYTE   byEnable;                 //Ƿøó,0- 1- 
    BYTE   byDirection;              //ⷽ 1-У2-У3-˫4-ɶ5-򱱣6-򶫣7-ɱϣ8-
    BYTE   byRes1[2];                //
    DWORD  dwSceneID;                //ID(ֻ), 0 - ʾóЧ
    BYTE   bySceneName[NAME_LEN];    //
    NET_DVR_PTZPOS struPtzPos;       //ptz 
    DWORD  dwTrackTime;              //ʱ[5,300] 룬TFS(ͨȡ֤)ģʽЧ
    BYTE   byRes2[24];               //
}NET_DVR_ONE_SCENE_CFG, *LPNET_DVR_ONE_SCENE_CFG;

//ýṹ
typedef struct tagNET_DVR_SCENE_CFG
{
    DWORD dwSize;                                          //ṹС
    NET_DVR_ONE_SCENE_CFG struSceneCfg[MAX_ITS_SCENE_NUM]; //Ϣ
    BYTE   byRes[40];                                      //
}NET_DVR_SCENE_CFG,*LPNET_DVR_SCENE_CFG;

//ೡ
typedef struct tagNET_DVR_SCENE_COND
{
    DWORD   dwSize;       //ṹС
    LONG    lChannel;     //ͨ
    DWORD   dwSceneID;    //ID, 0-ʾóЧ
    BYTE    byRes[48];    //
}NET_DVR_SCENE_COND, *LPNET_DVR_SCENE_COND;

//ȡ֤ʽ
typedef struct tagNET_DVR_FORENSICS_MODE
{
    DWORD  dwSize;      //ṹС
    BYTE   byMode;      // 0-ֶȡ֤ ,1-Զȡ֤2-Զٺ;̬ȡ֤
    BYTE   byRes[23];   //
}NET_DVR_FORENSICS_MODE,*LPNET_DVR_FORENSICS_MODE;

//Ϣ
typedef struct tagNET_DVR_SCENE_INFO_
{  
    DWORD           dwSceneID;              //ID, 0 - ʾóЧ
    BYTE            bySceneName[NAME_LEN];  //
    BYTE            byDirection;            //ⷽ 1-У2-У3-˫4-ɶ5-򱱣6-򶫣7-ɱϣ8-
    BYTE            byRes1[3];              //
    NET_DVR_PTZPOS  struPtzPos;             //Ptz 
    BYTE            byRes2[64] ;            //
}NET_DVR_SCENE_INFO,*LPNET_DVR_SCENE_INFO;

//ͨ¼(չ)
typedef struct tagNET_DVR_AID_ALARM_V41
{
    DWORD              dwSize;              //ṹ
    DWORD              dwRelativeTime;        //ʱ
    DWORD              dwAbsTime;            //ʱ
    NET_VCA_DEV_INFO   struDevInfo;            //ǰ豸Ϣ
    NET_DVR_AID_INFO   struAIDInfo;         //ͨ¼Ϣ
    NET_DVR_SCENE_INFO struSceneInfo;       //Ϣ
    DWORD              dwPicDataLen;        //ͼƬ
    BYTE               *pImage;             //ָͼƬָ
    // 0-ֱϴ; 1-ƴ洢URL(3.7Ver)ԭȵͼƬݱURLݣͼƬȱURL
    BYTE               byDataType;
    BYTE               byLaneNo;  // 
    WORD               wMilliSecond;        //ʱ
    //ţ·ڱšڲţ
    BYTE                  byMonitoringSiteID[MONITORSITE_ID_LEN/*48*/];
    BYTE                  byDeviceID[DEVICE_ID_LEN/*48*/];//豸
    BYTE               byRes[28]; // ֽ   
}NET_DVR_AID_ALARM_V41, *LPNET_DVR_AID_ALARM_V41;

//ͨͳϢ(չ)
typedef struct tagNET_DVR_TPS_ALARM_V41
{
    DWORD                 dwSize;          // ṹС
    DWORD                 dwRelativeTime;  // ʱ
    DWORD                 dwAbsTime;       // ʱ
    NET_VCA_DEV_INFO      struDevInfo;     // ǰ豸Ϣ
    NET_DVR_TPS_INFO_V41  struTPSInfo;     // ͨͳϢ 
    //ţ·ڱšڲţ
    BYTE           byMonitoringSiteID[MONITORSITE_ID_LEN/*48*/];
    BYTE           byDeviceID[DEVICE_ID_LEN/*48*/];//豸 
    DWORD                dwStartTime;  // ʼͳʱ
    DWORD                dwStopTime;    // ͳʱ
    BYTE                   byRes[24];      // 
} NET_DVR_TPS_ALARM_V41,*LPNET_DVR_TPS_ALARM_V41;

/*******************************ܽͨ¼ end*****************************************/

#define XXX_MAJOR_VERSION      2

/* Ӱ汾ţŻֲṹģڼ汾ʱ31 */

#define XXX_SUB_VERSION        3

/* 汾ţbug31 */

#define XXX_REVISION_VERSION   4

typedef struct tagNET_DVR_VCA_VERSION
{
    WORD    wMajorVersion;        // 汾
    WORD    wMinorVersion;        // ΰ汾
    WORD    wRevisionNumber;    // 
    WORD    wBuildNumber;        // 
    WORD    wVersionYear;        //    汾-
    BYTE    byVersionMonth;        //    汾-
    BYTE    byVersionDay;        //    汾-
    BYTE    byRes[8];            // ֽ
}NET_DVR_VCA_VERSION, *LPNET_DVR_VCA_VERSION;


/****************************** end***********************************/

/******************************ʶ begin******************************************/
typedef struct tagNET_DVR_PLATE_PARAM
{    
    BYTE    byPlateRecoMode;    //ʶģʽ,ĬΪ1(Ƶģʽ)
    BYTE    byBelive;            //Ŷֵ, ֻƵʶʽ, ݱӳ̶, 󴥷ʸ߾, ©ʸ߾, 80-90Χ
    BYTE    byRes[22];          //ֽ
}NET_DVR_PALTE_PARAM, *LPNET_DVR_PALTE_PARAM;

typedef struct tagNET_DVR_PLATECFG
{    
    DWORD        dwSize;
    DWORD    dwEnable;                           /* ǷƵʶ 0 1 */
    BYTE    byPicProType;    //ʱͼƬʽ 0- 0-ϴ
    BYTE    byRes1[3];  // ֽ
    NET_DVR_JPEGPARA struPictureParam;         //ͼƬṹ
    NET_DVR_PALTE_PARAM struPlateParam;   // ʶ
    NET_DVR_HANDLEEXCEPTION struHandleType;       /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];//ʱ
    BYTE    byRelRecordChan[MAX_CHANNUM];        //¼ͨ,Ϊ1ʾͨ
    BYTE   byRes[20];   // ֽ
}NET_DVR_PLATECFG, *LPNET_DVR_PLATECFG;

// ʶӽṹ
typedef struct tagNET_DVR_PLATE_INFO
{
    BYTE  byPlateType;                    //
    BYTE  byColor;                        //ɫ
    BYTE  byBright;                        //
    BYTE  byLicenseLen;                    //ַ
    BYTE  byEntireBelieve;                //ƵŶȣ-100
    BYTE  byRegion;     // ֵ 0-1-ŷ(EU)2-(ER)3-ŷ&˹(EU&CIS) ,0xff-
    BYTE  byCountry;     // ֵöCOUNTRY_INDEX֧"COUNTRY_ALL = 0xff, //ALL  ȫ"
    BYTE  byRes[33];                    //
    NET_VCA_RECT    struPlateRect;        //λ
    char sLicense[MAX_LICENSE_LEN];        //ƺ
    BYTE byBelieve[MAX_LICENSE_LEN];    //ʶַŶȣ⵽"A12345", ŶΪ,20,30,40,50,60,70ʾ""ȷĿֻ%"A"ֵȷĿ%
}NET_DVR_PLATE_INFO, *LPNET_DVR_PLATE_INFO;

typedef struct tagNET_DVR_PLATERECO_RESULE
{
    DWORD dwSize;
    DWORD    dwRelativeTime;                //ʱ
    DWORD    dwAbsTime;                        //ʱ
    NET_VCA_DEV_INFO struDevInfo;           // ǰ豸Ϣ
    NET_DVR_PLATE_INFO struPlateInfo;
    DWORD dwPicDataLen;                        //ͼƬĳ Ϊ0ʾûͼƬ0ʾýṹͼƬ*/
    DWORD dwRes[4];                            //Ϊ0
    BYTE  *pImage;                           //ָͼƬָ
}NET_DVR_PLATERECO_RESULE, *LPNET_DVR_PLATERECO_RESULE;

/******************************ʶ end******************************************/

/*******************************Ƶۺƽ̨***********************************/
typedef struct 
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;    //Main type 1-alarm; 2-abnormal; 3-operation; 0xff-all 
    DWORD    dwMinorType;    //Hypo-Type 0-all;
    BYTE    sPanelUser[MAX_NAMELEN]; //user ID for local panel operation
    BYTE    sNetUser[MAX_NAMELEN];//user ID for network operation
    NET_DVR_IPADDR    struRemoteHostAddr;//remote host IP
    DWORD    dwParaType;//parameter type
    DWORD    dwChannel;//channel number
    DWORD    dwDiskNumber;//HD number
    DWORD    dwAlarmInPort;//alarm input port
    DWORD    dwAlarmOutPort;//alarm output port
    DWORD   dwInfoLen;
    BYTE    byDevSequence;//λ
    BYTE    byMacAddr[MACADDR_LEN];//MACַ,6
    BYTE    sSerialNumber[SERIALNO_LEN];//кţ48
    char    sInfo[LOG_INFO_LEN - SERIALNO_LEN - MACADDR_LEN - 1 ];
}NET_DVR_LOG_MATRIX, *LPNET_DVR_LOG_MATRIX;

//2009-11-21 Ƶۺƽ̨
typedef struct tagVEDIOPLATLOG
{
    BYTE bySearchCondition;//0-λ1-к2-MACַ
    //λţ0-79ӦϵͳĲλţ
    //0xffʾе־78K6467
    //0xfeʾ78Kϵ־0xfd־0xfc־
    BYTE byDevSequence;
    BYTE  sSerialNumber[SERIALNO_LEN];//кţ48
    BYTE  byMacAddr[MACADDR_LEN];//MACַ,6
} NET_DVR_VEDIOPLATLOG, *LPNET_DVR_VEDIOPLATLOG;

typedef struct tagNET_DVR_CODESYSTEMABILITY
{
    DWORD dwSize;
    DWORD dwAbilityVersion;//汾ţ16λʾ汾16λʾΰ汾 
    DWORD dwSupportMaxVideoFrameRate;//λ(K)
                                     /*λ:
                                     0:ʱ¼
                                     1:ʱ|¼¼ 
                                     2:ƶ¼
                                     3:翪¼
                                     4:ƶ|翪¼
                                     5:ƶ&翪¼
                                     6:ܽ¼
                                     7:ⴥ¼
                                     8:ʶ𴥷¼
    9:ֶ¼*/
    DWORD dwSupportRecordType;
    BYTE  bySupportLinkMode;//λ:0λ:ʾ1λ:ʾ
    BYTE  bySupportStringRow;//ַ֧
    BYTE  bySupportHideNum;//֧Ƶڵ
    BYTE  byRes1;
    /*0-DCIF1-CIF2-QCIF3-4CIF4-2CIF6-QVGA(320*240), 16-VGA17-UXGA18-SVGA19-HD720p20-XVGA21-HD900p22-SXGAp27-HD1080i28-2560*192029-1600*30430-2048*153631-2448*204832-2448*120033-2448*800 34-XGA1024x76835-SXGA1280x1024*/
    BYTE  byMainStreamSupportResolution[8];//ֵ֧ķֱʣλ
    BYTE  bySubStreamSupportResolution[8];//ֵ֧ķֱʣλ
    BYTE  byEventStreamSupportResolution[8];//¼ֵ֧ķֱʣλ
    BYTE  byNotSupportPreview;//Ƿ֧Ԥ,1-֧֣0-֧
    BYTE  byNotSupportStorage;//Ƿִ֧洢,1-֧֣0-֧
    BYTE  byRes2[98];//        
}NET_DVR_CODESYSTEMABILITY, *LPNET_DVR_CODESYSTEMABILITY;

/********************************end*******************************************/

/******************************ץĻ*******************************************/
//IO
typedef struct tagNET_DVR_IO_INCFG
{
    DWORD   dwSize;
    BYTE    byIoInStatus;//IO״̬0-½أ1-أ2-غ½أ3-ߵƽ4-͵ƽ
    BYTE    byRes[3];//ֽ
}NET_DVR_IO_INCFG, *LPNET_DVR_IO_INCFG;

//IO
typedef struct tagNET_DVR_IO_OUTCFG
{
    DWORD   dwSize;
    BYTE    byDefaultStatus;//IOĬ״̬0-͵ƽ1-ߵƽ 
    BYTE    byIoOutStatus;//IOЧʱ״̬0-͵ƽ1-ߵƽ2-
    WORD    wAheadTime;//IOǰʱ䣬λus
    DWORD   dwTimePluse;//ʱ䣬λus
    DWORD   dwTimeDelay;//IOЧʱ䣬λus
    BYTE    byFreqMulti;        //ƵֵΧ[1,15]
    BYTE    byDutyRate;        //ռձȣ[0,40%]
    BYTE    byRes[2];
}NET_DVR_IO_OUTCFG, *LPNET_DVR_IO_OUTCFG;

//
typedef struct tagNET_DVR_FLASH_OUTCFG
{
    DWORD  dwSize;
    BYTE   byMode;//˸ģʽ0-1-2-3-
    BYTE   byRelatedIoIn;//ƹIOţʱ˲Ч
    BYTE   byRecognizedLane;  /*IOţλʾbit0ʾIO1Ƿ0-1-*/
    BYTE   byDetectBrightness;/*Զʹ0-⣻1-*/
    BYTE   byBrightnessThreld;/*ʹֵΧ[0,100],ֵ*/
    BYTE   byStartHour;        //ʼʱ-Сʱ,ȡֵΧ0-23
    BYTE   byStartMinute;        //ʼʱ-,ȡֵΧ0-59
    BYTE   byEndHour;             //ʱ-Сʱ,ȡֵΧ0-23
    BYTE   byEndMinute;        //ʱ-,ȡֵΧ0-59
    BYTE   byFlashLightEnable;    //ʱʹ:0-;1-
    BYTE   byRes[2];
}NET_DVR_FLASH_OUTCFG, *LPNET_DVR_FLASH_OUTCFG;

//̵ƹܣ2IOһ飩
typedef struct tagNET_DVR_LIGHTSNAPCFG
{
    DWORD   dwSize;
    BYTE    byLightIoIn;//̵ƵIO 
    BYTE    byTrigIoIn;//IO
    BYTE    byRelatedDriveWay;//IOĳ
    BYTE    byTrafficLight; //0-ߵƽƣ͵ƽ̵ƣ1-ߵƽ̵ƣ͵ƽ
    BYTE     bySnapTimes1; //ץĴ10-ץģ0-Ĵ5 
    BYTE     bySnapTimes2; //̵ץĴ20-ץģ0-Ĵ5 
    BYTE    byRes1[2];
    WORD    wIntervalTime1[MAX_INTERVAL_NUM];//ļʱ䣬ms
    WORD    wIntervalTime2[MAX_INTERVAL_NUM];//̵ļʱ䣬ms
    BYTE    byRecord;//¼־0-¼1-¼
    BYTE    bySessionTimeout;//¼ʱʱ䣨룩
    BYTE    byPreRecordTime;//¼ƬԤ¼ʱ()
    BYTE    byVideoDelay;//¼Ƭʱʱ䣨룩
    BYTE    byRes2[32];//ֽ
}NET_DVR_LIGHTSNAPCFG, *LPNET_DVR_LIGHTSNAPCFG;

//ٹ(2IOһ飩
typedef struct tagNET_DVR_MEASURESPEEDCFG
{
    DWORD   dwSize;
    BYTE    byTrigIo1;   //ٵ1Ȧ
    BYTE    byTrigIo2;   //ٵ2Ȧ
    BYTE    byRelatedDriveWay;//IOĳ
    BYTE    byTestSpeedTimeOut;//ģʽʱʱ䣬λs
    DWORD   dwDistance;//Ȧ,cm
    BYTE    byCapSpeed;//ģʽٶȣλkm/h
    BYTE    bySpeedLimit;//ֵλkm/h
    BYTE     bySnapTimes1; //Ȧ1ץĴ0-ץģ0-Ĵ5 
    BYTE     bySnapTimes2; //Ȧ2ץĴ0-ץģ0-Ĵ5 
    WORD    wIntervalTime1[MAX_INTERVAL_NUM];//Ȧ1ļʱ䣬ms
    WORD    wIntervalTime2[MAX_INTERVAL_NUM];//Ȧ2ļʱ䣬ms
    BYTE    byRes[32];//ֽ
}NET_DVR_MEASURESPEEDCFG, *LPNET_DVR_MEASURESPEEDCFG;


//
typedef struct tagNET_DVR_CLOUDSTORAGE_COND
{
    DWORD  dwSize;
    DWORD  dwChannel;
    BYTE    byRes1[64];
}NET_DVR_CLOUDSTORAGE_COND,*LPNET_DVR_CLOUDSTORAGE_COND;

//ýṹ
typedef struct tagNET_DVR_POOLPARAM
{
    DWORD  dwPoolID;// ƴ洢ڵ
    BYTE    byRes[4];
}NET_DVR_POOLPARAM,*LPNET_DVR_POOLPARAM;

typedef struct tagNET_DVR_CLOUDSTORAGE_CFG
{
    DWORD   dwSize;
    BYTE    byEnable;//0-1-
    BYTE    byRes[3];
    NET_DVR_IPADDR  struIP;
    WORD    wPort;//ݶ˿
    BYTE    byRes1[2];
    char    szUser[CLOUD_NAME_LEN/*48*/]; //û
    char    szPassword[CLOUD_PASSWD_LEN/*48*/];     // 
    NET_DVR_POOLPARAM  struPoolInfo[16];//0ʾ¼أ1ʾΥ¼أ2ʾݳأIPC/D
    BYTE    byRes2[128];
}NET_DVR_CLOUDSTORAGE_CFG,*LPNET_DVR_CLOUDSTORAGE_CFG;

typedef  struct  tagNET_DVR_PARKLAMP_COND
{ 
    DWORD  dwSize;
    DWORD  dwChannel;   //ͨ
    BYTE   byParkingIndex;   //Գλţ14
    BYTE   byRes[15];     //
}NET_DVR_PARKLAMP_COND, *LPNET_DVR_PARKLAMP_COND;

typedef  struct  tagNET_DVR_PARKLAMP_INFOCFG
{ 
    DWORD dwSize;
    char  sLicense[MAX_LICENSE_LEN/*16*/];//ƺ
    char  sParkingNo[MAX_LICENSE_LEN/*16*/];//λ(ʵʵĳλ)
    BYTE   byLampFlicker;//0~˸ 1 ˸ (λָʾ˸)
    BYTE   byLampColor;//0-  1- 2-  3-  4- 5-Ʒ 6- 7-ɫ  (λָʾɫ)
    BYTE   byStatus; //λ״̬ 0-޳1-г
    BYTE   byColorDepth; //ɫǳ0-ɫ1-ǳɫ
    BYTE   byColor;//ɫ0-ɫ1-ɫ2-ɫ3-ɫ4-ɫ5-ɫ6-7-ɫ8-ɫ9-ɫ10-ɫ11-ɫ12-ɫ0xff-δгɫʶ 
    //Ʒʶ οö VLR_VEHICLE_CLASS
    BYTE   byVehicleLogoRecog; 
    BYTE   byRes[250];//
}NET_DVR_PARKLAMP_INFOCFG, *LPNET_DVR_PARKLAMP_INFOCFG;

//Ƶ
typedef struct tagNET_DVR_VIDEOEFFECT
{
    BYTE byBrightnessLevel; /*0-100*/
    BYTE byContrastLevel; /*0-100*/
    BYTE bySharpnessLevel; /*0-100*/
    BYTE bySaturationLevel; /*0-100*/
    BYTE byHueLevel; /*0-100,*/
    BYTE byEnableFunc; //ʹܣλʾbit0-SMART IR()bit1-ն,bit2-ǿʹܣ0-1-
    BYTE byLightInhibitLevel; //ǿƵȼ[1-3]ʾȼ
    BYTE byGrayLevel; //Ҷֵ0-[0-255]1-[16-235]
}NET_DVR_VIDEOEFFECT, *LPNET_DVR_VIDEOEFFECT;

//
typedef struct tagNET_DVR_GAIN
{
    BYTE byGainLevel; /*棺0-100*/
    BYTE byGainUserSet; /*ûԶ棻0-100ץĻCCDģʽµץ*/
    BYTE byRes[2];
    DWORD dwMaxGainValue;/*ֵλdB*/
}NET_DVR_GAIN, *LPNET_DVR_GAIN;

//ƽ
typedef struct tagNET_DVR_WHITEBALANCE
{
BYTE byWhiteBalanceMode; /*0-ֶƽ⣨MWB,1-Զƽ1AWB1,2-Զƽ2 (AWB2),3-ԶƸΪƽ(Locked WB)
                         4-(Indoor)5-(Outdoor)6-չ(Fluorescent Lamp)7-Ƶ(Sodium Lamp)
                         8-Զ(Auto-Track)9-һΰƽ(One Push)10-Զ(Auto-Outdoor)
                         11-ƵԶ (Auto-Sodiumlight)12-ˮ(Mercury Lamp)13-Զƽ(Auto)
14-׳ (IncandescentLamp)15-ů(Warm Light Lamp)16-Ȼ(Natural Light) */
BYTE byWhiteBalanceModeRGain; /*ֶƽʱЧֶƽ R*/
BYTE byWhiteBalanceModeBGain; /*ֶƽʱЧֶƽ B*/
BYTE byRes[5];
}NET_DVR_WHITEBALANCE, *LPNET_DVR_WHITEBALANCE;

//ع
typedef struct tagNET_DVR_EXPOSURE
{
    BYTE  byExposureMode; /*0 ֶع 1Զع*/
    BYTE  byAutoApertureLevel; /* ԶȦ, 0-10 */ 
    BYTE  byRes[2];
    DWORD dwVideoExposureSet; /* ԶƵعʱ䣨λus*//*ע:ԶعʱֵΪعֵ 20-1s(1000000us)*/        
    DWORD dwExposureUserSet; /* Զعʱ,ץĻӦʱCCDģʽʱץĿٶ*/   
    DWORD dwRes;    
} NET_DVR_EXPOSURE, *LPNET_DVR_EXPOSURE;

//̬
typedef struct tagNET_DVR_WDR
{
    BYTE byWDREnabled; /*̬0 dsibale  1 enable 2 auto*/
    BYTE byWDRLevel1; /*0-F*/
    BYTE byWDRLevel2; /*0-F*/
    BYTE byWDRContrastLevel; /*0-100*/
    BYTE byRes[16];
} NET_DVR_WDR, *LPNET_DVR_WDR;

typedef struct tagNET_DVR_WDR_CFG
{
    DWORD  dwSize;   //ṹС
    NET_DVR_WDR  struWDR; //Ϣ
}NET_DVR_WDR_CFG, *LPNET_DVR_WDR_CFG;


//ҹת
typedef struct tagNET_DVR_DAYNIGHT
{
    BYTE byDayNightFilterType; /*ҹл0-죬1-ҹ2-Զ3-ʱ4-봥, 5-Զģʽ2޹*/
    BYTE bySwitchScheduleEnabled; /*0 dsibale  1 enable,()*/
    //ʱģʽ
    BYTE byBeginTime; /*ʼʱ䣨Сʱ0-23*/
    BYTE byEndTime; /*ʱ䣨Сʱ0-23*/
    //ģʽ2
    BYTE byDayToNightFilterLevel; //0-7
    BYTE byNightToDayFilterLevel; //0-7
    BYTE byDayNightFilterTime;//(60)
    //ʱģʽ
    BYTE byBeginTimeMin; //ʼʱ䣨֣0-59
    BYTE byBeginTimeSec; //ʼʱ䣨룩0-59
    BYTE byEndTimeMin; //ʱ䣨֣0-59
    BYTE byEndTimeSec; //ʱ䣨룩0-59
    //봥ģʽ
    BYTE byAlarmTrigState; //봥״̬0-죬1-ҹ
} NET_DVR_DAYNIGHT, *LPNET_DVR_DAYNIGHT;

//GammaУ
typedef struct tagNET_DVR_GAMMACORRECT
{
    BYTE byGammaCorrectionEnabled; /*0 dsibale  1 enable*/
    BYTE byGammaCorrectionLevel; /*0-100*/
    BYTE byRes[6];
} NET_DVR_GAMMACORRECT, *LPNET_DVR_GAMMACORRECT;

//ⲹ
typedef struct tagNET_DVR_BACKLIGHT
{
    BYTE byBacklightMode; /*ⲹ:0 off 1 UP2 DOWN3 LEFT4 RIGHT5MIDDLE6Զ壬10-11-Զ12-򱳹ⲹ*/
    BYTE byBacklightLevel; /*0x0-0xF*/
    BYTE byRes1[2];
    DWORD dwPositionX1; //X1
    DWORD dwPositionY1; //Y1
    DWORD dwPositionX2; //X2
    DWORD dwPositionY2; //Y2
    BYTE byRes2[4];
} NET_DVR_BACKLIGHT, *LPNET_DVR_BACKLIGHT;

//ֽ빦
typedef struct tagNET_DVR_NOISEREMOVE
{
    BYTE byDigitalNoiseRemoveEnable; /*0-ã1-ͨģʽֽ룬2-רģʽֽ*/
    BYTE byDigitalNoiseRemoveLevel; /*ͨģʽֽ뼶0x0-0xF*/
    BYTE bySpectralLevel;       /*רģʽ¿ǿȣ0-100*/
    BYTE byTemporalLevel;   /*רģʽʱǿȣ0-100*/
    BYTE byDigitalNoiseRemove2DEnable;         /* ץ֡2D룬0-ã1- */    
    BYTE byDigitalNoiseRemove2DLevel;            /* ץ֡2D뼶0-100 */
    BYTE byRes[2];
} NET_DVR_NOISEREMOVE, *LPNET_DVR_NOISEREMOVE;

//CMOSģʽǰ˾ͷ
typedef struct tagNET_DVR_CMOSMODCFG
{
    BYTE byCaptureMod;   //ץģʽ0-ץģʽ11-ץģʽ2
    BYTE byBrightnessGate;//ֵ
    BYTE byCaptureGain1;   //ץ1,0-100
    BYTE byCaptureGain2;   //ץ2,0-100
    DWORD dwCaptureShutterSpeed1;//ץĿٶ1
    DWORD dwCaptureShutterSpeed2;//ץĿٶ2
    BYTE  byRes[4];
}NET_DVR_CMOSMODECFG, *LPNET_DVR_CMOSMODECFG;

//ǰ˲
typedef struct tagNET_DVR_CAMERAPARAMCFG
{
    DWORD dwSize;
    NET_DVR_VIDEOEFFECT struVideoEffect;/*ȡԱȶȡͶȡȡɫ*/    
    NET_DVR_GAIN struGain;/*Զ*/
    NET_DVR_WHITEBALANCE struWhiteBalance;/*ƽ*/
    NET_DVR_EXPOSURE struExposure; /*ع*/
    NET_DVR_GAMMACORRECT struGammaCorrect;/*GammaУ*/
    NET_DVR_WDR struWdr;/*̬*/
    NET_DVR_DAYNIGHT struDayNight;/*ҹת*/
    NET_DVR_BACKLIGHT struBackLight;/*ⲹ*/
    NET_DVR_NOISEREMOVE struNoiseRemove;/*ֽ*/
    BYTE byPowerLineFrequencyMode; /*0-50HZ; 1-60HZ*/
    /*
        0-ԶȦ, 
        1-ֶȦ, 
        2-P-Iris1,
        3-Union 3-9mm F1.6-2.7 (T5280-PQ1) [IPC5.1.7]
        4-Union 2.8-12mm F1.6-2.7 (T5289-PQ1) [IPC5.1.7]
        5-HIK 3.8-16mm F1.5HV3816P-8MPIR)
        6-HIK 11-40mm F1.7 (HV1140P-8MPIR)
        7-HIK 2.7-12mm F1.2TV2712P-MPIR
    */
    BYTE byIrisMode;  
    BYTE byMirror ;  /* 0 off1- leftright2- updown3-center */
    BYTE byDigitalZoom;  /*:0 dsibale  1 enable*/
    BYTE byDeadPixelDetect;   /*,0 dsibale  1 enable*/
    BYTE byBlackPwl;/*ڵƽ ,  0-255*/ 
    BYTE byEptzGate;// EPTZر:0-ǫ̃1-ǫ̃
    BYTE byLocalOutputGate;//ر0-ر1-BNC 2-HDMIر  
    //20-HDMI_720P50
    //21-HDMI_720P60
    //22-HDMI_1080I60
    //23-HDMI_1080I50
    //24-HDMI_1080P24
    //25-HDMI_1080P25
    //26-HDMI_1080P30
    //27-HDMI_1080P50
    //28-HDMI_1080P60
    //40-SDI_720P50,
    //41-SDI_720P60,
    //42-SDI_1080I50,
    //43-SDI_1080I60,
    //44-SDI_1080P24,
    //45-SDI_1080P25,
    //46-SDI_1080P30,
    //47-SDI_1080P50,
    //48-SDI_1080P60
    BYTE byCoderOutputMode;//fpgaģʽ0ֱͨ3ذ
    BYTE byLineCoding; //Ƿб룺0-1-
    BYTE byDimmerMode; //ģʽ0-Զ1-Զ
    BYTE byPaletteMode; //ɫ壺0-ȣ1-ȣ2-ɫ28-ɫ8
    BYTE byEnhancedMode; //ǿʽܱ̽ߣ0-ǿ1-12-23-34-4
    BYTE byDynamicContrastEN;    //̬Աȶǿ 0-1
    BYTE byDynamicContrast;    //̬Աȶ 0-100
    BYTE byJPEGQuality;    //JPEGͼ 0-100
    NET_DVR_CMOSMODECFG struCmosModeCfg;//CMOSģʽǰ˲ãͷģʽȡ
    BYTE byFilterSwitch; //˲أ0-ã1-
    BYTE byFocusSpeed; //ͷٶȣ0-10
    BYTE byAutoCompensationInterval; //ʱԶŲ1-120λ
    BYTE bySceneMode;  //ģʽ0-⣬1-ڣ2-Ĭϣ3-
}NET_DVR_CAMERAPARAMCFG, *LPNET_DVR_CAMERAPARAMCFG;

//͸
typedef struct tagNET_DVR_DEFOGCFG
{
    BYTE byMode; //ģʽ0-ã1-Զģʽ2-ģʽ
    BYTE byLevel; //ȼ0-100
    BYTE byRes[6]; 
}NET_DVR_DEFOGCFG, *LPNET_DVR_DEFOGCFG;

//ӷ
typedef struct tagNET_DVR_ELECTRONICSTABILIZATION
{
    BYTE byEnable;//ʹ 0- ã1- 
    BYTE byLevel; //ȼ0-100
    BYTE byRes[6]; 
}NET_DVR_ELECTRONICSTABILIZATION, *LPNET_DVR_ELECTRONICSTABILIZATION;

//ģʽ
typedef struct tagNET_DVR_CORRIDOR_MODE_CCD
{
    BYTE       byEnableCorridorMode; //Ƿģʽ 0ã 1
    BYTE       byRes[11];
}NET_DVR_CORRIDOR_MODE_CCD, *LPNET_DVR_CORRIDOR_MODE_CCD;

// SMART IR()ò
typedef struct tagNET_DVR_SMARTIR_PARAM
{
    BYTE  byMode;//0ֶ1Զ
    BYTE  byIRDistance;//ȼ(ȼ)level:1~100 Ĭ:50ֶģʽӣ
    BYTE  byShortIRDistance;// ƾȼ(1~100)
    BYTE  byLongIRDistance;// Զƾȼ(1~100)
}NET_DVR_SMARTIR_PARAM,*LPNET_DVR_SMARTIR_PARAM;

//byIrisMode ΪP-Iris1ʱЧúȦСȼģʽ
typedef struct tagNET_DVR_PIRIS_PARAM
{
    BYTE  byMode;//0-Զ1-ֶ
    BYTE  byPIrisAperture;//ȦСȼ(ȼ,ȦС)level:1~100 Ĭ:50ֶģʽӣ
    BYTE  byRes[6];
}NET_DVR_PIRIS_PARAM,*LPNET_DVR_PIRIS_PARAM;


// 2014-02-25
typedef struct tagNET_DVR_LASER_PARAM_CFG
{
    //Length = 16
    BYTE    byControlMode;        //ģʽ            0-Ч1-Զ2-ֶ ĬԶ
    BYTE    bySensitivity;        //        0-100 Ĭ50
    BYTE    byTriggerMode;        //ƴģʽ    0-Ч1-о2- Ĭϻо
    BYTE    byBrightness;        //ģʽΪֶģʽЧ        0-255 Ĭ100
    BYTE    byAngle;            //ƽǶ        0-ЧΧ1-36  Ĭ12䷶ΧΪһԲȦڼǶǵԲİ뾶ĴС
    BYTE    byLimitBrightness;  //ģʽΪԶģʽЧ 0~100 2014-01-26
    BYTE    byEnabled ;         //ֶƼʹ 0-رգ1-
    BYTE    byIllumination;     //ǿ0~100
    BYTE    byLightAngle;       //Ƕ 0~100
    BYTE    byRes[7];           //
} NET_DVR_LASER_PARAM_CFG, *LPNET_DVR_LASER_PARAM_CFG;

typedef struct tagNET_DVR_FFC_PARAM
{
    //1-Schedule Mode,2-Temperature Mode, 3-Off 
    BYTE   byMode;
    //ʱ:ʾλӣѡ10,20,30,40,50,60,120,180,240
    BYTE   byRes1;
    WORD   wCompensateTime; //ʱģʽЧ
    BYTE   byRes2[4];
}NET_DVR_FFC_PARAM,*LPNET_DVR_FFC_PARAM;

typedef struct tagNET_DVR_DDE_PARAM   //sensor
{
    BYTE  byMode;//1-Off,2-Normal Mode,3-Expert Mode
    BYTE  byNormalLevel;//ͨģʽȼΧ[1,100]ͨģʽЧ
    BYTE  byExpertLevel;//רģʽȼΧ[1,100]רģʽЧ
    BYTE  byRes[5];
}NET_DVR_DDE_PARAM,*LPNET_DVR_DDE_PARAM;

typedef struct tagNET_DVR_AGC_PARAM
{
    BYTE  bySceneType;//1-Normal Sence,2-Highlight Sence,3-Manual Sence
    BYTE  byLightLevel;//ȵȼ[1,100]ֶģʽЧ
    BYTE  byGainLevel; //ȼ[1,100]ֶģʽЧ
    BYTE  byRes[5];
}NET_DVR_AGC_PARAM,*LPNET_DVR_AGC_PARAM;

//ץĻCCD 64ֽ
typedef struct tagNET_DVR_SNAP_CAMERAPARAMCFG 
{
    BYTE byWDRMode;   // ̬ģʽ;0~رգ1~ֿ̬ 2~̬
    BYTE byWDRType;    // ̬лģʽ; 0~ǿã1~ʱã2~
    BYTE byWDRLevel;   // ̬ȼ0~6Ӧ1-7Ĭ23
    BYTE byRes1;
    NET_DVR_TIME_EX struStartTime; //ʼ̬ʱ
    NET_DVR_TIME_EX struEndTime; //̬ʱ
    BYTE byDayNightBrightness; //ҹתֵ0-100Ĭ50
    //ɫǿ
    BYTE byMCEEnabled;//ɫǿʹܣtruefalseر
    BYTE byMCELevel;//ɫǿǿȣ0~100Ĭֵ50
    //ԶԱȶ
    BYTE byAutoContrastEnabled;//ԶԱȶʹܣtruefalseر
    BYTE byAutoContrastLevel;//ԶԱȵȼ0-100,Ĭ50
    //ϸǿ
    BYTE byLSEDetailEnabled;//ϸǿʹܣtruefalseر
    BYTE byLSEDetailLevel;//ϸǿȼ0-100,Ĭ50
    // License Plate Definition Enhancementǿ
    BYTE byLPDEEnabled;//ǿʹܣtruefalseر
    BYTE byLPDELevel;//ǿȼ0-100,Ĭ50
    BYTE byRes[35];
} NET_DVR_SNAP_CAMERAPARAMCFG,*LPNET_DVR_SNAP_CAMERAPARAMCFG;

//ѧ͸
typedef struct tagNET_DVR_OPTICAL_DEHAZE
{
    BYTE byEnable; //0~ùѧ͸1~ùѧ͸
    BYTE byRes[7]; 
} NET_DVR_OPTICAL_DEHAZE, *LPNET_DVR_OPTICAL_DEHAZE;

//ǰ˲
typedef struct tagNET_DVR_CAMERAPARAMCFG_EX
{
    DWORD dwSize;
    NET_DVR_VIDEOEFFECT struVideoEffect;/*ȡԱȶȡͶȡȡɫ*/    
    NET_DVR_GAIN struGain;/*Զ*/
    NET_DVR_WHITEBALANCE struWhiteBalance;/*ƽ*/
    NET_DVR_EXPOSURE struExposure; /*ع*/
    NET_DVR_GAMMACORRECT struGammaCorrect;/*GammaУ*/
    NET_DVR_WDR struWdr;/*̬*/
    NET_DVR_DAYNIGHT struDayNight;/*ҹת*/
    NET_DVR_BACKLIGHT struBackLight;/*ⲹ*/
    NET_DVR_NOISEREMOVE struNoiseRemove;/*ֽ*/
    BYTE byPowerLineFrequencyMode; /*0-50HZ; 1-60HZ*/
    BYTE byIrisMode; /*0-ԶȦ 1-ֶȦ, 2-P-Iris1, 3-Union 3-9mm F1.6-2.7 (T5280-PQ1), 4-Union 2.8-12mm F1.6-2.7 (T5289-PQ1),5-HIK 3.8-16mm F1.5HV3816P-8MPIR*/ 
    BYTE byMirror ;  /* 0 off1- leftright2- updown3-center 4-Auto*/
    BYTE byDigitalZoom;  /*:0 dsibale  1 enable*/
    BYTE byDeadPixelDetect;   /*,0 dsibale  1 enable*/
    BYTE byBlackPwl;/*ڵƽ ,  0-255*/ 
    BYTE byEptzGate;// EPTZر:0-ǫ̃1-ǫ̃
    BYTE byLocalOutputGate;//ر0-ر1-BNC 2-HDMIر  
    //20-HDMI_720P50
    //21-HDMI_720P60
    //22-HDMI_1080I60
    //23-HDMI_1080I50
    //24-HDMI_1080P24
    //25-HDMI_1080P25
    //26-HDMI_1080P30
    //27-HDMI_1080P50
    //28-HDMI_1080P60
    BYTE byCoderOutputMode;//fpgaģʽ0ֱͨ3ذ
    BYTE byLineCoding; //Ƿб룺0-1-
    BYTE byDimmerMode; //ģʽ0-Զ1-Զ
    BYTE byPaletteMode; //ɫ壺0-ȣ1-ȣ2-ɫ28-ɫ8, 9-ں1,10-ʺ,11-ں2,12-1,13-2,14-ɫ,15-ɫ1,16-ɫ2,17-,18-,19-,20-
    BYTE byEnhancedMode; //ǿʽܱ̽ߣ0-ǿ1-12-23-34-4
    BYTE byDynamicContrastEN;    //̬Աȶǿ 0-1
    BYTE byDynamicContrast;    //̬Աȶ 0-100
    BYTE byJPEGQuality;    //JPEGͼ 0-100
    NET_DVR_CMOSMODECFG struCmosModeCfg;//CMOSģʽǰ˲ãͷģʽȡ
    BYTE byFilterSwitch; //˲أ0-ã1-
    BYTE byFocusSpeed; //ͷٶȣ0-10
    BYTE byAutoCompensationInterval; //ʱԶŲ1-120λ
    BYTE bySceneMode;  //ģʽ0-⣬1-ڣ2-Ĭϣ3-
    NET_DVR_DEFOGCFG struDefogCfg;//͸
    NET_DVR_ELECTRONICSTABILIZATION struElectronicStabilization;//ӷ
    NET_DVR_CORRIDOR_MODE_CCD struCorridorMode;//ģʽ
    BYTE   byExposureSegmentEnable; //0~,1~  عʱʽ״عϵʱعʱ䵽мֵȻ浽мֵع⵽ֵ浽ֵ
    BYTE   byBrightCompensate;//ǿ [0~100]
    /*
    0-رա1-640*480@25fps2-640*480@30ps3-704*576@25fps4-704*480@30fps5-1280*720@25fps6-1280*720@30fps
    7-1280*720@50fps8-1280*720@60fps9-1280*960@15fps10-1280*960@25fps11-1280*960@30fps
    12-1280*1024@25fps13--1280*1024@30fps14-1600*900@15fps15-1600*1200@15fps16-1920*1080@15fps
    17-1920*1080@25fps18-1920*1080@30fps19-1920*1080@50fps20-1920*1080@60fps21-2048*1536@15fps22-2048*1536@20fps
    23-2048*1536@24fps24-2048*1536@25fps25-2048*1536@30fps26-2560*2048@25fps27-2560*2048@30fps
    28-2560*1920@7.5fps29-3072*2048@25fps30-3072*2048@30fps31-2048*1536@12.532-2560*1920@6.25
    33-1600*1200@2534-1600*1200@3035-1600*1200@12.536-1600*900@12.537-1280*960@12.5fps38-800*600@25fps39-800*600@30fps40
    4000*3000@12.5fps41-4000*3000@15fps42-4096*2160@20fps43-3840x2160@20fps 44-960*576@25fps45-960*480@30fps46-752*582@25fps
    47-768*494@30fps48-2560*1440@25fps49-2560*1440@30fps 50-720P@100fps51-720P@120fps52-2048*1536@50fps53-2048*1536@60fps
    54-3840*2160@25fps55-3840*2160@30fps56-4096*2160@25fps57-4096*2160@30fps 58-1280*1024@50fps59-1280*1024@60fps
    60-3072*2048@50fps61-3072*2048@60fps62-3072*1728@25fps63-3072*1728@30fps64-3072*1728@50fps65-3072*1728@60fps66-336*256@50fps67-336*256@60fps
    68-384*288@50fps69-384*288@60fps 70- 640 * 512@50fps 71- 640 * 512@60fps72-2592*1944@25fps73-2592*1944@30fps74-2688*1536@25fps75-2688*1536@30fps 
    76-2592*1944@20fps77-2592*1944@15fps78-2688*1520@20fps79-2688*1520@15fps80-2688*1520@25fps81-2688*1520@30fps82- 2720*2048@25fps 83- 2720*2048@30fps
    84-336*256@25fps85- 384*288@25fps86-640*512@25fps87-1280*960@50fps88-1280*960@60fps89-1280*960@100fps90-1280*960@120fps91-4000*3000@20fps
    92-1920*1200@25fps93-1920*1200@30fps94-2560*1920@25fps95-2560*1920@20fps96-2560*1920@30fps97-1280*1920@25fps98-1280*1920@30fps
    99-4000*3000@24fps100-4000*3000@25fps101-4000*3000@10fps102- 384*288@30fps103-2560*1920@15fps104-2400*3840@25fps105-1200*1920@25fps
    106-4096*1800@30fps107-3840*1680@30fps108-2560*1120@30fps109-704*320@30fps110-1280*560@30fps111-4096*1800@25fps112-3840*1680@25fps
    113-2560*1120@25fps114-704*320@25fps115-1280*560@25fps116-2400*3840@24fps117-3840*2400@24fps118-3840*2400@25fps119-2560*1920@12.5fps
    120-2560*2048@12fps121-2560*2048@15fps122-2560*1536@25fps123-2560*1536@30fps124-2256*2048@25fps125-2256*2048@30fps126-2592*2592@12.5fps127-2592*2592@15fps
    128 - 640*512@30fps129-2048*1520@30fps130-2048*1520@25fps131-3840*2160@24fps*/
    BYTE   byCaptureModeN; //ƵģʽNƣ
    BYTE   byCaptureModeP; //ƵģʽPƣ
    NET_DVR_SMARTIR_PARAM struSmartIRParam; //ŹϢ
    NET_DVR_PIRIS_PARAM struPIrisParam;//PIrisϢӦbyIrisModeֶδ2-PIris1ʼЧ
    //2014-02-25 
    NET_DVR_LASER_PARAM_CFG struLaserParam;    //
    NET_DVR_FFC_PARAM  struFFCParam;
    NET_DVR_DDE_PARAM  struDDEParam;
    NET_DVR_AGC_PARAM  struAGCParam;
    BYTE   byLensDistortionCorrection;//ͷУ 0-ر,1-
    BYTE   byRes1[3]; 
    NET_DVR_SNAP_CAMERAPARAMCFG struSnapCCD ; //ץĻCCDֻץĻ
    NET_DVR_OPTICAL_DEHAZE struOpticalDehaze;//ѧ͸
    BYTE   byRes2[180];
}NET_DVR_CAMERAPARAMCFG_EX, *LPNET_DVR_CAMERAPARAMCFG_EX;

typedef struct tagNET_DVR_FOCUSING_POSITION_STATE
{
    DWORD   dwSize;
    BYTE    byState;//۽λ״̬ 0-λ1-λ
    BYTE    byRes[31];    
}NET_DVR_FOCUSING_POSITION_STATE, *LPNET_DVR_FOCUSING_POSITION_STATE;

typedef enum _VCA_PLATE_COLOR_
{
    VCA_BLUE_PLATE  = 0,   //ɫ
        VCA_YELLOW_PLATE,      //ɫ
        VCA_WHITE_PLATE,       //ɫ
        VCA_BLACK_PLATE,       //ɫ
        VCA_GREEN_PLATE,       //ɫ
        VCA_BKAIR_PLATE,       //񺽺ɫ
        VCA_OTHER = 0xff       //
}VCA_PLATE_COLOR;

//
typedef enum _VCA_PLATE_TYPE_
{
    VCA_STANDARD92_PLATE = 0,    //׼ó
        VCA_STANDARD02_PLATE,        //02ʽó 
        VCA_WJPOLICE_PLATE,            //侯 
        VCA_JINGCHE_PLATE,            //
        STANDARD92_BACK_PLATE,         //ó˫β
        VCA_SHIGUAN_PLATE,          //ʹݳ
        VCA_NONGYONG_PLATE,         //ũó
        VCA_MOTO_PLATE              //Ħг
}VCA_PLATE_TYPE;

//ʶ
typedef enum _VTR_RESULT
{
    VTR_RESULT_OTHER      =  0,  //δ֪
    VTR_RESULT_BUS        =  1,  //ͳ
    VTR_RESULT_TRUCK      =  2,  //
    VTR_RESULT_CAR        =  3,  //γ
    VTR_RESULT_MINIBUS    =  4,  //
    VTR_RESULT_SMALLTRUCK =  5,  //С
    VTR_RESULT_HUMAN      =  6,  //
    VTR_RESULT_TUMBREL    =  7,  //ֳ
    VTR_RESULT_TRIKE      =  8,  //ֳ
    VTR_RESULT_SUV_MPV    =  9,  //SUV/MPV
    VTR_RESULT_MEDIUM_BUS =  10,  //Ϳͳ
    VTR_RESULT_MOTOR_VEHICLE = 11, //
    VTR_RESULT_NON_MOTOR_VEHICLE = 12,  //ǻ
    VTR_RESULT_SMALLCAR   = 13,   //Сͽγ
    VTR_RESULT_MICROCAR   = 14,   //΢ͽγ
    VTR_RESULT_PICKUP     = 15    //Ƥ
}VTR_RESULT;


//ɫ
typedef enum _VCR_CLR_CLASS
{
    VCR_CLR_UNSUPPORT  = 0,      //֧
        VCR_CLR_WHITE       = 1,   //
        VCR_CLR_SILVER        = 2,   //
        VCR_CLR_GRAY       = 3,      //
        VCR_CLR_BLACK      = 4,      //
        VCR_CLR_RED           = 5,      //
        VCR_CLR_DARKBLUE   = 6,      //
        VCR_CLR_BLUE       = 7,      //
        VCR_CLR_YELLOW     = 8,      //
        VCR_CLR_GREEN      = 9,      //
        VCR_CLR_BROWN      = 10,  //
        VCR_CLR_PINK       = 11,  //
        VCR_CLR_PURPLE     = 12,  //
        VCR_CLR_DARKGRAY   = 13,  //
        VCR_CLR_CYAN       = 14  //ɫ
}VCR_CLR_CLASS;

// 2013-11-04
typedef enum _VCA_OPERATE_TYPE_
{
    VCA_LICENSE_TYPE       = 0x1,  //ƺ
        VCA_PLATECOLOR_TYPE    = 0x2,  //ɫ
        VCA_CARDNO_TYPE        = 0x4,  //
        VCA_PLATETYPE_TYPE     = 0x8,  //
        VCA_LISTTYPE_TYPE      = 0x10, //
        VCA_INDEX_TYPE         = 0x20, //ˮ 2014-02-25
        VCA_OPERATE_INDEX_TYPE = 0x40  // 2014-03-03
}VCA_OPERATE_TYPE;

typedef enum _VCA_ILLEGAL_TYPE_
{
    VCA_POSTPIC_TYPE          = 0x1, //ͼƬ
        VCA_LOWSPEED_TYPE         = 0x2,  //
        VCA_HIGHSPEED_TYPE        = 0x4,  //
        VCA_RETROGRADE_TYPE       = 0x8,  //
        VCA_RUSH_REDLIGHT_TYPE    = 0x10,   //
        VCA_PRESS_LANE_TYPE       = 0x20, //ѹ
        VCA_VIOLATE_GUIDE_TYPE    = 0x40,//
        VCA_ROAD_STRAND_TYPE      = 0x80,//·(豸֧)
        VCA_VEHICLE_ILLEGAL_LANE_TYPE  = 0x100,//ռ
        VCA_ILLEGAL_LANE_CHANGE_TYPE   = 0x200,//Υ
        VCA_ILLEGAL_LANE_DRIVE_TYPE    = 0x400,//
        VCA_VIOLATE_BAN_TYPE           = 0x800,//Υ
        VCA_CROSS_PARKING_TYPE         = 0x1000,//·ͣ
        VCA_GREEN_PARKING_TYPE         = 0x2000//̵ͣ
}VCA_ILLEGAL_TYPE;

typedef enum _VCA_VEHICLE_TYPE_
{
    VCA_OTHER_TYPE          = 0x1,  //
        VCA_SMALLCAR_TYPE       = 0x2,  //Сͳ
        VCA_BIGCAR_TYPE         = 0x4,  //ͳ
        VCA_BUS_TYPE            = 0x8,  //ͳ
        VCA_TRUCK_TYPE          = 0x10,  //
        VCA_CAR_TYPE            = 0x20,   //γ
        VCA_MINIBUS_TYPE        = 0x40,   //
        VCA_SMALL_TRUCK_TYPE    = 0x80  //С
}VCA_VEHICLE_TYPE;

//Ʒ
typedef enum _VLR_VEHICLE_CLASS
{
    VLR_OTHER       = 0,    //
        VLR_VOLKSWAGEN  = 1,    //
        VLR_BUICK       = 2,    //
        VLR_BMW         = 3,    //
        VLR_HONDA       = 4,    //
        VLR_PEUGEOT     = 5,    //
        VLR_TOYOTA      = 6,    //
        VLR_FORD        = 7,    //
        VLR_NISSAN      = 8,    //ղ
        VLR_AUDI        = 9,    //µ
        VLR_MAZDA       = 10,   //Դ
        VLR_CHEVROLET   = 11,   //ѩ
        VLR_CITROEN     = 12,   //ѩ
        VLR_HYUNDAI     = 13,   //ִ
        VLR_CHERY       = 14,   //
        VLR_KIA         = 15,   //
        VLR_ROEWE       = 16,   //
        VLR_MITSUBISHI  = 17,   //
        VLR_SKODA       = 18,   //˹´
        VLR_GEELY       = 19,   //
        VLR_ZHONGHUA    = 20,   //л
        VLR_VOLVO       = 21,   //ֶ
        VLR_LEXUS       = 22,   //׿˹
        VLR_FIAT        = 23,   //
        VLR_EMGRAND     = 24,   //ۺ()
        VLR_DONGFENG    = 25,   //
        VLR_BYD         = 26,   //ǵ
        VLR_SUZUKI      = 27,   //ľ
        VLR_JINBEI      = 28,   //
        VLR_HAIMA       = 29,   //
        VLR_SGMW        = 30,   //
        VLR_JAC         = 31,   //
        VLR_SUBARU      = 32,   //˹³
        VLR_ENGLON      = 33,   //Ӣ()
        VLR_GREATWALL   = 34,   //
        VLR_HAFEI       = 35,   //
        VLR_ISUZU       = 36,   //ʮ()
        VLR_SOUEAST     = 37,   //
        VLR_CHANA       = 38,   //
        VLR_FOTON       = 39,   //
        VLR_XIALI       = 40,   //(һ)
        VLR_BENZ        = 41,   //
        VLR_FAW         = 42,   //һ
        VLR_NAVECO      = 43,   //ά
        VLR_LIFAN       = 44,   //
        VLR_BESTURN     = 45,   //һ(һ)
        VLR_CROWN       = 46,   //ʹ()
        VLR_RENAULT     = 47,   //ŵ
        VLR_JMC         = 48,   //JMC()
        VLR_MG          = 49,   //MG
        VLR_KAMA        = 50,   //
        VLR_ZOTYE       = 51,   //̩
        VLR_CHANGHE     = 52,   //
        VLR_XMKINGLONG  = 53,   //Ž()
        VLR_HUIZHONG    = 54,   //Ϻ()
        VLR_SZKINGLONG  = 55,   //ݽ
        VLR_HIGER       = 56,   //
        VLR_YUTONG      = 57,   //ͨ
        VLR_CNHTC       = 58,   //й
        VLR_BEIBEN      = 59,   //ؿ
        VLR_XINGMA      = 60,   //
        VLR_YUEJIN      = 61,   //Ծ
        VLR_HUANGHAI    = 62,   //ƺ
        VLR_OLDWALL     = 63,   //Ͽ
        VLR_CHANACOMMERCIAL = 64,   //
        VLR_PORSCHE                   = 65,               // ʱ
        VLR_CADILLAC                  = 66,               // 
        VLR_INFINITI                  = 67,               // Ӣ
        VLR_GLEAGLE                   = 68,               // ȫӥ()
        VLR_JEEP                      = 69,               // JEEP()
        VLR_LANDROVER                 = 70,               // ·
        VLR_CHANGFENG                 = 71,               // 
        VLR_BENNI                     = 72,               // ()
        VLR_ERA                       = 73,               // ʱ(ʱ)
        VLR_TAURUS                    = 74,               // ţ()
        VLR_EADO                      = 75,               // ݶ
        VLR_SHANQI                    = 76,               // 
        VLR_HONGYAN                   = 77,               // (άº)
        VLR_DRAGON                    = 78,               // ()
        VLR_JACTEXT                   = 79,               // JAC ()
        VLR_JACBUS                    = 80,               // ִͳ ()
        VLR_ANKAI                     = 81,               // ͳ
        VLR_SHENLONG                  = 82,               // ͳ
        VLR_DAEWOO                    = 83,               // ͳ
        VLR_WUZHENG                   = 84,               // 
        VLR_MAN                       = 85,               // MAN
        VLR_ZHONGTONG                 = 86,               // ͨͳ
        VLR_BAOJUN                    = 87,               // 
        VLR_BQWEIWANG                 = 88,               // 
        VLR_TRUMPCHE                  = 89,               // 
        VLR_LUFENG                    = 90,               // ½
        VLR_HMZHENGZHOU               = 91,               // ֣
        VLR_BEIJING                   = 92,               // 
        VLR_ZHONGSHUN                 = 93,               // ˳
        VLR_WEILIN                    = 94,               // 
        VLR_OPEL                      = 95,               // ŷ
        VLR_KARRY                     = 96,               // 
        VLR_SMA                       = 97,               // 
        VLR_SMATEXT                   = 98,               // SMA
        VLR_YUWIN                     = 99,               // Ԧʤ
        VLR_MINI                      = 100,               // MINI
        VLR_MARK                      = 101,               // MARKX 
        VLR_HAVAL                     = 102,               // HAVAL
        VLR_OGA                       = 103,               // ک
        VLR_VENUCIA                   = 104,               // 
        VLR_BYD2                      = 105,               // ǵʽ2 (ǵ)
        VLR_SMART                     = 106,               // SMART
        VLR_BAW                       = 107,               // 쳧BAW
        VLR_LUXGEN                    = 108,               // ǽ
        VLR_YEMA                      = 109,               // Ұ
        VLR_ZTE                       = 110,               // 
        VLR_EVERUS                    = 111,               // 
        VLR_CHRYSLER                  = 112,               // ˹
        VLR_GONOW                     = 113,               // 
        VLR_SHJIANG                   = 114,               // ɻ
        VLR_RUILIN                    = 115,               // 
        VLR_FORTA                     = 116,               // 
        VLR_GAGUAR                    = 117,               // ݱ
        VLR_HEIBAO                    = 118,               // ڱ
        VLR_TKING                     = 119,               // ƿ
        VLR_TKINGTEXT                 = 120,               // ƿ
        VLR_FODAY                     = 121,               // 
        VLR_LOTUS                     = 122,               // 
        VLR_NANJUN                    = 123,               // Ͽ
        VLR_SHUANGHUAN                = 124,               // ˫
        VLR_SAIBAO                    = 125,               // 
        VLR_HAWTAI                    = 126,               // ̩
        VLR_LIFO                      = 127,               // Դɵ
        VLR_JONWAY                    = 128,               // Դ
        VLR_FULONGMA                  = 129,               // 
        VLR_WEILI                     = 130,               // Ϋ
        VLR_ANCHI                     = 131,               // 
        VLR_PAIXI                     = 132,               // ϲ
        VLR_HIGERTEXT                 = 133,               // HIGER
        VLR_RIYECAR                   = 134,               // ҰῨ
        VLR_RIYETRUCK                 = 135,               // Ұؿ
        VLR_JIANGNAN                  = 136,               // 
        VLR_OLDZOTYE                  = 137,               // Ͽ̩
        VLR_OLDXIALI                  = 138,               // Ͽ
        VLR_NEWAOCHI                  = 139,               // °³
        VLR_CDW                       = 140,               // 
        VLR_CDWTEXT                   = 141,               // 
        VLR_CIIMO                     = 142,               // ˼
        VLR_CHANADS                   = 143,               // а
        VLR_DS                        = 144,               // 
        VLR_ROHENS                    = 145,               // ִͶ˹
        VLR_YANTAI                    = 146,               // ̨
        VLR_SHUANGLONG                = 147,               // ˫
        VLR_FENGLING                  = 148,               // ʱ
        VLR_XINKAI                    = 149,               // ¿
        VLR_GMC                       = 150,               // GMC
        VLR_DATONG                    = 151,               // ͨ
        VLR_BQYINXIANG                = 152,               // 
        VLR_NEWCHERY                  = 153,               // 
        VLR_MUDAN                     = 154,               // ĵ
        VLR_DAYUN                     = 155,               // 
        VLR_DONGWO                    = 156,               // 
        VLR_UNION                     = 157,               // 
        VLR_CHUNZHOU                  = 158,               // ޿ͳ
        VLR_SANY                      = 159,               // һع
        VLR_YAXING                    = 160,               // ǿͳ
        VLR_HENGTONG                  = 161,               // ͨͳ
        VLR_SHAOLIN                   = 162,               // ֿͳ
        VLR_YOUNG                     = 163,               // ͳ
        VLR_STOM                      = 164,               // ʮͨ
        VLR_SANHUAN                   = 165,               // 
        VLR_XUGONG                    = 166,               // 칤
        VLR_BEIFANG                   = 167,               // 
        VLR_JIANGHUAN                 = 168,               // 
        VLR_BJFARM                    = 169,               // ũ
        VLR_NEWDADI                   = 170,               // ´
        VLR_SUNWIN                    = 171,               // ֿͳ
        VLR_YINGTIAN                  = 172,               // Ӣ
        VLR_QINGQI                    = 173,               // 
        VLR_CHUFENG                   = 174,               // 
        VLR_SCANIA                    = 175,               // ˹
        VLR_JIULONG                   = 176,               // ͳ
        VLR_YOUYI                     = 177,               // ͳ
        VLR_SHANGRAO                  = 178,               // Ŀͳ
        VLR_JIJIANG                   = 179,               // 
        VLR_YANGZI                    = 180,               // ӿͳ
        VLR_XIWO                      = 181,               // ֿͳ
        VLR_CHANGJIANG                = 182,               // ͳ
        VLR_WUYI                      = 183,               // 
        VLR_CHENGDU                   = 184,               // ɶͳ
        VLR_TIANMA                    = 185,               // 
        VLR_BAOLONG                   = 186,               // 
        VLR_NEWYATU                   = 187,               // ;
        VLR_BARUI                     = 188,               // ǰ
        VLR_GUANZHI                   = 189,               // 
        VLR_XIYATE                    = 190,               // 
        VLR_BINLI                     = 191,               // 
        VLR_DADI                      = 192,               // 
        VLR_FUQI                      = 193,               // 
        VLR_HANGTIAN                  = 194,               // 
        VLR_HENGTIAN                  = 195,               // 
        VLR_JMCCAR                    = 196,               // 
        VLR_KAERSEN                   = 197,               // ɭ
        VLR_KAWEI                     = 198,               // 
        VLR_LANBOJINI                 = 199,               // 
        VLR_MASHALADI                 = 200,               // ɯ
        VLR_SHUCHI                    = 201,               // ۿͳ
        VLR_SHILI                     = 202,               // ʵͳ
        VLR_HUABEI                    = 203,               // пͻ
        VLR_YIZHENG                   = 204,               // 
        VLR_CHUNLAN                   = 205,               // 
        VLR_DAFA                      = 206,               // 
        VLR_SHENYE                    = 207,               // Ұ
        VLR_FALALI                    = 208,               // 
        VLR_FUXING                    = 209,               // 
        VLR_ANYUAN                    = 210,               // Դͳ
        VLR_JINGHUA                   = 211,               // ͳ
        VLR_TAIHU                     = 212,               // ̫ͳ
        VLR_WUZHOULONG                = 213,               // 
        VLR_CHANGLONG                 = 214,               // ¡ͳ
        VLR_YUEXI                     = 215,               // ͳ
        VLR_SHENMA                    = 216,               // ͳ
        VLR_LUSHAN                    = 217,               // ®ɽ
        VLR_WANFENG                   = 218,               // 
        VLR_GZYUNBAO                  = 219,               // Ʊ
        VLR_ZHONGDA                   = 220,               // д
        VLR_THREEWHEEL                = 221,               // ֳ
        VLR_TWOWHEEL                  = 222,               // ֳ
        VLR_JBC                       = 223,              // JBC
        VLR_YZJIANG                   = 224,               // ӽͳ
        VLR_CNJ                       = 225,               // ϿCNJ
        VLR_FORLAND                   = 226,               // ʱ
        VLR_FARMCAR                   = 227,               // ũó
        VLR_DONGFANGHONG              = 228,               // 
        VLR_STEYR                     = 229,               // ˹̫
        VLR_HONGQI                    = 230,               // 
        VLR_USER1       = 231,   //û1
        VLR_USER2       = 232,   //û2
        VLR_USER3       = 233,   //û3
        VLR_USER4       = 234,   //û4
        VLR_USER5       = 235,   //û5
        VLR_USER6       = 236,   //û6
        VLR_USER7       = 237,   //û7
        VLR_USER8       = 238    //û8
}VLR_VEHICLE_CLASS;

/********************ƷBegin*************************/
//Ʒ
typedef enum _VSB_VOLKSWAGEN_CLASS
{
    VSB_VOLKSWAGEN_OTHER          = 0,   // 
        VSB_VOLKSWAGEN_LAVIDA         = 1,   // 
        VSB_VOLKSWAGEN_CROSSLAVIDA    = 2,   // ʾ
        VSB_VOLKSWAGEN_TIGUAN         = 3,   // ;
        VSB_VOLKSWAGEN_TOURAN         = 4,   // ;
        VSB_VOLKSWAGEN_SANTANA        = 5,   // ɣ
        VSB_VOLKSWAGEN_SANTANA2000    = 6,   // ɣ2000
        VSB_VOLKSWAGEN_SANTANA3000    = 7,   // ɣ3000
        VSB_VOLKSWAGEN_VISTA          = 8,   // ɣ-־
        VSB_VOLKSWAGEN_PASSAT         = 9,   // 
        VSB_VOLKSWAGEN_PASSATLINGYU   = 10,  // -Ԧ
        VSB_VOLKSWAGEN_POLO           = 11,  // 
        VSB_VOLKSWAGEN_POLOCROSS      = 12,  // -˶
        VSB_VOLKSWAGEN_POLOGTI        = 13,  // -GTI
        VSB_VOLKSWAGEN_SAGITAR        = 14,  // 
        VSB_VOLKSWAGEN_MAGOTAN        = 15,  // 
        VSB_VOLKSWAGEN_JETTA          = 16,  // ݴ
        VSB_VOLKSWAGEN_BORA           = 17,  // 
        VSB_VOLKSWAGEN_NEWGOLF        = 18,  // ¸߶
        VSB_VOLKSWAGEN_GOLFGTI        = 19,  // ߶-GTI
        VSB_VOLKSWAGEN_GOL            = 20,  // ߶
        VSB_VOLKSWAGEN_CADDY          = 21,  // 
        VSB_VOLKSWAGEN_PHAETON        = 22,  // 
        VSB_VOLKSWAGEN_TOUREG         = 23,  // ;
        VSB_VOLKSWAGEN_SCIROCCO       = 24,  // п
        VSB_VOLKSWAGEN_BEETLE         = 25,  // ׿ǳ
        VSB_VOLKSWAGEN_SHARAN         = 26,  // 
        VSB_VOLKSWAGEN_MULTIVAN       = 27,  // 
        VSB_VOLKSWAGEN_CARBONCOPY     = 28,  // һ-CC
        VSB_VOLKSWAGEN_VISTACHANGDA   = 29,  // ɣ־-
        VSB_VOLKSWAGEN_BORASPORTLINE  = 30,   // -SPORTLINE
        VSR_VOLKSWAGEN_CC_1             =31,   //-CC-2012,2011,2010
        VSR_VOLKSWAGEN_Cross_POLO_1     = 32,   //-Cross-POLO-2010,2007
        VSR_VOLKSWAGEN_Cross_POLO_2     = 33,   //-Cross-POLO-2014,2012
        VSR_VOLKSWAGEN_MULTIVAN_1       = 34,   //-Multivan-2014,2012,2011
        VSR_VOLKSWAGEN_POLO_1           = 35,   //-POLO-2006,2005,2004,2003,2002
        VSR_VOLKSWAGEN_POLO_2           = 36,   //-POLO-2013,2012,2011
        VSR_VOLKSWAGEN_POLO_JINQU_1     = 37,   //-POLOȡ-2009,2008,2007,2006
        VSR_VOLKSWAGEN_POLO_JINQU_2     = 38,   //-POLOȡ-2011
        VSR_VOLKSWAGEN_Tiguan_1         = 39,   //-Tiguan-2011,2009
        VSR_VOLKSWAGEN_Tiguan_2         = 40,   //-Tiguan-2014,2013,2012
        VSR_VOLKSWAGEN_XIALANG_1        = 41,   //--2013,2012
        VSR_VOLKSWAGEN_BAOLAI_1         = 42,   //--2005,2004
        VSR_VOLKSWAGEN_BAOLAI_2         = 43,   //--2006
        VSR_VOLKSWAGEN_BAOLAI_3         = 44,   //--2012,2011,2010,2009,2008
        VSR_VOLKSWAGEN_BAOLAI_4         = 45,   //--2014,2013
        VSR_VOLKSWAGEN_SHANGKU_1        = 46,   //-п-2014,2013
        VSR_VOLKSWAGEN_PASATE_1         = 47,   //--2003,2001Ԧ
        VSR_VOLKSWAGEN_PASATE_2         = 48,   //--2007,2006,2005Ԧ
        VSR_VOLKSWAGEN_PASATE_3         = 49,   //--2009,2008,2007,2005,2004,2003,2001,2000
        VSR_VOLKSWAGEN_PASATE_4         = 50,   //--2011,2009Ԧ
        VSR_VOLKSWAGEN_PASATE_5         = 51,   //--2014,2013,2012,2011
        VSR_VOLKSWAGEN_JIEDA_1          = 52,   //-ݴ-2005CIF,2002
        VSR_VOLKSWAGEN_JIEDA_2          = 53,   //-ݴ-2009,2008,2006,2005,2004
        VSR_VOLKSWAGEN_JIEDA_3          = 54,   //-ݴ-2012,2010
        VSR_VOLKSWAGEN_JIEDA_4          = 55,   //-ݴ-2013
        VSR_VOLKSWAGEN_LANGYI_1         = 56,   //--2012,2011,2010,2009,2008
        VSR_VOLKSWAGEN_LANGYI_2         = 57,   //--2013
        VSR_VOLKSWAGEN_SANGTANA_1       = 58,   //-ɣ-2007,2002,2000,1999,1995
        VSR_VOLKSWAGEN_SANGTANA_2       = 59,   //-ɣ-2014,2013
        VSR_VOLKSWAGEN_SANGTANA_3       = 60,   //-ɣ2000-2003,2001,2000,1999,1998,1996
        VSR_VOLKSWAGEN_SANGTANA_4       = 61,   //-ɣ3000-2007,2006,2005,2004,2003
        VSR_VOLKSWAGEN_SANGTANAZHIJUN_1 = 62,   //-ɣ־(vista)-2011,2010,2009,2008
        VSR_VOLKSWAGEN_SANGTANAZHIJUN_2 = 63,   //-ɣ־(vista)-2006
        VSR_VOLKSWAGEN_JIAKECHONG_1     = 64,   //-׿ǳ-2010,2009,2008,2007,2006,2005
        VSR_VOLKSWAGEN_JIAKECHONG_2     = 65,   //-׿ǳ-2014,2013
        VSR_VOLKSWAGEN_HUITENG_2        = 66,   //--2010,2009,2007,2006
        VSR_VOLKSWAGEN_MAITENG_1        = 67,   //--2011,2010,2009,2008,2007
        VSR_VOLKSWAGEN_MAITENG_2        = 68,   //--2013,2012
        VSR_VOLKSWAGEN_TUAN_3           = 69,   //-;-2006,2005,2004
        VSR_VOLKSWAGEN_TUAN_1           = 70,   //-;-2010,2009,2008
        VSR_VOLKSWAGEN_TUAN_2           = 71,   //-;-2013,2012,2011
        VSR_VOLKSWAGEN_TUGUAN_1         = 72,   //-;-2012,2011,2010
        VSR_VOLKSWAGEN_TURUI_1          = 73,   //-;-2006,2005,2003
        VSR_VOLKSWAGEN_TURUI_2          = 74,   //-;-2014,2013,2012,2011
        VSR_VOLKSWAGEN_SUTENG_1         = 75,   //--2010,2009,2007,2006
        VSR_VOLKSWAGEN_SUTENG_2         = 76,   //--2011
        VSR_VOLKSWAGEN_SUTENG_3         = 77,   //--2014,2013,2012
        VSR_VOLKSWAGEN_GAOERFU_1        = 78,   //-߶-2008,2007,2006,2005,2004,2003
        VSR_VOLKSWAGEN_GAOERFU_2        = 79,   //-߶-2012,2011,2012,2011,2010
        VSR_VOLKSWAGEN_GAOERFU_3        = 80,   //-߶GTI-2013,2012,2011,2010
        VSR_VOLKSWAGEN_LANGYI_3         = 81,   //--2014
        VSR_VOLKSWAGEN_HUITENG_1        = 82   //--2004
} VSB_VOLKSWAGEN_CLASS;

//Ʒ
typedef enum _VBR_BUICK_CLASS
{
    VBR_BUICK_OTHER        = 0,   // 
        VBR_BUICK_ENCORE       = 1,   // 
        VBR_BUICK_GL8          = 2,   // GL8
        VBR_BUICK_LEGAL        = 3,   // 
        VBR_BUICK_LACROSS      = 4,   // Խ
        VBR_BUICK_EXCELLE      = 5,   // Խ
        VBR_BUICK_EXCELLEGT    = 6,   // ӢGT
        VBR_BUICK_WXCELLEXT    = 7,   // ӢXT
        VBR_BUICK_ENCLAVE      = 8,   // 
        VBR_BUICK_ROYAUM       = 9,   // 
        VBR_BUICK_SAIL         = 10,  // ŷ
        VBR_BUICK_EXCELLEHRV   = 11,  // ԽHRV
        VBR_BUICK_PARKAVENUE   = 12,  // 
        VBR_BUICK_CENTURY      = 13,   // 
        VBR_BUICK_GL8_1          = 14,   // -GL8-2004,2003
        VBR_BUICK_GL8_2          = 15,   // -GL8-2007,2006,2005
        VBR_BUICK_GL8_3          = 16,   // -GL8-2010_2008_2006_2005½
        VBR_BUICK_GL8_4          = 17,   // -GL8-2014,2013,2012,2011
        VBR_BUICK_GL8_5          = 18,   // -GL8-2014_2013_2011
        VBR_BUICK_ENCORE_1       = 19,   // --2014,2013
        VBR_BUICK_ENCLAVE_1      = 20,   // --2013,2010,2009
        VBR_BUICK_LEGAL_1        = 21,   // --2001,2000,1999
        VBR_BUICK_LEGAL_2        = 22,   // --2008,2006,2005,2004,2002
        VBR_BUICK_LEGAL_3        = 23,   // --2013,2012,2011,2010,2009
        VBR_BUICK_LEGAL_4        = 24,   // --2013_2012_2011˶
        VBR_BUICK_LEGAL_5        = 25,   // --2014
        VBR_BUICK_LEGAL_6        = 26,   // --2014˶
        VBR_BUICK_LACROSS_1      = 27,   // -Խ-2008,2007,2006
        VBR_BUICK_LACROSS_2      = 28,   // -Խ-2012,2011,2010,2009
        VBR_BUICK_LACROSS_3      = 29,   // -Խ-2013
        VBR_BUICK_EXCELLE_1      = 30,   // -Խ-2006,2005,2004
        VBR_BUICK_EXCELLE_2      = 31,   // -Խ-2008_2006_2005_2004HRV
        VBR_BUICK_EXCELLE_3      = 32,   // -Խ-2011,2009,2008
        VBR_BUICK_EXCELLE_4      = 33,   // -Խ-2013
        VBR_BUICK_PARKAVENUE_1   = 34,   // --2011,2010,2009,2008,2007
        VBR_BUICK_SAIL_1         = 35,   // -ŷ-2004,2003
        VBR_BUICK_EXCELLEGT_1    = 36,   // -ӢGT-2013,2012,2011,2010
        VBR_BUICK_WXCELLEXT_1    = 37,   // -ӢXT-2014,2013,2012,2010
        VBR_BUICK_CENTURY_1      = 38,   // --2000
        VBR_BUICK_RONGYU_1       = 39   // --2005,2004
}VBR_BUICK_CLASS;

//Ʒ
typedef enum _VSB_BMW_CLASS
{
    VSB_BMW_OTHER       = 0,   // 
        VSB_BMW_3SERIES     = 1,   // 3ϵ
        VSB_BMW_5SERIES     = 2,   // 5ϵ
        VSB_BMW_X1          = 3,   // X1
        VSB_BMW_1SERIES     = 4,   // 1ϵ
        VSB_BMW_7SERIES     = 5,   // 7ϵ
        VSB_BMW_X3          = 6,   // X3
        VSB_BMW_X5          = 7,   // X5
        VSB_BMW_X6          = 8,   // X6
        VSB_BMW_Z4          = 9,   // Z4
        VSB_BMW_MINI        = 10,  // 
        VSB_BMW_6SERIES     = 11,   //6ϵ
        VSB_BMW_YIXI_1      = 12,     // -1ϵ-2011,2010,2008,2007
        VSB_BMW_YIXI_2      = 13,     // -1ϵ-2013,2012
        VSB_BMW_SANXI_1     = 14,     // -3ϵ-2004
        VSB_BMW_SANXI_2     = 15,     // -3ϵ-2007,2005
        VSB_BMW_SANXI_3     = 16,     // -3ϵ-2012,2011,2010,2009
        VSB_BMW_SANXI_4     = 17,     // -3ϵ-2014,2013
        VSB_BMW_WUXI_1      = 18,     // -5ϵ-2010,2009,2008
        VSB_BMW_WUXI_2      = 19,     // -5ϵ-2013,2012,2011
        VSB_BMW_LIUXI_1     = 20,     // -6ϵ-δ֪
        VSB_BMW_QIXI_1      = 21,     // -7ϵ-2011,2010,2009
        VSB_BMW_QIXI_2      = 22,     // -7ϵ-2013
        VSB_BMW_X1_1        = 23,     // -X1-2012,2010
        VSB_BMW_X1_2        = 24,     // -X1-2014,2013
        VSB_BMW_X3_1        = 25,     // -X3-2009,2008,2006
        VSB_BMW_X3_2        = 26,     // -X3-2013,2012,2011
        VSB_BMW_X5_1        = 27,     // -X5-2010,2009,2008
        VSB_BMW_X5_2        = 28,     // -X5-2013,2012,2011
        VSB_BMW_X5_3        = 29,     // -X5-2013˶
        VSB_BMW_X6_1        = 30,     // -X6-2013,2012,2011,2009,2008
        VSB_BMW_Z4_1        = 31     // -Z4-2004
}VSB_BMW_CLASS;

//Ʒ
typedef enum _VSB_HONDA_CLASS
{
    VSB_HONDA_OTHER       = 0,   // 
        VSB_HONDA_CRV         = 1,   // CR-V(˼)
        VSB_HONDA_JADE        = 2,   // ܵ
        VSB_HONDA_CIVIC       = 3,   // ˼
        VSB_HONDA_SPIRIOR     = 4,   // ˼
        VSB_HONDA_CIIMO       = 5,   // ˼
        VSB_HONDA_ELYSION     = 6,   // 
        VSB_HONDA_OBYSSEY     = 7,   // 
        VSB_HONDA_FIT         = 8,   // ɶ
        VSB_HONDA_NEWCITY     = 9,   // 淶
        VSB_HONDA_CROSSTOUR   = 10,  // ʫͼ
        VSB_HONDA_CRIDER      = 11,  // 
        VSB_HONDA_ACCORD      = 12,  // Ÿ
        VSB_HONDA_CITY        = 13,  // ˼
        VSB_HONDA_ANTILOCK    = 14,  // µ
        VSB_HONDA_CRZ         = 15,   // CR-Z
        VSB_HONDA_CRV_1       = 16,   // -CR-V-2004
        VSB_HONDA_CRV_2       = 17,   // -CR-V-2005
        VSB_HONDA_CRV_3       = 18,   // -CR-V-2008,2007
        VSB_HONDA_CRV_4       = 19,   // -CR-V-2010
        VSB_HONDA_CRV_5       = 20,   // -CR-V-2013,2012
        VSB_HONDA_CRIDER_1    = 21,   // --2014,2013
        VSB_HONDA_OBYSSEY_1   = 22,   // -µ-2002
        VSB_HONDA_OBYSSEY_2   = 23,   // -µ-2006,2005,2004
        VSB_HONDA_OBYSSEY_3   = 24,   // -µ-2008,2007
        VSB_HONDA_OBYSSEY_4   = 25,   // -µ-2011
        VSB_HONDA_CIVIC_1     = 26,   // -˼-2007
        VSB_HONDA_CIVIC_5     = 27,   // -˼-1996
        VSB_HONDA_CIVIC_2     = 28,   // -˼-2008,2006
        VSB_HONDA_CIVIC_3     = 29,   // -˼-2009
        VSB_HONDA_CIVIC_4     = 30,   // -˼-2013,2012,2011
        VSB_HONDA_CITY_1      = 31,   // -˼-2008,2007,2006
        VSB_HONDA_SPIRIOR_1   = 32,   // -˼-2009
        VSB_HONDA_SIMING_1    = 33,   // -˼-2012
        VSB_HONDA_JIEDE_1     = 34,   // -ܵ-2013
        VSB_HONDA_CROSSTOUR_1 = 35,   // -ʫͼ-2013,2012,2010
        VSB_HONDA_AILISHEN_1  = 36,   // --2012
        VSB_HONDA_NEWCITY_1   = 37,   // -淶-2009
        VSB_HONDA_NEWCITY_2   = 38,   // -淶-2011
        VSB_HONDA_NEWCITY_3   = 39,   // -淶-2014,2012
        VSB_HONDA_ACCORD_1    = 40,   // -Ÿ-1996
        VSB_HONDA_ACCORD_2    = 41,   // -Ÿ-1999
        VSB_HONDA_ACCORD_3    = 42,   // -Ÿ-2001
        VSB_HONDA_ACCORD_4    = 43,   // -Ÿ-2003
        VSB_HONDA_ACCORD_5    = 44,   // -Ÿ-2008
        VSB_HONDA_ACCORD_6    = 45,   // -Ÿ-2010
        VSB_HONDA_ACCORD_7    = 46,   // -Ÿ-2011
        VSB_HONDA_ACCORD_8    = 47,   // -Ÿ-2012
        VSB_HONDA_ACCORD_9    = 48,   // -Ÿ-2013
        VSB_HONDA_ACCORD_10   = 49,   // -Ÿ-2014
        VSB_HONDA_FIT_1       = 50,   // -ɶ-2004
        VSB_HONDA_FIT_2       = 51,   // -ɶ-2004
        VSB_HONDA_FIT_3       = 52,   // -ɶ-2005
        VSB_HONDA_FIT_4       = 53,   // -ɶ-2007
        VSB_HONDA_FIT_5       = 54,   // -ɶ-2008
        VSB_HONDA_FIT_6       = 55   // -ɶ-2013,2011
}VSB_HONDA_CLASS;

//Ʒ
typedef enum _VSB_PEUGEOT_CLASS
{
    VSB_PEUGEOT_OTHER      = 0,   // 
        VSB_PEUGEOT_2008       = 1,   // 2008
        VSB_PEUGEOT_207        = 2,   // 207
        VSB_PEUGEOT_SENNA      = 3,   // 
        VSB_PEUGEOT_3008       = 4,   // 3008
        VSB_PEUGEOT_301        = 5,   // 301
        VSB_PEUGEOT_307        = 6,   // 307
        VSB_PEUGEOT_308        = 7,   // 308
        VSB_PEUGEOT_408        = 8,   // 408
        VSB_PEUGEOT_508        = 9,   // 508
        VSB_PEUGEOT_206        = 10,  // 206
        VSB_PEUGEOT_407        = 11,   // 407
        VSB_PEUGEOT_206_1      = 12, // -206-δ֪
        VSB_PEUGEOT_207_1      = 13, // -207-2011,2010,2009
        VSB_PEUGEOT_207_2      = 14, // -207-2013
        VSB_PEUGEOT_3008_1     = 15, // -3008-2014,2013
        VSB_PEUGEOT_301_1      = 16, // -301-δ֪
        VSB_PEUGEOT_307_1      = 17, // -307-2007,2006,2005,2004
        VSB_PEUGEOT_307_2      = 18, // -307-2010,2009,2008
        VSB_PEUGEOT_307_3      = 19, // -307-2013_2012_2011CROSS
        VSB_PEUGEOT_308_1      = 20, // -308-2014,2013,2012
        VSB_PEUGEOT_407_1      = 21, // -407-δ֪
        VSB_PEUGEOT_408_1      = 22, // -408-2012,2011,2010
        VSB_PEUGEOT_408_2      = 23, // -408-2013
        VSB_PEUGEOT_508_1      = 24, // -508-2014,2013,2012,2011
        VSB_PEUGEOT_207_3      = 25, // -207-2011,2010,2009
        VSB_PEUGEOT_307_4      = 26 // -307-2013,2012,2010,2009,2008
        
}VSB_PEUGEOT_CLASS;

//Ʒ
typedef enum _VSB_TOYOTA_CLASS
{
    VSB_TOYOTA_OTHER            = 0,   // 
        VSB_TOYOTA_HIGHLANDER       = 1,   // 
        VSB_TOYOTA_CAMRY            = 2,   // 
        VSB_TOYOTA_YARIS            = 3,   // ʿ
        VSB_TOYOTA_YARISL           = 4,   // YARIS L
        VSB_TOYOTA_VERSO            = 5,   // 
        VSB_TOYOTA_HUAGUAN          = 6,   // 
        VSB_TOYOTA_CROWN            = 7,   // ʹ
        VSB_TOYOTA_COROLLA          = 8,   // 
        VSB_TOYOTA_COSTER           = 9,   // ˹
        VSB_TOYOTA_PRADO            = 10,  // 
        VSB_TOYOTA_PRIUS            = 11,  // ˹
        VSB_TOYOTA_RAV4             = 12,  // RAV4
        VSB_TOYOTA_REZI             = 13,  // ־
        VSB_TOYOTA_VIOS             = 14,  // 
        VSB_TOYOTA_PREVIA           = 15,  // ά
        VSB_TOYOTA_HIACE            = 16,  // ʨ
        VSB_TOYOTA_86               = 17,  // 86
        VSB_TOYOTA_SPEQUOIA         = 18,  // ɼ
        VSB_TOYOTA_LANDCRUISER      = 19,  // ½Ѳ(¿·)
        VSB_TOYOTA_SIENNA           = 20,  // 
        VSB_TOYOTA_CAMRYHYBRID      = 21,  // -HYBRID
        VSB_TOYOTA_GRACE            = 22,  // ˹
        VSB_TOYOTA_ALPHARD          = 23,   // 
        VSB_TOYOTA_RAV4_1           = 24,   // -RAV4-2012ֶ,2011,2010,2009
        VSB_TOYOTA_RAV4_2           = 25,   // -RAV4-2013
        VSB_TOYOTA_86_1             = 26,   // -86-δ֪
        VSB_TOYOTA_JIAMEI_2         = 27,   // --2001,2000,1999,1998
        VSB_TOYOTA_JIAMEI_3         = 28,   // --2004,2003,2002
        VSB_TOYOTA_LANDEKLZ_1       = 29,   // -¿·-2011ж,2010,2007
        VSB_TOYOTA_KAIMEIRUI_1      = 30,   // --2008,2007,2006
        VSB_TOYOTA_KAIMEIRUI_2      = 31,   // --2012
        VSB_TOYOTA_KAIMEIRUI_3      = 32,   // --2012,2011,2010,2009
        VSB_TOYOTA_KAIMEIRUI_4      = 33,   // --2013,2012
        VSB_TOYOTA_KAIMEIRUI_5      = 34,   // --2013
        VSB_TOYOTA_KAIMEIRUI_6      = 35,   // --2014,2012
        VSB_TOYOTA_KALUOLA_1        = 36,   // --2010,2009,2008,2007,2006
        VSB_TOYOTA_KALUOLA_2        = 37,   // --2013,2012,2011
        VSB_TOYOTA_AIERFA_1         = 38,   // --2011,2010
        VSB_TOYOTA_AIERFA_2         = 39,   // --2013,2012
        VSB_TOYOTA_WEICHI_1         = 40,   // --2004,2003
        VSB_TOYOTA_WEICHI_2         = 41,   // --2007,2006,2005
        VSB_TOYOTA_WEICHI_3         = 42,   // --2009,2008
        VSB_TOYOTA_WEICHI_4         = 43,   // --2013,2012,2011,2010
        VSB_TOYOTA_WEICHI_5         = 44,   // --2014
        VSB_TOYOTA_PULADUO_1        = 45,   // --2007,2006,2005,2004
        VSB_TOYOTA_PULADUO_2        = 46,   // --2010
        VSB_TOYOTA_PULADUO_3        = 47,   // --2014
        VSB_TOYOTA_PURUIWEIYA_1     = 48,   // -ά-2004
        VSB_TOYOTA_PURUIWEIYA_4     = 49,   // -ά-2005
        VSB_TOYOTA_PURUIWEIYA_2     = 50,   // -ά-2006
        VSB_TOYOTA_PURUIWEIYA_3     = 51,   // -ά-2012,2010,2008,2007
        VSB_TOYOTA_KESIDA_1         = 52,   // -˹-2007
        VSB_TOYOTA_KESIDA_2         = 53,   // -˹-2011
        VSB_TOYOTA_HANLANDA_1       = 54,   // --2011,2009
        VSB_TOYOTA_HANLANDA_2       = 55,   // --2012
        VSB_TOYOTA_HANLANDA_3       = 56,   // --2013
        VSB_TOYOTA_HAISHI_1         = 57,   // -ʨ-2001
        VSB_TOYOTA_HUANGGUAN_1      = 58,   // -ʹ-1999
        VSB_TOYOTA_HUANGGUAN_2      = 59,   // -ʹ-2009,2008,2007,2006,2005
        VSB_TOYOTA_HUANGGUAN_3      = 60,   // -ʹ-2010
        VSB_TOYOTA_HUANGGUAN_4      = 61,   // -ʹ-2012,2011
        VSB_TOYOTA_HONGSHAN_1       = 62,   // -ɼ-δ֪
        VSB_TOYOTA_HUAGUAN_1        = 63,   // --2006,2005,2004
        VSB_TOYOTA_HUAGUAN_2        = 64,   // --2009,2008,2007
        VSB_TOYOTA_HUAGUAN_3        = 65,   // --2011,2010
        VSB_TOYOTA_YIZHI_1          = 66,   // --2014,2012,2011
        VSB_TOYOTA_RUIZHI_1         = 67,   // -־-2006,2005
        VSB_TOYOTA_RUIZHI_2         = 68,   // -־-2009,2008,2007
        VSB_TOYOTA_RUIZHI_3         = 69,   // -־-2010Ȱ
        VSB_TOYOTA_RUIZHI_4         = 70,   // -־-2012,2010
        VSB_TOYOTA_LUDIXUNYANG_1    = 71,   // -½Ѳ-δ֪
        VSB_TOYOTA_YALISHI_1        = 72,   // -ʿ-2009,2008,2007
        VSB_TOYOTA_YALISHI_2        = 73,   // -ʿ-2012,2011,2010
        VSB_TOYOTA_RAV4_3           = 74,   // -RAV4-2013,Ӣ,,2012
        VSB_TOYOTA_YARiSL_1         = 75,   // -YARiS-L
        VSB_TOYOTA_JIAMEI_1         = 76,   // --1996
        VSB_TOYOTA_PLATZ_1          = 77,   // -PLATZ-1999
        VSB_TOYOTA_LANDEKLZ_2       = 78   // -¿·-2014,2012ж,2012
}VSB_TOYOTA_CLASS;

//Ʒ
typedef enum _VSB_FORD_CLASS
{
    VSB_FORD_OTHER       = 0,   // 
        VSB_FORD_FOCUS       = 1,   // ˹
        VSB_FORD_FIESTA      = 2,   // 껪
        VSB_FORD_SMAX        = 3,   // ˹
        VSB_FORD_MONDEO      = 4,   // ɵŷ
        VSB_FORD_ECOSPORT    = 5,   // 
        VSB_FORD_ESCAPE      = 6,   // 
        VSB_FORD_ZHISHENG    = 7,   // ʤ
        VSB_FORD_ESCORT      = 8,   // ˹
        VSB_FORD_EXPLORER    = 9,   // ̽
        VSB_FORD_EDGE        = 10,  // 
        VSB_FORD_TRANSIT     = 11,   // ȫ˳
        VSB_FORD_QUANSHUN_1      = 12,    // -ȫ˳-δ֪
        VSB_FORD_JIANIANHUA_1    = 13,    // -껪-2006,2005,2004
        VSB_FORD_JIANIANHUA_2    = 14,    // -껪-2011,2010,2009
        VSB_FORD_JIANIANHUA_3    = 15,    // -껪-2013
        VSB_FORD_JIANIANHUA_4    = 16,    // -껪-2012
        VSB_FORD_TANXIANZHE_1    = 17,    // -̽-2013,2011
        VSB_FORD_FOCUS_1         = 18,    // -˹-2005
        VSB_FORD_FOCUS_2         = 19,    // -˹-2005
        VSB_FORD_FOCUS_3         = 20,    // -˹-2008,2007,2006
        VSB_FORD_FOCUS_4         = 21,    // -˹-2013,2012,2011,2009
        VSB_FORD_FOCUS_5         = 22,    // -˹-2012
        VSB_FORD_FOCUS_6         = 23,    // -˹-2012,ʱ,2011,2010,2009,2008
        VSB_FORD_YIBO_1          = 24,    // --2013
        VSB_FORD_YIHU_1          = 25,    // --2013
        VSB_FORD_MENGDIOU_1      = 26,    // -ɵŷ-2003
        VSB_FORD_MENGDIOU_2      = 27,    // -ɵŷ-2005,2004
        VSB_FORD_MENGDIOU_3      = 28,    // -ɵŷ-2006
        VSB_FORD_MENGDIOU_4      = 29,    // -ɵŷ-2013
        VSB_FORD_MENGDIOU_5      = 30,    // -ɵŷ-ʤ-2010,2008,2007
        VSB_FORD_MENGDIOU_6      = 31,    // -ɵŷ-ʤ-2011
        VSB_FORD_RUIJIE_1        = 32,    // --2012,2011
        VSB_FORD_MAIKESI_1       = 33    // -˹-2008,2007
}VSB_FORD_CLASS;

//ղƷ
typedef enum _VSB_NISSAN_CLASS
{
    VSB_NISSAN_OTHER              = 0,   // 
        VSB_NISSAN_XTRAIL             = 1,   // 濥
        VSB_NISSAN_MURANO             = 2,   // ¥
        VSB_NISSAN_LIVINA             = 3,   // 
        VSB_NISSAN_MARCH              = 4,   // 
        VSB_NISSAN_TIIDA              = 5,   // 
        VSB_NISSAN_TEANA              = 6,   // 
        VSB_NISSAN_QASHQAI            = 7,   // п
        VSB_NISSAN_SYLPHY             = 8,   // 
        VSB_NISSAN_SUNNY              = 9,   // 
        VSB_NISSAN_D22PICKUP          = 10,  // D22Ƥ
        VSB_NISSAN_D22VAN             = 11,  // D22ʽ
        VSB_NISSAN_CABSTAR            = 12,  // ˹
        VSB_NISSAN_HV200              = 13,  // NV200
        VSB_NISSAN_PALADIN            = 14,  // 
        VSB_NISSAN_YIDA               = 15,  // ô
        VSB_NISSAN_DUCK               = 16,  // 
        VSB_NISSAN_CEFIRO             = 17,  // 
        VSB_NISSAN_FENGSHENBLUEBIRD   = 18,  // 
        VSB_NISSAN_FENGSHENSUNNY      = 19,  // 
        VSB_NISSAN_SUCCE              = 20,  // ˧
        VSB_NISSAN_FUGA               = 21,  // 
        VSB_NISSAN_BLUEBIRD4          = 22,  // 4
        VSB_NISSAN_VENUCIA            = 23,  // 
        VSB_NISSAN_QUEST              = 24,  // ʿ
        VSB_NISSAN_GENISS             = 25,   // 
        VSB_NISSAN_NV200_1            = 26,  // ղ-NV200-2013,2012,2011,2010
        VSB_NISSAN_TIANLAI_1          = 27,  // ղ--2005,2004
        VSB_NISSAN_TIANLAI_2          = 28,  // ղ--2007,2006
        VSB_NISSAN_TIANLAI_3          = 29,  // ղ--2010,2008
        VSB_NISSAN_TIANLAI_4          = 30,  // ղ--2012,2011
        VSB_NISSAN_TIANLAI_5          = 31,  // ղ--2012ưȫ,2011
        VSB_NISSAN_TIANLAI_6          = 32,  // ղ--2014,2013
        VSB_NISSAN_QIJUN_1            = 33,  // ղ-濥-2010,2008
        VSB_NISSAN_QIJUN_2            = 34,  // ղ-濥-2012,2011
        VSB_NISSAN_PALADING_1         = 35,  // ղ--2013,2011,2006,2004
        VSB_NISSAN_LOULAN_1           = 36,  // ղ-¥-2013,2011
        VSB_NISSAN_LOULAN_2           = 37,  // ղ--2010
        VSB_NISSAN_LANNIAO_1          = 38,  // ղ--2002
        VSB_NISSAN_LANNIAO_2          = 39,  // ղ--2003
        VSB_NISSAN_LANNIAO_3          = 40,  // ղ--2004
        VSB_NISSAN_GUISHI_1           = 41,  // ղ-ʿ-2005
        VSB_NISSAN_XUANYI_1           = 42,  // ղ--2006
        VSB_NISSAN_XUANYI_2           = 43,  // ղ--2012,2009,2007
        VSB_NISSAN_XUANYI_3           = 44,  // ղ--2014,2012
        VSB_NISSAN_XIAOKE_1           = 45,  // ղ-п-2009,2008
        VSB_NISSAN_XIAOKE_2           = 46,  // ղ-п-2013,2012,2011
        VSB_NISSAN_SUNNY_3            = 47,  // ղ--2004
        VSB_NISSAN_SUNNY_1            = 48,  // ղ--2006,2005
        VSB_NISSAN_SUNNY_2            = 49,  // ղ--2012,2011
        VSB_NISSAN_YIDA_1             = 50,  // ղ-ô-2008,2006,2005
        VSB_NISSAN_YIDA_2             = 51,  // ղ-ô-δ֪
        VSB_NISSAN_FENGDU_1           = 52,  // ղ--δ֪
        VSB_NISSAN_FENGYA_1           = 53,  // ղ--δ֪
        VSB_NISSAN_LIWEI_1            = 54,  // ղ--2008,2007
        VSB_NISSAN_LIWEI_2            = 55,  // ղ--2009
        VSB_NISSAN_LIWEI_3            = 56,  // ղ--2010
        VSB_NISSAN_LIWEI_4            = 57,  // ղ--2011,2010,2008
        VSB_NISSAN_JUNYI_1            = 58,  // ղ--2006
        VSB_NISSAN_QIDA_1             = 59,  // ղ--2006,2005
        VSB_NISSAN_QIDA_2             = 60,  // ղ--2009,2008
        VSB_NISSAN_QIDA_3             = 61,  // ղ--2013,2012,2011
        VSB_NISSAN_RUIQI_1            = 62   // ղ-Ƥ-2009
}VSB_NISSAN_CLASS;

//µƷ
typedef enum _VSB_AUDI_CLASS
{
    VSB_AUDI_OTHER        = 0,   // 
        VSB_AUDI_A3           = 1,   // µA3
        VSB_AUDI_A4L          = 2,   // µA4L
        VSB_AUDI_A6L          = 3,   // µA6L
        VSB_AUDI_Q3           = 4,   // µQ3
        VSB_AUDI_Q5           = 5,   // µQ5
        VSB_AUDI_A1           = 6,   // µA1
        VSB_AUDI_A4           = 7,   // µA4
        VSB_AUDI_A5           = 8,   // µA5
        VSB_AUDI_A6           = 9,   // µA6
        VSB_AUDI_A7           = 10,  // µA7
        VSB_AUDI_A8L          = 11,  // µA8L
        VSB_AUDI_Q7           = 12,  // µQ7
        VSB_AUDI_S5           = 13,  // µS5
        VSB_AUDI_TT           = 14,  // µTT
        VSB_AUDI_100          = 15,  // µ100
        VSB_AUDI_200          = 16,  // µ200
        VSB_AUDI_S7           = 17,  // µS7
        VSB_AUDI_S8           = 18,  // µS8
        VSB_AUDI_100_1        = 19,   // µ-100-δ֪
        VSB_AUDI_200_1        = 20,   // µ-200-δ֪
        VSB_AUDI_A1_1         = 21,   // µ-A1-2014,2013,2012
        VSB_AUDI_A3_1         = 22,   // µ-A3-2013,2010ʰ
        VSB_AUDI_A3_2         = 23,   // µ-A3-2013,2011,2010
        VSB_AUDI_A4_1         = 24,   // µ-A4-2005,2000ڰ
        VSB_AUDI_A4_2         = 25,   // µ-A4-2007,2006,2004
        VSB_AUDI_A4L_1        = 26,   // µ-A4L-2013
        VSB_AUDI_A5_1         = 27,   // µ-A5-2011,2010
        VSB_AUDI_A6_1         = 28,   // µ-A6-1996,1995,1991
        VSB_AUDI_A6L_1        = 29,   // µ-A6L-2008,2007,2006,2005
        VSB_AUDI_A6L_2        = 30,   // µ-A6L-2011,2010,2009
        VSB_AUDI_A6L_3        = 31,   // µ-A6L-2014,2013,2012
        VSB_AUDI_A7_1         = 32,   // µ-A7-2014,2013ȡ,2012,2011
        VSB_AUDI_A8L_1        = 33,   // µ-A8L-2006
        VSB_AUDI_A8L_2        = 34,   // µ-A8L-2009,2008
        VSB_AUDI_A8L_3        = 35,   // µ-A8L-2011
        VSB_AUDI_A8L_4        = 36,   // µ-A8L-2013,2012
        VSB_AUDI_Q3_1         = 37,   // µ-Q3-2014,2013,2012
        VSB_AUDI_Q5_1         = 38,   // µ-Q5-2012,2010˶ 
        VSB_AUDI_Q5_2         = 39,   // µ-Q5-2012,2010ԽҰ
        VSB_AUDI_Q5_3         = 40,   // µ-Q5-2012ȡ,2011,2010,2009
        VSB_AUDI_Q5_4         = 41,   // µ-Q5-2013
        VSB_AUDI_Q7_1         = 42,   // µ-Q7-2007
        VSB_AUDI_Q7_2         = 43,   // µ-Q7-2014,2013
        VSB_AUDI_S7_1         = 44,   // µ-S7-2013
        VSB_AUDI_S8_1         = 45,   // µ-S8-2013
        VSB_AUDI_TT_2         = 46,   // µ-TT-2010,2008,2007
        VSB_AUDI_TT_3         = 47,   // µ-TT-2012,2011
        VSB_AUDI_TT_4         = 48,   // µ-TT-2013,2013,2011TTS
        VSB_AUDI_TT_1         = 49   // µ-TT-2008TTS
}VSB_AUDI_CLASS;

//ԴƷ
typedef enum _VSB_MAZDA_CLASS
{
    VSB_MAZDA_OTHER         = 0,   // 
        VSB_MAZDA_CX5           = 1,   // ԴCX5
        VSB_MAZDA_2             = 2,   // Դ2
        VSB_MAZDA_3             = 3,   // Դ3
        VSB_MAZDA_6             = 4,   // Դ6
        VSB_MAZDA_8             = 5,   // Դ8
        VSB_MAZDA_COREWING      = 6,   // 
        VSB_MAZDA_CX7           = 7,   // ԴCX7
        VSB_MAZDA_X5            = 8,   // ԴX5
        VSB_MAZDA_5             = 9,   // Դ5
        VSB_MAZDA_PREMACY       = 10,  // Ͽ
        VSB_MAZDA_MPV           = 11,   // ԴMPV
        VSB_MAZDA_CX5_1         = 12,   // Դ-CX-5-2014,2013,2012
        VSB_MAZDA_CX7_1         = 13,   // Դ-CX-7-2014,2013,2011,2010
        VSB_MAZDA_2_1           = 14,   // Դ-Mazda2-2011,2009,2008,2007A
        VSB_MAZDA_3_1           = 15,   // Դ-Mazda3-2004,2002
        VSB_MAZDA_3_2           = 16,   // Դ-Mazda3-2009,2007
        VSB_MAZDA_3_3           = 17,   // Դ-Mazda3-2012,2010
        VSB_MAZDA_3_4           = 18,   // Դ-Mazda3ǳ-2013,2012
        VSB_MAZDA_5_1           = 19,   // Դ-Mazda5-2010,2008,2007
        VSB_MAZDA_5_2           = 20,   // Դ-Mazda5-2013,2012,2011
        VSB_MAZDA_6_2           = 21,   // Դ-Mazda6-2006
        VSB_MAZDA_6_3           = 22,   // Դ-Mazda6-2007
        VSB_MAZDA_8_1           = 23,   // Դ-Mazda8-2013,2011,2010
        VSB_MAZDA_PREMACY_1     = 24,   // Դ--2003
        VSB_MAZDA_PREMACY_2     = 25,   // Դ--2006,2005,2004
        VSB_MAZDA_COREWING_1    = 26,   // Դ--2012,2011,2010,2009
        VSB_MAZDA_COREWING_2    = 27,   // Դ--2011,2010
        VSB_MAZDA_COREWING_3    = 28,   // Դ--2012
        VSB_MAZDA_2_2           = 29,   // Դ-Mazda2()-2011,2010,2008
        VSB_MAZDA_6_1           = 30,   // Դ-Mazda6-2004
        VSB_MAZDA_6_4           = 31   // Դ-Mazda6-2014,2013,2012,2011,2010
}VSB_MAZDA_CLASS;

//ѩƷ
typedef enum _VSB_CHEVROLET_CLASS
{
    VSB_CHEVROLET_OTHER          = 0,   // 
        VSB_CHEVROLET_NEWAVEO        = 1,   // Ψŷ
        VSB_CHEVROLET_EPICA          = 2,   // 
        VSB_CHEVROLET_CRUZE          = 3,   // ³
        VSB_CHEVROLET_CAPTIVA        = 4,   // 
        VSB_CHEVROLET_MALIBU         = 5,   // 
        VSB_CHEVROLET_SAIL           = 6,   // ŷ
        VSB_CHEVROLET_CAMARO         = 7,   // 
        VSB_CHEVROLET_LECHENG        = 8,   // ֳ
        VSB_CHEVROLET_LOVA           = 9,   // ַ
        VSB_CHEVROLET_OLDAVEO        = 10,  // ֳ-ϿΨŷ
        VSB_CHEVROLET_SPARK          = 11,  // ֳ
        VSB_CHEVROLET_SAILSRV        = 12,   // ŷSRV
        VSB_CHEVROLET_LOVA_1         = 13,   // ѩ-ַ-2009,2008,2007,2006
        VSB_CHEVROLET_LOVA_2         = 14,   // ѩ-ַ-2010
        VSB_CHEVROLET_SPARK_1        = 15,   // ѩ-ֳ-2010,2009,2006,2005,2004
        VSB_CHEVROLET_SPARK_2        = 16,   // ѩ-ֳ-2010˶
        VSB_CHEVROLET_OLDAVEO_1      = 17,   // ѩ-ֳ-2005
        VSB_CHEVROLET_OLDAVEO_2      = 18,   // ѩ-ֳ-2010,2009,2008
        VSB_CHEVROLET_EPICA_1        = 19,   // ѩ--2005
        VSB_CHEVROLET_EPICA_3        = 20,   // ѩ--2012,2011,2010
        VSB_CHEVROLET_EPICA_4        = 21,   // ѩ--2012,2011,2010
        VSB_CHEVROLET_EPICA_5        = 22,   // ѩ--2013
        VSB_CHEVROLET_NEWAVEO_1      = 23,   // ѩ-Ψŷ-2013,2012,2011
        VSB_CHEVROLET_CAPTIVA_1      = 24,   // ѩ--2010,2008
        VSB_CHEVROLET_CAPTIVA_2      = 25,   // ѩ--2014,2013,2012,2011
        VSB_CHEVROLET_KEMAILUO_1     = 26,   // ѩ--2012,2011
        VSB_CHEVROLET_CRUZE_1        = 27,   // ѩ-³-2014,2013,2012,2011,2010,2009
        VSB_CHEVROLET_SAIL_1         = 28,   // ѩ-ŷ-2005
        VSB_CHEVROLET_SAIL_2         = 29,   // ѩ-ŷ-2013,2011,2010
        VSB_CHEVROLET_MALIBU_1       = 30,   // ѩ--2014,2013,2012
        VSB_CHEVROLET_EPICA_2        = 31   // ѩ--2009,2008,2007
}VSB_CHEVROLET_CLASS;

//ѩƷ
typedef enum _VSB_CITROEN_CLASS
{
    VSB_CITROEN_OTHER                 = 0,   // 
        VSB_CITROEN_C2                    = 1,   // ѩC2
        VSB_CITROEN_C4L                   = 2,   // ѩC4L
        VSB_CITROEN_C5                    = 3,   // ѩC5
        VSB_CITROEN_ELYSEE                = 4,   // 
        VSB_CITROEN_CQUATRELIANGXIANG     = 5,   // 
        VSB_CITROEN_CQUATRESANXIANG       = 6,   // 
        VSB_CITROEN_SAEAPICASSO           = 7,   // -ϼ
        VSB_CITROEN_PICASSO               = 8,   // ϼ
        VSB_CITROEN_CTRIOMPHE             = 9,   // 
        VSB_CITROEN_XSARA                 = 10,  //   
        VSB_CITROEN_SHENLONGFUKANG        = 11,  // 
        VSB_CITROEN_CHANGANDS             = 12,   // DS
        VSB_CITROEN_C2_1                  = 13,   // ѩ-C2-2012,2010,2008,2007,2006
        VSB_CITROEN_C4L_1                 = 14,   // ѩ-C4L-2014,2013
        VSB_CITROEN_C4PICASSO_1           = 15,   // ѩ-C4ϼ-2009ʰ
        VSB_CITROEN_C5_1                  = 16,   // ѩ-C5-2012,2011,2010
        VSB_CITROEN_CQUATRESANXIANG_1     = 17,   // ѩ--2013,2012
        VSB_CITROEN_CQUATRELIANGXIANG_1   = 18,   // ѩ--2011,2010,2009,2008
        VSB_CITROEN_CTRIOMPHE_1           = 19,   // ѩ--2010,2009,2008,2006
        VSB_CITROEN_FUKANG_1              = 20,   // ѩ--2006,2005,2004,2003,2002
        VSB_CITROEN_ELYSEE_1              = 21,   // ѩ--2006,2005,2004,2003,2002
        VSB_CITROEN_ELYSEE_2              = 22,   // ѩ--2013,2012,2011,2010,2009,2008,2007
        VSB_CITROEN_SAEAPICASSO_1         = 23    // ѩ--ϼ-2014 
}VSB_CITROEN_CLASS;

//ִƷ
typedef enum _VSB_HYUNDAI_CLASS
{
    VSB_HYUNDAI_OTHER            = 0,   // 
        VSB_HYUNDAI_IX35             = 1,   // ִIX35
        VSB_HYUNDAI_LANGDONG         = 2,   // ʶ
        VSB_HYUNDAI_MOINCA           = 3,   // Ԧ
        VSB_HYUNDAI_SHENGDA          = 4,   // ʤ
        VSB_HYUNDAI_VERNA            = 5,   // 
        VSB_HYUNDAI_RUIYI            = 6,   // 
        VSB_HYUNDAI_SONATAEIGHT      = 7,   // 
        VSB_HYUNDAI_TUCSON           = 8,   // ;ʤ
        VSB_HYUNDAI_YUEDONG          = 9,   // ö
        VSB_HYUNDAI_ELANTRA          = 10,  // 
        VSB_HYUNDAI_GRANDSANTAFE     = 11,  // 
        VSB_HYUNDAI_COUPE            = 12,  // 
        VSB_HYUNDAI_MATRIX           = 13,  // 
        VSB_HYUNDAI_ACCENT           = 14,  // 
        VSB_HYUNDAI_IX30             = 15,  // ִIX30
        VSB_HYUNDAI_SONATA           = 16,  // 
        VSB_HYUNDAI_REFINE           = 17,  // ִ
        VSB_HYUNDAI_MISTRA           = 18,  // ͼ
        VSB_HYUNDAI_SONATAYUFENG     = 19,  // -
        VSB_HYUNDAI_SANTAFE          = 20,  // ִʥ
        VSB_HYUNDAI_HUIYI            = 21,   // ڻ
        VSB_HYUNDAI_I30_1            = 22,   // ִ-i30-2010,2009
        VSB_HYUNDAI_IX35_1           = 23,   // ִ-ix35-2012,2011,2010
        VSB_HYUNDAI_YILANTE_1        = 24,   // ִ--2006,2005,2004
        VSB_HYUNDAI_YILANTE_2        = 25,   // ִ--2007
        VSB_HYUNDAI_YILANTE_3        = 26,   // ִ--2011
        VSB_HYUNDAI_SHENGDA_1        = 27,   // ִ-ȫʤ-2013,2012
        VSB_HYUNDAI_MINGTU_1         = 28,   // ִ-ͼ-2014,2013
        VSB_HYUNDAI_MINGYU_1         = 29,   // ִ-Ԧ-2013,2011,2009
        VSB_HYUNDAI_SHENGDAFEI_1     = 30,   // ִ-ʥ-δ֪
        VSB_HYUNDAI_YUXIANG_1        = 31,   // ִ--2005ʰ
        VSB_HYUNDAI_YUXIANG_2        = 32,   // ִ--2006,2005
        VSB_HYUNDAI_YUEDONG_1        = 33,   // ִ-ö-2010,2009,2008
        VSB_HYUNDAI_YUEDONG_2        = 34,   // ִ-ö-2012,2011
        VSB_HYUNDAI_SHENGDA_2        = 35,   // ִ-ʤ-2009,2006
        VSB_HYUNDAI_SHENGDA_3        = 36,   // ִ-ʤ-2012,2011,2010
        VSB_HYUNDAI_LANGDONG_1       = 37,   // ִ-ʶ-2013,2012
        VSB_HYUNDAI_GERUI_1          = 38,   // ִ--δ֪
        VSB_HYUNDAI_RUIYI_1          = 39,   // ִ--2014
        VSB_HYUNDAI_RUINA_1          = 40,   // ִ--2013,2010
        VSB_HYUNDAI_RUINA_2          = 41,   // ִ--2014,2013,2011
        VSB_HYUNDAI_RUIFENG_1        = 42,   // ִ--δ֪
        VSB_HYUNDAI_SUONATA_1        = 43,   // ִ--2008,2007,2006,2004,2003׼
        VSB_HYUNDAI_SUONATA_2        = 44,   // ִ--2010,2009,2008,2006,2004
        VSB_HYUNDAI_SOUNATA_3        = 45,   // ִ--2011,2010
        VSB_HYUNDAI_WEILAKESI_1      = 46,   // ִ-ά˹-2012,2010,2008,2007
        VSB_HYUNDAI_MEIJIA_1         = 47,   // ִ--δ֪
        VSB_HYUNDAI_JINKOUHUIYI_1    = 48,   // ִ-ڻ-δ֪
        VSB_HYUNDAI_TUSHENG_1        = 49,   // ִ-;ʤ-2005
        VSB_HYUNDAI_TUSHENG_2        = 50,   // ִ-;ʤ-2011,2009,2008,2006
        VSB_HYUNDAI_TUSHENG_3        = 51,   // ִ-;ʤ-2013
        VSB_HYUNDAI_KUPAI_1          = 52,   // ִ--δ֪
        VSB_HYUNDAI_YASHENTE_1       = 53,   // ִ--2008,2006
        VSB_HYUNDAI_YASHENTE_2       = 54,   // ִ--2011
        VSB_HYUNDAI_LINGXIANG_1      = 55,   // ִ--2009,2008
        VSB_HYUNDAI_FEISI_1          = 56    // ִ-˼-2011
}VSB_HYUNDAI_CLASS;

//Ʒ
typedef enum _VSB_CHERY_CLASS
{
    VSB_CHERY_OTHER        = 0,   // 
        VSB_CHERY_A1           = 1,   // A1
        VSB_CHERY_A3           = 2,   // A3
        VSB_CHERY_EASTAR       = 3,   // ֮
        VSB_CHERY_FULWIN       = 4,   // 
        VSB_CHERY_QQ           = 5,   // QQ
        VSB_CHERY_E5           = 6,   // E5
        VSB_CHERY_COWIN        = 7,   // 
        VSB_CHERY_TIGGO        = 8,   // 
        VSB_CHERY_A5           = 9,   // A5
        VSB_CHERY_S16          = 10,  // S16
        VSB_CHERY_YOUYA        = 11,  // 
        VSB_CHERY_V5           = 12,  // V5
        VSB_CHERY_E3           = 13,   // E3
        VSB_CHERY_A1_1                = 14,     // -A1-2011,2008,2007
        VSB_CHERY_A3LIANGXIANG_1      = 15,     // -A3-2012,2010,2009
        VSB_CHERY_A5_1                = 16,     // -A5-2009,2007,2006
        VSB_CHERY_QQ_1                = 17,     // -QQ-2006,2005,2004
        VSB_CHERY_QQ_2                = 18,     // -QQ-2010,2007,2006
        VSB_CHERY_QQ_3                = 19,     // -QQ-2012,2011,2010,2009,2007
        VSB_CHERY_QQ_4                = 20,     // -QQ-2012˶
        VSB_CHERY_QQ_5                = 21,     // -QQ-2013
        VSB_CHERY_DONGFANGZHIZI_1     = 22,     // -֮-2005,2004,2003
        VSB_CHERY_DONGFANGZHIZI_2     = 23,     // -֮-2007,2006
        VSB_CHERY_DONGFANGZHIZI_3     = 24,     // -֮CROSS-2009,2008,2007
        VSB_CHERY_YOUYA_1             = 25,     // --δ֪
        VSB_CHERY_E3_1                = 26,     // -E3-2013
        VSB_CHERY_E5_1                = 27,     // -E5-2014,2012,2011
        VSB_CHERY_QIYUN1_1            = 28,     // -1-2010
        VSB_CHERY_QIYUN1_2            = 29,     // -1-2012
        VSB_CHERY_QIYUN_1             = 30,     // --2004
        VSB_CHERY_QIYUN_2             = 31,     // --2009,2008,2007,2006
        VSB_CHERY_QIYUN2_1            = 32,     // -2-2012
        VSB_CHERY_QIYUN2_2            = 33,     // -2-2012,2010
        VSB_CHERY_QIYUN3_1            = 34,     // -3-2010
        VSB_CHERY_RUIHU_1             = 35,     // --2007,2006,2005
        VSB_CHERY_RUIHU_2             = 36,     // --2009,2007
        VSB_CHERY_RUIHU_3             = 37,     // --2012,2011
        VSB_CHERY_RUIHU_4             = 38,     // --2013,2012ԶDVVT
        VSB_CHERY_RUIHU_5             = 39,     // --2013Ӣ,2012Ӣ
        VSB_CHERY_FENGYUN2SANXIANG_1  = 40,     // -2-2010
        VSB_CHERY_AIRUIZE7_1          = 41     // -7-2014,2013
}VSB_CHERY_CLASS;

//Ʒ
typedef enum _VSB_KIA_CLASS
{
    VSB_KIA_OTHER        = 0,   // 
        VSB_KIA_K2           = 1,   // K2
        VSB_KIA_K3           = 2,   // K3
        VSB_KIA_K5           = 3,   // K5
        VSB_KIA_RIO          = 4,   // ŷ
        VSB_KIA_CERATO       = 5,   // ͼ
        VSB_KIA_SPORTAGER    = 6,   // ʨ
        VSB_KIA_SOUL         = 7,   // 
        VSB_KIA_ZHIPAO       = 8,   // 
        VSB_KIA_CARENS       = 9,   // 
        VSB_KIA_CARNIVAL     = 10,  // λ
        VSB_KIA_OPTIMA       = 11,  // Զ
        VSB_KIA_OPIRUS       = 12,  // ŷ˹
        VSB_KIA_MAXIMA       = 13,  // ǧ
        VSB_KIA_FORTE        = 14,  // 
        VSB_KIA_SORENTO      = 15,  // 
        VSB_KIA_K2_1         = 16,   // -K2-2013,2012,2011
        VSB_KIA_K3_1         = 17,   // -K3-2012
        VSB_KIA_K5_1         = 18,   // -K5-2012,2011
        VSB_KIA_RUIOU_1      = 19,   // -RIOŷ-2009,2007
        VSB_KIA_QIANLIMA_1   = 20,   // -ǧ-2004
        VSB_KIA_QIANLIMA_2   = 21,   // -ǧ-2006,2005
        VSB_KIA_JIAHUA_1     = 22,   // -λ-δ֪
        VSB_KIA_XINJIALE_1   = 23,   // -¼-2011
        VSB_KIA_ZHIPAO_1     = 24,   // --2014,2012,2011,2010
        VSB_KIA_SHIPAO_1     = 25,  // -ʨ-2008,2007,2005
        VSB_KIA_SHIPAO_2     = 26,  // -ʨ-2011,2009
        VSB_KIA_SHIPAO_3     = 27,  // -ʨ-2012
        VSB_KIA_SHIPAO_4     = 28,  // -ʨ-2013
        VSB_KIA_FURUIDI_1    = 29,  // --2012,2011,2009
        VSB_KIA_FURUIDI_2    = 30,  // --2014
        VSB_KIA_XIUER_1      = 31,  // --2012,2010
        VSB_KIA_SUOLANTUO_1  = 32,  // --2006
        VSB_KIA_SUOLANTUO_2  = 33,  // --2012,2010,2009
        VSB_KIA_SAILATU_1    = 34,  // -ͼ-2006,2005
        VSB_KIA_SAILATU_2    = 35,  // -ͼ-2007
        VSB_KIA_SAILATU_3    = 36,  // -ͼ-2012,2010GLS
        VSB_KIA_YUANJIAN_1   = 37   // -Զ-δ֪
}VSB_KIA_CLASS;

//Ʒ
typedef enum _VSB_BENZ_CLASS
{
    VSB_BENZ_OTHER         = 0,   // 
        VSB_BENZ_C             = 1,   // C
        VSB_BENZ_E             = 2,   // E
        VSB_BENZ_GLK           = 3,   // GLK
        VSB_BENZ_WEITING       = 4,   // -PINYIN
        VSB_BENZ_SPRINTER      = 5,   // 
        VSB_BENZ_VIANO         = 6,   // Ψŵ
        VSB_BENZ_M             = 7,   // Mϵ
        VSB_BENZ_CLK           = 8,   // CLKϵ
        VSB_BENZ_G             = 9,   // Gϵ
        VSB_BENZ_GL            = 10,  // GLϵ
        VSB_BENZ_R             = 11,  // Rϵ
        VSB_BENZ_S             = 12,  // Sϵ
        VSB_BENZ_A             = 13,  // Aϵ
        VSB_BENZ_SMART         = 14,  // ˹()
        VSB_BENZ_B             = 15,  // Bϵ
        VSB_BENZ_SLK           = 16,  // SLKϵ
        VSB_BENZ_MB100         = 17,  // MB100
        VSB_BENZ_VITO          = 18,  // 
        VSB_BENZ_CLS           = 19,  // CLSϵ
        VSB_BENZ_SL            = 20,   // SLϵ
        VSB_BENZ_AJI_1         = 21,   // -A-2011,2009
        VSB_BENZ_AJI_2         = 22,   // -A-2013
        VSB_BENZ_BJI_1         = 23,   // -B-2010,2009
        VSB_BENZ_CJI_1         = 24,   // -C-2010,2008,2007ʱ
        VSB_BENZ_CJI_2         = 25,   // -C-2013,2011,CGI
        VSB_BENZ_CJI_3         = 26,   // -C-2013,2011ʱ
        VSB_BENZ_EJI_1         = 27,   // -E-2002
        VSB_BENZ_EJI_2         = 28,   // -E-2007,2006
        VSB_BENZ_EJI_3         = 29,   // -E-2013,2012,2011,2010,2009
        VSB_BENZ_EJI_4         = 30,   // -E-2013,2012,2011,2010,2009ʱ
        VSB_BENZ_GLKJI_1       = 31,   // -GLK-2012,2011
        VSB_BENZ_GLKJI_2       = 32,   // -GLK-2012,2011,2008
        VSB_BENZ_GLKJI_3       = 33,   // -GLK-2014,2013
        VSB_BENZ_GLJI_1        = 34,   // -GL-2011
        VSB_BENZ_GLJI_2        = 35,   // -GL-2011,2010
        VSB_BENZ_GLJI_3        = 36,   // -GL-2012,2010
        VSB_BENZ_GJI_1         = 37,   // -G-2013,2010,2009
        VSB_BENZ_MB100_1       = 38,   // -MB100-2000
        VSB_BENZ_MLJI_1        = 39,   // -ML-2006,2005
        VSB_BENZ_MLJI_2        = 40,   // -ML-2010,2008
        VSB_BENZ_MLJI_3        = 41,   // -ML-2014,2012
        VSB_BENZ_RJI_1         = 42,   // -R-2006
        VSB_BENZ_RJI_2         = 43,   // -R-2007
        VSB_BENZ_RJI_3         = 44,   // -R-2014,2011,2010,2009
        VSB_BENZ_SLKJI_2       = 45,   // -SLK-2006,2004
        VSB_BENZ_SLKJI_3       = 46,   // -SLK-2010,2009
        VSB_BENZ_SLKJI_1       = 47,   // -SLK-2011
        VSB_BENZ_SJI_1         = 48,   // -S-2004
        VSB_BENZ_SJI_2         = 49,   // -S-2009_Hybrid,2008,2006
        VSB_BENZ_SJI_3         = 50,   // -S-2009,2008
        VSB_BENZ_SJI_4         = 51,   // -S-2012,2011,2010
        VSB_BENZ_LINGTE_1      = 52,   // --2013,2012,2011
        VSB_BENZ_WEIYANUO_1    = 53,   // -Ψŵ-2010,2006,2004
        VSB_BENZ_WEIYANUO_2    = 54,   // -Ψŵ-2014,2013,2012,2011
        VSB_BENZ_WEITING_1     = 55,   // --2013,2011,2010
        VSB_BENZ_KECHE_1       = 56    // -ͳ1-A
}VSB_BENZ_CLASS;

//˹´Ʒ
typedef enum _VSB_SKODA_CLASS
{
    VSB_SKODA_OTHER            = 0,   // 
        VSB_SKODA_HAORUI           = 1,   // 
        VSB_SKODA_FABIA            = 2,   // 
        VSB_SKODA_OCTAVIA          = 3,   // 
        VSB_SKODA_SUPERB           = 4,   // 
        VSB_SKODA_SPACEBACK        = 5,   // 꿶
        VSB_SKODA_RAPID            = 6,   // 
        VSB_SKODA_YETI             = 7,    // Ұ
        VSB_SKODA_HAORUI_1         = 8,      // ˹´--2013,2012,2010,2009
        VSB_SKODA_MINGRUI_1        = 9,      // ˹´--2009,2008,2007
        VSB_SKODA_MINGRUI_2        = 10,      // ˹´--2014,2013,2012,2011,2010
        VSB_SKODA_MINGRUI_3        = 11,      // ˹´-RS-2010
        VSB_SKODA_XINRUI_1         = 12,      // ˹´--2013ѡ
        VSB_SKODA_JINGRUI_1        = 13,      // ˹´--2011,2009,2008
        VSB_SKODA_JINGRUI_2        = 14,      // ˹´--2014,2013,2012
        VSB_SKODA_JINGRUI_3        = 15,      // ˹´--2014,2013,2012Sport
        VSB_SKODA_SUPAI_1          = 16,      // ˹´--2013
        VSB_SKODA_YEDI_1           = 17      // ˹´-Ұ-2014,2013
}VSB_SKODA_CLASS;

//Ʒ
typedef enum _VSB_DONGFENG_CLASS
{
    VSB_DONGFENG_OTHER                 = 0,   // 
        VSB_DONGFENG_JOYEARX5              = 1,   // X5
        VSB_DONGFENG_LINGZHI               = 2,   // 
        VSB_DONGFENG_JOYEARX3              = 3,   // X3
        VSB_DONGFENG_JOYEAR                = 4,   // 
        VSB_DONGFENG_FENGXINGCM7           = 5,   // CM7
        VSB_DONGFENG_YUFENG                = 6,   // 
        VSB_DONGFENG_FENGSHENA60           = 7,   // A60
        VSB_DONGFENG_FENGSHENS30           = 8,   // S30
        VSB_DONGFENG_FENGSHENH30CROSS      = 9,   // H30-CROSS
        VSB_DONGFENG_PICKUP                = 10,  // Ƥ
        VSB_DONGFENG_ZHONGXINGMIANBAOCHE   = 11,  // 
        VSB_DONGFENG_XIAOXINGMIANBAOCHE    = 12,  // С
        VSB_DONGFENG_ZHONGXINGVAN          = 13,  // ͻ
        VSB_DONGFENG_QINGXINGXIANGSHIVAN   = 14,  // ʽ
        VSB_DONGFENG_QINGZHONGXINGVAN      = 15,  // ͨ
        VSB_DONGFENG_FENGSHENMERCURY       = 16,  // ˮ
        VSB_DONGFENG_SUCCE                 = 17,  // ˧
        VSB_DONGFENG_ODIN                  = 18,  // ¶
        VSB_DONGFENG_YUMSUN                = 19,  // 
        VSB_DONGFENG_RUIQI                 = 20,  // 
        VSB_DONGFENG_FENGGUANG             = 21,  // 
        VBR_DONGFENG_C35_1                 = 22,   // -C35-2013
        VBR_DONGFENG_K07_1                 = 23,   // -K07-2008
        VBR_DONGFENG_K07_2                 = 24,   // -K07-2010,2006
        VBR_DONGFENG_V21_1                 = 25,   // -V21-2011
        VBR_DONGFENG_JIALONG_1             = 26,   // --ػ
        VBR_DONGFENG_XKFG_1                = 27,   // -С-2013
        VBR_DONGFENG_CV03_1                = 28,   // -CV03-2012
        VBR_DONGFENG_KAIPUTE_1             = 29,   // --C390
        VBR_DONGFENG_DUOLIKA_1             = 30,   // --S2800
        VBR_DONGFENG_DUOLIKA_2             = 31,   // --XLп
        VBR_DONGFENG_DUOLIKA_3             = 32,   // --п
        VBR_DONGFENG_TIANJIN_1             = 33,   // --4X2ػ
        VBR_DONGFENG_TIANJIN_2             = 34,   // --A
        VBR_DONGFENG_XBW_1                 = 35,   // -С-Ῠ1
        VBR_DONGFENG_XBW_2                 = 36,   // -С-Ῠ2
        VBR_DONGFENG_MENGKA_1              = 37,   // -ο-Ῠ
        VBR_DONGFENG_FURUIKA_1             = 38,   // --Ῠ1
        VBR_DONGFENG_RUIQI_1               = 39,   // -Ƥ-2013,2010,2009
        VBR_DONGFENG_A60_1                 = 40,   // -A60-2014,2012
        VBR_DONGFENG_H30_1                 = 41,   // -H30-Cross-2012,2011
        VBR_DONGFENG_H30_2                 = 42,   // -H30-Cross-2014,2013
        VBR_DONGFENG_H30_3                 = 43,   // -H30-2012
        VBR_DONGFENG_JINGYI_1              = 44,   // --2014_2012LV,2011
        VBR_DONGFENG_JINGYI_2              = 45,   // --2014_2012XL,2011,2010,2009,2008,2007
        VBR_DONGFENG_JINGYI_3              = 46,   // -X5-2014,2013
        VBR_DONGFENG_LINGZHI_1             = 47,   // --2004
        VBR_DONGFENG_LINGZHI_2             = 48,   // --2011,2008,2007
        VBR_DONGFENG_LINGZHI_3             = 49,   // --2011Q3׼,2010Q7
        VBR_DONGFENG_LINGZHI_4             = 50,   // --2014_2013M3
        VBR_DONGFENG_LINGZHI_5             = 51   // --2014_2013V3,2011M3_ð_
}VSB_DONGFENG_CLASS;

//ǵƷ
typedef enum _VSB_BYD_CLASS
{
    VSB_BYD_OTHER         = 0,   // 
        VSB_BYD_F0            = 1,   // ǵF0
        VSB_BYD_F3            = 2,   // ǵF3
        VSB_BYD_F3R           = 3,   // ǵF3R
        VSB_BYD_F6            = 4,   // ǵF6
        VSB_BYD_G3            = 5,   // ǵG3
        VSB_BYD_G3R           = 6,   // ǵG3R
        VSB_BYD_G6            = 7,   // ǵG6
        VSB_BYD_L3            = 8,   // ǵL3
        VSB_BYD_M6            = 9,   // ǵM6
        VSB_BYD_S6            = 10,  // ǵS6
        VSB_BYD_SURUI         = 11,  // 
        VSB_BYD_FOLEL         = 12,  // ش
        VSB_BYD_SIRUI         = 13,  // ˼
        VSB_BYD_MT5           = 14,  // ǵMT5()
        VSB_BYD_F0_1          = 15,        // ǵ-F0-2013,2012,2011,2010,2009,2008
        VSB_BYD_F3R_1         = 16,        // ǵ-F3R-2011,2009,2008,2007
        VSB_BYD_F6_1          = 17,        // ǵ-F6-2011,2009,2008
        VSB_BYD_G3R_1         = 18,        // ǵ-G3R-2011
        VSB_BYD_G6_1          = 19,        // ǵ-G6-2013,2012,2011
        VSB_BYD_L3_1          = 20,        // ǵ-L3-2013,2012,2011,2010
        VSB_BYD_M6_1          = 21,        // ǵ-M6-2013,2011,2010
        VSB_BYD_S6_1          = 22,        // ǵ-S6-2014,2013,2012,2011
        VSB_BYD_FULAIER_1     = 23,        // ǵ--2005
        VSB_BYD_SURUI_1       = 24        // ǵ--2014,2013,2012
}VSB_BYD_CLASS;

//ľƷ
typedef enum _VSB_SUZUKI_CLASS
{
    VSB_SUZUKI_OTHER           = 0,   // 
        VSB_SUZUKI_ALTO            = 1,   // 
        VSB_SUZUKI_SCROSS          = 2,   // Ԧ
        VSB_SUZUKI_SWIFT           = 3,   // 
        VSB_SUZUKI_SX4             = 4,   // 
        VSB_SUZUKI_LINGYANG        = 5,   // 
        VSB_SUZUKI_BEIDOUXING      = 6,   // 
        VSB_SUZUKI_LIANAA6         = 7,   // -A6
        VSB_SUZUKI_LANDY           = 8,   // ˵
        VSB_SUZUKI_SPLASH          = 9,   // ϲ
        VSB_SUZUKI_GRANDVITARA     = 10,  // ά
        VSB_SUZUKI_JIMNY           = 11,  // ķ
        VSB_SUZUKI_KAZASHI         = 12,  // 
        VSB_SUZUKI_LIANA           = 13,   // 
        VSB_SUZUKI_LIANA_1           = 14,     // ľ--2012,2011,2010,2008,2007,2005
        VSB_SUZUKI_LIANA_2           = 15,     // ľ--2013,2012,2011
        VSB_SUZUKI_BEIDOUXING_1      = 16,     // ľ--2012,2011,2010,2009,2008,2007,2005,2004׼
        VSB_SUZUKI_BEIDOUXING_2      = 17,     // ľ--2013,2012,2011,2010,2009,2008,2007,2005,2004,2003
        VSB_SUZUKI_BEIDOUXING_3      = 18,     // ľ--2013,2012,2011,2010,2009,2008,2007,2005,2004,2003
        VSB_SUZUKI_BEIDOUXING_4      = 19,     // ľ--2013X5
        VSB_SUZUKI_JIMUNI_1          = 20,     // ľ-ķ-2011,2010,2009,2007
        VSB_SUZUKI_JIMUNI_2          = 21,     // ľ-ķ-2012
        VSB_SUZUKI_SX4_1             = 22,     // ľ-SX4-2008,2006
        VSB_SUZUKI_SX4_2             = 23,     // ľ-SX4-2010,2009
        VSB_SUZUKI_SX4_3             = 24,     // ľ-SX4-2011A,2009,2008,2007
        VSB_SUZUKI_SX4_4             = 25,     // ľ-SX4-2011B
        VSB_SUZUKI_SX4_5             = 26,     // ľ-SX4-2013,2012,2011
        VSB_SUZUKI_ALTO_1            = 27,     // ľ--2006,2001,2000,1999,1993׼
        VSB_SUZUKI_ALTO_2            = 28,     // ľ--2006,2004,2001,2000,1999,1993
        VSB_SUZUKI_ALTO_3            = 29,     // ľ--2013
        VSB_SUZUKI_ALTO_4            = 30,     // ľ--2014,2012,2011,2010,2009
        VSB_SUZUKI_SPLASH_1          = 31,     // ľ-ϲ-2013,2012,2011
        VSB_SUZUKI_LANDY_1           = 32,     // ľ-˵-2011,2010,2007
        VSB_SUZUKI_LINGYANG_2        = 33,     // ľ--2006,2004,2003
        VSB_SUZUKI_LINGYANG_3        = 34,     // ľ--2009,2008,2007
        VSB_SUZUKI_LINGYANG_4        = 35,     // ľ--2011
        VSB_SUZUKI_LINGYANG_5        = 36,     // ľ--2012
        VSB_SUZUKI_GRANDVITARA_1     = 37,     // ľ-ά-2011,2008,2007,2006
        VSB_SUZUKI_FENGYU_1          = 38,     // ľ-Ԧ-2014
        VSB_SUZUKI_SWIFT_1           = 39,     // ľ--2011_1.3L,2009,2008,2007,2005
        VSB_SUZUKI_SWIFT_2           = 40,     // ľ--2012,2011
        VSB_SUZUKI_KINGCHANG_1       = 41,     // ľ--2004
        VSB_SUZUKI_LINGYANG_1        = 42     // ľ--2002
}VSB_SUZUKI_CLASS;

//Ʒ
typedef enum _VSB_SGMW_CLASS
{
    VSB_SGMW_OTHER               = 0,   // 
        VSB_SGMW_HONGGUANG           = 1,   // 
        VSB_SGMW_HONGGUANGS          = 2,   // S
        VSB_SGMW_ZHIGUANG            = 3,   // ֮
        VSB_SGMW_RONGGUANGS          = 4,   // ٹS
        VSB_SGMW_RONGGUANG           = 5,   // ٹ
        VSB_SGMW_HONGTU              = 6,   // ;
        VSB_SGMW_XINGWANG            = 7,   // 
        VSB_SGMW_YANGGUANG           = 8,   // 
        VSB_SGMW_XIAOXUANFENG        = 9,   // С
        VSB_SGMW_WULINGZHIGUANG_1    = 10,       // -֮-2010,2009ҵ
        VSB_SGMW_WULINGZHIGUANG_2    = 11,       // -֮-2010̳,
        VSB_SGMW_WULINGZHIGUANG_3    = 12,       // -֮-2010,2008ʽ,2007
        VSB_SGMW_XINGWANG_1          = 13,       // --2003
        VSB_SGMW_XINGWANG_2          = 14,       // --2009׼
        VSB_SGMW_XINGWANG_3          = 15,       // --2010,2009,2007,2006,2005,2004
        VSB_SGMW_HONNGUANG_1         = 16,       // --2013,2010
        VSB_SGMW_HONNGUANG_2         = 17,       // --2014,2013S
        VSB_SGMW_XIAOXUANFENG_1      = 18,       // -С-2006
        VSB_SGMW_YANGGUANG_1         = 19,       // --2006,2005,2004
        VSB_SGMW_YANGGUANG_2         = 20,       // --2008,2007
        VSB_SGMW_YANGGUANG_3         = 21,       // --2009,2006,2005ֶ׼
        VSB_SGMW_RONGGUANG_1         = 22,       // -ٹ-2012,2011,2008
        VSB_SGMW_RONGGUANG_2         = 23,       // -ٹ-2012,2011,2008׼
        VSB_SGMW_HONGTU_1            = 24        // -;-2010,2009,2008,2007
}VSB_SGMW_CLASS;

//Ʒ
typedef enum _VSB_CHANA_CLASS
{
    VSB_CHANA_OTHER                = 0,   // 
        VSB_CHANA_HONOR                = 1,   // ŷŵ
        VSB_CHANA_XINGKA               = 2,   // ǿ
        VSB_CHANA_ZHIXING              = 3,   // ֮
        VSB_CHANA_PICKUP               = 4,   // С(Ƥ)
        VSB_CHANA_ZHIXING2             = 5,   // ֮2
        VSB_CHANA_TAURUS               = 6,   // ţ
        VSB_CHANA_XINGGUANG            = 7,   // ǹ
        VSB_CHANA_BENNI                = 8,   // 
        VSB_CHANA_ALSVIN               = 9,   // 
        VSB_CHANA_CX20                 = 10,  // CX20
        VSB_CHANA_CX30                 = 11,  // CX30
        VSB_CHANA_EADO                 = 12,  // ݶ
        VSB_CHANA_ZHIXINGS460          = 13,  // ֮S460
        VSB_CHANA_CM8                  = 14,  // CM8
        VSB_CHANA_XINBAO               = 15,  // ±
        VSB_CHANA_XUNLONG              = 16,  // ѫ
        VSB_CHANA_YUNTONG              = 17,  // ͨ
        VSB_CHANA_LEIMENG              = 18,  // 
        VSB_CHANA_XINGYUN              = 19,  // 
        VSB_CHANA_OULIWEI              = 20,  // ŷ
        VSB_CHANA_EADOXT               = 21,   // XT
        VSB_CHANA_XINGYUN_1            = 22,      // --2004,2003,2000
        VSB_CHANA_OULIWEI_1            = 23,      // -ŷ-2013
        VSB_CHANA_YUNTONG_1            = 24,      // -ͨ-2004
        VSB_CHANA_TAURUS_1             = 25,      // -ţ-2013,2012,2011,2010
        VSB_CHANA_LEIMENG_1            = 26,      // --2005,2003
        VSB_CHANA_ZHIXING_1            = 27,      // -֮-2010,2009
        VSB_CHANA_ZHIXING_2            = 28,      // -֮-2013
        VSB_CHANA_ZHIXING_3            = 29,      // -֮2-2009,2008
        VSB_CHANA_ZHIXING_4            = 30,      // -֮2-2012
        VSB_CHANA_ZHIXING_5            = 31,      // -֮S460-2010,2009
        VSB_CHANA_ZHIXING_6            = 32,      // -֮SC6350-2003
        VSB_CHANA_PICKUP_1             = 33,      // -΢-2013,2012
        VSB_CHANA_XINGGUANG_1          = 34,      // -ǹ4500-2009,2007
        VSB_CHANA_XINGGUANG_2          = 35,      // -ǹ4500-2012
        VSB_CHANA_HONOR_1              = 36      // -ŷŵ-2014,2012
}VSB_CHANA_CLASS;

//γƷ
typedef enum _VSB_EADO_CLASS
{
    VSB_EADO_OTHER                = 0,       // 
        VSB_EADO_CS_1                 = 1,       // γ-CS35-2014,2013,2012
        VSB_EADO_CX_1                 = 2,       // γ-CX20-2011
        VSB_EADO_CX_2                 = 3,       // γ-CX30-2010
        VSB_EADO_BENBEN_1             = 4,       // γ--2008,2007,2006
        VSB_EADO_BENBEN_2             = 5,       // γ--2008,2007˶
        VSB_EADO_BENBEN_3             = 6,       // γ--2010
        VSB_EADO_BENBEN_4             = 7,       // γ-MINI-2011,2010
        VSB_EADO_BENBEN_5             = 8,       // γ-MINI-2012
        VSB_EADO_YUEXIANG_1           = 9,       // γ--2011,2010,2009
        VSB_EADO_YUEXIANG_2           = 10,       // γ--2012
        VSB_EADO_YUEXIANG_3           = 11,       // γ-V3-2013,2012
        VSB_EADO_YUEXIANG_4           = 12,       // γ-V5-2012
        VSB_EADO_YIDONG_1             = 13        // γ-ݶ-2014,2013,2012
}VSB_EADO_CLASS;

//Ʒ
typedef enum _VSB_JINBEI_CLASS
{
    VSB_JINBEI_OTHER           = 0,   // 
        VSB_JINBEI_GRACE           = 1,   // 𱭸˹
        VSB_JINBEI_HIACE           = 2,   // 𱭺ʨ
        VSB_JINBEI_HAIXING         = 3,   // 
        VSB_JINBEI_BADAO           = 4,   // 𱭰Ե
        VSB_JINBEI_LINGQI          = 5,   // 
        VSB_JINBEI_JINQI           = 6,   // 
        VSB_JINBEI_LINGCHI         = 7,   // 
        VSB_JINBEI_QIYUN           = 8,   // 
        VSB_JINBEI_ZHISHANG_1      = 9,       // -S30-2014,2013,2012
        VSB_JINBEI_HAIXING_1       = 10,       // --2012
        VSB_JINBEI_HAIXING_2       = 11,       // --2012A7ػ,2011
        VSB_JINBEI_HIACE_1         = 12,       // -ʨ-2008
        VSB_JINBEI_HIACE_2         = 13,       // -ʨ-2013,2011,2010
        VSB_JINBEI_HIACE_3         = 14,       // -ʨ-2013,2011,2008׼
        VSB_JINBEI_JINDIAN_1       = 15,       // --2009
        VSB_JINBEI_GRACE_1         = 16,       // -˹MPV-2011,2008,2007
        VSB_JINBEI_GRACE_2         = 17,       // -˹MPV-2011,2010,2009,2007׼9
        VSB_JINBEI_BADAO_1         = 18       // -ԵSUV-2011,2008 
        
}VSB_JINBEI_CLASS;

//Ʒ
typedef enum _VSB_GEELY_CLASS
{
    VSB_GEELY_OTHER              = 0,   // 
        VSB_GEELY_EC7                = 1,   // ۺEC7
        VSB_GEELY_EC8                = 2,   // ۺEC8                                                          
        VSB_GEELY_SC3                = 3,   // SC3
        VSB_GEELY_SC5RV              = 4,   // SC5-RV
        VSB_GEELY_SC6                = 5,   // SC6
        VSB_GEELY_JINGYING           = 6,   // ӥ
        VSB_GEELY_JINGGANG           = 7,   // 
        VSB_GEELY_SX7                = 8,   // SX7
        VSB_GEELY_HAOQING            = 9,   // 
        VSB_GEELY_MEIRI              = 10,  // 
        VSB_GEELY_YINGLUNSC7         = 11,  // ӢSC7
        VSB_GEELY_PANDA              = 12,  // è
        VSB_GEELY_YUANJING           = 13,  // Զ
        VSB_GEELY_ZIYOUJIAN          = 14   // ɽ
}VSB_GEELY_CLASS;

//Ʒ
typedef enum _VSB_MITSUBISHI_CLASS
{
    VSB_MITSUBISHI_OTHER                 = 0,   // 
        VSB_MITSUBISHI_GALANT                = 1,   // 
        VSB_MITSUBISHI_ZINGER                = 2,   // 
        VSB_MITSUBISHI_LANCER                = 3,   // ɪ
        VSB_MITSUBISHI_LANCEREX              = 4,   // 
        VSB_MITSUBISHI_PAJERO                = 5,   // 
        VSB_MITSUBISHI_PAJEROSPORT           = 6,   // -
        VSB_MITSUBISHI_JINGXUANASX           = 7,   // ASX
        VSB_MITSUBISHI_GRANDIS               = 8,   // 
        VSB_MITSUBISHI_OUTLANDER             = 9,   // ŷ
        VSB_MITSUBISHI_QINXINGYUEYE          = 10,  // ԽҰ
        VSB_MITSUBISHI_GTO                   = 11,  // GTO
        VSB_MITSUBISHI_SOVERAN               = 12,  // 
        VSB_MITSUBISHI_LIONVEL               = 13,  // 
        VSB_MITSUBISHI_HAFEISIMBO            = 14,   // 
        VSB_MITSUBISHI_LANCEREX_1            = 15,   // --2012,2011,2010
        VSB_MITSUBISHI_JINGXUAN_1            = 16,   // --2012,2011
        VSB_MITSUBISHI_ZINGER_1              = 17,   // --2011,2009
        VSB_MITSUBISHI_PAJERO_1              = 18,   // --2004
        VSB_MITSUBISHI_PAJERO_2              = 19,   // --2004
        VSB_MITSUBISHI_PAJERO_3              = 20,   // --2010
        VSB_MITSUBISHI_PAJEROSPORT_1         = 21,   // -޾-2011
        VSB_MITSUBISHI_GALANT_1              = 22,   // --2009
        VSB_MITSUBISHI_GALANDI_1             = 23,   // --2007
        VSB_MITSUBISHI_GALANDI_2             = 24,   // --2010
        VSB_MITSUBISHI_OUTLANDER_1           = 25,   // -ŷ-2012,2011,2010
        VSB_MITSUBISHI_OUTLANDER_2           = 26,   // -ŷ-2013
        VSB_MITSUBISHI_LINGYUE_1             = 27,   // --δ֪
        VSB_MITSUBISHI_LANCER_1              = 28   // -ɪ-2010
}VSB_MITSUBISHI_CLASS;

//׿˹Ʒ
typedef enum _VSB_LEXUS_CLASS
{
    VSB_LEXUS_OTHER             = 0,   // 
        VSB_LEXUS_ES                = 1,   // ׿˹ES
        VSB_LEXUS_CT                = 2,   // ׿˹CT                                                          
        VSB_LEXUS_RX                = 3,   // ׿˹RX
        VSB_LEXUS_IS                = 4,   // ׿˹IS
        VSB_LEXUS_LX                = 5,   // ׿˹LX
        VSB_LEXUS_GS                = 6,   // ׿˹GS
        VSB_LEXUS_GX                = 7,   // ׿˹GX
        VSB_LEXUS_LS                = 8,    // ׿˹LS
        VSB_LEXUS_CT_1              = 9,   // ׿˹-CT-2013,2012,2011
        VSB_LEXUS_ES_1              = 10,   // ׿˹-ES-1994
        VSB_LEXUS_ES_2              = 11,   // ׿˹-ES-2010,2009,2006
        VSB_LEXUS_ES_3              = 12,   // ׿˹-ES-2013,2012
        VSB_LEXUS_GS_1              = 13,   // ׿˹-GS-2011,2010,2009,2008,2005
        VSB_LEXUS_GX_1              = 14,   // ׿˹-GX-2012,2010
        VSB_LEXUS_IS_1              = 15,   // ׿˹-IS-2011
        VSB_LEXUS_LS_1              = 16,   // ׿˹-LS-1994
        VSB_LEXUS_LS_2              = 17,   // ׿˹-LS-2005,2004
        VSB_LEXUS_LS_3              = 18,   // ׿˹-LS-2009,2007,2006
        VSB_LEXUS_LX_1              = 19,   // ׿˹-LX-2013,2012
        VSB_LEXUS_RX_1              = 20,   // ׿˹-RX-2011,2010,2009
        VSB_LEXUS_RX_2              = 21,   // ׿˹-RX-2013,2012
        VSB_LEXUS_RX_3              = 22   // ׿˹-RX-2007
}VSB_LEXUS_CLASS;

//Ʒ
typedef enum _VSB_ROEWE_CLASS
{
    VSB_ROEWE_OTHER              = 0,   // 
        VSB_ROEWE_350                = 1,   // 350
        VSB_ROEWE_550                = 2,   // 550                                                          
        VSB_ROEWE_W5                 = 3,   // W5
        VSB_ROEWE_950                = 4,   // 950
        VSB_ROEWE_750                = 5,   // 750
        VSB_ROEWE_350_1              = 6,   // -350-2011Ѹǰ,2010
        VSB_ROEWE_350_2              = 7,   // -350-2014,2013,2012,2011
        VSB_ROEWE_550_1              = 8,   // -550-2012,2010,2009,2008
        VSB_ROEWE_750_1              = 9,   // -750-2009,2008,2007,2006
        VSB_ROEWE_750_2              = 10,  // -750-2012,2011
        VSB_ROEWE_950_1              = 11   // -950-2012
}VSB_ROEWE_CLASS;


//Ʒ
typedef enum _VSB_HAIMA_CLASS
{
    VSB_HAIMA_OTHER               = 0,   // 
        VSB_HAIMA_PREMARIN            = 1,   // 
        VSB_HAIMA_S7                  = 2,   // S7
        VSB_HAIMA_PRINCE              = 3,   // 
        VSB_HAIMA_CUPID               = 4,   // 2-
        VSB_HAIMA_HATCHBACK           = 5,   // 3-
        VSB_HAIMA_KNIGHT              = 6,   // ʿ
        VSB_HAIMA_HAPPIN              = 7,   // 
        VSB_HAIMA_FAMILY              = 8,   // 
        VSB_HAIMA_M3                  = 9,    // M3
        VSB_HAIMA_CUPID_1             = 10,   // --2012,2011,2010
        VSB_HAIMA_PREMARIN_1          = 11,   // --2007
        VSB_HAIMA_PREMARIN_2          = 12,   // --2012,2010
        VSB_HAIMA_HATCHBACK_1         = 13,   // --2010,2009
        VSB_HAIMA_HAPPIN_1            = 14,   // --2010,2009,2008,2007,2004
        VSB_HAIMA_HAPPIN_2            = 15,   // --2012,2011
        VSB_HAIMA_M3_1                = 16,   // -3-2010,2008,2007
        VSB_HAIMA_FAMILY_1            = 17,   // --2007,2006
        VSB_HAIMA_FAMILY_2            = 18,   // --2010,2009,2008
        VSB_HAIMA_FAMILY_3            = 19,   // --2011
        VSB_HAIMA_FAMILY_4            = 20,   // --2014,2013,2012
        VSB_HAIMA_KNIGHT_1            = 21,   // -ʿ-2013_2012A,2011,2010
        VSB_HAIMA_KNIGHT_2            = 22,   // -ʿ-2013_2012B
        VSB_HAIMA_NEWHONGDA_1         = 23,   // ó-º-2009
        VSB_HAIMA_NEWHONDGA_2         = 24,   // ó-º-2012
        VSB_HAIMA_PRINCE_1            = 25,   // ó--2010
        VSB_HAIMA_RONGDA_1            = 26   // ó-ٴ-2012
        
}VSB_HAIMA_CLASS;

//Ʒ
typedef enum _VSB_GREATWALL_CLASS
{
    VSB_GREATWALL_OTHER               = 0,   // 
        VSB_GREATWALL_SING                = 1,   // Ӱ
        VSB_GREATWALL_SAIJUN              = 2,   // 
        VSB_GREATWALL_HAVAL               = 3,   // 
        VSB_GREATWALL_SAFE                = 4,   // 
        VSB_GREATWALL_SAIKU               = 5,   // 
        VSB_GREATWALL_SAILING             = 6,   // 
        VSB_GREATWALL_KINGDEER            = 7,   // ϶
        VSB_GREATWALL_DEER                = 8,   // ϶
        VSB_GREATWALL_WINGLE              = 9,   // 翥
        VSB_GREATWALL_COOLBEAR            = 10,  // 
        VSB_GREATWALL_LINGAO              = 11,  // 
        VSB_GREATWALL_CROSS               = 12,  // 
        VSB_GREATWALL_GWPERI              = 13,  // 
        VSB_GREATWALL_COWRY               = 14,  // 
        VSB_GREATWALL_M4                  = 15,   // M4
        VSB_GREATWALL_LINGAO_1            = 16,   // --2010
        VSB_GREATWALL_HAVAL_1             = 17,   // -H3-2010,2009
        VSB_GREATWALL_HAVAL_2             = 18,   // -H3-2012,2010,2009
        VSB_GREATWALL_HAVAL_3             = 19,   // -H5-2012,2011,2010
        VSB_GREATWALL_HAVAL_4             = 20,   // -H5-2012,2011,2010̾
        VSB_GREATWALL_HAVAL_5             = 21,   // -H5-2012
        VSB_GREATWALL_HAVAL_6             = 22,   // -H5-2014,2013
        VSB_GREATWALL_HAVAL_8             = 23,   // -H6-2014,2013
        VSB_GREATWALL_HAVAL_9             = 24,   // -M2-2010
        VSB_GREATWALL_HAVAL_10            = 25,   // -M2-2013,2012
        VSB_GREATWALL_HAVAL_11            = 26,   // -M4-2012
        VSB_GREATWALL_HAVAL_12            = 27,   // --2011
        VSB_GREATWALL_CROSS_1             = 28,   // --2009,2008
        VSB_GREATWALL_CROSS_2             = 29,   // -CROSS-2011,2009
        VSB_GREATWALL_JINGLING_1          = 30,   // --δ֪
        VSB_GREATWALL_SING_1              = 31,   // -Ӱ-2003
        VSB_GREATWALL_SAIKU_1             = 32,   // --2004
        VSB_GREATWALL_SAILING_1           = 33,   // --δ֪
        VSB_GREATWALL_DIER_1              = 34,   // -϶-δ֪
        VSB_GREATWALL_COOLBEAR_1          = 35,   // --2010,2009
        VSB_GREATWALL_KINGDEER_1          = 36,   // -϶-2008,2007,2004,2003
        VSB_GREATWALL_GREATWALL_1         = 37,   // -C20R-2013,2011
        VSB_GREATWALL_GREATWALL_2         = 38,   // -C30-2010
        VSB_GREATWALL_GREATWALL_3         = 39,   // -C30-2012
        VSB_GREATWALL_GREATWALL_4         = 40,   // -C30-2013
        VSB_GREATWALL_GREATWALL_5         = 41,   // -C50-2013,2012
        VSB_GREATWALL_GREATWALL_6         = 42,   // -V80-2013,2012,2010,2009,2008
        VSB_GREATWALL_WINGLE_1            = 43,   // -翥3-2011,2010,2007,2006
        VSB_GREATWALL_WINGLE_2            = 44,   // -翥5-2014,2012,2011,2009 
        VSB_GREATWALL_HAVAL_7             = 45   // -H6-2013,2012,2011
}VSB_GREATWALL_CLASS;

//Ʒ
typedef enum _VSB_DS_CLASS
{
    VSB_DS_OTHER                      = 0,          // 
        VSB_DS_KUBO_1                     = 1,          // -Ძ-2011,2010,2009,2008
        VSB_DS_KUWEI_1                    = 2,          // --2011,2010,2009
        VSB_DS_KUWEI_2                    = 3           // --2013
}VSB_DS_CLASS;

//·Ʒ
typedef enum _VSB_LANDROVER_CLASS
{
    VSB_LANDROVER_OTHER              = 0,   // 
        VSB_LANDROVER_FAXIAN_1           = 1,   // ·--2005,2004
        VSB_LANDROVER_FAXIAN_2           = 2,   // ·--2013,2011,2010
        VSB_LANDROVER_LANSHENG_1         = 3,   // ·-ʤ-2012,2011,2010
        VSB_LANDROVER_LANSHENG_2         = 4,   // ·-ʤ-2014,2013,2012,2011
        VSB_LANDROVER_LANSHENG_3         = 5,   // ·-ʤ˶-2013,2012,2011,2010
        VSB_LANDROVER_LANSHENG_4         = 6,   // ·-ʤ˶-2013Ԧ
        VSB_LANDROVER_SXZ_1              = 7   // ·-2-2014,2013,2011
}VSB_LANDROVER_CLASS;

//Ʒ
typedef enum _VSB_MG_CLASS
{
    VSB_MG_OTHER             = 0,  // 
        VSB_MG_3SW_1             = 1,  // MG-MG-3SW-2009,2008
        VSB_MG_MG3_1             = 2,  // MG-MG3-2013,2012,2011
        VSB_MG_MG5_1             = 3,  // MG-MG5-2014,2013,2012
        VSB_MG_MG6_1             = 4,  // MG-MG6-2012,2011
        VSB_MG_MG7_1             = 5,  // MG-MG7-2010,2009,2008,2007
}VSB_MG_CLASS;

//һƷ
typedef enum _VSB_FAW_CLASS
{
    VSB_FAW_OTHER                                       = 0,    // 
        VSB_FAW_501_1                                        = 1,    //һ-501-Ῠ
        VSB_FAW_N3_1                                        = 2,    //һ-N3+-2006
        VSB_FAW_N3_2                                        = 3,    //һ-N3+-2008
        VSB_FAW_JIABAO_1                                    = 4,    //һ-ѱ-2011T50,T57
        VSB_FAW_JIABAO_2                                    = 5,    //һ-ѱ-2000
        VSB_FAW_JIABAO_3                                    = 6,    //һ-ѱ-2006
        VSB_FAW_JIABAO_4                                    = 7,    //һ-ѱ-2012,2011V50ʰ
        VSB_FAW_JIABAO_5                                    = 8,    //һ-ѱ-2012,2011V70
        VSB_FAW_JIABAO_6                                    = 9,    //һ-ѱ-2013,2012,2011V52ʵ
        VSB_FAW_JIABAO_7                                    = 10,    //һ-ѱ-2014,2013V80
        VSB_FAW_XIALI_1                                        = 11,    //һ--1999,1997
        VSB_FAW_XIALI_2                                        = 12,    //һ-2000-2003,2002
        VSB_FAW_XIALI_3                                        = 13,    //һ-A+-2011,2010,2006,2005
        VSB_FAW_XIALI_4                                        = 14,    //һ-N3-2012
        VSB_FAW_XIALI_5                                        = 15,    //һ-N5-2014,2013,2011,2010,2009
        VSB_FAW_XIALI_6                                        = 16,    //һ-N7-2013
        VSB_FAW_AOWEI_1                                        = 17,    //һ-J5P-2005,2004,2003
        VSB_FAW_AOWEI_2                                        = 18,    //һ-J5P-4X2ǣ,ж
        VSB_FAW_AOWEI_3                                        = 19,    //һ-J5P-4X2ǣ,ж
        VSB_FAW_AOWEI_4                                        = 20,    //һ-J5P-6X6ԽҰж
        VSB_FAW_AOXING_1                                    = 21,    //һ--2004
        VSB_FAW_WEILE_1                                        = 22,    //һ--2004
        VSB_FAW_WEILE_2                                        = 23,    //һ--2008,2007
        VSB_FAW_WEIZI_1                                        = 24,    //һ--2004
        VSB_FAW_WEIZHI_1                                    = 25,    //һ-־V2-2012ֶCROSS
        VSB_FAW_WEIZHI_2                                    = 26,    //һ-־V2-2012ԶCROSS,2010
        VSB_FAW_WEIZHI_3                                    = 27,    //һ-־V5-2013,2012
        VSB_FAW_WEIZHI_4                                    = 28,    //һ-־-2009,2008,2007
        VSB_FAW_WEIZHI_5                                    = 29,    //һ-־-2011
        VSB_FAW_XIAOJIEFANG_1                                = 30,    //һ-С-90,109Ῠ
        VSB_FAW_HANWEI_1                                    = 31,    //һ-J5M-4X4ػ
        VSB_FAW_HANWEI_2                                    = 32,    //һ-J5M-6X6ǣ,6X4ж
        VSB_FAW_HANWEI_3                                    = 33,    //һ-J5M-8X8ж
        VSB_FAW_XINDAWEI_1                                    = 34,    //һ-´-2010
        VSB_FAW_XINHANWEI_1                                    = 35,    //һ-º-2011
        VSB_FAW_SENYA_1                                        = 36,    //һ-ɭM80-2012,2011,2009
        VSB_FAW_TENGWEI_1                                    = 37,    //һ-L5M-ؿ
        VSB_FAW_JIEFANG_1                                    = 38,    //һ-J4R-A
        VSB_FAW_JIEFANG_2                                    = 39,    //һ-J4R-ж,ǣ
        VSB_FAW_JIEFANG_3                                    = 40,    //һ-J6-2004
        VSB_FAW_JIEFANG_4                                    = 41,    //һ-J6-ؿ
        VSB_FAW_JIEFANG_5                                    = 42,    //һ-J6L-п
        VSB_FAW_JIEFANG_6                                    = 43,    //һ-L5-A
        VSB_FAW_SAILONG_1                                    = 44,    //һ--п
        VSB_FAW_JUNWEI_1                                    = 45,    //һ-J5K-п
        VSB_FAW_B50_1                                        = 46,    //һ-B50-2012,2011,2009
        VSB_FAW_B50_2                                        = 47    //һ-B50-2013
}VSB_FAW_CLASS;


//Ʒ
typedef enum _VSB_SAICMOTOR_CLASS
{
    VSB_SAICMOTOR_OTHER               = 0,    // 
        VSB_HONGYAN_JIESHI_1              = 1,    // άº-ʨ-2012
        VSB_DATONG_V80_1                  = 2     // ͨ-V80-2014,2013,2012,2011
}VSB_SAICMOTOR_CLASS;

//Ʒ
typedef enum _VSB_SOUEAST_CLASS
{
    VSB_SOUEAST_OTHER                 = 0,    // 
        VSB_SOUEAST_V3_1                  = 1,    // -V3-2011ֵҸ,2010,2009,2008
        VSB_SOUEAST_V3_2                  = 2,    // -V3-2012
        VSB_SOUEAST_V3_3                  = 3,    // -V3-2012콢,2011,2010·ɰ
        VSB_SOUEAST_V3_4                  = 4,    // -V3-2012ɰ
        VSB_SOUEAST_V5_1                  = 5,    // -V5-2014,2013,2012
        VSB_SOUEAST_XIWANG_1              = 6,    // -ϣ-2011,2010
        VSB_SOUEAST_DELIKA_1              = 7,    // --2003,2002
        VSB_SOUEAST_DELIKA_2              = 8,    // --2005
        VSB_SOUEAST_DELIKA_3              = 9,    // --2008
        VSB_SOUEAST_DELIKA_4              = 10,    // --2009
        VSB_SOUEAST_LINGSHUAI_1           = 11,    // -˧-2005,2004GLXi
        VSB_SOUEAST_FULIKA_1              = 12,    // --2005
        VSB_SOUEAST_FULIKA_2              = 13    // --2007
}VSB_SOUEAST_CLASS;


//Ʒ
typedef enum _VSB_ZTE_CLASS
{
    VSB_ZTE_OTHER                     = 0,        // 
        VSB_ZTE_WEIHU_1                   = 1,        // --2012,2010
        VSB_ZTE_WEIHU_2                   = 2,        // -TUV-2010,2006
        VSB_ZTE_WUXIAN_1                  = 3,        // --2008
        VSB_ZTE_WUXIAN_2                  = 4         // --2012,2011,2010,2009
}VSB_ZTE_CLASS;


//лƷ
typedef enum _VSB_ZHONGHUA_CLASS
{
    VSB_ZHONGHUA_OTHER                = 0,    // 
        VSB_ZHONGHUA_H230_1               = 1,   // л-H230-2012
        VSB_ZHONGHUA_H320_1               = 2,   // л-H320-2012
        VSB_ZHONGHUA_H330_1               = 3,   // л-H330-2013
        VSB_ZHONGHUA_H530_1               = 4,   // л-H530-2012,2011
        VSB_ZHONGHUA_V5_1                 = 5,   // л-V5-2012,2011
        VSB_ZHONGHUA_ZUNCHI_1             = 6,   // л--2004
        VSB_ZHONGHUA_ZUNCHI_2             = 7,   // л--2005,2003
        VSB_ZHONGHUA_KUBAO_1              = 8,   // л-ᱦ-2007
        VSB_ZHONGHUA_JUNJIE_1             = 9,   // л--2010,2009,2008,2007,2006
        VSB_ZHONGHUA_JUNJIE_2             = 10,   // л--2012,2011
        VSB_ZHONGHUA_JUNJIECROSS_1        = 11,   // л-cross-2010,2009
        VSB_ZHONGHUA_JUNJIEFRV_1          = 12,   // л-FRV-2009,2008
        VSB_ZHONGHUA_JUNJIEFRV_2          = 13,   // л-FRV-2010
        VSB_ZHONGHUA_JUNJIEFSV_1          = 14,   // л-FSV-2009
        VSB_ZHONGHUA_JUNJIEFSV_2          = 15,   // л-FSV-2010
        VSB_ZHONGHUA_JUNJIEFSV_3          = 16   // л-FSV-2011
}VSB_ZHONGHUA_CLASS;


//йƷ
typedef enum _VSB_CNHTC_CLASS
{
    VSB_CNHTC_OTHER                   = 0,    // 
        VSB_CNHTC_HOKA_2                  = 1,      // й-HOKA-ǣ,ж
        VSB_CNHTC_HOWO_1                  = 2,      // й-HOWO-A7
        VSB_CNHTC_HOWO_2                  = 3,      // й-HOWO-T7H
        VSB_CNHTC_HOWO_3                  = 4,      // й-HOWO-Ῠ
        VSB_CNHTC_HOWO_4                  = 5,      // й-HOWOؿ-ǣ
        VSB_CNHTC_HOWO_5                  = 6,      // й-HOWOؿ-жA
        VSB_CNHTC_HOWO_6                  = 7,      // й-HOWOؿ-жB
        VSB_CNHTC_HOWO_7                  = 8,      // й-HOWOؿ-ػA
        VSB_CNHTC_HOWO_8                  = 9,      // й-HOWOؿ-ػC
        VSB_CNHTC_SITAIERWANG_1           = 10,      // й-˹̫-ǣA,ػ,賵
        VSB_CNHTC_HAOHAN_1                = 11,      // й--A
        VSB_CNHTC_HAOYUN_1                = 12,      // й--ǣB,ػ,ж
        VSB_CNHTC_JINWANGZI_1             = 13,      // й-ؿ-ǣB
        VSB_CNHTC_HOKA_1                  = 14      // й-HOKA-H7
}VSB_CNHTC_CLASS;

//ͨƷ
typedef enum _VSB_ZHONGTONG_CLASS
{
    VSB_ZHONGTONG_OTHER               = 0,  // 
        VSB_ZHONGTONG_KAICHI_1            = 1,  // ͨͳ-A-A
        VSB_ZHONGTONG_LINGYU_1            = 2,  // ͨͳ--A
        VSB_ZHONGTONG_LINGXIU_1           = 3,  // ͨͳ--A
        VSB_ZHONGTONG_LINGHANG_1          = 4,  // ͨͳ-캽-A
        VSB_ZHONGTONG_SHIJI_1             = 5,  // ͨͳ--A
        VSB_ZHONGTONG_KAIXUAN_1           = 6,  // ͨͳ--A
        VSB_ZHONGTONG_LINGYUN_1           = 7,  // ͨͳ-A-A
        VSB_ZHONGTONG_YANGGUANG_1         = 8  // ͨͳ--A
}VSB_ZHONGTONG_CLASS;


//Ʒ
typedef enum _VSB_JIULONG_CLASS
{
    VSB_JIULONG_OTHER                 = 0,    // 
        VSB_JIULONG_JIULONGA5_1           = 1,    // -A5-2011
}VSB_JIULONG_CLASS;

//̩Ʒ
typedef enum _VSB_ZOTYE_CLASS
{
    VSB_ZOTYE_OTHER                  = 0,       // 
        VSB_ZOTYE_2008_2                  = 1,      // ̩-2008-2011,2010,2008
        VSB_ZOTYE_5008_1                  = 2,      // ̩-5008-2013,2011,2010,2008
        VSB_ZOTYE_Z300_1                  = 3,      // ̩-Z300-2013,2012
        VSB_ZOTYE_2008_1                  = 4      // ̩-2008-2007
}VSB_ZOTYE_CLASS;

//άƷ
typedef enum _VSB_NAVECO_CLASS
{
    VSB_NAVECO_OTHER                  = 0,       // 
        VSB_NAVECO_Daily_1                = 1,     // ά-Daily-2006,2004,2003
        VSB_NAVECO_Power_1                = 2,     // ά-Power-Daily
        VSB_NAVECO_Turbo_1                = 3,     // ά-Turbo-Daily-2014,2012,2011
        VSB_NAVECO_Venice_1               = 4,     // ά-Venice-2011,2008
        VSB_NAVECO_BAODI_1                = 5,     // ά--2012,2009
        VSB_NAVECO_DEYIHUOCHE_1           = 6,     // ά--2011
        VSB_NAVECO_DULING_1               = 7     // ά--2010,2009,2007
}VSB_NAVECO_CLASS;

//ʱƷ
typedef enum _VSB_PORSCHE_CLASS
{
    VSB_PORSCHE_OTHER                 = 0,    // 
        VBR_PORSCHE_PANAMERA_1            = 1,    // ʱ-panamera-2013,2012,2010
        VBR_PORSCHE_CAYENNE_1             = 2,    // ʱ-Cayenne-2014,2013,2011,2010
}VSB_PORSCHE_CLASS;


//˹Ʒ
typedef enum _VSB_CHRYSLER_CLASS
{
    VSB_CHRYSLER_OTHER                = 0,    // 
        VSB_CHRYSLER_300C_1               = 1,   // ˹-300C-2007,2006,2004
        VSB_CHRYSLER_PTMANBUZHE_1         = 2,   // ˹-PT-2007
}VSB_CHRYSLER_CLASS;

//Ʒ
typedef enum _VSB_CADILLAC_CLASS
{
    VSB_CADILLAC_OTHER                = 0,    // 
        VSB_CADILLAC_ATS_1                = 1,   // -ATS-2014
        VSB_CADILLAC_CTS_1                = 2,   // -CTS-2012
        VSB_CADILLAC_CTS_3                = 3,   // -CTS-2012Ӣ˶,2011,2010,2009,2008
        VSB_CADILLAC_SLS_1                = 4,   // -SLS-2007,2006
        VSB_CADILLAC_SLS_2                = 5,   // -SLS-2012,2011,2010
        VSB_CADILLAC_SRX_1                = 6,   // -SRX-2012,2011,2010,2009
        VSB_CADILLAC_CTS_2                = 7,   // -CTS-2012,2009CTS
        VSB_CADILLAC_KAILEIDE_1           = 8   // -׵-2011,2010,2008,2007,2006
}VSB_CADILLAC_CLASS;


//KAMAƷ
typedef enum _VSB_KAMA_CLASS
{
    VSB_KAMA_OTHER                    = 0,       // 
        VSB_KAMA_QINGKA_2                 = 1,       // KAMA--ῨD
        VSB_KAMA_FULAIKA_1                = 2,       // KAMA--ῨA
        VSB_KAMA_JINYUNKA_1               = 3,       // KAMA-˿-Ῠ
        VSB_KAMA_JUNWEIKA_1               = 4,       // KAMA--2014,2011
        VSB_KAMA_QINGKA_1                 = 5       // KAMA--ῨC
}VSB_KAMA_CLASS;

//Ʒ
typedef enum _VSB_LIFAN_CLASS
{
    VSB_LIFAN_OTHER                   = 0,      // 
        VSB_LIFAN_320_1                   = 1,      // -320-2012,2011,2009
        VSB_LIFAN_520_1                   = 2,      // -520-2007,2006
        VSB_LIFAN_520_2                   = 3,      // -520-2013,2011,2010,2008
        VSB_LIFAN_620_1                   = 4,      // -620-2012,2010,2009,2008
        VSB_LIFAN_X60_1                   = 5,      // -X60-2013,2012,2011
        VSB_LIFAN_FENGSHUN_1              = 6      // -˳-2011
}VSB_LIFAN_CLASS;


//Ʒ
typedef enum _VSB_BEIJING_CLASS
{
    VSB_BEIJING_OTHER                 = 0,      // 
        VSB_BEIJING_E_1                   = 1,    // -Eϵ-2014,2013,2012
}VSB_BEIJING_CLASS;

//Ʒ
typedef enum _VSB_BEIBEN_CLASS
{
    VSB_BEIBEN_OTHER                  = 0,      // 
        VSB_BEIBEN_NG80_1                 = 1,     // -NG80-ؿA
        VSB_BEIBEN_NG80_2                 = 2,     // -NG80-ؿB
        VSB_BEIBEN_NG80_3                 = 3,     // -NG80-ؿC
        VSB_BEIBEN_V3_1                   = 4,     // -V3-V3H1
        VSB_BEIBEN_V3_2                   = 5     // -V3-ؿA
}VSB_BEIBEN_CLASS;

//ͳƷ
typedef enum _VSB_BEIFANG_CLASS
{
    VSB_BEIFANG_OTHER                 = 0,      // 
        VSB_BEIFANG_A_1                   = 1       // ͳ-ͳ1-A
}VSB_BEIFANG_CLASS;


//Ʒ
typedef enum _VSB_BAW_CLASS
{
    VSB_BAW_OTHER                     = 0,        // 
        VSB_BAW_YUSHENG007_1              = 1,        // -ʤ007-2013,2011
        VSB_BAW_QILING_1                  = 2,        // --A
        VSB_BAW_LUBA_1                    = 3,        // -½-2004
        VSB_BAW_QISHI_1                   = 4         // -ʿ-2009,2007
}VSB_BAW_CLASS;

//Ʒ
typedef enum _VSB_BQWEIWANG_CLASS
{
    VSB_BQWEIWANG_OTHER               = 0,  // 
        VSB_BQWEIWANG_205_1               = 1,  // -205-2013
        VSB_BQWEIWANG_306_1               = 2   // -306-2014,2013,2011
}VSB_BQWEIWANG_CLASS;


//Ʒ
typedef enum _VSB_SMA_CLASS
{
    VSB_SMA_OTHER                     = 0,        // 
        VSB_SMA_HAIYU_1                   = 1,        // --2007,2005,2004
        VSB_SMA_HAIYU_2                   = 2,        // --2007MB
        VSB_SMA_HAISHANG_1                = 3,        // --2008,2005
        VSB_SMA_HAIJING_1                 = 5,        // --2010,2009
        VSB_SMA_HAIXUN_1                  = 4,        // -Ѹ-2005,2004쭷
        VSB_SMA_HAIXUN_2                  = 6,        // -Ѹ-2007,2006
}VSB_SMA_CLASS;

//Ʒ
typedef enum _VSB_XINGMA_CLASS
{
    VSB_XINGMA_OTHER                  = 0,        // 
        VSB_XINGMA_XINGKAIMA_1            = 1         // -ǿ-ǣ1,ػ1
}VSB_XINGMA_CLASS;

//˫Ʒ
typedef enum _VSB_SHUANGHUAN_CLASS
{
    VSB_SHUANGHUAN_OTHER              = 0,        // 
        VSB_SHUANGHUAN_SCEO_1             = 1,        // ˫-SCEO-2011,2009,2006,2005
}VSB_SHUANGHUAN_CLASS;

//Ʒ
typedef enum _VSB_JEEP_CLASS
{
    VSB_JEEP_OTHER                    = 0,       // 
        VSB_JEEP_DAQIENUOJI_1             = 1,       // -ŵ()-2014,2013,2012,2011
        VSB_JEEP_DAQIENUOJI_2             = 2,       // -ŵ()-2014
        VSB_JEEP_ZHINANZHE_1              = 3,       // -ָ-2010,2007
        VSB_JEEP_ZHINANZHE_2              = 4,       // -ָ-2014,2013,2012,2011
        VSB_JEEP_MUMAREN_1                = 5,       // --2012ʹٻ,2011
        VSB_JEEP_MUMAREN_2                = 6,       // --2014,2013,2012,2011,2010,2009,2008
        VSB_JEEP_ZIYOUKE                  = 7,       // -ɿ-2014,2013,2012,2011
}VSB_JEEP_CLASS;

//Ʒ
typedef enum _VSB_VENUCIA_CLASS
{
    VSB_VENUCIA_OTHER                 = 0,       // 
        VSB_VENUCIA_D50_1                 = 1        // -D50-2014,2013,2012
}VSB_VENUCIA_CLASS;

//Ʒ
typedef enum _VSB_HAFEI_CLASS
{
    VSB_HAFEI_OTHER                   = 0,      // 
        VSB_HAFEI_XINMINYI_1              = 1,      // --2010
        VSB_HAFEI_XINMINYI_2              = 2,      // --2012
        VSB_HAFEI_MINYI_1                 = 3,      // --2006
        VSB_HAFEI_MINYI_2                 = 4,      // --2008
        VSB_HAFEI_SAIBAO_1                = 5,      // --2012
        VSB_HAFEI_SAIMA_1                 = 6,      // --2002
        VSB_HAFEI_SAIMA_2                 = 7,      // --2004,2003
        VSB_HAFEI_SAIMA_3                 = 8,      // --2009
        VSB_HAFEI_LUBAO_1                 = 9,      // -·-2004
        VSB_HAFEI_LUBAO_2                 = 10,      // -·-2008,2007
        VSB_HAFEI_LUBAO_3                 = 11,      // -·-2012
        VSB_HAFEI_LUZUNXIAOBAWANG_1       = 12,      // -·С-2011,2010
        VSB_HAFEI_RUIYI_1                 = 13,      // --2009
        VSB_HAFEI_JUNYI_1                 = 14       // --2012,2010
}VSB_HAFEI_CLASS;

//ƿŷƷ
typedef enum _VSB_TKING_CLASS
{
    VSB_TKING_OTHER                   = 0,      // 
        VSB_TKING_OUGUAN_1                = 1,      // ƿŷ-ŷ-2011
        VSB_TKING_OUGUAN_2                = 2,      // ƿŷ-ŷ-ῨB
        VSB_TKING_OUTENG_1                = 3,      // ƿŷ-ŷ-ῨA
        VSB_TKING_FUXING_1                = 4,      // ƿŷ--2006
        VSB_TKING_QINGKAWANG_1            = 5,      // ƿŷ-Ῠ-Ῠ
        VSB_TKING_AFANDA_1                = 6,      // ƿŷ--ؿ
        VSB_TKING_JUNQI_1                 = 7       // ƿŷ--ؿA
}VSB_TKING_CLASS;

//Ʒ
typedef enum _VSB_DAEWOO_CLASS
{
    VSB_DAEWOO_OTHER                  = 0,    // 
        VBR_DAEWOO_6960H3_1               = 1     // -6960H3-A
}VSB_DAEWOO_CLASS;

//Ʒ
typedef enum _VSB_DAYUN_CLASS
{
    VSB_DAYUN_OTHER                   = 0,     // 
        VBR_DAYUN_ZHONGKA_1               = 1      // -ؿ-A
}VSB_DAYUN_CLASS;

//Ʒ
typedef enum _VSB_BESTURN_CLASS
{
    VSB_BESTURN_OTHER                 = 0,   // 
        VSB_BESTURN_B70_1                 = 1,    // -B70-2009,2007,2006
        VSB_BESTURN_B70_2                 = 2,    // -B70-2011
        VSB_BESTURN_B70_3                 = 3,    // -B70-2011Ӣ,2010
        VSB_BESTURN_B70_4                 = 4,    // -B70-2012
        VSB_BESTURN_B90_1                 = 5,    // -B90-2012
        VSB_BESTURN_AOXING_1              = 6       // һ--2004
}VSB_BESTURN_CLASS;

//Ʒ
typedef enum _VSB_WEILIN_CLASS
{
    VSB_WEILIN_OTHER                 = 0,      // 
        VSB_WEILIN_H3_1                   = 1,     // -H3-2011
        VSB_WEILIN_V5_1                   = 2,     // -V5-2012,2009
        VSB_WEILIN_X5_1                   = 3      // -X5-2012,2011,2010
}VSB_WEILIN_CLASS;

//ͨƷ
typedef enum _VSB_YUTONG_CLASS
{
    VSB_YUTONG_OTHER                  = 0,     // 
        VSB_YUTONG_8XI_1                  = 1,     // ͨ-8ϵ-2012,2005
        VSB_YUTONG_KECHE_1                = 2,     // ͨ-ͳ10-2013,2010
        VSB_YUTONG_KECHE_3                = 3,     // ͨ-ͳ2-A
        VSB_YUTONG_KECHE_4                = 4,     // ͨ-ͳ8-2004
        VSB_YUTONG_KECHE_5                = 5,     // ͨ-ͳ9-2014
        VSB_YUTONG_KECHE_2                = 6      // ͨ-ͳ12-A
}VSB_YUTONG_CLASS;

//Ʒ
typedef enum _VSB_ANKAI_CLASS
{
    VSB_ANKAI_OTHER                   = 0,      // 
        VSB_ANKAI_KECHE_1                 = 1,      // -ͳ1-A
        VSB_ANKAI_KECHE_2                 = 2       // -ͳ3-A
}VSB_ANKAI_CLASS;

//Ʒ
typedef enum _VSB_BAOJUN_CLASS
{
    VSB_BAOJUN_OTHER            = 0,   // 
        VSB_BAOJUN_630_1                  = 1      // -630-2014,2013,2012,2011
}VSB_BAOJUN_CLASS;

//Ʒ
typedef enum _VSB_BINLI_CLASS
{
    VSB_BINLI_OTHER                   = 0,     // 
        VSB_BINLI_OULU_1                  = 1      // -ŷ½-2009,2008
}VSB_BINLI_CLASS;

//Ʒ
typedef enum _VSB_TRUMPCHE_CLASS
{
    VSB_TRUMPCHE_OTHER                = 0,   // 
        VSB_TRUMPCHE_GA5_1                = 1,   // -GA5-2012,2011
        VSB_TRUMPCHE_GA5_2                = 3,   // -GA5-2013,2012ԶӢ
        VSB_TRUMPCHE_GS5_1                = 2    // -GS5-2014,2013,2012
}VSB_TRUMPCHE_CLASS;

// Ʒ
typedef enum _VSB_GONOW_CLASS
{
    VSB_GONOW_OTHER                   = 0,   // 
        VSB_GONOW_G3_1                    = 1,      // -G3-2011
        VSB_GONOW_G5_1                    = 2,      // -G5-2012,2011
        VSB_GONOW_SHUAIJIAN_1             = 4,      // -˧-2012,2009
        VSB_GONOW_XINGWANGM1_1            = 3,      // -M1-2012
        VSB_GONOW_CAIYUN500_1             = 5      // -500-2010
}VSB_GONOW_CLASS;

//Ʒ
typedef enum _VSB_ISUZU_CLASS
{
    VSB_ISUZU_OTHER                   = 0,   // 
        VSB_ISUZU_ZHONGXINGSHANGYONG_1    = 1,      // -ó-2011
        VSB_ISUZU_WUSHILINGPIKA_1         = 2,      // -ʮƤ-2009
        VSB_ISUZU_WUSHILINGPIKA_2         = 3,      // -ʮƤ-2014,2009
        VSB_ISUZU_JINGJIZHE_1             = 4      // --2004,2002
}VSB_ISUZU_CLASS;


//Ʒ
typedef enum _VSB_KARRY_CLASS
{
    VSB_KARRY_OTHER                   = 0,   // 
        VSB_KARRY_YOU_2                   = 1,      // --2013,2012
        VSB_KARRY_YOUJIN_1                = 2,      // -ž-2012,2011,2010
        VSB_KARRY_YOUSHENG_1              = 3,      // -ʤ-2010
        VSB_KARRY_YOUSHENG_2              = 4,      // -ʤ-2012,2011
        VSB_KARRY_YOUYA                   = 5,      // --2012,2011,2007
        VSB_KARRY_YOU_1                   = 6      // --2011,2010,2009
}VSB_KARRY_CLASS;

//ݱƷ
typedef enum _VSB_GAGUAR_CLASS
{
    VSB_GAGUAR_OTHER                  = 0,   // 
        VSB_GAGUAR_XF_1                   = 1,     // ݱ-XF-2014,2013
        VSB_GAGUAR_XJ_1                   = 2     // ݱ-XJ-2014,2013,2012,2011,2010
}VSB_GAGUAR_CLASS;

//˹³Ʒ
typedef enum _VSB_SUBARU_CLASS
{
    VSB_SUBARU_OTHER                  = 0,   // 
        VSB_SUBARU_AOHU_1                 = 1,     // ˹³--2012,2011,2010
        VSB_SUBARU_LISHI_1                = 2,     // ˹³-ʨγ-2008,2006
        VSB_SUBARU_LISHI_2                = 3,     // ˹³-ʨγ-2011,2010
        VSB_SUBARU_XV_1                   = 4,     // ˹³-˹³XV-2014,2012
        VSB_SUBARU_SENLINREN_1            = 5,     // ˹³-ɭ-2007,2006
        VSB_SUBARU_SENLINREN_2            = 6     // ˹³-ɭ-2012,2011,2010,2009,2008
}VSB_SUBARU_CLASS;

//ʱƷ
typedef enum _VSB_ERA_CLASS
{
    VSB_ERA_OTHER                     = 0,   // 
        VSB_ERA_XIAOKA_1                  = 1,        // ʱ-С֮-С֮1,2,Q2
        VSB_ERA_XIAOKA_3                  = 2,        // ʱ-С֮-С֮5
        VSB_ERA_XIAOKA_4                  = 3,        // ʱ-С֮-
        VSB_ERA_KANGRUI_1                 = 4,        // ʱ--H1
        VSB_ERA_KANGRUI_2                 = 5,        // ʱ--H3
        VSB_ERA_KANGRUI_3                 = 6,        // ʱ--K1,KQ1
        VSB_ERA_RUIWO_1                   = 7,        // ʱ--RC1
        VSB_ERA_RUIWO_2                   = 8,        // ʱ--RC2
        VSB_ERA_RUIWO_3                   = 9,        // ʱ--IIῨA
        VSB_ERA_JINGANG                   = 10,        // ʱ--568
        VSB_ERA_LINGHANG_1                = 11,        // ʱ-캽-캽2
        VSB_ERA_LINGHANG_2                = 12,        // ʱ-캽-캽3
        VSB_ERA_YULING_1                  = 13,        // ʱ-Ԧ-ԦV1
        VSB_ERA_YULING_2                  = 14,        // ʱ-Ԧ-ԦV5,VQ5
        VSB_ERA_YULING_3                  = 15,        // ʱ-Ԧ-ԦVQ1,VQ2
        VSB_ERA_YULING_4                  = 17,        // ʱ-Ԧ-
        VSB_ERA_XIAOKA_2                  = 17,        // ʱ-С֮-С֮3
}VSB_ERA_CLASS;

//Ʒ
typedef enum _VSB_CHANGHE_CLASS
{
    VSB_CHANGHE_OTHER           = 0,  // 
        VSB_CHANGHE_CH6321_1        = 1,  // -CH6321-2000
        VSB_CHANGHE_DANSHUANGPAI_1  = 2,  // -µ˫-1999
        VSB_CHANGHE_AIDIER_1        = 3,  // -϶-2004
        VSB_CHANGHE_AIDIER_2        = 4,  // -϶-2007,2006
        VSB_CHANGHE_FURUIDA_1       = 5   // --2014,2013,2011,2009
}VSB_CHANGHE_CLASS;

//ŷƷ
typedef enum _VSB_OPEL_CLASS
{
    VSB_OPEL_OTHER              = 0,    // 
        VSB_OPEL_YATE_1             = 1     // ŷ--2010GTCȫ絲,2007,2006
}VSB_OPEL_CLASS;

//ԴƷ
typedef enum _VSB_JONWAY_CLASS
{
    VSB_JONWAY_OTHER            = 0,   // 
        VSB_JONWAY_A380_1           = 1    // Դ-A380-2010,2009,2008
}VSB_JONWAY_CLASS;

//Ʒ
typedef enum _VSB_JIANGNAN_CLASS
{
    VSB_JIANGNAN_OTHER          = 0,   // 
        VSB_JIANGNAN_TT_1           = 1    // -TT-2011,2010,2004
}VSB_JIANGNAN_CLASS;

//ȫӥƷ
typedef enum _VSB_GLEAGLE_CLASS
{
    VSB_GLEAGLE_OTHER                      = 0,   // 
        VSB_GLEAGLE_EAGLE_GC7_1                = 1,   // ȫӥ-GC7-2013,2012
        VSB_GLEAGLE_EAGLE_GX2_1                = 2,   // ȫӥ-GX2-2012,2011
        VSB_GLEAGLE_EAGLE_GX7_1                = 3,   // ȫӥ-GX7-2013,2012
        VSB_GLEAGLE_EAGLE_PANDA_1              = 4,   // ȫӥ-è-2013,2011,2010,2009
        VSB_GLEAGLE_EAGLE_ZIYOUJIAN_1          = 5,   // ȫӥ-ɽ-2009±׼,2007
        VSB_GLEAGLE_EAGLE_ZIYOUJIAN_2          = 6,   // ȫӥ-ɽ-2010,2009,2008,2006,2005
        VSB_GLEAGLE_EAGLE_ZIYOUJIAN_3          = 7,   // ȫӥ-ɽ-2012,2011
        VSB_GLEAGLE_EAGLE_YUANJING_1           = 8,   // ȫӥ-Զ-2011,2010,2009,2008,2006
        VSB_GLEAGLE_EAGLE_YUANJING_2           = 9,   // ȫӥ-Զ-2013,2012
}VSB_GLEAGLE_CLASS;

//ۺƷ
typedef enum _VSB_EMGRAND_CLASS
{
    VSB_EMGRAND_OTHER                      = 0,   // 
        VSB_EMGRAND_EC7_2                      = 1,   // ۺ-EC7-2013
        VSB_EMGRAND_EC7_3                      = 2,   // ۺ-EC7-RV
        VSB_EMGRAND_EC8_1                      = 3,   // ۺ-EC8-2013,2011,2010
        VSB_EMGRAND_EC7_1                      = 4    // ۺ-EC7-2012,2010,2009
}VSB_EMGRAND_CLASS;


//ӢƷ
typedef enum _VSB_ENGLON_CLASS
{
    VSB_ENGLON_OTHER                       = 0,    // 
        VSB_ENGLON_SC3_1                       = 1,    // Ӣ-SC3-2012
        VSB_ENGLON_SC5_1                       = 2,    // Ӣ-SC5-RV-2012
        VSB_ENGLON_SC6_1                       = 3,    // Ӣ-SC6-2012
        VSB_ENGLON_SC7_1                       = 4,    // Ӣ-SC7-2013,2012,2011,2010
        VSB_ENGLON_SX7_1                       = 5,    // Ӣ-SX7-2014,2013
        VSB_ENGLON_JINGANG_1                   = 6,    // Ӣ--2010,2007,2006
        VSB_ENGLON_JINYING_1                   = 7     // Ӣ-ӥ-2011,2010,2008
}VSB_ENGLON_CLASS;


//-Ʒ
typedef enum _VSB_JAC_CLASS
{
    VSB_JAC_OTHER               = 0,      // 
        VSB_JAC_TONGYUE_1           = 1,      // -ͬ-2012,2010,2008
        VSB_JAC_HEYUE_1             = 2,      // --2012,2011,2010
        VSB_JAC_HEYUEA30_2          = 3,      // -A30-2013
        VSB_JAC_HEYUERS_3           = 4,      // -RS-2012,2011
        VSB_JAC_HAOYUN_1            = 5,      // --Ῠ1
        VSB_JAC_WEILING_2           = 6,      // --ŰῨ
        VSB_JAC_WEILING_3           = 7,      // --ػ
        VSB_JAC_WEILING_4           = 8,      // --Ῠ
        VSB_JAC_KECHE_1             = 9,      // -ͳ-A
        VSB_JAC_BINYUE_1            = 10,      // --2010,2008
        VSB_JAC_SHUAILING_2         = 11,      // -˧-Ῠ
        VSB_JAC_KANGLING_1          = 12,      // --Ῠ1
        VSB_JAC_KANGLING_2          = 13,      // --Ῠ2
        VSB_JAC_YUEYUE_1            = 14,      // --2013,2012,2011,2010
        VSB_JAC_XINGRUI_1           = 15,      // --2012,2011
        VSB_JAC_GEERFA_H_1          = 16,      // -H-ػ
        VSB_JAC_GEERFA_K_2          = 17,      // -K-ؿ1
        VSB_JAC_GEERFA_K_3          = 18,      // -K-ؿ2
        VSB_JAC_GEERFA_M_4          = 19,      // -M-ػ
        VSB_JAC_RUIFENG_1           = 20,      // --2011,2009,2007ֶ
        VSB_JAC_RUIFENG_2           = 21,      // --2013,2012,2011,2010,2007,2005
        VSB_JAC_RUIFENG_3           = 22,      // -M5-2012,2011
        VSB_JAC_RUIFENG_4           = 23,      // -S5-2013
        VSB_JAC_RUIYING_1           = 24,      // -ӥ-2009,2007
        VSB_JAC_RUIYING_2           = 25,      // -ӥ-2013,2012,2011
        VSB_JAC_JUNLING_2           = 26,      // --խ,
        VSB_JAC_WEILING_1           = 27,      // --ʽῨ
        VSB_JAC_SHUAILING_1         = 28,      // -˧-ʮ
        VSB_JAC_RUILING_1           = 29,      // --2012
        VSB_JAC_JUNLING_1           = 30      // --콢
}VSB_JAC_CLASS;


//Ʒ
typedef enum _VSB_JMC_CLASS
{
    VSB_JMC_OTHER               = 0,      // 
        VSB_JMC_KAIYUN_1            = 1,      // --102,109Ῠ
        VSB_JMC_KAIYUN_2            = 2,      // --95Ῠ
        VSB_JMC_YUHU_1              = 3,      // --2012
        VSB_JMC_BAODIAN_1           = 4,      // --2007
        VSB_JMC_BAODIAN_2           = 5,      // --2009׼,2008
        VSB_JMC_BAODIAN_3           = 6,      // --2014,2012,2009
        VSB_JMC_BAOWEI_1            = 7,      // --2005
        VSB_JMC_BAOWEI_2            = 8,      // --2009
        VSB_JMC_QUANSHUN_1          = 9,      // -ȫ˳-2010,2008
        VSB_JMC_QUANSHUN_2          = 10,      // -ȫ˳-2006
        VSB_JMC_QUANSHUN_3          = 11,      // -ȫ˳-2013,2011,2010
        VSB_JMC_SHUNDA_1            = 12,      // -˳-2004,2003
        VSB_JMC_SHUNDA_2            = 13,      // -˳-2011,2010,2008
        VSB_JMC_YUSHENG_1           = 14,      // -Ԧʤ-2013
        VSB_JMC_YUSHENG_2           = 15       // -Ԧʤ-2013ֶװ,2012,2011
}VSB_JMC_CLASS;

// ֶƷ
typedef enum _VSB_VOLVO_CLASS
{
    VSB_VOLVO_OTHER             = 0,   // 
        VSB_VOLVO_C30_1             = 1,    // ֶ-C30-2013,2012,2011,2010
        VSB_VOLVO_S40_1             = 2,    // ֶ-S40-2012,2011,2010,2009,2008,2007
        VSB_VOLVO_S60_1             = 3,    // ֶ-S60-2003
        VSB_VOLVO_S60_2             = 4,    // ֶ-S60-2013,2012,2011
        VSB_VOLVO_S80L_1            = 5,    // ֶ-S80L-2012,2011,2010,2009
        VSB_VOLVO_XC60_1            = 6,    // ֶ-XC60-2013,2012,2011,2010,2009
        VSB_VOLVO_XC90_1            = 7     // ֶ-XC90-2013,2012,2011,2008
}VSB_VOLVO_CLASS;

// Ʒ
typedef enum _VSB_HIGER_CLASS
{
    VSB_HIGER_OTHER             = 0,   // 
        VSB_HIGER_H8_1              = 1,    // -H8-A
        VSB_HIGER_H92_1             = 2,    // -H92-A
        VSB_HIGER_V7_1              = 3,    // -V7,V8-2006
        VSB_HIGER_KECHE_1           = 4,    // -ͳ5-A
        VSB_HIGER_LONGWEI_1         = 5,    // --2012,2011
        VSB_HIGER_H7V_1             = 6     // -H7V-2010
}VSB_HIGER_CLASS;

// Ʒ
typedef enum _VSB_RUILIN_CLASS
{
    VSB_RUILIN_OTHER            = 0,   // 
        VSB_RUILIN_G3_1             = 1,   // -G3-2012,2010
        VSB_RUILIN_G5_1             = 2,   // -G5-2012,2011,2010
        VSB_RUILIN_M1_1             = 3,   // -M1-2013,2011,2010,2009
        VSB_RUILIN_X1_1             = 4,   // -X1-2012A,2011,2010
        VSB_RUILIN_X1_2             = 5    // -X1-2012B
}VSB_RUILIN_CLASS;

// Ʒ
typedef enum _VSB_SHENLONG_CLASS
{
    VSB_SHENLON_OTHER                  = 0,         // 
        VSB_SHENLONG_KECHE_1               = 1          //ͳ-ͳ4-A
}VSB_SHENLONG_CLASS;

// Ʒ
typedef enum _VSB_FOTON_CLASS
{
    VSB_FOTON_OTHER                    = 0,            // 
        VSB_FOTON_AOLING_1                 = 1,            // --п
        VSB_FOTON_AOLING_2                 = 2,            // --ʽ
        VSB_FOTON_AOLING_3                 = 3,            // --TX,CTX
        VSB_FOTON_OUMAN_1                  = 4,            // -ŷ-GTL6ϵB
        VSB_FOTON_OUMAN_2                  = 5,            // -ŷ-TX6ϵ,9ϵ
        VSB_FOTON_OUMAN_3                  = 6,            // -ŷ-ŷؿ1
        VSB_FOTON_OUMAN_4                  = 7,            // -ŷ-ʨ6ϵ,9ϵ
        VSB_FOTON_OUHUI_1                  = 8,            // -ŷԿͳ-D
        VSB_FOTON_OUMAKE_1                 = 9,            // -ŷ-3ϵ
        VSB_FOTON_OUMAKE_2                 = 10,            // -ŷ-5ϵ
        VSB_FOTON_SAPU_1                   = 11,            // --2011
        VSB_FOTON_SAPU_3                   = 12,            // --2011͹
        VSB_FOTON_MENGPAIKE_1              = 13,            // -ɿ-2013
        VSB_FOTON_MIDI_1                   = 14,            // -Ե-2011,2009
        VSB_FOTON_FENGJING_1               = 15,            // -羰ϵ-2012,2011,2009
        VSB_FOTON_SAPU_2                  = 16            // --2011Z7
}VSB_FOTON_CLASS;

//Ʒ
typedef enum _VSB_FODAY_CLASS
{
    VSB_FODAY_OTHER                    = 0,            // 
        VSB_FODAY_CHAOREN_1                = 1,            // -СƤ-2009,2006
        VSB_FODAY_CHAOREN_2                = 2,            // -СƤ-2011
        VSB_FODAY_TANSUOZHE_1              = 3,            // -̽6-2013,2011,2010
        VSB_FODAY_TANSUOZHE_2              = 4,            // -̽ߢ-2011,2010,2009
        VSB_FODAY_TANSUOZHE_3              = 5,            // -̽ߢ-2011,2004
        VSB_FODAY_XIONGSHI_1               = 6             // -ʨF16Ƥ-2012
}VSB_FODAY_CLASS;

// Ʒ
typedef enum _VSB_HONGQI_CLASS
{
    VSB_HONGQI_OTHER                   = 0,         // 
        VSB_HONGQI_MINGSHI_1               = 1           // --2007,2003,2001,2000,1999
}VSB_HONGQI_CLASS;


// ǽ Ʒ
typedef enum _VSB_LUXGEN_CLASS
{
    VSB_LUXGEN_OTHER                   = 0,         // 
        VSB_LUXGEN_DASEVEN_1               = 1          // ǽ-7-SUV
}VSB_LUXGEN_CLASS;

// Ʒ
typedef enum _VSB_XIALI_CLASS
{
    VSB_XIALI_OTHER                    = 0,         // 
        VSB_XIALI_QIBING_1                 = 1,         // ()--2010
}VSB_XIALI_CLASS;

// ۿͳƷ
typedef enum _VSB_SHUCHI_CLASS
{
    VSB_SHUCHI_OTHER                   = 0,         // 
        VSB_SHUCHI_A_1                     = 1          // ۿͳ-ͳ-A
}VSB_SHUCHI_CLASS;

//ӢƷ
typedef enum _VSB_INFINITI_CLASS
{
    VSB_INFINITI_OTHER                 = 0,         // 
        VSB_INFINITI_EX_1                  = 1,         // Ӣ-EX-2013,2011,2010,2009,2008
        VSB_INFINITI_FX_1                  = 2,         // Ӣ-FX-2007
        VSB_INFINITI_FX_2                  = 3,         // Ӣ-FX-2011,2010,2009
        VSB_INFINITI_FX_3                  = 4,         // Ӣ-FX-2013,2012FX35
        VSB_INFINITI_G_1                   = 5,         // Ӣ-G-2013,2010
        VSB_INFINITI_JX_1                  = 6          // Ӣ-JX-2013,2011
}VSB_INFINITI_CLASS;


// Ʒ
typedef enum _VSB_LOTUS_CLASS
{
    VSB_LOTUS_OTHER                    = 0,            // 
        VSB_LOTUS_L3_1                     = 1,            // -L3-2010,2009
        VSB_LOTUS_L3_2                     = 2             // -L5-2012,2011
}VSB_LOTUS_CLASS;

//Ʒ
typedef enum _VSB_FIAT_CLASS
{
    VSB_FIAT_OTHER                     = 0,            // 
        VSB_FIAT_FEIYUE_1                  = 1             // -Ծ-2014,2013,2012
}VSB_FIAT_CLASS;

//کƷ
typedef enum _VSB_OGA_CLASS
{
    VSB_OGA_OTHER                      = 0,              // 
        VSB_OGA_MDX_1                      = 1,              // ک-MDX-2010
        VSB_OGA_MDX_2                      = 2               // ک-MDX-2011
}VSB_OGA_CLASS;



// ԾƷ
typedef enum _VSB_YUEJIN_CLASS
{
    VSB_YUEJIN_OTHER                   = 0,           // 
        VSB_YUEJIN_SHUAIHU_1               = 1,           // Ծ-˧-H100,H300
        VSB_YUEJIN_CAISHEN_1               = 2,           // Ծ--S100
        VSB_YUEJIN_CAISHEN_2               = 3,           // Ծ--S300
        VSB_YUEJIN_CAISHEN_3               = 4            // Ծ--S500
}VSB_YUEJIN_CLASS;

//ҰƷ
typedef enum _VSB_YEMA_CLASS
{
    VSB_YEMA_OTHER                     = 0,        // 
        VSB_YEMA_F99_1                     = 1            // Ұ-F99-2012,2011,2010,2009 
}VSB_YEMA_CLASS;

//Ʒ
typedef enum _VSB_SZKINGLONG_CLASS
{
    VSB_SZKINGLONG_OTHER               = 0,        // 
        VSB_SZKINGLONG_BUS11_1             = 1,       // -ͳ11-A
        VSB_SZKINGLONG_BUS12_1             = 2,       // -ͳ12-A
        VSB_SZKINGLONG_BUS13_1             = 3,       // -ͳ13-A
        VSB_SZKINGLONG_BUS14_1             = 4,       // -ͳ14-A
        VSB_SZKINGLONG_BUS16_1             = 5,       // -ͳ16-A
        VSB_SZKINGLONG_BUS18_1             = 6,       // -ͳ18-A
        VSB_SZKINGLONG_BUS1_1              = 7,       // -ͳ1-A
        VSB_SZKINGLONG_BUS20_1             = 8,       // -ͳ20-A
        VSB_SZKINGLONG_BUS2_1              = 9,       // -ͳ2-A
        VSB_SZKINGLONG_BUS5_1              = 10,       // -ͳ5-A
        VSB_SZKINGLONG_BUS6_1              = 11,       // -ͳ6-A
        VSB_SZKINGLONG_BUS9_1              = 12,       // -ͳ9-A
        VSB_SZKINGLONG_BUS10_1             = 13,       // -ͳ10-A
        VSB_SZKINGLONG_BUS15_1             = 14        // -ͳ15-A
}VSB_SZKINGLONG_CLASS;

//ԱƷ
typedef enum _VSB_CHANGFENG_CLASS
{
    VSB_CHANGFENG_OTHER                = 0,        // 
        VSB_CHANGFENG_CS7_1                = 1,        // Ա-CS7-2009
        VSB_CHANGFENG_QIBING_1             = 2,        // Ա--2010,2009
        VSB_CHANGFENG_LIEBAO_1             = 3,        // Ա-ԱCS6-2010,2008
        VSB_CHANGFENG_FULING_1             = 4,        // Ա-Ƥ-A
        VSB_CHANGFENG_FEIYANG_1            = 5,        // Ա-Ƥ-2010,2009,2005
        VSB_CHANGFENG_FEITENG_1            = 6,        // Ա--2010,2009,2006
        VSB_CHANGFENG_BLACKJINGANG_1       = 7,        // Ա-ڽ-2013,2010,2009,2008,2006
}VSB_CHANGFENG_CLASS;

//½Ʒ
typedef enum _VSB_LUFENG_CLASS
{
    VSB_LUFENG_OTHER                   = 0,           // 
        VSB_LUFENG_X6_1                    = 1,           // ½-X6-2005
        VSB_LUFENG_X6_2                    = 2,           // ½-X6-2006
        VSB_LUFENG_X6_3                    = 3,           // ½-X6-2011,2010,2008,2007
        VSB_LUFENG_LUFENGX5_1              = 4,           // ½-½X5-2013
        VSB_LUFENG_LUFENGX8_1              = 5,           // ½-½X8-2013,2012,2011,2009
        VSB_LUFENG_LUFENGX8_2              = 6,           // ½-½X8-2014,2012̽
        VSB_LUFENG_FENGHUA_1               = 7,           // ½-绪-2008,2007
        VSB_LUFENG_X6_4                    = 8,           // ½-X6-2011
        VSB_LUFENG_FENGSHANG_1             = 9            // ½--2011,2006 
}VSB_LUFENG_CLASS;

//ؿƷ
typedef enum _VSB_SHANQI_CLASS
{
    VSB_SHANQI_OTHER                   = 0,           // 
        VSB_SHANQI_AOLONG_1                = 1,           // ؿ--ؿA
        VSB_SHANQI_AOLONG_2                = 2,           // ؿ--ؿB
        VSB_SHANQI_DELONG_1                = 3,           // ؿ-F2000-4X2ǣ
        VSB_SHANQI_DELONG_2                = 4,           // ؿ-F3000-B
        VSB_SHANQI_DELONG_3                = 5,           // ؿ-M3000-ؿ 
}VSB_SHANQI_CLASS;


//ҰƷ
typedef enum _VSB_RENAULT_CLASS
{
    VSB_RENAULT_OTHER                  = 0,          // 
        VSB_RENAULT_MEIGANNA_1             = 1,          // ŵ-÷-2006
        VSB_RENAULT_KELEIAO_1              = 2,          // ŵ-װ-2010,2009
        VSB_RENAULT_KELEIAO_2              = 3,          // ŵ-װ-2013,2012
        VSB_RENAULT_SCENE_1                = 4,          // ŵ-羰-2007
        VSB_RENAULT_FENGLANG_1             = 5,          // ŵ--2011
        VSB_RENAULT_TAFEIKE_1              = 6           // ŵ-ƿ-2004    
}VSB_RENAULT_CLASS;

//ƺƷ
typedef enum _VSB_HUANGHAI_CLASS
{
    VSB_HUANGHAI_OTHER                 = 0,         // 
        VSB_HUANGHAI_DACAISHEN_1           = 1,         // ƺ--2013,2012
        VSB_HUANGHAI_DACAISHEN_2           = 2,         // ƺ--2013,2012,2011,2010,2009Ͱ
        VSB_HUANGHAI_BUS4_1                = 3,         // ƺ-ͳ4-2012,2011
        VSB_HUANGHAI_CHALLENGER_1          = 4,         // ƺ-ս-2011,2010,2009,2008
        VSB_HUANGHAI_AOLONGCUV_1           = 5,         // ƺ-CUV-2010,2009
        VSB_HUANGHAI_AOJUN_1               = 6,         // ƺ--2009
        VSB_HUANGHAI_AOJUN_2               = 7,         // ƺ--2010,2009
        VSB_HUANGHAI_QISHENGV3_1           = 8,         // ƺ-ʤV3-2011
        VSB_HUANGHAI_LINGHANGZHE_1         = 9,         // ƺ-캽-2007,2005
        VSB_HUANGHAI_FENGCHI_1             = 10         // ƺ--A
}VSB_HUANGHAI_CLASS;

/********************ƷEnd*************************/

//Ϣ
typedef struct tagNET_DVR_VEHICLE_INFO_
{
    DWORD dwIndex;          //
    BYTE  byVehicleType;    // 0 ʾͣ1 ʾСͳ2 ʾͳ ,3ʾ˴ ,4ʾֳ 5ʾֳ(3.5Ver)
    BYTE  byColorDepth;        //ɫǳ
    BYTE  byColor;          //ɫ,οVCR_CLR_CLASS
    /*״쳣״̬
    0~״
    1~״
    2~״һֱĳһͬٶֵ
    3~״ͳΪ0
    4~״ͳݹ߹С
    */
    BYTE  byRadarState;
    WORD  wSpeed;           //λkm/h
    WORD  wLength;          //ǰһĳ  
                            /*Υͣ0-1-٣2-٣3-У4-,5-ѹ,6-7-·
                            8-ռǣ9-Υ10- 11-Υ12-·ͣ13-̵ͣ, 14-δ(Υ1357), 
    15-Υͣ16-Υµͷ,17-ռӦ,18-,19-,20-ѹ,21-δϵȫ,22-˴,23-*/
    BYTE  byIllegalType;
    BYTE  byVehicleLogoRecog; //οö VLR_VEHICLE_CLASS
    BYTE  byVehicleSubLogoRecog; //Ʒʶ𣻲οVSB_VOLKSWAGEN_CLASSö١
    BYTE  byVehicleModel; //Ʒ0-δ֪ο"Ʒ.xlsx"
    BYTE  byCustomInfo[16];  //ԶϢ
    WORD  wVehicleLogoRecog;  //Ʒƣο"Ʒ.xlsx" (ֶμbyVehicleLogoRecog);
    BYTE  byRes3[14];    
}NET_DVR_VEHICLE_INFO, *LPNET_DVR_VEHICLE_INFO;

//Ƽ
typedef struct tagNET_DVR_PLATE_RESULT
{
    DWORD   dwSize;            //ṹ
    BYTE    byResultType;    //0-Ƶʶ1ͼʶ 2 10Mʱ·
    BYTE    byChanIndex;    //ͨ
    WORD    wAlarmRecordID;    //¼ID(ڲѯ¼񣬽byResultTypeΪ2ʱЧ)
    DWORD   dwRelativeTime;    //ʱ  
    BYTE    byAbsTime[32];    //ʱ,yyyymmddhhmmssxxx,e.g.20090810235959999룩
    DWORD   dwPicLen;        //ͼƬ(ͼ)
    DWORD    dwPicPlateLen;  //СͼƬ
    DWORD   dwVideoLen;        //¼ݳ
    BYTE    byTrafficLight;    //0-Ǻ̵ץģ1-̵ʱץģ2-ʱץ
    BYTE    byPicNum;       //ĵͼƬ
    BYTE    byDriveChan;    //
    BYTE     byVehicleType; //ͣοVTR_RESULT
    DWORD   dwBinPicLen;    //ƶֵͼ
    DWORD   dwCarPicLen;    //ԭͼ
    DWORD   dwFarCarPicLen; //Զͼ
    BYTE    *pBuffer3;      //ƶֵͼ
    BYTE    *pBuffer4;      //ԭͼ
    BYTE    *pBuffer5;      //Զͼ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE    byRelaLaneDirectionType;
    BYTE    byCarDirectionType; //ʻķ0ʾ£1ʾϣʵʳʻ֣
    BYTE    byRes3[6];   
    NET_DVR_PLATE_INFO  struPlateInfo;    //Ϣṹ
    NET_DVR_VEHICLE_INFO struVehicleInfo; //Ϣ
    BYTE    *pBuffer1;                   // ϴͼƬ(ͼ)ָָͼƬϢϴƵָָƵϢͼƬƵϢNULL(DVSͼ)
    BYTE    *pBuffer2;                  // ϴͼƬ(ͼ)ʱָͼƬָ루DVSƲͼ
}NET_DVR_PLATE_RESULT, *LPNET_DVR_PLATE_RESULT;
//ͼƬݺ¼ݣֻһ֣ͼƬΪͼƬ+СͼƬ

//ͼϢ        
typedef struct tagNET_DVR_IMAGEOVERLAYCFG
{
    DWORD        dwSize;
    BYTE        byOverlayInfo;//ʹܿأ0-ӣ1-
    BYTE        byOverlayMonitorInfo;//ǷӼϢ0-ӣ1-
    BYTE        byOverlayTime;//Ƿʱ䣬0-ӣ1-
    BYTE        byOverlaySpeed;//Ƿٶȣ0-ӣ1-
    BYTE        byOverlaySpeeding;//Ƿӳٱ0-ӣ1-
    BYTE        byOverlayLimitFlag;//Ƿٱ־0-ӣ1-
    BYTE        byOverlayPlate;//Ƿӳƺţ0-ӣ1-
    BYTE        byOverlayColor;//Ƿӳɫ0-ӣ1-
    BYTE        byOverlayLength;//Ƿӳ0-ӣ1-
    BYTE        byOverlayType;//Ƿӳͣ0-ӣ1-
    BYTE        byOverlayColorDepth;//Ƿӳɫǳ0-ӣ1-
    BYTE        byOverlayDriveChan;//Ƿӳ0-ӣ1-
    BYTE        byOverlayMilliSec; //ӺϢ 0-ӣ1-
    BYTE        byOverlayIllegalInfo; //ΥϢ 0-ӣ1-
    BYTE        byOverlayRedOnTime;  //Ӻʱ 0-ӣ1-
    BYTE        byFarAddPlateJpeg;      //ԶͼǷӳƽͼ,0-,1-
    BYTE        byNearAddPlateJpeg;      //ͼǷӳƽͼ,0-,1-
    BYTE        byRes1[3];    //
    BYTE        byMonitorInfo1[32];    //Ϣ1
    BYTE        byMonitorInfo2[44]; //Ϣ2
    BYTE        byRes2[52];    //
}NET_DVR_IMAGEOVERLAYCFG, *LPNET_DVR_IMAGEOVERLAYCFG;

//IOץĹ
typedef struct tagNET_DVR_SNAPCFG
{
    DWORD   dwSize;
    BYTE    byRelatedDriveWay;//IOĳ
    BYTE     bySnapTimes; //ȦץĴ0-ץģ0-ĴĿǰ5  
    WORD    wSnapWaitTime;  //ץĵȴʱ䣬λmsȡֵΧ[0,60000]
    WORD    wIntervalTime[MAX_INTERVAL_NUM];//ļʱ䣬ms
    DWORD   dwSnapVehicleNum; //ץĳš
    NET_DVR_JPEGPARA  struJpegPara;//ץͼƬ
    BYTE    byRes2[16];//ֽ
}NET_DVR_SNAPCFG, *LPNET_DVR_SNAPCFG;

typedef enum _ITC_MAINMODE_ABILITY_
{
    ITC_MODE_UNKNOW    = 0x0,   //
        ITC_POST_MODE  = 0x1,  //ģʽ
        ITC_EPOLICE_MODE      = 0x2,  //羯ģʽ
        ITC_POSTEPOLICE_MODE  = 0x4  //ʽ羯ģʽ
}ITC_MAINMODE_ABILITY;

typedef enum _ITC_RECOG_REGION_TYPE_
{
    ITC_REGION_RECT    = 0x0,   //
        ITC_REGION_POLYGON  = 0x1,  //
}ITC_RECOG_REGION_TYPE;

typedef struct tagNET_DVR_SNAP_ABILITY
{
    DWORD dwSize;
    BYTE  byIoInNum;//IO
    BYTE  byIoOutNum;//IO
    BYTE  bySingleSnapNum;//IO
    BYTE  byLightModeArrayNum;//̵ģʽ
    BYTE  byMeasureModeArrayNum;//ģʽ
    BYTE  byPlateEnable; //ʶ
    BYTE  byLensMode;//ͷģʽ0-CCD,1-CMOS
    BYTE  byPreTriggerSupport; //Ƿ֧ԭģʽ0-֧֣1-֧
    DWORD dwAbilityType; //ֵ֧ĴģʽλʾITC_MAINMODE_ABILITY
    BYTE  byIoSpeedGroup; //ֵ֧IO
    BYTE  byIoLightGroup; //ֵ֧IO̵
    BYTE  byRecogRegionType; //ʶֵ֧ͣITC_RECOG_REGION_TYPE
    BYTE  bySupport; //豸λʾ0-֧֣1-֧
    // bySupport&0x1ʾǷ֧չַ
    // bySupport&0x2ʾǷ֧չУʱýṹ
    // bySupport&0x4, ʾǷֶ֧()
    // bySupport&0x8, ʾǷ֧bonding(ݴ)
    // bySupport&0x10, ʾǷ֧Խ
    //2013-07-09 
    WORD wSupportMultiRadar;// 豸λʾ0-֧֣1-֧
    // wSupportMultiRadar&0x1ʾ RS485״ ֳ֧״ﴦ
    // wSupportMultiRadar&0x2ʾ Ȧ ֳ֧״ﴦ
    // wSupportMultiRadar&0x4ʾ п ֳ֧״ﴦ
    // wSupportMultiRadar&0x8ʾ Ƶ ֳ֧״ﴦ
    BYTE  byICRPresetNum;
    // ʾֵ֧ICRԤõ㣨˹ƬƫƵ㣩
    BYTE  byICRTimeSlot;//ʾֵ֧ICRʱ18
    BYTE  bySupportRS485Num;//ʾֵ֧RS485ڵ
    BYTE  byExpandRs485SupportSensor;// 豸λʾ0-֧֣1-֧
    // byExpandRs485SupportSensor &0x1ʾ羯ֳ֧
    // byExpandRs485SupportSensor &0x2ʾʽ羯ֳ֧
    BYTE  byExpandRs485SupportSignalLampDet;// 豸λʾ0-֧֣1-֧
    // byExpandRs485SupportSignalLampDet &0x1ʾ羯֧źŵƼ
    // byExpandRs485SupportSignalLampDet &0x2ʾʽ羯֧źŵƼ
    BYTE  byRelayNum;// ʾ̵ּ֧ĸ 2013-11-04
    BYTE  bySupport1; //豸λʾ0-֧֣1-֧
    // bySupport1&0x1ʾǷ֧ԶУʱϢ
    // bySupport1&0x2,  ʾǷ֧ƵŻ
    // bySupport1&0x4,  ʾǷ֧DDNS÷
    // bySupport1&0x8,  ʾǷֻ֧ȡ豸ǰģʽӿ
    // bySupport1&0x10, ʾǷֳ֧ 2014-03-03
    // bySupport1&0x20,  ʾǷ֧GPSģ
    // bySupport1&0x40,  ʾǷ֧NTPУʱַ֧
    // bySupport1&0x80,  ʾǷ֧tpsϴ
    BYTE  bySupport2; //豸λʾ0-֧֣1-֧
    // bySupport2&0x01,  ʾǷ֧Ϣ
    // bySupport2&0x02,  ʾͨͼINTER_PICCFG_V30Ƿ֧ƵʱòbyOSDMilliSecondEnable
    BYTE  bySupportWhiteBalance; //ƽĬ϶ֶ֧ƽ⡢Զƽ⡢Զƽ23ģʽ
    // bySupportWhiteBalance &0x01,  ʾǷ֧չģʽ
    // bySupportWhiteBalance &0x02,  ʾǷ֧Ȼģʽ
    // bySupportWhiteBalance &0x04,  ʾǷ֧ůģʽ
    // bySupportWhiteBalance &0x08,  ʾǷְ֧׳ģʽ
    BYTE  byRes[9];
} NET_DVR_SNAP_ABILITY, *LPNET_DVR_SNAP_ABILITY;

typedef struct tagNET_ITC_ICRTIMECFG
{
    NET_DVR_SCHEDTIME  struTime;
    BYTE   byAssociateRresetNo;//Ԥõ18 , 0
    BYTE   bySubSwitchMode;//1~죬2~ (Ԥõ0 ʱЧ)
    BYTE   byRes[10];
}NET_ITC_ICRTIMECFG, *LPNET_ITC_ICRTIMECFG;

typedef struct tagNET_ITC_ICR_TIMESWITCH_PARAM  //156
{
    NET_ITC_ICRTIMECFG  struAutoCtrlTime[MAX_TIMESEGMENT_V30];//Զлʱ (Զл ʱЧ ֧4飬Ԥ4)
    BYTE  byICRPreset[MAX_ICR_NUM]; //ʵЧ̬ʾ [0~100] ±ʾԤõ18 07 Ӧ
    BYTE  byRes[20];
}NET_ITC_ICR_TIMESWITCH_PARAM, *LPNET_ITC_ICR_TIMESWITCH_PARAM;

typedef struct tagNET_ITC_ICR_MANUALSWITCH_PARAM
{    
    BYTE  byICRPreset[MAX_ICR_NUM]; //ʵЧ̬ʾ [0~100]
    BYTE  bySubSwitchMode;//1~죬2~
    BYTE  byRes[147];
}NET_ITC_ICR_MANUALSWITCH_PARAM, *LPNET_ITC_ICR_MANUALSWITCH_PARAM;

typedef struct tagNET_ITC_ICR_AOTOSWITCH_PARAM
{
    BYTE  byICRPreset[MAX_ICR_NUM]; //ʵЧ̬ʾ [0~100] ±ʾԤõ18 07 Ӧ
    BYTE  byICRAutoSwitch; // ICRԶлֵѡ, ȡֵΧ[0 100]
    BYTE  byRes[147];
}NET_ITC_ICR_AOTOSWITCH_PARAM, *LPNET_ITC_ICR_AOTOSWITCH_PARAM;

//㷨Զ
typedef struct tagNET_ITC_ICR_ALGAOTOSWITCH_PARAM
{
    BYTE  byDetectThreshold;//ֵ,Χ[0,100],Ĭ 58
    BYTE  byAbBrightnessThreshold; //쳣ֵΧ[0,100]Ĭ12
    BYTE  byRes[154];
}NET_ITC_ICR_ALGAOTOSWITCH_PARAM, *LPNET_ITC_ICR_ALGAOTOSWITCH_PARAM;

typedef union tagNET_ITC_ICR_PARAM_UNION
{
    BYTE uLen[156];
    NET_ITC_ICR_AOTOSWITCH_PARAM struICRAutoSwitch;
    NET_ITC_ICR_MANUALSWITCH_PARAM struICRManualSwitch;
    NET_ITC_ICR_TIMESWITCH_PARAM struICRTimeSwitch;
    NET_ITC_ICR_ALGAOTOSWITCH_PARAM strICRAlgorithmAutoSwitch;
}NET_ITC_ICR_PARAM_UNION,*LPNET_ITC_ICR_PARAM_UNION;

typedef struct tagNET_ITC_ICRCFG
{
    DWORD dwSize;
    BYTE  bySwitchType;//1~Զл2~ֶл ,3~ʱл,4~㷨Զ 
    BYTE  byRes[3];
    NET_ITC_ICR_PARAM_UNION uICRParam;
}NET_ITC_ICRCFG, *LPNET_ITC_ICRCFG;

//2013-07-09 쳣
typedef struct
{    
    DWORD   dwHandleType; //쳣,쳣ʽ""
    /*0x00: Ӧ*/
    /*0x01: Ͼ*/
    /*0x02: */
    /*0x04: ϴ*/
    /*0x08: ̵*/
    /*0x10: JPRGץͼϴEmail*/
    /*0x20: ⱨ*/
    /*0x40: ӵͼ(ĿǰֻPCNVR֧)*/
    /*0x200: ץͼϴFTP*/  
    BYTE     byEnable; //0ã1
    BYTE    byRes;
    WORD    wDuration;//ʱ(λ/s)
    BYTE    byAlarmOutTriggered[MAX_ITC_EXCEPTIONOUT];//ͨ
    BYTE    byRes1[8];
} NET_ITC_HANDLEEXCEPTION, *LPNET_ITC_HANDLEEXCEPTION;

typedef struct
{
    DWORD dwSize;
    NET_ITC_HANDLEEXCEPTION struSnapExceptionType[MAX_EXCEPTIONNUM_V30]; //ÿԪضʾһ쳣0- Ӳ̳,1-߶,2-IP ַͻ, 3-쳣, 4-źŵƼ쳣
}NET_ITC_EXCEPTION,*LPNET_ITC_EXCEPTION;

typedef struct tagNET_DVR_TRIGCOORDINATE
{
    WORD wTopLeftX; /*ȦϽǺ꣨2ֽڣ*/
    WORD wTopLeftY; /*ȦϽ꣨2ֽڣ*/
    WORD wWdith; /*Ȧȣ2ֽڣ*/
    WORD wHeight; /*Ȧ߶ȣ2ֽڣ*/
} NET_DVR_TRIGCOORDINATE, *LPNET_DVR_TRIGCOORDINATE;

typedef enum _PROVINCE_CITY_IDX_
{
    ANHUI_PROVINCE             = 0,              //
        AOMEN_PROVINCE             = 1,              //
        BEIJING_PROVINCE           = 2,              //
        CHONGQING_PROVINCE         = 3,              //
        FUJIAN_PROVINCE            = 4,              //
        GANSU_PROVINCE             = 5,              //
        GUANGDONG_PROVINCE         = 6,              //㶫
        GUANGXI_PROVINCE           = 7,              //
        GUIZHOU_PROVINCE           = 8,              //
        HAINAN_PROVINCE            = 9,              //
        HEBEI_PROVINCE             = 10,             //ӱ
        HENAN_PROVINCE             = 11,             //
        HEILONGJIANG_PROVINCE      = 12,             //
        HUBEI_PROVINCE             = 13,             //
        HUNAN_PROVINCE             = 14,             //
        JILIN_PROVINCE             = 15,             //
        JIANGSU_PROVINCE           = 16,             //
        JIANGXI_PROVINCE           = 17,             //
        LIAONING_PROVINCE          = 18,             //
        NEIMENGGU_PROVINCE         = 19,             //ɹ
        NINGXIA_PROVINCE           = 20,             //
        QINGHAI_PROVINCE           = 21,             //ຣ
        SHANDONG_PROVINCE          = 22,             //ɽ
        SHANXI_JIN_PROVINCE        = 23,             //ɽ
        SHANXI_SHAN_PROVINCE       = 24,             //
        SHANGHAI_PROVINCE          = 25,             //Ϻ
        SICHUAN_PROVINCE           = 26,             //Ĵ
        TAIWAN_PROVINCE            = 27,             //̨
        TIANJIN_PROVINCE           = 28,             //
        XIZANG_PROVINCE            = 29,             //
        XIANGGANG_PROVINCE         = 30,             //
        XINJIANG_PROVINCE          = 31,             //½
        YUNNAN_PROVINCE            = 32,             //
        ZHEJIANG_PROVINCE          = 33              //㽭
}PROVINCE_CITY_IDX;

typedef struct tagNET_DVR_GEOGLOCATION
{
    int iRes[2]; /**/
    DWORD dwCity; /*УPROVINCE_CITY_IDX */
}NET_DVR_GEOGLOCATION, *LPNET_DVR_GEOGLOCATION;

//ģʽ
typedef enum _SCENE_MODE_
{
    UNKOWN_SCENE_MODE   = 0,            //δ֪ģʽ
        HIGHWAY_SCENE_MODE  = 1,            //ٳģʽ
        SUBURBAN_SCENE_MODE = 2,            //ģʽ()
        URBAN_SCENE_MODE    = 3,            //ģʽ
        TUNNEL_SCENE_MODE   = 4             //ģʽ()
}SCENE_MODE;

typedef struct tagNET_DVR_VTPARAM
{
    DWORD   dwSize;
    BYTE    byEnable;  /* ǷʹȦ0-ʹã1-ʹ*/
    BYTE    byIsDisplay; /* ǷʾȦ0-ʾ1-ʾ*/
    BYTE    byLoopPos; //䴥Ȧƫ0-ϣ1-
    BYTE    bySnapGain; /*ץ*/
    DWORD   dwSnapShutter; /*ץĿٶ*/
    NET_DVR_TRIGCOORDINATE struTrigCoordinate; //
    NET_DVR_TRIGCOORDINATE struRes[MAX_VL_NUM];
    BYTE    byTotalLaneNum;/*Ƶĳ1*/
    BYTE    byPolarLenType; /*ƫͣ0ƫ񾵣1ʩ͵ƫ񾵡*/
    BYTE    byDayAuxLightMode; /*츨ģʽ0޸1LED2*/
    BYTE    byLoopToCalRoadBright; /*Լ·ȵĳ(Ȧ)*/
    BYTE    byRoadGrayLowTh; /*·ȵֵʼֵ1*/
    BYTE    byRoadGrayHighTh; /*·ȸֵʼֵ140*/
    WORD    wLoopPosBias; /*䴥Ȧλ30*/
    DWORD   dwHfrShtterInitValue; /*ͼعʱĳʼֵ2000*/
    DWORD   dwSnapShtterInitValue; /*ץͼعʱĳʼֵ500*/
    DWORD   dwHfrShtterMaxValue; /*ͼعʱֵ20000*/
    DWORD   dwSnapShtterMaxValue; /*ץͼعʱֵ1500*/
    DWORD   dwHfrShtterNightValue; /*ͼعʱֵ3000*/
    DWORD   dwSnapShtterNightMinValue; /*ץͼعʱСֵ3000*/
    DWORD   dwSnapShtterNightMaxValue; /*ץͼعʱֵ5000*/
    DWORD   dwInitAfe; /*ĳʼֵ200*/
    DWORD   dwMaxAfe; /*ֵ400*/
    WORD    wResolutionX;/* 豸ǰֱʿ*/
    WORD    wResolutionY;/* 豸ǰֱʸ*/
    DWORD   dwGainNightValue; /*棬Ĭֵ70*/
    DWORD   dwSceneMode; /*ģʽ SCENE_MODE */
    DWORD   dwRecordMode; /*¼־0-¼1-¼*/
    NET_DVR_GEOGLOCATION struGeogLocation; /*ַλ*/
    BYTE    byTrigFlag[MAX_VL_NUM]; /*־0-ͷ1-β2-ͷ/β*/
    BYTE    byTrigSensitive[MAX_VL_NUM];  /*ȣ1-100*/
    BYTE    byRes2[62];
}NET_DVR_VTPARAM, *LPNET_DVR_VTPARAM;

typedef struct tagNET_DVR_SNAPENABLECFG
{
    DWORD dwSize;
    BYTE  byPlateEnable;//Ƿֳ֧ʶ0-֧֣1-֧
    BYTE  byRes1[2];   //
    BYTE  byFrameFlip;   //ͼǷת 0-ת1-ת
    WORD  wFlipAngle;    //ͼתǶ 0,90,180,270
    WORD  wLightPhase;   //λȡֵΧ[0, 360]
    BYTE  byLightSyncPower;  //ǷźŵƵԴͬ0-ͬ1-ͬ
    BYTE  byFrequency;        //źƵ
    BYTE  byUploadSDEnable;  //ǷԶϴSDͼƬ0-1-
    BYTE  byPlateMode; //ʶģʽ:0-Ƶ,1-ⲿ
    BYTE  byUploadInfoFTP; //ǷϴץĸϢFTP0-1-
    BYTE  byAutoFormatSD; //ǷԶʽSD0-1-
    WORD  wJpegPicSize; //JpegͼƬС[64-8196]
    BYTE  bySnapPicResolution;  //ץͼƬֱ(NET_DVR_COMPRESSION_INFO_V30зֱʱһ)
    BYTE  byRes[55]; //
}NET_DVR_SNAPENABLECFG, *LPNET_DVR_SNAPENABLECFG;

/*ftpϴ*/
typedef struct 
{
    DWORD    dwSize;
    DWORD    dwEnableFTP;            /*Ƿftpϴ*/
    char    sFTPIP[16];                /*ftp */
    DWORD    dwFTPPort;                /*ftp˿*/
    BYTE    sUserName[NAME_LEN];    /*û*/
    BYTE    sPassword[PASSWD_LEN];    /**/
    DWORD    dwDirLevel;    /*0 = ʹĿ¼ṹֱӱڸĿ¼,1 = ʹ1Ŀ¼,2=ʹ2Ŀ¼*/
    WORD     wTopDirMode;    /* һĿ¼0x1 = ʹ豸,0x2 = ʹ豸,0x3 = ʹ豸ipַ0x4=ʹü,0x5=ʹʱ(),0x=6Զ,0x7=Υ,0x8=,0x9=ص*/
    WORD     wSubDirMode;    /* Ŀ¼0x1 = ʹͨ,0x2 = ʹͨţ,0x3=ʹʱ(),0x4=ʹó,0x=5Զ,0x6=Υ,0x7=,0x8=ص*/
    BYTE    byEnableAnony; //0-1-
    BYTE    byPicArchivingInterval;//ͼƬ鵵[1~30],0ʾر
    BYTE    byRes[22];
}NET_DVR_FTPCFG, *LPNET_DVR_FTPCFG;

/*ͼƬԪ */
#define PICNAME_ITEM_DEV_NAME         1        /*豸*/
#define PICNAME_ITEM_DEV_NO         2        /*豸*/
#define PICNAME_ITEM_DEV_IP         3        /*豸IP*/
#define PICNAME_ITEM_CHAN_NAME         4        /*ͨ*/
#define PICNAME_ITEM_CHAN_NO         5        /*ͨ*/
#define PICNAME_ITEM_TIME             6        /*ʱ*/
#define PICNAME_ITEM_CARDNO            7        /**/
#define PICNAME_ITEM_PLATE_NO       8   /*ƺ*/
#define PICNAME_ITEM_PLATE_COLOR    9   /*ɫ*/
#define PICNAME_ITEM_CAR_CHAN       10  /**/
#define PICNAME_ITEM_CAR_SPEED      11  /*ٶ*/
#define PICNAME_ITEM_CARCHAN        12  /**/
#define PICNAME_ITEM_PIC_NUMBER     13  //ͼƬ
#define PICNAME_ITEM_CAR_NUMBER     14  //
#define PICNAME_MAXITEM             15

#define PICNAME_ITEM_SPEED_LIMIT_VALUES    15 //ֵ
#define PICNAME_ITEM_ILLEGAL_CODE          16 //Υ
#define PICNAME_ITEM_CROSS_NUMBER          17 //·ڱ
#define PICNAME_ITEM_DIRECTION_NUMBER      18 //

//(3.7Ver)
#define PICNAME_ITEM_CAR_COLOR             19 //ɫ
#define PICNAME_ITEM_PLATE_COORDINATE      20 //
#define PICNAME_ITEM_CAR_TYPE              21 //
#define PICNAME_ITEM_VIOLATION_TYPE        22 //Υ
#define PICNAME_ITEM_CUSTOM                255//Զ



//ͼƬ
typedef struct 
{
    BYTE     byItemOrder[PICNAME_MAXITEM];    /*    鶨ļĹ */
    BYTE     byDelimiter;        /*ָһΪ'_'*/
}NET_DVR_PICTURE_NAME, *LPNET_DVR_PICTURE_NAME;

//2013-09-27
#define PICNAME_ITEM_PARK_DEV_IP             1        /*豸IP*/
#define PICNAME_ITEM_PARK_PLATE_NO          2       /*ƺ*/
#define PICNAME_ITEM_PARK_TIME                 3        /*ʱ*/
#define PICNAME_ITEM_PARK_INDEX             4       /*λ*/
#define PICNAME_ITEM_PARK_STATUS            5       /*λ״̬*/
#define PICNAME_ITEM_BUILDING_NUMBER        6       /*ŵԪ*/
#define PICNAME_ITEM_OUTDOOR_UNIT_ID        7       /*ſڻ*/
#define PICNAME_ITEM_UNLOCK_TYPE            8       /*ʽ*/
#define PICNAME_ITEM_DEVICE_NAME            9       //豸
#define PICNAME_ITEM_PERIOD_NO              10      /*ں*/
#define PICNAME_ITEM_DEV_INDEX              11      /*豸*/
#define PICNAME_PREFIX                      32      /*ͼƬԶǰ׺*/
//ͼƬչ 2013-09-27
typedef struct 
{
    BYTE     byItemOrder[PICNAME_MAXITEM];    /*    鶨ļĹ */
    BYTE     byDelimiter;                    /*ָһΪ'_'*/
    BYTE    byPicNamePrefix[PICNAME_PREFIX/*32*/];  //ͼƬԶǰ׺
}NET_DVR_PICTURE_NAME_EX, *LPNET_DVR_PICTURE_NAME_EX;

/* ץͼ*/
typedef struct 
{
    BYTE    byStrFlag;    /*ݿʼ*/
    BYTE     byEndFlag;    /**/
    WORD    wCardIdx;    /*ʼλ*/
    DWORD     dwCardLen;    /*ų*/
    DWORD   dwTriggerPicChans;    /*ͨţλӵ1λʼƣ0x2ʾһͨ*/
}NET_DVR_SERIAL_CATCHPIC_PARA, *LPNET_DVR_SERIAL_CATCHPIC_PARA;

//DVRץͼãߣ
typedef struct 
{
    DWORD    dwSize;
    NET_DVR_JPEGPARA struJpegPara[MAX_CHANNUM_V30];    /*ÿͨͼ*/
    WORD    wBurstMode;                            /*ץͼʽ,λ.0x1=봥0x2=ƶⴥ 0x4=2320x8=4850x10=紥*/
    WORD    wUploadInterval;                    /*ͼƬϴ()[0,65535]*/
    NET_DVR_PICTURE_NAME     struPicNameRule;    /* ͼƬ */
    BYTE    bySaveToHD;        /*Ƿ񱣴浽Ӳ*/
    BYTE    byRes1;
    WORD    wCatchInterval;        /*ץͼ()[0,65535]*/
    BYTE    byRes2[12];
    NET_DVR_SERIAL_CATCHPIC_PARA struRs232Cfg;
    NET_DVR_SERIAL_CATCHPIC_PARA struRs485Cfg;
    DWORD dwTriggerPicTimes[MAX_CHANNUM_V30];    /* ÿͨһδմ */
    DWORD dwAlarmInPicChanTriggered[MAX_ALARMIN_V30]; /*ץͨ,λãӵ1λʼ*/
}NET_DVR_JPEGCFG_V30, *LPNET_DVR_JPEGCFG_V30;

//ץĴṹ()
typedef struct tagNET_DVR_MANUALSNAP
{
    BYTE   byOSDEnable;//0-ر(Ĭ)1-ر
    BYTE   byLaneNo;//, ΧΪ1-6ĬΪ1(ץĻڲʹ)
    BYTE   byRes[22]; //
}NET_DVR_MANUALSNAP, *LPNET_DVR_MANUALSNAP;

typedef struct tagNET_DVR_SPRCFG    
{
    DWORD dwSize; 
    BYTE byDefaultCHN[MAX_CHJC_NUM]; /*豸ʡݵĺּд*/
    BYTE byPlateOSD;    /*0:ͳƲɫͼ,1:ͳƲɫͼ*/
    BYTE bySendJPEG1;   /*0-ͽJPEGͼ,1-ͽJPEGͼ*/
    BYTE bySendJPEG2;   /*0-ԶJPEGͼ,1-ԶJPEGͼ*/
    WORD wDesignedPlateWidth;   /*ƿ*/
    BYTE byTotalLaneNum;  /*ʶĳ*/
    BYTE byRes1;      /**/
    WORD wRecognizedLane;  /*ʶĳţλʾbit0ʾ1Ƿʶ0-ʶ1-ʶ*/
    NET_VCA_RECT struLaneRect[MAX_LANERECT_NUM];  /*ʶ*/
                                                  DWORD dwRecogMode;  /*ʶͣ
                                                                      bit0-ʶ0-ʶ1-ʶ(βʶ)  
                                                                      bit1-ʶСʶ0-Сʶ1-ʶ 
                                                                      bit2-ɫʶ0-óɫʶڱʶСʶʱֹã1-ɫʶ
                                                                      bit3-ũóʶ0-ũóʶ1-ũóʶ 
                                                                      bit4-ģʶ0-ģʶ1-ģʶ
                                                                      bit5-֡λ򳡶λ0-֡λ1-λ
                                                                      bit6-֡ʶʶ0-֡ʶ1-ʶ 
                                                  bit7-ϻ죺0-죬1- */
                                                  BYTE  bySendPRRaw;           //Ƿԭͼ0-ͣ1- 
                                                  BYTE  bySendBinImage;      //Ƿͳƶֵͼ0-ͣ1- 
                                                  BYTE  byDelayCapture;  //ʱץĿ,λ֡
                                                  BYTE  byUseLED;    //ʹLEDƣ0-1-
                                                  BYTE  byRes2[68];    //
}NET_DVR_SPRCFG, *LPNET_DVR_SPRCFG;

typedef struct tagNET_DVR_PLCCFG
{
    DWORD dwSize;
    BYTE byPlcEnable;    //ǷóȲĬã0-رգ1- 
    BYTE byPlateExpectedBright;    //ƵԤȣĬֵ50, Χ[0, 100]
    BYTE byRes1[2];    // 
    BYTE byTradeoffFlash;     //ǷƵӰ: 0 - ;  1 - (Ĭ); 
    //ʹƲʱ, ǼƵǿЧӦ, ҪΪ1;Ϊ0
    BYTE byCorrectFactor;     //ϵ, Χ[0, 100], Ĭֵ50 (tradeoff_flashлʱ,ָĬֵ
    WORD wLoopStatsEn;  //ǷȦȣλʾ0-ͳƣ1-ͳ
    BYTE byPlcBrightOffset;// Ȳ(ȦģʽЧ)ȡֵΧ1~100
    BYTE byRes[19];
}NET_DVR_PLCCFG, *LPNET_DVR_PLCCFG;

typedef struct tagNET_DVR_DEVICESTATECFG
{
    DWORD dwSize;
    WORD wPreviewNum; //ԤӸ
    WORD wFortifyLinkNum; //Ӹ
    NET_DVR_IPADDR struPreviewIP[MAX_LINK];  //ԤûIPַ
    NET_DVR_IPADDR struFortifyIP[MAX_FORTIFY_NUM]; //ӵûIPַ
    DWORD dwVideoFrameRate;    //֡ʣ0-ȫ; 1-1/16; 2-1/8; 3-1/4; 4-1/2; 5-1; 6-2; 7-4; 8-6; 9-8; 10-10; 11-12; 12-16; 13-20; 14-15; 15-18; 16-22;
    BYTE byResolution;      //ֱ0-DCIF 1-CIF, 2-QCIF, 3-4CIF, 4-2CIF 5,16-VGA640*480, 17-UXGA1600*1200, 18-SVGA 800*600,19-HD720p1280*720,20-XVGA,  21-HD900p, 27-HD1080i, 28-2560*1920, 29-1600*304, 30-2048*1536, 31-2448*2048
    BYTE bySnapResolution;      //ץķֱ0-DCIF 1-CIF, 2-QCIF, 3-4CIF, 4-2CIF 5,16-VGA640*480, 17-UXGA1600*1200, 18-SVGA 800*600,19-HD720p1280*720,20-XVGA,  21-HD900p, 27-HD1080i, 28-2560*1920, 29-1600*304, 30-2048*1536, 31-2448*2048
    BYTE byStreamType; //ͣ0-1-
    BYTE byTriggerType; //ģʽ0-Ƶ1-ͨ
    DWORD dwSDVolume;  //SD
    DWORD dwSDFreeSpace; //SDʣռ
    BYTE byDetectorState[MAX_DRIVECHAN_NUM][MAX_COIL_NUM];  //״̬0-δʹã1-2-쳣
    BYTE byDetectorLinkState; //״̬0-δӣ1-
    BYTE bySDStatus;    //SD״̬ 01ߣ2쳣3-sd
    BYTE byFortifyLevel[MAX_FORTIFY_NUM]; //ȼ0-ޣ1-һȼߣ2-ȼУ3-ȼͣ
    BYTE byRes2[116]; //
}NET_DVR_DEVICESTATECFG, *LPNET_DVR_DEVICESTATECFG;

typedef struct tagNET_DVR_POSTEPOLICECFG
{
    DWORD dwSize;
    DWORD dwDistance;//Ȧ,λcmȡֵΧ[0,20000]
    DWORD dwLightChan[MAX_SIGNALLIGHT_NUM];    //źŵͨ
    BYTE  byCapSpeed;//־٣λkm/hȡֵΧ[0,255]
    BYTE  bySpeedLimit;//ֵλkm/hȡֵΧ[0,255]
    BYTE  byTrafficDirection;//0-ɶ1-򶫣2-򱱣3-ɱ
    BYTE  byRes1; //
    WORD  wLoopPreDist;        /*ӳپ λ*/
    WORD  wTrigDelay;             /*Ӳʱʱ λ*/
    BYTE  byRes[124];//ֽ
}NET_DVR_POSTEPOLICECFG, *LPNET_DVR_POSTEPOLICECFG;


//źŵ쳣
typedef struct  tagNET_DVR_SIGNALLAMP_DETCFG
{
    DWORD   dwSize;        //ṹ
    //ʱ,yyyymmddhhmmssxxx,e.g.20090810235959999  λΪ
    BYTE    byAbsTime[32];    
    NET_DVR_IPADDR    struAlarmCamIP;//IP
    DWORD   dwPic1Len;     //쳣ͼƬ1
    DWORD   dwPic2Len;     //쳣ͼƬ2
    char    *pPic1Buffer;    //ָ  ӳͼƬ
    char    *pPic2Buffer;    //ָ  źŵ״̬ͼƬ
    BYTE    byRes[128];
}NET_DVR_SIGNALLAMP_DETCFG, *LPNET_DVR_SIGNALLAMP_DETCFG;

typedef struct tagNET_DVR_EXDEVDET_COND
{
    DWORD         dwSize; // ṹС
    DWORD         dwChannel;                //ͨ    
    BYTE          byExternalDevType;// 0-Чֵ1-źŵ,2-
    BYTE          byRes[63];             // ֽ
}NET_DVR_EXDEVDET_COND,*LPNET_DVR_EXDEVDET_COND;

typedef struct tagNET_DVR_EXDEVDET_CFG
{
    DWORD         dwSize; // ṹС
    BYTE          byExternalDevStatus;// 0-1-쳣
    BYTE          byRes[63];// ֽ
} NET_DVR_EXDEVDET_CFG,*LPNET_DVR_EXDEVDET_CFG;

/***************************** end *********************************************/

#define IPC_PROTOCOL_NUM      50   //ipc Э

//Э
typedef struct tagNET_DVR_PROTO_TYPE
{ 
    DWORD dwType;               /*ipcЭֵ*/    
    BYTE  byDescribe[DESC_LEN]; /*Эֶ*/    
}NET_DVR_PROTO_TYPE, *LPNET_DVR_PROTO_TYPE;

//Эб
typedef struct tagNET_DVR_IPC_PROTO_LIST
{    
    DWORD   dwSize; 
    DWORD   dwProtoNum;           /*ЧipcЭĿ*/   
    NET_DVR_PROTO_TYPE struProto[IPC_PROTOCOL_NUM];   /*ЧipcЭ*/    
    BYTE    byRes[8];
}NET_DVR_IPC_PROTO_LIST, *LPNET_DVR_IPC_PROTO_LIST;

//ЭбV41
typedef struct tagNET_DVR_IPC_PROTO_LIST_V41
{
    DWORD   dwSize;  
    DWORD   dwProtoNum;  //ЧipcЭĿ
    BYTE    *pBuffer;    //Эб, dwProtoNum NET_DVR_PROTO_TYPEṹ  
    DWORD   dwBufferLen; //
    BYTE    byRes[32];   
}NET_DVR_IPC_PROTO_LIST_V41, *LPNET_DVR_IPC_PROTO_LIST_V41;

typedef struct tagNET_DVR_PTZPOS_INFO
{
    DWORD    dwPanPos;    // Pˮƽ
    DWORD    dwTiltPos;    // Tֱ
    DWORD    dwZoomPos;  // Z䱶
}NET_DVR_PTZPOS_INFO, *LPNET_DVR_PTZPOS_INFO;

//ʶṹ
typedef struct tagNET_VCA_HUMAN_FEATURE
{
    BYTE byAgeGroup;    //,μ HUMAN_AGE_GROUP_ENUM
    BYTE bySex;         //Ա, 1 -  , 2 - Ů
    BYTE byEyeGlass;    //Ƿ۾ 1 - , 2 - 
    BYTE byRes [13];    //
}NET_VCA_HUMAN_FEATURE ,*LPNET_VCA_HUMAN_FEATURE;

//ɫ
typedef struct tagNET_DVR_OBJECT_FEATURE
{
    BYTE  byColorRatel;            //ɫƶеռֵ
    BYTE  byRed;                        // RGBɫеĺɫ
    BYTE  byGreen;                    // RGBɫеɫ
    BYTE  byBlue;                   // RGBɫеɫ
    BYTE  byRes[32];
}NET_DVR_OBJECT_FEATURE ,*LPNET_DVR_OBJECT_FEATURE;

//
typedef union tagNET_DVR_ADVANCE_COND_UNION
{  
    BYTE                  byLen[36];  //峤
    NET_VCA_HUMAN_FEATURE      struHumanFeature; //
    NET_DVR_OBJECT_FEATURE     struObjectFeature; //
}NET_DVR_ADVANCE_COND_UNION,*LPNET_DVR_ADVANCE_COND_UNION;


#define MAX_ALERTLINE_NUM    8 //󾯽    


typedef struct tagNET_DVR_TRAVERSE_PLANE_SEARCHCOND
{    
    NET_VCA_TRAVERSE_PLANE struVcaTraversePlane[MAX_ALERTLINE_NUM/*8*/];  //Խ
    DWORD dwPreTime;   /*ܱǰʱ λ:*/
    DWORD dwDelayTime; /*ܱӳʱ λ:*/ 
    NET_DVR_PTZPOS_INFO struPTZPosInfo;  //PTZϢ
    BYTE  byAdvanceType;   //Ϸʽ0-ʹţ1-ϣ2-ɫռ
    BYTE  byRes1[3];  //
    NET_DVR_ADVANCE_COND_UNION uAdvanceCond;  //
    BYTE  byRes[5604]; //
}NET_DVR_TRAVERSE_PLANE_SEARCHCOND, *LPNET_DVR_TRAVERSE_PLANE_SEARCHCOND; //Խѯ

#define MAX_INTRUSIONREGION_NUM    8 //
typedef struct tagNET_DVR_INTRUSION_SEARCHCOND  
{
    NET_VCA_INTRUSION struVcaIntrusion[MAX_INTRUSIONREGION_NUM/*8*/]; //
    DWORD dwPreTime;   /*ܱǰʱ λ:*/
    DWORD dwDelayTime; /*ܱӳʱ λ:*/ 
    NET_DVR_PTZPOS_INFO struPTZPosInfo;  //PTZϢ
    BYTE  byAdvanceType;//Ϸʽ0-ʹţ1-ϣ2-ɫռ
    BYTE  byRes1[3];  //
    NET_DVR_ADVANCE_COND_UNION uAdvanceCond;  //
    BYTE byRes[5348]; //
} NET_DVR_INTRUSION_SEARCHCOND, *LPNET_DVR_INTRUSION_SEARCHCOND; //


typedef struct tagNET_DVR_FACEDETECTION_SEARCHCOND
{
    NET_VCA_POLYGON  struFacePolygon; //ʶ
    DWORD           dwPreTime;   /*¼ǰʱ λ:*/
    DWORD           dwDelayTime; /*¼ӳʱ λ:*/
    BYTE byRes[5972]; //
}NET_DVR_FACEDETECTION_SEARCHCOND, *LPNET_DVR_FACEDETECTION_SEARCHCOND; //


typedef union tagNET_DVR_AREA_SMARTSEARCH_COND_UNION
{  
    BYTE    byLen[6144];  //ṹ峤
    BYTE    byMotionScope[64][96]; // 0-96λʾ64У96*64С飬1-ƶ0-ƶ 
    NET_DVR_TRAVERSE_PLANE_SEARCHCOND struTraversPlaneCond; //Խ
    NET_DVR_INTRUSION_SEARCHCOND struIntrusionCond; //
    NET_DVR_FACEDETECTION_SEARCHCOND struFaceSnapCond; //
}NET_DVR_AREA_SMARTSEARCH_COND_UNION,
*LPNET_DVR_AREA_SMARTSEARCH_COND_UNION;


//
typedef struct tagNET_DVR_SMART_SEARCH_PARAM
{
    BYTE      byChan;                    //ͨ
    BYTE      bySearchCondType; //ܲNET_DVR_AREA_SMARTSEARCH_COND_UNION     
    /*0-ƶ 1-Խ⣬ 2-, 3- */
    WORD      wChan;                //ͨţ ֶǶbyChanչʹøֶκbyChanԲʹ
    NET_DVR_TIME struStartTime;        //¼ʼʱ
    NET_DVR_TIME struEndTime;        //¼ֹͣʱ
    NET_DVR_AREA_SMARTSEARCH_COND_UNION uSmartSearchCond;  //ܲ
    BYTE  bySensitivity;               //ƶ,1    >80%  2 40%~80%  3 1%~40%    
    BYTE byRes2[11];
}NET_DVR_SMART_SEARCH_PARAM, *LPNET_DVR_SMART_SEARCH_PARAM;

typedef struct tagNET_DVR_SMART_SEARCH_PARAM_V40
{  
    DWORD                   dwSize;                 //ṹС
    NET_DVR_STREAM_INFO   struIDInfo;           //ͨϢ
    BYTE                   bySearchCondType;     //ܲ 0-, 1-Խ, 2-,3-, 4-Ƽ
    BYTE                  bySensitivity; //̬,1-100
    BYTE                  byRes1[2];
    NET_DVR_TIME_EX       struStartTime;  
    NET_DVR_TIME_EX       struEndTime;
    NET_DVR_AREA_SMARTSEARCH_COND_UNION uSmartSearchCond;  //ܲ
    BYTE                  byRes2[256];
}NET_DVR_SMART_SEARCH_PARAM_V40,*LPNET_DVR_SMART_SEARCH_PARAM_V40;



typedef struct tagNET_DVR_SMART_SEARCH_RET
{
    NET_DVR_TIME struStartTime;    //ƶⱨʼʱ
    NET_DVR_TIME struEndTime;   //¼ֹͣʱ
    BYTE byRes[64];
}NET_DVR_SMART_SEARCH_RET, *LPNET_DVR_SMART_SEARCH_RET;

// IPSAN ļĿ¼
typedef struct tagNET_DVR_IPSAN_SERACH_PARAM
{
    NET_DVR_IPADDR  struIP;     // IPSAN IPַ
    WORD            wPort;      // IPSAN  ˿
    BYTE            byRes[10];  // ֽ
}NET_DVR_IPSAN_SERACH_PARAM, *LPNET_DVR_IPSAN_SERACH_PARAM;

typedef struct tagNET_DVR_IPSAN_SERACH_RET
{
    BYTE byDirectory[128];  // صļĿ¼
    BYTE byRes[20];
}NET_DVR_IPSAN_SERACH_RET, *LPNET_DVR_IPSAN_SERACH_RET;

//DVR豸
typedef struct
{
    DWORD dwSize;
    BYTE sDVRName[NAME_LEN];     //DVR
    DWORD dwDVRID;                //DVR ID,ң //V1.4(0-99), V1.5(0-255)
    DWORD dwRecycleRecord;        //Ƿѭ¼,0:; 1:
    //²ɸ
    BYTE sSerialNumber[SERIALNO_LEN];  //к
    DWORD dwSoftwareVersion;            //汾,16λ汾,16λǴΰ汾
    DWORD dwSoftwareBuildDate;            //,0xYYYYMMDD
    DWORD dwDSPSoftwareVersion;            //DSP汾,16λ汾,16λǴΰ汾
    DWORD dwDSPSoftwareBuildDate;        // DSP,0xYYYYMMDD
    DWORD dwPanelVersion;                // ǰ汾,16λ汾,16λǴΰ汾
    DWORD dwHardwareVersion;    // Ӳ汾,16λ汾,16λǴΰ汾
    BYTE byAlarmInPortNum;        //DVR
    BYTE byAlarmOutPortNum;        //DVR
    BYTE byRS232Num;            //DVR 232ڸ
    BYTE byRS485Num;            //DVR 485ڸ 
    BYTE byNetworkPortNum;        //ڸ
    BYTE byDiskCtrlNum;            //DVR Ӳ̿
    BYTE byDiskNum;                //DVR Ӳ̸
    BYTE byDVRType;                //DVR, 1:DVR 2:ATM DVR 3:DVS ......
    BYTE byChanNum;                //DVR ͨ
    BYTE byStartChan;            //ʼͨ,DVS-1,DVR - 1
    BYTE byDecordChans;            //DVR ·
    BYTE byVGANum;                //VGAڵĸ 
    BYTE byUSBNum;                //USBڵĸ
    BYTE byAuxoutNum;            //ڵĸ
    BYTE byAudioNum;            //ڵĸ
    BYTE byIPChanNum;            //ͨ 8λ8λbyHighIPChanNum 
    BYTE byZeroChanNum;            //ͨ
    BYTE bySupport;        //λΪ0ʾ֧֣1ʾ֧֣
    //bySupport & 0x1, ʾǷ֧
    //bySupport & 0x2, ʾǷֱ֧
    //bySupport & 0x4, ʾǷ֧ѹȡ
    //bySupport & 0x8, ʾǷֶ֧
    //bySupport & 0x10, ʾ֧ԶSADP
    //bySupport & 0x20, ʾ֧Raid
    //bySupport & 0x40, ʾ֧IPSAN
    //bySupport & 0x80, ʾ֧rtp over rtsp
    BYTE byEsataUseage;        //EsataĬ;0-Ĭϱݣ1-Ĭ¼
    BYTE byIPCPlug;            //0-رռ弴ã1-򿪼弴
    BYTE byStorageMode;        //0-ģʽ,1-, 2֡ģʽ
    BYTE bySupport1;        //λΪ0ʾ֧֣1ʾ֧
    //bySupport1 & 0x1, ʾǷ֧snmp v30
    //bySupport1 & 0x2, ֻ֧طź
    //bySupport1 & 0x4, Ƿֲ֧ȼ    
    //bySupport1 & 0x8, 豸Ƿֲ֧ʱչ
    //bySupport1 & 0x10, ʾǷֶ֧33
    //bySupport1 & 0x20, ʾǷ֧rtsp over http    
    WORD wDevType;//豸ͺ
    BYTE  byDevTypeName[DEV_TYPE_NAME_LEN];//豸ͺ 
    BYTE bySupport2; //չλΪ0ʾ֧֣1ʾ֧
    //bySupport2 & 0x1, ʾǷ֧չOSDַ(ն˺ץĻչ)
    BYTE byAnalogAlarmInPortNum; //ģⱨ
    BYTE byStartAlarmInNo;    //ģⱨʼ
    BYTE byStartAlarmOutNo;  //ģⱨʼ
    BYTE  byStartIPAlarmInNo;  //IPʼ
    BYTE  byStartIPAlarmOutNo; //IPʼ
    BYTE byHighIPChanNum;      //ͨ8λ 
    BYTE byEnableRemotePowerOn;//Ƿ豸ߵ״̬Զ̿ܣ0-ã1-
    WORD wDevClass; //豸࣬ж豸ĸƷߣ0 1-50 DVR51-100 DVS101-150 NVR151-200 IPC65534 ෽豸ͶӦкźֵ.docx
    BYTE byRes2[6];            //
}NET_DVR_DEVICECFG_V40, *LPNET_DVR_DEVICECFG_V40;

#define MAX_ZEROCHAN_NUM    16
//ͨѹò
typedef struct tagNET_DVR_ZEROCHANCFG
{
    DWORD dwSize;            //ṹ
    BYTE  byEnable;            //0-ֹͣͨ룬1-ʾͨ
    BYTE  byRes1[3];            //
    DWORD dwVideoBitrate;     //Ƶ 0- 1-16K() 2-32K 3-48k 4-64K 5-80K 6-96K 7-128K 8-160k 9-192K 10-224K 11-256K 12-320K
    // 13-384K 14-448K 15-512K 16-640K 17-768K 18-896K 19-1024K 20-1280K 21-1536K 22-1792K 23-2048K
    //λ(31λ)ó1ʾԶ, 0-30λʾֵ(MIN-32K MAX-8192K)
    DWORD dwVideoFrameRate;    //֡ 0-ȫ; 1-1/16; 2-1/8; 3-1/4; 4-1/2; 5-1; 6-2; 7-4; 8-6; 9-8; 10-10; 11-12; 12-16; 13-20, //V2.014-15, 15-18, 16-22;
    BYTE  byRes2[32];        //
}NET_DVR_ZEROCHANCFG, *LPNET_DVR_ZEROCHANCFG;

//ͨŲ
typedef struct tagNET_DVR_ZERO_ZOOMCFG
{
    DWORD dwSize;                //ṹ
    NET_VCA_POINT  struPoint;    //е
    BYTE byState;                //ڵ״̬0-С1-Ŵ  
    BYTE byPreviewNumber;       //ԤĿ,0-1,1-4,2-9,3-16 òֻ
    BYTE byPreviewSeq[MAX_WINDOW_V30];//ͨϢ òֻ
    BYTE byRes[30];                // 
}NET_DVR_ZERO_ZOOMCFG, *LPNET_DVR_ZERO_ZOOMCFG;

#define DESC_LEN_64 64
typedef struct tagNET_DVR_SNMPCFG
{
    DWORD   dwSize;            //ṹ
    BYTE    byEnable;            //0-SNMP1-ʾSNMP
    BYTE    byRes1[3];            //
    WORD    wVersion;        //snmp 汾  v1 = 1, v2 =2, v3 =3豸Ŀǰ֧ v3
    WORD    wServerPort; //snmpϢն˿ڣĬ 161
    BYTE    byReadCommunity[NAME_LEN]; //ͬ壬31,Ĭ"public"
    BYTE    byWriteCommunity[NAME_LEN];//дͬ,31 ֽ,Ĭ "private"
    BYTE     byTrapHostIP [DESC_LEN_64];    //ipַ֧IPV4 IPV6    
    WORD    wTrapHostPort;   // trap˿
    BYTE    byTrapName[NAME_LEN];    
    BYTE    byRes2[70];    //
}NET_DVR_SNMPCFG, *LPNET_DVR_SNMPCFG;

typedef struct tagNET_DVR_SNMPv3_USER
{
    BYTE    byUserName[NAME_LEN];            // û                
    BYTE    bySecLevel;                        // ȫ 1-У 2-ȨУ 3-ȨУ
    BYTE    byAuthtype;                        // ֤ 0-MD5֤ 1-SHA֤ 2: none
    BYTE    byPrivtype;                        // 0: DES; 1: AES; 2: none;
    BYTE    byRes[5];
    BYTE    byAuthpass[PASSWD_LEN];            // ֤
    BYTE    byPrivpass[PASSWD_LEN];            // 
}NET_DVR_SNMPv3_USER, *LPNET_DVR_SNMPv3_USER;

// snmpv30
typedef struct tagNET_DVR_SNMPCFG_V30
{
    DWORD                dwSize;            //ṹ
    BYTE                byEnableV1;        //0-SNMP V11-ʾSNMP V1
    BYTE                byEnableV2;        //0-SNMP V21-ʾSNMP V2
    BYTE                byEnableV3;        //0-SNMP V31-ʾSNMP V3
    BYTE                byRes1[3];
    WORD                wServerPort;                    //snmpϢն˿ڣĬ 161
    BYTE                byReadCommunity[NAME_LEN];        //ͬ壬31,Ĭ"public"
    BYTE                byWriteCommunity[NAME_LEN];        //дͬ,31 ֽ,Ĭ "private"
    BYTE                 byTrapHostIP [DESC_LEN_64];        //ipַ֧IPV4 IPV6    
    WORD                wTrapHostPort;                    // trap˿
    BYTE                byRes2[2];       
    NET_DVR_SNMPv3_USER    struRWUser;    // дû
    NET_DVR_SNMPv3_USER    struROUser;    // ֻû
    BYTE                byTrapName[NAME_LEN];
}NET_DVR_SNMPCFG_V30, *LPNET_DVR_SNMPCFG_V30;

#define  PROCESSING          0     //ڴ
#define  PROCESS_SUCCESS     100   //
#define  PROCESS_EXCEPTION   400   //쳣
#define  PROCESS_FAILED      500   //ʧ
#define  PROCESS_QUICK_SETUP_PD_COUNT 501 //һ3Ӳ

#define  SOFTWARE_VERSION_LEN 48
typedef struct tagNET_DVR_SADPINFO
{
    NET_DVR_IPADDR  struIP;     // 豸IPַ
    WORD            wPort;      // 豸˿ں
    WORD            wFactoryType;   // 豸
    char            chSoftwareVersion[SOFTWARE_VERSION_LEN];
    char            chSerialNo[16]; // к
    WORD            wEncCnt;       // ͨ
    BYTE            byMACAddr[MACADDR_LEN];        // MAC ַ
    NET_DVR_IPADDR  struSubDVRIPMask;   // DVR IPַ
    NET_DVR_IPADDR  struGatewayIpAddr;  // 
    NET_DVR_IPADDR    struDnsServer1IpAddr;            /* 1IPַ */
    NET_DVR_IPADDR    struDnsServer2IpAddr;            /* 2IPַ */
    BYTE            byDns;
    BYTE            byDhcp;
    BYTE            szGB28181DevID[DEV_ID_LEN];  //GB28181Эʱ豸IDIPCGB28181Э
    BYTE            byActivated;//0-Ч1-Ѽ2-δ
    BYTE            byRes[125];     // ֽ
}NET_DVR_SADPINFO, *LPNET_DVR_SADPINFO;

#define  MAX_SADP_NUM   256   // 豸Ŀ
typedef struct tagNET_DVR_SADPINFO_LIST
{
    DWORD            dwSize;   //  ṹС
    WORD             wSadpNum;   // 豸Ŀ
    BYTE             byRes[6];   // ֽ
    NET_DVR_SADPINFO struSadpInfo[MAX_SADP_NUM]; // 
}NET_DVR_SADPINFO_LIST, *LPNET_DVR_SADPINFO_LIST;

typedef struct tagNET_DVR_SADP_VERIFY
{
    char chPassword[PASSWD_LEN];
    NET_DVR_IPADDR struOldIP;
    WORD        wOldPort;
    BYTE        byRes[62];
}NET_DVR_SADP_VERIFY, *LPNET_DVR_SADP_VERIFY;

/*******************************ݽӿ begin********************************/
//ȡ豸Ϣӿڶ
#define DESC_LEN_32          32   //ֳ
#define MAX_NODE_NUM         256  //ڵ

typedef struct tagNET_DVR_DESC_NODE
{ 
    int   iValue;           
    BYTE  byDescribe[DESC_LEN_32]; //ֶ 
    DWORD dwFreeSpace;           //ȡбר,λΪM
    BYTE  byRes[12];              //  
}NET_DVR_DESC_NODE, *LPNET_DVR_DESC_NODE;

typedef struct tagNET_DVR_DISKABILITY_LIST
{ 
    DWORD     dwSize;            //ṹ
    DWORD     dwNodeNum;         //
    NET_DVR_DESC_NODE  struDescNode[MAX_NODE_NUM];  //  
}NET_DVR_DISKABILITY_LIST, *LPNET_DVR_DISKABILITY_LIST;

//ݽб
#define BACKUP_SUCCESS                100  //
#define BACKUP_CHANGE_DEVICE          101  //豸豸

#define BACKUP_SEARCH_DEVICE          300  //豸
#define BACKUP_SEARCH_FILE            301  //¼ļ
#define BACKUP_SEARCH_LOG_FILE        302  //־ļ

#define BACKUP_EXCEPTION              400  //쳣
#define BACKUP_FAIL                      500  //ʧ

#define BACKUP_TIME_SEG_NO_FILE       501  //ʱ¼ļ
#define BACKUP_NO_RESOURCE            502  //벻Դ
#define BACKUP_DEVICE_LOW_SPACE       503  //豸
#define BACKUP_DISK_FINALIZED         504  //¼̷
#define BACKUP_DISK_EXCEPTION         505  //¼쳣
#define BACKUP_DEVICE_NOT_EXIST       506  //豸
#define BACKUP_OTHER_BACKUP_WORK      507  //ݲڽ
#define BACKUP_USER_NO_RIGHT          508  //ûûвȨ
#define BACKUP_OPERATE_FAIL           509  //ʧ
#define BACKUP_NO_LOG_FILE            510  //Ӳ־

//ݹ̽ӿڶ
typedef struct tagNET_DVR_BACKUP_NAME_PARAM
{
    DWORD dwFileNum;   //ļ
    NET_DVR_FINDDATA_V30 struFileList[MAX_RECORD_FILE_NUM]; //ļб
    BYTE byDiskDes[DESC_LEN_32];   //ݴ
    BYTE byWithPlayer;      //Ƿ񱸷ݲ
    BYTE byContinue;    /*Ƿ 0 1*/
    BYTE byRes[34];         //
}NET_DVR_BACKUP_NAME_PARAM, *LPNET_DVR_BACKUP_NAME_PARAM;

typedef struct tagNET_DVR_BACKUP_TIME_PARAM
{
    LONG            lChannel;        //ʱ䱸ݵͨ
    NET_DVR_TIME    struStartTime;   //ݵʼʱ
    NET_DVR_TIME    struStopTime;    //ݵֹʱ
    BYTE            byDiskDes[DESC_LEN_32];     //ݴ
    BYTE            byWithPlayer;               //Ƿ񱸷ݲ
    BYTE            byContinue;                 //Ƿ 0 1
    BYTE            byDrawFrame;                 //0 ֡  1 ֡
    BYTE            byUseBackCfgParam;          //ʹñеĲ0-Ч1-(úͨЧ)2-
    DWORD           dwStreamType;                //ͣλʾ
    //&0x1-ʾ 
    //&0x2-ʾ
    //&0x4-ʾ
    BYTE            byRes[28];                     // ֽ 
}NET_DVR_BACKUP_TIME_PARAM, *LPNET_DVR_BACKUP_TIME_PARAM;
/********************************* end *******************************************/

typedef enum _COMPRESSION_ABILITY_TYPE_
{
    COMPRESSION_STREAM_ABILITY = 0, //ѹ
        MAIN_RESOLUTION_ABILITY = 1,    //ѹֱ
        SUB_RESOLUTION_ABILITY  = 2,    //ѹֱ
        EVENT_RESOLUTION_ABILITY =  3,  //¼ѹֱ
        FRAME_ABILITY = 4,                //֡
        BITRATE_TYPE_ABILITY = 5,        //λ
        BITRATE_ABILITY = 6,            //λ
        THIRD_RESOLUTION_ABILITY = 7,   //ѹֱ
        STREAM_TYPE_ABILITY = 8,        //
        PIC_QUALITY_ABILITY = 9,         //ͼ
        INTERVAL_BPFRAME_ABILITY = 10,  //BP֡
        VIDEO_ENC_ABILITY = 11,           //Ƶ
        AUDIO_ENC_ABILITY = 12,           //Ƶ
        VIDEO_ENC_COMPLEXITY_ABILITY = 13, //Ƶ븴Ӷ
        FORMAT_ABILITY = 14, //װʽ
}COMPRESSION_ABILITY_TYPE;

//б
typedef struct tagNET_DVR_ABILITY_LIST
{ 
    DWORD     dwAbilityType;    // COMPRESSION_ABILITY_TYPE
    BYTE      byRes[32];        //ֽ
    DWORD     dwNodeNum;        //
    NET_DVR_DESC_NODE  struDescNode[MAX_NODE_NUM];  //  
}NET_DVR_ABILITY_LIST, *LPNET_DVR_ABILITY_LIST;

#define MAX_ABILITYTYPE_NUM  12   //
// ѹб
typedef struct tagNET_DVR_COMPRESSIONCFG_ABILITY
{ 
    DWORD     dwSize;            //ṹ
    DWORD     dwAbilityNum;        //͸
    NET_DVR_ABILITY_LIST struAbilityNode[MAX_ABILITYTYPE_NUM]; //  
}NET_DVR_COMPRESSIONCFG_ABILITY, *LPNET_DVR_COMPRESSIONCFG_ABILITY;
/********************************9000RH begin****************************************/
#define SUPPORT_PD_NUM            16
#define SUPPORT_ARRAY_NUM        8
#define SUPPORT_VD_NUM            128
#define SUPPORT_PD_NUM_            16
#define SUPPORT_PD_NUM_PARTTWO    8

typedef enum tagRAID_MODE
{
    RAID0 = 1,
        RAID1,
        RAID10,
        RAID1E,
        RAID5,
        RAID6,
        RAID50,
        JBOD, 
        RAID60
}RAID_MODE;

typedef enum tagHD_SUPPORT_TYPE
{
    HD_TYPE_SATA    = 0x01,
        HD_TYPE_PATA    = 0x02,
        HD_TYPE_SAS     = 0x04,
        HD_TYPE_ATAPI   = 0x08,
        HD_TYPE_TAPE    = 0x10,
        HD_TYPE_SES     = 0x20
}HD_SUPPORT_TYPE;

// λʾ λΪ0ʾ֧  1ʾ֧
typedef enum tagSUPPORT_RAID_TYPE
{
    RAID0_ABILITY   = 0x0001,
        RAID1_ABILITY   = 0x0002,
        RAID10_ABILITY  = 0x0004,
        RAID1E_ABILITY  = 0x0008,
        RAID5_ABILITY   = 0x0010,
        RAID6_ABILITY   = 0x0020,
        RAID50_ABILITY  = 0x0040,
        JBOD_ABILITY    = 0x0080,
        RAID60_ABILITY  = 0x0100
}SUPPORT_RAID_TYPE;

//  
typedef struct tagNET_DVR_PHY_DISK_INFO
{
    WORD    wPhySlot;         // Ӳ̲λ 
    BYTE    byType;         // ӲϢ0 ͨ1ȫȱ2-ȱ 3-
    BYTE    byStatus;       // Ӳ״̬  0- 1- 2-ɾ 3-̶ʧ 4- 5- 6- 7-쳣 8-SMART״̬쳣 9-0xff-
    BYTE    byMode[40];   // Ӳ ַ
    DWORD   dwHCapacity;    //  32λ λkb
    DWORD   dwLCapacity;    //  32λ
    BYTE    byArrrayName[MAX_NAMELEN];
    WORD    wArrayID;          // ID
    BYTE    byRes[102];         // ֽ  
}NET_DVR_PHY_DISK_INFO, *LPNET_DVR_PHY_DISK_INFO;

typedef struct tagNET_DVR_PHY_DISK_LIST
{
    DWORD   dwSize;
    DWORD   dwCount;
    NET_DVR_PHY_DISK_INFO struPhyDiskInfo[SUPPORT_PD_NUM];
}NET_DVR_PHY_DISK_LIST, *LPNET_DVR_PHY_DISK_LIST;

typedef enum tagBGA_TYPE
{
    BGA_REBUILD = 0x01,            // ؽ
        BGA_CONSISTENCY_FIX = 0x02,    // һԼ鲢޸
        BGA_CONSISTENCY_CHECK = 0x04,  // һԼ
        BGA_INIT_QUICK = 0x08,         // ʼ()
        BGA_INIT_BACK = 0x10,          // ʼ(ȫ)
        BGA_MIGRATION = 0x20,       // Ǩ
        BGA_INIT_FORE = 0x40,           // ʼ
        BGA_COPYBACK = 0x80             // Ǩ
}BGA_TYPE;

typedef enum tagBGA_STATE
{
    BGA_STATE_NONE = 0,     //  ޺̨
        BGA_STATE_RUNNING,       //  ̨
        BGA_STATE_ABORTED,       //  ̨ȡ
        BGA_STATE_PAUSED         //  ̨ͣ     
}BGA_STATE;
typedef struct tagNET_DVR_BGA_INFO
{
    BYTE    byBga;  // ̨ 
    BYTE    byBgaState;           /*ֵ--̨״̬*/
    WORD    wBgaPercentage;     /*ֵ--ִ̨аٷֱ*/
    BYTE    byRes[4];  // ֽ
}NET_DVR_BGA_INFO, *LPNET_DVR_BGA_INFO;

// Ϣ
typedef struct tagNET_DVR_ARRAY_INFO
{
    WORD    wArrayID; // ID
    BYTE    byRaidMode; // raidģʽ  RAID_MODE
    BYTE    byStatus;  // 0- 1-̶ʧ 2- 3- 4-쳣 5- 6-  7-ɾ 8-SMART״̬쳣 0xff-
    DWORD   dwHCapacity; // 32λ
    DWORD   dwLCapacity; // 32λ
    DWORD   dwHFreeSpace;   // ʣռ32λ
    DWORD   dwLFreeSpace;   // ʣռ32λ
    BYTE    byArrayName[MAX_NAMELEN]; // 
    BYTE    byPDCount;  // Ŀ
    BYTE    bySpareCount;   // ȱĿ
    BYTE    byRes1[2];
    WORD    wPDSlots[SUPPORT_PD_NUM];    // 
    WORD    wSparePDSlots[SUPPORT_PD_NUM];    // ȱ
    NET_DVR_BGA_INFO    struBgaInfo;    // ̨״̬
    WORD    wPDSlotsPartTwo[SUPPORT_PD_NUM_PARTTWO];  //չ0ʾЧ
    WORD    wSparePDSlotsPartTwo[SUPPORT_PD_NUM_PARTTWO];    // ȱչ0ʾЧ
    BYTE    byRes2[48]; // ֽ
}NET_DVR_ARRAY_INFO, *LPNET_DVR_ARRAY_INFO;


typedef struct tagNET_DVR_ARRAY_LIST
{
    DWORD   dwSize;     // ṹС
    DWORD   dwCount;    // и
    NET_DVR_ARRAY_INFO struArrayInfo[SUPPORT_ARRAY_NUM];
}NET_DVR_ARRAY_LIST, *LPNET_DVR_ARRAY_LIST;

//Ϣ
typedef struct tagNET_DVR_VD_INFO
{
    WORD    wSlot;    //̲λ  
    BYTE    byStatus; // ״̬0- 1- 2-ɾ 3-̶ʧ 4- 5- 6- 7-쳣 8-SMART״̬쳣 0xff- 
    BYTE    byRaidMode; // Raid ģʽ  RAID_MODE
    WORD    wArrayID;      // ID
    BYTE    byRepair;   // ǷҪ޸ 0 Ҫ 1Ҫ
    BYTE    byUsage;          //LUNʹ÷ʽ  0-IPSAN 1-FCSAN 2-DVR 3-NAS 4-¼
    BYTE    byArrayName[MAX_NAMELEN];
    BYTE    byName[MAX_NAMELEN];    // 
    DWORD   dwHCapacity;    // 32λ
    DWORD   dwLCapacity;    // 32λ
    DWORD   dwHFreeSpace;   // ʣռ32λ
    DWORD   dwLFreeSpace;   // ʣռ32λ
    NET_DVR_BGA_INFO    struBgaInfo;    // ̨״̬
    DWORD                dwBlockSize;    //С洢ԪС
    NET_DVR_IPADDR        struWarrantIP;    // ȨDVRIP
    char                szArrayGroup[NAME_LEN];     //ʹõ飬ԶŸΪʹĬ
    BYTE                byRes[20];
}NET_DVR_VD_INFO, *LPNET_DVR_VD_INFO;

typedef struct tagNET_DVR_VD_LIST
{
    DWORD   dwSize;     // ṹС
    DWORD   dwCount;    // ̸
    NET_DVR_VD_INFO struVDInfo[SUPPORT_VD_NUM];  //
}NET_DVR_VD_LIST, *LPNET_DVR_VD_LIST;

typedef struct tagNET_DVR_ADAPTER_VERSION
{
    WORD    wMajorVersion;
    WORD    wMinorVersion;
    WORD    wRevisionNumber;
    WORD    wBuildNumber;
}NET_DVR_ADAPTER_VERSION, *LPNET_DVR_ADAPTER_VERSION;

typedef struct tagNET_DVR_VD_SLOT
{
    WORD  wVDSlot;
    BYTE  byAlloc;  // ǷѾ
    BYTE  byRes[5];
    DWORD dwHVDSlotSize;    // ̿ռС32λ
    DWORD dwLVDSlotSize;    // ̿ռС32λ
}NET_DVR_VD_SLOT, *LPNET_DVR_VD_SLOT;

typedef struct tagNET_DVR_ARRAY_SPACE_ALLOC_INFO
{
    BYTE    byVDSlotCount;                        /*current number of slots in DG*/ 
    BYTE    byRes1[3];              // ֽ
    NET_DVR_VD_SLOT struVDSlots[SUPPORT_VD_NUM];
}NET_DVR_ARRAY_SPACE_ALLOC_INFO, *LPNET_DVR_ARRAY_SPACE_ALLOC_INFO;

typedef struct tagNET_DVR_RAID_ADAPTER_INFO
{
    DWORD dwSize;    // ṹС
    NET_DVR_ADAPTER_VERSION struVersion;    // 汾
    BYTE    bySlotCount;    //λ
    BYTE    bySupportMigrate;  // Ǩ(1-֧  0-֧)
    BYTE    bySupportExpand;   //   (1-֧  0-֧)
    BYTE    bySupportRebuild;  // Ƿ֧ؽ (1֧ 0-֧)
    WORD    wSlotSupportType; //  λʾ HD_SUPPORT_TYPE
    WORD    wSupportRaidType;      // ֧Raid  λʾ  
    BYTE    byAutoRebuild;      // 0 Զؽ 1Զؽ 
    BYTE    byRes[27];      // ֽ
}NET_DVR_RAID_ADAPTER_INFO, *LPNET_DVR_RAID_ADAPTER_INFO;

typedef struct tagNET_DVR_OPERATE_ARRAY_PARAM
{
    //Ƿһ  Ϊһ򴴽ʱʱ֮ҪarrayƣҪ
    // 豸д
    BYTE    byRaidMode;     // /ǨʱRaid
    BYTE    byPDCount;  // Ŀ
    WORD    wArrayID;   // ǨƻؽʱҪָID      
    WORD    wPDSlots[SUPPORT_PD_NUM];//  
    BYTE    byName[MAX_NAMELEN];  // array 
    BYTE    byInitMode;              //ʼʽ
    BYTE    byRes1;
    WORD    wPDSlotsPartTwo[SUPPORT_PD_NUM_PARTTWO];       //Ϣ
    BYTE    byRes2[2];
}NET_DVR_OPERATE_ARRAY_PARAM, *LPNET_DVR_OPERATE_ARRAY_PARAM;


#define INIT_QUICK                                      0    /*ٳʼ*/
#define INIT_FULLFOREGROUND                             1    /*ȫʼ(ǰ̨)*/
#define INIT_FULLBACKGROUND                             2    /*ȫʼ(̨)*/

typedef struct tagNET_DVR_OPERATE_VD_PARAM
{
    WORD    wArrayID;        // ID
    BYTE    bySlot;            // ָλ
    BYTE    byInitType;     // ʱʼ 0 - ٳʼ 1 - ǰ̨ȫʼ 2 - ̨ȫʼ
    DWORD    dwHCapacity;    // ̴С32λ
    DWORD    dwLCapacity;    // ̴С32λ
    BYTE    byName[MAX_NAMELEN]; // 
    BYTE    byRes2[16];          // ֽ 
}NET_DVR_OPERATE_VD_PARAM, *LPNET_DVR_OPERATE_VD_PARAM;


typedef struct tagNET_DVR_SPARE_DISK_PARAM
{
    WORD    wPDSlot;        // ̲λ
    WORD    wArrayID;       // 
    BYTE    bySpareType;    // ȱ 1-ȫȱ  2 ָ  ΪָеʱҪָеID
    BYTE    byRes[7];       // ֽ
}NET_DVR_SPARE_DISK_PARAM, *LPNET_DVR_SPARE_DISK_PARAM;

/********************************9000RH End****************************************/


#define MATRIX_MAXDECSUBSYSTEMCHAN    4//Ƶۺƽ̨ϵͳͨ

//ȡϵͳϢ
typedef struct tagNET_DVR_DECSUBSYSTEMJIONSTATUS
{
    BYTE    byJoinStatus;//״̬0-ûй1-Ѿ
    BYTE    byJoinSubSystem;//ϵͳλ
    BYTE    byJoinDispNum;//ʾͨ
    BYTE    byJoinSubWindowNum;//Ӵں
    BYTE    byRes[4];
}NET_DVR_DECSUBSYSTEMJIONSTATUS,LPNET_DVR_DECSUBSYSTEMJIONSTATUS;

typedef struct tagNET_DVR_SINGLESUBSYSTEMJOININFO
{
    BYTE    bySubSystemType;//ϵͳͣ0-ޣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ,5-ϵͳ6-ϵͳ
    BYTE    byConnectStatus;//ϵͳ״̬1-2-ӶϿ
    BYTE    byMatrixNum;//Ƶۺƽ̨ţϵͳ34ʱ
    BYTE    bySubSystemNum;//ϵͳλţ0~79ϵͳ34ʱ    
    NET_DVR_DECSUBSYSTEMJIONSTATUS struDecSub [MATRIX_MAXDECSUBSYSTEMCHAN];
    BYTE    byBindStatus;//״̬0-ûа󶨣1-Ѿ󶨣ƴʱõ
    BYTE    byRes[7];
}NET_DVR_SINGLESUBSYSTEMJOININFO,LPNET_DVR_SINGLESUBSYSTEMJOININFO;

typedef struct tagNET_DVR_ALLDECSUBSYSTEMJOININFO
{
    DWORD dwSize;
    NET_DVR_SINGLESUBSYSTEMJOININFO struSingleSubSystemJoinInfo[MAX_SUBSYSTEM_NUM];//80
    BYTE  byRes[8];
}NET_DVR_ALLDECSUBSYSTEMJOININFO, *LPNET_DVR_ALLDECSUBSYSTEMJOININFO;

//2010-04-13 NAT
typedef struct tagNET_DVR_NATASSOCIATECFG
{
    DWORD                  dwSize;
    NET_DVR_NETCFG_V30  struNatIpAddress[2];//NAT IPַ 
    BYTE                byNATEnable;//ǷNATܣ0-ã0-
    BYTE                  byRes[63];
}NET_DVR_NATASSOCIATECFG, *LPNET_DVR_NATASSOCIATECFG;

//2010-06-01 Ƶۺƽ̨
typedef struct tagNET_DVR_TEMPERATUREALARMCFG
{
    BYTE     byEnableTemperatureAlarm;//ʹ¶ȳޱ0-1-
    BYTE     byRes1[3];
    int      iTemperatureUpLimited;    //ȷСλ1234ʾ¶12.34
    int      iTemperatureDownLimited;    
    NET_DVR_HANDLEEXCEPTION_V30 struTempHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /*ʱ*/
    BYTE     byRes2[32];
}NET_DVR_TEMPERATUREALARMCFG, *LPNET_DVR_TEMPERATUREALARMCFG;

typedef struct tagNET_DVR_BOARDALARMCFG
{
    BYTE   byEnablePullAlarm;//Ȳαʹܣ1-0-
    BYTE   byRes1[3];
    NET_DVR_HANDLEEXCEPTION_V30 struBoardHandleType;    /* ʽ */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /*ʱ*/
    BYTE   byRes2[32];
}NET_DVR_BOARDALARMCFG, *LPNET_DVR_BOARDALARMCFG;


typedef struct tagNET_DVR_VIDEOPLATFORMALARMCFG
{
    DWORD                          dwSize;
    NET_DVR_TEMPERATUREALARMCFG  struTempAlarmCfg;    
    NET_DVR_BOARDALARMCFG          struBoardAlarmCfg;    
    NET_DVR_HANDLEEXCEPTION_V30  struHandleException[MAX_EXCEPTIONNUM];//0-쳣1-ϵͳ쳣2-IPַͻ3-߶ϣ4-Ƿʣ5-쳣6-ǰ쳣
    BYTE                         byRes[32];
}NET_DVR_VIDEOPLATFORMALARMCFG,*LPNET_DVR_VIDEOPLATFORMALARMCFG;
//2010-05-17
typedef struct  tagNET_DVR_CODESPLITTERASSOCIATE
{
    DWORD        dwSize;
    NET_DVR_IPADDR   struIP;  /*IPַ*/
    WORD        wPort;        //˿ں
    BYTE        byRes1[6];
    BYTE        sUserName[NAME_LEN];    /* û32 */
    BYTE        sPassword[PASSWD_LEN];    /* 16*/
    BYTE        byChan;//ͨ
    BYTE        byRes2[15];
} NET_DVR_CODESPLITTERASSOCIATE, *LPNET_DVR_CODESPLITTERASSOCIATE;

//2010-06-01 Ƶۺƽ̨ϴṹ
typedef struct tagNET_DVR_MATRIXSUBSYSTEMINFO
{
    BYTE   byMatrixNum;//Ƶۺƽ̨
    BYTE    bySubSystemNum;//ϵͳλ
    BYTE   byRes [14];
} NET_DVR_MATRIXSUBSYSTEMINFO, *LPNET_DVR_MATRIXSUBSYSTEMINFO;

typedef struct tagNET_DVR_VIDEOPLATFORM_ALRAMINFO
{
    DWORD  dwSize;      //ṹС
    BYTE   byAlarmType;    // 0-γӰ壬1-Ӱ,2-¶ȳޱ3-¶ȳޱ4-״̬쳣5-ϵͳ쳣,6-Ƿʣ7-쳣,8-ǰ쳣
    BYTE   byBoardNum;     //Ӱţ1B10ֶָ֧ΣЧΪ0xff
    BYTE   byRes1[2];
    BYTE   bySubSystemChan[8]; //Ӱλ,һӰ8ϵͳֱӦĲλţϵͳ쳣ʱbySubSystemChan[0]ʾӦϵͳ        
    int    iTemperature;  //¶ȳޱʱã¶ֵ
    BYTE   byMainboardSeq;//¶ȳޱʱã0-壬1-
    BYTE   byRes2[3];
    BYTE   byFanSequence[32];//쳣ȣbyFanSequence[i] = 1ʾi+1쳣byFanSequence[i] = 0ʾi+1    
    NET_DVR_MATRIXSUBSYSTEMINFO struInputNote;// 쳣ʱʹã
    NET_DVR_MATRIXSUBSYSTEMINFO struOutputNote;//쳣ʱʹã
    BYTE   byRes3[68];    
}NET_DVR_VIDEOPLATFORM_ALRAMINFO,*LPNET_DVR_VIDEOPLATFORM_ALRAMINFO;

/***************************ѶDVR begin *****************************/
#define MAX_INQUEST_PIP_NUM        3     //ͨʾĻлĿ
#define MAX_INQUEST_CDRW_NUM    4     //¼Ŀ
#define MAX_INQUEST_PIP_NUM_EX    16        //Ѷл

typedef struct 
{
    DWORD      dwSize;
    DWORD      dwNum;                       //¼
    DWORD      dwRwSelectPara[MAX_CHANNUM_V30];// Ƿѡиù
    DWORD      dwModeSelect;                //0ʾѭ¼ģʽ  1ʾп¼ģʽ(Ĭģʽ)
    BYTE       byRes[24];                   //
    DWORD       dwStartCDRW;                 //DVR Ѿʼ¼
    DWORD      dwHdExcp;                    //Ӳ 
    DWORD       dwInterval;                  //ʱ10(0)20(1)30(2)
    char        sLable[64];                  //
}NET_DVR_INQUEST_CDRW_CFG, *LPNET_DVR_INQUEST_CDRW_CFG;

typedef struct
{
    char      sFileName[36];             //ļ
    DWORD     dwFileLen;                 //ļ
}NET_DVR_INQUEST_FILEINFO, *LPNET_DVR_INQUEST_FILEINFO;

typedef struct 
{
    DWORD     dwFileNum;                     // Ҫ¼ɾļһ20
    NET_DVR_INQUEST_FILEINFO struFileInfo[MAX_RECORD_FILE_NUM];
    //ڱʾ¼ļʱʹ
    DWORD     dwCDIndex;                    //¼1:ѡ1ſ¼2:ѡ2ſ¼ 3:3ſ¼,4:4ſ¼,5:п¼
    DWORD      bFinalizeDisc;                 // 0=¼֮󲻷̣1=¼֮
}NET_DVR_INQUEST_FILES, *LPNET_DVR_INQUEST_FILES;

typedef struct 
{    
    DWORD     dwEnable;            //¼״̬ǷЧ,0-Ч,1-Ч    
                                DWORD     dwStatus;            /* dwType=0ʱ
                                                            0-1-޹̻쳣,
                                                            dwType=12ʱ
                                                            0-¼1-޹̻쳣
                                                            2-ѷ(81֧)3-̿ռ䲻㣬
                                                            4-쳣Ѷֹ(81֧)
                                                            dwType=3ʱ
                                                            0-¼1-޹̻쳣
                                                            2-ѷ(81֧)3-̿ռ䲻
                                                            dwType=4ʱ
                                                            0-¼1-޹̻쳣
                                                            2-ѷ(81֧)3-̿ռ䲻
                                                            dwType=5ʱ,
                                                            0- 1-޹̻쳣,
                                                            2-ѷ(81֧)
                                                            dwType=67ʱ,
                                                            0-¼, 1-޹̻쳣,
                                2-ѷ(81֧), 3-̿ռ䲻*/        
                                DWORD    dwVolumn;      //,λM
                                DWORD    dwFreeSpace;   //ʣ,λM    
                                DWORD    dwTimeLeft;     // ʣʱ䣬λ
                                BYTE          byCDType;         // 
                                BYTE       byRes[3];      //ֽ
}NET_DVR_INQUEST_CDRW, *LPNET_DVR_INQUEST_CDRW;

typedef struct 
{    
/*״̬0-Ѷʼ
1-Ѷп¼2-Ѷֹͣ
3-¼Ѷļ, 
4-(º󱸷ݺͱر)
5-
6-ʼӲ
    7-ָѶ*/
    DWORD    dwType;            
    NET_DVR_INQUEST_CDRW   strCDRWNum[MAX_INQUEST_CDRW_NUM];   //0ʾ¼1    
    NET_DVR_TIME_EX            struInquestStartTime;        //Ѷʼʱ
    BYTE                    byRes[16];             //
}NET_DVR_INQUEST_CDRW_STATUS, *LPNET_DVR_INQUEST_CDRW_STATUS;

typedef struct
{
    BYTE     byPipChan;              //лʾͨ 0xFFر
    BYTE     byRes[3];              //ֽ
    WORD     wTopLeftX;              //лx
    WORD     wTopLeftY;              //лY
}NET_DVR_INQUEST_PIP_PARAM, *LPNET_DVR_INQUEST_PIP_PARAM;

typedef struct 
{
    BYTE     byBaseChan;          //ʾлڵͨ
    BYTE     byBackChan;          //ʾлͨ
                                  BYTE     byPIPMode;           /*Ƿ, 
                                                                0 ǰС
                                                                1 ǰ1С
                                                                2 ǰ2С
                                                                3 ǰ3С
                                  */
                                  BYTE     byRes;               //ֽ
                                  NET_DVR_INQUEST_PIP_PARAM  strPipPara[MAX_INQUEST_PIP_NUM];  //λõĲ    
}NET_DVR_INQUEST_PIP_STATUS, *LPNET_DVR_INQUEST_PIP_STATUS;

//V40չлչΪ32
typedef struct tagNET_DVR_INQUEST_PIP_PARAM_V40
{
    BYTE     byPipChan;      /*лʾͨ 0xFFر*/ 
    BYTE     byRes1[3];
    WORD     wTopLeftX;         /*лx*/
    WORD     wTopLeftY;         /*лY*/
    WORD     wHeight;            /*лĸ */
    WORD     wWidth;            /*лĿ */
    BYTE     byRes2[32];
}NET_DVR_INQUEST_PIP_PARAM_V40, *LPNET_DVR_INQUEST_PIP_PARAM_V40;

typedef struct tagNET_DVR_INQUEST_PIP_STATUS_V40
{
    NET_DVR_STRUCTHEAD    struStructHead;
    BYTE             byBaseChan;     /*ʾлڵͨ*/
    BYTE             byBackChan;     /*ʾлͨ*/
                                    BYTE             byPIPMode;      /*Ƿ, 0 ǰС
                                                                    1 ǰ1С
                                                                    2 ǰ2С
                                                                    3 ǰ3С
                                                                    4 ǰ4С
                                                                    5 ǰ5С
                                                                    6 ǰ6С
                                                                    7 ǰ7С
                                                                    8 ǰ8С
                                                                    9 ǰ9С
                                    255  ǰڹرԤ*/
                                    BYTE                         byPipCount;          /*Сĸ*/
                                    BYTE                        byPicShowMode; /*ʾģʽ0-л1-2-ƴ*/
                                    BYTE                        byRes[31];        /**/
                                    NET_DVR_INQUEST_PIP_PARAM_V40     strPipPara[MAX_INQUEST_PIP_NUM_EX];  /*λõĲ*/
}NET_DVR_INQUEST_PIP_STATUS_V40, *LPNET_DVR_INQUEST_PIP_STATUS_V40;

typedef struct 
{
    BYTE    sSecretKey[16];        /*Կ*/
    BYTE    byRes[64];             /*ֽ*/
}NET_DVR_INQUEST_SECRET_INFO, *LPNET_DVR_INQUEST_SECRET_INFO;


/***************************ѶDVR end *****************************/


/********************************ӿڲṹ(end)*********************************/
#define        MAX_BIGSCREENNUM    100//ƴ

typedef struct tagNET_DVR_SINGLESCREENCFG
{
    BYTE    byScreenSeq;//Ļţ0xffʾô,64-Tһʾ
    BYTE    bySubSystemNum;//ϵͳλ,ֵû
    BYTE    byDispNum;//ϵͳ϶Ӧʾͨţ64-Tиֵʾʾͨ
    BYTE    byRes[9];
}NET_DVR_SINGLESCREENCFG, *LPNET_DVR_SINGLESCREENCFG;

typedef struct tagNET_DVR_BIGSCREENCFG
{
    DWORD   dwSize;
    BYTE    byEnable;//ƴʹܣ0-ʹܣ1-ʹ
    BYTE    byModeX;/*ƴģʽ*/
    BYTE    byModeY;
    BYTE    byMainDecodeSystem;//ۺƽ̨Ľиֵʾλţ64-Tиֵʾͨ
    BYTE    byMainDecoderDispChan;//ʾͨţ1.1netra汾netraʾܹͨΪ64-TиֵЧ
    BYTE    byVideoStandard;      //ÿʽͬ 1:NTSC,2:PAL
    BYTE    byRes1[2];
    DWORD  dwResolution;         //ÿֱͬ
    //ƴӴĻϢ
    NET_DVR_SINGLESCREENCFG struFollowSingleScreen[MAX_BIGSCREENNUM]; 
    //ʼΪ׼
    WORD    wBigScreenX; //ڵǽʼX
    WORD    wBigScreenY; //ڵǽʼY
    BYTE    byRes2[12];
}NET_DVR_BIGSCREENCFG, *LPNET_DVR_BIGSCREENCFG;


#define    DECODEPIC_LEFTADJUST            1        /*ͼ*/
#define    DECODEPIC_RIGHTADJUST            2        /*ͼ*/
#define    DECODEPIC_UPADJUST                3        /*ͼ*/
#define    DECODEPIC_DOWNADJUST            4        /*ͼ*/
#define    DECODEPIC_REDUCEADJUST            5        /*ͼС*/  
#define    DECODEPIC_FULL_SCREEN_ADJUST    6        /*ͼȫ*/
#define    DECODEPIC_CANCEL_FULL_SCREEN_ADJUST    7        /*ͼȡȫʾ*/   
#define DECODEPIC_AUTOADJUST           8        /*  ͼԶ */
#define DECODEPIC_HEIGHTADJUST         9       /* ͼ߶ȵ */
#define DECODEPIC_WIDTHADJUST             10       /* ͼȵ */

#define     MAX_UNITEDMATRIX_NUM        8//Ƶۺƽ̨
#define     MAX_SUBDOMAIN_NUM            4//
typedef struct tagNET_DVR_SUBSERVERINFO
{
    BYTE        bySequence;//ţţƵۺƽ̨ƽ̨ţ0ʾ޴ƽ̨\
    BYTE        byBelongSubDomain;//ƽ̨Чʾĸ
    BYTE        byRes1[6];
    DWORD       dwMaxIpcNums;//ӵIPC
    NET_DVR_IPADDR struSubMatrixIP;        /*IPַ*/
    WORD        wSubMatrixPort;        /*ϵͳ˿ں*/
    BYTE        byRes2[6];
}NET_DVR_SUBSERVERINFO, *LPNET_DVR_SUBSERVERINFO;

typedef struct tagNET_DVR_UNITEDMATRIXINFO
{
    DWORD dwSize;
    NET_DVR_SUBSERVERINFO struDomainInfo;
    NET_DVR_SUBSERVERINFO struSubDomainInfo[MAX_SUBDOMAIN_NUM];//Ϣ
    NET_DVR_SUBSERVERINFO struMatrixInfo[MAX_UNITEDMATRIX_NUM];//Ƶۺƽ̨Ϣ
    BYTE  byRes[32];
}NET_DVR_UNITEDMATRIXINFO, *LPNET_DVR_UNITEDMATRIXINFO;        

typedef struct tagNET_DVR_REGCALLBACKPARAM
{
    char sDeviceID[NAME_LEN];//豸ID
    char sPassword[PASSWD_LEN];
    BYTE sSerialNumber[SERIALNO_LEN]; /* 豸к */
    DWORD dwDeviceType;//豸
    BYTE nStatus;// ״̬0ߣ1ߣ
    /* net type, 0: unknow; 1: 2G wireless networks; 2: 3G wireless networks; 3: line networks */
    BYTE byNetType;    
    BYTE byRes[14];
}NET_DVR_REGCALLBACKPARAM, *LPNET_DVR_REGCALLBACKPARAM;

typedef struct tagNET_DVR_LOGONREPONSEPARAM
{
    //ʱλ, 5ı180ڡĬ15롣
    WORD wHeartbeatTime;
    BYTE byOvertimes;// 豸ʱĬ3
    BYTE byRes[13];    
}NET_DVR_LOGONREPONSEPARAM, *LPNET_DVR_LOGONREPONSEPARAM;


typedef struct tagNET_DVR_PREVIEWPARAM
{
    BYTE byTransProtol;        //Э飬0-TCP, 1-UDP
    BYTE byTransMode;        ///* ģʽ 0 1*/ 
    NET_DVR_IPADDR struCuIp; //CUIPַ
    WORD wPort;/*CU˿*/
    WORD wUdpPort;
    BYTE bySupportQos;//ǷQOS,1-ã0-
    //ǷNATԤ0-1-(ֻbyTransModeֶ)
    BYTE  byNatRequest;
    BYTE  byPreviewType;// 0-ͨԤ 1-ʱԤ
    BYTE  byRes[7];
}NET_DVR_PREVIEWPARAM, *LPNET_DVR_PREVIEWPARAM;
typedef struct tagNET_DVR_DEVICENATINFO
{
    NET_DVR_IPADDR struPuIp; //PUIPַ
    WORD    wOuterPort;/*PU˿*/
    WORD    wInterPort;//PUƵıض˿
    DWORD   nSessionID;//CMSsessionID
    BYTE    byRes[4];
}NET_DVR_DEVICENATINFO, *LPNET_DVR_DEVICENATINFO;


typedef struct tagNET_DVR_PREVIEWCALLBACKPARAM
{
    LONG lChannel;
    BYTE nLinkProtocol;
    BYTE nTransMode;
    BYTE byPreviewType; //0-ͨԤ 1-ʱԤ
    BYTE byRes[5];
    DWORD nSessionID;//CMSsessionID
}NET_DVR_PREVIEWCALLBACKPARAM, *LPNET_DVR_PREVIEWCALLBACKPARAM;

//ط
typedef struct tagNET_DVR_PLAYBACKREQUESTPARAM
{
    BYTE byPlayBackMode;        /* طģʽ 1 2ʱ */
    BYTE byRes1[3];
    union
    {
        char sFileName [100];        /* طŵļ */
        struct 
        {
            LONG    lChannel;                /*طŵͨ*/
            NET_DVR_TIME struStartTime;            /* ʱطŵĿʼʱ */
            NET_DVR_TIME struStopTime;            /* ʱطŵĽʱ */
            BYTE    byRes[48];
        }struPlayBackbyTime;
    }playbackmode;
    NET_DVR_IPADDR struCuIp; //CUIPַ
    WORD    wPort;/*CU˿*/
    BYTE    byRes2[2];
    DWORD   dwSessionID;//CMSsessionID,
    BYTE    byRes3[16];
}NET_DVR_PLAYBACKREQUESTPARAM, *LPNET_DVR_PLAYBACKREQUESTPARAM;    

//2010-10-06
typedef struct tagNET_DVR_PLAYBACKCALLBACKPARAM
{
    BYTE byPlayBackMode;        /* طģʽ 1 2ʱ */
    BYTE byRes1[3];
    union
    {
        char sFileName [100];        /* طŵļ */
        struct 
        {
            LONG        lChannel;                /*طŵͨ*/
            NET_DVR_TIME struStartTime;            /* ʱطŵĿʼʱ */
            NET_DVR_TIME struStopTime;            /* ʱطŵĽʱ */
            BYTE       byRes[48];
        }struPlayBackbyTime;
    }playbackmode;
    DWORD nSessionID;//CMSsessionID
    BYTE byRes2[44];
}NET_DVR_PLAYBACKCALLBACKPARAM, *LPNET_DVR_PLAYBACKCALLBACKPARAM;  

typedef struct tagNET_DVR_VOICEREQUESETPARAM
{
    BYTE    nVoiceChannel;        //Խͨ
    BYTE    byRes1[3];
    NET_DVR_IPADDR struCuIp; //CUIPַ
    WORD     wPort;/*CU˿*/
    BYTE    byRes2[10];
}NET_DVR_VOICEREQUESTPARAM, *LPNET_DVR_VOICEREQUESTPARAM;             

typedef struct tagNET_DVR_ALARMSETUPREQUESETPARAM
{
    NET_DVR_IPADDR struCuIp; //CUIPַ
    WORD     wPort;/*CU˿*/
    BYTE    byRes[2];
}NET_DVR_ALARMSETUPREQUESTPARAM, *LPNET_DVR_ALARMSETUPREQUESTPARAM;        

typedef struct tagNET_DVR_GPSALARMINFO
{
    BYTE byDeviceID[NAME_LEN];/*豸ID*/
    NET_DVR_TIME_EX struGpsTime;    /*GPSϴʱ*/
    DWORD    dwLongitude;    /* */
    DWORD    dwLatitude;  /* γ*/
    int     iTimeZone; /*ʱ÷ʾ+601+4808-60-4808ֶκGPSTimeһʱ*/ 
    DWORD dwDirection; /*=ʵʷԶΪλΪ˳ʱ뷽㣩*100*/
    WORD  wSatellites; /**/
    WORD  wPrecision; /**/
    DWORD dwHeight; /*߶:ףԤ*/
    DWORD dwGPSSeq; /*GPSţGPSʱҪõ*/
    WORD  wSpeed;//ٶȣλkm/h
    /* direction[0]:'E'or'W'(/), direction[1]:'N'or'S'(γ/γ)*/
    char sDirection[2]; 
    BYTE byLocateMode;/*λģʽ(ֵ0)1,λ,2,3,,4,Ч*/  
    BYTE byRes[3];
}NET_DVR_GPSALARMINFO, *LPNET_DVR_GPSALARMINFO;

//ͼƬϢϴ
typedef struct tagNET_DVR_PICINFO
{
    DWORD   dwSize;                //ṹ
    BYTE    byChanIndex;            //ͨ
    BYTE    byRes1[3];                //
    BYTE     byDeviceID[NAME_LEN];/*豸ID*/
    BYTE    byAbsTime[32];        //ʱ, yyyymmddhhmmssxxx,
    DWORD   dwPicLen;                    //ͼƬ
    BYTE    byRes2[32];
    BYTE    *pPicBuffer;
}NET_DVR_PICTUREINFO, *LPNET_DVR_PICTUREINFO;

//ƽ̨
typedef struct tagNET_DVR_CMSPARAM
{
    DWORD   dwSize;
    NET_DVR_IPADDR struCmsAddr;
    WORD   wCmsPort;
    BYTE   byRes1[2];
    BYTE   sDeviceID[NAME_LEN];
    BYTE   byPassword[PASSWD_LEN];
    NET_DVR_IPADDR struPicServerAddr;
    WORD   wPicServerPort;
    WORD   wCmsUdpPort;//CMSUDPѯĶ˿
    BYTE   byRes2[12];
}NET_DVR_CMSPARAM, *LPNET_DVR_CMSPARAM;

///Ź
#define DIALPASSWD_LEN  32 //볤

typedef struct tagNET_DVR_QOSPARAM
{
    WORD wMaxBitUL;    /* the maximum number of kbits/s in up-link traffic */
    WORD wMaxBitDL;    /* the maximum number of kbits/s in down-link traffic */
    BYTE byTrafficClass;    /* 0: conversationnal; 1: streaming; 2: interactive;3: background; 4: subscribed value(default) */
    BYTE byRes[7];
}NET_DVR_QOSPARAM, *LPNET_DVR_QOSPARAM;


typedef struct tagNET_DVR_PPPDPARAM
{
    BYTE byDialNum[NAME_LEN];        /* dial number, eg. "#777" */
    BYTE byUserName[NAME_LEN];    /* user name, eg. "card" */
    BYTE byPassword[DIALPASSWD_LEN];    /* password, eg. "card" */
    BYTE byApn[NAME_LEN];        /* access point name, eg. "cmnet" */
    NET_DVR_IPADDR struLocalIp;/* local IP address */
    NET_DVR_IPADDR struRemoteIp;/* remote IP address */
    WORD wMtuSize;        /* max transfer unit of ppp interface */
    BYTE byVerifyProtocal;    /* IPCP verify protocal: 0: auto; 1: CHAP; 2: PAP */
    BYTE byRes[25];    
}NET_DVR_PPPDPARAM, *LPNET_DVR_PPPDPARAM;

#define MAX_PHONE_NUM                32//볤

typedef struct tagNET_DVR_DIALPARAM
{
    DWORD dwSize;
    BYTE bEnable3G;        /* 0: disable; 1: enable 3g */
    BYTE byDialMethod;        /* dial methold: 0: auto dial; 1: manual dial; */
    BYTE bySwitchMethod;    /* switch methold: 0: auto switch;13Gȣ2: manual switch to 2G; 3: manual switch to 3G; */
    BYTE byEnaAlarmInDial;   /* ʹܱ봥; 0: disable; 1: enable */
    BYTE byRes1[10];
    WORD wOffLineTime;        /* auto off line when no connection exist,λӣΧ5~65535 */    
    NET_DVR_PPPDPARAM struPppdParam;
    NET_DVR_QOSPARAM struQosParam;
    BYTE byUimNumber[MAX_PHONE_NUM];
    BYTE byRes2[24];
}NET_DVR_DIALPARAM, *LPNET_DVR_DIALPARAM;

typedef struct tagNET_DVR_DIALREQUEST
{
    BYTE byConnNum;        /**/
    BYTE byNetType;        /* ָĳĬϲŲʱ˲ûá0Զ1CDMA2EVDO3WCDMA4TD-SCDMA */
    BYTE byRes[6];
} NET_DVR_DIALREQUEST, *LPNET_DVR_DIALREQUEST;


/* UIM card information */
typedef enum
{
    UIM_UNKNOWN = 0,
        UIM_VALID = 1,
        UIM_NOVALID = 4,
        UIM_ROAM = 11,
        UIM_NOEXIST = 255
}UIM_INFO;

/* real 3g mode */
typedef enum
{
    /* evdo */
    RMODE_CDMA1X = 12,
        RMODE_EVDO = 14,
        RMODE_CDMAHYBRID = 18,
        /* wcdma */
        RMODE_GSM = 21,
        RMODE_GPRS = 22,
        RMODE_EDGE = 23,
        RMODE_WCDMA = 24,
        RMODE_HSDPA = 25,
        RMODE_HSUPA = 26,
        RMODE_HSPA = 27,
        /* tdscdma */
        RMODE_TGSM = 31,
        RMODE_TGPRS = 32,
        RMODE_TEDGE = 33,
        RMODE_TDSCDMA = 34,
        RMODE_TDHSDPA = 35,
        RMODE_TDHSUPA = 36,
        RMODE_TDHSPA = 37
}REAL_MODE;

typedef struct tagNET_DVR_DIALSTATUS
{
    BYTE byRealMode;        /* REAL_MODE ,real 3g mode networks */
    BYTE byUimCard;        /* UIM_INFO ,UIM card information */
    BYTE byRes1[6];
    DWORD dwSignal;            /* signal RSSI */
    DWORD dwDialStatus;        /* dial status */
    NET_DVR_IPADDR struLocalIp;    /* wireless networks IP address */
    NET_DVR_IPADDR struRemoteIp;    /* wireless networks gateway */
    NET_DVR_IPADDR struNetMask;    /* wireless networks netmask */
    NET_DVR_IPADDR struDns;        /* wireless networks DNS */     
    BYTE  byRes2[16];
}NET_DVR_DIALSTATUS, *LPNET_DVR_DIALSTATUS;

//Ź
#define MAX_WHITELIST_NUM            8 //

#define HARDDISKFULL_EXCEPTION      0x0     /*Ӳ*/
#define HARDDISKERROR_EXCEPTION     0x1     /*Ӳ̴*/
#define ETHERNETBROKEN_EXCEPTION    0x2     /*߶*/
#define IPADDRCONFLICT_EXCEPTION    0x3     /*IPַͻ*/
#define ILLEGALACCESS_EXCEPTION     0x4     /*Ƿ*/
#define VI_EXCEPTION                0x5     /*Ƶź쳣*/
#define VS_MISMATCH_EXCEPTION       0x6     /*/Ƶʽƥ */
#define VIDEOCABLELOSE_EXCEPTION    0x7     /*Ƶź*/
#define AUDIOCABLELOSE_EXCEPTION    0x8     /*Ƶź*/
#define ALARMIN_EXCEPTION           0x9     /**/
#define MASKALARM_EXCEPTION         0xa     /*ڵ*/
#define MOTDET_EXCEPTION            0xb     /*ƶ*/
#define RECORDING_EXCEPTION         0xc     /*¼쳣*/
#define WIRELESS_EXCEPTION          0xd     /*PIR*/
#define PIR_EXCEPTION                0xe     /*߱*/
#define CALLHELP_EXCEPTION          0xf     /*ȱ*/

#define AUDIO_DETECTION_EXCEPTION              0x10    /*Ƶ쳣ⱨ*/
#define SCENECHANGE_DETECTION_EXCEPTION        0x11    /*ⱨ*/
#define DEFOCUS_DETECTION_EXCEPTION            0x12    /*齹ⱨ*/
#define FACE_DETECTION_ENTRANCE_EXCEPTION      0x13    /*ⱨ*/
#define LINE_DETECTION_ENTRANCE_EXCEPTION      0x14    /*Խⱨ*/
#define FIELD_DETECTION_ENTRANCE_EXCEPTION     0x15    /*ⱨ*/
#define REGION_EXITING_EXCEPTION               0x16    /*뿪ⱨ*/
#define REGION_ENTRANCE_EXCEPTION              0x17    /*򱨾*/
#define LOITERING_EXCEPTION                    0x18    /*Աǻⱨ*/
#define GROUP_EXCEPTION                        0x19    /*Աۼⱨ*/
#define RAPIDMOVE_EXCEPTION                    0x1a    /*ƶⱨ*/
#define PARKING_EXCEPTION                      0x1b    /*ͣⱨ*/
#define UNATTENDEDBAGGAGE_EXCEPTION            0x1c    /*Ʒⱨ*/
#define ATTENDEDBAGGAGE_EXCEPTION              0x1d    /*Ʒȡⱨ*/


#define PHONECFG_RECEIVE_SMS        0x0    /* ֽ֧ձ */
#define PHONECFG_SMS_CONTROL        0x1    /* ֶ֧ſ */
#define PHONECFG_CALL_CONTROL       0x2    /* ֺ֧п */
#define PHONECFG_SMS_REBOOT         0x3    /*ֶ֧*/
#define PHONECFG_DOOR_CONTROL       0x4    /* ֧Ų*/

typedef struct tagNET_DVR_PHONECFG
{
    BYTE byWhiteList[MAX_PHONE_NUM];
    BYTE byPhonePerssion[32]; /*ֽڱʾǷʹܸúĳܣλĺ
    PHONECFG_RECEIVE_SMSȶ */
    BYTE byAlarmHandler[32];   /*ֽڱʾǷʹܶĳ͵Ķŷ*/
    BYTE byRes[128];
} NET_DVR_PHONECFG, *LPNET_DVR_PHONECFG;

typedef struct tagNET_DVR_SMSRELATIVEPARAM
{
    DWORD dwSize;
    BYTE bEnableSmsAlarm;    /* 0: disable; 1: enable 3g */
    BYTE byRes1[7];
    NET_DVR_PHONECFG struWhiteList[MAX_WHITELIST_NUM];
    BYTE byRes2[32];
}NET_DVR_SMSRELATIVEPARAM, *LPNET_DVR_SMSRELATIVEPARAM;


typedef struct tagNET_DVR_SMSLISTINFO
{
    DWORD  dwSize;
    DWORD dwTotalSmsNum;//
    BYTE  byRes[8];
    BYTE  *pSmsParam;
    DWORD dwBufLen;//ָ볤ȣ
}NET_DVR_SMSLISTINFO, *LPNET_DVR_SMSLISTINFO;

typedef struct tagNET_DVR_SMSPARAM
{
    DWORD dwIndex;            /* the index of sms */
    BYTE byStatus;            /* read yet or not */
    BYTE byRes[7];
    NET_DVR_TIME_EX struRecvTime;        /* sms receive time */
}NET_DVR_SMSPARAM, *LPNET_DVR_SMSPARAM;

#define    MAX_SMSCONTENT_LEN        140//ݳ
typedef struct tagNET_DVR_SMSCONTENT
{
    BYTE byPhoneNum[MAX_PHONE_NUM];
    BYTE byMsg[MAX_SMSCONTENT_LEN];
}NET_DVR_SMSCONTENT, *LPNET_DVR_SMSCONTENT;     

//pin
typedef enum
{
    CPIN_READY = 1,
        CPIN_PIN = 2,
        CPIN_PUK = 3,
        CPIN_PIN2 = 4,
        CPIN_PUK2 = 5
}PIN_READY;

typedef struct tagNET_DVR_PINSTATUS
{
    DWORD dwSize;
    BYTE byStatus;        /* PIN status, defination see enum: PIN_READY */
    BYTE byPinTimes;    /* remain input PIN times */
    BYTE byPukTimes;    /* remain input PUK times */    
    BYTE bEnableLock;    /* now the PIN locking function is enabled or not: 0, not enabled lock; 1, lock enabled */
    BYTE byRes[4];
}NET_DVR_PINSTATUS, *LPNET_DVR_PINSTATUS;

typedef enum
{
    PIN_ENABLE = 1,
        PIN_DISABLE = 2,
        PIN_VERIFY = 3,
        PUK_VERIFY = 4,
        PIN_CHANGE = 5
}PIN_CMD;
#define MAX_PIN_LEN        12  //PIN󳤶
typedef struct tagNET_DVR_PINCODEPARAM
{
    DWORD dwSize;
    BYTE byPinCmd;        /* PIN command, defination see enum: PIN_CMD */
    BYTE byRes1[3];
    BYTE byPinCode[MAX_PIN_LEN];        /* pin/puk code */
    BYTE byNewPinCode[MAX_PIN_LEN];    /* new pin code */
    BYTE byRes2[16];
}NET_DVR_PINCODEPARAM, *LPNET_DVR_PINCODEPARAM;


//ͼƬ
typedef struct 
{
    /* 0=CIF, 1=QCIF, 2=D1 3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA*/
    WORD    wPicSize;
    WORD    wPicQuality; /* ͼƬϵ 0- 1-Ϻ 2-һ */
    //ץͼͼƬʽ1-ϴģ2-豸ر棬3-ϴͬʱ豸ر
    BYTE    byPicTackleMode; 
    BYTE   byRes[11];
}NET_DVR_PUSHJPEGPARA, *LPNET_DVR_PUSHJPEGPARA;


#define    COM_PUSHALARM        0x1200    //豸Ϣϴģʽ豸ʹ
#define    COM_PUSHALARM_V30    0x1201    //豸Ϣϴv30ģʽ豸ʹ
typedef struct tagNET_DVR_PUSHALARMINFO
{
    DWORD dwAlarmType;/*0-ź,1-Ӳ,2-źŶʧ,3ƶ,4Ӳδʽ,5-дӲ̳,6-ڵ,7-ʽƥ, 8-Ƿ*/
    DWORD dwAlarmInputNumber;/*˿*/
    DWORD dwAlarmOutputNumber[MAX_ALARMOUT];/*˿ڣһλΪ1ʾӦһ*/
    DWORD dwAlarmRelateChannel[MAX_CHANNUM];/*¼ͨһλΪ1ʾӦһ·¼, dwAlarmRelateChannel[0]Ӧ1ͨ*/
    DWORD dwChannel[MAX_CHANNUM];/*dwAlarmTypeΪ23,6ʱʾĸͨdwChannel[0]Ӧ1ͨ*/
    DWORD dwDiskNumber[MAX_DISKNUM];/*dwAlarmTypeΪ1,4,5ʱ,ʾĸӲ, dwDiskNumber[0]λӦ1Ӳ*/
    BYTE byDeviceID[NAME_LEN];/*豸ID*/
    BYTE byRes[4];
}NET_DVR_PUSHALARMINFO, *LPNET_DVR_PUSHALARMINFO;

typedef struct 
{
    DWORD dwAlarmType;/*0-ź,1-Ӳ,2-źŶʧ,3ƶ,4Ӳδʽ,5-дӲ̳,6-ڵ,7-ʽƥ, 8-Ƿ, 9-Ƶź쳣10-¼쳣 11- ܳ仯  12-쳣 */
    DWORD dwAlarmInputNumber;/*˿*/
    BYTE byAlarmOutputNumber[MAX_ALARMOUT_V30];/*˿ڣΪ1ʾӦ*/
    BYTE byAlarmRelateChannel[MAX_CHANNUM_V30];/*¼ͨΪ1ʾӦ¼, dwAlarmRelateChannel[0]Ӧ1ͨ*/
    BYTE byChannel[MAX_CHANNUM_V30];/*dwAlarmTypeΪ23,6910ʱʾĸͨdwChannel[0]Ӧ1ͨ*/
    BYTE byDiskNumber[MAX_DISKNUM_V30];/*dwAlarmTypeΪ1,4,5ʱ,ʾĸӲ, dwDiskNumber[0]Ӧ1Ӳ*/
    BYTE byDeviceID[NAME_LEN];/*豸ID*/
    BYTE byRes[7];
}NET_DVR_PUSHALARMINFO_V30, *LPNET_DVR_PUSHALARMINFO_V30;

//2011-04-20
//
typedef struct tagNET_DVR_MB_AUTOWORKPARA
{
    /*ǰƷʽ 0:  Ԥ,  1:  ʱػ,  2:  Զػ*/
    BYTE    byCurPowerCtrlType;   
    BYTE    byRes[3];
    NET_DVR_SCHEDTIME    struWorkTime[MAX_DAYS][2];    
}NET_DVR_MB_AUTOWORKPARA, *LPNET_DVR_MB_AUTOWORKPARA;

typedef struct tagNET_DVR_MB_POWERCTRLPARA
{
    DWORD    dwSize;
    DWORD     dwHaltDelay; /* ػӳʱ,λmin */
    NET_DVR_MB_AUTOWORKPARA  struAutoWorkPara;/*ز*/
    BYTE       byEnableUnderVoltProtect;   /*ǷǷѹ*/
    BYTE       byUnderVoltPercent;   /*Ƿѹٷֱȣ859095Чֵ*/
    BYTE       byRes[34];
}NET_DVR_MB_POWERCTRLPARA, *LPNET_DVR_MB_POWERCTRLPARA;
/*ע1ػӳʱ, ѡʱΪ 05ӣ10 20 25 30 35 40 45  50 60 60*2 60*3  60 *4   60*5  60*6 */

//Զ
typedef struct tagNET_DVR_MB_AUTOBACKUPPARA
{
    DWORD dwSize;
    BYTE  byEnableAutoBackup; /* ǷԶ 0 ر 1  */
    BYTE  byRes1[3];
    BYTE  byBackupChannel[MAX_CHANNUM_V30];     /*Ҫݵͨ*/
    BYTE  byBackupDays[MAX_CHANNUM_V30];/**/
                                        /* ļ 
                                        {0,ALL_RECORD_TYPE,ȫ},
                                        {1,TIMING_REC,ʱ},
                                        {2,MOTION_DETECT_REC,ƶ },
                                        {3,ALARM_REC, },
    {4,MANUAL_REC,ֶ¼}*/
    BYTE  byBackupFileType[MAX_CHANNUM_V30];
    NET_DVR_SCHEDTIME struBackupTime[MAX_CHANNUM_V30][2];    /* Զʱ*/                
    BYTE  byRes2[36];                        /* ֽ*/
}NET_DVR_MB_AUTOBACKUPPARA, *LPNET_DVR_MB_AUTOBACKUPPARA;


typedef struct tagNET_DVR_MB_GPSPARA
{
    DWORD dwSize;
    BYTE  byEnableGPS;    /*ǷGPS */
    BYTE  byGpsInterface;/*gpsսӿ0-rs232, 1-rs485, 2-frontpanel, 3-lcd */
    BYTE  bySpeedUnit;  /*ٶȵλ0/Сʱ1 Ӣ/Сʱ*/
    BYTE  byEnableRetrieve; /* ä(1ã0) */
    int      iAdjustTime;/*ʱ*/
    BYTE  byEnableAdjustTime;/*ǷGPSУʱ 1-, 0-*/
    BYTE  byRes1[5];
    WORD  wGpsUploadInterval;    /* GPSϴ, */
    BYTE  byGpsOsdChannel[MAX_CHANNUM_V30];/*OSD ʾÿֽڴһ· */
    DWORD dwSpeedLimit;    /* ٱ*/
    NET_DVR_HANDLEEXCEPTION_V30  struGpsAlarm; 
    BYTE  byRes2[36];
}NET_DVR_MB_GPSPARA, *LPNET_DVR_MB_GPSPARA;
/*ע1λΪ/Сʱ ʱΧΪ0 ,965Ӣ/Сʱλʱ ٶȷΧΪ0-600*/

#define         SENSOR_IN_NUMBER          8
typedef struct tagNET_DVR_MB_SENSORINPARA
{
    DWORD dwSize;
    BYTE  byTriggerType[SENSOR_IN_NUMBER];/*г״̬شֻú4ֱɲתת0-ߵƽ1-͵ƽ*/
    BYTE  byTriggerChannel [SENSOR_IN_NUMBER];
    BYTE  byOsdDisplay [MAX_CHANNUM_V30];/*OSDʾ,ÿλһ·*/
    BYTE  byRes[32];
}NET_DVR_MB_SENSORINPARA, *LPNET_DVR_MB_SENSORINPARA;


typedef struct tagNET_DVR_ACCELERATIONCFG
{
    DWORD    dwMaxXAcc;    /* Xٶȱֵ ȡֵΪʵֵ10,СΪ0*/
    DWORD    dwMaxYAcc;    /* Yٶȱֵ ȡֵΪʵֵ10.СΪ0*/
    DWORD    dwMaxZAcc;    /* Zٶȱֵ ȡֵΪʵֵ10,СΪ0*/
    BYTE    byRes[4];
}NET_DVR_ACCELERATIONCFG,*LPNET_DVR_ACCERATIONCFG;

typedef struct tagNET_DVR_GSENSORPARA
{
    DWORD dwSize;
    NET_DVR_ACCELERATIONCFG struAccelerationCfg;
    BYTE  byModuleSelect;/*ģѡ0/1*/
    BYTE  byRes1[3];
    NET_DVR_HANDLEEXCEPTION_V30 struHandleException;
    BYTE  byRes2[24];    /*չֽ*/
}NET_DVR_GSENSORPARA, *LPNET_DVR_GSENSORPARA;

typedef struct tagNET_DVR_MB_DOWNLOADSVRPARA
{
    DWORD dwSize;
    NET_DVR_IPADDR    struDownloadSvrIp;        /* Զطַ */
    BYTE  byRes[64];
}NET_DVR_MB_DOWNLOADSVRPARA,*LPNET_DVR_MB_DOWNLOADSVRPARA;

/* ʶز*/
typedef struct tagNET_DVR_PLATERECOG_PARA
{
    DWORD dwSize;
    BYTE byPrMode; /* ʶģʽ, ̬ͼ0/̬Ƶ1 */
    BYTE byPrScene; /* ʶĳ, ٳ0/ٳ1 */
    BYTE byPrDetRect; /* 0:ȫĻ;1: */
    BYTE byPrPicQuality; /* ʶ𷵻صͼƬ, 0:/3: */    
    BYTE byPrPicMode;/*ʶ𷵻صͼƬֱ: JPEG_MODE_D1, JPEG_MODE_CIF, JPEG_MODE_QCIF */
    BYTE byPlateOsdDisplay; /* OSDǷʾ 0:ʾ/1:ʾ */
    BYTE byPrProvCharIndex;    /* ʶʡ׺ֶӦ */
    BYTE byPrProvCharIndex1;    /* ʶ𳣼׺1Ӧ */
    BYTE byPrProvCharIndex2;    /* ʶ𳣼׺2Ӧ */
    BYTE byRes[7];
}NET_DVR_PLATERECOG_PARA, *LPNET_DVR_PLATERECOG_PARA;


/* ̬ȡ֤ϵͳ,òĽṹ*/
typedef struct tagNET_DVR_SPEEDLMT_PARA
{
    BYTE    bStartMaxSpeedLimit;        /*  */
    BYTE    bStartMinSpeedLimit;        /*  */
    BYTE    byRes[6];
    DWORD    dwMaxSpeedLimit;                /*  */
    DWORD    dwMinSpeedLimit;                /*  */
}NET_DVR_SPEEDLMT_PARA, *LPNET_DVR_SPEEDLMT_PARA;

/* ̬ȡ֤ϵͳ,ƱȶԲĽṹ*/
typedef struct tagNET_DVR_PLATECHECK_PARA
{
    BYTE    bAlarmWhenChecked;            /* ɹǷ񱨾 */
    BYTE    bInformWhenChecked;            /* ɹǷԻʾ */
    BYTE    byRes[6];
    NET_DVR_IPADDR struBlackFtpServer;            /* FTPַ */
}NET_DVR_PLATECHECK_PARA, *LPNET_DVR_PLATECHECK_PARA;

typedef struct tagNET_DVR_ENFORCESYS_PARA
{
    DWORD dwSize;
    NET_DVR_SPEEDLMT_PARA    struSpeedLmtPara;    /**/
    NET_DVR_PLATECHECK_PARA struPlateCheckPara;    /*Ʊȶ*/
    BYTE    bySelPeccType;    /*ǷѡΥ*/
    BYTE    byEnfOptHabit; /*ȡ֤ϰ, 0:ȡ֤;1:̰ȡ֤*/
                           /*Ԥ֡ʵģʽ֣
                           A ر adjPrevFpsMode=0
                           Թ̶֡(25FPS)Ԥ
                           B ׼ adjPrevFpsMode=1
                           Թ̶֡(6FPS)Ԥ
                           C Ӧ adjPrevFpsMode=2
                           GPSٶϢ̬Ԥ֡ʣ
    3ЧGPS£Թ̶֡Ԥ*/
    BYTE    byAdjPrevFpsMode;        
    BYTE    byRes1;
    NET_DVR_IPADDR  struUploadServerIp; //ϴַ
    WORD    wUploadServerPort;
    BYTE    byRes2[18];
}NET_DVR_ENFORCESYS_PARA, *LPNET_DVR_ENFORCESYS_PARA;

typedef struct tagNET_DVR_PUSHMODEPARAM
{
    //ֱģʽUDPԤģʽ1-ͬ˿ڶ·2-һ˿һ·
    BYTE byUdpPreviewMode; 
    //Խģʽ0-Խ1-תSDKĲɼͲţ
    BYTE byVoiceWorkMode; 
    BYTE byRes[18];    
}NET_DVR_PUSHMODEPARAM, *LPNET_DVR_PUSHMODEPARAM;

#define MAX_ALARMHOST_ALARMIN_NUM            512//籨󱨾
#define MAX_ALARMHOST_ALARMOUT_NUM            512//籨󱨾

#define ALARMHOST_MAX_AUDIOOUT_NUM            32//籨
#define ALARMHOST_MAX_ELECTROLOCK_NUM        32//籨
#define ALARMHOST_MAX_MOBILEGATE_NUM        32//籨ƶ
#define ALARMHOST_MAX_SIREN_NUM             8 // 󾯺Ŀ
#define MAX_ALARMHOST_SUBSYSTEM             32//ϵͳ

//
typedef enum tagSENSOR_TYPE
{
    SENSOR_TYPE_NONE = 0,                   // 
        SENSOR_TYPE_TEMPERATURE = 1,            // ¶
        SENSOR_TYPE_HUMIDITY ,                  // ʪ
        SENSOR_TYPE_WINDSPEED,                  // 
        SENSOR_TYPE_GAS,                        // 
        SENSOR_AC_VOLTAGE,                      // ѹ
        SENSOR_AC_CURRENT,                      // 
        SENSOR_DC_VOLTAGE,                      // ֱѹ
        SENSOR_DC_CURRENT,                      // ֱ
        SENSOR_WATER_PRESSURE,                  // ˮѹ
        SENSOR_PRESSURE_TRANSMITTER,            // ѹ
        SENSOR_FLOW_TRANSMITTER,                // 
        SENSOR_WATER_LEAKAGE,                   // ©ˮ
        SENSOR_INTERGRATED_TEMPERATURE_DETECTOR,//һ廯±
        SENSOR_ISOLATION_TEMPERATURE_DETECTOR,  //ʽ±
        SENSOR_RESIDUAL_CHLORINE,               //
        SENSOR_TYPE_AC_TERMINAL = 16,           //AC              
        SENSOR_TYPE_AC_SOCKET = 17,             //AC
        SENSOR_TYPE_UNKNOW = 255                // δ
}SENSOR_TYPE;

typedef struct tagNET_DVR_SENSOR_INFO
{
    DWORD  dwSize;                 // ṹС
    BYTE    byName[NAME_LEN];    // 
    BYTE    byEnable;               // Ƿ 
    BYTE    byValid;                // ǷЧ (òֻܻȡܸ)
    BYTE    byType;                 // ģ SENSOR_TYPE
    BYTE    byAlarmMode;//ģʽ֣15-HHHH14-HHHL12-HHLL8HLLL0-LLLL1111ϣ1110£1100£1000()0000()
    float   fMeasureHigh;           // 
    float   fMeasureLow;            // 
    float    fAlarm1;           //1,1-4 
    float    fAlarm2;           //2
    float    fAlarm3;           //3
    float    fAlarm4;           //4
    DWORD   dwOsdCfg;          //ģַӣλʾ0-15ӦƵͨ1-16
    float    fSensitive;            // ȱʾʵʱֵı仯ȵķΧʱʾʵʱֵ˱仯Ϊûз仯磺Ϊ0.1ʾǰֵ֮0.1ʱΪݷ仯0.1ҪϴΪ1ʾ仯1ʱϱ
    BYTE    bySensorStandard;    //0- 0~20mA1, 0~5V
    BYTE    byChan;            //ģͨ
    BYTE    byRes3[114];            // ֽ
}NET_DVR_SENSOR_INFO, *LPNET_DVR_SENSOR_INFO;

typedef struct tagNET_DVR_SIREN_PARAM
{
    DWORD   dwSize;                    // ṹС
    BYTE    byName[NAME_LEN];        // 
    WORD    wDelay;                    // ӳ λΪ, Χ 0~5599s 0ʾһֱ
    BYTE    byRes1[2];
    DWORD   dwOverallEventJointSirenOn;        //ȫ¼¼Ͱλʾbit0-, bit1-ȫּ̽,bit2-ϵ磬bit3-صѹ,bit4-绰ߵ,bit5-쳣,bit6-쳣,  bit7-485
    DWORD    dwSubsystemEventJointSirenOn[MAX_ALARMHOST_SUBSYSTEM/*32*/];//ϵͳ¼±ʾϵͳţÿһԪذλʾ¼ͣbit0-
    BYTE    byRes2[448];  // ֽڡ
}NET_DVR_SIREN_PARAM, *LPNET_DVR_SIREN_PARAM;

typedef struct tagNET_DVR_AIR_CONDITION_PARAM
{
    DWORD    dwSize;        // ṹС
    BYTE    byEnable;    // 0--ػ 1--
    BYTE    byMode;        // յģʽ
    BYTE    byTemperature;    // ¶ȣֵʾ ͨΪ16-30
    BYTE    byRes[9];        // ֽ
}NET_DVR_AIR_CONDITION_PARAM, *LPNET_DVR_AIR_CONDITION_PARAM;

typedef enum tagDETECTOR_TYPE
{
    PANIC_BUTTON = 0,               // 
        MAGNETIC_CONTACT,               // Ŵſ
        SMOKE_DETECTOR,                 // ̸̽
        ACTIVE_INFRARED_DETECTOR,       // ̽
        PASSIVE_INFRARED_DETECTOR,      // ̽
        GLASS_BREAK_DETECTOR,           // ̽
        VIBRATION_DETECTOR,             // ̽
        DUAL_TECHNOLOGY_PIR_DETECTOR,   // ˫ƶ̽
        TRIPLE_TECHNOLOGY_PIR_DETECTOR, // ̽
        HUMIDITY_DETECTOR,              // ʪ̽
        TEMPERATURE_DETECTOR,           // ¸̽
        COMBUSTIBLE_GAS_DETECTOR,        // ȼ̽
        DYNAMIC_SWITCH,                    //涯
        CONTROL_SWITCH,                    //ƿ
        SMART_LOCK,                        //
        OTHER_DETECTOR = 0xffff          // ̽   
}DETECTOR_TYPE;

typedef struct tagNET_DVR_ALARMIN_PARAM
{
    DWORD   dwSize;
    BYTE    byName[NAME_LEN];
    WORD    wDetectorType; // DETECTOR_TYPE
    BYTE    byType;     //ͣ0:ʱ,1-24Сʱ,2-ʱ ,3-ڲ4-Կ׷ 5-𾯷 6-ܽ 7-24Сʱ  8-24Сʱ9-24Сʱ𶯷 0xff-
    BYTE    byUploadAlarmRecoveryReport;    //Ƿϴָ棬0-ϴ1-ϴ        
    DWORD    dwParam;    //   ʱʱ೤ʱ, бʱʱͨ , ÷ʽͨеbySupportAlarmInDelayֶ
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT];/*ʱʱ*/
    BYTE    byAssociateAlarmOut[MAX_ALARMHOST_ALARMOUT_NUM];  // 
    BYTE    byAssociateSirenOut[8];        //   0 ʾ1 ֵΪ1ʾ 0 ʾ
    BYTE    bySensitivityParam;//Ȳ, 0-10ms1-250ms2-500ms3-750ms
    BYTE    byArrayBypass;//Ƿ·,0-֧·,1-֧·
    BYTE    byJointSubSystem; //ϵͳţòֻܻȡ  
    BYTE    byModuleStatus;    //ģ״̬ 1- 2-
    WORD    wModuleAddress;    //ģַչģ0~2550xFFFFʾЧ
    BYTE    byModuleChan;    //ģͨţ1ʼֵģ0xFFʾЧ
    BYTE    byModuleType;    //ģͣ1-ط2-3-˫4-85-8·ģ, 6-
    WORD    wZoneIndex;        //ţòֻܻȡ      
    WORD    wInDelay;    //ʱ0-255
    WORD    wOutDelay;    //˳ʱ0-255
    BYTE    byAlarmType;     // 0-Ч1-2-
    BYTE    byZoneResistor;    //裬λǧŷ  0-Ч 1--2.2 2--3.33--4.74--5.6  5--8.2 0xff-Զ
    float    fZoneResistorManual;/*ֶ裬1.0-10.0ȷСһλλǧŷbyZoneResistorΪ0xffʱЧ*/
    BYTE    byRes2[32];      // ֽ
}NET_DVR_ALARMIN_PARAM, *LPNET_DVR_ALARMIN_PARAM;

typedef struct tagNET_DVR_ALARMOUT_PARAM
{
    DWORD   dwSize;             // ṹС
    BYTE    byName[NAME_LEN];   // 
    WORD    wDelay;             // ӳ λs, Χ0~3599s 0 ʾһֱ
    WORD    wTriggerIndex;        //ţòֻܻȡ
    BYTE    byAssociateAlarmIn[MAX_ALARMHOST_ALARMIN_NUM];   //ʾŸıͨ ͬʱһ±0ʾ1 0- 1-
    BYTE    byModuleType;    //Ӵͣ1-ش 2-4·3-8· 4-5-32·
    BYTE    byModuleStatus;    //Ӵ״̬ 1- 2-
    WORD    wModuleAddress;    //Ӵַչģ0~2550xFFFFʾЧ
    BYTE    byModuleChan;    //Ӵͨţ1ʼֵģ0xFFʾЧ
    BYTE    byWorkMode;        //ģʽ1-2-涯
    BYTE    byAlarmOutMode;    //ģʽ1-ģʽ2-ģʽ
    BYTE    byTimeOn;        //ʱ 1~60s
    BYTE    byTimeOff;        //ʱ 1~60s
    BYTE       byRes2[51];             //ֽ
}NET_DVR_ALARMOUT_PARAM, *LPNET_DVR_ALARMOUT_PARAM;

typedef struct tagNET_DVR_ALARMIN_SETUP
{
    BYTE byAssiciateAlarmIn[MAX_ALARMHOST_ALARMIN_NUM];//ͨ ±0Ӧ1
    BYTE byRes[100];//ֽ
}NET_DVR_ALARMIN_SETUP, *LPNET_DVR_ALARMIN_SETUP;

typedef struct tagNET_DVR_ALARMHOST_MAIN_STATUS
{
    DWORD  dwSize; 
    BYTE   bySetupAlarmStatus[MAX_ALARMHOST_ALARMIN_NUM];//ڲ״̬(֧512ڲѯ)0-Ӧڴڳ״̬1-Ӧڴڲ״̬
    BYTE   byAlarmInStatus[MAX_ALARMHOST_ALARMIN_NUM];//ڱ״̬(֧512ڲѯ)0-Ӧڵǰޱ1-Ӧڵǰб
    BYTE   byAlarmOutStatus[MAX_ALARMHOST_ALARMOUT_NUM];//״̬(֧512ڲѯ)0-Ӧޱ1-Ӧб
    BYTE   byBypassStatus[MAX_ALARMHOST_ALARMIN_NUM];  // ·״̬ ±ʾ0Ӧ1 0-ʾû· 1-ʾ·
    BYTE   bySubSystemGuardStatus[MAX_ALARMHOST_SUBSYSTEM]; //ϵͳ״̬,0-Ӧϵͳڳ״̬1-Ӧϵͳڲ״̬
    BYTE   byAlarmInFaultStatus[MAX_ALARMHOST_ALARMIN_NUM];//ڹ״̬0-Ӧڴ״̬1-Ӧڴڹ״̬
    BYTE   byRes[56];      //  ֽ
}NET_DVR_ALARMHOST_MAIN_STATUS, *LPNET_DVR_ALARMHOST_MAIN_STATUS;

typedef struct tagNET_DVR_ALARMHOST_MAIN_STATUS_V40
{
    DWORD  dwSize; 
    BYTE   bySetupAlarmStatus[MAX_ALARMHOST_ALARMIN_NUM];//״̬(֧512ѯ)0-Ӧڳ״̬1-Ӧڲ״̬
    BYTE   byAlarmInStatus[MAX_ALARMHOST_ALARMIN_NUM];//״̬(֧512ѯ)0-Ӧǰޱ1-Ӧǰб
    BYTE   byAlarmOutStatus[MAX_ALARMHOST_ALARMOUT_NUM];//״̬(֧512ѯ)0-Ӧޱ1-Ӧб
    BYTE   byBypassStatus[MAX_ALARMHOST_ALARMIN_NUM];  // ·״̬ ±ʾ0Ӧ1 0-ʾû· 1-ʾ·
    BYTE   bySubSystemGuardStatus[MAX_ALARMHOST_SUBSYSTEM/*32*/]; //ϵͳ״̬,0-Ӧϵͳڳ״̬1-Ӧϵͳڲ״̬
    BYTE   byAlarmInFaultStatus[MAX_ALARMHOST_ALARMIN_NUM];//״̬0-Ӧ״̬1-Ӧڹ״̬
    BYTE   byAlarmInMemoryStatus[MAX_ALARMHOST_ALARMIN_NUM];//״̬ 0-Ӧǰޱ1-Ӧǰб0xffffff
    BYTE   byAlarmInTamperStatus[MAX_ALARMHOST_ALARMIN_NUM]; // ״̬0-Ӧޱ1-Ӧб
    BYTE   byEnableSubSystem[MAX_ALARMHOST_SUBSYSTEM/*32*/]; //ϵͳ״̬0-Ч1-Ӧϵͳδã2-Ӧϵͳ
    BYTE   bySubSystemGuardType[MAX_ALARMHOST_SUBSYSTEM];/* 0-Ч1-2-ʱ3-ز*/
    BYTE   byRes[448];      //  ֽ
}NET_DVR_ALARMHOST_MAIN_STATUS_V40, *LPNET_DVR_ALARMHOST_MAIN_STATUS_V40;

typedef struct tagNET_DVR_ALARMHOST_OTHER_STATUS
{
    DWORD  dwSize;
    BYTE   bySirenStatus[ALARMHOST_MAX_SIREN_NUM];    // ״̬ 0-Ŵޱ״̬1-Ŵб״̬
    BYTE   byRes[92];             // ֽ
}NET_DVR_ALARMHOST_OTHER_STATUS, *LPNET_DVR_ALARMHOST_OTHER_STATUS;

//ʹ״̬
typedef struct tagNET_DVR_ALARMHOST_ENABLECFG
{
    DWORD dwSize;
    BYTE  byAudioOutEnable[ALARMHOST_MAX_AUDIOOUT_NUM];//ʹܣ0-ܣ1-ʹ
    BYTE  byElectroLockEnable[ALARMHOST_MAX_ELECTROLOCK_NUM];//ʹܣ0-ܣ1-ʹ
    BYTE  byMobileGateEnable[ALARMHOST_MAX_MOBILEGATE_NUM];//ƶʹܣ0-ܣ1-ʹ
    BYTE  bySirenEnable[ALARMHOST_MAX_SIREN_NUM];//ʹܣ 0-ܣ1-ʹ
    BYTE  bySerialPurpose;//;0-ڼ1-PTZ
    BYTE  byRes[63];    
}NET_DVR_ALARMHOST_ENABLECFG, *LPNET_DVR_ALARMHOST_ENABLECFG;

typedef struct tagNET_DVR_ALARMHOST_ABILITY
{
    DWORD   dwSize;                      // ṹС
    WORD    wTotalAlarmInNum;         // (),
    WORD    wLocalAlarmInNum;         // ر
    WORD    wExpandAlarmInNum;        // չı
    WORD    wTotalAlarmOutNum;        //  豸ֵ֧
    WORD    wLocalAlarmOutNum;        // رڸ
    WORD    wExpandAlarmOutNum;       // չı
    WORD    wTotalRs485Num;           //  豸ֵ֧
    WORD    wLocalRs485Num;           // 485
    WORD    wExpandRs485Num;          // չ485
    WORD    wFullDuplexRs485Num;    // ȫ˫485
    WORD    wTotalSensorNum;          // ģ (豸ֵ֧)
    WORD    wLocalSensorNum;        // ģ
    WORD    wExpandSensorNum;         // չģ
    WORD    wAudioOutNum;                //
    WORD    wGatewayNum;            //Ž
    WORD    wElectroLockNum;            //
    WORD    wSirenNum;                 // Ŀ
    WORD    wSubSystemNum;            // ɻϵͳĿ
    WORD    wNetUserNum;            // û
    WORD    wKeyboardNum;           // 
    WORD    wOperatorUserNum;           // û
    BYTE    bySupportDetector;//Ƿֳ֧̽1-֧֣0-֧
    BYTE    bySupportSensitivity;//Ƿַ֧ȣ1-֧֣0-֧
    BYTE    bySupportArrayBypass;//Ƿ֧·1-֧֣0-֧
    BYTE    bySupportAlarmInDelay;//Ƿַ֧ӳ,1-֧֣0-֧
    //bySupportAlarmInDelayΪ1ʱʾͻӦʹNET_DVR_ALARMIN_PARAM еdwParamʱʱ䣬бʹʱʽ;
    //bySupportAlarmInDelayΪ0ʱʾͨNET_DVR_ALARMSUBSYSTEMPARAM еwEnterDelay wExitDelay 
    BYTE    bySupportAlarmInType[16];//ֵ֧ķ,0:ʱ,1-24Сʱ,2-ʱ ,3-ڲ4-Կ׷ 5-𾯷 6-ܽ 7-24Сʱ 15-
    BYTE    byTelNum;        //ֵ֧绰
    BYTE    byCenterGroupNum;    //
    BYTE    byGPRSNum;        //GPRS4
    BYTE    byNetNum;        //4
    BYTE    byAudioNum;        //Ƶ
    BYTE    by3GNum;        //3Gģ
    BYTE    byAnalogVideoChanNum;        //ģƵͨ
    BYTE    byDigitalVideoChanNum;        //Ƶͨ
    BYTE    bySubSystemArmType;        //ϵͳͣ0-ʾ֧֣1-ʾ֧֡bit0-ͨעСֻ֧ͨмֶεʱСѾСиֶΪ00ʾ֧֣1ʾ֧֡ӿSDKڲݣbit1-ʱbit2-ز    
    BYTE    byPublicSubSystemNum;    //ϵͳ
    DWORD    dwSupport1;    //λʾ0ʾ֧֣0ʾ֧
    // bit0:     Ƿ֧ϵͳþʱ䣬֧򾯺ʱÿϵͳã֧֣ʱھŲ
    // bit1:    Ƿ֧¼
    // bit2:    Ƿ֧¼ر
    // bit3:    Ƿ֧ϵͳʹ
    // bit4;    Ƿַ֧
    // bit5;    Ƿ֧ϵͳԶ
    // bit6:    Ƿ֧־Ϲ
    // bit7:    Ƿֹ֧״̬ѯ
    // bit8:    Ƿ֧ϵͳչ
    // bit9:    Ƿ֧Կ׷ϵͳ
    // bit10:   Ƿ֧"ʾɹͱ"
    // bit11:   Ƿֵ֧뵼
    // bit12:   Ƿ֧LEDĻ
    // bit13: Ƿֹ֧Ϲعϵ
    DWORD    dwSubSystemEvent;        //ϵͳ¼λʾ0ʾ֧֣0ʾ֧,bit0-ʱbit1-˳ʱbit2-bit3-bit4-bit5-
    DWORD    dwOverallEvent;            //ȫ¼λʾ0ʾ֧֣0ʾ֧֣bit0-磬bit1-صѹͣbit2-绰ߵߣbit3-쳣bit4-쳣
    DWORD    dwFaultType;            //豸ֵ֧Ĺͣbit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-̵ߣbit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣    
    BYTE    byPublicSubsystemAssociateSubsystemNum;    //ϵͳɹϵͳ
    BYTE    byOverallKeyboard;    //ȫ̸ּ
    WORD    wSafetyCabinSupport; //տλʾ0ʾ֧֣0ʾ֧    
    //bit0: Ƿַ֧տģʽ
    //bit1: Ƿ֧źŴ
    //bit2: Ƿ֧Ļã̽ӳʱ䡢״̬仯Ӧʱ䣩
    //bit3: Ƿֺ֧䴫ã˲
    //bit4: Ƿַ֧ʹóʱʱ
    BYTE    by485SlotNum;        //485λ
    BYTE    bySubSystemAttributeAbility;  // ֵΪ1ֹ1ϵͳرʹ
    WORD    wKeyboardAddrNum;      // ̵ַ
    BYTE    byRes[118];            //  ֽ
}NET_DVR_ALARMHOST_ABILITY, *LPNET_DVR_ALARMHOST_ABILITY;

#define MAX_485CHAN                256    //485ͨ
#define MAX_485SLOT                256    //485λ
typedef struct tagNET_DVR_485_SLOT_LIST_INFO
{
    DWORD        dwSize;
    BYTE        byAll;    //0-ȫȡ1-ȫȡ
    BYTE        byres[3];
    BYTE        byIndex[MAX_485SLOT];            //485λ
    BYTE           byRes[64];      //
}NET_DVR_485_SLOT_LIST_INFO,* LPNET_DVR_485_SLOT_LIST_INFO;

typedef struct tagNET_DVR_485LIST_INFO
{
    DWORD        dwSize;
    BYTE        byAll;    //0-ȫȡ1-ȫȡ
    BYTE        byres[3];
    BYTE        byIndex[MAX_485CHAN];            //485ͨ ±ʾͨţֵ0-ʾʹã1ʾʹ
    BYTE       byRes[64];      //
}NET_DVR_485LIST_INFO,*LPNET_DVR_485LIST_INFO;

typedef struct tagNET_DVR_ALARM_RS485CFG
{
    DWORD   dwSize;                 // ṹС
    BYTE    sDeviceName[NAME_LEN];  // ǰ豸 
    WORD    wDeviceType;            // ǰ豸,ͨNET_DVR_GetDeviceTypeListȡ
    WORD    wDeviceProtocol;        // ǰ豸Э ͨȡЭбȡ    
    DWORD   dwBaudRate;             //(bps)0-501-752-1103-1504-3005-6006-12007-24008-48009-960010-1920011-3840012-5760013-7680014-115.2k 
    BYTE    byDataBit;              // мλ0-5λ1-6λ2-7λ3-8λ 
    BYTE    byStopBit;              // ֹͣλ0-1λ1-2λ 
    BYTE    byParity;               //ǷУ飺0-У飬1-У飬2-żУ 
    BYTE    byFlowcontrol;           // Ƿأ0-ޣ1-,2-Ӳ 
    BYTE    byDuplex;                // 0 - ˫1- ȫ˫  ֻͨ1ȫ˫ֻǰ˫
    BYTE    byWorkMode;                // ģʽ 0-̨ 1-͸ͨ,2-ݿأ3-,0xfe-Զ壬0xff-
    BYTE    byChannel;                //485ͨ
    BYTE    bySerialType;            //: 0--485, 1--232
    BYTE    byMode;                 //ģʽ 0-Ӷ 1-ӿͻ 2-չģ
    BYTE    byRes[35];              // ֽ
}NET_DVR_ALARM_RS485CFG, *LPNET_DVR_ALARM_RS485CFG;

#define MAX_DEVICE_PROTO_NUM       256
#define MAX_DEVICE_TYPE_NUM            256

// 485ǰ豸֧Эб
typedef struct tagNET_DVR_DEVICE_PROTO_LIST
{
    DWORD   dwSize;             // ṹС
    DWORD   dwProtoNum;         // Э
    NET_DVR_PROTO_TYPE struProtoType[MAX_DEVICE_PROTO_NUM];  // Э
    BYTE    byRes[12];          // ֽ
}NET_DVR_DEVICE_PROTO_LIST, *LPNET_DVR_DEVICE_PROTO_LIST;

typedef struct tagNET_DVR_DEVICE_TYPE
{
    DWORD    dwType;
    BYTE    byDescribe[DESC_LEN];
}NET_DVR_DEVICE_TYPE, *LPNET_DVR_DEVICE_TYPE;

typedef struct tagNET_DVR_DEVICE_TYPE_LIST
{
    DWORD    dwSize;                // ṹС
    DWORD    dwTypeNum;            // ͸
    NET_DVR_DEVICE_TYPE struDeviceType[MAX_DEVICE_TYPE_NUM];
    BYTE    byRes[12];
}NET_DVR_DEVICE_TYPE_LIST, *LPNET_DVR_DEVICE_TYPE_LIST;

#define    MAX_ALARMHOST_VIDEO_CHAN    64
typedef struct tagNET_DVR_ALARM_DEVICE_USER
{
    DWORD  dwSize;                 // ṹС
    BYTE   sUserName[NAME_LEN];    // û
    BYTE   sPassword[PASSWD_LEN];    // 
    NET_DVR_IPADDR    struUserIP;                    /* ûIPַ(Ϊ0ʱʾκεַ) */
    BYTE   byMACAddr[MACADDR_LEN];            /* ַ */
    BYTE   byUserType; // 0-ͨû 1-Աû
    BYTE   byAlarmOnRight;         // Ȩ
    BYTE   byAlarmOffRight;        // Ȩ
    BYTE   byBypassRight;          // ·Ȩ
    BYTE   byOtherRight[MAX_RIGHT];  // Ȩ
    // 0 -- ־Ȩ
    // 1 -- ػ
    // 2 -- Ȩ
    // 3 --    ȡȨ
    // 4 -- ָĬϲȨ
    // 5 -- Ȩ
    // 6 -- PTZ Ȩ
    // 7 -- ԶȨ
    // 8 -- ԶԤ
    // 9 -- Զֶ¼
    // 10 -- Զ̻ط
    BYTE    byNetPreviewRight[MAX_ALARMHOST_VIDEO_CHAN/8];    // Զ̿Ԥͨλʾͨbit0-channel 11-Ȩޣ0-Ȩ
    BYTE    byNetRecordRight[MAX_ALARMHOST_VIDEO_CHAN/8];    // Զ̿¼ͨλʾͨbit0-channel 11-Ȩޣ0-Ȩ
    BYTE    byNetPlaybackRight[MAX_ALARMHOST_VIDEO_CHAN/8]; // Զ̿Իطŵͨλʾͨbit0-channel 11-Ȩޣ0-Ȩ
    BYTE    byNetPTZRight[MAX_ALARMHOST_VIDEO_CHAN/8];        // Զ̿PTZͨλʾͨbit0-channel 11-Ȩޣ0-Ȩ
    //BYTE    byPriority;                                        // ȼ0xff-ޣ0--ͣ1--У2--
    //ޣʾ֧ȼã
    //ͣĬȨޣԶ̻طţԶ̲鿴־״̬Զ̹ػ/
    //УԶ̨̿Զֶ¼Զ̻طţԽԶԤرݣ/Զ̹ػ/
    //ߣԱ
    BYTE    byRes2[168];              // ֽ
}NET_DVR_ALARM_DEVICE_USER, *LPNET_DVR_ALARM_DEVICE_USER;

typedef struct tagNET_DVR_KEYBOARD_USER
{
    DWORD     dwSize;     // ṹС
    DWORD    dwID;        // ûID
    BYTE    byDefanceArea[MAX_ALARMHOST_ALARMIN_NUM]; //Ȩ  ±ʾ ֧512 0 - Ȩ 1- Ȩ
    BYTE    byRes[560];        // ֽ
}NET_DVR_KEYBOARD_USER, *LPNET_DVR_KEYBOARD_USER;

typedef struct tagNET_DVR_OPERATE_USER
{
    DWORD     dwSize;        // ṹС
    BYTE    sUserName[NAME_LEN];    // û
    BYTE    sPassword[PASSWD_LEN];  // 
                                    BYTE   bySubSystemPermission;/*0-װԱȨ ԱȨޣϵͳ£ 1-޲棬· 2-޳棬· 3-޲棬· 
                                                                 4-в//棬· 5-г棬· 6-в棬·  7-޲棬· 
                                                                 8-޲棬· 9-޲棬· 10-в棬· 11-г棬· 1
                                    2-в棬·*/
                                    BYTE    byRes[63];             //  ֽ
}NET_DVR_OPERATE_USER, *LPNET_DVR_OPERATE_USER;

typedef struct tagNET_DVR_GATEWAY_CFG
{
    DWORD    dwSize;        // ṹС
    BYTE    byName[NAME_LEN];    //  Ž    
    BYTE    byEnable;    // Ƿ
    BYTE    byLocalEnable;  //  Ƿ
    WORD    wDelayTime;    // ʱʱ    λΪ0-65535 0Ϊһֱ
    BYTE    byLockWorkMode;//ģʽ0-ͨ1-ϵ
    BYTE    byRes[31];    // ֽ
}NET_DVR_GATEWAY_CFG, *LPNET_DVR_GATEWAY_CFG;

typedef struct tagNET_DVR_SENSOR_ALARM
{
    DWORD   dwSize;                // ṹС
    DWORD   dwAbsTime;            // ʱϢ  OSDʾϢ
    BYTE    byName[NAME_LEN];     // sensor 
    BYTE    bySensorChannel;    // ģͨ
    BYTE    byType;             // ģ
    BYTE    byAlarmType;        // 1-42-33-24-15-16-27-38-4 ͵ǰģʽй
    // 統Ϊ1000ʱ,1123ֱ
    BYTE    byAlarmMode;        //ģʽ֣-HHHH-HHHL-HHLLHLLL-LLLL Ϊƽ̶̨жϹ,1111ϣ1110£1100£1000()0000() 
    float    fValue;                // ǰģֵ
    BYTE    byRes2[32];            // ֽ
}NET_DVR_SENSOR_ALARM, *LPNET_DVR_SENSOR_ALARM;

typedef struct 
{
    /*ԤĿǰıû(򣬼)*/
    DWORD  dwAlarmType;             
    /*0Ӧ1˿*/
    BYTE   byAlarmInputNumber[MAX_ALARMHOST_ALARMIN_NUM];
    BYTE    byRes[160];
}NET_DVR_ALARMHOST_ALARMINFO,*LPNET_DVR_ALARMHOST_ALARMINFO;
// ϴ
typedef struct tagNET_DVR_SWITCH_ALARM
{
    DWORD dwSize;
    BYTE   byName[NAME_LEN];     // switch 
    WORD  wSwitchChannel;     // ͨ, 0-255
    BYTE    byAlarmType;        //  0--1--·2--·,3-쳣 
    BYTE     byRes[41];            // ֽ
}NET_DVR_SWITCH_ALARM, *LPNET_DVR_SWITCH_ALARM;

typedef union tagNET_DVR_ALARMHOST_EXCEPTION_PARAM
{
    DWORD   dwUnionSize[20];        // С    
}NET_DVR_ALARMHOST_EXCEPTION_PARAM, *LPNET_DVR_ALARMHOST_EXCEPTION_PARAM;

typedef struct tagNET_DVR_ALARMHOST_EXCEPTION_ALARM
{
    DWORD   dwSize;             // ṹС
    // 쳣  1-豸𱨾 2-豸ָ 3-Դ籨 4-Դָ 5-ڲͨŹϱ 
    // 6-ڲͨŹϺָ  7-绰߶ 8-绰߶߻ָ 9-Լʧܱ  10-Լʧָܺ    
    // 11Ƿѹ  12صѹָ13-عϣ14-MBUSģߣ15-MBUSģ߻ָ16-̵ߣ
    //17-̵߻ָ18-豸ƶ19-豸ƶλ  20-485·ϱ  21-485·Ϻָ
    //25-Ӱ1,26-Ӱ1γ, 27-Ӱ2,28-Ӱ2γ
    DWORD   dwExceptionType;    
    BYTE   byRes[36];          // 
}NET_DVR_ALARMHOST_EXCEPTION_ALARM, *LPNET_DVR_ALARMHOST_EXCEPTION_ALARM;

//вŲü÷ʽ
#define MAX_CENTERNUM            4        //G1,G2 G3 G4N1N2N3N4T1T2T3T4
typedef struct tagNET_DVR_PHONECENTERDIALCFG
{
    BYTE sCenterName[NAME_LEN];
    BYTE byPhoneNum[MAX_PHONE_NUM/*32*/];  //ĺ  
    BYTE byRepeatCall;          //ظŴ1~15
    BYTE byPstnProtocol;        //ͨЭ飬0-CID
    BYTE byDialDelay;           //ʱ150s, 0-150
    BYTE byPstnTransMode;       //䷽ʽ0-DTMF 5/S1-DTMF 10/S
    BYTE byRes1[6];
    BYTE byReceiverId[6];         //ջʶ˺ţ
    BYTE byRes2[32];
}NET_DVR_PHONECENTERDIALCFG, *LPNET_DVR_PHONECENTERDIALCFG;

typedef struct tagNET_DVR_ALARMHOSTDIALCFG
{
    DWORD dwSize;
    NET_DVR_PHONECENTERDIALCFG struPhoneCenterParam[MAX_CENTERNUM];//Ĳ
    WORD wReportPeriod;      //ԱϴڣСʱֵ֧7죬168Сʱ), Χ1-168
    WORD wFirstReportTime;     //豸һԱϴ1~3600
    BYTE  byReportValid;    //0-òԱϴ 1-òԱϴ
    BYTE  byRes[19];
}NET_DVR_ALARMHOSTDIALCFG, *LPNET_DVR_ALARMHOSTDIALCFG;

typedef struct tagNET_DVR_ALARMHOSTDIALSETUPMODE
{
    DWORD dwSize;
    BYTE byEnableMode;//÷ʽ0ã1һֱã2:߶ãʱرգ
    BYTE byCallType; //ϴķʽ1-ģ2-˫ģ3һһ
    BYTE byRes1[14];
}NET_DVR_ALARMHOSTDIALSETUPMODE, *LPNET_DVR_ALARMHOSTDIALSETUPMODE;

#define  MAX_PU_CHAN_NUM    512

typedef struct tagNET_DVR_PU_CHAN_INFO
{
    NET_DVR_IPADDR  struIpAddr;     // ipַ
    WORD            wPort;          // ˿
    WORD            wChannel;       // ͨ     
    BYTE            byRes[24];      // 
}NET_DVR_PU_CHAN_INFO, *LPNET_DVR_PU_CHAN_INFO;

typedef struct tagNET_DVR_PU_CHAN_LIST
{
    DWORD   dwSize;     // ṹ
    DWORD   dwNum;      // ǰͨ
    NET_DVR_PU_CHAN_INFO struPuChanInfo[MAX_PU_CHAN_NUM];
}NET_DVR_PU_CHAN_LIST, *LPNET_DVR_PU_CHAN_LIST;

#define  MAX_ALARM_CAM_NUM    32        // CAM

typedef struct tagNET_DVR_PTZ_CTRL
{
    BYTE    byEnable;   // ǷPTZ
    BYTE    byType;     // PTZ Ƶ 1- Ԥõ 2 -Ѳ  3-켣
    BYTE    byPtzNo;    //  ptz ƵԤõ Ѳ 켣
    BYTE    byRes[5];    // ֽ
}NET_DVR_PTZ_CTRL, *LPNET_DVR_PTZ_CTRL;

typedef struct tagNET_DVR_ALARM_CAM_INFO
{
    DWORD            dwCamID;      // CAMͨ
    DWORD           dwRecordTime;   // ¼ʱ λΪs  -1ʾһֱ¼ 0 ʾ¼
    DWORD           dwMonID;      // CamMonʾ
    DWORD           dwResidentTime; // Ѳͣʱ䵥λΪs  -1ʾһֱͣ 0 ʾͣ
    NET_DVR_PTZ_CTRL struPtzCtrl;    // PTZϢ
    BYTE            byAlarmOffMode;        // лǽȡģʽ   0-ȡ1-Զȡ2-ֶȡ ȡȡʱȡǽ   ԶȡȡʱȴһʱȡǽԼ20  ֶȡûֶͨķʽȡ
    BYTE            byDevType;        // 豸Ϊ豸ʱЧʾܱ豸ȡԴ 1-뿨     2-뿨
    BYTE            byDecChan;        // ΪͨΪͨ
    BYTE            byRes[17];      // ֽ
}NET_DVR_ALARM_CAM_INFO, *LPNET_DVR_ALARM_CAM_INFO;

typedef struct tagNET_DVR_ALARM_CAM_CFG
{
    DWORD        dwSize;            // ṹС
    BYTE        byEnable;       // ǷñCAM 豸Ĭϲ
    BYTE        byRes[7];       // ֽ
    DWORD        dwNum;            // CAMĸ ȡǰЧ  
    NET_DVR_ALARM_CAM_INFO struAlarmCam[MAX_ALARM_CAM_NUM];
}NET_DVR_ALARM_CAM_CFG, *LPNET_DVR_ALARM_CAM_CFG;

#define MAX_GATEWAY_NUM         8  // Ž
typedef struct tagNET_DVR_ALARMHOST_AUDIO_ASSOCIATE_ALARM
{
    DWORD         dwSize;
    BYTE        byEnterDoor[8];    // ±ʾŽţԪֵʾϢ0ʾ 1-8ʾƵ
    BYTE        byExitDoor[8];     // ±ʾŽţԪֵʾϢ0ʾ 1-8ʾƵ
    BYTE         byAlarmIn[MAX_ALARMHOST_ALARMIN_NUM/*512*/];  //룬±ʾţԪֵʾϢ0ʾ 1-8ʾƵ
    BYTE         byRes[128];
}NET_DVR_ALARMHOST_AUDIO_ASSOCIATE_ALARM, *LPNET_DVR_ALARMHOST_AUDIO_ASSOCIATE_ALARM;

//ϴأϴصչ
typedef struct tagNET_DVR_UPLOAD_PARAM
{
    DWORD         dwSize;
    BYTE        byUploadType;    /*ϴʽ1-ļԵַȡļϴ 2-ӻȡϴ*/
    BYTE        byDataType;        //ͣ1-Ƶ
    BYTE        byDataNum;        //ݱţ磺ϴòʾţһţʱʾ
    BYTE        byAudioType;        //ʽ0-wave
    char        sFileName[260];        //ļȫ·
    char        *lpBuffer;            //ݻ
    DWORD        dwBufferSize;        //С
    BYTE        byRes2[128];
}NET_DVR_UPLOAD_PARAM, *LPNET_DVR_UPLOAD_PARAM;

typedef void (CALLBACK *DATADOWNLOAD)(LONG nDownloadHandle, DWORD dwDataType, void* pBuffer, DWORD dwBufSize, void *pUser);
typedef struct tagNET_DVR_ALARMHOST_PARAM
{
    DWORD         dwSize;
    BYTE        byDownType;        /*صݱ淽ʽ1-ļԵַݣ 2-ͨصȡ*/
    BYTE        byDataType;        //ͣ1-Ƶ
    BYTE        byDataNum;        //ݱţ磺òʾţһţʱʾ
    BYTE        byRes1;
    char        sFileName[260];        //ļȫ·
    DATADOWNLOAD lpDataCallBack; //ʱĻص
    void*        pUserData;    //ûݣڻصд
    BYTE        byRes2[128];
}NET_DVR_DOWNLOAD_PARAM, *LPNET_DVR_DOWNLOAD_PARAM;


typedef struct tagNET_DVR_ALARMHOST_DOWNLOAD_PARAM
{
    DWORD         dwSize;
    BYTE        byDownType;        /*صݱ淽ʽ1-ļԵַݣ 2-ͨصȡ*/
    BYTE        byDataType;        //ͣ1-Ƶ
    BYTE        byDataNum;        //ݱţ磺òʾţһţʱʾ
    BYTE        byRes1;
    char        sFileName[260];        //ļȫ·
    DATADOWNLOAD lpDataCallBack; //ʱĻص
    void*        pUserData;    //ûݣڻصд
    BYTE        byRes2[128];
}NET_DVR_ALARMHOST_DOWNLOAD_PARAM, *LPNET_DVR_ALARMHOST_DOWNLOAD_PARAM;

//LEDĻ
typedef  struct tagNET_DVR_LED_SCREEN_CFG
{
    DWORD         dwSize;
    BYTE        sLEDName[NAME_LEN/*32*/];    // LEDĻ
    BYTE        byTransMode;                 // ִֻ֧ͨѶ 1-ͨ
    BYTE        byProtocolType;                // ЭͣӦLEDĳ
    BYTE        byLEDColor;                 // 1-ɫ 2-˫ɫ 3-256Ҷ˫ɫ 4- ȫɫĿǰֻõɫ
    BYTE        byDataPolarity;                // ݼ .0-1-
    BYTE        byOEPolarity;                // 0-Ч 1-Ч
    BYTE        byScanMode;                 // 1-1/16,  2-1/8,  3-1/4,  4-1/2,  5-̬
    BYTE        byRes1[2];
    //ĻȺ͸߶С16*16㣬8    
    WORD        wLEDWidth;                     // 16~2048
    WORD         wLEDHeight;                    // 16~2048
    BYTE        byRes2[64];
}NET_DVR_LED_SCREEN_CFG, *LPNET_DVR_LED_SCREEN_CFG;

//LED
#define  MAX_CONTENT_LEN  512
typedef  struct tagNET_DVR_LED_CONTENT_CFG
{
    DWORD         dwSize;
    BYTE        sLEDContent[MAX_CONTENT_LEN];    // LEDĻʾ
    BYTE        byContentAct;                    // 1-̬2-ٴ3-ƶ4-ƶ 5-ƶ 6-ƶ
    BYTE        byContentSpeed;                    // 1-241죬24    
    BYTE        byContentStayTime;                 // 0-127.5s(0.5s SDKʱ*2ֵ0-255豸ʹõʱ2)
    BYTE        byRes[33];
}NET_DVR_LED_CONTENT_CFG, *LPNET_DVR_LED_CONTENT_CFG;

//LEDʱػ
#define     LED_TIMER_NUM             3            // LEDػʱ
#define        TIME_SEGMENT_A_DAY        48            // ʱθһ24СʱСʱһ

typedef struct tagNET_DVR_SWITCH_TIME
{
    BYTE    byValid;                // 鶨ʱʱǷЧʱǳɶõ
    BYTE    byRes[3];
    NET_DVR_TIME_EX struTimeOn;     // ʱ
    NET_DVR_TIME_EX struTimeOff;     // ػʱ
}NET_DVR_SWITCH_TIME, *LPNET_DVR_SWITCH_TIME;


typedef struct tagNET_DVR_LED_SWITCH_TIME
{
    DWORD        dwSize;
    NET_DVR_SWITCH_TIME struTimer[LED_TIMER_NUM /*3*/];         //ʱػʱ䣬ṹֻСʱͷЧÿ鿪ʱҪڸĹػʱ䣬ǰһĹػʱҪ磺struTimer[0]Ĺػʱ1000ôstruTimer[0]ĿʱΪ10:00֮ǰ struTimer[1]ĿʱΪ10:00Ժ
    BYTE        byRes[64];
}NET_DVR_LED_SWITCH_TIME, *LPNET_DVR_LED_SWITCH_TIME;

//ʱȵ
typedef struct tagNET_DVR_LED_BRIGHTNESS_STEP
{
    DWORD         dwSize;
    BYTE        byValid;        //ʱȵǷЧ
    BYTE        byRes1[3];
    BYTE         byBrightnessStep[TIME_SEGMENT_A_DAY /*48*/];     //ȫ24СʱΪ48ʱΣÿ30һʱΣ48ֽڱʾÿʱεȼȹ160~15ʾ
    BYTE        byRes2[48];
}NET_DVR_LED_BRIGHTNESS_STEP, *LPNET_DVR_LED_BRIGHTNESS_STEP;

typedef struct tagNET_DVR_LED_STATUS
{
    DWORD    dwSize;
    BYTE    bySwitchState;        //1-״̬ 2-ػ״̬
    BYTE    byBrightness;        //ֵΧ0-15
    BYTE    byRes[62];
}NET_DVR_LED_STATUS, *LPNET_DVR_LED_STATUS;

//2010-12-28 뿨 begin
//µĽ뿨
#define        MAX_DECODE_CARD_NUM            6   //뿨
/********************뿨ģʽ궨********************/
typedef enum _HD_DISPLAY_FORMAT
{
    HD_DISPLAY_FORMAT_INVALID = 0x00000000,
        HD_DISPLAY_FORMAT_CVBS = 0x00000001,
        HD_DISPLAY_FORMAT_DVI = 0x00000002,
        HD_DISPLAY_FORMAT_VGA = 0x00000004, 
        HD_DISPLAY_FORMAT_HDMI = 0x00000008, 
        HD_DISPLAY_FORMAT_YPbPr = 0x00000010
}HD_DISPLAY_FORMAT,*LPHD_DISPLAY_FORMAT;

/********************뿨ģʽ궨********************/
typedef struct tagNET_DVR_DECCARD_ABILITY      /*뿨*/
{
    BYTE byCardType;      //뿨(0:MD,1:MD+,2:HD)
    BYTE byDecNums;      //ͨ
    BYTE byDispNums;      //ʾͨ
    BYTE byDecStartIdx;     //׸ͨнͨе
    BYTE byDispStartIdx;     //׸ʾͨʾͨе
    BYTE byDispResolution[80]; //ģʽֵ֧ķֱ
    BYTE byDispFormat[8];     //ֵ֧ģʽ(HD_DISPLAY_FORMAT)
    BYTE byWindowMode[4][8]; //ֵ֧Ĵģʽ(1,2,4,9,16))
    BYTE byRes[35];
} NET_DVR_DECCARD_ABILITY,*LPNET_DVR_DECCARD_ABILITY;

typedef struct tagNET_DVR_DECODESVR_ABILITY
{
    DWORD dwSize;      /* ṹС */
    BYTE byCardNums;      /* 뿨 */
    BYTE byStartChan;     /* ʼͨ */
    BYTE byRes1[2];
    NET_DVR_DECCARD_ABILITY struDecCardAbility[MAX_DECODE_CARD_NUM];
    BYTE byRes2[64];
}NET_DVR_DECODESVR_ABILITY, *LPNET_DVR_DECODESVR_ABILITY;

typedef struct tagNET_MATRIX_DEV_CHAN_INFO
{
    NET_DVR_IPADDR     struIP;            //DVR IPַ
    WORD     wDVRPort;                 //˿ں
    BYTE     byChannel;                //ͨ
    BYTE    byTransProtocol;        //Э0-TCP1-UDP
    BYTE    byTransMode;            //ģʽ 0 1
    BYTE    byFactoryType;            /*ǰ豸,ͨӿڻȡ*/
    BYTE    byUsedSlotNum;            //Ƿʹòλţ0-ʹã1-ʹ
    BYTE    bySlotNum;//λ
    BYTE    byRes[68];
    BYTE    sUserName[NAME_LEN];    //½ʺ
    BYTE    sPassword[PASSWD_LEN];    //
}NET_MATRIX_DEV_CHAN_INFO,*LPNET_MATRIX_DEV_CHAN_INFO;

typedef struct tagNET_MATRIX_PU_STREAM_CFG
{
    DWORD                            dwSize;
    NET_DVR_STREAM_MEDIA_SERVER_CFG    struStreamMediaSvrCfg;
    NET_MATRIX_DEV_CHAN_INFO        struDevChanInfo;
} NET_MATRIX_PU_STREAM_CFG,LPNET_MATRIX_PU_STREAM_CFG;

/*cameraõԪṹ*/
typedef struct tagNET_DVR_MATRIX_CAMERACFG
{
    DWORD                    dwGlobalIndex;//ȫֱ
    DWORD                    dwInterIndex;//ֲ
    BYTE                    sCamName[NAME_LEN];
    NET_MATRIX_PU_STREAM_CFG struPuStreamCfg;
} NET_DVR_MATRIX_CAMERACFG,*LPNET_DVR_MATRIX_CAMERACFG;

typedef struct tagNET_DVR_MATRIX_CAMERALIST
{
    DWORD            dwSize;
    BYTE            byRes[12];
    DWORD            dwCamNum;//CAM
    BYTE              *pBuffer;
    DWORD             dwBufLen;//ָ볤ȣ
} NET_DVR_MATRIX_CAMERALIST,*LPNET_DVR_MATRIX_CAMERALIST;

typedef struct tagNET_DVR_DISP_CHAN_INFO
{
    NET_DVR_IPADDR    struIP;                /*  IPַ */
    WORD     wDVRPort;                 /* ˿ں */
    BYTE     byDispChannel;            /* ʾͨ */
    BYTE    byUsedSlotNum;            //Ƿʹòλţ0-ʹã1-ʹ
    BYTE    bySlotNum;//λ
    BYTE    byRes[7];
    BYTE    sUserName[NAME_LEN];    /*½ʺ */
    BYTE    sPassword[PASSWD_LEN];    /* */
}NET_DVR_DISP_CHAN_INFO,*LPNET_DVR_DISP_CHAN_INFO;

/*monitorõԪṹ*/
typedef struct tagNET_DVR_MATRIX_MONITORCFG
{
    DWORD                        dwGlobalIndex;//ȫֱ
    DWORD                        dwInterIndex;
    BYTE                        sMonName[NAME_LEN];
    NET_DVR_DISP_CHAN_INFO        struDispChanCfg;
} NET_DVR_MATRIX_MONITORCFG,*LPNET_DVR_MATRIX_MONITORCFG;
typedef struct tagNET_DVR_MATRIX_MONITORLIST
{
    DWORD        dwSize;
    BYTE        byRes[12];
    DWORD        dwMonNum;//MON
    BYTE          *pBuffer;
    DWORD         dwBufLen;//ָ볤ȣ
} NET_DVR_MATRIX_MONITORLIST,*LPNET_DVR_MATRIX_MONITORLIST;

#define     MAX_SUBMATRIX_NUM        8//ϵͳ
typedef struct tagNET_DVR_SUBMATRIXINFO
{
    BYTE        byMainMatrix;//Ƿϵͳ1-ǣ0-
    BYTE        bySubMatrixSequence;//Ƶۺƽ̨ϵͳ
    BYTE        byLoginType;//עͣ1-ֱ2-DNS3-
    BYTE        byRes1[9];
    NET_DVR_IPADDR  struSubMatrixIP;        /*IPַ޸ģ*/
    WORD        wSubMatrixPort;        /*ϵͳ˿ںţ޸ģ*/
    BYTE        byRes2[6];
    NET_DVR_IPADDR  struSubMatrixIPMask;    /*IPַ*/
    NET_DVR_IPADDR    struGatewayIpAddr;         /* صַ */    
    BYTE        sUserName[NAME_LEN];    /* û ˲ֻܻȡ*/
    BYTE        sPassword[PASSWD_LEN];    /* ˲ֻܻȡ*/
    char        sDomainName[MAX_DOMAIN_NAME];//(޸)
    char         sDnsAddress[MAX_DOMAIN_NAME];/*DNSIPַ*/
    BYTE        sSerialNumber[SERIALNO_LEN];//кţ˲ֻܻȡ
    BYTE        byRes3[16];
}NET_DVR_SUBMATRIXINFO, *LPNET_DVR_SUBMATRIXINFO;

typedef struct tagNET_DVR_ALLUNITEDMATRIXINFO
{
    DWORD dwSize;
    NET_DVR_SUBMATRIXINFO struSubMatrixInfo[MAX_SUBMATRIX_NUM];
    BYTE  byRes2[32];
}NET_DVR_ALLUNITEDMATRIXINFO, *LPNET_DVR_ALLUNITEDMATRIXINFO;

#define    MAX_GATEWAYTRUNKNUM        1024 //Ƶۺƽ̨·ɸ

typedef struct tagNET_DVR_MATRIXGATEWAYNOTE
{
    WORD    wTrunkInToOutAbility;//ߴD1ı׼4ʾ֧4D1
    WORD    wTrunkOutToInAbility;//ߴD1ı׼4ʾ֧4D1˫ʱõֵ
    BYTE    byRes[4];
    NET_DVR_MATRIXSUBSYSTEMINFO struInputNote;
    NET_DVR_MATRIXSUBSYSTEMINFO struOutputNote;
}NET_DVR_MATRIXGATEWAYNOTE, *LPNET_DVR_MATRIXGATEWAYNOTE;

typedef struct tagNET_DVR_MATRIXGATEWAYINFO
{
    DWORD dwSize;
    NET_DVR_MATRIXGATEWAYNOTE struGatewayNote[MAX_GATEWAYTRUNKNUM];
    BYTE  byRes [32];
}NET_DVR_MATRIXGATEWAYINFO, *LPNET_DVR_MATRIXGATEWAYINFO;

typedef struct tagNET_DVR_MATRIXCODESYSTEMINFO
{
    BYTE   byMatrixNum;//Ƶۺƽ̨
    BYTE    bySubSystemNum;//ϵͳλ
    BYTE    byChan;//ͨ
    BYTE   byRes [13];
}NET_DVR_MATRIXCODESYSTEMINFO,*LPNET_DVR_MATRIXCODESYSTEMINFO;
typedef struct tagNET_DVR_MATRIXDECODESYSTEMINFO
{
    BYTE    byMatrixNum;//Ƶۺƽ̨
    BYTE    bySubSystemNum;//ϵͳλ
    BYTE    byDispChan;//ʾͨ
    BYTE    bySubDispChan;//ʾͨͨ
    BYTE    byRes [12];
}NET_DVR_MATRIXDECODESYSTEMINFO,*LPNET_DVR_MATRIXDECODESYSTEMINFO;

typedef struct tagNET_DVR_MATRIXSWITCH
{
    NET_DVR_MATRIXCODESYSTEMINFO struInputNote;
    NET_DVR_MATRIXDECODESYSTEMINFO struOutputNote;
    BYTE    byRes[32];
}NET_DVR_MATRIXSWITCH, *LPNET_DVR_MATRIXSWITCH;

typedef enum {
    ENC_CARD = 0,
        DEC_CARD,
        SD_DEC_CARD,
        FPGA_CARD,
        CS_CARD,
        ALERTOR_CARD,
        NAT_0,
        NAT_1,
        VCA_CARD,
        VGA_DEC_CARD,
        VGA_ENC_CARD,
        ERR_CARD,
} DEV_TYPE;

typedef struct tagNET_DVR_MATRIXSWITCHCTRL
{
    DWORD dwCamId;//ȫֱ
    DWORD dwMonId;//ȫֱ
    BYTE  bySubWindowNum;//ӦӴں
    BYTE   bySwitchType;/*лͣ0:л1:л2:ȡ0xff:ʾMONбȫȡ*/
    WORD   wAlarmType;//豸ͣ1:2豸
    DWORD  dwResidentTime;/* ʾפʱ䣬0xFFFFFFFF ʱ Ϊפʾ*/
    BYTE   byVcaDevType;//豸"豸"ʱDEV_TYPE
    BYTE   byRes[19];
}NET_DVR_MATRIXSWITCHCTRL, *LPNET_DVR_MATRIXSWITCHCTRL;

typedef struct tagNET_DVR_MATRIXDATABASE
{
    //ļͣ1-ݿļ2-ݿļ3-ƽ̨ݿļ4-ļ0xffһʧܵݿ
    DWORD dwDevType; 
    DWORD dwParam; //ššƽ̨ţļʱֵ
    BYTE  byFileType;//ļͣ1-sql䣬2-db䣬3-ļ
    BYTE  byRes [3];
} NET_DVR_MATRIXDATABASE, *LPNET_DVR_MATRIXDATABASE;

typedef struct tagNET_DVR_SUBSYSTEMINFO_V40
{
/*ϵͳͣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ5-ϵͳ6-ϵͳ7-ϵͳ8-V6ϵͳ
    9-V6ϵͳ10-תϵͳ11-X86ϵͳ12-ϵͳ13-X86ķ壬14- X86ҵ壬15-ƴϵͳ 16-˽ϵͳ17-X86ƴϵͳ18-ͨƴϵͳ0-NULL˲ֻܻȡ*/
    BYTE        bySubSystemType;
    //ϵͳͨϵͳ485˲ֻܻȡ
    BYTE        byChan;
    BYTE        byLoginType;//עͣ1-ֱ2-DNS3-
    BYTE        bySlotNum ;//λţ˲ֻܻȡ
    BYTE        byRes1[4];
    NET_DVR_IPADDR   struSubSystemIP;        /*IPַ޸ģ*/
    NET_DVR_IPADDR   struSubSystemIPMask;//
    NET_DVR_IPADDR     struGatewayIpAddr;    /* صַ */
    WORD        wSubSystemPort;        //ϵͳ˿ںţ޸ģ
    BYTE        byRes2[6];
    BYTE        sUserName[NAME_LEN];    /* û ˲ֻܻȡ*/
    BYTE        sPassword[PASSWD_LEN];    /*(޸)*/
    char        sDomainName[MAX_DOMAIN_NAME];//(޸)
    char         sDnsAddress[MAX_DOMAIN_NAME];/*DNSIPַ*/
    BYTE        sSerialNumber[SERIALNO_LEN];//кţ˲ֻܻȡ
    BYTE        byBelongBoard;//Ӱţ1ʼ0xffʾЧ
    BYTE        byInterfaceType;//ӿͣ1-BNC2-VGA3-HDMI4-DVI5-SDI, 6-FIBER, 7-RGB, 8-YPrPb, 9-VGA/HDMI/DVIӦ10-3GSDI, 11-VGA/DVIӦ12-HDTVI0xff-Ч
    BYTE        byInterfaceNums;//ӿڸ0xffʾЧ
    BYTE        byInterfaceStartNum;//ӿʼţ0xffʾЧ
    BYTE        byDeviceName[20];//ϵͳ
    BYTE        byAudioChanNums; //Ƶͨ
    BYTE        byAudioChanStartNum; //Ƶͨʼ
    BYTE        byAudioChanType;//Ƶͨͣ0-Ч1-Ƶ룬2-Ƶ
    BYTE        byRes3[33];
}NET_DVR_SUBSYSTEMINFO_V40, *LPNET_DVR_SUBSYSTEMINFO_V40;

#define  MAX_SUBSYSTEM_NUM_V40  120
typedef struct tagNET_DVR_ALLSUBSYSTEMINFO_V40
{
    DWORD dwSize;
    NET_DVR_SUBSYSTEMINFO_V40 struSubSystemInfo[MAX_SUBSYSTEM_NUM_V40];
    BYTE byRes[8];
}NET_DVR_ALLSUBSYSTEMINFO_V40, *LPNET_DVR_ALLSUBSYSTEMINFO_V40;

typedef struct tagNET_DVR_SINGLESUBSYSTEMJOININFO_V40
{
    /*ϵͳͣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ5-ϵͳ6-ϵͳ7-ϵͳ8-V6ϵͳ9-V6ϵͳ0-NULL˲ֻܻȡ*/
    BYTE   bySubSystemType; 
    BYTE   byConnectStatus;//ϵͳ״̬1-2-ӶϿ
    BYTE   byMatrixNum;//Ƶۺƽ̨ţϵͳ34ʱ
    BYTE   bySubSystemNum;//ϵͳλţ0~79ϵͳ34ʱ
    NET_DVR_DECSUBSYSTEMJIONSTATUS struDecSub [MATRIX_MAXDECSUBSYSTEMCHAN];
    BYTE   byBindStatus;//״̬0-ûа󶨣1-Ѿ󶨣ƴʱõ
    BYTE   bySlotNum ;//λţ˲ֻܻȡ
    //ϵͳΪ1ʱã0-δ1-D12-7203-1080
    BYTE   byDecodeAbility; 
    BYTE   byUsedTrunk;
    BYTE   byRes[64];
}NET_DVR_SINGLESUBSYSTEMJOININFO_V40,LPNET_DVR_SINGLESUBSYSTEMJOININFO_V40;

typedef struct tagNET_DVR_ALLDECSUBSYSTEMJOININFO_V40
{
    DWORD dwSize;
    NET_DVR_SINGLESUBSYSTEMJOININFO_V40 struSingleSubSystemJoinInfo[MAX_SUBSYSTEM_NUM_V40];
    BYTE  byRes[48];
}NET_DVR_ALLDECSUBSYSTEMJOININFO_V40, *LPNET_DVR_ALLDECSUBSYSTEMJOININFO_V40;

#define  MAX_OPTICALFIBER_NUM  16
typedef struct tagNET_DVR_SUBSYSTEM_ABILITY
{
/*ϵͳͣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ5-ϵͳ6-ϵͳ7-ϵͳ8-V6ϵͳ9-V6ϵͳ
    10-תϵͳ11-X86ϵͳ壬 14- X86ҵ壬15-ƴϵͳ 16-˽ϵͳ17-X86ƴϵͳ18-ͨƴϵͳ0-NULL˲0-NULL˲ֻܻȡ*/
    BYTE  bySubSystemType;
    BYTE  byChanNum;//ϵͳͨ
    BYTE  byStartChan;//ϵͳʼͨ
    BYTE  bySlotNum ;//λ 
    BYTE  byRes1[4];
    union
    {
        BYTE byRes[200];        
        struct
        {
            BYTE byDecode;        //ǷǴ빦ܵܰ,1-ǣ0-
            BYTE byNeedPreAllocDec; //ǷҪԤԴ1-ǣ0-
            BYTE byVACType;  //ϵͳͣ0-ͨͣ1-ǿ
            BYTE byRes[197];
        }struVACSystemAbility;
        struct
        {
            BYTE  byVGANums;//VGAʾͨ1ʼ
            BYTE  byBNCNums;//BNCʾͨ9ʼ
            BYTE  byHDMINums;//HDMIʾͨ25ʼ
            BYTE  byDVINums;//DVIʾͨ29ʼ
            BYTE  byLayerNums ;//ƴУʱ֧ͼ
            BYTE  bySpartan;//Թܣ0-֧֣1-֧
            BYTE  byDecType; //ϵͳͣ0-ͨ,1-ǿ(ͨͷʱǰ4ʹԴǿ޴ƣǿɱϵͳ16·D1Դ
            //ǿͱΪԴɱãܱͨ)
            //2-ܹϵͳ3-תϵͳܺתϵͳڽǽ
            BYTE  byOutputSwitch;//Ƿ֧HDMI/DVIл0-֧֣1-֧
            BYTE  bySDINums;//SDIʾͨ33ʼ
            BYTE  byRes1[38];               
            BYTE  byDecoderType ; //Ƿֶ֧೧룬0-֧֣1-֧
            BYTE  byRes2[152];
        }struDecoderSystemAbility;
        struct
        {
            BYTE  byCoderType;//ͣ0-壬1-, 2-ģ
            BYTE  byOptical;//˻룬0-1-
            BYTE  byOpticalSubChan; //ÿŵ            
            BYTE  bySupportAVSeparate;//Ƿ֧Ƶ룬0-֧֣1-֧
            BYTE  byRes[196];
        }struCoderSystemAbility;
        struct
        {
            WORD    wTrunkAbility;//ߴD1ı׼4ʾ֧4D1
            BYTE    byOpticalFiberNum;//
            BYTE    byRes[197];
        }struInputSystemAbility;
        struct
        {
            WORD    wTrunkAbility;//ߴD1ı׼4ʾ֧4D1
            BYTE    byOpticalFiberNum;//
            BYTE    byRes[197];
        }struOutputSystemAbility;
        struct
        {
            BYTE    by485Num;//ϵͳ485
            BYTE    bySlotNum;//ÿ485λ
            BYTE    byRes[198];
        }struCodeSpitterSystemAbility;
        struct
        {
            WORD    wAlarmInNums;
            WORD    wAlarmOutNums;
            /* ʶǷӣ 1ʾӣ Ϊ0 ʾδ */
            BYTE  byAlarmBoxEnable[4][8];
            BYTE  bySupportContact; /* Ƶۺƽ̨ڲ0-֧,1-֧ */
            BYTE  byRes[163];
        }struAlarmHostSystemAbility;
        struct
        {
            BYTE  byOpticalFiberNum;//
            BYTE  byRes1[3];
            //˴D1ı׼4ʾ֧4D1
            WORD    wTrunkAbility[MAX_OPTICALFIBER_NUM/*16*/];
            BYTE  byRes2[164];
        }struInOutputSystemAbility;
        struct
        {
            BYTE  bySupportRingProtocol;   //Ƿֻ֧Э
            BYTE  bySupportRingNums; //ֻ֧
            BYTE  bySupportPortNums;  //ֵ֧Ķ˿
            BYTE  byRes[1]; 
            DWORD dwPortSupportRingProto; //ÿ˿Ƿֻ֧Э飬λ㣬132λֱʾ132˿ڣ0-֧֣1-ʾ֧ 
            BYTE  byRes2[192];
        } struFiberSwitchSystemAbility;    
    }struAbility;
}NET_DVR_SUBSYSTEM_ABILITY, *LPNET_DVR_SUBSYSTEM_ABILITY;

typedef struct tagNET_DVR_VIDEOPLATFORM_ABILITY_V40
{
    DWORD   dwSize;
    BYTE    byCodeSubSystemNums;//ϵͳ
    BYTE    byDecodeSubSystemNums;//ϵͳ
    BYTE    bySupportNat;//Ƿ֧NAT0-֧֣1-֧
    BYTE    byInputSubSystemNums;//ϵͳ
    BYTE    byOutputSubSystemNums;//ϵͳ
    BYTE    byCodeSpitterSubSystemNums;//ϵͳ
    BYTE    byAlarmHostSubSystemNums;//ϵͳ
    BYTE    bySupportBigScreenNum;//֧ɴĸ
    BYTE    byVCASubSystemNums;//ϵͳ
    BYTE    byV6SubSystemNums;//V6ϵͳ
    BYTE    byV6DecoderSubSystemNums;//V6ϵͳ
    BYTE    bySupportBigScreenX;/*ƴӵģʽmn*/
    BYTE    bySupportBigScreenY;
    BYTE    bySupportSceneNums;//ֳ֧ģʽĸ
    BYTE    byVcaSupportChanMode;//ֵ֧ͨʹģʽ0-ʹýͨ1-ʹʾͨͨ
    BYTE    bySupportScreenNums;//ֵ֧ĴĻ
    BYTE    bySupportLayerNums;//ֵ֧ͼ0xff-Ч
    BYTE    byNotSupportPreview;//Ƿ֧Ԥ,1-֧֣0-֧
    BYTE    byNotSupportStorage;//Ƿִ֧洢,1-֧֣0-֧
    BYTE    byUploadLogoMode;//ϴlogoģʽ0-ϴͨ1-ϴʾͨ
    NET_DVR_SUBSYSTEM_ABILITY struSubSystemAbility[MAX_SUBSYSTEM_NUM_V40];
    BYTE    by485Nums;//485ڸ
    BYTE    by232Nums;//232ڸ
    BYTE    bySerieStartChan;//ʼͨ
    BYTE    byScreenMode;//ģʽ0-ɿͻ˷䣬1-豸˷
    BYTE    byDevVersion;//豸汾0-B10/B11/B121-B20
    BYTE    bySupportBaseMapNums;//ֵ֧ĵͼͼŴ1ʼ
    WORD    wBaseLengthX;//ÿСĻ׼ֵB20ʹ
    WORD    wBaseLengthY;
    BYTE    bySupportPictureTrans;  //Ƿ֧ͼƬԣ0-֧֣1-֧    
    BYTE    bySupportPreAllocDec;   //Ƿ֧ܽԴԤ䣬0-֧֣1-֧
    BYTE    bySupportDecAutoManage; //Ƿֽ֧Դ
    BYTE    byTranDevSubSystemNums; //תϵͳ
    BYTE    byFiberSwitchNums;  //ϵͳ
    BYTE    byRes2[625];
}NET_DVR_VIDEOPLATFORM_ABILITY_V40, *LPNET_DVR_VIDEOPLATFORM_ABILITY_V40;

typedef struct tagNET_DVR_VIDEOPLATFORM_ABILITY
{
    DWORD dwSize;
    BYTE  byCodeSubSystemNums;//ϵͳ
    BYTE  byDecodeSubSystemNums;//ϵͳ
    BYTE  bySupportNat;//Ƿ֧NAT0-֧֣1-֧
    BYTE  byInputSubSystemNums;//ϵͳ
    BYTE  byOutputSubSystemNums;//ϵͳ
    BYTE  byCodeSpitterSubSystemNums;//ϵͳ
    BYTE  byAlarmHostSubSystemNums;//ϵͳ
    BYTE  bySupportBigScreenNum;//֧ƴ
    BYTE  byVCASubSystemNums;//ϵͳ
    BYTE  byRes1[11];   
    NET_DVR_SUBSYSTEM_ABILITY struSubSystemAbility[MAX_SUBSYSTEM_NUM];
    BYTE  by485Nums;//485ڸ
    BYTE  by232Nums;//485ڸ
    BYTE  bySerieStartChan;//ʼͨ
    BYTE  byRes2[637];    
}NET_DVR_VIDEOPLATFORM_ABILITY, *LPNET_DVR_VIDEOPLATFORM_ABILITY;
//ȡӿ

//ģʽA 
typedef struct tagNET_DVR_HOLIDATE_MODEA
{
    BYTE    byStartMonth;    // ʼ 1ʼ
    BYTE    byStartDay;        // ʼ 1ʼ
    BYTE    byEndMonth;        //  
    BYTE    byEndDay;        // 
    BYTE    byRes[4];        // ֽ
}NET_DVR_HOLIDATE_MODEA, *LPNET_DVR_HOLIDATE_MODEA;

typedef struct tagNET_DVR_HOLIDATE_MODEB
{
    BYTE    byStartMonth;    // 1ʼ
    BYTE    byStartWeekNum;    // ڼ 1ʼ 
    BYTE    byStartWeekday;    // ڼ
    BYTE    byEndMonth;        // 1ʼ
    BYTE    byEndWeekNum;    // ڼ 1ʼ 
    BYTE    byEndWeekday;    // ڼ    
    BYTE    byRes[2];        // ֽ 
}NET_DVR_HOLIDATE_MODEB, *LPNET_DVR_HOLIDATE_MODEB;

typedef struct tagNET_DVR_HOLIDATE_MODEC
{
    WORD    wStartYear;        // 
    BYTE    byStartMon;        // 
    BYTE    byStartDay;        // 
    WORD    wEndYear;        // 
    BYTE    byEndMon;        // 
    BYTE    byEndDay;        // 
}NET_DVR_HOLIDATE_MODEC, *LPNET_DVR_HOLIDATE_MODEC;

typedef union tagNET_DVR_HOLIDATE_UNION
{    
    // С 12ֽ
    DWORD                    dwSize[3];
    NET_DVR_HOLIDATE_MODEA    struModeA;    // ģʽA
    NET_DVR_HOLIDATE_MODEB    struModeB;    // ģʽB
    NET_DVR_HOLIDATE_MODEC    struModeC;    // ģʽC
}NET_DVR_HOLIDATE_UNION, *LPNET_DVR_HOLIDATE_UNION;

typedef enum tagHOLI_DATE_MODE
{
    HOLIDATE_MODEA = 0,
        HOLIDATE_MODEB,
        HOLIDATE_MODEC
}HOLI_DATE_MODE;

typedef struct tagNET_DVR_HOLIDAY_PARAM
{
    BYTE    byEnable;            // Ƿ
    BYTE    byDateMode;            // ģʽ 0-ģʽA 1-ģʽB 2-ģʽC
    BYTE    byRes1[2];            // ֽ
    NET_DVR_HOLIDATE_UNION uHolidate;    // 
    BYTE    byName[NAME_LEN];    // 
    BYTE    byRes2[20];            // ֽ
}NET_DVR_HOLIDAY_PARAM, *LPNET_DVR_HOLIDAY_PARAM;

#define  MAX_HOLIDAY_NUM    32

typedef struct tagNET_DVR_HOLIDAY_PARAM_CFG
{
    DWORD    dwSize;            // ṹС
    NET_DVR_HOLIDAY_PARAM struHolidayParam[MAX_HOLIDAY_NUM];    // ղ
    DWORD    byRes[40];        // 
}NET_DVR_HOLIDAY_PARAM_CFG, *LPNET_DVR_HOLIDAY_PARAM_CFG;

// ձʽ
typedef struct tagNET_DVR_HOLIDAY_HANDLE
{
    DWORD    dwSize;                // ṹС
    NET_DVR_SCHEDTIME              struAlarmTime[MAX_TIMESEGMENT_V30];    // ʱ
    BYTE    byRes2[240];        // ֽ
}NET_DVR_HOLIDAY_HANDLE, *LPNET_DVR_HOLIDAY_HANDLE;

typedef struct tagNET_DVR_HOLIDAY_HANDLE_COND
{
    DWORD    dwSize;                // ṹС
    DWORD    dwChannel;            //ͨ
    DWORD    dwSMDHandleType;    //ܼղ 0-Ƶ쳣⣬1-齹⣬2-
    BYTE     byRes2[32];        // ֽ
}NET_DVR_HOLIDAY_HANDLE_COND, *LPNET_DVR_HOLIDAY_HANDLE_COND;

typedef struct tagNET_DVR_HOLIDAY_RECORD
{
    DWORD           dwSize;
    NET_DVR_RECORDDAY     struRecDay;     // ¼
    NET_DVR_RECORDSCHED   struRecordSched[MAX_TIMESEGMENT_V30]; // ¼ʱ
    BYTE      byRes[20];      //  ֽ
}NET_DVR_HOLIDAY_RECORD, *LPNET_DVR_HOLIDAY_RECORD;

#define  MAX_LINK_V30  128

typedef struct tagNET_DVR_ONE_LINK
{
    NET_DVR_IPADDR  struIP;     // ͻIP
    LONG            lChannel;   // ͨ
    BYTE            byRes[32];  // ֽ
}NET_DVR_ONE_LINK, *LPNET_DVR_ONE_LINK;

typedef struct tagNET_DVR_LINK_STATUS
{
    DWORD   dwSize;      // ṹС
    WORD    wLinkNum;    // ӵĿ
    BYTE    byRes1[2];  // ֽ
    NET_DVR_ONE_LINK struOneLink[MAX_LINK_V30];   // ӵĿͻϢ
    BYTE    byRes[32];  // ֽ
}NET_DVR_LINK_STATUS, *LPNET_DVR_LINK_STATUS;

#define MAX_BOND_NUM  2

typedef struct tagNET_DVR_ONE_BONDING
{
    BYTE    byMode;                // ģʽ0 - ݴ 1 - ؾ
    BYTE    byUseDhcp;            // Ƿʹdhcp
    BYTE    byMasterCard;        //  ָΪ        
    BYTE    byStatus;           // BONDING״̬  0 - 쳣 1- ֻܻȡ
    BYTE    byBond[MAX_NETWORK_CARD];// byBond[0]== 1 ʾʹeh0  0ʾʹeh0
    NET_DVR_ETHERNET_V30    struEtherNet;        // 
    NET_DVR_IPADDR    struGatewayIpAddr;  // صַ
    BYTE    byRes[20];            // ֽ
}NET_DVR_ONE_BONDING, *LPNET_DVR_ONE_BONDING;

typedef struct tagNET_DVR_NETWORK_BONDING
{
    DWORD   dwSize;         // ṹС
    BYTE    byEnable;       // Ƿbonding
    BYTE    byNum;          // Bondingĸ
    BYTE    byRes1[2];         //  ֽ
    NET_DVR_ONE_BONDING struOneBond[MAX_BOND_NUM];
    BYTE    byRes2[40];        // ֽ
}NET_DVR_NETWORK_BONDING, *LPNET_DVR_NETWORK_BONDING;


// 
typedef struct tagNET_DVR_DISK_QUOTA 
{
    BYTE    byQuotaType;     // ,1 -  2-3-ʱ
    BYTE    byRes1[5];       // ֽ
    WORD    wStoragePeriod;  //¼洢ڣλ죬ΪʱʱЧ
    DWORD   dwHCapacity;     // Ĵ32λ λMB
    DWORD   dwLCapacity;     // Ĵ32λ λMB
    DWORD   dwHUsedSpace;    // ʹõĴ̴С32λ λMB
    DWORD   dwLUsedSpace;    // ʹõĴ̴С32λ λMB
    BYTE    byQuotaRatio;    //    Ĵ̱,λ:%
    BYTE    byRes2[21];      // ֽ
}NET_DVR_DISK_QUOTA, *LPNET_DVR_DISK_QUOTA;

typedef struct tagNET_DVR_DISK_QUOTA_CFG
{
    DWORD   dwSize;         // ṹС
    NET_DVR_DISK_QUOTA    struPicQuota;       //  ͼƬ
    NET_DVR_DISK_QUOTA    struRecordQuota;    //  ¼
    NET_DVR_DISK_QUOTA    struAddInfoQuota;   //  Ϣ (ƴ洢Ŀǰֵ֧ĸϢУȶͼ)
    BYTE    byRes[12];      //ֽ
}NET_DVR_DISK_QUOTA_CFG, *LPNET_DVR_DISK_QUOTA_CFG;


typedef struct tagNET_DVR_TIMING_CAPTURE
{
    NET_DVR_JPEGPARA  struJpegPara;   // ʱץͼͼƬ
    DWORD      dwPicInterval;  // ʱץͼʱ,λs   1-1s 2-2s 3-3s 4-4s 5-5s 
    //    6-10m 7-30m 8-1h 9-12h 10-24h
    BYTE       byRes[12];      // ֽ
}NET_DVR_TIMING_CAPTURE, *LPNET_DVR_TIMING_CAPTURE;

typedef struct tagNET_DVR_REL_CAPTURE_CHAN
{
    BYTE    byChan[16];    // λʾ
    BYTE    byRes[20];          // ֽ
}NET_DVR_REL_CAPTURE_CHAN, *LPNET_DVR_REL_CAPTURE_CHAN;

#define MAX_PIC_EVENT_NUM      32
#define MAX_ALARMIN_CAPTURE   16

typedef struct  tagNET_DVR_REL_CAPTURE_CHAN_V40
{
    DWORD   dwMaxRelCaptureChanNum;  //ɴĹͨ-ֻ
    DWORD   dwChanNo[MAX_CHANNUM_V40]; //Ĺץͼͨţֵʾý,0xffffffffʾЧ
    BYTE     byRes[32];
}NET_DVR_REL_CAPTURE_CHAN_V40, *LPNET_DVR_REL_CAPTURE_CHAN_V40;

typedef struct tagNET_DVR_EVENT_CAPTURE_V40
{
    NET_DVR_JPEGPARA  struJpegPara;   // ¼ץͼͼƬ
    DWORD   dwPicInterval;   // ¼ץͼʱ  λΪ 
    NET_DVR_REL_CAPTURE_CHAN_V40 struRelCaptureChan[MAX_PIC_EVENT_NUM];   // ± 0 ƶⴥץͼ 1 Ƶڵץͼ 2 Ƶʧץͼ,3ʾPIRץͼ4ʾ߱ץͼ5ʾȱץͼ,6ʾץͼ
    NET_DVR_REL_CAPTURE_CHAN_V40 struAlarmInCapture[MAX_ALARMIN_CAPTURE];    // 봥ץͼ±0 1 
    DWORD   dwMaxGroupNum;  //豸ֵ֧󱨾ÿ16
    BYTE      byCapTimes; //ץͼ
    BYTE      byRes[59];
}NET_DVR_EVENT_CAPTURE_V40, *LPNET_DVR_EVENT_CAPTURE_V40;


typedef struct tagNET_DVR_EVENT_CAPTURE
{
    NET_DVR_JPEGPARA  struJpegPara;   // ¼ץͼͼƬ
    DWORD       dwPicInterval;  // ¼ץͼʱ  λΪ  1-1s 2-2s 3-3s 4-4s 5-5s 
    //    6-10m 7-30m 8-1h 9-12h 10-24h
    /*
    ± 0 ƶⴥץͼ 1 Ƶڵץͼ2 Ƶʧץͼ,3ʾPIRץͼ
    4ʾ߱ץͼ5ʾȱץͼ,6ʾץͼ,7 ʾץͼ
    8 ʾ-Խץͼ9 ʾץͼ,10ʾץͼ, 
    11-,12-뿪,13-ǻ,14-Աۼ,15-˶,
    16-ͣ,17-Ʒ,18-Ʒȡ⡣
    */
    NET_DVR_REL_CAPTURE_CHAN struRelCaptureChan[MAX_PIC_EVENT_NUM]; 
    NET_DVR_REL_CAPTURE_CHAN struAlarmInCapture[MAX_ALARMIN_CAPTURE];    // 봥ץͼ±0 1 
    BYTE       byCapTimes; //ץͼ
    BYTE       byRes[59];
}NET_DVR_EVENT_CAPTURE, *LPNET_DVR_EVENT_CAPTURE;

typedef struct tagNET_DVR_JPEG_CAPTURE_CFG_V40
{
    DWORD                             dwSize;               //ṹ峤
    NET_DVR_TIMING_CAPTURE        struTimingCapture;    
    NET_DVR_EVENT_CAPTURE_V40    struEventCapture;
    BYTE       byStreamType;//ץͼ 0-1-
    BYTE       byRes3[19];     // ֽ
}NET_DVR_JPEG_CAPTURE_CFG_V40, *LPNET_DVR_JPEG_CAPTURE_CFG_V40;

typedef struct tagNET_DVR_JPEG_CAPTURE_CFG
{
    DWORD      dwSize;         // ṹС
    NET_DVR_TIMING_CAPTURE struTimingCapture;    
    NET_DVR_EVENT_CAPTURE struEventCapture;
    BYTE       byStreamType;//ץͼ 0-1-
    BYTE       byRes3[19];     // ֽ
}NET_DVR_JPEG_CAPTURE_CFG, *LPNET_DVR_JPEG_CAPTURE_CFG;  

typedef struct tagNET_DVR_CAPTURE_DAY
{
    BYTE    byAllDayCapture;    // Ƿȫץͼ
    BYTE    byCaptureType;        // ץͼͣ0-ʱץͼ1-ƶץͼ2-ץͼ3-ƶ򱨾ץͼ4-ƶͱץͼ6-ܱץͼ
    BYTE    byRes[2];
}NET_DVR_CAPTURE_DAY, *LPNET_DVR_CAPTURE_DAY;

typedef struct tagNET_DVR_CAPTURE_SCHED
{
    NET_DVR_SCHEDTIME struCaptureTime;        // ץͼʱ
    BYTE        byCaptureType;       // ץͼͣ0-ʱץͼ1-ƶץͼ2-ץͼ3-ƶ򱨾ץͼ4-ƶͱץͼ6-ܱץͼ
    BYTE        byRes[3];           // ֽ
}NET_DVR_CAPTURE_SCHED, *LPNET_DVR_CAPTURE_SCHED;

// ͨץͼƻ
typedef struct tagNET_DVR_SCHED_CAPTURECFG
{
    DWORD  dwSize;     // ṹ
    BYTE    byEnable;    // Ƿץͼ
    BYTE    byRes1[3];    // ֽ
    NET_DVR_CAPTURE_DAY    struCaptureDay[MAX_DAYS];    // ȫץͼƻ
    NET_DVR_CAPTURE_SCHED    struCaptureSched[MAX_DAYS][MAX_TIMESEGMENT_V30];    // ʱץͼƻ
    NET_DVR_CAPTURE_DAY    struCaptureHoliday;            // ץͼƻ
    NET_DVR_CAPTURE_SCHED    struHolidaySched[MAX_TIMESEGMENT_V30];    // ʱμץͼƻ
    DWORD    dwRecorderDuration;    // ץͼʱ 0xffffffffʾֵЧ 
    BYTE    byRes[40];            // ֽ
}NET_DVR_SCHED_CAPTURECFG, *LPNET_DVR_SCHED_CAPTURECFG;


typedef struct tagNET_DVR_FLOW_TEST_PARAM
{
    DWORD  dwSize;              //ṹС
    LONG   lCardIndex;         //
    DWORD  dwInterval;         //豸ϴʱ, λ:100ms
    BYTE   byRes[8];           //ֽ
}NET_DVR_FLOW_TEST_PARAM, *LPNET_DVR_FLOW_TEST_PARAM;

typedef struct tagNET_DVR_FLOW_INFO
{
    DWORD  dwSize;             //ṹС
    DWORD  dwSendFlowSize;     //С,λkbps
    DWORD  dwRecvFlowSize;     //С,λkbps
    BYTE   byRes[20];          // 
}NET_DVR_FLOW_INFO, *LPNET_DVR_FLOW_INFO;

//  ¼ǩ
#define LABEL_NAME_LEN 40
typedef struct tagNET_DVR_RECORD_LABEL
{
    DWORD  dwSize;                    // ṹС
    NET_DVR_TIME  struTimeLabel;            // ǩʱ 
    BYTE    byQuickAdd;                // Ƿ ʱǩЧ
    BYTE    byRes1[3];                // ֽ
    BYTE    sLabelName[LABEL_NAME_LEN];    // ǩ Ϊ40ֽ  
    BYTE    byRes2[40];                // ֽ
}NET_DVR_RECORD_LABEL, *LPNET_DVR_RECORD_LABEL;

#define  LABEL_IDENTIFY_LEN     64
typedef struct tagNET_DVR_LABEL_IDENTIFY
{
    BYTE    sLabelIdentify[LABEL_IDENTIFY_LEN];    // 64ֽڱʶ
    BYTE    byRes[8];               // ֽ
}NET_DVR_LABEL_IDENTIFY, *LPNET_DVR_LABEL_IDENTIFY;

#define MAX_DEL_LABEL_IDENTIFY  20// ɾǩʶ

typedef struct tagNET_DVR_DEL_LABEL_PARAM
{
    DWORD   dwSize;       // ṹС
    BYTE    byMode;   // λʾ,0x01ʾʶɾ
    BYTE    byRes1;
    WORD    wLabelNum;      // ǩĿ      
    NET_DVR_LABEL_IDENTIFY struIndentify[MAX_DEL_LABEL_IDENTIFY]; // ǩʶ
    BYTE    byRes2[160];   //ֽ    
}NET_DVR_DEL_LABEL_PARAM, *LPNET_DVR_DEL_LABEL_PARAM;

typedef struct tagNET_DVR_MOD_LABEL_PARAM
{
    NET_DVR_LABEL_IDENTIFY struIndentify; //Ҫ޸ĵıǩʶ
    BYTE byRes1[24];
    BYTE sLabelName[LABEL_NAME_LEN];    //޸ĺıǩ
    BYTE byRes2[40];                
}NET_DVR_MOD_LABEL_PARAM, *LPNET_DVR_MOD_LABEL_PARAM;

// ǩṹ
typedef struct tagNET_DVR_FIND_LABEL
{
    DWORD       dwSize;          // ṹС
    LONG        lChannel;        // ҵͨ
    NET_DVR_TIME    struStartTime;    // ʼʱ
    NET_DVR_TIME    struStopTime;    // ʱ
    BYTE        sLabelName[LABEL_NAME_LEN];    //  ¼ǩ ǩΪգֹʱбǩ
    BYTE        byDrawFrame;        //0:֡1֡
    BYTE        byRes[39];        // ֽ
}NET_DVR_FIND_LABEL, *LPNET_DVR_FIND_LABEL;

// ǩϢṹ
typedef struct tagNET_DVR_FINDLABEL_DATA
{
    BYTE    sLabelName[LABEL_NAME_LEN];    // ǩ
    NET_DVR_TIME struTimeLabel;        // ǩʱ
    NET_DVR_LABEL_IDENTIFY struLabelIdentify; // ǩʶ
    BYTE    byRes1[32];            // ֽ
}NET_DVR_FINDLABEL_DATA, *LPNET_DVR_FINDLABEL_DATA;

#define CARDNUM_LEN_V30 40
//ö
typedef enum _COUNTRY_INDEX_
{
    COUNTRY_NONSUPPORT = 0,   //0-㷨ⲻ֧ʶ
        COUNTRY_CZE = 1, //Czech Republic ݿ˹͹
        COUNTRY_FRA = 2, //France 
        COUNTRY_DEU = 3, //Germany ¹
        COUNTRY_ESP = 4, //Spain  
        COUNTRY_ITA = 5, //Italy  
        COUNTRY_NLD = 6, //Netherlands 
        COUNTRY_POL = 7, //Poland  
        COUNTRY_SVK = 8, //Slovakia  ˹工
        COUNTRY_BLR = 9, // Belorussia  ׶˹
        COUNTRY_MDA = 10, //Moldova  Ħ
        COUNTRY_RUS = 11, //Russia  ˹
        COUNTRY_UKR = 12, //Ukraine  ڿ
        COUNTRY_BEL = 13, //Belgium  ʱ
        COUNTRY_BGR = 14, //Bulgaria  
        COUNTRY_DNK = 15, //Denmark  
        COUNTRY_FIN = 16, //Finland  
        COUNTRY_GBR = 17, //Great Britain  Ӣ
        COUNTRY_GRC = 18, //Greece  ϣ
        COUNTRY_HRV = 19, //Croatia  ޵
        COUNTRY_HUN = 20, //Hungary  
        COUNTRY_ISR = 21, //Israel  ɫ
        COUNTRY_LUX = 22, //Luxembourg  ¬ɭ
        COUNTRY_MKD = 23, //Macedonia  ٹ͹
        COUNTRY_NOR = 24, //Norway  Ų
        COUNTRY_PRT = 25, //Portugal  
        COUNTRY_ROU = 26, //Romania  
        COUNTRY_SRB = 27, //Serbia  ά
        COUNTRY_AZE = 28, //Azerbaijan ͹
        COUNTRY_GEO = 29, //Georgia  ³
        COUNTRY_KAZ = 30, //Kazakhstan ˹̹
        COUNTRY_LTU = 31, //Lithuania  𹲺͹
        COUNTRY_TKM = 32, //Turkmenistan ˹̹
        COUNTRY_UZB = 33, //Uzbekistan   ȱ˹̹
        COUNTRY_LVA = 34, //Latvia       ά
        COUNTRY_EST = 35, //Estonia ɳ
        COUNTRY_ALB = 36, //Albania 
        COUNTRY_AUT = 37, //Austria µ
        COUNTRY_BIH = 38, //Bosnia and Herzegovina ˹Ǻͺά
        COUNTRY_IRL = 39, //Ireland 
        COUNTRY_ISL = 40, //Iceland 
        COUNTRY_VAT = 41, //Vatican ٸ
        COUNTRY_MLT = 42, //Malta 
        COUNTRY_SWE = 43, //Sweden 
        COUNTRY_CHE = 44, //Switzerland ʿ
        COUNTRY_CYP = 45, //Cyprus ·˹
        COUNTRY_TUR = 46, //Turkey 
        COUNTRY_SVN = 47, //Slovenia ˹
        COUNTRY_UNRECOGNIZED = 0xfe, //Unrecognized ޷ʶ
        COUNTRY_ALL = 0xff, //ALL  ȫ
}COUNTRY_INDEX;

typedef struct tagNET_DVR_FIND_PICTURE_PARAM
{
    DWORD  dwSize;         // ṹС 
    LONG   lChannel;       // ͨ
    /* ҵͼƬ:0ʱץͼ1 ƶץͼ 2 ץͼ
    3  | ƶץͼ 4  & ƶץͼ 6 ֶץͼ ,
    9-ͼƬ,10- PIR11- ߱12- ȱ, 
    0xa Ԥʱͼ0xd , 0xe Խ⣬0xf ⣬
    0x10 , 0x11-豸ػطʱͼ, 0x12-,
    0x13-,0x14-뿪,0x15-ǻ,
    0x16-Աۼ,0x17-˶,0x18-ͣ,
    0x19-Ʒ,0x1a-Ʒȡ, 0x1b-,
    0x1c-м,0x1d-ȡ֤¼,0x1e-,0x1f-ƻ,
    0x20-ֻ⣬0x21-Ԥ0x22-±, 0x23,0xff- ȫ*/ 
    BYTE   byFileType;        
    BYTE   byNeedCard;     // ǷҪ
                           /*
                           0-1-ģ2-3-壬4-5-ʣ6-7-
                           8-9-10-11-ԥ12-ڣ13-14-棬
                           15-16-գ17-ӣ18-ɣ19-ɣ20-21-࣬
                           22-³23-24-£25-26-27-̨28-
                           29-أ30-ۣ31-£32-ƣ33-㣬34-0xff-ȫ
    */
    BYTE   byProvince;     //ʡֵ
    BYTE   byRes;  //ҽǷҪ󷵻Ϣ0-أ1-
    BYTE   sCardNum[CARDNUM_LEN_V30];     // 
    NET_DVR_TIME  struStartTime;//ͼƬĿʼʱ
    NET_DVR_TIME  struStopTime;// ͼƬĽʱ
    //ITC3.7 
    DWORD    dwTrafficType; //ͼƬЧ ο VCA_OPERATE _TYPE 
    DWORD    dwVehicleType; // ο VCA_VEHICLE_TYPE
    //ΥͲο VCA_ILLEGAL_TYPE ǰָ֧ѡ
    DWORD    dwIllegalType;
    BYTE     byLaneNo;  //(1~99)
    BYTE     bySubHvtType ;//0-,1-(ֳ֧Ƽʡݼ),2-ǻ,3-
    BYTE     byRes2[2];
    char     sLicense[MAX_LICENSE_LEN/*16*/];    //ƺ
    BYTE     byRegion;     // ֵ 0-1-ŷ(Europe Region)2-(Russian Region)3-ŷ&˹(EU&CIS) ,0xff-
    BYTE     byCountry;     // ֵգCOUNTRY_INDEX 
    BYTE     byRes3[6];     // ֽ
}NET_DVR_FIND_PICTURE_PARAM, *LPNET_DVR_FIND_PICTURE_PARAM;

#define PICTURE_NAME_LEN 64

typedef struct
{
    char    sFileName[PICTURE_NAME_LEN];//ͼƬ
    NET_DVR_TIME struTime;//ͼƬʱ
    DWORD dwFileSize;//ͼƬĴС
    char    sCardNum[CARDNUM_LEN_V30];    //
    BYTE   byPlateColor ;//οṹ VCA_PLATE_COLOR
    BYTE   byVehicleLogo;//οṹ VLR_VEHICLE_CLASS
    BYTE   byEventSearchStatus; //ͼƬʾͬһҽʱ0-ʾûͼƬϢ1-ʾ滹ͼƬϢܹͼƬϢһ״̬Ϊ0ͼƬ
    BYTE   byRecogResult ;//ʶοṹVTR_RESULT
    char   sLicense[MAX_LICENSE_LEN/*16*/];    //ƺ
    BYTE   byRes[12];
}NET_DVR_FIND_PICTURE,*LPNET_DVR_FIND_PICTURE;

#define MAX_RECORD_PICTURE_NUM  50      //  󱸷ͼƬ  

typedef struct tagNET_DVR_BACKUP_PICTURE_PARAM
{
    DWORD  dwSize;         // ṹС   
    DWORD  dwPicNum;
    NET_DVR_FIND_PICTURE struPicture[MAX_RECORD_PICTURE_NUM];
    BYTE   byDiskDes[DESC_LEN_32];
    BYTE   byWithPlayer;
    BYTE   byContinue;    /*Ƿ 0 1*/
    BYTE   byRes[34];
}NET_DVR_BACKUP_PICTURE_PARAM, *LPNET_DVR_BACKUP_PICTURE_PARAM;

typedef struct 
{    
    DWORD dwSize;           //ṹС
    DWORD dwChannel;        //ͨ
    BYTE  byCompressType;   //ȡѹ1,2,3,¼
    BYTE  byRes[15];        //
    NET_DVR_COMPRESSIONCFG_V30  struCurrentCfg; //ǰѹ
}NET_DVR_COMPRESSION_LIMIT, *LPNET_DVR_COMPRESSION_LIMIT;

#define   STEP_READY       0    //׼
#define   STEP_RECV_DATA   1    //
#define   STEP_UPGRADE     2    //ϵͳ
#define   STEP_BACKUP      3    //ϵͳ
#define   STEP_SEARCH      255  //ļ

typedef struct tagNET_DVR_VIDEO_EFFECT
{
    DWORD dwBrightValue;      //[0,255]
    DWORD dwContrastValue;    //Աȶ[0,255]
    DWORD dwSaturationValue;  //Ͷ[0,255]
    DWORD dwHueValue;         //ɫ[0,255]
    DWORD dwSharpness;          //[0,255]
    DWORD dwDenoising;          //ȥ[0,255]
    BYTE  byRes[12];
}NET_DVR_VIDEO_EFFECT, *LPNET_DVR_VIDEO_EFFECT;

typedef struct tagNET_DVR_VIDEO_INPUT_EFFECT
{    
    DWORD                    dwSize;                //ṹС
    WORD                    wEffectMode;        //ģʽ 0-׼ 1- 2- 3-  255-Զ
    BYTE                    byRes1[146];        //
    NET_DVR_VIDEO_EFFECT    struVideoEffect;    //ƵЧ
    BYTE                    byRes2[60];            //
}NET_DVR_VIDEO_INPUT_EFFECT, *LPNET_DVR_VIDEO_INPUT_EFFECT;


typedef struct tagNET_DVR_VIDEOPARA_V40
{
    DWORD    dwChannel;            // ͨ
    DWORD    dwVideoParamType;      // Ƶ 0- 1-Աȶ 2-Ͷ 3-ɫ 4- 5-ȥ
    DWORD    dwVideoParamValue;  //ӦƵֵΧ
    BYTE     byRes[12];
}NET_DVR_VIDEOPARA_V40, *LPNET_DVR_VIDEOPARA_V40;

typedef struct tagNET_DVR_DEFAULT_VIDEO_COND
{
    DWORD    dwSize;            // ṹС
    DWORD    dwChannel;        // ͨ
    DWORD    dwVideoMode;    // ģʽ
    BYTE    byRes[32];      // 
}NET_DVR_DEFAULT_VIDEO_COND, *LPNET_DVR_DEFAULT_VIDEO_COND;

typedef struct tagNET_DVR_ENCODE_JOINT_PARAM
{
    DWORD    dwSize;            // ṹС
    BYTE    byJointed;        //  0 ûй 1 Ѿ
    BYTE    byDevType;        // 豸  1 豸
    BYTE    byRes1[2];        // ֽ
    NET_DVR_IPADDR    struIP;            // ıȡ豸IPַ
    WORD    wPort;            // ıȡ豸˿ں
    WORD    wChannel;        // ıȡ豸ͨ
    BYTE    byRes2[20];            // ֽ
}NET_DVR_ENCODE_JOINT_PARAM, *LPNET_DVR_ENCODE_JOINT_PARAM;    

typedef struct tagNET_DVR_VCA_CHAN_WORKSTATUS
{
    BYTE    byJointed;                // 0-ûй  1-Ѿ
    BYTE    byRes1[3];
    NET_DVR_IPADDR    struIP;                    // ȡ豸IPַ
    WORD    wPort;                    // ȡ豸˿ں
    WORD    wChannel;                // ȡ豸ͨ
    BYTE    byVcaChanStatus;        // 0 - δ 1 - 
    BYTE    byRes2[19];                // ֽ
}NET_DVR_VCA_CHAN_WORKSTATUS, *LPNET_DVR_VCA_CHAN_WORKSTATUS;

typedef struct tagNET_DVR_VCA_DEV_WORKSTATUS
{
    DWORD    dwSize;            // ṹС
    BYTE    byDeviceStatus;    // 豸״̬0 -  1- 
    BYTE    byCpuLoad;        // CPUʹ0-100 ֱʹðٷ
    NET_DVR_VCA_CHAN_WORKSTATUS struVcaChanStatus[MAX_VCA_CHAN];
    DWORD    dwRes[40];        // ֽ
}NET_DVR_VCA_DEV_WORKSTATUS, *LPNET_DVR_VCA_DEV_WORKSTATUS;

typedef struct tagNET_DVR_VGA_DISP_CHAN_CFG_V40
{        
    DWORD    dwSize; 
    BYTE   byAudio;            /*ƵǷ*/
    BYTE   byAudioWindowIdx;      /*ƵӴ*/
    BYTE     byVgaResolution;      /*ֱʣȡ*/
    BYTE    byVedioFormat;         /*1:NTSC,2:PAL0-NULL*/
    DWORD    dwWindowMode;        /*ģʽȡ*/       
    BYTE      byJoinDecChan[MAX_WINDOWS];/*ӴڹĽͨ*/
    BYTE    byEnlargeStatus;          /*ǷڷŴ״̬0Ŵ1Ŵ*/
    BYTE    byEnlargeSubWindowIndex;//ŴӴں
    BYTE    byScale; /*ʾģʽ0---ʵʾ1---ʾ( BNC )*/
    /*ֹ壬0-Ƶۺƽ̨ڲʾͨã1-ʾͨ*/
    BYTE    byUnionType;
    union
    {
        BYTE byRes[160];
        struct
        {
            /*ӴڶӦͨӦĽϵͳĲλ(Ƶۺƽ̨нϵͳЧ)*/
            BYTE    byJoinDecoderId[MAX_WINDOWS];
            //ʾƵֱʣ1-D1,2-720P,3-1080P豸Ҫݴ//ֱʽнͨķ䣬1ó1080P豸4ͨ
            //˽ͨ
            BYTE    byDecResolution;
            BYTE    byRes[143];
        }struVideoPlatform;
        struct
        {
            BYTE    byRes[160];
        }struNotVideoPlatform;
    }struDiff;
    BYTE    byRes[120];
}NET_DVR_VGA_DISP_CHAN_CFG_V40,*LPNET_DVR_VGA_DISP_CHAN_CFG_V40;

typedef struct tagNET_DVR_V6SUBSYSTEMPARAM
{
    BYTE        bySerialTrans;//Ƿ͸0-1-
    BYTE        byRes[35];
}NET_DVR_V6SUBSYSTEMPARAM, *LPNET_DVR_V6SUBSYSTEMPARAM;




typedef struct tagNET_DVR_CORRECT_DEADPIXEL_PARAM
{
    DWORD dwSize;
    DWORD dwCommand; //0-뻵ģʽ1-ӻ㣬2-滵㣬3-˳
    DWORD dwDeadPixelX; //X
    DWORD dwDeadPixelY; //Y
    BYTE byRes[12]; //
}NET_DVR_CORRECT_DEADPIXEL_PARAM, *LPNET_DVR_CORRECT_DEADPIXEL_PARAM;

#define MAX_REDAREA_NUM   6   //̵

typedef struct tagNET_DVR_CORRECT_PARAMS
{
    BYTE byYellowIntervalTime;//ƵƵļʱ䣬λ루s
    BYTE byDigTrafficLight;//ǷǽֻͨƵƣ0-ǣ1-
    BYTE byRes[2];
}NET_DVR_CORRECT_PARAMS,*LPNET_DVR_CORRECT_PARAMS;

typedef struct tagNET_DVR_REDAREACFG
{
    DWORD dwSize;
    DWORD dwCorrectEnable; //ǷУܣ0-رգ1-
    DWORD dwCorrectLevel; //У1(У)-10(У),ĬΪ5
    DWORD dwAreaNum; //У
    NET_VCA_RECT struLaneRect[MAX_REDAREA_NUM]; //У
    NET_DVR_CORRECT_PARAMS struCorrectParam[MAX_REDAREA_NUM/*6*/]; //УԺУӦ
    BYTE   byRes2[8]; //
}NET_DVR_REDAREACFG, *LPNET_DVR_REDAREACFG;

typedef struct tagNET_DVR_HISTORICDATACFG
{
    DWORD dwSize;
    DWORD dwTotalNum;  //ʷݸ
    BYTE byRes[16];
}NET_DVR_HISTORICDATACFG, *LPNET_DVR_HISTORICDATACFG;


#define INQUEST_MESSAGE_LEN     44    //ѶصϢ
#define INQUEST_MAX_ROOM_NUM    2     //ѶҸ
#define MAX_RESUME_SEGMENT      2     //֧ͬʱָƬĿ

typedef struct tagNET_DVR_INQUEST_ROOM
{
    BYTE        byRoomIndex;     //Ѷұ
    BYTE        byFileType;        //0-Ѷļ1-ͥϴļ
    BYTE        byRes[22];       //
}NET_DVR_INQUEST_ROOM, *LPNET_DVR_INQUEST_ROOM;

typedef struct tagNET_DVR_INQUEST_MESSAGE
{
    char         sMessage[INQUEST_MESSAGE_LEN]; //صϢ
    BYTE    byRes[46];                     //
}NET_DVR_INQUEST_MESSAGE, *LPNET_DVR_INQUEST_MESSAGE;

typedef struct tagNET_DVR_INQUEST_SENSOR_DEVICE
{
    WORD    wDeviceType;    //ݲɼ豸ͺ:0- 1- 2-ز 3- 4- 5-ء6-ϡ7-ά˹
    WORD    wDeviceAddr;    //ݲɼ豸ַ    
    BYTE     byRes[28];        //
}NET_DVR_INQUEST_SENSOR_DEVICE, *LPNET_DVR_INQUEST_SENSOR_DEVICE;

typedef struct tagNET_DVR_INQUEST_SENSOR_INFO
{
    NET_DVR_INQUEST_SENSOR_DEVICE struSensorDevice[INQUEST_MAX_ROOM_NUM];
    DWORD   dwSupportPro;      //֧Э,λʾ, °汾չֶ
    //0x1: 0x2:ز 0x4:
    BYTE    byRes[120];        //
}NET_DVR_INQUEST_SENSOR_INFO, *LPNET_DVR_INQUEST_SENSOR_INFO;

typedef struct tagNET_DVR_INQUEST_ROOM_INFO
{
    char        szCDName[NAME_LEN];    //ƣ˫̹һ
    union
    {
        BYTE     byBitRate;    // byCalcTypeΪ0ʱЧ(0-321-482-643-804-965-128
                                //6-1607-1928-2249-25610-32011-38412-448
                                //13-51214-64015-76816-896ǰ16ֵ)17-102418-128019-1536
                                //20-179221-204822-307223-409624-8192
        BYTE    byInquestTime;  // byCalcTypeΪ1ʱЧ0-1Сʱ, 1-2Сʱ,2-3Сʱ,3-4Сʱ, 4-6Сʱ,5-8Сʱ,6-10Сʱ,7-12Сʱ
        //8-16Сʱ, 9-20Сʱ,10-22Сʱ,11-24Сʱ
    }uCalcMode;
    BYTE        byCalcType;            //¼0- 1-ʱ
    BYTE        byAutoDelRecord;    // ǷԶɾ¼0-ɾʱ¼ 1-ɾ
    BYTE        byAlarmThreshold;        // ֵ
    BYTE        byInquestChannelResolution;     //Ѷֱͨʣ0:720P,1:1080P,2:CIF,3:4CIF,4:WD1,5-VGA
    BYTE        byRes[11];
}NET_DVR_INQUEST_ROOM_INFO, *LPNET_DVR_INQUEST_ROOM_INFO;

typedef struct tagNET_DVR_INQUEST_SYSTEM_INFO
{
    DWORD    dwRecordMode;         //¼ģʽ:1 ˫ģʽ 2 ֿģʽ 3 ˫˫ģʽ޸Ҫ豸
    DWORD    dwWorkMode;           //ģʽ:0 ׼ģʽ 1 ͨģʽ(Ŀǰֻб׼ģʽ)
    DWORD    dwResolutionMode;     //豸ֱʣ0: 1:D1 2:720P 3:1080PѶôֶΣ
    NET_DVR_INQUEST_SENSOR_INFO struSensorInfo;  //ʪȴ    
    NET_DVR_INQUEST_ROOM_INFO     struInquestRoomInfo[INQUEST_MAX_ROOM_NUM];
    BYTE    byEnableHashCheck;        //ǷöԹHASHֵУ 0-壬1-ã2-
    BYTE    byEnableInitCD;        //Ƿóʼ 0-壬1-ã2-
    BYTE    byRes[22];    
}NET_DVR_INQUEST_SYSTEM_INFO, *LPNET_DVR_INQUEST_SYSTEM_INFO;

typedef struct tagNET_DVR_INQUEST_RESUME_SEGMENT
{
    NET_DVR_TIME  struStartTime; //¼ʼʱ
    NET_DVR_TIME  struStopTime;  //¼ֹʱ
    BYTE    byRoomIndex;         //Ѷұ,1ʼ
    BYTE    byDriveIndex;        //¼,1ʼ
    WORD    wSegmetSize;         //ƬϵĴС, λM 
    DWORD   dwSegmentNo;         //ƬڱѶе,1ʼ 
    BYTE    byRes[24];           //
}NET_DVR_INQUEST_RESUME_SEGMENT, *LPNET_DVR_INQUEST_RESUME_SEGMENT;

typedef struct tagNET_DVR_INQUEST_RESUME_EVENT
{
    DWORD   dwResumeNum;       //ָ¼
    NET_DVR_INQUEST_RESUME_SEGMENT struResumeSegment[MAX_RESUME_SEGMENT];
    BYTE    byResumeMode;        //ָģʽ0-ָ̻1-˫ָ̻
    BYTE    byRes[199];        //
}NET_DVR_INQUEST_RESUME_EVENT, *LPNET_DVR_INQUEST_RESUME_EVENT;

typedef struct tagNET_DVR_INQUEST_DEVICE_VERSION
{
BYTE  byMainVersion;         /*汾.
                             0 : δ֪
                             1 : 8000ѶDVR
                             ΰ汾: 1 : 8000HD-S
                             2 : 8100ѶDVR 
                             ΰ汾: 1 : Ѷ81SNL
                             2 : Ѷ81SH
                             3 : Ѷ81SFH
                             3 : 8608ѶNVR 
                             ΰ汾: 1 : DS-8608SN-SP
                             2 : DS-8608SN-ST
*/
BYTE  bySubVersion;          //ߴΰ汾
BYTE  byUpgradeVersion;      //汾,δΪ0
BYTE  byCustomizeVersion;     //ư汾,ǶΪ0
BYTE  byRes[60];             //
}NET_DVR_INQUEST_DEVICE_VERSION, *LPNET_DVR_INQUEST_DEVICE_VERSION;

typedef struct tagNET_DVR_DISK_RAID_INFO 
{
    DWORD dwSize;   //ṹС
    BYTE byEnable;  //RaidǷ
    BYTE bySleepStatus;    //0-Ч 1-ߣ2-
    BYTE byRes[34];  //ֽ
}NET_DVR_DISK_RAID_INFO, *LPNET_DVR_DISK_RAID_INFO;


typedef struct tagNET_DVR_SYNCHRONOUS_IPC
{
    DWORD dwSize;    //ṹС
    BYTE  byEnable;  //ǷãΪǰIPCͬ豸
    BYTE  byRes[7];  //
}NET_DVR_SYNCHRONOUS_IPC, *LPNET_DVR_SYNCHRONOUS_IPC;

typedef struct tagNET_DVR_IPC_PASSWD
{
    DWORD dwSize;    //ṹС
    char sOldPasswd[PASSWD_LEN];  //IPCľ룬DVRDVR֤
    char sNewPasswd[PASSWD_LEN];  //IPC
    BYTE byRes[32];
}NET_DVR_IPC_PASSWD, *LPNET_DVR_IPC_PASSWD;

//ͨȡDVR״̬λbps
typedef struct tagNET_DEVICE_NET_USING_INFO 
{
    DWORD dwSize;    //ṹС
    DWORD dwPreview;   //Ԥ
    DWORD dwPlayback;  //ط
    DWORD dwIPCModule; //IPC
    DWORD dwNetDiskRW; //̶д
    BYTE res[32];
}NET_DVR_DEVICE_NET_USING_INFO, *LPNET_DVR_DEVICE_NET_USING_INFO;

//ͨDVRǰIPCIPַ
typedef struct tagNET_DVR_IPC_NETCFG
{
    DWORD dwSize;      //ṹС
    NET_DVR_IPADDR struIP;       //IPCIPַ
    WORD wPort;       //IPCĶ˿
    char res[126];  
}NET_DVR_IPC_NETCFG, *LPNET_DVR_IPC_NETCFG;

//ʱ
typedef struct tagNET_DVR_TIME_LOCK
{
    DWORD dwSize;      //ṹС
    NET_DVR_TIME strBeginTime;
    NET_DVR_TIME strEndTime;
    DWORD   dwChannel;        //ͨ, 0xffʾͨ
    DWORD   dwRecordType;     //¼:  0xffffffffȫ0ʱ¼1-ƶ⣬23-ƶ⣬4-ƶ⣬5-6-ֶ¼7-¼(ͬļ)
    DWORD   dwLockDuration;   //ʱ,λ,0xffffffffʾ
    NET_DVR_TIME_EX strUnlockTimePoint;    //ʱЧdwLockDurationΪʱʱ䵽ʱԶ
    BYTE    byRes[4];
}NET_DVR_TIME_LOCK, *LPNET_DVR_TIME_LOCK;

typedef struct tagNET_DVR_LOCK_RETURN
{
    DWORD dwSize;      //ṹС
    NET_DVR_TIME strBeginTime; 
    NET_DVR_TIME strEndTime;
    BYTE    byRes[20];
}NET_DVR_LOCK_RETURN, *LPNET_DVR_LOCK_RETURN;

//67DVS
//֤
typedef enum 
{
    UPGRADE_CERT_FILE = 0, 
    UPLOAD_CERT_FILE = 1,
    TRIAL_CERT_FILE = 2,
    CONFIGURATION_FILE = 3,
    UPLOAD_RECORD_FILE = 4 , //ϴ¼ļ
    SCENE_CONFIGURATION_FILE = 5, //ļϴ
    UPLOAD_PICTURE_FILE = 6,  //ϴͼƬļ
    UPLOAD_VIOLATION_FILE = 7,  //ϴΥֵļ
    UPLOAD_TG_FILE = 8,  //ϴTGTiming GeneratorļT1ԣ
    UPLOAD_DATA_TO_DB = 9,        //ϴļͼ
    UPLOAD_BACKGROUND_PIC = 10, //ϴͼƬ
    UPLOAD_CALIBRATION_FILE = 11, //ϴ궨ļ
    UPLOAD_TME_FILE = 12, //ϴڹļ
    
    //UPLOAD_TME_FILE = 12, //ϴڹļ
    UPLOAD_VEHICLE_BLACKWHITELST_FILE = 13,
    UPLOAD_PICTURE_TO_CLOUD = 15,    //ϴͼƬƴ洢
    UPLOAD_VIDEO_FILE = 16,  //ϴƵļ
    UPLOAD_SCREEN_FILE = 17,    //ϴĻļ
    UPLOAD_PUBLISH_MATERIAL = 18,    //ϴϢ̬زļ
    UPLOAD_PUBLISH_UPGRADE_FILE = 19,    //ϴϢļ
    UPLOAD_RING_FILE = 20,   //ϴļ
    UPLOAD_ENCRYPT_CERT = 21,    //ϴ֤
    UPLOAD_THERMOMETRIC_FILE = 22, //ϴ±궨ļ
    UPLOAD_SUBBRAND_FILE = 23, //ϴƷļ
    UPLOAD_LED_CHECK_FILE = 24,    //ϴLEDУļ
    BATCH_UPLOAD_PICTURE_FILE = 25  //ϴͼƬļ
}NET_SDK_UPLOAD_TYPE;  

typedef enum 
{
    NET_SDK_DOWNLOAD_CERT = 0,        //֤
    NET_SDK_DOWNLOAD_IPC_CFG_FILE = 1,//IPCļ
    NET_SDK_DOWNLOAD_BASELINE_SCENE_PIC = 2, //ػ׼ͼƬ
    NET_SDK_DOWNLOAD_VQD_ALARM_PIC = 3,       //VQDͼƬ
    NET_SDK_DOWNLOAD_CONFIGURATION_FILE=4,   //ļ
    NET_SDK_DOWNLOAD_SCENE_CONFIGURATION_FILE = 5, //سļ
    NET_SDK_DOWNLOAD_FILE_FORM_DB = 6,                //ͼ
   // NET_SDK_DOWNLOAD_TME_FILE = 7  //سڹļ

    NET_SDK_DOWNLOAD_TME_FILE = 7,  //سڹļ
    NET_SDK_DOWNLOAD_VEHICLE_BLACKWHITELST_FILE = 8, //غڰļ
    NET_SDK_DOWNLOAD_FILE_FORM_CLOUD = 10,    //ƴ洢ͼƬ
    NET_SDK_DOWNLOAD_PICTURE = 11, //ͼƬ
    NET_SDK_DOWNLOAD_VIDEO = 12, //Ƶ
    NET_DVR_DOWNLOAD_SCREEN_FILE = 13, //Ļļ
    NET_SDK_DOWNLOAD_PUBLISH_MATERIAL = 14,    //Ϣ̬زļ
    NET_SDK_DOWNLOAD_THERMOMETRIC_FILE = 15,//ز±궨ļ
    NET_SDK_DOWNLOAD_LED_CHECK_FILE = 16,//LEDУļ
}NET_SDK_DOWNLOAD_TYPE;

//״̬
typedef enum 
{
    NET_SDK_DOWNLOAD_STATUS_SUCCESS = 1,    //سɹ
        NET_SDK_DOWNLOAD_STATUS_PROCESSING,        //
        NET_SDK_DOWNLOAD_STATUS_FAILED,            //ʧ
        NET_SDK_DOWNLOAD_STATUS_UNKOWN_ERROR    //δ֪ 
}NET_SDK_DOWNLOAD_STATUS;

//ؿ
typedef enum tagNET_SDK_DOWNLOAD_CONTROL_TYPE_ENUM
{
    ENUM_DOWNLOAD_CONTROL_ERR = -1,
    ENUM_DOWNLOAD_CONTROL_QOS = 1        //
}NET_SDK_DOWNLOAD_CONTROL_TYPE_ENUM;

typedef struct tagNET_DVR_BONJOUR_CFG
{
    DWORD    dwSize;                // ṹС
    BYTE    byEnableBonjour;        // Bonjourʹ 0  1ر
    BYTE     byRes1[3];                
    BYTE     byFriendlyName[MAX_DOMAIN_NAME];     // 
    BYTE     byRes2[128];
}NET_DVR_BONJOUR_CFG, *LPNET_DVR_BONJOUR_CFG;

typedef struct tagNET_DVR_SOCKS_CFG
{
    DWORD            dwSize;                // ṹС
    BYTE            byEnableSocks;          // ʹ 0ر 1
    BYTE             byVersion;              // SOCKS汾 4SOCKS4   5SOCKS5
    WORD            wProxyPort;                // ˿ڣĬ1080
    BYTE            byProxyaddr[MAX_DOMAIN_NAME];      // IPַ
    BYTE             byUserName[MAX_DOMAIN_NAME];     // û SOCKS
    BYTE             byPassword[NAME_LEN];            // SOCKS5
    BYTE             byLocalAddr[MAX_LOCAL_ADDR_LEN];  //ʹsocksΣʽΪ"ip/netmask;ip/netmask;"
    BYTE             byRes[128];
}NET_DVR_SOCKS_CFG, *LPNET_DVR_SOCKS_CFG;



typedef struct tagNET_DVR_QOS_CFG
{
    DWORD        dwSize;
    BYTE        byManageDscp;   // ݵDSCPֵ [0-63]
    BYTE        byAlarmDscp;    // ݵDSCPֵ [0-63]
    BYTE        byVideoDscp;    // ƵݵDSCPֵ [0-63]byFlagΪ0ʱʾƵ
    BYTE        byAudioDscp;    // ƵݵDSCPֵ [0-63]byFlagΪ1ʱЧ
    BYTE        byFlag;            // 0Ƶһ1Ƶֿ
    BYTE        byEnable;
    BYTE         byRes[126];
}NET_DVR_QOS_CFG, *LPNET_DVR_QOS_CFG;

typedef struct tagNET_DVR_HTTPS_CFG
{
    DWORD        dwSize;
    WORD        wHttpsPort;        // HTTPS˿
    BYTE        byEnable;        // ʹ 0ر 1
    BYTE        byRes[125];
}NET_DVR_HTTPS_CFG, *LPNET_DVR_HTTPS_CFG;

//֤
typedef struct tagNET_DVR_CERT_NAME
{
    BYTE    byCountry[MAX_COUNTRY_NAME_LEN];              //Ҵ CN
    BYTE     byState[MAX_DOMAIN_NAME];                //޻ʡ
    BYTE     byLocality[MAX_DOMAIN_NAME];            //
    BYTE     byOrganization[MAX_DOMAIN_NAME];        //֯
    BYTE     byUnit[MAX_DOMAIN_NAME];                //λ
    BYTE     byCommonName[MAX_DOMAIN_NAME];
    BYTE     byEmail[MAX_DOMAIN_NAME];  
    BYTE     byRes[128];
}NET_DVR_CERT_NAME, *LPNET_DVR_CERT_NAME ;

typedef struct tagNET_DVR_CERT_PARAM
{
    DWORD dwSize;
    WORD wCertFunc; //֤࣬0-802.1x,1-HTTPS
    WORD wCertType; //֤ͣ0-CA1-Certificate,2-˽Կļ
    BYTE byFileType; //֤ļͣ0-PEM,1-PFX
    BYTE byRes[35]; 
}NET_DVR_CERT_PARAM, *LPNET_DVR_CERT_PARAM;

#define UPLOAD_CERTIFICATE  1 //ϴ֤


typedef struct tagNET_DVR_CERT_INFO
{
    DWORD                 dwSize;
    NET_DVR_CERT_PARAM     struCertParam;    //֤
    DWORD                dwValidDays;   //ЧΪǩʱЧ
    BYTE                 byPasswd[NAME_LEN];   //˽Կ
    NET_DVR_CERT_NAME     struCertName;    // ֤
    NET_DVR_CERT_NAME     struIssuerName;    // ֤鷢ƣǩ֤ϢȡʱЧ
    NET_DVR_TIME_EX         struBeginTime;   //֤鴴ʱ䣨ǩ֤ϢȡʱЧ
    NET_DVR_TIME_EX         struEndTime;   //ֹ֤ʱ䣨ǩ֤ϢȡʱЧ
    BYTE                 serialNumber[NAME_LEN];   //֤ʶ루ǩ֤ϢȡʱЧ
    BYTE                 byVersion; 
    BYTE                 byKeyAlgorithm;            // 0-RSA  1-DSA
    BYTE                  byKeyLen;                //ܳ 0-512  1-1024 2-2048
    BYTE                 bySignatureAlgorithm; //ǩ㷨ͣǩ֤ϢȡʱЧ
    BYTE                 byRes[128];
}NET_DVR_CERT_INFO, *LPNET_DVR_CERT_INFO;


//channel record status
//***ͨ¼״̬*****//
typedef struct tagNET_DVR_CHANS_RECORD_STATUS
{
    BYTE    byValid;       //ǷЧ
                           /*(ֻ)¼:0: ¼1¼ 2- 
                           3- 4-Ƶ 5-δ 6-浵 7-ش 
    8-û 9-δ֤,10-浵к¼ 11-¼شк¼*/
    BYTE    byRecord;     
    WORD    wChannelNO;   //ͨ
    DWORD   dwRelatedHD;  //
    BYTE    byOffLineRecord;  //¼ 0-ر 1-
    BYTE    byRes[7];      //ֽ
}NET_DVR_CHANS_RECORD_STATUS, *LPNET_DVR_CHANS_RECORD_STATUS;


typedef struct tagNET_DVR_IP_ALARM_GROUP_NUM
{
    DWORD dwSize; 
    DWORD dwIPAlarmInGroup;      //IPͨ
    DWORD dwIPAlarmInNum;       //IPͨ
    DWORD dwIPAlarmOutGroup;     //IPͨ
    DWORD dwIPAlarmOutNum;      //IPͨ
    BYTE byRes[64];  
}NET_DVR_IP_ALARM_GROUP_NUM, *LPNET_DVR_IP_ALARM_GROUP_NUM;
//****NVR end***//

typedef struct tagNET_DVR_CHAN_GROUP_RECORD_STATUS
{
    DWORD dwSize; //ṹС
    NET_DVR_CHANS_RECORD_STATUS struChanStatus[MAX_CHANNUM_V30]; //һ64
}NET_DVR_CHAN_GROUP_RECORD_STATUS, *LPNET_DVR_CHAN_GROUP_RECORD_STATUS;


typedef struct tagNET_DVR_RECTCFG
{
    WORD wXCoordinate; /*ϽʼX*/
    WORD wYCoordinate; /*ϽY*/
    WORD wWidth;       /*ο*/
    WORD wHeight;      /*θ߶*/
}NET_DVR_RECTCFG, *LPNET_DVR_RECTCFG;
/*Ϣ*/
typedef struct tagNET_DVR_WINCFG
{
    DWORD dwSize;
    BYTE  byVaild;
    BYTE  byInputIdx;          /*Դ*/
    BYTE  byLayerIdx;          /*ͼ㣬0Ϊײ*/
    BYTE  byTransparency; //͸ȣ0100 
    NET_DVR_RECTCFG  struWin;//ĿĴ(ʾǽ)
    WORD wScreenHeight;//
    WORD wScreenWidth;//
    BYTE  byRes[20];
}NET_DVR_WINCFG, *LPNET_DVR_WINCFG;

#define  MAX_LAYERNUMS    32

typedef struct tagNET_DVR_ALLWINCFG
{
    DWORD dwSize;
    NET_DVR_WINCFG struWinCfg[MAX_LAYERNUMS];
    BYTE  byRes2[24];
}NET_DVR_ALLWINCFG, *LPNET_DVR_ALLWINCFG;

typedef struct tagNET_DVR_SCREENZOOM
{
    DWORD dwSize;
    DWORD dwScreenNum;//
    NET_DVR_POINT_FRAME struPointFrame;
    BYTE  byLayer;//ͼ
    BYTE  byRes[11];
}NET_DVR_SCREENZOOM, *LPNET_DVR_SCREENZOOM;

//2011-04-18
/*Ϣ,99991ʼ */
typedef struct tagNET_MATRIX_CAMERAINFO
{  
    DWORD dwGlobalCamId;      /* camȫֱ*/
    BYTE  sCamName[NAME_LEN]; /*cam*/
    DWORD dwMatrixId;          /*camӦı*/
    DWORD dwLocCamId;         /*camӦڲ*/ 
    BYTE  byValid;    /*ǷЧ0-1-*/
    BYTE  byPtzCtrl; /* Ƿɿأ0-1-*/
    BYTE  byUseType; //*ʹͣ0-Ϊʹã1-BNC2-SP3,3-V6ˣ4-*/ 
    BYTE  byUsedByTrunk;//ǰʹ״̬0-ûбʹã1-ʹ 
    BYTE  byTrunkReq; /*ֱ,D1Ϊλ1 - 1D12- 2D1ΪʹʱָǸߵĴ*/
    BYTE  byRes1[3];
    NET_DVR_TIME struInstallTime;//װʱ
    BYTE  sPurpose[NAME_LEN];/*;*/
    BYTE  byRes2[20];  
}NET_MATRIX_CAMERAINFO, *LPNET_MATRIX_CAMERAINFO;

/*Ϣ2048*/
typedef struct tagNET_MATRIX_MONITORINFO 
{
    DWORD    dwGloalMonId; /*mon ͳһ*/
    BYTE    sMonName[NAME_LEN];
    DWORD    dwMatrixId;  /*monھı*/
    DWORD    dwLocalMonId; /*monڲ*/
    BYTE    byValid;    /*ǷЧ0-1-*/
    BYTE    byTrunkType; /*ʹͣ0-Ϊʹã1-BNC2-SP3,3-V6ˣ4-*/ 
    BYTE    byUsedByTrunk;//ǰʹ״̬0-ûбʹã1-ʹ 
    BYTE    byTrunkReq; /*ֱ, D1Ϊλ1- 1D12- 2D1ΪʹʱָǸߵĴ*/
    NET_DVR_TIME struInstallTime;//װʱ
    BYTE    sPurpose[NAME_LEN];/*;*/
    BYTE    byRes[20];  
}NET_MATRIX_MONITORINFO, *LPNET_MATRIX_MONITORINFO;

typedef struct tagNET_MATRIX_DIGITALMATRIX
{
    NET_DVR_IPADDR  struAddress; /*豸Ϊ豸ʱIPϢ*/
    WORD    wPort;
    BYTE    byNicNum; /*0 - eth0, 1 - eth1, ˫ͨż󶨵*/
    BYTE    byRes[69];   
}NET_MATRIX_DIGITALMATRIX, *LPNET_MATRIX_DIGITALMATRIX;
typedef struct tagNET_MATRIX_ANALOGMATRIX
{
    BYTE    bySerPortNum;   /*ӵĴں  0xff-ͨ*/
    BYTE    byMatrixSerPortType;/* صĴģļ̿(Э)ӻͨſڣЭ飩 0 --- ЭͨѶ 1 --- ͨѶ*/
    BYTE    byRes1[2];
    NET_DVR_SINGLE_RS232 struRS232;    //232ڲ  ͨʱ˲Ч
    BYTE    byRes2[200];      
}NET_MATRIX_ANALOGMATRIX, *LPNET_MATRIX_ANALOGMATRIX;

typedef union tagNET_MATRIX_UNION
{
    NET_MATRIX_DIGITALMATRIX struDigitalMatrix;
    NET_MATRIX_ANALOGMATRIX struAnalogMatrix;
}NET_MATRIX_UNION, *LPNET_MATRIX_UNION;
/*Ϣ20*/
typedef struct tagNET_MATRIX_MATRIXINFO 
{
    DWORD   dwSize;
    DWORD    dwMatrixId;  /**/
    BYTE    sDevName[NAME_LEN];
    BYTE    byCtrlType; /*ָͨѶʽǴͨ, ͨ*/
    BYTE    byProtocolType;/*ͨſЭ*/
    BYTE    byRes1[6];   /*Ԥ*/
    NET_MATRIX_UNION struMatrixUnion;
    DWORD    dwMaxPortsIn; /**/
    DWORD    dwMaxPortsOut;/**/
    BYTE    sUserName[NAME_LEN];   /*¼û*/
    BYTE    sPassword[PASSWD_LEN];  /*¼*/        
    NET_DVR_TIME struInstallTime;//װʱ
    BYTE    sPurpose[NAME_LEN];/*;*/
    BYTE    byRes2[20];   /*Ԥ*/
}NET_MATRIX_MATRIXINFO, *LPNET_MATRIX_MATRIXINFO;


typedef struct tagNET_DVR_MATRIXLIST
{
    DWORD    dwSize;
    BYTE    byRes[12];
    DWORD    dwMatrixNum;//豸صľ
    BYTE    *pBuffer;//Ϣ
    DWORD   dwBufLen;//ָ볤ȣ
}NET_DVR_MATRIXLIST,*LPNET_DVR_MATRIXLIST;

/*Ϣ*/
typedef struct tagNET_MATRIX_UARTPARAM
{    
    DWORD dwSize;
    BYTE  byPortName[NAME_LEN];
    WORD  wUserId; /*ûţ豸ΪʱһûȨ޹*/
    BYTE  byPortType;    /*ͣ0-RS232/1-RS485/2-RS422*/
    BYTE  byFuncType; /*ӵ豸0-У1-̣2-͸ͨ(485ڲó͸ͨ),3-ģ*/     
    BYTE  byProtocolType;  /*ֵ֧Э, Ӽ豸ʱҪϢ,ȡ֧Эıż*/
    BYTE  byBaudRate;
    BYTE  byDataBits;
    BYTE  byStopBits;   /*ֹͣλ*/
    BYTE  byParity;      /*У*/
    BYTE  byFlowCtrl;   /*أأ*/
    BYTE  byRes[22];     /*Ԥ*/
}NET_MATRIX_UARTPARAM, *LPNET_MATRIX_UARTPARAM;

//256û1256
typedef struct tagNET_MATRIX_USERPARAM 
{
    DWORD dwSize;
    BYTE    sUserName[NAME_LEN];
    BYTE    sPassword[PASSWD_LEN/*16*/];
    BYTE    byRole;/*ûɫ:0-Ա,1-ԱֻһϵͳԱ255Ա*/
    BYTE    byLevel;  /*ͳһڲ,1- 255*/
    BYTE    byRes[18];
}NET_MATRIX_USERPARAM, *LPNET_MATRIX_USERPARAM;

//255Դ
typedef struct tagNET_MATRIX_RESOURSEGROUPPARAM
{
    DWORD dwSize;
    BYTE  byGroupName[NAME_LEN];
    BYTE  byGroupType;/*0-CAM飬1-MON*/
    BYTE  byRes1;
    WORD  wMemNum;
    DWORD dwGlobalId[512];
    BYTE  byRes2[20];
}NET_MATRIX_RESOURCEGROUPPARAM,*LPNET_MATRIX_RESOURSEGROUPPARAM;

//255û
typedef struct tagNET_MATRIX_USERGROUPPARAM
{
    DWORD dwSize;
    BYTE  sGroupName[NAME_LEN];
    WORD  wUserMember[255];  /*ûԱ*/
    WORD  wResorceGroupMember[255]; /*ԴԱ*/
    BYTE  byPermission[32];//Ȩޣ0-ptzȨޡлȨޡѯȨ
    BYTE  byRes[20];
} NET_MATRIX_USERGROUPPARAM, *LPNET_MATRIX_USERGROUPPARAM;

typedef struct tagNET_MATRIX_TRUNKPARAM
{
    DWORD    dwSize;
    DWORD    dwTrunkId;
    BYTE    sTrunkName[NAME_LEN];
    DWORD    dwSrcMonId;
    DWORD    dwDstCamId;
    BYTE    byTrunkType;  /*ʹ  1-BNC2-SP3˸壬3-SP3D1 4-V6ˣ5-*/
    BYTE    byAbility;     /*ʾ˵ĴԴ伸·*/
    BYTE    bySubChan;   /*Թ˸߶ԣʾͨ*/
    BYTE    byLevel;        /* ߼ 1-255*/
    WORD    wReserveUserID;    //ԤûID 1~256 0ʾͷԤ
    BYTE   byRes[18]; 
} NET_MATRIX_TRUNKPARAM, *LPNET_MATRIX_TRUNKPARAM;

typedef struct tagNET_DVR_MATRIX_TRUNKLIST
{
    DWORD    dwSize;
    BYTE    byRes[12];
    DWORD    dwTrunkNum;//豸صĸ
    BYTE    *pBuffer;//Ϣ
    DWORD   dwBufLen;//ָ볤ȣ
}NET_DVR_MATRIX_TRUNKLIST,*LPNET_DVR_MATRIX_TRUNKLIST;

#define MATRIX_PROTOCOL_NUM    20    //ֵ֧Э
#define KEYBOARD_PROTOCOL_NUM  20    //ֵ֧Э
typedef struct tagNET_DVR_PROTO_TYPE_EX
{ 
    WORD wType;               /*ipcЭֵ*/  
    WORD wCommunitionType;        /*0ģ 1 2ģ⡢*/
    BYTE  byDescribe[DESC_LEN]; /*Эֶ*/    
}NET_DVR_PROTO_TYPE_EX, LPNET_DVR_PROTO_TYPE_EX;

typedef struct tagNET_DVR_MATRIXMANAGE_ABIILITY
{
    DWORD    dwSize;
    DWORD    dwMaxCameraNum;//Camera
    DWORD    dwMaxMonitorNum;//
    WORD    wMaxMatrixNum;//
    WORD    wMaxSerialNum;//
    WORD    wMaxUser;//û
    WORD    wMaxResourceArrayNum;//Դ
    WORD    wMaxUserArrayNum;//û
    WORD    wMaxTrunkNum;//
    BYTE    nStartUserNum;//ʼû
    BYTE    nStartUserGroupNum;//ʼû
    BYTE    nStartResourceGroupNum;//ʼԴ
    BYTE    nStartSerialNum;//ʼں
    DWORD   dwMatrixProtoNum;     /*ЧľЭĿ0ʼ*/
    NET_DVR_PROTO_TYPE_EX struMatrixProto[MATRIX_PROTOCOL_NUM];/*Эб*/    
    DWORD   dwKeyBoardProtoNum;     /*ЧļЭĿ0ʼ*/
    NET_DVR_PROTO_TYPE_EX struKeyBoardProto[KEYBOARD_PROTOCOL_NUM];/*Эб*/   
    BYTE    byRes[32];
} NET_DVR_MATRIXMANAGE_ABILITY, *LPNET_DVR_MATRIXMANAGE_ABILITY;

//ץĹ()
typedef struct tagNET_VCA_SINGLE_FACESNAPCFG
{
    BYTE byActive;                //Ƿ񼤻0-1-
    /********* IPC5.1.7  Begin 2014-03-21***********/
    //ԶROIʹ
    BYTE byAutoROIEnable;//0-ر,1-
    BYTE byRes[2]; //
    /********* IPC5.1.7  End 2014-03-21***********/
    NET_VCA_SIZE_FILTER struSizeFilter;   //ߴ
    NET_VCA_POLYGON     struVcaPolygon;        //ʶ
}NET_VCA_SINGLE_FACESNAPCFG, *LPNET_VCA_SINGLE_FACESNAPCFG;

//ץĹ
typedef struct tagNET_VCA_FACESNAPCFG
{
    DWORD dwSize;
    BYTE bySnapTime;                    //ĿץĴ0-10
    BYTE bySnapInterval;                 //ץļλ֡
    BYTE bySnapThreshold;               //ץֵ0-100
    BYTE byGenerateRate;         //Ŀٶ,Χ[1, 5]    
    BYTE bySensitive;            //ĿȣΧ[1, 5]
    BYTE byReferenceBright; //2012-3-27ο[0,100]
    BYTE byMatchType;         //2012-5-3ȶԱģʽ0-Ŀʧ󱨾1-ʵʱ
    BYTE byMatchThreshold;  //2012-5-3ʵʱȶֵ0~100
    NET_DVR_JPEGPARA  struPictureParam; //ͼƬṹ
    NET_VCA_SINGLE_FACESNAPCFG struRule[MAX_RULE_NUM]; //ץĹ
    //ع̳ʱ䣨ֽڣ
    WORD wFaceExposureMinDuration;//Χ(1~3600룬Ĭ60)ЧԶģʽ
    //عģʽ
    BYTE byFaceExposureMode;//1-رգ2-0-Զжϣ
    BYTE byBackgroundPic;//ͼϴʹ 0-Ĭֵ1-ֹ
    DWORD dwValidFaceTime;    //Ч̳ʱ䣬λ
    DWORD dwUploadInterval; //ץͳϴʱ䣬λ룬Ĭ900
    BYTE byRes2[88];
}NET_VCA_FACESNAPCFG, *LPNET_VCA_FACESNAPCFG;

//
typedef enum tagHUMAN_AGE_GROUP_ENUM
{    
    ENUM_AGE_GROUP_INFANT      = 1,   //Ӥ׶
        ENUM_AGE_GROUP_CHILD       = 2,   //ͯ
        ENUM_AGE_GROUP_YOUNGSTER   = 3,   //
        ENUM_AGE_GROUP_ADOLESCENT  = 4,   //
        ENUM_AGE_GROUP_YOUTH       = 5,   //
        ENUM_AGE_GROUP_PRIME       = 6,   //׳
        ENUM_AGE_GROUP_MIDLIFE     = 7,   //
        ENUM_AGE_GROUP_MIDAGE      = 8,   //
        ENUM_AGE_GROUP_OLD         = 9    //
}HUMAN_AGE_GROUP_ENUM;

//ץĽ
typedef struct tagNET_VCA_FACESNAP_RESULT
{
    DWORD   dwSize;             // ṹС
    DWORD     dwRelativeTime;     // ʱ
    DWORD    dwAbsTime;            // ʱ
    DWORD   dwFacePicID;       //ͼID
    DWORD   dwFaceScore;        //,0-100
    NET_VCA_TARGET_INFO  struTargetInfo;//ĿϢ
    NET_VCA_RECT         struRect;      //ͼ
    NET_VCA_DEV_INFO       struDevInfo;    //ǰ豸Ϣ
    DWORD   dwFacePicLen;        //ͼĳȣΪ0ʾûͼƬ0ʾͼƬ
    DWORD   dwBackgroundPicLen; //ͼĳȣΪ0ʾûͼƬ0ʾͼƬ()
    BYTE    bySmart;            //IDS豸0(Ĭֵ)Smart Functiom Return 1
    BYTE    byAlarmEndMark;//0-1-ǣֶνIDֶʹãʾIDӦ±ҪṩNVRʹãжϱȡʶͼƬУߵͼƬ
    BYTE    byRepeatTimes;   //ظ0-
    BYTE    byRes;
    NET_VCA_HUMAN_FEATURE   struFeature;  //
    float   fStayDuration;  //ͣʱ(λ: )
    char    sStorageIP[16];        //洢IPַ
    WORD    wStoragePort;            //洢˿ں
    BYTE    byRes1[18];              // ֽ
    BYTE*   pBuffer1;  //ͼͼƬ
    BYTE*   pBuffer2;  //ͼͼƬݣͨұͼӿڿԻȡͼ
}NET_VCA_FACESNAP_RESULT, *LPNET_VCA_FACESNAP_RESULT;

typedef struct tagNET_VCA_SUB_PROCIMG_V50
{
    DWORD dwImageLen;  //ͼƬݳ
    DWORD dwFaceScore;        //,0-100
    NET_VCA_RECT struVcaRect; //ͼ
    NET_VCA_POINT struLeftEyePoint;  //λ
    NET_VCA_POINT struRightEyePoint; //λ
    BYTE       byDistance;           //ۼ
    BYTE       bySex;
    BYTE       byAgeGroup; 
    BYTE       byEyeGlass; 
    NET_VCA_RECT struPosRect;  //λ
    BYTE       byRes[20];  //
    BYTE       *pImage;  //ͼƬ
}NET_VCA_SUB_PROCIMG_V50, *LPNET_VCA_SUB_PROCIMG_V50;

typedef struct tagNET_DVR_FACE_DETECTION
{
    DWORD     dwSize; //ṹС
    DWORD        dwRelativeTime; //ʱ
    DWORD       dwAbsTime; //ʱ
    DWORD      dwBackgroundPicLen; //ͼĳȣΪ0ʾûͼƬ0ʾͼƬ
    NET_VCA_DEV_INFO  struDevInfo;   //ǰ豸Ϣ
    NET_VCA_RECT   struFacePic[MAX_FACE_PIC_NUM/*30*/];//ͼ
    BYTE   byFacePicNum;//ͼ
    BYTE   byRes[255];
    BYTE*  pBackgroundPicpBuffer; //ͼͼƬ
}NET_DVR_FACE_DETECTION,*LPNET_DVR_FACE_DETECTION;

typedef struct tagNET_VCA_FD_PROCIMG_RESULT_V50
{
    DWORD dwSize;   //ṹС
    DWORD dwImageId; //ͼID
    BYTE byRes[20]; //
    DWORD dwSubImageNum;  //ͼ
    NET_VCA_SUB_PROCIMG_V50  struProcImg[MAX_TARGET_NUM];  //ͼϢ
}NET_VCA_FD_PROCIMG_RESULT_V50, *LPNET_VCA_FD_PROCIMG_RESULT_V50;

//齹
typedef struct  tagNET_DVR_DEFOCUS_ALARM
{
    DWORD   dwSize;     /*ṹ*/
    NET_VCA_DEV_INFO       struDevInfo;/*豸Ϣ*/
    BYTE    byRes[64];        // ֽ
}NET_DVR_DEFOCUS_ALARM, *LPNET_DVR_DEFOCUS_ALARM;

typedef struct  tagNET_DVR_AUDIOEXCEPTION_ALARM
{
    DWORD      dwSize;     /*ṹ*/
    BYTE  byAlarmType;//ͣ1-Ƶ쳣2-Ƶͻ䣨ǿ3-ǿ4-Ƶʧ
    BYTE  byRes1;
    WORD wAudioDecibel;//ǿȣƵͻʱõ
    NET_VCA_DEV_INFO       struDevInfo;/*豸Ϣ*/
    BYTE    byRes[64];        // ֽ
}NET_DVR_AUDIOEXCEPTION_ALARM, *LPNET_DVR_AUDIOEXCEPTION_ALARM;

typedef struct  tagNET_BUTTON_DOWN_EXCEPTION_ALARM
{
    DWORD      dwSize;     /*ṹ*/
    NET_VCA_DEV_INFO       struDevInfo;/*豸Ϣ*/
    BYTE    byRes[64];        // ֽ
}NET_BUTTON_DOWN_EXCEPTION_ALARM, *LPNET_BUTTON_DOWN_EXCEPTION_ALARM;

typedef struct tagNET_VCA_FD_IMAGE_CFG
{
    DWORD   dwWidth;                  //Ҷͼݿ
    DWORD   dwHeight;                 //Ҷͼ߶
    DWORD   dwImageLen;  //Ҷͼݳ
    BYTE     byRes[20];  //
    BYTE     *pImage;    //Ҷͼ
}NET_VCA_FD_IMAGE_CFG, *LPNET_VCA_FD_IMAGE_CFG;

typedef struct tagNET_VCA_FD_PROCIMG_CFG
{
    DWORD    dwSize;           //ṹС
    BYTE     byEnable;         //Ƿ񼤻;
    BYTE     bySensitivity;      //ȣ[0,5]
    BYTE     byRes1[22];       //ֽ 
    NET_VCA_SIZE_FILTER  struSizeFilter;  //ߴ
    NET_VCA_POLYGON   struPolygon;    //
    NET_VCA_FD_IMAGE_CFG struFDImage;  //ͼƬϢ
    BYTE     byRes2[20];    //
}NET_VCA_FD_PROCIMG_CFG, *LPNET_VCA_FD_PROCIMG_CFG;

typedef struct tagNET_VCA_SUB_PROCIMG
{
    DWORD dwImageLen;  //ͼƬݳ
    DWORD dwFaceScore;        //,0-100
    NET_VCA_RECT struVcaRect; //ͼ
    BYTE  byRes[20];  //
    BYTE  *pImage;  //ͼƬ
}NET_VCA_SUB_PROCIMG, *LPNET_VCA_SUB_PROCIMG;

typedef struct tagNET_VCA_FD_PROCIMG_RESULT
{
    DWORD dwSize;   //ṹС
    DWORD dwImageId; //ͼID
    BYTE byRes[20]; //
    DWORD dwSubImageNum;  //ͼ
    NET_VCA_SUB_PROCIMG  struProcImg[MAX_TARGET_NUM];  //ͼϢ
}NET_VCA_FD_PROCIMG_RESULT, *LPNET_VCA_FD_PROCIMG_RESULT;

typedef struct tagNET_VCA_PICMODEL_RESULT
{
    DWORD dwImageLen;  //ͼƬݳ
    DWORD dwModelLen;  //ģݳ
    BYTE  byRes[20]; //
    BYTE  *pImage;  //ͼƬָ
    BYTE  *pModel;  //ģָ
}NET_VCA_PICMODEL_RESULT, *LPNET_VCA_PICMODEL_RESULT;

typedef struct tagNET_VCA_REGISTER_PIC
{
    DWORD dwImageID; //ͼID
    DWORD dwFaceScore;        //,0-100
    NET_VCA_RECT struVcaRect;  //ͼ
    BYTE  byRes[20];  //
}NET_VCA_REGISTER_PIC, *LPNET_VCA_REGISTER_PIC;

#define MAX_HUMAN_PICTURE_NUM  10   //Ƭ
#define MAX_HUMAN_BIRTHDATE_LEN 10   //³

typedef struct tagNET_DVR_AREAINFOCFG
{ 
    WORD wNationalityID; //
    WORD wProvinceID; //ʡ
    WORD wCityID; //
    WORD wCountyID; //
    BYTE byRes[4]; //
}NET_DVR_AREAINFOCFG, *LPNET_DVR_AREAINFOCFG;

typedef struct tagNET_VCA_HUMAN_ATTRIBUTE
{
    BYTE   bySex; //Ա0-У1-Ů
    BYTE   byCertificateType; //֤ͣ0-֤1-֤
    BYTE   byBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //£磺201106
    BYTE   byName[NAME_LEN]; //
    NET_DVR_AREAINFOCFG struNativePlace; //
    BYTE   byCertificateNumber[NAME_LEN];  //֤
    BYTE   byRes2[20];
}NET_VCA_HUMAN_ATTRIBUTE, *LPNET_VCA_HUMAN_ATTRIBUTE;

typedef struct tagNET_VCA_HUMANATTRIBUTE_COND
{
    BYTE   bySex; //Ա0-ã1-У2-Ů
    BYTE   byCertificateType; //֤ͣ0-ã1-֤2-֤
    BYTE   byStartBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ʼ£磺201106
    BYTE   byEndBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ֹ£201106
    BYTE   byName[NAME_LEN]; //
    NET_DVR_AREAINFOCFG struNativePlace; //
    BYTE   byCertificateNumber[NAME_LEN];  //֤
    BYTE   byRes[20];
}NET_VCA_HUMANATTRIBUTE_COND, *LPNET_VCA_HUMANATTRIBUTE_COND;


typedef struct tagNET_VCA_BLACKLIST_INFO
{
    DWORD  dwSize;   //ṹС
    DWORD  dwRegisterID;  //עIDţֻ
    DWORD  dwGroupNo; //
    BYTE   byType; //ڰ־0-ȫ1-2-
    BYTE   byLevel; //ȼ0-ȫ1-ͣ2-У3-
    BYTE   byRes1[2];  //
    NET_VCA_HUMAN_ATTRIBUTE struAttribute;  //ԱϢ
    BYTE   byRemark[NAME_LEN]; //עϢ
    BYTE   byRes2[20];
}NET_VCA_BLACKLIST_INFO, *LPNET_VCA_BLACKLIST_INFO;

typedef struct tagNET_VCA_BLACKLIST_PARA
{
    DWORD dwSize;   //ṹС
    NET_VCA_BLACKLIST_INFO struBlackListInfo;  //
    DWORD dwRegisterPicNum;  //ͼ
    NET_VCA_PICMODEL_RESULT struRegisterPic[MAX_HUMAN_PICTURE_NUM];  //ͼƬϢ
    BYTE  byRes[40]; //
}NET_VCA_BLACKLIST_PARA, *LPNET_VCA_BLACKLIST_PARA;

typedef struct tagNET_VCA_BLACKLIST_COND
{
    LONG  lChannel; //ͨ
    DWORD dwGroupNo; //
    BYTE  byType; //ڰ־0-ȫ1-2-
    BYTE  byLevel; //ȼ0-ȫ1-ͣ2-У3-
    BYTE  byRes1[2];  //
    NET_VCA_HUMAN_ATTRIBUTE struAttribute; //ԱϢ
    BYTE  byRes[20];
}NET_VCA_BLACKLIST_COND, *LPNET_VCA_BLACKLIST_COND;

typedef struct tagNET_VCA_BLACKLIST_PIC
{
    DWORD dwSize;   //ṹС
    DWORD dwFacePicNum;  //ͼ
    BYTE  byRes[20]; //
    NET_VCA_PICMODEL_RESULT  struBlackListPic[MAX_HUMAN_PICTURE_NUM];  //ƬϢ
}NET_VCA_BLACKLIST_PIC, *LPNET_VCA_BLACKLIST_PIC;

typedef struct tagNET_VCA_FIND_PICTURECOND
{
    LONG lChannel;//ͨ
    NET_DVR_TIME struStartTime;//ʼʱ
    NET_DVR_TIME struStopTime;//ʱ
    BYTE byRes[12]; //
}NET_VCA_FIND_PICTURECOND, *LPNET_VCA_FIND_PICTURECOND;

#define MAX_FACE_PIC_LEN   6144   //ͼƬݳ
typedef struct tagNET_VCA_SUB_SNAPPIC_DATA
{
    DWORD dwFacePicID; //ͼID
    DWORD dwFacePicLen;  //ͼݳ
    NET_DVR_TIME struSnapTime;  //ץʱ
    DWORD dwSimilarity; //ƶ
    BYTE  byRes[16];  //
    char  sPicBuf[MAX_FACE_PIC_LEN];  //ͼƬ
}NET_VCA_SUB_SNAPPIC_DATA, *LPNET_VCA_SUB_SNAPPIC_DATA;

typedef struct tagNET_VCA_ADVANCE_FIND
{
    DWORD dwFacePicID; //ͼƬID
    BYTE  byRes[36];
}NET_VCA_ADVANCE_FIND, *LPNET_VCA_ADVANCE_FIND;

typedef struct tagNET_VCA_NORMAL_FIND
{
    DWORD dwImageID; //ͼID
    DWORD dwFaceScore;  //
    NET_VCA_RECT struVcaRect; //ͼ
    BYTE byRes[20];
}NET_VCA_NORMAL_FIND, *LPNET_VCA_NORMAL_FIND;

typedef union tagNET_VCA_FIND_SNAPPIC_UNION
{
    NET_VCA_NORMAL_FIND  struNormalFind; //ͨ
    NET_VCA_ADVANCE_FIND struAdvanceFind; //߼
}NET_VCA_FIND_SNAPPIC_UNION, *LPNET_VCA_FIND_SNAPPIC_UNION;

typedef enum _VCA_FIND_SNAPPIC_TYPE_
{
    VCA_NORMAL_FIND  = 0x00000000,   //ͨ
        VCA_ADVANCE_FIND  = 0x00000001  //߼
}VCA_FIND_SNAPPIC_TYPE;

typedef struct tagNET_VCA_FIND_PICTURECOND_ADVANCE
{
    LONG lChannel;//ͨ
    NET_DVR_TIME struStartTime;//ʼʱ
    NET_DVR_TIME struStopTime;//ʱ
    BYTE byThreshold;  //ֵ0-100
    BYTE byRes[23]; //
    VCA_FIND_SNAPPIC_TYPE dwFindType;//ͣVCA_FIND_SNAPPIC_TYPE
    NET_VCA_FIND_SNAPPIC_UNION uFindParam; //
}NET_VCA_FIND_PICTURECOND_ADVANCE, *LPNET_VCA_FIND_PICTURECOND_ADVANCE;

typedef struct tagNET_VCA_FACESNAP_INFO_ALARM
{
    DWORD dwRelativeTime;     // ʱ
    DWORD dwAbsTime;            // ʱ
    DWORD dwSnapFacePicID;       //ץͼID
    DWORD dwSnapFacePicLen;        //ץͼĳȣΪ0ʾûͼƬ0ʾͼƬ
    NET_VCA_DEV_INFO struDevInfo;        //ǰ豸Ϣ
       BYTE  byRes[20];              // ֽ
    BYTE  *pBuffer1;  //ץͼͼƬ
}NET_VCA_FACESNAP_INFO_ALARM, *LPNET_VCA_FACESNAP_INFO_ALARM;

typedef struct tagNET_VCA_BLACKLIST_INFO_ALARM
{
    NET_VCA_BLACKLIST_INFO struBlackListInfo; //Ϣ
    DWORD dwBlackListPicLen;       //ͼĳȣΪ0ʾûͼƬ0ʾͼƬ
       BYTE  byRes[20];              // ֽ
    BYTE  *pBuffer1;  //ͼͼƬ
}NET_VCA_BLACKLIST_INFO_ALARM, *LPNET_VCA_BLACKLIST_INFO_ALARM;

typedef struct tagNET_VCA_FACESNAP_MATCH_ALARM
{
    DWORD dwSize;             // ṹС
    float fSimilarity; //ƶȣ[0.001,1]
    NET_VCA_FACESNAP_INFO_ALARM  struSnapInfo; //ץϢ
    NET_VCA_BLACKLIST_INFO_ALARM struBlackListInfo; //Ϣ
    char         sStorageIP[16];        //洢IPַ
    WORD            wStoragePort;            //洢˿ں
    BYTE             byRes[42];              // ֽ
}NET_VCA_FACESNAP_MATCH_ALARM, *LPNET_VCA_FACESNAP_MATCH_ALARM;


typedef struct tagNET_VCA_BLACKLIST_INFO_ALARM_LOG
{
    NET_VCA_BLACKLIST_INFO struBlackListInfo; //Ϣ
    DWORD dwBlackListPicID;       //ͼIDڲͼƬ
       BYTE  byRes[20];              // ֽ
}NET_VCA_BLACKLIST_INFO_ALARM_LOG, *LPNET_VCA_BLACKLIST_INFO_ALARM_LOG;

typedef struct tagNET_VCA_FACESNAP_INFO_ALARM_LOG
{
    DWORD dwRelativeTime;     // ʱ
    DWORD dwAbsTime;            // ʱ
    DWORD dwSnapFacePicID;       //ץͼID
    NET_VCA_DEV_INFO       struDevInfo;        //ǰ豸Ϣ
       BYTE  byRes[20];              // ֽ
}NET_VCA_FACESNAP_INFO_ALARM_LOG, *LPNET_VCA_FACESNAP_INFO_ALARM_LOG;

typedef struct tagNET_VCA_FACESNAP_MATCH_ALARM_LOG
{
    DWORD dwSize;             // ṹС
    float fSimilarity; //ƶȣ[0.001,1]
    NET_VCA_FACESNAP_INFO_ALARM_LOG  struSnapInfoLog; //ץϢ
    NET_VCA_BLACKLIST_INFO_ALARM_LOG struBlackListInfoLog; //Ϣ
    BYTE  byRes[60];              // ֽ
}NET_VCA_FACESNAP_MATCH_ALARM_LOG, *LPNET_VCA_FACESNAP_MATCH_ALARM_LOG;

typedef struct tagNET_VCA_FACEMATCH_PICCOND
{
    DWORD dwSize;             // ṹС
       DWORD dwSnapFaceID; //ץͼID
    DWORD dwBlackListID; //ƥĺID
    DWORD dwBlackListFaceID; //ȶԵĺͼID
    BYTE  byRes[20];              // ֽ
}NET_VCA_FACEMATCH_PICCOND, *LPNET_VCA_FACEMATCH_PICCOND;

typedef struct tagNET_VCA_FACEMATCH_PICTURE
{
    DWORD dwSize;             // ṹС
       DWORD dwSnapFaceLen; //ץͼ
    DWORD dwBlackListFaceLen; //ȶԵĺͼ
    BYTE  byRes[20];              //ֽ
    BYTE *pSnapFace;  //ץͼͼƬ
    BYTE *pBlackListFace;  //ȶԵĺͼ
}NET_VCA_FACEMATCH_PICTURE, *LPNET_VCA_FACEMATCH_PICTURE;

typedef struct tagNET_VCA_BLACKLIST_FASTREGISTER_PARA
{
    DWORD dwSize;   //ṹС
    NET_VCA_BLACKLIST_INFO struBlackListInfo;  //
    DWORD dwImageLen;  //ͼݳ
    BYTE  byRes[124];  //
    BYTE  *pImage;    //ͼ
}NET_VCA_BLACKLIST_FASTREGISTER_PARA, *LPNET_VCA_BLACKLIST_FASTREGISTER_PARA;

//
typedef struct tagNET_VCA_SINGLE_PATH
{
    BYTE  byActive;  // Ƿ,0-,1- 
    BYTE  byType;   //0-洢ץģ1-洢ȶԱ2-洢ץĺͺȶԱ0xff-Ч
    BYTE  bySaveAlarmPic; //ǷڱıͼƬ0-1-
    BYTE  byRes1[5]; //
    DWORD dwDiskDriver;   //̷ţ0ʼ
    DWORD dwLeftSpace;   //ԤλΪG
    BYTE  byRes2[8]; //
}NET_VCA_SINGLE_PATH, *LPNET_VCA_SINGLE_PATH;

//洢·
typedef struct tagNET_VCA_SAVE_PATH_CFG
{ 
    DWORD dwSize;   //ṹС
    NET_VCA_SINGLE_PATH  struPathInfo[MAX_DISKNUM_V30]; //
    BYTE  byRes[40]; //
}NET_VCA_SAVE_PATH_CFG, *LPNET_VCA_SAVE_PATH_CFG;

typedef struct tagNET_DVR_DEV_ACCESS_CFG
{
    DWORD   dwSize;
    NET_DVR_IPADDR     struIP;        //豸IPַ
    WORD     wDevicePort;                 //˿ں
    BYTE    byEnable;                 //Ƿã0-1-
    BYTE     byRes1;                //
    BYTE    sUserName[NAME_LEN];    //豸ĵ¼ʺ
    BYTE    sPassword[PASSWD_LEN];    //豸ĵ¼
    BYTE    byRes2[60];
}NET_DVR_DEV_ACCESS_CFG,*LPNET_DVR_DEV_ACCESS_CFG;

/********************************ʶ end****************************/
//ֱ
#define MAKE_RESOLUTION(_interlace_, _width_, _height_, _fps_) \
    (((_interlace_)<<28) \
    |((((_width_)>>3)&0x1ff)<<19)| \
    ((((_height_)>>1)&0x7ff)<<8)| \
((_fps_)&0xff))
#define GET_RES_INTERLACE(_res_) \
(((_res_)>>28)&0x1)
#define GET_RES_WIDTH(_res_) \
((((_res_)>>19)&0x1ff)<<3)
#define GET_RES_HEIGHT(_res_) \
((((_res_)>>8)&0x7ff)<<1)
#define GET_RES_FPS(_res_) \
((_res_)&0xff)

#define NOT_AVALIABLE    MAKE_RESOLUTION (0,0,0,0)
#define SVGA_60HZ         MAKE_RESOLUTION(0, 800, 600, 60)
#define SVGA_75HZ         MAKE_RESOLUTION(0, 800, 600, 75)
#define XGA_60HZ         MAKE_RESOLUTION(0, 1024, 768, 60) 
#define XGA_75HZ         MAKE_RESOLUTION(0, 1024, 768, 75)
#define SXGA_60HZ          MAKE_RESOLUTION(0, 1280, 1024, 60)
#define SXGA2_60HZ      MAKE_RESOLUTION(0, 1280, 960, 60)
#define _720P_24HZ      MAKE_RESOLUTION(0, 1280, 720, 24)
#define _720P_25HZ      MAKE_RESOLUTION(0, 1280, 720, 25)
#define _720P_30HZ      MAKE_RESOLUTION(0, 1280, 720, 30)  
#define _720P_60HZ      MAKE_RESOLUTION(0, 1280, 720, 60)
#define _720P_50HZ      MAKE_RESOLUTION(0, 1280, 720, 50) 
#define _1080I_60HZ     MAKE_RESOLUTION(1, 1920, 1080, 60)
#define _1080I_50HZ      MAKE_RESOLUTION(1, 1920, 1080, 50)
#define _1080P_60HZ     MAKE_RESOLUTION(0, 1920, 1080, 60)
#define _1080P_50HZ     MAKE_RESOLUTION(0, 1920, 1080, 50)
#define _1080P_30HZ     MAKE_RESOLUTION(0, 1920, 1080, 30)
#define _1080P_25HZ     MAKE_RESOLUTION(0, 1920, 1080, 25)
#define _1080P_24HZ     MAKE_RESOLUTION(0, 1920, 1080, 24)
#define UXGA_60HZ          MAKE_RESOLUTION(0, 1600, 1200, 60)
#define UXGA_30HZ          MAKE_RESOLUTION(0, 1600, 1200, 30)
#define WSXGA_60HZ         MAKE_RESOLUTION(0, 1680, 1050, 60)
#define WUXGA_60HZ      MAKE_RESOLUTION(0, 1920, 1200, 60)
#define WUXGA_30HZ         MAKE_RESOLUTION(0, 1920, 1200, 30)
#define WXGA_60HZ          MAKE_RESOLUTION(0, 1360, 768, 60)
#define SXGA_PLUS_60HZ    MAKE_RESOLUTION(0, 1400, 1050, 60)
#define VGA_MODE_3840x2160_30HZ MAKE_RESOLUTION(0, 3840, 2160, 30)
#define VGA_MODE_3840x2160_60HZ MAKE_RESOLUTION(0, 3840, 2160, 60)



//ʾָͨģʽ
#define  MAX_WINDOWS_NUM 12        //ָģʽ
#define  MAX_SUPPORT_RES 32
#define  MAX_DISPNUM_V41 32
#define  MAX_SDI_RES     16     //SDIʾֱַ֧ͨ

typedef struct tagNET_DVR_DISPWINDOWMODE
{
    BYTE byDispChanType;//ʾͨͣ0-BNC, 1-VGA, 2-HDMI, 3-DVI 4-SDI
    BYTE byDispChanSeq;//ʾͨ,1ʼVGAʾڼVGA
    BYTE byRes[2];
    BYTE byDispMode[MAX_WINDOWS_NUM/*12*/];
}NET_DVR_DISPWINDOWMODE, *LPNET_DVR_DISPWINDOWMODE;

typedef struct tagNET_DVR_DISPINFO
{
    BYTE  byChanNums;//ͨ
    BYTE  byStartChan;//ʼͨ
    BYTE  byRes[2];
    DWORD    dwSupportResolution[MAX_SUPPORT_RES/*32*/];//ֱַ֧
}NET_DVR_DISPINFO, *LPNET_DVR_DISPINFO;

//ƴϢ
typedef struct tagNET_DVR_SCREENINFO
{
    BYTE  bySupportBigScreenNums;//ƴ
    BYTE  byStartBigScreenNum;//ƴʼ
    BYTE  byMaxScreenX;//ƴģʽ
    BYTE  byMaxScreenY;
    BYTE  byRes[8];
}NET_DVR_SCREENINFO, *LPNET_DVR_SCREENINFO;

typedef struct tagNET_DVR_SDI_INFO
{
    BYTE  byChanNums;//ͨ
    BYTE  byStartChan;//ʼͨ
    BYTE  byRes[2];
    DWORD dwSupportResolution[MAX_SDI_RES/*16*/];//ֱַ֧
}NET_DVR_SDI_INFO,*LPNET_DVR_SDI_INFO;

typedef struct tagNET_DVR_MATRIX_ABILITY_V41
{
    DWORD dwSize;
    BYTE  byDspNums;//DSP  
    BYTE  byDecChanNums;//ͨ
    BYTE  byStartChan;//ʼͨ
    BYTE  byRes1[5];
    NET_DVR_DISPINFO struVgaInfo;//VGAʾͨϢ
    NET_DVR_DISPINFO struBncInfo;//BNCʾͨϢ
    NET_DVR_DISPINFO struHdmiInfo;//HDMIʾͨϢ
    NET_DVR_DISPINFO struDviInfo;//DVIʾͨϢ
    NET_DVR_DISPWINDOWMODE struDispMode[MAX_DISPNUM_V41/*32*/];
    NET_DVR_SCREENINFO struBigScreenInfo;
    BYTE  bySupportAutoReboot; //Ƿ֧Զ0-֧֣1-֧
    BYTE  byRes2[3];
    NET_DVR_SDI_INFO struSDIInfo;//SDIʾͨϢ
    BYTE  byRes3[48];
} NET_DVR_MATRIX_ABILITY_V41, *LPNET_DVR_MATRIX_ABILITY_V41;

//ʾͨ
#define  MAX_WINDOWS                16
#define  MAX_WINDOWS_V41            36

#define  STARTDISPCHAN_VGA        1
#define  STARTDISPCHAN_BNC        9
#define  STARTDISPCHAN_HDMI        25
#define  STARTDISPCHAN_DVI        29

typedef union tagNET_DVR_VIDEO_PLATFORM
{
    BYTE byRes[160];
    struct
    {
        /*ӴڶӦͨӦĽϵͳĲλ(Ƶۺƽ̨нϵͳЧ)*/
        //ۺƽ̨֧ԶԴ˲Ҫ
        BYTE    byJoinDecoderId[MAX_WINDOWS_V41];
        //ʾƵֱʣ1-D1,2-720P,3-1080P豸Ҫݴ˷ֱʽнͨķ䣬1ó1080P豸4ͨ˽ͨ
        BYTE    byDecResolution[MAX_WINDOWS_V41];
        NET_DVR_RECTCFG struPosition; //ʾͨڵǽλ
        BYTE    byRes[80];
    }struVideoPlatform;
    struct
    {
        BYTE    byRes[160];
    }struNotVideoPlatform;
}NET_DVR_VIDEO_PLATFORM, LPNET_DVR_VIDEO_PLATFORM;


typedef struct tagNET_DVR_MATRIX_VOUTCFG
{        
    DWORD    dwSize; 
    BYTE    byAudio;            /*ƵǷ*/
    BYTE    byAudioWindowIdx;      /*ƵӴ*/
    BYTE    byDispChanType;      /*ʾͨͣ0-BNC1-VGA2-HDMI3-DVI4-YPbPr(뿨DECODER_SERVERר)*/   
    BYTE    byVedioFormat;         /*1:NTSC,2:PAL0-NULL*/
    DWORD    dwResolution;//ֱ
    DWORD    dwWindowMode;        /*ģʽȡ*/       
    BYTE    byJoinDecChan[MAX_WINDOWS_V41];/*ӴڹĽͨ,豸ֽ֧ԴԶʱ˲*/
    BYTE    byEnlargeStatus;          /*ǷڷŴ״̬0Ŵ1Ŵ*/
    BYTE    byEnlargeSubWindowIndex;//ŴӴں
    BYTE    byScale; /*ʾģʽ0---ʵʾ1---ʾ( BNC )*/
    BYTE    byUnionType;/*ֹ,0-Ƶۺƽ̨ڲʾͨã1-ʾͨ*/
    NET_DVR_VIDEO_PLATFORM        struDiff;
    DWORD   dwDispChanNum; //ʾţ˲ȫȡʱЧ
    WORD     wLEDWidth;     //LEDֱʿ0ΪЧ   
    WORD     wLEDHeight;    //LEDֱʸߣ0ΪЧ
    BYTE      byEnableVideoEffect;  //ʾЧʹܣ 0-ʹܣ !0-ʹ
    BYTE      byRes[3];  //ֶ
    NET_DVR_VIDEOEFFECT struVideoEffect;   //ʾЧ
    BYTE    byRes2[60];
}NET_DVR_MATRIX_VOUTCFG,*LPNET_DVR_MATRIX_VOUTCFG;

/*豸״̬*/
typedef struct tagNET_DVR_DISP_CHAN_STATUS_V41
{
    BYTE  byDispStatus;      /*ʾ״̬0δʾ1ʾ*/
    BYTE  byBVGA;              /*0-BNC1-VGA 2-HDMI3-DVI4-SDI 0xff-Ч*/
    BYTE  byVideoFormat;     /*Ƶʽ1:NTSC,2:PAL,0-NON*/
    BYTE  byWindowMode;       /*ģʽ*/
    BYTE  byJoinDecChan[MAX_WINDOWS_V41];   /*ӻĽͨ*/
    BYTE  byFpsDisp[MAX_WINDOWS_V41];        /*ÿӻʾ֡*/
    BYTE  byScreenMode;        /*Ļģʽ0-ͨ 1-*/
    BYTE  byRes1[3];
    DWORD  dwDispChan; /*ȡȫʾͨ״̬ʱЧʱ0*/
    BYTE  byRes2[24];                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
}NET_DVR_DISP_CHAN_STATUS_V41, *LPNET_DVR_DISP_CHAN_STATUS_V41;

/*豸״̬*/
typedef struct tagNET_DVR_DECODER_WORK_STATUS_V41
{
    DWORD dwSize;
    NET_DVR_MATRIX_CHAN_STATUS struDecChanStatus[32];     /*ͨ״̬*/
    /*ʾͨ״̬*/
    NET_DVR_DISP_CHAN_STATUS_V41   struDispChanStatus[MAX_DISPNUM_V41/*32*/];     
    BYTE byAlarmInStatus[32];         /*״̬*/
    BYTE byAlarmOutStatus[32];       /*״̬*/
    BYTE byAudioInChanStatus;          /*Խ״̬*/
    BYTE byRes[127];
}NET_DVR_DECODER_WORK_STATUS_V41,*LPNET_DVR_DECODER_WORK_STATUS_V41;
/*******************************ļط-Զ̻ط*******************************/
typedef struct tagNET_DVR_MATRIX_DEC_REMOTE_PLAY_V41
{
    DWORD    dwSize;
    NET_DVR_IPADDR    struIP;        /* DVR IPַ */    
    WORD    wDVRPort;            /* ˿ں */    
    BYTE    byChannel;            /* ͨ */
    BYTE     byReserve;
    BYTE    sUserName[NAME_LEN];        /* û */
    BYTE    sPassword[PASSWD_LEN];        /*  */
    DWORD    dwPlayMode;       /* 0ļ 1ʱ*/            
    NET_DVR_TIME StartTime;
    NET_DVR_TIME StopTime;
    char    sFileName[128];
    BYTE    byRes[64];        /**/
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_V41, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_V41;


#define  MAX_BIGSCREENNUM_SCENE 100
#define  MAX_LAYERNUMS    32

//ʾͨýṹ
typedef struct tagNET_DVR_RECTCFG_SCENE
{
    WORD wXCoordinate; /*ϽʼX*/
    WORD wYCoordinate; /*ϽY*/
    WORD wWidth;       /*ο*/
    WORD wHeight;      /*θ߶*/
}NET_DVR_RECTCFG_SCENE, *LPNET_DVR_RECTCFGSCENE;

typedef struct tagNET_DVR_SCENEDISPCFG
{       
    BYTE    byEnable;//Ƿã0-ã1-
    BYTE    bySoltNum;//λ
    BYTE    byRes1[2]; 
    BYTE    byDispChanNum; 
    BYTE    byAudio;                /*ƵǷ,0-1-*/
    BYTE    byAudioWindowIdx;      /*ƵӴ*/
    BYTE    byVedioFormat;          /*1:NTSC,2:PAL0-NULL*/
    BYTE    byWindowMode;            /*ģʽȡ*/   
    BYTE    byEnlargeStatus;         /*ǷڷŴ״̬0Ŵ1Ŵ*/
    BYTE    byEnlargeSubWindowIndex;//ŴӴں    
    BYTE    byScale; /*ʾģʽ0-ʵʾ1-ʾ( BNC )*/
    DWORD   dwResolution;//ֱ
    BYTE    byJoinDecChan[MAX_WINDOWS_V41];/*ӴڹĽͨ*/
    BYTE    byJoinDecoderId[MAX_WINDOWS_V41];/*λ*/
    //ʾƵֱʣ1-D1,2-720P,3-1080P豸Ҫݴ//ֱʽнͨķ䣬1ó1080P豸4ͨ˽ͨ
    BYTE    byDecResolution[MAX_WINDOWS_V41];
    BYTE    byRow;//ڵе
    BYTE    byColumn;//ڵе
    BYTE    byRes2[5];
    NET_DVR_RECTCFG struDisp; //ǽʾλ
} NET_DVR_SCENEDISPCFG,*LPNET_DVR_SCENEDISPCFG;

typedef struct tagDEV_CHAN_INFO_SCENE
{
    NET_DVR_IPADDR struIP;                /* DVR IPַ */
    WORD     wDVRPort;                 /* ˿ں */
    BYTE     byChannel;        /* ͨţ9000豸IPC룬ͨŴ33ʼ */
    BYTE    byTransProtocol;        /* Э0-TCP1-UDP 2-MCAST3-RTP*/
    BYTE    byTransMode;            /* ģʽ 0 1*/
    BYTE    byFactoryType;                /*ǰ豸*/
    BYTE    byDeviceType;            //豸ͣ1-IPC2- ENCODER
    BYTE    byRes[5];
    BYTE    sUserName[NAME_LEN];    /* ½ʺ */
    BYTE    sPassword[PASSWD_LEN];    /*  */
} NET_DVR_DEV_CHAN_INFO_SCENE,*LPNET_DVR_DEV_CHAN_INFO_SCENE;

/*ý*/
typedef struct tagSTREAM_MEDIA_SERVER_CFG_SCENE
{
    BYTE    byValid;            /*Ƿýȡ,0ʾЧ*/
    BYTE    byRes1[3];
    NET_DVR_IPADDR struDevIP;    /*ýַ*/
    WORD    wDevPort;            /*ý˿*/
    BYTE    byTransmitType;        /*Э0-TCP1-UDP */
    BYTE    byRes2[5];
}NET_DVR_STREAM_MEDIA_SERVER_CFG_SCENE,*LPNET_DVR_STREAM_MEDIA_SERVER_CFG_SCENE;

typedef struct tagPU_STREAM_CFG_SCENE
{
    NET_DVR_STREAM_MEDIA_SERVER_CFG_SCENE    streamMediaServerCfg;
    NET_DVR_DEV_CHAN_INFO_SCENE                struDevChanInfo;
}NET_DVR_PU_STREAM_CFG_SCENE,*LPNET_DVR_PU_STREAM_CFG_SCENE;

typedef struct  tagNET_DVR_CYC_SUR_CHAN_ELE_SCENE
{
    BYTE                            byEnable;    /* Ƿ 0 1*/
    BYTE                            byRes[3];
    NET_DVR_STREAM_MEDIA_SERVER_CFG_SCENE    struStreamMediaSvrCfg;    
    NET_DVR_DEV_CHAN_INFO_SCENE            struDecChanInfo;    /*ѲͨϢ*/
}NET_DVR_CYC_SUR_CHAN_ELE_SCENE,*LPNET_DVR_CYC_SUR_CHAN_ELE_SCENE;

//Ѳṹ
typedef struct  tagNET_DVR_MATRIX_LOOP_DECINFO_SCENE
{
    WORD    wPoolTime;        /*ѯ*/
    BYTE    byRes1[2];
    NET_DVR_CYC_SUR_CHAN_ELE_SCENE    struChanArray[MAX_CYCLE_CHAN/*16*/];
    BYTE    byRes2[4];
} NET_DVR_MATRIX_LOOP_DECINFO_SCENE,*LPNET_DVR_MATRIX_LOOP_DECINFO_SCENE;

//ͨýṹ
typedef struct tagNET_DVR_DECODECHANCFG_SCENE/*struct size : 2064*/
{
    BYTE    byDecodeEnable;//ͣ־0-ֹͣ1-ö̬룬2-Ѳ
    BYTE    bySlotNum;//λ
    BYTE    byDecChan;
    BYTE    byJointAllDecodeChan;        //Ƿܽͨ 0-1-
    BYTE    byJointSlotNum;            //ĲλţܽĲλţ
    BYTE    byJointChanNum;        //ͨţܽͨţ
    BYTE    byRes[2];
    union
    {
        NET_DVR_PU_STREAM_CFG_SCENE struSceneDynamicDecCfg; 
        NET_DVR_MATRIX_LOOP_DECINFO_SCENE struSceneCycDecCfg;
    } struDecCfg;
}NET_DVR_DECODECHANCFG_SCENE,*LPNET_DVR_DECODECHANCFG_SCENE;

typedef struct tagNET_DVR_BIGSCREENCFG_SCENE
{
    BYTE byAllValid; /*ʹܱ־ */
    BYTE byAssociateBaseMap;//ĵͼţ0
    BYTE byEnableSpartan;//ʹܣ1-0-
    BYTE byRes;
    NET_DVR_WINCFG struWinCfg[MAX_LAYERNUMS];
    NET_DVR_BIGSCREENCFG struBigScreen;
}NET_DVR_BIGSCREENCFG_SCENE, *LPNET_DVR_BIGSCREENCFG_SCENE;

typedef struct tagNET_DVR_MATRIX_SCENECFG
{
    DWORD dwSize;
    BYTE  sSceneName[NAME_LEN];
    BYTE  byBigScreenNums;//ĸֵͨȡ
    BYTE  byRes1[3];
    WORD  wDecChanNums;//нͨĸ
    WORD  wDispChanNums;//ʾͨĸ
    BYTE  byRes2[12];
    BYTE  *pBigScreenBuffer;//û, byBigScreenNumssizeof(NET_DVR_BIGSCREENCFG_SCENE)
    BYTE  *pDecChanBuffer;//ͨû, wDecChanNumssizeof(NET_DVR_DECODECHANCFG_SCENE)
    BYTE  *pDispChanBuffer;//ʾͨû, wDispChanNumssizeof(NET_DVR_SCENEDISPCFG)
}NET_DVR_MATRIX_SCENECFG, *LPNET_DVR_MATRIX_SCENECFG;



typedef struct tagNET_DVR_BIGSCREENASSOCIATECFG
{
    DWORD dwSize;
    BYTE  byEnableBaseMap;//ʹܵͼʾ
    BYTE  byAssociateBaseMap;//ĵͼţ0
    BYTE  byEnableSpartan;//ʹܣ1-0-
    BYTE  byRes[21];
} NET_DVR_BIGSCREENASSOCIATECFG, *LPNET_DVR_BIGSCREENASSOCIATECFG;
/**************************************************************/
#define MAX_WIN_COUNT  224 //ֵ֧󿪴

typedef struct tagNET_DVR_SCREEN_WINCFG
{
    DWORD    dwSize;
    BYTE    byVaild;
    BYTE    byInputType;        //CAM_MDOE
    WORD    wInputIdx;            /*Դ*/
    DWORD    dwLayerIdx;            /*ͼ㣬0Ϊײ*/
    NET_DVR_RECTCFG  struWin;    //ĿĴ(ʾǽ)
    BYTE    byWndIndex;            //ں
    BYTE    byCBD;                //0-ޣ1-2-
    BYTE    bySubWnd;            //0ǣ1
    BYTE    byRes1;
    DWORD   dwDeviceIndex;//豸
    BYTE    byRes2[16];
}NET_DVR_SCREEN_WINCFG, *LPNET_DVR_SCREEN_WINCFG;

typedef struct tagNET_DVR_WINLIST
{
    DWORD    dwSize;
    WORD    wScreenSeq;    //豸
    BYTE    byRes[10];
    DWORD    dwWinNum;    //豸صĴ
    BYTE    *pBuffer;    //ϢΪ224*sizeof(NET_DVR_WINCFG)
    DWORD   dwBufLen;    //ָ볤
}NET_DVR_WINLIST,*LPNET_DVR_WINLIST;

#define MAX_LAYOUT_COUNT 16        //󲼾
typedef struct tagNET_DVR_LAYOUTCFG
{
    DWORD dwSize;
    BYTE  byValid;                                //ǷЧ
    BYTE  byRes1[3];
    BYTE  byLayoutName[NAME_LEN/*32*/];            //            
    NET_DVR_SCREEN_WINCFG struWinCfg[MAX_WIN_COUNT/*224*/];    //ڴڲ
    BYTE  byRes2[16];
}NET_DVR_LAYOUTCFG, *LPNET_DVR_LAYOUTCFG;

typedef struct tagNET_DVR_LAYOUT_LIST
{
    DWORD dwSize;
    NET_DVR_LAYOUTCFG struLayoutInfo[MAX_LAYOUT_COUNT/*16*/];   //в
    BYTE byRes[4];
}NET_DVR_LAYOUT_LIST, *LPNET_DVR_LAYOUT_LIST;

#define MAX_CAM_COUNT  224

typedef enum tagNET_DVR_CAM_MODE
{
    NET_DVR_UNKNOW  = 0,//Ч
        NET_DVR_CAM_BNC,
        NET_DVR_CAM_VGA,
        NET_DVR_CAM_DVI,
        NET_DVR_CAM_HDMI,
        NET_DVR_CAM_IP,
        NET_DVR_CAM_RGB,
        NET_DVR_CAM_DECODER,
        NET_DVR_CAM_MATRIX,
        NET_DVR_CAM_YPBPR,
        NET_DVR_CAM_USB,
        NET_DVR_CAM_SDI,
        NET_DVR_CAM_HDI,
        NET_DVR_CAM_DP,
        NET_DVR_CAM_HDTVI,
        NET_DVR_CAM_JOINT,   //ƴźԴ
        NET_DVR_CAM_HDBASET,
}NET_DVR_CAM_MODE;

typedef struct tagNET_DVR_INPUTSTREAMCFG
{
    DWORD    dwSize ;
    BYTE    byValid;
    BYTE    byCamMode;                        //źԴͣNET_DVR_CAM_MODE
    WORD    wInputNo;                        //źԴ0-224
    BYTE    sCamName[NAME_LEN] ;            //źԴ
    NET_DVR_VIDEOEFFECT struVideoEffect;    //Ƶ
    NET_DVR_PU_STREAM_CFG    struPuStream;    //ipʱʹ
    WORD    wBoardNum ;                        //źԴڵİ忨
    WORD    wInputIdxOnBoard;                //źԴڰ忨ϵλ
    DWORD   dwResolution;//ֱ
    BYTE    byVideoFormat;//ƵʽVIDEO_STANDARD
    BYTE    byStatus;    //źԴ״̬0-ֶЧ 1-ź 2-ź 3-쳣 
    BYTE    sGroupName[NAME_LEN/*32*/];    //źԴ 
    BYTE    byJointMatrix;            //   0-  1-
    BYTE    byRes;  
}NET_DVR_INPUTSTREAMCFG, *LPNET_DVR_INPUTSTREAMCFG;

typedef struct tagNET_DVR_INPUTSTREAM_LIST
{
    DWORD dwSize;
    NET_DVR_INPUTSTREAMCFG struInputStreamInfo[MAX_CAM_COUNT]; //źԴ
    BYTE byRes[4];
}NET_DVR_INPUTSTREAM_LIST, *LPNET_DVR_INPUTSTREAM_LIST;

/**************************************************************/
/*ͨ*/
typedef struct tagNET_DVR_OUTPUTPARAM
{
    DWORD  dwSize;
    BYTE   byMonMode;        /*ģʽ,1-BNC,2-VGA,3-DVI,4-HDMI*/
    BYTE   byRes1[3];
    DWORD  dwResolution;    /*ֱʣȡֵ֧Ľ*/
    NET_DVR_VIDEOEFFECT  struVideoEffect;    /*ͨƵ*/
    BYTE    byRes2[32];
}NET_DVR_OUTPUTPARAM, *LPNET_DVR_OUTPUTPARAM;

typedef struct tagNET_DVR_OUTPUTCFG
{
    DWORD    dwSize;
    BYTE    byScreenLayX;                        //-
    BYTE    byScreenLayY;                        //-
    WORD    wOutputChanNum;                    //ͨ0ʾ豸ֵ֧ͨȡֵʾʵͨ
    BYTE    byRes1[4];
    NET_DVR_OUTPUTPARAM  struOutputParam;    /*ͨƵ*/
    BYTE    sWallName[16];                    //ǽ
    BYTE    byRes2[8];
}NET_DVR_OUTPUTCFG, *LPNET_DVR_OUTPUTCFG;

/**************************************************************/
#define SCREEN_PROTOCOL_NUM      20    //ֵ֧Э
//
typedef struct tagNET_DVR_SCREENSERVER_ABILITY
{
    DWORD dwSize;               /*ṹ*/
    BYTE byIsSupportScreenNum; /*ִ֧Ŀ*/
    BYTE bySerialNums;            //ڸ
    BYTE byMaxInputNums;
    BYTE byMaxLayoutNums;
    BYTE byMaxWinNums;
    BYTE byRes1[19];
    BYTE byMaxScreenLayX;//-
    BYTE byMaxScreenLayY;//-
    WORD wMatrixProtoNum; /*ЧĴЭĿ*/
    NET_DVR_PROTO_TYPE struScreenProto[SCREEN_PROTOCOL_NUM];/*Эб*/
    BYTE byRes2[24];
}NET_DVR_SCREENSERVER_ABILITY, *LPNET_DVR_SCREENSERVER_ABILITY;

//
typedef struct tagNET_DVR_SCREENCONTROL_ABILITY
{
    DWORD dwSize;           /*ṹ*/
    BYTE byLayoutNum;         /* ָ*/
    BYTE byWinNum;             /*Ļڸ*/
    BYTE byOsdNum;          /*OSD*/
    BYTE byLogoNum;         /*Logo*/
    BYTE byInputStreamNum;  //Դ ---豸֧ͨԴԴ
    BYTE byOutputChanNum;    //ͨ---豸֧ͨ
    BYTE byCamGroupNum;        /**/
    BYTE byPlanNum;            /*Ԥ*/
    BYTE byRes1[5];
    BYTE byIsSupportPlayBack;  /*Ƿֻ֧ط*/    
    BYTE byMatrixInputNum;  //֧
    BYTE byMatrixOutputNum; //֧
    NET_DVR_DISPINFO struVgaInfo;//VGAϢ
    NET_DVR_DISPINFO struBncInfo;//BNCϢ
    NET_DVR_DISPINFO struHdmiInfo;//HDMIϢ
    NET_DVR_DISPINFO struDviInfo;//DVIϢ
    BYTE byMaxUserNums;//֧û
    BYTE byPicSpan;        //ͼȣһŵͼɸǵĻ
    WORD wDVCSDevNum;    //ֲʽ豸
    WORD wNetSignalNum;    //Դ
    WORD wBaseCoordinateX;//׼
    WORD wBaseCoordinateY; 
    BYTE byExternalMatrixNum;    //Ӿ
    BYTE byRes2[49];
}NET_DVR_SCREENCONTROL_ABILITY, *LPNET_DVR_SCREENCONTROL_ABILITY;

/*******************************ź״̬*******************************/
typedef struct tagNET_DVR_ANALOGINPUTSTATUS
{
    DWORD    dwLostFrame;        /*Ƶ붪֡*/
    BYTE    byHaveSignal;        /*ǷƵź*/
    BYTE    byVideoFormat;        /*Ƶʽ1NTSC,2PAL,0*/
    BYTE    byRes[46];
} NET_DVR_ANALOGINPUTSTATUS, *LPNET_DVR_ANALOGINPUTSTATUS;

typedef union tagNET_DVR_INPUTSTATUS_UNION
{
    NET_DVR_MATRIX_CHAN_STATUS struIpInputStatus;
    NET_DVR_ANALOGINPUTSTATUS struAnalogInputStatus;
} NET_DVR_INPUTSTATUS_UNION, *LPNET_DVR_INPUTSTATUS_UNION;

typedef struct tagNET_DVR_INPUTSTATUS
{
    WORD    wInputNo;        /*źԴ*/
    BYTE    byInputType;    //NET_DVR_CAM_MODE
    BYTE    byRes1[9];
    NET_DVR_INPUTSTATUS_UNION struStatusUnion;
    BYTE    byRes2[16];
} NET_DVR_INPUTSTATUS, *LPNET_DVR_INPUTSTATUS;

typedef struct tagNET_DVR_SCREENINPUTSTATUS
{
    DWORD    dwSize;
    BYTE    byRes[12];
    DWORD    dwNums;        //豸صԴ״̬
    BYTE    *pBuffer;    //
    DWORD   dwBufLen;    //ָ볤ȣ
}NET_DVR_SCREENINPUTSTATUS,*LPNET_DVR_SCREENINPUTSTATUS;

typedef struct tagNET_DVR_SCREENALARMCFG
{
    DWORD    dwSize;
    BYTE    byAlarmType;    //ͣ1-Ӱγ2-Ӱ룬3-ϵͳ״̬쳣4-ϵͳָָ 5-Դ쳣   6-¶ȱ 7-FPGA汾ƥ 8-Ԥʼ 9-Ԥ 10- 11-IPַͻ12-쳣
    BYTE    byBoardType;    // 1- 2- 3-壬4-壬Ϊ1236ʱʹ 
    BYTE    bySubException;    //쳣ʱ쳣 1- ֱı 2-˿͸ı3-ֱʴ4-ֱʸı䵼½Դ㣬رոԴӦڡ5-ֱʸı䣬ѿű1/88Χ6-ֱʻָ,7-ֱʸı䵼,豸رմ 
    BYTE    byRes1;
    WORD    wStartInputNum; // 쳣Դ쳣㣩 
    WORD    wEndInputNum;    // 쳣Դ쳣յ㣩 
    BYTE    byRes2[16];       
}NET_DVR_SCREENALARMCFG, *LPNET_DVR_SCREENALARMCFG;

typedef struct tagNET_DVR_MATRIX_CFG
{
    BYTE  byValid;                //жǷģǷЧ
    BYTE  byCommandProtocol;    //ģָ4֣
    BYTE  byScreenType;            //    
    BYTE  byRes1;
    BYTE  byScreenToMatrix[32];    //ģĻĶӦϵ
    BYTE  byRes2[4];
}NET_DVR_MATRIX_CFG, *LPNET_DVR_MATRIX_CFG;

typedef struct tagNET_DVR_DIGITALSCREEN
{
    NET_DVR_IPADDR  struAddress;/*豸Ϊ豸ʱIPϢ*/
    WORD            wPort;        //ͨ
    BYTE            byRes[26];  //
}NET_DVR_DIGITALSCREEN, *LPNET_DVR_DIGITALSCREEN;
typedef struct tagNET_DVR_ANALOGSCREEN
{
    BYTE    byDevSerPortNum;   /*豸Ĵں*/
    BYTE    byScreenSerPort;  /*ӴĴں*/
    BYTE    byRes[130];   
    NET_DVR_MATRIX_CFG struMatrixCfg;
}NET_DVR_ANALOGSCREEN, *LPNET_DVR_ANALOGSCREEN;

typedef union tagNET_DVR_SCREEN_UNION
{
    NET_DVR_DIGITALSCREEN struDigitalScreen;
    NET_DVR_ANALOGSCREEN struAnalogScreen;
}NET_DVR_SCREEN_UNION, *LPNET_DVR_SCREEN_UNION;
typedef struct tagNET_DVR_SCREEN_SCREENINFO
{
    DWORD dwSize;
    BYTE byValid;                //ǷЧ
    BYTE nLinkMode;                //ӷʽ0-ڣ1-
    BYTE byDeviceType;            //豸ͺţȡ
    BYTE byScreenLayX;            //-
    BYTE byScreenLayY;            //-
    BYTE byRes1[3];
    BYTE sUserName[NAME_LEN];    /*¼û*/
    BYTE sPassword[PASSWD_LEN]; /*¼*/   
    BYTE sDevName[NAME_LEN];    /*豸*/
    NET_DVR_SCREEN_UNION struScreenUnion;
    BYTE byInputNum;            // Դ
    BYTE byOutputNum;            // Դ
    BYTE byCBDNum;                //CBD
    BYTE byRes2[29];
} NET_DVR_SCREEN_SCREENINFO, *LPNET_DVR_SCREEN_SCREENINFO;

/*******************************ͼϴ*******************************/
typedef struct tagNET_DVR_BASEMAP_CFG
{    
    BYTE byScreenIndex;         //Ļ
    BYTE byMapNum;                /*ָ˶ٿ */
    BYTE res[2];
    WORD wSourWidth;            /* ԭͼƬĿ */
    WORD wSourHeight;            /* ԭͼƬĸ߶ */
}NET_DVR_BASEMAP_CFG, LPNET_DVR_BASEMAP_CFG;


typedef struct tagNET_DVR_PICCFG
{
    DWORD    dwSize;        //С
    BYTE    byUseType;    //1-ͼ2-GIFͼƬ3-CADͼƬ 4-ͼƬ
    BYTE    bySequence;//    
    BYTE    byRes[2];
    NET_DVR_BASEMAP_CFG    struBasemapCfg;
    BYTE    sPicName[NAME_LEN];//ͼƬ
    DWORD   dwVideoWall;       //ǽ 1ֽǽ+3ֽڱ
    BYTE    byRes2[28];
}NET_DVR_PICTURECFG, *LPNET_DVR_PICTURECFG;

/*******************************OSD*******************************/
#define MAX_OSDCHAR_NUM 256
typedef struct tagNET_DVR_OSDCFG
{
    DWORD   dwSize;
    BYTE    byValid;    /*ǷЧ 0Ч 1Ч*/
    BYTE    byDispMode;  //ʾģʽ1-͸2-͸3-ģʽ
    BYTE    byFontColorY; /*ɫY,0-255*/
    BYTE    byFontColorU; /*ɫU,0-255*/
    BYTE    byFontColorV; /*ɫV,0-255*/
    BYTE    byBackColorY; /*ɫY,0-255*/
    BYTE    byBackColorU; /*ɫU,0-255*/
    BYTE    byBackColorV; /*ɫV,0-255*/
    WORD    wXCoordinate;   /*OSDĻϽλx*/
    WORD    wYCoordinate;   /*OSDĻϽλy*/
    WORD    wWidth;       /*OSD*/
    WORD    wHeight;      /*OSD߶*/
    DWORD   dwCharCnt;     /*ַĸ*/
    WORD    wOSDChar[MAX_OSDCHAR_NUM];       /*OSDַ*/
    BYTE    byRes[32];
}NET_DVR_OSDCFG, *LPNET_DVR_OSDCFG;


/*******************************ȡϢ*******************************/
typedef struct tagNET_DVR_SERIAL_CONTROL
{ 
    DWORD    dwSize ;
    BYTE    bySerialNum;        // ڸ
    BYTE    byRes1[3];
    BYTE    bySerial[32];
    BYTE    byRes2[32];
}NET_DVR_SERIAL_CONTROL, *LPNET_DVR_SERIAL_CONTROL;

/*******************************Ļ*******************************/
//ĻԴ
typedef enum tagINPUT_INTERFACE_TYPE
{
    INTERFACE_VGA = 0,
        INTERFACE_SVIDEO, // 2046NL֧֣2046NH֧
        INTERFACE_YPBPR,
        INTERFACE_DVI ,
        INTERFACE_BNC , 
        INTERFACE_DVI_LOOP,//(ͨ) 2046NH֧֣2046NL֧
        INTERFACE_BNC_LOOP, //(ͨ) 2046NH֧֣2046NL.֧
        INTERFACE_HDMI,
        INTERFACE_IP,
        INTERFACE_USB,
        INTERFACE_SDI,
        INTERFACE_DP,
        INTERFACE_HDBASET
}INPUT_INTERFACE_TYPE;
typedef struct tagNET_DVR_INPUT_INTERFACE_CTRL
{
    BYTE    byInputSourceType;    //INPUT_INTERFACE_TYPE
    BYTE    byRes[15];
}NET_DVR_INPUT_INTERFACE_CTRL, *LPNET_DVR_INPUT_INTERFACE_CTRL;
//ʾԪɫ
typedef struct tagNET_DVR_DISPLAY_COLOR_CTRL
{
    BYTE    byColorType;        //1- 2-Աȶ 3-Ͷ 4-
    char    byScale;            //-1 0+1ֵ
    BYTE    byRes[14];
}NET_DVR_DISPLAY_COLOR_CTRL, *LPNET_DVR_DISPLAY_COLOR_CTRL;
//ʾԪλÿ
typedef struct tagNET_DVR_DISPLAY_POSITION_CTRL
{
    BYTE    byPositionType;    //1-ˮƽλ 2-ֱλã
    char    byScale;            //-1 0+1ֵ
    BYTE    byRes[14];
}NET_DVR_DISPLAY_POSITION_CTRL, *LPNET_DVR_DISPLAY_POSITION_CTRL;


/*******************************ĻV41*******************************/
typedef struct tagNET_DVR_RECTCFG_EX 
{
    DWORD dwXCoordinate; /*ϽʼX*/
    DWORD dwYCoordinate; /*ϽY*/
    DWORD dwWidth;       /*ο*/
    DWORD dwHeight;      /*θ߶*/
    BYTE  byRes[4];
}NET_DVR_RECTCFG_EX, *LPNET_DVR_RECTCFG_EX;

/*******************************Ԥ*******************************/
#define        MAX_PLAN_ACTION_NUM     32     //Ԥ
#define        DAYS_A_WEEK                7    //һ7
#define        MAX_PLAN_COUNT            16    //Ԥ


typedef enum
{
    NET_DVR_SWITCH_LAYOUT = 1,         // л Ĭ
        NET_DVR_SCREEN_POWER_OFF,          // رմĻʾ
        NET_DVR_SCREEN_POWER_ON,           // 򿪴Ļʾ
}NET_DVR_PLAN_OPERATE_TYPE;

/*ԤϢ*/
typedef struct  tagNET_DVR_PLAN_INFO
{
    BYTE      byValid;          // ǷЧ
    BYTE      byType;           // NET_DVR_PLAN_OPERATE_TYPE
    WORD      wLayoutNo;      // ֺ
    BYTE    byScreenStyle;    //Ļͺţػã1ǵ2Ǹ
    BYTE    byRes1[3];
    DWORD      dwDelayTime;      // һʱ, λ
    DWORD   dwSerialNo;        //ںţĻʱʹ
    BYTE    byRes2[28];
} NET_DVR_PLAN_INFO, *LPNET_DVR_PLAN_INFO;
typedef struct tagNET_DVR_CYCLE_TIME
{
    BYTE    byValid; 
    BYTE    byRes[3];
    NET_DVR_TIME_EX struTime;
}NET_DVR_CYCLE_TIME, *LPNET_DVR_CYCLE_TIME;
/*Ԥ*/
typedef struct tagNET_DVR_PLAN_CFG
{
    DWORD     dwSize;
    BYTE      byValid;          // ԤǷЧ
    BYTE      byWorkMode;      // Ԥģʽ 1ʾֶ2Զ3Ԥѭ
    BYTE    byWallNo;        //ǽţ1ʼ
    BYTE    byPlanNo;    //ԤţȡԤбʱЧ0-Ч֧
    BYTE      byPlanName[NAME_LEN/*32*/]; //Ԥ
    NET_DVR_TIME_EX struTime; // ģʽΪԶʱʹ
    NET_DVR_CYCLE_TIME struTimeCycle[DAYS_A_WEEK/*7*/]; /*ѭʱ䣬Ϊһڣꡢ¡ʹá磺struTimeCycle[0]еbyValidֵ1ʾִиԤȡֵΪ[0,6]0죬1һԴ*/
    DWORD     dwWorkCount;      // Ԥִд0Ϊһֱѭţֵʾ
    NET_DVR_PLAN_INFO strPlanEntry[MAX_PLAN_ACTION_NUM/*32*/];  // Ԥִе
    BYTE    byRes2[64];
}NET_DVR_PLAN_CFG, *LPNET_DVR_PLAN_CFG;


/*******************************ȡ豸״̬*******************************/
/*Ԥб*/
typedef struct tagNET_DVR_PLAN_LIST
{
    DWORD        dwSize;
    DWORD        dwPlanNums;            //豸źԴ
    BYTE          *pBuffer;            //ָdwInputSignalNumsNET_DVR_PLAN_CFGṹСĻ
    BYTE        byWallNo;            //ǽţ1ʼ
    BYTE        byRes1[2];
    DWORD         dwBufLen;            //仺ȣڵdwInputSignalNumsNET_DVR_PLAN_CFGṹС
    BYTE        byRes2[64];
} NET_DVR_PLAN_LIST,*LPNET_DVR_PLAN_LIST;


/*******************************Ԥ*******************************/
//ýṹΪͨÿƽṹ
typedef struct tagNET_DVR_CONTROL_PARAM
{
    DWORD    dwSize;
    BYTE    sDeviceID[NAME_LEN]; //豸豸ID
    WORD    wChan;                 //ͨ
    BYTE    byIndex;             //ȷʾʲô
    BYTE    byRes1;
    DWORD    dwControlParam;
    BYTE    byMandatoryAlarm;    //1-ʹ  0-ʹ
    BYTE    byRes2[31];
}NET_DVR_CONTROL_PARAM, *LPNET_DVR_CONTROL_PARAM;

/*******************************ȡ豸״̬*******************************/
typedef struct tagNET_DVR_DEVICE_RUN_STATUS
{
    DWORD     dwSize;
    DWORD    dwMemoryTotal;        //ڴ    λKbyte
    DWORD    dwMemoryUsage;        //ڴʹ λKbyte
    BYTE    byCPUUsage;            //CPUʹ 0-100
    BYTE    byMainFrameTemp;   //¶ȣλ϶
    BYTE    byBackPanelTemp;    //¶ȣλ϶
    BYTE    byRes1[1];
    BYTE    byLeftDecResource[32];   //ʣԴԽD1ֱԴΪλbyLeftDecResource[i],ʾλiʣԴ,0xffʾЧǽûӣ
    float    fNetworkFlow;    //,λKB/sСλ
    BYTE    byRes[88];
}NET_DVR_DEVICE_RUN_STATUS, *LPNET_DVR_DEVICE_RUN_STATUS;

// 91ϵHD-SDIDVR Ϣ
typedef struct tagNET_DVR_ACCESS_CAMERA_INFO
{
    DWORD dwSize;
       char  sCameraInfo[32];        // ǰϢ
    BYTE  byInterfaceType;        // ǰ˽ӿͣ1:VGA, 2:HDMI, 3:YPbPr 4:SDI 5:FC
    BYTE  byRes1[3];
    DWORD dwChannel;
       BYTE  byRes[24];
}NET_DVR_ACCESS_CAMERA_INFO, *LPNET_DVR_ACCESS_CAMERA_INFO;

typedef struct tagNET_DVR_AUDIO_INPUT_PARAM
{
    BYTE  byAudioInputType;  //Ƶͣ0-mic in1-line in
    BYTE  byVolume; //volume,[0-100]
    BYTE  byEnableNoiseFilter; //Ƿ-أ-
    BYTE  byres[5];
}NET_DVR_AUDIO_INPUT_PARAM, *LPNET_DVR_AUDIO_INPUT_PARAM;

typedef struct tagNET_DVR_CAMERA_DEHAZE_CFG
{
    DWORD dwSize;
    BYTE byDehazeMode; //0-ã1-Զģʽ2-
    BYTE byLevel; //ȼ0-100
    BYTE byRes[6]; 
}NET_DVR_CAMERA_DEHAZE_CFG, *LPNET_DVR_CAMERA_DEHAZE_CFG;

typedef struct tagNET_DVR_INPUT_SIGNAL_LIST
{
    DWORD        dwSize;
    DWORD        dwInputSignalNums;    //豸źԴ
    BYTE          *pBuffer;            //ָdwInputSignalNumsNET_DVR_INPUTSTREAMCFGṹСĻ
    BYTE        byRes1[3];
    DWORD         dwBufLen;            //仺ȣڵdwInputSignalNumsNET_DVR_INPUTSTREAMCFGṹС
    BYTE        byRes2[64];
} NET_DVR_INPUT_SIGNAL_LIST,*LPNET_DVR_INPUT_SIGNAL_LIST;

// ȫ״̬
#define PULL_DISK_SUCCESS        1   // ȫ̳ɹ
#define PULL_DISK_FAIL            2   // ȫʧ
#define PULL_DISK_PROCESSING    3   // ֹͣ
#define PULL_DISK_NO_ARRAY         4    // в 
#define PULL_DISK_NOT_SUPPORT    5     // ְ֧ȫ

// ɨ״̬
#define SCAN_RAID_SUC            1     // ɨгɹ
#define SCAN_RAID_FAIL            2     // ɨʧ
#define SCAN_RAID_PROCESSING    3    // ɨ
#define SCAN_RAID_NOT_SUPPORT    4     // ֧ɨ

// ǰ״̬
#define SET_CAMERA_TYPE_SUCCESS            1   // ɹ
#define SET_CAMERA_TYPE_FAIL            2   // ʧ
#define SET_CAMERA_TYPE_PROCESSING        3   // ڴ

//9000 2.2
typedef struct tagNET_DVR_RECORD_TIME_SPAN_INQUIRY
{
    DWORD    dwSize;    //ṹС
    BYTE    byType;    //0 Ƶ¼, 1ͼƬͨ¼, 2ANRͨ¼, 3֡ͨ¼
    BYTE     byRes[63]; //
}NET_DVR_RECORD_TIME_SPAN_INQUIRY, *LPNET_DVR_RECORD_TIME_SPAN_INQUIRY;

typedef struct tagNET_DVR_RECORD_TIME_SPAN
{
    DWORD          dwSize;        //ṹС
    NET_DVR_TIME  strBeginTime;  //ʼʱ
    NET_DVR_TIME  strEndTime;    //ʱ
    BYTE          byType;        //0 Ƶ¼, 1ͼƬͨ¼, 2ANRͨ¼, 3֡ͨ¼
    BYTE           byRes[35];     //
}NET_DVR_RECORD_TIME_SPAN, *LPNET_DVR_RECORD_TIME_SPAN;

typedef struct tagNET_DVR_DRAWFRAME_DISK_QUOTA_CFG
{
    DWORD    dwSize;                    //ṹС
    BYTE     byPicQuota;                //ͼƬٷֱ     [0%,  30%]
    BYTE     byRecordQuota;                //ͨ¼ٷֱ [20%, 40%]
    BYTE     byDrawFrameRecordQuota;    //֡¼ٷֱ [30%, 80%]
    BYTE     byRes[61];                    //ֽ
}NET_DVR_DRAWFRAME_DISK_QUOTA_CFG, *LPNET_DVR_DRAWFRAME_DISK_QUOTA_CFG;

typedef struct tagNET_DVR_NAT_PORT
{
    WORD wEnable;         //ö˿Ƿʹӳ
    WORD wExtPort;        //ӳⲿ˿ں
    BYTE byRes[12];       //
}NET_DVR_NAT_PORT, *LPNET_DVR_NAT_PORT;

typedef struct  tagNET_DVR_NAT_CFG
{
    DWORD dwSize;          //ṹС
    WORD wEnableUpnp;     //UPNPǷ
    WORD wEnableNat;        //UPNP˿ӳ䣨NATǷ(wEnableUpnpһ)
    NET_DVR_IPADDR  struIpAddr;      //NAT·LAN IPַ
    NET_DVR_NAT_PORT    struHttpPort;   //web server http˿ӳ
    NET_DVR_NAT_PORT    struCmdPort; //˿ӳ(8000)
    NET_DVR_NAT_PORT    struRtspPort;  //rtsp˿ӳ
    BYTE byFriendName[64]; //
    BYTE byNatType; //UPNP˿ӳͣ0-ֶ1-Զ
    BYTE            byRes1[3];    //
    NET_DVR_NAT_PORT    struHttpsPort;     //https˿ӳ
    BYTE            byres[76];    //
}NET_DVR_NAT_CFG, *LPNET_DVR_NAT_CFG;

typedef struct
{
    DWORD  dwEnabled;               //ö˿Ƿʹӳ
    WORD   wInternalPort;           //ӳǰĶ˿
    WORD   wExternalPort;           //ӳĶ˿
                                    DWORD  dwStatus;                 /*˿ӳ״̬
                                                                     0 δЧ
                                                                     1 δЧӳԴ˿ĿĶ˿һ
                                                                     2 δЧ:  ӳ˿ںѱʹ
                                                                     3 Ч
                                    */
                                    NET_DVR_IPADDR    struNatExternalIp;       //ӳⲿַ
                                    NET_DVR_IPADDR    struNatInternalIp;       //NAT·LAN IPַ
                                    BYTE   byRes[16];               //
}NET_DVR_UPNP_PORT_STATE, *LPNET_DVR_UPNP_PORT_STATE;


typedef struct
{
    NET_DVR_UPNP_PORT_STATE strUpnpPort[UPNP_PORT_NUM];     //˿ӳ״̬,0 web server˿ 1 ˿ 2 rtsp˿
    BYTE   byRes[200];              //
}NET_DVR_UPNP_NAT_STATE, *LPNET_DVR_UPNP_NAT_STATE;

typedef struct tagNET_DVR_PLAYCOND
{
    DWORD             dwChannel;
    NET_DVR_TIME     struStartTime;
    NET_DVR_TIME     struStopTime;
    BYTE             byDrawFrame;  //0:֡1֡
    BYTE             byStreamType ; //ͣ0- 1- 2-
    BYTE             byStreamID[STREAM_ID_LEN];
    BYTE             byRes[30];    //
}NET_DVR_PLAYCOND, *LPNET_DVR_PLAYCOND;

typedef struct tagNET_DVR_ATMFINDINFO
{
    BYTE    byTransactionType;       // 0-ȫ1-ѯ 2-ȡ 3- 4-޸룬5-תˣ 6-޿ѯ 7-޿ 8-̳ 9-̿ 10-Զ
    BYTE    byRes[3] ;    //
    DWORD  dwTransationAmount ;     //׽ ;
} NET_DVR_ATMFINDINFO, *LPNET_DVR_ATMFINDINFO ;

typedef union  tagNET_DVR_SPECIAL_FINDINFO_UNION
{
    BYTE  byLenth[8] ;
    NET_DVR_ATMFINDINFO      struATMFindInfo;           //ATMѯ
}NET_DVR_SPECIAL_FINDINFO_UNION, *LPNET_DVR_SPECIAL_FINDINFO_UNION;


typedef struct tagNET_DVR_FILECOND_V40
{
    LONG           lChannel;
    DWORD          dwFileType;/*¼ļ0xff-ȫ0-ʱ¼1-ƶ⣬2-3-ƶ⣬4-ƶ⣬5-6-ֶ¼
    7-¼10-PIR11-߱12-ȱ13-ȫ¼14-ܽͨ¼15-Խ⣬16-֣17-쳣18-⣬19-⣨Խ|||쳣|⣩
    20-⣬ 21-ź22-ش23-Ǩ¼24-ڵ25-pos¼26-, 27-뿪,28-ǻ,29-Աۼ,30-˶,31-ͣ,32-Ʒ,33-Ʒȡ, 
    34-⣬35-ƻ⣬36-ֻ⣬37-Ԥ38-±,39-ܶŹ40-⣬41-˯⣬42-*/
    DWORD          dwIsLocked;
    DWORD          dwUseCardNo;//ǷATMϢвѯ0-ATMϢ1-׿Ųѯ2-Ͳѯ3-׽ѯ4-šͼ׽ϲѯ 5-γƲңʱűʾγ
    BYTE           sCardNumber[CARDNUM_LEN_OUT];
    NET_DVR_TIME   struStartTime;
    NET_DVR_TIME   struStopTime;
    BYTE           byDrawFrame; //0:֡1֡
    BYTE        byFindType; //0:ѯͨ1ѯ浵
    BYTE        byQuickSearch; //0:ͨѯ1٣ѯ
    BYTE        bySpecialFindInfoType ;    //רвѯ 0-Ч 1-ATMѯ  
    DWORD       dwVolumeNum;  //浵
    BYTE        byWorkingDeviceGUID[GUID_LEN];    //GUIDͨȡN+1õ
    NET_DVR_SPECIAL_FINDINFO_UNION uSpecialFindInfo ;   //רвѯ
    BYTE        byStreamType;    //0-1-2-0xff-ȫ
    BYTE        byAudioFile;                //Ƶļ 0-Ƶļ1-Ƶļ
    BYTE        byRes2[30];    //
}NET_DVR_FILECOND_V40, *LPNET_DVR_FILECOND_V40;

typedef struct 
{
    BYTE    sAESKey[16];        /*Կ*/
    BYTE    byRes[64];          /*ֽ*/
}NET_DVR_AES_KEY_INFO, *LPNET_DVR_AES_KEY_INFO;

typedef struct
{
    NET_DVR_IPADDR struIP;     //IPַ
    BYTE  byRes[128]; //
}NET_DVR_POE_CFG, *LPNET_DVR_POE_CFG;

#define MAX_PRO_PATH         256    //Э·

typedef struct
{
    DWORD dwSize;              //ṹС
    DWORD dwEnabled;           //ǷøЭ0  1 
    char  sProtocalName[DESC_LEN];   //ԶЭ, 16λ
    BYTE  byRes1[64];          //,Эչ
    DWORD dwEnableSubStream;   //Ƿ0  1 
    
    BYTE  byMainProType;        //Э 1 RTSP
    BYTE  byMainTransType;        // 0Auto 1udp 2rtp over rtsp
    WORD  wMainPort;           //˿    
    char  sMainPath[MAX_PRO_PATH];  //·
    
    BYTE  bySubProType;         //Э 1 RTSP
    BYTE  bySubTransType;        // 0Auto 1udp 2rtp over rtsp
    WORD  wSubPort;            //˿
    char  sSubPath[MAX_PRO_PATH];   //· 
    
    BYTE  byRes2[200];          //
}NET_DVR_CUSTOM_PROTOCAL, *LPNET_DVR_CUSTOM_PROTOCAL;


//B10֧PSIA豸
//ѭǽṹ壨ʵʱ
typedef struct  
{
    DWORD    dwEnable; /* Ƿ 0 1*/
    BYTE    byType; //豸 0: DEV_SDK  1:DEV_DAHUA  2:DEV_EHOME    3:DEV_OTHERES
    BYTE    byRes[3];  //
    NET_DVR_STREAM_MEDIA_SERVER_CFG streamMediaServerCfg; 
    NET_DVR_DEV_CHAN_INFO  struDevChanInfo; /* ѭͨϢ */
    BYTE    sRtspUrl[128];//ַ
}NET_DVR_MATRIX_CHAN_INFO_EX,*LPNET_DVR_MATRIX_CHAN_INFO_EX;

typedef struct
{
    DWORD    dwSize;
    DWORD    dwPoolTime;    /*ѯ*/
    NET_DVR_MATRIX_CHAN_INFO_EX        struchanConInfo[MAX_CYCLE_CHAN_V30];
    BYTE    byRes[16];
}NET_DVR_MATRIX_LOOP_DECINFO_EX,*LPNET_DVR_MATRIX_LOOP_DECINFO_EX;

//ʵʱԤǽṹ
typedef struct
{
    DWORD dwSize;
    BYTE byType; //豸 0: DEV_SDK  1:DEV_DAHUA  2:DEV_EHOME 3:DEV_OTHERES
    BYTE byRes[3]; //
    NET_DVR_STREAM_MEDIA_SERVER_CFG struStreamMediaSvrCfg;
    NET_DVR_DEV_CHAN_INFO struDevChanInfo;
    BYTE sRtspUrl[128];//ַ
}NET_DVR_PU_STREAM_CFG_EX,*LPNET_DVR_PU_STREAM_CFG_EX;

typedef struct tagNET_DVR_MATRIX_TRUNKCFG
{
    DWORD     dwGlobalIndex;  //
    DWORD     dwInterIndex;   //ȫֱ
    BYTE      sTrunkName[NAME_LEN];
    BYTE      byType;   //豸1-bnc, 2-SP3, 3-V6
    BYTE      byDir;   //߷ 1-2-
    BYTE      byAbility;   //D1
    BYTE      bySubsys;   //ϵͳID
    BYTE      byChan;     //ͨID
    BYTE      byRes[255];     //Ԥ
} NET_DVR_MATRIX_TRUNKCFG,*LPNET_DVR_MATRIX_TRUNKCFG;

typedef struct tagNET_DVR_DECSUBSYSTEMJIONSTATUS_V41
{
    BYTE        byJoinStatus;//״̬0-ûй1-ѾֶͨжϱԼϵͳ2-ռãbyDecodeAbility1ʱЧ3-4-
    BYTE        byJoinSubSystem;// ռõϵͳλ
    BYTE        byJoinDispNum;// ռõʾͨ
    BYTE        byJoinSubWindowNum;// ռõӴں
    BYTE        byDecodeAbility;   //ͨĵǰ0-δ1-D12-7203-1080
    BYTE        byRes[15];
}NET_DVR_DECSUBSYSTEMJIONSTATUS_V41,LPNET_DVR_DECSUBSYSTEMJIONSTATUS_V41;

typedef struct tagNET_DVR_SINGLESUBSYSTEMJOININFO_V41
{
    /*ϵͳͣ1-ϵͳ2-ϵͳ3-ϵͳ4-ϵͳ5-ϵͳ6-ϵͳ7-ϵͳ8-V6ϵͳ9-V6ϵͳ0-NULL˲ֻܻȡ*/
    BYTE    bySubSystemType; 
    BYTE    byConnectStatus;//ϵͳ״̬1-2-ӶϿ
    BYTE    byMatrixNum;//Ƶۺƽ̨ţϵͳ34ʱ
    BYTE    bySubSystemNum;//ϵͳλţϵͳ34ʱ
    NET_DVR_DECSUBSYSTEMJIONSTATUS_V41 struSubSystem[MAX_DECODECHANNUM];
    BYTE    byBindStatus;//״̬0-ûа󶨣1-Ѿ󶨣ƴʱõ
    BYTE    bySlotNum ;//λţ˲ֻܻȡ
    BYTE    byUsedTrunk;//Ƿ񱻸ʹã0-δʹã1-ʹ
    BYTE    byRes[65];
}NET_DVR_SINGLESUBSYSTEMJOININFO_V41,LPNET_DVR_SINGLESUBSYSTEMJOININFO_V41;

typedef struct tagNET_DVR_ALLDECSUBSYSTEMJOININFO_V41
{
    DWORD dwSize;
    NET_DVR_SINGLESUBSYSTEMJOININFO_V41 struSingleSubSystemJoinInfo[MAX_SUBSYSTEM_NUM_V40];
    BYTE  byRes[48];
}NET_DVR_ALLDECSUBSYSTEMJOININFO_V41,*LPNET_DVR_ALLDECSUBSYSTEMJOININFO_V41;

//////////ϵͳ/////////////
#define MAX_ALARMHOSTKEYBOARD 64 //籨
typedef struct tagNET_DVR_PUBLIC_SUB_SYSTEM
{
    //ϵͳţλʾbit0ʾùϵͳϵͳ1.
    DWORD    dwJointSubSystem;
    BYTE    byRes[16];
}NET_DVR_PUBLIC_SUB_SYSTEM, *LPNET_DVR_PUBLIC_SUB_SYSTEM;

typedef struct tagNET_DVR_NOAMAL_SUB_SYSTEM
{
    //ʾЩϵͳλʾbit0 ʾϵͳ.ϵͳ1
    DWORD    dwBeJoinedSubSystem;
    BYTE    byRes[16];    
}NET_DVR_NOAMAL_SUB_SYSTEM, *LPNET_DVR_NOAMAL_SUB_SYSTEM;

typedef union tagNET_DVR_JOINT_SUB_SYSTEM
{
    // byPublicAttributeEnableΪ0ʱʹøñ
    NET_DVR_NOAMAL_SUB_SYSTEM     struNormalSubSystem;
    //byPublicAttributeEnableΪ1ʱʹøñ
    NET_DVR_PUBLIC_SUB_SYSTEM        struPublicSubSystem;
    BYTE    byRes[20];    
}NET_DVR_JOINT_SUB_SYSTEM,*LPNET_DVR_JOINT_SUB_SYSTEM;

#define MAX_SUBSYSTEM_ID_LEN 16 //ϵͳID󳤶

//////////GPRS/////////////
#define    ACCOUNTNUM_LEN             6
#define ACCOUNTNUM_LEN_32             32
#define ACCOUNTNUM_LEN_V40      9
#define    APN_NAME_LEN            32
#define    APN_USERNAME_LEN        24
#define    APN_USERPASSWORD_LEN    16

typedef struct tagNET_DVR_ALARMSUBSYSTEMPARAM
{
    DWORD        dwSize;
    WORD        wEnterDelay;                    //ʱ,λ:, Χ10-150 бʱʱ NET_DVR_ALARMIN_PARAM еdwParamʱʱ
    //÷ʽͨеbySupportAlarmInDelayֶ
    WORD        wExitDelay;//˳ʱ,λ:룬 Χ10-300
    BYTE        byHostageReport;                //Юֱ棬0 1ʹ
    BYTE        bySubsystemEnable;                //ϵͳʹ
    BYTE        byKeyToneOfArmOrDisarm;            // ɹͲǷʾ0-̲ʾ 1-ʾ
    BYTE        byKeyToneOfManualTestReport;    //ɹͲԱǷʾ0-̲ʾ 1-ʾ
    WORD        wDelayTime;                        //ʱdwSupport1еbit0λΪ1ʱʹøòþʱ䡣bit0Ϊ0ʱʹNET_DVR_SIREN_PARAMеwDelayþʱ
    BYTE        byEnableAlarmInDelay;//0--(ʹϵͳʱ),1--(ʹ÷ʱ)Ĭϲ
    BYTE         byPublicAttributeEnable;        //ǷΪϵͳ
    NET_DVR_JOINT_SUB_SYSTEM struJointSubSystem;        
    BYTE        byKeyZoneArm;                    //Ƿ֧Կ׷ϵͳв
    BYTE        byKeyZoneArmReport;                //Ƿ֧Կ׷ϵͳʱͲ
    BYTE        byKeyZoneDisarm;                //Ƿ֧Կ׷ϵͳг
    BYTE        byKeyZoneDisarmReport;            //Ƿ֧Կ׷ϵͳгʱͳ
    BYTE        bySubSystemID[MAX_SUBSYSTEM_ID_LEN];    //ϵͳID
    BYTE        byKeyZoneArmReportEnable;    //Կ׷ϴʹ 0- 1-ʹ
    BYTE        byKeyZoneArmEnable;    //Կ׷ʹܣ 0 - 1-ʹ
    BYTE        byOneKeySetupAlarmEnable;          //һʹ
    BYTE        bySingleZoneSetupAlarmEnable;       //ʹ
    BYTE        byCenterType;                    //0-Ч, 1-˺(6),2-չ˺(9)
    BYTE        sCenterAccount[ACCOUNTNUM_LEN/*6*/];    //ʺ
    BYTE        sCenterAccountV40[ACCOUNTNUM_LEN_32/*32*/];    //˺V40,ʹôֶʱsCenterAccountЧ
    BYTE        byRes2[565];                    // ֽ
}NET_DVR_ALARMSUBSYSTEMPARAM, *LPNET_DVR_ALARMSUBSYSTEMPARAM;

typedef struct tagNET_DVR_REMIND_TIME//8
{
    BYTE byEnable;//Ƿñ 0-ã1-
    BYTE byHour;//0~24
    BYTE byMinute;//0~60
    BYTE bySecond;//0~60
}NET_DVR_REMIND_TIME,*LPNET_DVR_REMIND_TIME;

//ϵͳչ
#define    MAX_KEYBOARD_USER_NUM    256
typedef struct tagNET_DVR_SUBSYSTEM_PARAM_EX
{
    DWORD     dwSize;
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS/*7*/][MAX_TIMESEGMENT_V30/*8*/]; //ʱ
    BYTE    byAlarmInAdvance;            // ǰʾʱ0~45
    BYTE    byRes1[3];
    BYTE     byJointAlarmIn[MAX_ALARMHOST_ALARMIN_NUM / 8];//λʾϵͳıͨţ0-룬1-
    BYTE     byJointKeyboard[MAX_ALARMHOSTKEYBOARD/*64*/ / 8];//λʾֵ֧ļ̺ţ0-룬1-
    BYTE    byJointOpetaterUser[MAX_KEYBOARD_USER_NUM/8];//λʾbit0ʾ̲û1 0- 1-
    NET_DVR_REMIND_TIME    struAlarmRemindTime[MAX_DAYS/*7*/][MAX_TIMESEGMENT_V30/*8*/];//MAX_TIMESEGMENT_V30ʾÿ֧8
    BYTE             byRes2[288];            // ֽ
}NET_DVR_SUBSYSTEM_PARAM_EX, *LPNET_DVR_SUBSYSTEM_PARAM_EX;


typedef struct tagNET_DVR_ALARMHOST_PRINTER_CFG
{
    DWORD     dwSize;
    BYTE     byPrinterEnable;        //Ƿôӡ
    BYTE    byPrintTime;            //Ƿӡʱ
    BYTE     byFaultDetect;            //Ƿӡ
    BYTE    byRes1;
    DWORD    dwAlarmInfo;            //Ϣλʾbit0-bit1-ָbit2-bit-3Юֱ
    DWORD    dwDeviceInfo;            //豸Ϣλʾbit0-ϵ硢bit1-ϵָbit2-Ƿѹbit3-Ƿѹָbit4-绰߶ߡbit5-绰߶߻ָbit6-Ա桢bit7-bit8-ָbit9-485豸ߡbit10-485豸߻ָbit11-쳣bit12-ָbit13-쳣bit14-ָbit15-չ쳣bit17-չ߻ָbit17-Ӳ̹ϡbit18-Ӳ̹ϻָ
    DWORD    dwOperateInfo;            //Ϣλʾbit0-bit1-bit2-bit3-·bit4-·ָbit5-̡bit6-˳̡bit7-λ
    BYTE     byRes2[256];            // ֽ
}NET_DVR_ALARMHOST_PRINTER_CFG, *LPNET_DVR_ALARMHOST_PRINTER_CFG;

typedef struct tagNET_DVR_ALARMHOST_NETPARAM
{ 
    DWORD dwSize;
    NET_DVR_IPADDR struIP;
    WORD    wPort;
    BYTE    byAddressType;    //0 - , 1 - ipv4/ipv6ַ2 - 
    BYTE    byRes1[1];
    BYTE    byDomainName[MAX_DOMAIN_NAME/*64*/]; //GPRSáʱֶξЧ
    BYTE    byReportProtocol;        //1-private 2-NAL2300
    BYTE    byDevID[ACCOUNTNUM_LEN_32/*32*/]; //ЭΪNAL2300ʱЧ
    BYTE    byRes2[7]; //GPRSڹ̶ķϽеģԲҪϢԤһЩֶ
}NET_DVR_ALARMHOST_NETPARAM,  *LPNET_DVR_ALARMHOST_NETPARAM;

typedef struct tagNET_DVR_REGISTER_RS485CFG
{
    DWORD   dwSize;                 // ṹС
    WORD    wDeviceProtocol;        // ǰ豸Э ͨȡЭбȡ    
    BYTE    byRes[2];
    DWORD   dwBaudRate;             //(bps)0-501-752-1103-1504-3005-6006-12007-24008-48009-960010-1920011-3840012-5760013-7680014-115.2k 
    BYTE    byRes1[124];              // ֽ
}NET_DVR_REGISTER_RS485CFG, *LPNET_DVR_REGISTER_RS485CFG;

typedef struct tagNET_DVR_ALARMHOST_WIRELESS_NETWORK_CFG
{
    DWORD    dwSize;
    NET_DVR_ALARMHOST_NETPARAM struNetCenter[MAX_CENTERNUM]; // GPRSز 
    BYTE     byAPNName[APN_NAME_LEN/*32*/];
    BYTE    byAPNUserName[APN_USERNAME_LEN/*24*/];
    BYTE    byAPNPassWord[APN_USERPASSWORD_LEN/*16*/];
    BYTE    byReconnTime;    //ʱ䣬ʧЧʱ䣬10Ϊλ,ȡֵΧ1-30
    BYTE    byOverTime;        //ʱʱ䣬OverTimeʱûյЧΧ1-254λ30
    BYTE    byDetectLinkTime;    //    //̽·Ƿ񻹱֣Χ1-30λ10s
    BYTE    byRes1;
    BYTE    bySIMNum[NAME_LEN/*32*/]; //SIMţֻţ
    NET_DVR_IPADDR    struSIMIP;      //½IPַֻܻȡ
    BYTE    byRes2[64];
}NET_DVR_ALARMHOST_WIRELESS_NETWORK_CFG, *LPNET_DVR_ALARMHOST_WIRELESS_NETWORK_CFG;


///////////////////////
typedef struct tagNET_DVR_ALARMHOST_NETCFG
{
    DWORD dwSize;
    NET_DVR_ALARMHOST_NETPARAM     struNetCenter[MAX_CENTERNUM];
    BYTE    byRes1[32];
}NET_DVR_ALARMHOST_NETCFG,  *LPNET_DVR_ALARMHOST_NETCFG;

//////////ľϴʽ/////////////
#define    MAX_REPORTCHAN_NUM        4
#define    MAX_CENTERGROUP_NUM        16
typedef struct tagNET_DVR_ALARMHOST_REPORTCENTER_CFG
{
    DWORD    dwSize;
    BYTE    byValid;                //Ƿ
    BYTE    byRes[3]; //1
    BYTE    byChanAlarmMode[MAX_REPORTCHAN_NUM/*4*/];    //鱨ͨ 1-T12-T2 3-N1 4-N25-G1 6-G2
    BYTE    byDealFailCenter[MAX_CENTERGROUP_NUM/*16*/]; //ָ鷢ʧܱ棬±ʾĸ飬0-ѡ1-ѡ
    BYTE    byDataType;    //1- 2-Ǳ 3-
    BYTE    byRes2[15];    //2
}NET_DVR_ALARMHOST_REPORTCENTER_CFG, *LPNET_DVR_ALARMHOST_REPORTCENTER_CFG;

#define MAX_EVENT_NUM 32//籨¼
typedef struct tagNET_DVR_ALARMHOST_REPORT_CENTER_CFG_V40
{
    DWORD        dwSize;            
    BYTE        byValid;            //Ƿ
    BYTE        byDataType;            //1-б 2-зǱ 3-ݣ4-棬5-Ƿ
    BYTE        byRes[2];             //1
    BYTE        byChanAlarmMode[MAX_REPORTCHAN_NUM/*4*/];    //鱨ͨ 1-T12-T2 3-N1 4-N25-G1 6-G2(豸֧3GG1G2ʾ3Gģ飬֧֣ʾGPRSģ飬һ豸3GģGPRSģֻһ)
    BYTE        byDealFailCenter[MAX_CENTERGROUP_NUM/*16*/]; //ָ鷢ʧܱ棬±ʾĸ飬0-ѡ1-ѡ
    BYTE         byZoneReport[MAX_ALARMHOST_ALARMIN_NUM];    //ͣ0-ϴ1-ϴ 
    BYTE        byNonZoneReport[MAX_EVENT_NUM]; //Ƿ, ÿһԪرʾһ¼ͣ0-ϴ1-ϴbyNonZoneReport[0]- byNonZoneReport[1]-ϵͳ״̬ byNonZoneReport[2]-ȡ byNonZoneReport[3]-Ա byNonZoneReport[4]- byNonZoneReport[5]- byNonZoneReport[6]-Юֱ byNonZoneReport[7]-ָ byNonZoneReport[8]-· byNonZoneReport[9]-·ָ档
    BYTE        byRes2[256];            //2
}NET_DVR_ALARMHOST_REPORT_CENTER_CFG_V40, *LPNET_DVR_ALARMHOST_REPORT_CENTER_CFG_V40;


//////////״̬ϴ/////////////
typedef  struct tagNET_DVR_ALARMHOST_SAFETYCABINSTATE
{
    DWORD    dwSize;
    BYTE    byEnterButton;    //Űť״̬ 0- 1-ť
    BYTE    byExitButton;    //Űť״̬ 0- 1-ť
    BYTE    byDoorState;    //״̬    0-Źر 1-Ŵ
    BYTE    byLockState;    //״̬ 0-    1-
    BYTE    byUrgencyButton;    //ť״̬    0- 1-ť
    BYTE    byManState;        //״̬     0-û 1-
    BYTE    byAbnormal; //쳣״̬  0- 1-쳣(ʹóʱϴ쳣)
    BYTE    byLightState;   //ƹ״̬ 0- 1-
    BYTE    byFanState;     //״̬ 0-أ1-
    BYTE    byRes[63];
}NET_DVR_ALARMHOST_SAFETYCABINSTATE,*LPNET_DVR_ALARMHOST_SAFETYCABINSTATE;

/////////ڣ״̬ϴ/////////////
typedef  struct tagNET_DVR_ALARMHOST_ALARMOUTSTATUS
{
    DWORD    dwSize;
    BYTE    byName[32];        //ƻ򾯺
    BYTE    byAlarmType;    //1-״̬ 2-״̬
    WORD    wChan;            //Ǳ״ֵ̬ķΧΪ0-511Ǿ״̬Χ1-8ֻ1
    BYTE    byAlarmStatus; //״̬ 0-ޱ 1-б
    BYTE    byRes[32];
}NET_DVR_ALARMHOST_ALARMOUTSTATUS,*LPNET_DVR_ALARMHOST_ALARMOUTSTATUS;

//////////ϴ/////////////
typedef struct tagNET_DVR_AUDIO_PARAM
{
    DWORD        dwSize;
    BYTE        byAudioFormat;      //Ƶʽ1-G7112-G722 
    BYTE        byRes1;
    WORD        wChannels;          // number of channels (i.e. mono, stereo...)
    DWORD        dwSamplesPerSec;    //
    BYTE        byRes2[20];            //
    DWORD        dwAudioSize;        //ƵȴСѹĴС
}NET_DVR_AUDIO_PARAM,*LPNET_DVR_AUDIO_PARAM;

//ԤV40ӿ
typedef struct tagNET_DVR_PREVIEWINFO
{
    LONG lChannel;//ͨ
    DWORD dwStreamType;    // ͣ0-1-2-33-4 Դ
    DWORD dwLinkMode;// 0TCPʽ,1UDPʽ,2ಥʽ,3 - RTPʽ4-RTP/RTSP,5-RSTP/HTTP 
    HWND hPlayWnd;//Ŵڵľ,ΪNULLʾͼ
    DWORD bBlocked;  //0-ȡ, 1-ȡ, SDKڲconnectʧܽ5sĳʱܹ,ʺѯȡ.
    DWORD bPassbackRecord; //0-¼ش,1¼ش
    BYTE byPreviewMode;//Ԥģʽ0-Ԥ1-ӳԤ
    BYTE byStreamID[STREAM_ID_LEN/*32*/];//IDlChannelΪ0xffffffffʱô˲
    BYTE byProtoType; //ӦòȡЭ飬0-˽Э飬1-RTSPЭ
    BYTE byRes1;
    BYTE byVideoCodingType; //ݱ 0-ͨñ(YUV)һص8BIT 1-ͣһص14BITSDKڲͷļбŸû
    DWORD dwDisplayBufNum; //ſⲥŻ󻺳֡Χ1-500ʱĬΪ1 
    BYTE byRes[216];
}NET_DVR_PREVIEWINFO, *LPNET_DVR_PREVIEWINFO;


//¼

typedef struct tagNET_DVR_TRIGGER_EVENT
{
    DWORD    dwSize;
    DWORD    dwOverallEventTriggerAlarmoutOn;    //ȫ¼λbit0-磬bit1-صѹͣbit2-绰ߵߣbit3-쳣bit4-쳣 ,bit5-Ӳ̹
    DWORD    dwOverallEventTriggerAlarmoutOff;    //ȫ¼λbit0-磬bit1-صѹͣbit2-绰ߵߣbit3-쳣bit4-쳣 ,bit5-Ӳ̹
    DWORD    dwSubSystemEventTriggerAlarmoutOn[MAX_ALARMHOST_SUBSYSTEM/*32*/]; //ϵͳ¼,dwSubSystemEvent[0]ʾϵͳ1dwSubSystemEvent[2]ʾϵͳ2ϵͳȡwSubSystemÿϵͳ¼λʾbit0-ʱbit1-˳ʱbit2-bit3-bit4-bit5-,bit6-ָ,bit7-,bit8-ָ
    DWORD    dwSubSystemEventTriggerAlarmoutOff[MAX_ALARMHOST_SUBSYSTEM/*32*/]; //ϵͳ¼ر,wSubSystemEvent[0]ʾϵͳ1dwSubSystemEvent[2]ʾϵͳ2ϵͳȡwSubSystemÿϵͳ¼λʾbit0-ʱbit1-˳ʱbit2-bit3-bit4-bit5-,bit6-ָ,bit7-,bit8-ָ
    BYTE    byRes[128];
}NET_DVR_TRIGGER_EVENT, *LPNET_DVR_TRIGGER_EVENT;

//ϴ
typedef struct  tagNET_DVR_ALARMHOST_FAULT_CFG
{
    DWORD     dwSize;
    DWORD    dwCheckFault;    //Ƿϣbit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-485豸쳣bit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣, bit11-չ쳣ֵ֧Ĺʹȡ
    DWORD    dwOverallFaultJointLED;        //Ϲȫָּʾ bit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-485豸쳣bit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣ֵ֧Ĺʹȡ
    DWORD    dwOverallFaultJointSound;    //Ϲȫּ bit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-485豸쳣bit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣ֵ֧Ĺʹȡ
    DWORD    dwSubSystemFaultJointLED[MAX_ALARMHOST_SUBSYSTEM]; /*ϹϵͳָʾdwSubSystemFaultJointLED[0]ʾϵͳ1ĹϢdwSubSystemFaultJointLED[0]ÿһλʾһйϣbit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-485豸쳣bit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣; dwSubSystemFaultJointLED[1]ʾϵͳ2Դ*/
    DWORD    dwSubSystemFaultJointSound[MAX_ALARMHOST_SUBSYSTEM];/*ϹϵͳڼdwSubSystemFaultJointLED[0]ʾϵͳ1ĹϢdwSubSystemFaultJointSound [0]ÿһλʾһйϣbit0-ϵ磬bit1-Ƿѹbit2-𿪣bit3-绰ߵߣbit4-485豸쳣bit5-ϣbit6-쳣bit7-չ쳣bit8-Ӳ쳣; dwSubSystemFaultJointSound [1]ʾϵͳ2Դ*/
    DWORD    dwFaultJointFaultLight;//Ϲϵ
    BYTE    byRes[60];
}NET_DVR_ALARMHOST_FAULT_CFG, *LPNET_DVR_ALARMHOST_FAULT_CFG;

typedef struct tagNET_DVR_LIST_INFO
{
    DWORD    dwSize;
    BYTE    byIndex;            //ϵͳţ0xffʾϵͳ
    BYTE       byRes[63];      //
}NET_DVR_LIST_INFO, *LPNET_DVR_LIST_INFO;

#define CID_CODE_LEN 4
typedef enum tagNET_DVR_ALARMHOST_REPORT_TYPE
{
    NET_DVR_DEFENCE_ALARM = 1,        //
        NET_DVR_VIDEO_ALARM,            //Ƶ
        NET_DVR_VIRTUAL_DEFENCE_ALARM,    //
        NET_DVR_HOSTAGE_ALARM,            //Юֱ
        NET_DVR_KNOCK_DOWN_ALARM,        //𱨾
        NET_DVR_OPERATE_ALARM,            //
        NET_DVR_OHTER_ABNORMAL_ALARM    //쳣
}NET_DVR_ALARMHOST_REPORT_TYPE;


typedef enum tagNET_DVR_ALARMHOST_CID_MAIN_TYPE
{
    CID_ENTER = 1000,    /*Ļ*/
    CID_EXIT = 3000        /*ָĻ*/
}NET_DVR_ALARMHOST_CID_MAIN_TYPE;


typedef enum tagNET_DVR_ALARMHOST_CID_MINOR_TYPE
{
    CID_ALARM = 103,            /**/
    CID_FIRE_ALARM = 110,       /**/
    CID_ABDUCT_REPORT = 121,    /*Юֱ*/
    CID_SILENT_24 = 122,        /*24Сʱ*/
    CID_AUDIO_24 = 123,         /*24Сʱ*/
    CID_AUXILIARY_24 = 124,     /*24Сʱ*/
    CID_SHOCK_24 = 125,         /*24Сʱ*/
    CID_PERIMETER_ALARM = 131,  /*ܽ*/
    CID_INNET_ALARM = 132,      /*ڲ*/
    CID_ENTER_EXIT = 134,       /**/
    CID_DEVICE_OPEN = 137,      /*豸*/
    CID_ZONE_BUS_BREAK = 141,   // ߿·
    CID_ZONE_BUS_SHORT = 142,   // ߶·
    
    CID_AC_LOSS = 301,          /**/
    CID_LOW_BATT_VOL = 302,     /*صѹ*/
    CID_DEV_RESET = 305,        /*λ*/
    CID_MBUS_MODEL_FAULT = 333, // չģ
    CID_PRINTER_FAIL = 336,     /*ӡ*/
    CID_LINE_LOSS = 354,          // 绰ͨѶʧ
    CID_BUS_LOSS = 382,         /*չģ*/
    CID_DETECTOR_OPEN = 383,     /*Ӧ*/

    CID_GUARD = 401,            /**/
    CID_GUARD_AUTO = 403,       /*Զ*/
    CID_CANCEL_ARM = 406,       /**/
    CID_GUARD_IMME = 408,       /*ʱ*/
    CID_KEY_ZONE_GUARD = 409,   /*Կ׷*/
    CID_GUARD_STAY = 441,       /*ز*/
    CID_FORCED_ARM = 442,       /*ǿƲ*/
    CID_AUTOCTRL_TRIG = 443,    /*ʱ/ش*/
    CID_ONETOUCH_AWAY_ARMING = 444, /*һ*/
    CID_ONETOUCH_STAY_ARMING = 445, /*һز*/
    CID_CARD_ARMING_OR_DISARMING = 446, /*ˢ*/
    CID_AUTOGUARD_FAIL = 455,   /*Զʧ*/
    CID_AOPEN_TRIG_FAIL = 460,  /*ʱʧ*/
    CID_ACLOSE_TRIG_FAIL = 461, /*ʱرմʧ*/
    CID_AUTOUNGUARD_FAIL = 462, /*Զʧ*/

    CID_BYPASS = 570,           /*·¼*/
    CID_GROUP_BYPASS = 574,     /*·*/

    CID_MANUAL_TEST_RPT = 601,  /*ֶԱ*/
    CID_AUTO_TEST_RPT = 602,    /*ʱԱ*/
    CID_ENTER_PROG = 627,       /**/
    CID_EXIT_PROG = 628,        /*˳*/

    CID_SOFT_INSTAND = 810,     /**/
    CID_SOFT_FIRE = 811,        /**/
    CID_SOFT_MOBS = 812,        /*˾mobster*/
    
    CID_KEY_FAIL = 910,         /*̵*/
    CID_TRIGGER_FAIL = 911,     /*ϴ*/
    CID_GPK_FAIL = 912,         /*GP/K*/
    CID_MODULE_FAIL = 913,      /*MN/K*/
    CID_WRIE_LESS_NET = 920,    /**/
    CID_SIM_FAULT = 921,        /*SIM*/
    CID_IPADDR_CONFLICT = 930,  /*IPͻ*/
    CID_ETHERNET_BROKEN = 931,  /*߶*/
    CID_GROUP_OUT_RP = 932,       // ͨѶʧ
    CID_GROUP_IN_RP = 933,        // ͨͨѶʧ
    CID_MOTION_DECTECT = 940,   /*ƶⱨʼ/*/
    CID_MASK_ALARM = 941,       /*ڵʼ/*/
    CID_VI_LOST = 942,          /*Ƶʧʼ/*/
    CID_VS_MISMATCH = 943,      /*/Ƶʽƥ*/
    CID_VI_EXCEPTION = 944,     /*Ƶ쳣/ָ*/
    CID_HD_FULL = 945,          /*Ӳ/ָ*/
    CID_HD_ERROR = 946,         /*Ӳ̴/ָ*/
    CID_PIC_SEND_FAILED = 947,  /*ͼƬϴʧ*/
    CID_KEY_LOCKED = 948,      /**/
    CID_ZONE_BUS_SEARCH = 970,    // 
    CID_ZONE_BUS_REGIST = 971,    // ע
    CID_GUARD_DELAY_OP = 972,     // Զʱ
    CID_GUARD_SINGLE = 973     /**/
}NET_DVR_ALARMHOST_CID_MINOR_TYPE;


typedef struct tagNET_DVR_CID_ALARM
{
    DWORD    dwSize;
    BYTE    sCIDCode[CID_CODE_LEN/*4*/];    //CID¼
    BYTE    sCIDDescribe[NAME_LEN/*32*/];    //CID¼
    NET_DVR_TIME_EX struTriggerTime;            //ʱ
    NET_DVR_TIME_EX struUploadTime;                //ϴʱ
    BYTE    sCenterAccount[ACCOUNTNUM_LEN/*6*/];    //ʺ
    BYTE    byReportType;                    //NET_DVR_ALARMHOST_REPORT_TYPE
    BYTE    byUserType;                        //ûͣ0-û 1-û,2-ֻû,3-ϵͳû
    BYTE    sUserName[NAME_LEN/*32*/];        //ûû
    WORD    wKeyUserNo;                        //û    0xFFFFʾЧ
    BYTE    byKeypadNo;                        //̺        0xFFʾЧ
    BYTE    bySubSysNo;                        //ϵͳ        0xFFʾЧ
    WORD    wDefenceNo;                        //        0xFFFFʾЧ
    BYTE    byVideoChanNo;                    //Ƶͨ    0xFFʾЧ
    BYTE    byDiskNo;                        //Ӳ̺        0xFFʾЧ
    WORD    wModuleAddr;                    //ģַ        0xFFFFʾЧ
    BYTE    byCenterType;                    //0-Ч, 1-˺(6),2-չ˺(9)
    BYTE    byRes1;
    BYTE    sCenterAccountV40[ACCOUNTNUM_LEN_32/*32*/];    //˺V40,ʹôֶʱsCenterAccountЧ
    BYTE    byRes2[28];
}NET_DVR_CID_ALARM, *LPNET_DVR_CID_ALARM;

#define MODULE_INFO_LEN            32    //ģϢ
#define VERSION_INFO_LEN        32    //汾Ϣ

typedef struct tagNET_DVR_ALARMHOST_MODULE_CFG
{
    DWORD dwSize;
    BYTE    byModuleType;    //1-2- 3-      
    BYTE    byZoneType;        //ͣ1-ط2-3-˫4-85-8·ģ6-0xffʾòЧ
    BYTE    byTriggerType;    //ͣ1-ش 2-4·3-8·4-0xffʾòЧ
    BYTE    byRes1[1];
    char    sModelInfo[MODULE_INFO_LEN];                //ģϢ
    char    sDeviceVersionInfo[VERSION_INFO_LEN];                /* 汾Ϣ*/
    BYTE    byRes[188];
} NET_DVR_ALARMHOST_MODULE_CFG, *LPNET_DVR_ALARMHOST_MODULE_CFG;


#define MAX_DECODE_CARD_SUPPORTDISPNUMS 8//ÿ뿨ֵ֧ʾͨ
#define MAX_SUPPORT_RES 32
typedef struct tagNET_DVR_DECCARD_ABILITY_V41 /*뿨*/
{
    BYTE byCardType;      //뿨(0:MD,1:MD+,2:HD)
    BYTE byDecNums;      //ͨ 
    BYTE byDispNums;      //ʾͨ 
    BYTE byDecStartIdx;     //׸ͨнͨе 
    BYTE byDispStartIdx;     //׸ʾͨʾͨе
    BYTE byRes1[3]; 
    DWORD dwVgaSupportResolution[MAX_SUPPORT_RES/*32*/];//ֵ֧ķֱ
    DWORD dwHdmiSupportResolution[MAX_SUPPORT_RES/*32*/];//ֵ֧ķֱ
    DWORD dwDviSupportResolution[MAX_SUPPORT_RES/*32*/];//ֵ֧ķֱ
    DWORD dwYpbprSupportResolution[MAX_SUPPORT_RES/*32*/];//ֵ֧ķֱ
    BYTE byDispFormat[MAX_DECODE_CARD_SUPPORTDISPNUMS];   //ֵ֧ģʽ(HD_DISPLAY_FORMATеö) 
    BYTE byWindowMode[MAX_DECODE_CARD_SUPPORTDISPNUMS][12]; //ֵ֧Ĵģʽ(1,2,4,9,16))
    BYTE byRes2[36];
} NET_DVR_DECCARD_ABILITY_V41,*LPNET_DVR_DECCARD_ABILITY_V41;

#define        MAX_DECODE_CARD_NUM            6   //뿨
typedef struct tagNET_DVR_DECODESVR_ABILITY_V41
{
    DWORD dwSize;      /* ṹС */
    BYTE byCardNums;      /* 뿨 */
    BYTE byStartChan;     /* ʼͨ */
    BYTE byRes1[2];
    NET_DVR_DECCARD_ABILITY_V41 struDecCardAbility[MAX_DECODE_CARD_NUM];
    BYTE byRes2[64];
}NET_DVR_DECODESVR_ABILITY_V41, *LPNET_DVR_DECODESVR_ABILITY_V41;

// ¼״̬
typedef struct tagNET_DVR_STREAM_RECORD_STATUS
{
    DWORD           dwSize;
    BYTE            byRecord;         //(ֻ)¼, 0¼1¼ 2- 
    //3- 4-Ƶ 5-δ 6-浵
    //7-ش 8-û 9-δ֤
    //10-浵к¼ 11-¼شк¼
    BYTE            byOffLineRecord;  //¼ 0-ر 1-
    BYTE            byRes1[2];        //ֽ
    DWORD            dwRelatedHD;      //
    BYTE            byRes2[8];        //ֽ
}NET_DVR_STREAM_RECORD_STATUS, *LPNET_DVR_STREAM_RECORD_STATUS;

#define  CHAN_NO_LEN   24

typedef struct tagNET_DVR_DIRECT_CONNECT_CHAN_INFO
{
    BYTE        byEnable;                    //Ƿ
    BYTE        byProType;                    //Эͣ0-˽Э(default), (Ҫ豸ȡ)
    BYTE          byZeroChan;                    //Ƿͨ,0-ǣ1-
    BYTE        byPriority;                //ȼ
    BYTE        sUserName[NAME_LEN];        //û
    BYTE        sPassword[PASSWD_LEN];        //
    BYTE        byDomain[MAX_DOMAIN_NAME];    //豸
    NET_DVR_IPADDR  struIP;                        //IPַ
    WORD        wDVRPort;                     //˿ں
    BYTE        byStreamType;               //:0; 1
    BYTE        byOnline;                    //ֻ0- 1-
    DWORD        dwChannel;                  //ͨ
    BYTE        byTransProtocol;            //Эͣ0-TCP1-UDP2-ಥ
    BYTE        byLocalBackUp;                //ر: 0-CVRرݣ1-CVRر--طʱһ¼һڴ浵رݣ
    WORD        wDirectLastTime;            //ʱ
    BYTE        byChanNo[CHAN_NO_LEN];     //ͨ--VAGȡ
}NET_DVR_DIRECT_CONNECT_CHAN_INFO, *LPNET_DVR_DIRECT_CONNECT_CHAN_INFO;

typedef struct tagNET_DVR_DIRECT_CONNECT_CHAN_INFO_V40
{
    BYTE    byEnable;                    //Ƿ
    BYTE    byProType;                    //Эͣ0-˽Э(default), 1-Э飬2-, 3- (Ҫ豸ȡ)
    BYTE    byZeroChan;                    //Ƿͨ,0-ǣ1-
    BYTE    byRes1;                        //ֶΣ0
    BYTE    sUserName[NAME_LEN];        //û
    BYTE    sPassword[PASSWD_LEN];        //
    BYTE    byAddress[MAX_DOMAIN_NAME];  //ǰIP,Ҫ豸 ʽΪĸ'.'Ϊ,ΪIPַ
    WORD    wDVRPort;                     //˿ں
    BYTE    byStreamType;               //:0; 1
    BYTE    byOnline;                    //ֻ0- 1-
    DWORD   dwChannel;                //ͨ
    BYTE    byTransProtocol;            //Эͣ0-TCP1-UDP 2-ಥ
    BYTE    byLocalBackUp;                     //رݣ0-CVRرݣ1-CVRر--¼ʱһ¼һڴ浵رݣ
    BYTE    byRes2[2];                //ֶΣ0
    BYTE    byVAGChanNo[MAX_VAG_CHANNO_LEN];     //ЭΪVAGʱӦVAGͨ
    BYTE    byRes[340];
}NET_DVR_DIRECT_CONNECT_CHAN_INFO_V40, *LPNET_DVR_DIRECT_CONNECT_CHAN_INFO_V40;


typedef struct tagNET_DVR_PU_STREAM_URL_CFG
{ 
    BYTE    byEnable;  
    BYTE    byRes[3]; 
    BYTE    byStreamMediaIP[64];//ýIP 
    WORD    wStreamMediaPort; //ý˿
    BYTE    byTransmitType; //ý崫Э 0- TCP  1- UDP
    BYTE    byRes1[33];
    BYTE    byDevIP[64]; //豸IP 
    WORD    wDevPort; //豸˿
    BYTE    byChannel; //ͨ
    BYTE    byTransMode; //ģʽ 0- 1-  
    BYTE    byProType;    
    // 0-˽ 1- 2- 3-ɳ 4-ɫǼ NET_DVR_GetIPCProtoListӿڻȡ
    //VQDýֻ֧ 01ʽֱ֧ 01234
    BYTE    byTransProtocol; //Э0-TCP,  1-UDP,  2-ಥʽ,  3-RTP
    BYTE    byRes3[2];
    BYTE    sUserName[NAME_LEN];   //豸½û
    BYTE    sPassWord[PASSWD_LEN]; // 豸½
    BYTE    byRes2[28];  //Ԥ  
}NET_DVR_PU_STREAM_URL_CFG, *LPNET_DVR_PU_STREAM_URL_CFG;

typedef struct tagNET_DVR_PU_STREAM_URL_CFG_V40
{ 
    BYTE    byEnable;  
    BYTE    byRes[3]; 
    BYTE    byStreamMediaIP[64];//ýIP 
    WORD   wStreamMediaPort; //ý˿
    BYTE    byTransmitType; //ý崫Э 0- TCP  1- UDP
    BYTE    byRes1;
    BYTE    byDevIP[64]; //豸IP 
    WORD   wDevPort; //豸˿
    BYTE    byChannel; //ͨ
    BYTE    byTransMode; //ģʽ 0- 1-  
    BYTE    byProType;    
    // 0- 1- 2- 3-ɳ 4-ɫǼ NET_DVR_GetIPCProtoListӿڻȡ
    //VQDýֻ֧ 01ʽֱ֧ 01234
    BYTE    byTransProtocol; //Э0-TCP,  1-UDP  2-ಥʽ
    BYTE    byRes3[2];
    BYTE    sUserName[NAME_LEN];   //豸½û
    BYTE    sPassWord[PASSWD_LEN]; // 豸½
    BYTE    byRes2[308];  //Ԥ  
}NET_DVR_PU_STREAM_URL_CFG_V40, *LPNET_DVR_PU_STREAM_URL_CFG_V40;

typedef struct tagNET_DVR_STREAM_URL_V40
{
    BYTE    byEnable; 
    BYTE    byStreamType; //
    BYTE    byLocalBackUp; //Ƿ񱾵ر
    BYTE     byRes;
    BYTE    strURL[URL_LEN_V40]; //ýURLԼ
    DWORD   dwProtocalType;   //IPCЭֵͨȡIPCЭбõ
    BYTE    sUserName[NAME_LEN];   //豸½û
    BYTE    sPassWord[PASSWD_LEN]; // 豸½
    BYTE    byAddress[MAX_DOMAIN_NAME];  //ԴIP,Ҫ ʽΪĸ'.'Ϊ,ΪIPַ
    WORD    wIPPort;  //ԴӦĶ˿ں
    WORD    wChanNo; //Դ豸IPͨ
    BYTE    byVAGChanNo[MAX_VAG_CHANNO_LEN];     //Դͨ,VAG
    BYTE     byRes1[88];   
}NET_DVR_STREAM_URL_V40, *LPNET_DVR_STREAM_URL_V40;

typedef union tagNET_DVR_STREAM_TYPE_UNION
{
    NET_DVR_DIRECT_CONNECT_CHAN_INFO    struChanInfo;          //IPͨϢ  ֵΪ0
    NET_DVR_PU_STREAM_URL                struStreamUrl;        //ͨý嵽urlȡֵΪ4
    NET_DVR_PU_STREAM_URL_CFG           struStreamUrlCfg; //ͨý嵽ָ豸ȡֵΪ6
}NET_DVR_STREAM_TYPE_UNION, *LPNET_DVR_STREAM_TYPE_UNION;

typedef union tagNET_DVR_STREAM_TYPE_V40_UNION
{
    NET_DVR_DIRECT_CONNECT_CHAN_INFO_V40    struChanInfo;     //IPͨϢֵΪ0
    NET_DVR_PU_STREAM_URL struPuStreamUrl;        //ͨý嵽urlȡֵΪ4
    NET_DVR_PU_STREAM_URL_CFG_V40   struStreamUrlCfg; //ͨý嵽urlȡֵΪ6
    NET_DVR_RTSP_PROTOCAL_CFG struRtspCfg;        //ɱ׼RTSPȡ ֵ7
    NET_DVR_STREAM_URL_V40  struStreamUrlV40;  //ͨý壨ּ֧ʽԴȡֵΪ8
}NET_DVR_STREAM_TYPE_V40_UNION, *LPNET_DVR_STREAM_TYPE_V40_UNION;


typedef struct tagNET_DVR_STREAM_MODE_TYPE
{
    BYTE                    byGetStreamType;    //ȡʽ0-ֱӴ豸ȡ1-ýȡ2-ͨIPServeripַȡ, 3.ͨIPServerҵ豸ͨýȥ豸 4-ͨýURLȥȡ
    BYTE                    byRes[3];            // ֽ
    NET_DVR_STREAM_TYPE_UNION    uGetStream;            // ͬȡʽṹ
}NET_DVR_STREAM_MODE_TYPE, *LPNET_DVR_STREAM_MODE_TYPE;

// ԴϢ
typedef struct tagNET_DVR_STREAM_SRC_INFO
{
    DWORD                        dwSize;
    NET_DVR_STREAM_MODE_TYPE    struStreamSrcInfo;
}NET_DVR_STREAM_SRC_INFO,*LPNET_DVR_STREAM_SRC_INFO;

typedef struct tagNET_DVR_STREAM_SRC_INFO_V40
{
    DWORD                    dwSize;
    BYTE                    byGetStreamType;    //ȡʽ0-ֱӴ豸ȡ1-ýȡ2-ͨIPServeripַȡ, 3.ͨIPServerҵ豸ͨýȥ豸 4-ͨýURLȥȡ 6-ͨý嵽ָ豸ȡ
    BYTE                    byRes1[3];            // ֽ
    NET_DVR_STREAM_TYPE_V40_UNION    uGetStream;            // ͬȡʽṹ
    BYTE                    byRes[512];            // ֽ
}NET_DVR_STREAM_SRC_INFO_V40,*LPNET_DVR_STREAM_SRC_INFO_V40;


// ¼Ϣ
typedef struct 
{
    DWORD            dwSize;
    NET_DVR_RECORD_V30    struRecordInfo;
}NET_DVR_STREAM_RECORD_INFO, *LPNET_DVR_STREAM_RECORD_INFO;

// IDʱμ
typedef struct tagNET_DVR_STREAM_TIME_LOCK
{
    DWORD            dwSize;                // ṹС
    NET_DVR_TIME    strBeginTime;        // ʼʱ
    NET_DVR_TIME    strEndTime;            // ʱ
    NET_DVR_STREAM_INFO struStreamInfo;        // Ϣ
    DWORD            dwRecordType;        // ¼:  0xffffffffȫʱ¼-ƶ⣬-ƶ⣬-ƶ⣬--ֶ¼-¼(ͬļ)
    DWORD            dwLockDuration;        // ʱ,λ룬0xffffffffʾ
    NET_DVR_TIME_EX        strUnlockTimePoint;    // ʱЧdwLockDurationΪʱʱ䵽ʱԶ
    BYTE                byRes[4];
}NET_DVR_STREAM_TIME_LOCK, *LPNET_DVR_STREAM_TIME_LOCK;

// ID+ʱطŽṹ
typedef struct tagNET_DVR_VOD_PARA
{
    DWORD                dwSize;
    NET_DVR_STREAM_INFO struIDInfo; 
    NET_DVR_TIME        struBeginTime;
    NET_DVR_TIME        struEndTime;
    HWND                hWnd;
    BYTE                byDrawFrame; //0:֡1֡
    BYTE                byVolumeType;  //0-ͨ¼  1-浵
    BYTE                byVolumeNum;  //ţĿǰָ浵
    BYTE                byStreamType;   // 0- 1-2-
    DWORD                   dwFileIndex;      //浵ϵ¼ļ浵¼ʱصֵ
    BYTE                byAudioFile;    //Ƶļ0-1-
    BYTE                byRes2[23];
}NET_DVR_VOD_PARA, *LPNET_DVR_VOD_PARA;

// ֶ¼
typedef struct tagNET_DVR_MANUAL_RECORD_PARA
{
    NET_DVR_STREAM_INFO struStreamInfo; 
    DWORD            lRecordType;
    BYTE            byRes[32];
}NET_DVR_MANUAL_RECORD_PARA, *LPNET_DVR_MANUAL_RECORD_PARA;


// CABACѹѡ20%ֻģͨ
typedef struct tagNET_DVR_STREAM_CABAC
{
    DWORD        dwSize;                  //ṹС
    BYTE         byCabacEnable;           //ѹѡֵ0  1 
    BYTE          byRes1[31];                  //
}NET_DVR_STREAM_CABAC, *LPNET_DVR_STREAM_CABAC;

#define  MAX_IOSPEED_GROUP_NUM      4 //IO
#define  MAX_IOOUT_NUM              4  //IOڸ
#define  MAX_IOIN_NUM               8  //IOڸ
#define  MAX_RELAY_NUM              12 //̵豸 2013-11-04
#define  MAX_VEHICLE_TYPE_NUM        8  //Ϣܿ2013-11-04
#define  MAX_IOIN_NUMEX             10 //IOڸ(չ)
#define  MAX_ITC_LANE_NUM           6  //󳵵
#define  MAX_LANEAREA_NUM           2  //
#define  ITC_MAX_POLYGON_POINT_NUM    20    //֧20Ķ
#define  MAX_ITC_SERIALCHECK_NUM    8 //У͸
#define  MAX_LIGHT_NUM              6 //ͨ
#define  MAX_VIDEO_INTERVAL_NUM     2  //ץļ
#define  MAX_VIDEO_DETECT_LIGHT_NUM  12  //Ƶ
#define  MAX_CALIB_RECOG_NUM        2  //궨
#define  MAX_RS485_NUM  12 //485֧
#define  MAX_MOBILE_POLYGON_NUM     3 //ƶ֧ʶ
#define  MAX_MOBILE_DETECTLINE_NUM  3 //ƶ֧Υ߸
#define  MAX_IOOUT_K_NUM            8  //KϵIOڸ

//IOڲ3.1汾֮
typedef struct tagNET_ITC_IOOUT_PARAM
{
    DWORD    dwSize;
    BYTE     byDefaultStatus;//IOĬ״̬0-͵ƽ1-ߵƽ 
    BYTE     byIOOutStatus;//IOЧʱ״̬0-͵ƽ1-ߵƽ2-
    BYTE     byMode; //ƹʽ,λʾ0-ʾ1-ʾbit0-Ƶbit1-ڣbit2-Υ
    BYTE     byIOWorkMode;//IOڹģʽ0-ƣ1-ƫ,  2-
    DWORD    dwTimeDelay;//IOЧʱ䣬λus
    WORD     wAheadTime;//IOǰʱ䣬λus
    BYTE     byFreqMulti;        //ƵֵΧ[1,15]
    BYTE     byDutyRate;        //ռձȣ[0,40%]
    BYTE     byDetectBrightness;/*Զʹ0-⣻1-*/
    BYTE     byBrightnessThreld;/*ʹֵΧ[0,100],ֵ*/
    BYTE     byFlashLightEnable;    //ʱʹ:0-;1-
    BYTE     byStartHour;        //ʼʱ-Сʱ,ȡֵΧ0-23
    BYTE     byStartMinute;        //ʼʱ-,ȡֵΧ0-59
    BYTE     byEndHour;        //ʱ-Сʱ,ȡֵΧ0-23
    BYTE     byEndMinute;        //ʱ-,ȡֵΧ0-59
    BYTE     byAutoPlateBrightness;// Զʹ 0- 1-
    BYTE     byRes[8];
}NET_ITC_IOOUT_PARAM, *LPNET_ITC_IOOUT_PARAM;

typedef enum _ITC_TRIGGERMODE_TYPE_
{
    ITC_POST_IOSPEED_TYPE              = 0x1,  //IO٣ڣ
        ITC_POST_SINGLEIO_TYPE             = 0x2,  //IOڣ
        ITC_POST_RS485_TYPE                = 0x4,  //RS485ڣ
        ITC_POST_RS485_RADAR_TYPE          = 0x8,  //RS485״ﴥڣ
        ITC_POST_VIRTUALCOIL_TYPE          = 0x10,   //Ȧڣ
        ITC_POST_HVT_TYPE_V50               = 0x20,    //пƵV50
        ITC_POST_MPR_TYPE                  = 0x40,   //֡ʶ()(Ver3.7)
        ITC_POST_PRS_TYPE                  = 0x80,   //Ƶⴥ
        ITC_EPOLICE_IO_TRAFFICLIGHTS_TYPE  = 0x100,  //IO̵ƣ羯
        ITC_EPOLICE_RS485_TYPE             = 0x200,  //RS485羯羯
        ITC_POST_HVT_TYPE                   = 0x400,    //пƵڣ
        ITC_PE_RS485_TYPE                  = 0x10000,  //RS485ʽ羯ʽ羯
        ITC_VIDEO_EPOLICE_TYPE             = 0x20000, //Ƶ羯ʽ羯
        ITC_VIA_VIRTUALCOIL_TYPE           = 0x40000,  //VIA
        ITC_POST_IMT_TYPE                   = 0x80000,   //ǻۼ
        IPC_POST_HVT_TYPE                   = 0x100000,    //IPCֵ֧HVT
        ITC_POST_MOBILE_TYPE               = 0x200000, //ƶͨģʽ
        ITC_REDLIGHT_PEDESTRIAN_TYPE       = 0x400000,    //˴ƴ
        ITC_NOCOMITY_PEDESTRIAN_TYPE       = 0x800000    //˴
}ITC_TRIGGERMODE_TYPE;

//ӿڵӦpOutBuf
typedef struct tagNET_ITC_TRIGGERMODE_ABILITY
{
    DWORD dwSize;
    DWORD dwTriggerType; //ͣλʾITC_TRIGGERMODE_ABILITY壬Ͳͬ˴صĴҲͬ
    BYTE byRes[16]; 
}NET_ITC_TRIGGERMODE_ABILITY, *LPNET_ITC_TRIGGERMODE_ABILITY;

typedef struct tagNET_ITC_INTERVAL_PARAM    
{
    BYTE byIntervalType;    //ͣĬϰʱ䣩0-ʱЧ,1-Ч
    BYTE byRes1[3];
    WORD wInterval[MAX_INTERVAL_NUM];//ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    BYTE byRes[8];
}NET_ITC_INTERVAL_PARAM, *LPNET_ITC_INTERVAL_PARAM;

//ʶ
typedef struct tagNET_ITC_PLATE_RECOG_PARAM
{
    BYTE byDefaultCHN[MAX_CHJC_NUM]; /*豸ʡݵĺּд*/
    BYTE byEnable; //Ƿøʶ0-1-
    DWORD dwRecogMode;  
    /*ʶͣ
       bit0-ʶ0-ʶ1-ʶ(βʶ)  
       bit1-ʶСʶ0-Сʶ1-ʶ 
       bit2-ɫʶ0-óɫʶڱʶСʶʱֹã1-ɫʶ
       bit3-ũóʶ0-ũóʶ1-ũóʶ 
       bit4-ģʶ0-ģʶ1-ģʶ
       bit5-֡λ򳡶λ0-֡λ1-λ
       bit6-֡ʶʶ0-֡ʶ1-ʶ 
       bit7-ϻ죺0-죬1- 
       bit8-Ħгʶ0-Ħгʶ1-Ħгʶ;
       bit9-ģʽ0-羯/֡1-ڣ
       bit10-΢Сƣ0-ã1-΢Сʶ(6080)
       bit11-ȫ⣺0-ã1-ðȫ
       bit12-񺽳ʶ: 0-ã1-񺽳ʶ
       bit13-ƹб: 0-ã1-бPRS
       bit14-ʶ: 0-ã1-ʶPRS
       bit15-⣺0-ã1-
       bit16-Ʊ공⣺0-ã1-ûƱ공
       bit17-ΣƷ⣺0-ã1-ΣƷ
       bit18-ʹݳʶ0-ã1-ʹݳʶ 
       bit19-Ʒʶ0-ã1-óƷʶ
    */
    BYTE byVehicleLogoRecog;//ʶ 0-ã1-  
   /*
       0-1-ģ2-3-壬4-5-ʣ6-7-8-9-10-11-ԥ
       12-ڣ13-14-棬15-16-գ17-ӣ18-ɣ19-ɣ20-21-࣬22-³
       23-24-£25-26-27-̨28-29-أ30-ۣ31-£32-ƣ33-㣬
       34-0xff-ȫ
    */
    BYTE byProvince;//ʡֵ
    BYTE byRegion;// ֵ 0-1-ŷޣ2-, 3-ŷ&˹(EU&CIS)
    BYTE byRes1;
    WORD wPlatePixelWidthMin;//ʶСֵλأǰƼΧ[130,500]
    WORD wPlatePixelWidthMax;//ʶֵλأǰƼΧ[130,500]
    BYTE byRes[24];
}NET_ITC_PLATE_RECOG_PARAM, *LPNET_ITC_PLATE_RECOG_PARAM;

//ͽṹ
typedef struct tagNET_ITC_POLYGON
{
    DWORD dwPointNum; //Ч ڵ33һΪЧ߽ΪЧ 
    NET_VCA_POINT  struPos[ITC_MAX_POLYGON_POINT_NUM]; //α߽,20 
}NET_ITC_POLYGON, *LPNET_ITC_POLYGON;

typedef struct tagNET_ITC_PLATE_RECOG_REGION_PARAM    
{
    BYTE byMode; //ͣ0-Σ1-
    BYTE byRes1[3];
    union
    {
        NET_VCA_RECT struRect;  //
        NET_ITC_POLYGON struPolygon; //
    }uRegion;
    BYTE  byRes[16];    //
}NET_ITC_PLATE_RECOG_REGION_PARAM, *LPNET_ITC_PLATE_RECOG_REGION_PARAM;

//IOٲ
typedef struct tagNET_ITC_SINGLE_IOSPEED_PARAM
{
    BYTE byEnable; //Ƿã0-ã1-
    BYTE byTrigCoil1; //һȦIO0-IO1,1-IO2,2-IO3,3-IO4,4-IO5,5-IO6
    BYTE byCoil1IOStatus;//һȦIO״̬0-½أĬϣ1-أ2-غ½أ3-ߵƽ4-͵ƽ
    BYTE byTrigCoil2; //ڶȦIO0-IO1,1-IO2,2-IO3,3-IO4,4-IO5,5-IO6
    BYTE byCoil2IOStatus;//ڶȦIO״̬0-½أĬϣ1-أ2-غ½أ3-ߵƽ4-͵ƽ
    BYTE byRelatedDriveWay;//ĳ
    BYTE byTimeOut;//ʱʱ䣨Ĭ10λs
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    DWORD dwDistance;//Ȧ루Ĭ1000,λ
    BYTE byCapSpeed;//ٶȣĬ30λkm/h
    BYTE bySpeedLimit;//ֵĬ60λkm/h
    BYTE bySpeedCapEn; //Ƿóץģ0-1-
    BYTE bySnapTimes1; //Ȧ1ץĴĬϲץģ0-ץģ0-Ĵ5 
    BYTE bySnapTimes2; //Ȧ2ץĴĬ10-ץģ0-Ĵ5
    BYTE byBigCarSpeedLimit; //󳵳ֵ
    BYTE byBigCarSignSpeed;//־()λkm/h(3.7Ver)
    BYTE byIntervalType;    //ͣĬϰʱ䣩0-ʱЧ,1-Ч
    WORD wInterval1[MAX_INTERVAL_NUM];//Ȧ1ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    WORD wInterval2[MAX_INTERVAL_NUM];//Ȧ2ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IO(ͬʱ)0ʾIO11ʾIO2Դƣ0-1-
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byLaneType;   //ͣ0-δá1-ٹ·2-п·0xff-·
    BYTE byCarSignSpeed;//־٣λkm/h(3.7Ver)
    BYTE byUseageType; //;ͣITC_LANE_USEAGE_TYPE
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ(ʶ1һ)
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byLowSpeedLimit;                        //С޵ֵλkm/h
    BYTE byBigCarLowSpeedLimit;                //޵ֵλkm/h
    BYTE byLowSpeedCapEn;                 //Ƿõץģ0-1-
    BYTE byEmergencyCapEn;                //ǷӦץģ0-1-
    BYTE byRes[27];
}NET_ITC_SINGLE_IOSPEED_PARAM, *LPNET_ITC_SINGLE_IOSPEED_PARAM;

//IOٲ
typedef struct tagNET_ITC_POST_IOSPEED_PARAM
{
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_SINGLE_IOSPEED_PARAM struSingleIOSpeed[MAX_IOSPEED_GROUP_NUM]; //IO
    BYTE  byRes[32];
}NET_ITC_POST_IOSPEED_PARAM, *LPNET_ITC_POST_IOSPEED_PARAM;

//IO
typedef struct tagNET_ITC_SINGLEIO_PARAM
{
    BYTE byDefaultStatus;//IOĬ״̬0-͵ƽ1-ߵƽ
    BYTE byRelatedDriveWay;//ĳ
    BYTE bySnapTimes; //ץĴĬ10-ץģ0-Ĵ5
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    NET_ITC_INTERVAL_PARAM struInterval; //ץļ
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IOڣͬʱ
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byEnable;//IOʹܱ־0-ã1- (Remark:֧ bySupport&0x20ʾǷֵ֧IOIOʹ ʱЧ)
    BYTE byUseageType; //;ͣITC_LANE_USEAGE_TYPE
    BYTE byEmergencyCapEn;  //ǷӦץģ0-1-
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ
    BYTE byRes[24];
}NET_ITC_SINGLEIO_PARAM, *LPNET_ITC_SINGLEIO_PARAM;

//IO
typedef struct tagNET_ITC_POST_SINGLEIO_PARAM
{
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_SINGLEIO_PARAM struSingleIO[MAX_IOIN_NUMEX]; //IO
}NET_ITC_POST_SINGLEIO_PARAM, *LPNET_ITC_POST_SINGLEIO_PARAM;

typedef struct tagNET_ITC_LANE_PARAM
{
    BYTE byEnable; //Ƿøó0-ã1-
    BYTE byRelatedDriveWay;//ĳ
    WORD wDistance; //Ȧ룬ٶ
    WORD wTrigDelayTime; //ӳʱ䣨Ĭ200λ
    BYTE byTrigDelayDistance; //ӳپ루Ĭ0λ
    BYTE bySpeedCapEn; //Ƿóץģ0-1-
    BYTE bySignSpeed;//־٣λkm/h
    BYTE bySpeedLimit;//ֵλkm/h
    BYTE bySnapTimes; //ץĴĬ10-ץģ0-Ĵ5
    BYTE byOverlayDriveWay; //OSDӵĳ
    NET_ITC_INTERVAL_PARAM struInterval; //ץļ
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IOڣͬʱ
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byCartSignSpeed;//־()λkm/h
    BYTE byCartSpeedLimit;//ֵ󳵣λkm/h
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ
    BYTE byLaneType;   //ͣ0-δá1-ٹ·2-п·0xff-·
    BYTE byUseageType; //;ͣITC_LANE_USEAGE_TYPE
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byLowSpeedLimit;                    //С޵ֵλkm/h
    BYTE byBigCarLowSpeedLimit;                //޵ֵλkm/h
    BYTE byLowSpeedCapEn;                   //Ƿõץģ0-1-
    BYTE byEmergencyCapEn;                 //ǷӦץģ0-1-
    BYTE byRes[9];
}NET_ITC_LANE_PARAM, *LPNET_ITC_LANE_PARAM;

//RS485
typedef struct tagNET_ITC_POST_RS485_PARAM
{
    BYTE byRelatedLaneNum;//ĳ
    BYTE byTriggerSpareMode; //ģʽ0-Ĭϣ1-Ȧģʽ,2-ڻϳģʽ
    BYTE byFaultToleranceTime;//ݴʱ(λ:)ڼ⳵Ƿʱ
    BYTE byRes1; 
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_LANE_PARAM struLane[MAX_ITC_LANE_NUM]; //ĳ
    BYTE  byRes[32];
}NET_ITC_POST_RS485_PARAM, *LPNET_ITC_POST_RS485_PARAM;

typedef struct tagNET_ITC_RADAR_PARAM
{
    BYTE    byRadarType;    //״ͣ0-״,1-״2-άǣ3-΢4,״IOչ(˲ڿȦпڽʹãRS485״ﲻʹ),0xff-
    BYTE    byLevelAngle;   //ˮƽɽǶ,ĬΪ25(090)
    WORD    wRadarSensitivity; //״ 
    WORD    wRadarSpeedValidTime;//״ٶЧʱ(0~2000] ,0ʾ֧
    BYTE    byRes1[2];
    float      fLineCorrectParam;//Խ[0.0~2.0]
    int      iConstCorrectParam;//[-100~100]
    BYTE    byRes2[8];
}NET_ITC_RADAR_PARAM, *LPNET_ITC_RADAR_PARAM;

typedef struct tagNET_ITC_RS485_ACCESS_INFO_COND  //ṹ
{
    DWORD dwSize;
    DWORD dwChannel;
    DWORD dwTriggerModeType;
    BYTE  byAssociateRS485No;//RS485 15 (Ψһֵ)
    //    BYTE  byModeType; //0Ԥ1״23źŵƼ
    BYTE  byRes[15];
}NET_ITC_RS485_ACCESS_INFO_COND,*LPNET_ITC_RS485_ACCESS_INFO_COND;

typedef struct tagNET_ITC_RADAR_INFO_PARAM
{
    NET_ITC_RADAR_PARAM  struRadarParam;//24
    BYTE  byAssociateLaneNo;//ĳ199 (ֵڲͬRS485ظ)
    BYTE  byRes[103];
}NET_ITC_RADAR_INFO_PARAM, *LPNET_ITC_RADAR_INFO_PARAM;

typedef union tagNET_ITC_ACCESS_DEVINFO_PARAM_UNION
{
    BYTE uLen[128];
    NET_ITC_RADAR_INFO_PARAM struRadarInfoParam;//״
}NET_ITC_ACCESS_DEVINFO_PARAM_UNION, *LPNET_ITC_ACCESS_DEVINFO_PARAM_UNION;

typedef struct tagNET_ITC_RS485_ACCESS_CFG //144  ýṹ
{
    DWORD dwSize;
    BYTE  byModeType;//0Ԥbit1״bit2bit3źŵƼ
    BYTE  byRes[3];
    NET_ITC_ACCESS_DEVINFO_PARAM_UNION uITCAccessDevinfoParam; //64
    BYTE  byRes1[12];
}NET_ITC_RS485_ACCESS_CFG,*LPNET_ITC_RS485_ACCESS_CFG;

//2013-07-09 ״չ
typedef struct tagNET_ITC_RS485_ACCESS_INFO
{
    DWORD dwSize;
    NET_ITC_RADAR_PARAM  struRadar[MAX_ITC_LANE_NUM];//೵״Ϣ
    //ʾֵ֧ĬΪ0ʾ  мּ֧
    BYTE  byRes[20];
}NET_ITC_RS485_ACCESS_INFO, *LPNET_ITC_RS485_ACCESS_INFO;


//RS485״ﴥ
typedef struct tagNET_ITC_POST_RS485_RADAR_PARAM
{
    BYTE byRelatedLaneNum;//ĳ
    BYTE byRes1[3];
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_LANE_PARAM struLane[MAX_ITC_LANE_NUM]; //ĳ
    NET_ITC_RADAR_PARAM struRadar;  //״
    BYTE  byRes[32];
}NET_ITC_POST_RS485_RADAR_PARAM, *LPNET_ITC_POST_RS485_RADAR_PARAM;

typedef struct tagNET_ITC_VTLANE_PARAM
{
    BYTE byRelatedDriveWay;//ĳ
    BYTE bySpeedCapEn; //Ƿóץģ0-1-
    BYTE bySignSpeed;//־٣λkm/h
    BYTE bySpeedLimit;//ֵλkm/h
    BYTE bySnapTimes; //ץĴĬ10-ץģ0-Ĵ5
    BYTE byBigCarSignSpeed;///*󳵱־٣λkm/h*/
    BYTE byBigCarSpeedLimit;/*ֵλkm/h*/
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    NET_ITC_INTERVAL_PARAM struInterval; //ץļ
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IOڣͬʱ
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byLowSpeedLimit;/*޵٣λkm/h*/
    BYTE byBigCarLowSpeedLimit; /*޵٣λkm/h*/
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ
    NET_VCA_LINE struLine; //
}NET_ITC_VTLANE_PARAM, *LPNET_ITC_VTLANE_PARAM;

typedef struct tagNET_ITC_VTCOIL_INFO
{
    NET_VCA_RECT struLaneRect;  /*Ȧ*/
    BYTE byTrigFlag; //־0-ͷ1-β2-ͷ/β
    BYTE byTrigSensitive;  //ȣ1-100
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IO(ͬʱ)0ʾIO11ʾIO2Դƣ0-1-
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byLaneType;   //ͣ0-δá1-ٹ·2-п·0xff-·
    BYTE byEnableRadar; //Ƿ״٣0-1-
    NET_ITC_VTLANE_PARAM struLane; //ĳ
    //;ͣITC_LANE_USEAGE_TYPEʹ18(3.7Ver)
    BYTE byUseageType; 
    //ʻITC_LANE_CAR_DRIVE_DIRECT(3.7Ver)
    BYTE byCarDriveDirect;
    BYTE byRes[30];
}NET_ITC_VTCOIL_INFO, *LPNET_ITC_VTCOIL_INFO;

//Ȧ
typedef struct tagNET_ITC_POST_VTCOIL_PARAM
{
    BYTE    byRelatedLaneNum;//ĳ
    BYTE    byIsDisplay; //ƵǷʾȦ0-ʾ1-ʾ
    BYTE    byLoopPos; //䴥ȦƫĬ10
    BYTE    byPolarLenType; /*ƫͣ0ƫ񾵣1ʩ͵ƫ񾵡*/
    BYTE    byDayAuxLightMode; /*츨ģʽ0޸1LED2*/
    BYTE    byVideoLaneNO; //ƵοȵĲο
    BYTE    byVideoLowTh; /*ƵοȵֵʼֵĬ40*/
    BYTE    byVideoHighTh; /*ƵοȸֵʼֵĬ55*/
    BYTE    byRecordMode; //¼־0-¼1-¼
    BYTE     bySnapMode;//ץģʽ0-Ƶģʽ1-ģʽ
    /*ٷʽ0-٣0x1-״٣0x2-Ƶ*/
    BYTE    bySpeedDetector;
    BYTE    byRes2;
    WORD    wResolutionX;/* 豸ǰֱʿ*/
    WORD    wResolutionY;/* 豸ǰֱʸ*/
    DWORD   dwDayInitExp; /*Ƶعʱĳʼֵ2000*/
    DWORD   dwDayMaxExp; /*Ƶعʱֵ20000*/
    DWORD   dwNightExp; /*Ƶعʱֵ3000*/
    DWORD   dwSnapExp; /*ץعʱ*/
    BYTE    byDayInitGain; /*Ƶĳʼֵ200*/
    BYTE    byDayMaxGain; /*Ƶֵ400*/
    BYTE    byNightGain; /*Ƶ*/
    BYTE    bySnapGain; /*ץ*/
    DWORD   dwSceneMode; //ģʽ SCENE_MODE
    NET_DVR_GEOGLOCATION struGeogLocation; //ַλ(Ĭ㽭)
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_VTCOIL_INFO struVtCoil[MAX_VL_NUM]; //Ȧ
    NET_ITC_RADAR_PARAM struRadar;  //״
    NET_VCA_LINE struLine; //ҳ
    //ΥͣλʾITC_VIOLATION_DETECT_TYPE0-ã1-(3.7Ver)
    DWORD dwVioDetectType;    
    BYTE  byDebugMode; /*ģʽ0-ã1-*/
    BYTE  byRes[11];
}NET_ITC_POST_VTCOIL_PARAM, *LPNET_ITC_POST_VTCOIL_PARAM;

//IO̵Ʋ
typedef struct tagNET_ITC_SINGLE_IOTL_PARAM
{
    BYTE byEnable; //Ƿã0-ã1-
    BYTE byLightIO; //̵IO0-IO1,1-IO2,2-IO3,3-IO4,4-IO5,5-IO6
    BYTE byTrafficLight; //̵Ч״̬0-ߵƽƣ͵ƽ̵ƣ1-ߵƽ̵ƣ͵ƽ
    BYTE byTrigIO;//IOţ0-IO1,1-IO2,2-IO3,3-IO4,4-IO5,5-IO6
    BYTE byTrigIOStatus;//IOڵ״̬Ĭ00-½أ1-أ2-غ½أ3-ߵƽ4-͵ƽ
    BYTE byRelatedDriveWay;//ĳ
    BYTE byRecordEnable;//¼־0-¼1-¼
    BYTE byRecordType;//¼ͣ0-Ԥ¼1-ʱ¼
    BYTE byPreRecordTime;//¼ƬԤ¼ʱ䣨Ĭ0λ
    BYTE byRecordDelayTime;//¼Ƭʱʱ䣨Ĭ0λ
    BYTE byRecordTimeOut;//¼ʱʱ䣨룩
    BYTE byRedSnapTimes; //ץĴ0-ץģ0-Ĵ5 
    BYTE byGreenSnapTimes; //̵ץĴ0-ץģ0-Ĵ5
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    BYTE byRes1;
    BYTE byIntervalType;    //ͣĬϰʱ䣩0-ʱЧ,1-Ч
    WORD wRedInterval[MAX_INTERVAL_NUM];//ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    WORD wGreenInterval[MAX_INTERVAL_NUM];//̵ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IOڣͬʱ
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE byRes2[3];
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ
    BYTE  byRes[32];
}NET_ITC_SINGLE_IOTL_PARAM, *LPNET_ITC_SINGLE_IOTL_PARAM;

//羯IO̵Ʋ
typedef struct tagNET_ITC_EPOLICE_IOTL_PARAM
{
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_SINGLE_IOTL_PARAM struSingleIOTL[MAX_IOSPEED_GROUP_NUM]; //IO̵Ʋ
    BYTE  byRes[32];
}NET_ITC_EPOLICE_IOTL_PARAM, *LPNET_ITC_EPOLICE_IOTL_PARAM;

typedef enum _ITC_SERIAL_PROTOCOL_
{
    ITC_PROTOCOL_UNKNOW = 0, /*δ֪*/
        ITC_SINGLE_COIL_PROTOCOL_MODE1 = 1, /*ȦЭģʽ1ʾΪ_1_1_1_1뿪뿪ʱץģ뿪ʶϴ3ųͼƬͳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE1 = 2, /*˫ȦЭģʽ1ʾΪ˫_1_1_2_11뿪1뿪2ץģ뿪1ʶϴ3ųͼƬͳƽĬϣ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE2 = 3, /*˫ȦЭģʽ2ʾΪ˫_1_2_2_1뿪1뿪2뿪2ʱץģ뿪1ʶϴ3ųͼƬͳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE3 = 4, /*˫ȦЭģʽ3ʾΪ˫_2_1_2_12뿪1뿪2ʱץģ뿪1ʶϴ3ųͼƬͳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE4 = 5, /*˫ȦЭģʽ4ʾΪ˫/_2_2_2_12뿪2뿪2ʱץģ뿪1ʶϴ3ųͼƬͳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE5 = 6, /*˫ȦЭģʽ5ʾΪ˫/_2_2_2_22뿪2뿪2ʱץģ2뿪1ʶϴ3ųͼƬŶȸߵĳƽĬϣ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE6 = 7, /*˫ȦЭģʽ6ʾΪ˫/_1_2_2_21뿪2뿪2ʱץģ1뿪1ʶϴ3ųͼƬŶȸߵĳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE7 = 8, /*˫ȦЭģʽ7ʾΪ˫_1_1_2_11뿪1뿪2ʱץģ뿪1ʶϴͼƬ뿪1Ƶ1뿪1뿪2ʱͳƽ*/
        ITC_DOUBLE_COIL_PROTOCOL_MODE8 = 9, /*˫ȦЭģʽ8ʾΪ˫_1_1_2_21뿪1뿪2ʱץģ1뿪1ʶϴͼƬ뿪1Ƶ1뿪1뿪2ʱŶȸߵĳƽĬϣ*/
        ITC_SINGLE_COIL_PROTOCOL_MODE2 = 10, /*ȦЭģʽ2ʾΪ_1_1_1_2뿪뿪ʱץģ뿪ʶϴͼƬ뿪Ƶ뿪뿪ʱŶȸߵĳƽĬϣ*/
        ITC_OTHER_PROTOCOL = 0xff /*Э(demoã3.3֮汾demoͿؼִֵ֧)*/
}ITC_SERIAL_PROTOCOL;

//߼ץ
typedef enum _ITC_NORMAL_PASS_SERIAL_PROTOCOL_
{
    ITC_NORMAL_PASS_SERIAL_UNKNOW     =  0,   //δ֪
        ITC_NORMAL_PASS_PROTOCOL_MODE1  = 1,  //Ȧ뿪ץģʶϴĬϣ
        ITC_NORMAL_PASS_PROTOCOL_MODE2 =2,  //Ȧ뿪ץģʶϴ뿪ͼƬŶȸߵĳƽ
        ITC_NORMAL_PASS_PROTOCOL_MODE3 =3,  //˫Ȧ뿪1ץģʶϴĬϣ
        ITC_NORMAL_PASS_PROTOCOL_MODE4 =4, //˫Ȧ1뿪1ץģʶϴ뿪1ͼƬŶȸߵĳƽ
        ITC_NORMAL_PASS_PROTOCOL_MODE5 =5, //˫Ȧ2뿪1ץģʶϴ뿪1ͼƬŶȸߵĳƽ
}ITC_NORMAL_PASS_SERIAL_PROTOCOL;

//Υ߼ץ
typedef enum _ITC_INVERSE_SERIAL_PROTOCOL_
{
    ITC_INVERSE_SERIAL_UNKNOW     =  0,   //δ֪
        ITC_INVERSE_PROTOCOL_MODE1  = 1,  //ץ
        ITC_INVERSE_PROTOCOL_MODE2 =2,  //1ץ2š뿪2ץģ1žʶϴ3ųͼƬŶȸߵĳƽ
        ITC_INVERSE_PROTOCOL_MODE3 =3,  //1뿪2ץģ1ʶϴ2ųͼƬͳƽ
}ITC_INVERSE_SERIAL_PROTOCOL;

//Υ߼ץ
typedef enum _ITC_SPEED_SERIAL_PROTOCOL_
{
    ITC_SPEED_SERIAL_UNKNOW     =  0,   //δ֪
        ITC_SPEED_PROTOCOL_MODE1  = 1,  //ץ
        ITC_SPEED_PROTOCOL_MODE2 =2,  //˫/Ȧ뿪1뿪2뿪2ʱץģ뿪1ʶϴͼƬ뿪1뿪1뿪2뿪2ʱͳƽ
        ITC_SPEED_PROTOCOL_MODE3 =3,  //˫/Ȧ뿪1뿪2뿪2ʱץģ뿪1ʶϴͼƬ뿪1뿪1뿪2ͳƽ
}ITC_SPEED_SERIAL_PROTOCOL;

//
typedef struct tagNET_ITC_SERIAL_INFO
{
    BYTE bySerialProtocol; //ЭͣITC_SERIAL_PROTOCOL
    BYTE byIntervalType;    //ͣĬϰʱ䣩0-ʱЧ,1-Ч
    WORD wInterval;//ļʱ䣨λmsļ루λףbyIntervalTypeΪ0ʱʾʱ䣬byIntervalTypeΪ1ʱʾ
    BYTE byNormalPassProtocol; //ץЭͣITC_NORMAL_PASS_SERIAL_PROTOCOL
    BYTE byInverseProtocol; //ץЭͣITC_INVERSE_SERIAL_PROTOCOL
    BYTE bySpeedProtocol; //ץЭͣITC_SPEED_SERIAL_PROTOCOL
    BYTE byRes[9];
}NET_ITC_SERIAL_INFO, *LPNET_ITC_SERIAL_INFO;

typedef struct tagNET_ITC_EPOLICE_LANE_PARAM
{
    BYTE byEnable; //Ƿøó0-ã1-
    BYTE byRelatedDriveWay;//ĳ
    WORD wDistance; //Ȧ룬λ
    BYTE byRecordEnable;//¼־0-¼1-¼
    BYTE byRecordType;//¼ͣ0-Ԥ¼1-ʱ¼
    BYTE byPreRecordTime;//¼ƬԤ¼ʱ䣨Ĭ0λ
    BYTE byRecordDelayTime;//¼Ƭʱʱ䣨Ĭ0λ
    BYTE byRecordTimeOut;//¼ʱʱ䣨룩
    BYTE bySignSpeed;//־(ʽ羯ģʽЧ)λkm/h
    BYTE bySpeedLimit;//ֵ(ʽ羯ģʽЧ)λkm/h
    BYTE byOverlayDriveWay; //OSDӵĳ
    NET_ITC_SERIAL_INFO struSerialInfo; //
    BYTE byRelatedIOOut[MAX_IOOUT_NUM]; //IOڣͬʱ
    BYTE byFlashMode;   //˸ģʽ0-ͬʱ1-
    BYTE bySerialType; //ͣ0-˽г1-˽OEM2-
    BYTE byRelatedIOOutEx;//0λʾIO1Դƣ0-1- ֹ֧8(byRelatedIOOutֶ)
    BYTE bySnapPicPreRecord; //ץͼƬԤ¼ʱ㣻0-ĬֵڶͼƬ1-һͼƬ2-ڶͼƬ3-ͼƬ
    NET_ITC_PLATE_RECOG_REGION_PARAM struPlateRecog[MAX_LANEAREA_NUM]; //ʶ
    BYTE byBigCarSignSpeed;    ///*󳵱־٣λkm/h*/
    BYTE byBigCarSpeedLimit;/*ֵλkm/h*/    
    BYTE byRedTrafficLightChan;//ͨţ116̵Ƽ
    BYTE byYellowTrafficLightChan;//Ƶͨţ116̵Ƽ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byRes3[11];
}NET_ITC_EPOLICE_LANE_PARAM, *LPNET_ITC_EPOLICE_LANE_PARAM;

//羯/ʽ羯RS485
typedef struct tagNET_ITC_EPOLICE_RS485_PARAM
{
    BYTE byRelatedLaneNum;//ĳ
    BYTE byTrafficLightSignalSrc;//ͨźԴ 0 1̵Ƽ
    BYTE byRes1[2];
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_EPOLICE_LANE_PARAM struLane[MAX_ITC_LANE_NUM]; //ĳ
    BYTE  byRes[32];
}NET_ITC_EPOLICE_RS485_PARAM, *LPNET_ITC_EPOLICE_RS485_PARAM;

//Բṹ
typedef struct tagNET_ITC_LANE_LOGIC_PARAM
{
    BYTE byUseageType;     //;ͣITC_LANE_USEAGE_TYPE
    BYTE byDirectionType;  //ͣITC_LANE_DIRECTION_TYPE
    BYTE byCarDriveDirect; //ʻITC_LANE_CAR_DRIVE_DIRECT 
    BYTE byRes[33];        //
}NET_ITC_LANE_LOGIC_PARAM, *LPNET_ITC_LANE_LOGIC_PARAM;

//Ƶ羯߽ṹ
typedef struct tagNET_ITC_LINE
{
    NET_VCA_LINE struLine; //߲
    BYTE byLineType; //ͣITC_LINE_TYPE
    BYTE byRes[7];
}NET_ITC_LINE, *LPNET_ITC_LINE;

typedef struct tagNET_ITC_SNAPMODE_PARAM
{
    BYTE     byVehicleCapMode;//ץģʽ0-Ƶģʽ1-ģʽ
    BYTE     byNoVehicleCapMode;//ǻץģʽ0-Ƶģʽ1-ģʽ
    BYTE     byPasserCapMode;//ץģʽ0-Ƶģʽ1-ģʽ
    BYTE     byRes[29];
}NET_ITC_SNAPMODE_PARAM, *LPNET_ITC_SNAPMODE_PARAM;

//size = 128
typedef struct tagNET_ITC_HVT_EC_PARAM
{
    DWORD         dwCapShutter;            //ץĿ0~65535
    WORD         wCapGain;            //ץ0100
    BYTE          byRes[2];
    DWORD         dwDayTimeVideoShutter;    //عʱֵ
    WORD         wDayTimeVideoGain;        //ֵ
    WORD         wNightVideoGain;            //ֵ
    DWORD         wNightVideoShutter;        //عʱֵ
    BYTE          byRes1[108];
}NET_ITC_HVT_EC_PARAM, *LPNET_ITC_HVT_EC_PARAM;

typedef struct tagNET_ITC_LANE_HVT_PARAM
{
    BYTE byLaneNO; //ĳ 1~255ڵӺϴ
    BYTE bySignSpeed;    //־٣λkm/h 0255  70
    BYTE bySpeedLimit;    //ֵλkm/h 0255    80 ʵЧ
    BYTE byBigCarSignSpeed;///*󳵱־٣λkm/h*/
    BYTE byBigCarSpeedLimit;/*ֵλkm/h*/
    BYTE bySpeedCapEn; //Ƿóץģ0-1-
    BYTE byCaptureCount;//ץ15()
    BYTE byRelatedIOOut;    /*IO(ͬʱ)λʾIOڣ0λʾIO1Դƣ0-1-*/
    BYTE byFlashMode;        /*˸ģʽ0-ͬʱ1-*/
    BYTE byEnableRadar; //Ƿ״٣0-1-
    BYTE byRes2[2];
    DWORD dwCapTarget;    //ץ bit0 ʾ bit1 ʾǻ bit2 ʾ 0ʾѡ 1ʾѡ
    NET_ITC_INTERVAL_PARAM struInterval; //ץļ
    BYTE byRes3[24];
    NET_ITC_LANE_LOGIC_PARAM struLane; //ԣbyUseageTypebyCarDriveDirect
    NET_ITC_LINE struLeftLaneLine;          //󳵵ߣΪߡʵߡߺ˫
    NET_ITC_LINE struRightLaneLine;          //ҳߣΪߡʵߡߺ˫
    NET_ITC_POLYGON struPlateRecog;         //ʶ
    NET_ITC_POLYGON struTraceArea;          //Ƶ
    NET_VCA_LINE  struForwardTrigLine;      //򴥷ߣһ߶ΣĶ˵λãĿǰֻ֧ˮƽãӿڰ߶ε˵㱣档һΪѴλã     
    NET_VCA_LINE  struBackwardTrigLine;     //򴥷ߣһ߶ΣĶ˵λãĿǰֻ֧ˮƽãӿڰ߶ε˵㱣棨һΪѴλã
    NET_VCA_LINE  struLeftTrigLine;          //ߴߣһ߶ΣĶ˵λãĿǰֱִֻ֧ãӿڰ߶ε˵㱣棨һΪ߽복Ѵλã
    NET_VCA_LINE  struRightTrigLine;          //ұߴߣһ߶ΣĶ˵λãĿǰֱִֻ֧ãӿڰ߶ε˵㱣棨һΪұ߽복Ѵλã
    BYTE byRes4[60];
}NET_ITC_LANE_HVT_PARAM, *LPNET_ITC_LANE_HVT_PARAM;

typedef struct tagNET_ITC_POST_HVT_PARAM
{
    BYTE byLaneNum;//ʶĳ1-6 
    BYTE bySceneMode;//0-δ֪1-·2-С
    BYTE byRoadExpBright;//·ȣƵع֮һ޻ʱݴֵƵع
    BYTE byPlateExpBright;//ȣƵع֮һлͨʶ𵽳ʱݴֵƵع
    NET_ITC_POLYGON struDetectArea;                    //Ƶ  
    NET_ITC_SNAPMODE_PARAM  struCapMode;//ץģʽ  
    NET_ITC_HVT_EC_PARAM struEcParam;    //عƲ  
    NET_ITC_LANE_HVT_PARAM struLaneParam[MAX_ITC_LANE_NUM]; //
    NET_ITC_PLATE_RECOG_PARAM  struPlateRecog;    //ʶ
    NET_DVR_GEOGLOCATION struGeogLocation;    //ַλãĬ㽭
    BYTE byRes[324];
}NET_ITC_POST_HVT_PARAM, *LPNET_ITC_POST_HVT_PARAM;

/*************************MPRģʽ begin 2013-12-07****************/
typedef struct tagNET_ITC_LANE_MPR_PARAM
{
    BYTE byLaneNO;
    union
    {
        BYTE  uLen[4];
        struct
        {
            BYTE  byIONo;//IO[1, byIoInNum+1] С1ʼֵݽӿNET_DVR_SNAP_ABILITYֶbyIoInNum
            BYTE  byTriggerType;//0-½أ1-
            BYTE  byRes1[2];
        }struIO;//IOģʽЧ
        struct
        {
            BYTE  byRelateChan;//ͨ[1,16]
            BYTE  byRes2[3];    
        }struRS485;
    }uTssParamInfo;
    BYTE byCarDriveDirect; //ʻ ITC_LANE_CAR_DRIVE_DIRECT
    BYTE byRes[58];
    NET_ITC_LINE struLaneLine;//
    NET_ITC_POLYGON struPlateRecog;//ʶ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byRes1[255];
}NET_ITC_LANE_MPR_PARAM,*LPNET_ITC_LANE_MPR_PARAM;

typedef struct tagNET_ITC_POST_MPR_PARAM
{
    BYTE byEnable;    
    BYTE byLaneNum;
    BYTE bySourceType;//0-MPRƵ,1-IOظȦ,2-RS485Ĵź
    BYTE byPicUploadType;//ͼƬϴͣ0~ȫϴ1-ϴ2-ϴ
    BYTE byRoadType;//ģʽѡ 0-ڣ1-е·2-Զ
    BYTE byRes2;
    WORD wCustomDelayTime;//Զץʱʱ䣨byRoadTypeΪ "Զ"ʱЧΧ[0,15000]ms
    BYTE byRes[56];
    NET_ITC_LINE struLaneBoundaryLine;//߽ߣ߽߳ߣ
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog;//ʶ  40
    NET_ITC_LANE_MPR_PARAM struLaneParam[MAX_ITC_LANE_NUM/*6*/];    
    char szSceneName[NAME_LEN/*32*/]; //
    BYTE byRes1[408];
}NET_ITC_POST_MPR_PARAM,*LPNET_ITC_POST_MPR_PARAM;
/*************************MPRģʽ end 2013-12-07****************/

typedef struct tagNET_DVR_VIA_LANE_PARAM
{
    BYTE byLaneNO;  //
    BYTE byRes[63]; // 
    NET_ITC_LANE_LOGIC_PARAM  struLogicParam; //Բ
    NET_ITC_LINE  struLaneLine;//  
    NET_ITC_POLYGON  struPlateRecog;//ʶ  
    BYTE byRes1[300]; // 
} NET_DVR_VIA_LANE_PARAM,*LPNET_DVR_VIA_LANE_PARAM;

typedef struct tagNET_DVR_VIA_VTCOIL_PARAM
{
    BYTE byEnable;    //ʹ 0- 1-
    BYTE byLaneNum; //
    BYTE byRes[62]; //     
    NET_ITC_LINE  struLaneBoundaryLine;//߽ߣ߽߳ߣ 
    NET_DVR_VIA_LANE_PARAM  struLaneParam[MAX_ITC_LANE_NUM/*6*/];
    NET_ITC_PLATE_RECOG_PARAM  struPlateRecog;//ʶ      
    BYTE byRes1[624];//
}NET_DVR_VIA_VTCOIL_PARAM,*LPNET_DVR_VIA_VTCOIL_PARAM;

//ӿ
typedef struct tagNET_DVR_TRIGGER_COND
{
    DWORD  dwSize;       //ṹС
    DWORD  dwChannel;    //ͨ
    DWORD  dwTriggerMode;//ʽο ITC_TRIGGERMODE_TYPE
    BYTE   byDetSceneID;//ⳡ[1,4], IPCĬ0
    BYTE   byRes[63];    //
}NET_DVR_TRIGGER_COND,*LPNET_DVR_TRIGGER_COND;

typedef struct tagNET_ITC_LANE_IMT_PARAM
{
    BYTE byLaneNO;//ӳ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byRes[146];
    NET_ITC_LINE struLaneLine;//
    BYTE byRes1[256];
}NET_ITC_LANE_IMT_PARAM,*LPNET_ITC_LANE_IMT_PARAM;

typedef struct tagNET_ITC_POST_IMT_PARAM
{
    BYTE byEnable;    
    BYTE byLaneNum;
    BYTE bySnapMode; //ץͣ0~1~
    BYTE byRes[61];
    NET_ITC_PLATE_RECOG_PARAM  struPlateRecog;//ʶ 
    NET_ITC_LINE struLaneBoundaryLine;//߽ߣұ߳ı߽ߣ
    NET_ITC_LANE_IMT_PARAM struLaneParam[MAX_ITC_LANE_NUM/*6*/];    
    BYTE byRes1[1584];
}NET_ITC_POST_IMT_PARAM,*LPNET_ITC_POST_IMT_PARAM;

typedef struct tagNET_ITC_LANE_PRS_PARAM
{
    BYTE byLaneNO;
    union
    {
        BYTE  uLen[4];
        struct
        {
            BYTE  byIONo;//IO[1,4]
            BYTE  byTriggerType;//0-½أ1-
            BYTE  byRes1[2];
        }struIO;//IOģʽЧ
        struct
        {
            BYTE  byRelateChan;//ͨ[1,16]
            BYTE  byRes2[3];    
        }struRS485;
    }uTssParamInfo;
    BYTE byRes[59];
    NET_ITC_LINE struLaneLine;//
    NET_ITC_POLYGON struPlateRecog;//ʶ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byRes1[255];
}NET_ITC_LANE_PRS_PARAM,*LPNET_ITC_LANE_PRS_PARAM;


typedef struct tagNET_ITC_POST_PRS_PARAM
{
    BYTE byEnable;    
    BYTE byLaneNum;
    BYTE bySourceType;//0-Ƶ,1-IOظȦ,2-RS485Ĵź
    BYTE bySnapMode;//0-ȫͼ1-ȫͼ+д
    BYTE byCapMode;//bySourceTypeΪ0Ƶʱʹã0-Ƶģʽ1-ģʽ
    BYTE byRes[59];
    NET_ITC_LINE struLaneBoundaryLine;//߽ߣ߽߳ߣ
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog;//ʶ  40
    NET_ITC_LANE_PRS_PARAM struLaneParam[MAX_ITC_LANE_NUM/*6*/];    
    BYTE byRes1[440];
}NET_ITC_POST_PRS_PARAM,*LPNET_ITC_POST_PRS_PARAM;

typedef struct tagNET_IPC_LANE_HVT_PARAM
{
    BYTE byLaneNO;
    BYTE byCarDriveDirect; //ʻ ITC_LANE_CAR_DRIVE_DIRECT
    BYTE byRes[62];
    NET_ITC_LINE struLaneLine;//
    NET_ITC_POLYGON struPlateRecog;//ʶ
    BYTE byRes1[256];
} NET_IPC_LANE_HVT_PARAM,*LPNET_IPC_LANE_HVT_PARAM;

typedef struct tagNET_IPC_POST_HVT_PARAM
{
    BYTE  byEnable;    
    BYTE  byLaneNum;
    BYTE  byRes[62];
    NET_ITC_LINE struLaneBoundaryLine;//߽ߣ߽߳ߣ
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog;//ʶ  40
    NET_IPC_LANE_HVT_PARAM struLaneParam[MAX_ITC_LANE_NUM/*6*/];    
    char    szSceneName[NAME_LEN/*32*/]; //
    BYTE  byRes1[408];
} NET_IPC_POST_HVT_PARAM,*LPNET_IPC_POST_HVT_PARAM;

//ץĻ4.0
typedef struct tagNET_ITC_LANE_HVT_PARAM_V50
{
    BYTE  byLaneNO;        //ĳ1255(ڵӺϴ)
    BYTE  byFlashMode;    //˸ģʽ0-ͬʱ1-
    BYTE  bySignSpeed;    //С־޸٣λkm/h
    BYTE  bySpeedLimit;    //С޸ֵλkm/h
    BYTE  bySignLowSpeed;    //С־޵٣λkm/h
    BYTE  byLowSpeedLimit;    //С޵ֵλkm/h
    BYTE  byBigCarSignSpeed;    //󳵱־޸٣λkm/h½棩
    BYTE  byBigCarSpeedLimit;    //޸ֵλkm/h½棩
    BYTE  byBigCarSignLowSpeed;    //󳵱־޵٣λkm/h
    BYTE  byBigCarLowSpeedLimit;    //޵ֵλkm/h
    BYTE  bySnapTimes;    //ץ1~3
    BYTE  byDriveLineSnapTime;// ѹץ 1~3
    BYTE  byHighSpeedSnapTime;// ץ1~3
    BYTE  byLowSpeedSnapTime;// ץ1~3
    BYTE  byBanSnapTime;// Υץ  1~3
    BYTE  byReverseSnapTime;//ץ  1~3
    BYTE  byRelatedDriveWay;                //ţƥ䳵
    BYTE  byLaneType;   //ͣ0-δá1-ٹ·2-п·0xff-·
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪbyRelatedDriveWayӦȷΨһԡ
    BYTE  byRelaLaneDirectionType;
    BYTE  byRes1[29];
    //ĿǰʹõһģԺܻչΪ೵ֱ
    //, λʾ,0-,1-òο ITC_VIOLATION_DETECT_TYPE
    DWORD  dwVioDetectType;
    DWORD  dwRelatedIOOut;  //IO(ͬʱ)λʾIOڣ0λʾIO1Դƣ0-1-
    NET_ITC_LINE struTrigLine; //ߣĿǰʹõһģԺܻչΪ೵ֱ
    NET_ITC_LINE struLineLeft;                //󳵵
    NET_ITC_POLYGON struPlateRecog;       //ʶ
    NET_ITC_LANE_LOGIC_PARAM struLane;   //ԣbyUseageTypebyCarDriveDirect
    NET_ITC_INTERVAL_PARAM struInterval;//ץļ20byte
    BYTE byRes2[280];
}NET_ITC_LANE_HVT_PARAM_V50, *LPNET_ITC_LANE_HVT_PARAM_V50;


typedef struct tagNET_ITC_POST_HVT_PARAM_V50
{
    BYTE byLaneNum;    //ʶĳ1-6
    BYTE byCapType;        //ץͣ0-ǡˣĬϣ1-
    BYTE byCapMode;    //ץķʽ0-Ƶ֡1-ץģ2-ģʽ 
    BYTE bySecneMode;    //ģʽ0-·Ĭϣ1-Сڣ2-ٹ·    
    BYTE bySpeedMode;  //ģʽ0-޲٣1-״٣2-Ƶ
    BYTE byLineRuleEffect; //Ч,ÿһλһ,0-Ч;1-Чbit0-󴥷;bit1-Ҵ;bit2-Ƶ
    BYTE byRes1[78];
    NET_ITC_LINE struLeftTrigLine;    //󴥷(һֱ)
    NET_ITC_LINE struRigtTrigLine;    //Ҵ(һֱ)
    NET_ITC_LINE struLaneBoundaryLine;        //߽ߣұ߳ҳߣ
    NET_ITC_POLYGON struDetectArea;    //Ƶ
    NET_DVR_GEOGLOCATION struGeogLocation; //λãĬ㽭ʡʱ
    NET_ITC_LANE_HVT_PARAM_V50 struLaneParam[MAX_ITC_LANE_NUM/*6*/]; //
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog;    //ʶ
    BYTE byRes2[260];
} NET_ITC_POST_HVT_PARAM_V50, *LPNET_ITC_POST_HVT_PARAM_V50;


//
typedef struct tagNET_ITC_LANE_NOCOMITY_PEDESTRIAN_PARAM
{
    BYTE byRelatedDriveWay;//ĳ
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    BYTE byPedestriansNum;//ֵΧ1-100Ĭֵ1
    BYTE byVehicleSpeed;//ٶֵΧ0-100Ĭֵ0
    DWORD dwVehicleInterval; //ֵΧ0-65536Ĭֵ0
    BYTE byPedesDetRule; //˼򣻴˼ʻ 0~ 1~ҡ
    BYTE byRes[3];
    NET_ITC_LINE struLaneLine;//
    NET_ITC_LINE struStopLine;//ֹͣ
    NET_ITC_POLYGON struPlateRecog;       //ʶ 
    BYTE byRes1[280];
} NET_ITC_LANE_NOCOMITY_PEDESTRIAN_PARAM,
*LPNET_ITC_LANE_NOCOMITY_PEDESTRIAN_PARAM;

//˲
typedef struct tagNET_ITC_NOCOMITY_PEDESTRIAN_PARAM
{
    BYTE byEnable;    //ʹ
    BYTE byLaneNum;// Χ1-3Ĭֵ3
    BYTE byRes[74];
    NET_ITC_LINE struLaneBoundaryLine;//ұ߽
    NET_ITC_LINE struTriggerLine;//˴
    NET_ITC_POLYGON struPedesDetRecog;//˼
    NET_ITC_LANE_NOCOMITY_PEDESTRIAN_PARAM struLaneParam[MAX_ITC_LANE_NUM/*6*/];    //
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    BYTE byRes1[400];
}NET_ITC_NOCOMITY_PEDESTRIAN_PARAM,
*LPNET_ITC_NOCOMITY_PEDESTRIAN_PARAM;

//IOźŵƲ
typedef struct tagNET_ITC_SINGLE_IO_LIGHT_PARAM
{
    BYTE byLightType; //ͨƵ,0-ת,1-ֱе,2-ת
    BYTE byRelatedIO; //IOں
    BYTE byRedLightState; //Ƶƽ״̬0-ߵƽƣ1-͵ƽ
    BYTE byRes[17];
}NET_ITC_SINGLE_IO_LIGHT_PARAM, *LPNET_ITC_SINGLE_IO_LIGHT_PARAM;

//IOźŵƲ
typedef struct tagNET_ITC_IO_LIGHT_PARAM
{
    NET_ITC_SINGLE_IO_LIGHT_PARAM struIOLight[MAX_LIGHT_NUM]; //IOźŵƲ
    BYTE byRes[8];
}NET_ITC_IO_LIGHT_PARAM, *LPNET_ITC_IO_LIGHT_PARAM;

//485źŵƲ
typedef struct tagNET_ITC_SINGLE_RS485_LIGHT_PARAM
{
    BYTE byLightType; //ͨƵͣ0-תƣ1-ֱеƣ2-ת
    BYTE byRelatedLightChan; //ĺ̵Ƽͨ
    BYTE byInputLight;    //źŵͣ0-Ӻƣ1-̵
    BYTE byRelatedYLightChan; //ĻƵƼͨ
    BYTE byRes[16];
}NET_ITC_SINGLE_RS485_LIGHT_PARAM, *LPNET_ITC_SINGLE_RS485_LIGHT_PARAM;

//485źŵƲ
typedef struct tagNET_ITC_RS485_LIGHT_PARAM
{
    NET_ITC_SINGLE_RS485_LIGHT_PARAM struRS485Light[MAX_LIGHT_NUM]; //485źŵƲ
    BYTE byRes[8];
}NET_ITC_RS485_LIGHT_PARAM, *LPNET_ITC_RS485_LIGHT_PARAM;

typedef struct tagNET_POS_PARAM
{
    WORD wLeft;
    WORD wTop;
    WORD wRight;
    WORD wBottom;
}NET_POS_PARAM, *LPNET_POS_PARAM;

//Ƶ⽻ͨźŵƲṹ
typedef struct tagNET_ITC_SINGLE_VIDEO_DETECT_LIGHT_PARAM
{
    BYTE byLightNum; //ͨƸ
    BYTE byStraightLight; //Ƿֱб־ƣ0- 1-
    BYTE byLeftLight; //Ƿת־ƣ0-1-
    BYTE byRightLight; //Ƿת־ƣ0-1-
    BYTE byRedLight;//Ƿкƣ0-1-
    BYTE byGreenLight; //Ƿ̵ƣ0-1-
    BYTE byYellowLight; //ǷлƵƣ0-1-
    BYTE byYellowLightTime;//ȡֵΧ010sITC3.7Ver
    NET_POS_PARAM struLightRect; //ͨ
    BYTE byRes[24];
}NET_ITC_SINGLE_VIDEO_DETECT_LIGHT_PARAM, *LPNET_ITC_SINGLE_VIDEO_DETECT_LIGHT_PARAM;


//Ƶ⽻ͨźŵƲṹ(12⣬488ֽ)
typedef struct tagNET_ITC_VIDEO_DETECT_LIGHT_PARAM
{
    NET_ITC_SINGLE_VIDEO_DETECT_LIGHT_PARAM struTrafficLight[MAX_VIDEO_DETECT_LIGHT_NUM]; //ƵźŵƲ
    BYTE byRes[8];
}NET_ITC_VIDEO_DETECT_LIGHT_PARAM, *LPNET_ITC_VIDEO_DETECT_LIGHT_PARAM;

//ͨźŵƽ
typedef union tagNET_ITC_LIGHT_ACCESSPARAM_UNION
{
    DWORD uLen[122];
    NET_ITC_IO_LIGHT_PARAM struIOLight; //IOźŵƲ
    NET_ITC_RS485_LIGHT_PARAM struRS485Light; //485źŵƲ
    NET_ITC_VIDEO_DETECT_LIGHT_PARAM struVideoDelectLight; //ƵźŵƲ
}NET_ITC_LIGHT_ACCESSPARAM_UNION, *LPNET_ITC_LIGHT_ACCESSPARAM_UNION;

//ͨźŵƲṹ
typedef struct tagNET_ITC_TRAFFIC_LIGHT_PARAM
{
    BYTE bySource; //ͨźŵƽԴ0-IO룬1-RS485
    BYTE byRes1[3];
    NET_ITC_LIGHT_ACCESSPARAM_UNION struLightAccess;//źŵƽ
    BYTE byRes[32];
}NET_ITC_TRAFFIC_LIGHT_PARAM, *LPNET_ITC_TRAFFIC_LIGHT_PARAM;

//Υ߲ṹ
typedef struct tagNET_ITC_VIOLATION_DETECT_LINE
{
    NET_ITC_LINE  struLaneLine; //߲
    NET_ITC_LINE  struStopLine; //ֹ߲ͣ
    NET_ITC_LINE  struRedLightLine; //ƴ߲
    NET_ITC_LINE  struCancelLine; //ֱдλȡ
    NET_ITC_LINE struWaitLine; //ֹ߲ͣ
    NET_ITC_LINE struRes[8];
}NET_ITC_VIOLATION_DETECT_LINE, *LPNET_ITC_VIOLATION_DETECT_LINE;

//˴Ʋ
typedef struct tagNET_ITC_REDLIGHT_PEDESTRIAN_PARAM
{
    BYTE byEnable;    //ʹ
    BYTE bySnapNumTimes; //ץ1-3Ĭ3
    BYTE byPedesDir; //˷0~1~2~˫
    BYTE byDelayTime; //ʱʱ1-5s
    BYTE byStackTargetEnble;//Ŀ򣨼ץĵһͼƬϿסƵˣ0~ӣ1~
    BYTE byCalibRecogCtrl;//궨ƣ0~Ƴ궨1~ӱ궨
    BYTE byRes1[2];
    NET_ITC_TRAFFIC_LIGHT_PARAM struTrafficLight; //ͨźŵƲ
    NET_ITC_LINE struStopLine;//ֹͣ
    NET_ITC_POLYGON struCalibRecog[MAX_CALIB_RECOG_NUM/*2*/];//궨
    BYTE byRes[440];
}NET_ITC_REDLIGHT_PEDESTRIAN_PARAM,
*LPNET_ITC_REDLIGHT_PEDESTRIAN_PARAM;

typedef struct tagNET_ITC_POST_MOBILE_PARAM
{
    BYTE  byEnable;    
    BYTE  bySceneMode;//ģʽ 0-ٹ· 1-е·
    /*ץ
    bit0-,bit1-ռ,bit2-ѹӲ·
    */
    WORD  wExpressWayCapType;//ٹ·
    /*ץ
    bit0-,bit1-ռ,bit2-ռרó
    */
    WORD  wUrbanRoadCapType;//е·
    BYTE  byCapNum;//ץ [2,3]
    BYTE  byRecordEnable;//Υ¼ʹ 0-رգ1-
    DWORD dwPreRecordTime;//¼Ԥ¼ʱ(s)
    DWORD dwOverRecordTime;//¼ʱʱ(s)
    NET_ITC_LANE_LOGIC_PARAM struLane;   //
    NET_ITC_POLYGON struPolygon[MAX_MOBILE_POLYGON_NUM/*3*/]; //ʶ
    NET_ITC_VIOLATION_DETECT_LINE struLine[MAX_MOBILE_DETECTLINE_NUM/*3*/]; //Υ
    NET_ITC_LINE struLaneBoundaryLine;        //߽ߣұ߳ҳߣ
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_INTERVAL_PARAM struInterval;//ץļ20byte
    BYTE  byRes[256];
}NET_ITC_POST_MOBILE_PARAM,*LPNET_ITC_POST_MOBILE_PARAM;

typedef union tagNET_ITC_TRIGGER_PARAM_UNION
{
    DWORD  uLen[1070];            //
    NET_ITC_POST_IOSPEED_PARAM      struIOSpeed;    //ڣIOٲ 
    NET_ITC_POST_SINGLEIO_PARAM     struSingleIO;   //ڣIO
    NET_ITC_POST_RS485_PARAM        struPostRs485;  //ڣRS485
    NET_ITC_POST_RS485_RADAR_PARAM  struPostRadar;  //ڣRS485״
    NET_ITC_POST_VTCOIL_PARAM       struVtCoil;     //ڣȦ
    NET_ITC_POST_HVT_PARAM          struHvt;        //ڣпڲ
    NET_ITC_EPOLICE_IOTL_PARAM      struIOTL;        //羯IO̵Ʋ
    NET_ITC_EPOLICE_RS485_PARAM     struEpoliceRs485; //羯RS485
    NET_ITC_EPOLICE_RS485_PARAM     struPERs485;    //ʽ羯RS485
    NET_ITC_POST_MPR_PARAM          struPostMpr;    //֡ⴥMPR
    NET_DVR_VIA_VTCOIL_PARAM        struViaVtCoil;  //(VIA)Ƶ
    NET_ITC_POST_IMT_PARAM          struPostImt;//ǻۼش
    NET_ITC_POST_PRS_PARAM          struPostPrs;//Ƶⴥ
    NET_IPC_POST_HVT_PARAM          struIpcHvt;//(IPC) пڲ
    NET_ITC_POST_HVT_PARAM_V50      struHvtV50;  /*ڣпڲV50*/
    NET_ITC_POST_MOBILE_PARAM       struPostMobile;// ƶͨģʽ
    NET_ITC_NOCOMITY_PEDESTRIAN_PARAM struNoComityPed;//˲
    NET_ITC_REDLIGHT_PEDESTRIAN_PARAM struRedLightPed;//˴Ʋ
}NET_ITC_TRIGGER_PARAM_UNION, *LPNET_ITC_TRIGGER_PARAM_UNION;

//ṹ
typedef struct tagNET_ITC_SINGLE_TRIGGERCFG
{
    BYTE  byEnable;    //Ƿøôģʽ0-1-
    BYTE  byRes1[3];
    DWORD dwTriggerType; //ͣITC_TRIGGERMODE_TYPE
    NET_ITC_TRIGGER_PARAM_UNION uTriggerParam; //
    BYTE  byRes[64];
}NET_ITC_SINGLE_TRIGGERCFG, *LPNET_ITC_SINGLE_TRIGGERCFG;

//ṹ
typedef struct tagNET_ITC_TRIGGERCFG
{
    DWORD   dwSize;            //ṹ
    NET_ITC_SINGLE_TRIGGERCFG  struTriggerParam;  //
    BYTE    byRes[32];
}NET_ITC_TRIGGERCFG, *LPNET_ITC_TRIGGERCFG;


//Υͺ궨
typedef enum _ITC_VIOLATION_DETECT_TYPE_
{
    ITC_VIOLATION_POST = 0x01, //ץ
        ITC_VIOLATION_DRIVELINE = 0x02,//ѹץ
        ITC_VIOLATION_REVERSE = 0x04,//ץ
        ITC_VIOLATION_REDLIGHT = 0x08,//ץ
        ITC_VIOLATION_DIRECTION = 0x10,//ʻץ
        ITC_VIOLATION_INTERSECTION_CONGEST = 0x20,//·ץ
        ITC_VIOLATION_NONDRIVEWAY = 0x40,  //ռץ
        ITC_VIOLATION_CHANGELANE = 0x80, //Υ
        ITC_VIOLATION_BAN = 0x100, //Υ
        ITC_VIOLATION_INTERSECTION_PARK=0x200,//Խ
        ITC_VIOLATION_GREEN_PARK=0x400,//̵ͣ
        ITC_VIOLATION_HIGH_SPEED = 0x800, /**/
        ITC_VIOLATION_LOW_SPEED = 0x1000, /**/
        ITC_VIOLATION_EMERGENCY = 0x2000, /*ռӦ*/
        ITC_VIOLATION_TURN_AROUND = 0x8000,/*Υͷ*/
        ITC_VIOLATION_CONGESTION = 0x10000 /*ӵ*/
}ITC_VIOLATION_DETECT_TYPE;


//Υṹ
typedef struct tagNET_ITC_VIOLATION_DETECT_PARAM
{
    DWORD dwVioDetectType; //Υ, λʾ, ITC_VIOLATION_DETECT_TYPE ,0-,1-
    BYTE byDriveLineSnapTimes; //ѹץ,2-3
    BYTE byReverseSnapTimes; //ץ,2-3
    WORD wStayTime; //ռͣʱ䣨ʱץģλs
    BYTE byNonDriveSnapTimes;//ռץ2-3
    BYTE byChangeLaneTimes;//Υץ 2-3
    BYTE bybanTimes;//Υץ2-3
    BYTE byDriveLineSnapSen;// ѹ(0~100)(3.7Ver)
    WORD wSnapPosFixPixel; //2,3ץλСƫ(ΥźŵʱЧ)λأ Ľ
    BYTE bySpeedTimes;//Υץ2-3(3.8Ver)
    BYTE byTurnAroundEnable;//Υµͷʹ 0~ر 1~
    BYTE byThirdPlateRecogTime;//ʶʱ 0~180s
    BYTE byPostSnapTimes;//ץ,1-2
    BYTE byRes1[18];
    WORD wStopLineDis;  //羯2ΥͼƬֹͣߵ̾룬[0,300]λ()
    BYTE byRes[14];
}NET_ITC_VIOLATION_DETECT_PARAM, *LPNET_ITC_VIOLATION_DETECT_PARAM;

//Ͷ
typedef enum _ITC_RELA_LANE_DIRECTION_TYPE_
{
    ITC_RELA_LANE_DIRECTION_UNKNOW      = 0,   //
        ITC_RELA_LANE_EAST_WEST               = 1,    //Ӷ
        ITC_RELA_LANE_WEST_EAST               = 2,    //
        ITC_RELA_LANE_SOUTH_NORTH            = 3,    //
        ITC_RELA_LANE_NORTH_SOUTH            = 4,    //ӱ
        ITC_RELA_LANE_EASTSOUTH_WESTNORTH  = 5,    //Ӷ
        ITC_RELA_LANE_WESTNORTH_EASTSOUTH  = 6,    //
        ITC_RELA_LANE_EASTNORTH_WESTSOUTH  = 7,    //Ӷ
        ITC_RELA_LANE_WESTSOUTH_EASTNORTH  = 8     //򶫱
} ITC_RELA_LANE_DIRECTION_TYPE;


//;Ͷ
typedef enum _ITC_LANE_USEAGE_TYPE_
{
    ITC_LANE_USEAGE_UNKNOW     =  0,   //δ֪
        ITC_LANE_CARRIAGEWAY  = 1,  //
        ITC_LANE_BUS      = 2,  //רõ
        ITC_LANE_FAST  = 3,  //쳵
        ITC_LANE_SLOW  = 4,  //
        ITC_LANE_MOTOR     = 5,   //Ħг
        ITC_LANE_NONMOTOR  = 6,  //ǻ
        ITC_LANE_REVERSE_LANE = 7, //򳵵
        ITC_LANE_BAN_TRUCKS  = 8, // ֹ
        ITC_LANE_MIX = 9, //ϳ
        ITC_LANE_EMERGENCY = 10, //Ӧ
        ITC_LANE_BAN_LEFT  = 11, // 󳵵
        ITC_LANE_BAN_RIGHT  = 12 // ҳ
}ITC_LANE_USEAGE_TYPE;

//Ͷ
typedef enum _ITC_LANE_DIRECTION_TYPE_
{
    ITC_LANE_DIRECTION_UNKNOW     =  0,   //δ֪
        ITC_LANE_LEFT      = 1,  //ת
        ITC_LANE_STRAIGHT  = 2,  //ֱ
        ITC_LANE_LEFT_STRAIGHT = 3, //ת+ֱ
        ITC_LANE_RIGHT  = 4,  //ת
        ITC_LANE_LEFT_RIGHT = 5, //ת+ת
        ITC_LANE_RIGHT_STRAIGHT = 6, //ת+ֱ
        ITC_LANE_LEFT_RIGHT_STRAIGHT = 7, //ת+ת+ֱ
        ITC_LANE_LEFT_WAIT  =  9,  //ת
        ITC_LANE_STRAIGHT_WAIT = 10, //ֱд
        ITC_LANE_FORWARD = 11, //ʻ
        ITC_LANE_BACKWARD = 12, //ʻ
        ITC_LANE_BOTHWAY = 13, //˫ʻ
        ITC_LANE_STRAIGHT_WAIT_RIGHT = 14 //ֱд + ת
}ITC_LANE_DIRECTION_TYPE; 

//ʻͶ 
typedef enum _ITC_LANE_CAR_DRIVE_DIRECT_
{
    ITC_LANE_DRIVE_UNKNOW        = 0, //δ֪
        ITC_LANE_DRIVE_UP_TO_DOWN    = 1, //ʻ()
        ITC_LANE_DRIVE_DOWN_TO_UP    = 2  //ʻ()        
}ITC_LANE_CAR_DRIVE_DIRECT;

//Ͷ
typedef enum _ITC_LINE_TYPE_
{
    ITC_LINT_UNKNOW     =  0,   //δ֪
        ITC_LINE_WHITE      = 1,  //İʵ
        ITC_LINE_STOP       = 2, //ֹͣ
        ITC_LINE_SINGLE_YELLOW = 3, //
        ITC_LINE_DOUBLE_YELLOW = 4, //˫
        ITC_LINE_GUARD_RAIL = 5, //л
        ITC_LINE_NO_CROSS = 6, //޷Խĳ
        ITC_LINE_DOTTED = 7 //
}ITC_LINE_TYPE;


//Ƶ羯ṹ
typedef struct tagNET_ITC_LANE_VIDEO_EPOLICE_PARAM
{
    BYTE byLaneNO; //ĳ
    BYTE bySensitivity; //Ȧȣ[1,100]
    BYTE byEnableRadar;//״0-ã1-
    //ͣοITC_RELA_LANE_DIRECTION_TYPE
    //òΪŶӦȷΨһԡ
    BYTE byRelaLaneDirectionType;
    NET_ITC_LANE_LOGIC_PARAM struLane; //
    NET_ITC_VIOLATION_DETECT_PARAM struVioDetect; //Υ
    NET_ITC_VIOLATION_DETECT_LINE struLine; //Υ
    NET_ITC_POLYGON struPlateRecog; //ʶ
    BYTE byRecordEnable;//¼־0-¼1-¼
    BYTE byRecordType;//¼ͣ0-Ԥ¼1-ʱ¼
    BYTE byPreRecordTime;//¼ƬԤ¼ʱ䣨Ĭ0λ
    BYTE byRecordDelayTime;//¼Ƭʱʱ䣨Ĭ0λ
    BYTE byRecordTimeOut;//¼ʱʱ䣨룩
    BYTE byCarSpeedLimit; //ֵλkm/h
    BYTE byCarSignSpeed;//־٣λkm/h
    BYTE bySnapPicPreRecord; //ץͼƬԤ¼ʱ㣻0-ĬֵڶͼƬ1-һͼƬ2-ڶͼƬ3-ͼƬ
    NET_ITC_INTERVAL_PARAM struInterval;//ץļ20byte
    BYTE byRes[36];
}NET_ITC_LANE_VIDEO_EPOLICE_PARAM, *LPNET_ITC_LANE_VIDEO_EPOLICE_PARAM;

//Ƶ羯ṹ
typedef struct tagNET_ITC_VIDEO_EPOLICE_PARAM
{
    BYTE byEnable;    //Ƿã0-ã1-
    BYTE byLaneNum; //ʶĳ
    BYTE byLogicJudge;//Υж߼ֵΪ0-1-
    BYTE byRes1;
    NET_ITC_PLATE_RECOG_PARAM struPlateRecog; //ʶ
    NET_ITC_TRAFFIC_LIGHT_PARAM struTrafficLight; //ͨźŵƲ
    NET_ITC_LANE_VIDEO_EPOLICE_PARAM struLaneParam[MAX_ITC_LANE_NUM]; //
    NET_ITC_LINE  struLaneBoundaryLine; //߽ߣұ߳ı߽ߣ
    NET_ITC_LINE  struLeftLine; //תֽ
    NET_ITC_LINE  struRightLine; //תֽ
    NET_ITC_LINE  struTopZebraLine; //ϲ
    NET_ITC_LINE  struBotZebraLine; //²
    BYTE  byRes[32];
}NET_ITC_VIDEO_EPOLICE_PARAM, *LPNET_ITC_VIDEO_EPOLICE_PARAM;

typedef union tagNET_ITC_VIDEO_TRIGGER_PARAM_UNION
{
    DWORD  uLen[1150];            
    NET_ITC_VIDEO_EPOLICE_PARAM struVideoEP; //Ƶ羯
}NET_ITC_VIDEO_TRIGGER_PARAM_UNION, *LPNET_ITC_VIDEO_TRIGGER_PARAM_UNION;

typedef struct tagNET_ITC_VIDEO_TRIGGER_PARAM
{
    DWORD dwSize;
    DWORD dwMode; //ģʽITC_TRIGGERMODE_TYPE
    NET_ITC_VIDEO_TRIGGER_PARAM_UNION uVideoTrigger; //ģʽ
    BYTE  byRes[32];
}NET_ITC_VIDEO_TRIGGER_PARAM, *LPNET_ITC_VIDEO_TRIGGER_PARAM;

typedef struct tagNET_DVR_STATUS_DETECTCFG
{
    DWORD  dwSize;            //ṹ
    BYTE   byEnableTrigIODetect; //IO״̬⣬1-ǣ0-
    BYTE   byEnableFlashOutDetect; //ͬ״̬⣬1-ǣ0-
    BYTE   byEnableRS485Detect; //RS485״̬⣬1-ǣ0-
    BYTE   byEnableTrafficLightDetect;//ͨ״̬⣬1-ǣ0-
    BYTE   byRes[28];
}NET_DVR_STATUS_DETECTCFG, *LPNET_DVR_STATUS_DETECTCFG;

typedef enum _ITC_STATUS_DETECT_TYPE_
{
    ITC_STATUS_DETECT_NULL = 0,        //δ֪
        ITC_STATUS_DETECT_TRIGGERIO,    //IO
        ITC_STATUS_DETECT_FLASHOUT,     //ͬ
        ITC_STATUS_DETECT_RS485, //RS485
        ITC_STATUS_DETECT_TRIGGERTYPE, //ͣ
        ITC_STATUS_DETECT_TRAFFICLIGHT_COLOR,  //ͨƣɫ
        ITC_STATUS_DETECT_TRAFFICLIGHT_TURN  //ͨƣת
}ITC_STATUS_DETECT_TYPE;

typedef struct tagNET_ITC_TRIGGERIO_INFO
{
    BYTE byTriggerIOIndex[MAX_IOIN_NUM]; //IO
    BYTE byRes[40]; 
}NET_ITC_TRIGGERIO_INFO, *LPNET_ITC_TRIGGERIO_INFO;

typedef struct tagNET_ITC_FLASHOUT_INFO
{
    BYTE byFlashOutIndex[MAX_IOOUT_K_NUM]; //ͬ
    BYTE byRes[40]; 
}NET_ITC_FLASHOUT_INFO, *LPNET_ITC_FLASHOUT_INFO;

typedef struct tagNET_ITC_SERIAL_CHECKINFO
{
    BYTE bySerialIndex[MAX_ITC_SERIALCHECK_NUM]; //485У0-Ч,1-Ч, bySerialIndex[0]ʾȷͷ, bySerialIndex[1]ʾȷβ
    BYTE byRes[40]; 
}NET_ITC_SERIAL_CHECKINFO, *LPNET_ITC_SERIAL_CHECKINFO;

typedef struct tagNET_ITC_TRIGGERTYPE_INFO
{
    BYTE byTrigTypeIndex; //ֵ
    BYTE byRes[47]; 
}NET_ITC_TRIGGERTYPE_INFO, *LPNET_ITC_TRIGGERTYPE_INFO;

//Ƶ羯
typedef struct tagNET_ITC_TRAFFIC_LIGHT_COLOR
{
    BYTE  byLeftLight;//תƣ0 ʾЧ1Ϊ 2Ϊ̵ 3 Ƶ 4ƶ
    BYTE  byRightLight; //תƣ0 ʾЧ1Ϊ 2Ϊ̵ 3 Ƶ 4ƶ
    BYTE  byStraightLight; //ֱеƣ0 ʾЧ1Ϊ 2Ϊ̵ 3 Ƶ 4ƶ
    BYTE  byRes[45];
}NET_ITC_TRAFFIC_LIGHT_COLOR, *LPNET_ITC_TRAFFIC_LIGHT_COLOR;

//Ƶ羯
typedef struct tagNET_ITC_TRAFFIC_LIGHT_TURN
{
    BYTE byLightType[MAX_ITC_LANE_NUM];// 0 ʾЧ1Ϊ 2Ϊ̵ 3 Ƶ 4ƶ
    BYTE byRes[42];
} NET_ITC_TRAFFIC_LIGHT_TURN, *LPNET_ITC_TRAFFIC_LIGHT_TURN;

typedef union tagNET_ITC_STATUS_UNION
{
    BYTE   uLen[48];            //
    NET_ITC_TRIGGERIO_INFO struTrigIO; //IOں
    NET_ITC_FLASHOUT_INFO struFlashOut; //ͬ
    NET_ITC_SERIAL_CHECKINFO struSerial;  //
    NET_ITC_TRIGGERTYPE_INFO struTrigType; //ͣ
    NET_ITC_TRAFFIC_LIGHT_COLOR struTrafficLightColor; //ͨƣɫӦITC_STATUS_DETECT_TRAFFICLIGHT_COLOR
    NET_ITC_TRAFFIC_LIGHT_TURN struTrafficLightTurn;//ͨƣת򣩶ӦITC_STATUS_DETECT_TRAFFICLIGHT_TURN
}NET_ITC_STATUS_UNION, *LPNET_ITC_STATUS_UNION;

typedef struct tagNET_ITC_STATUS_DETECT_RESULT
{
    ITC_STATUS_DETECT_TYPE dwStatusType;//״̬ͣITC_STATUS_DETECT_TYPE
    NET_ITC_STATUS_UNION uStatusParam; //״̬
    DWORD dwHoldTime; //ʱ䣨λms
    BYTE byRes[32];
}NET_ITC_STATUS_DETECT_RESULT, *LPNET_ITC_STATUS_DETECT_RESULT;

typedef struct tagNET_DVR_SETUPALARM_PARAM
{
    DWORD dwSize;
    BYTE  byLevel; //ȼ0-һȼߣ1-ȼУ2-ȼͣ
    BYTE  byAlarmInfoType; //ϴϢͣץĻ֧֣0-ϱϢNET_DVR_PLATE_RESULT1-±Ϣ(NET_ITS_PLATE_RESULT)2012-9-28
    BYTE  byRetAlarmTypeV40; //0--NET_DVR_ALARMINFO_V30NET_DVR_ALARMINFO, 1--豸֧NET_DVR_ALARMINFO_V40򷵻NET_DVR_ALARMINFO_V40֧򷵻NET_DVR_ALARMINFO_V30NET_DVR_ALARMINFO
    BYTE  byRetDevInfoVersion; //CVRϴϢصṹ汾 0-COMM_ALARM_DEVICE 1-COMM_ALARM_DEVICE_V40
    BYTE  byRetVQDAlarmType; //VQDϴͣ0-ϴNET_DVR_VQD_DIAGNOSE_INFO1-ϴNET_DVR_VQD_ALARM
    //1-ʾⱨչ(INTER_FACE_DETECTION),0-ʾԭֽ֧ṹ(INTER_FACESNAP_RESULT)
    BYTE  byFaceAlarmDetection;
    BYTE  bySupport; //Bit0- ʾǷϴͼƬ: 0-ϴ1-ϴ
    // 
    //bit0-Ƽ⣨IPC 0-1-
    //bit1-ͳƣIPC  0-1-
    //bit2-ȶͼͳƣIPC 0-1-
    BYTE  byBrokenNetHttp;
    WORD  wTaskNo;    //  (ϴNET_DVR_VEHICLE_RECOG_RESULTеֶdwTaskNoӦ ͬʱ ·ṹ NET_DVR_VEHICLE_RECOG_CONDеֶdwTaskNoӦ)
    BYTE  byRes1[5];
    BYTE  byCustomCtrl;//Bit0- ʾָ֧ʻͼϴ: 0-ϴ,1-ϴ,(עֻڹ˾ڲ8600/8200ƽ̨)
}NET_DVR_SETUPALARM_PARAM, *LPNET_DVR_SETUPALARM_PARAM;

typedef struct tagNET_ITC_VIDEO_TRIGGER_COND
{
    DWORD dwSize;
    DWORD dwChannel;
    DWORD dwTriggerMode; //ƵģʽͣITC_TRIGGERMODE_TYPE
    BYTE byRes[16];
}NET_ITC_VIDEO_TRIGGER_COND, *LPNET_ITC_VIDEO_TRIGGER_COND;

//ṹ
typedef struct tagNET_ITC_FTP_TYPE_COND
{
    DWORD dwChannel;//ͨ
    BYTE    byWorkMode;  // 0-FTP1(FTP)1-FTP2(FTP)
    BYTE    byRes[7];
}NET_ITC_FTP_TYPE_COND, *LPNET_ITC_FTP_TYPE_COND;

//ýṹ
typedef struct tagNET_ITC_FTP_CFG
{
    DWORD            dwSize;
    BYTE                byEnable;            /*Ƿftpϴܣ0-1-*/
    BYTE                 byAddressType;   //0-ʵipv4 ipv6ַ 1-
    // unionServerʹʵʵַ
    WORD                wFTPPort;            /*˿*/
    union
    {
        struct
        {
            BYTE            szDomain[MAX_DOMAIN_NAME];//ַ 
            BYTE            byRes1[80];
        }struDomain;
        struct
        {
            NET_DVR_IPADDR     struIp;/*IPַ*/        //IPv4 IPv6ַ, 144ֽ
        } struAddrIP;
    }unionServer;  //ʹṹͨbyAddressTypeֶαʾIPַ 64    
    BYTE                szUserName[NAME_LEN];        /*û*/
    BYTE                szPassWORD[PASSWD_LEN];        /**/
    BYTE                byRes4;  // 0-FTP1(FTP)1-FTP2(FTP)
                                 BYTE                byDirLevel;    /*0 = ʹĿ¼ṹֱӱڸĿ¼,
                                                                1 = ʹ1Ŀ¼,2=ʹ2Ŀ¼,
                                 3 = ʹ3Ŀ¼,4=ʹ4Ŀ¼*/                    
                                 BYTE                 byIsFilterCarPic;/*СͼǷϴ0-ϴ,1-ϴ*/
                                 BYTE                    byUploadDataType;//0-ȫ1-ڣ2-Υ (FTPʱĬѡȫ˫FTPʱֿ֧ڣΥµѡ)
                                 NET_DVR_PICTURE_NAME     struPicNameRule;/* ͼƬ */
                                                                        BYTE                byTopDirMode; /*һĿ¼, 0x1 = ʹ豸,
                                                                                                          0x2 = ʹ豸,0x3 =ʹ豸ipַ
                                                                                                          0x4=ʹü,0x5=ʹʱ(),  
                                                                                                          0x6=ʹʱ(),0x7=Υ,0x8=,0x9=ص,
                                                                        0xa=ͨ,0xb=ͨ,0xc=0xff=Զ*/
                                                                        BYTE                bySubDirMode; /*Ŀ¼, 0x1 =ʹ豸,
                                                                                                          0x2 = ʹ豸,0x3 =ʹ豸ipַ
                                                                                                          0x4=ʹü,0x5=ʹʱ(),  
                                                                                                          0x6=ʹʱ(),0x7=Υ,0x8=,0x9=ص,
                                                                        0xa=ͨ,0xb=ͨ,0xc=0xff=Զ*/
                                                                        BYTE                byThreeDirMode; /*Ŀ¼, 0x1 = ʹ豸,
                                                                                                            0x2 = ʹ豸,0x3 =ʹ豸ipַ
                                                                                                            0x4=ʹü,0x5=ʹʱ(),  
                                                                                                            0x6=ʹʱ(),0x7=Υ,0x8=,0x9=ص,
                                                                        0xa=ͨ,0xb=ͨ,0xc=0xff=Զ*/
                                                                        BYTE                byFourDirMode; /*ļĿ¼, 0x1 =ʹ豸,
                                                                                                           0x2 = ʹ豸,0x3 =ʹ豸ipַ
                                                                                                           0x4=ʹü,0x5=ʹʱ(),  
                                                                                                           0x6=ʹʱ(),0x7=Υ,0x8=,0x9=ص,
                                                                        0xa=ͨ,0xb=ͨ,0xc=0xff=Զ*/
                                                                        /*ͼƬԶ PICNAME_ITEM_CUSTOM ʱ Ч*/
                                                                        BYTE                szPicNameCustom[MAX_CUSTOMDIR_LEN];// (3.7Ver Ч)
                                                                        BYTE                szTopCustomDir[MAX_CUSTOMDIR_LEN]; /*ԶһĿ¼*/  
                                                                        BYTE                szSubCustomDir[MAX_CUSTOMDIR_LEN];/*ԶĿ¼*/
                                                                        BYTE                szThreeCustomDir[MAX_CUSTOMDIR_LEN];    /*ԶĿ¼*/
                                                                        BYTE                szFourCustomDir[MAX_CUSTOMDIR_LEN];    /*ԶļĿ¼*/
                                                                        BYTE                 byRes3[900]; //12չԤ ֧͸
}NET_ITC_FTP_CFG, *LPNET_ITC_FTP_CFG;

typedef struct tagNET_DVR_LATITUDE_PARAM
{
    BYTE byDegree;//[0,179]
    BYTE byMinute;//[0,59]
    BYTE bySec;//[0,59]
    BYTE byRes;
}NET_DVR_LATITUDE_PARAM, *LPNET_DVR_LATITUDE_PARAM;

typedef struct tagNET_DVR_LONGITUDE_PARAM
{
    BYTE byDegree;//[0,179]
    BYTE byMinute;//[0,59]
    BYTE bySec;//[0,59]
    BYTE byRes;
}NET_DVR_LONGITUDE_PARAM, *LPNET_DVR_LONGITUDE_PARAM;

typedef struct tagNET_DVR_GPS_DATACFG
{
    DWORD     dwSize;
    BYTE byGpsDataMode;//GPSݻȡ 0-Զ1-ֶ
    BYTE byLongitudeType;// 0-1-
    BYTE byLatitudeType;//γ 0-γ1-γ
    BYTE byRes;
    NET_DVR_LATITUDE_PARAM    struLatitude;     /*γ*/
    NET_DVR_LONGITUDE_PARAM    struLongitude; /**/
    BYTE byRes1[128];
}NET_DVR_GPS_DATACFG,*LPNET_DVR_GPS_DATACFG;

typedef enum _VCA_DATABASE_TYPE_
{
    DATABASE_NULL = 0, //δ֪
        DATABASE_SNAP,    //ץݿ
        DATABASE_FACE    //ݿ
}VCA_DATABASE_TYPE;

typedef struct tagNET_VCA_DATABASE_PARAM
{
    DWORD dwSize;
    DWORD dwDataBaseID; //ݿID豸ɣʱЧ޸ĺɾʱЧ
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    BYTE byDataBaseName[NAME_LEN]; //ݿ
    BYTE byAttribute[64]; //ݿ
    BYTE byRes[20];
}NET_VCA_DATABASE_PARAM, *LPNET_VCA_DATABASE_PARAM;

typedef struct tagNET_VCA_FIND_DATABASE_COND
{
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    BYTE byRes[12]; //
}NET_VCA_FIND_DATABASE_COND, *LPNET_VCA_FIND_DATABASE_COND;

typedef struct tagNET_VCA_DELETE_DATABASE_COND
{
    DWORD dwSize;
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    DWORD dwDataBaseID; //ݿID
    BYTE byRes[64]; //
}NET_VCA_DELETE_DATABASE_COND, *LPNET_VCA_DELETE_DATABASE_COND;

typedef struct tagNET_VCA_INQUIRE_SNAPDB_COND
{
    DWORD dwChannel;//ͨ
    NET_DVR_TIME struStartTime;//ʼʱ
    NET_DVR_TIME struStopTime;//ʱ
    BYTE bySex; //Ա0-ã1-У2-Ů
    BYTE byRes1[3]; //
    BYTE byStartBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ʼ£磺201106
    BYTE byEndBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ֹ£201106
    BYTE byAttribute1[NAME_LEN]; //1
    BYTE byAttribute2[NAME_LEN]; //2
    BYTE byRes[12]; //
}NET_VCA_INQUIRE_SNAPDB_COND, *LPNET_VCA_INQUIRE_SNAPDB_COND;

typedef struct tagNET_VCA_INQUIRE_SNAPRECORD_RESULT
{ 
    DWORD dwSize; //ṹС
    DWORD dwDataBaseID;  //ݿID
    DWORD dwRecordID; //¼ID
    NET_DVR_TIME struSnapTime;  //ץʱ
    BYTE bySex; //Ա0-ã1-У2-Ů
    BYTE byRes1[3]; //
    BYTE byStartBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ʼ£磺201106
    BYTE byEndBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ֹ£201106
    BYTE byAttribute1[NAME_LEN]; //1
    BYTE byAttribute2[NAME_LEN]; //2
    DWORD dwFacePicID; //ͼID
    DWORD dwFacePicLen;  //ͼݳ
    BYTE byRes[80];  //
    BYTE *pFacePic;    //ͼ
}NET_VCA_INQUIRE_SNAPRECORD_RESULT, *LPNET_VCA_INQUIRE_SNAPRECORD_RESULT;

typedef union tagNET_VCA_DELETE_SNAPRECORD_COND_UNION
{ 
    NET_VCA_INQUIRE_SNAPDB_COND struAttribute;  //ԱϢɾ
    DWORD dwRecordID; //¼IDɾ
}NET_VCA_DELETE_SNAPRECORD_COND_UNION, *LPNET_VCA_DELETE_SNAPRECORD_COND_UNION;

typedef enum _VCA_DELETE_RECORD_TYPE_
{
    DELETE_RECORD_SINGLE = 0, //ɾ
        DELETE_RECORD_BATCH    //ɾ
}VCA_DELETE_RECORD_TYPE;

typedef struct tagNET_VCA_DELETE_SNAPRECORD_COND
{ 
    VCA_DELETE_RECORD_TYPE dwDeleteType; //ɾ¼
    NET_VCA_DELETE_SNAPRECORD_COND_UNION uDeleteCond;  //ɾ
    BYTE  byRes[40]; //
}NET_VCA_DELETE_SNAPRECORD_COND, *LPNET_VCA_DELETE_SNAPRECORD_COND;

typedef enum _VCA_SEARCH_DATABASE_TYPE_
{
    VCA_NORMAL_SEARCH_DATABASE  = 0x00000000,   //ͨ
        VCA_ADVANCE_SEARCH_DATABASE  = 0x00000001  //߼
}VCA_SEARCH_DATABASE_TYPE;

typedef struct tagNET_VCA_ADVANCE_SEARCH_DATABASE_COND
{
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    DWORD dwDataBaseID; //ݿID
    DWORD dwFacePicID; //ͼƬID
    BYTE byRes[36];
}NET_VCA_ADVANCE_SEARCH_DATABASE_COND, *LPNET_VCA_ADVANCE_SEARCH_DATABASE_COND;

typedef union tagNET_VCA_SEARCH_DATABASE_COND_UNION
{
    DWORD uLen[25];
    NET_VCA_REGISTER_PIC struNormalFind; //ͨ
    NET_VCA_ADVANCE_SEARCH_DATABASE_COND struAdvanceFind; //߼
}NET_VCA_SEARCH_DATABASE_COND_UNION, *LPNET_VCA_SEARCH_DATABASE_COND_UNION;

typedef struct tagNET_VCA_SEARCH_DATABASE_PARAM
{
    DWORD dwSearchType; //ͣVCA_SEARCH_DATABASE_TYPE
    NET_VCA_SEARCH_DATABASE_COND_UNION uSearchCond; //
    BYTE byRes[16];
}NET_VCA_SEARCH_DATABASE_PARAM, *LPNET_VCA_SEARCH_DATABASE_PARAM;

typedef struct tagNET_VCA_SEARCH_SNAPDB_COND
{ 
    DWORD dwChannel; //ͨ
    DWORD dwDataBaseID; //ݿID
    NET_DVR_TIME struStartTime;//ʼʱ
    NET_DVR_TIME struStopTime;//ʱ
    BYTE bySex; //Ա0-ã1-У2-Ů
    BYTE byRes1[3]; //
    BYTE byStartBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ʼ£磺201106
    BYTE byEndBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ֹ£201106
    BYTE byAttribute1[NAME_LEN]; //1
    BYTE byAttribute2[NAME_LEN]; //2
    NET_VCA_SEARCH_DATABASE_PARAM struSearchParam;  //
    DWORD dwMaxSearchNum; //
    WORD wThreshold;  //ֵ0-100
    BYTE  byRes[78]; //
}NET_VCA_SEARCH_SNAPDB_COND, *LPNET_VCA_SEARCH_SNAPDB_COND;

typedef struct tagNET_VCA_SEARCH_SNAPRECORD_RESULT
{ 
    DWORD dwSize; //ṹС
    DWORD dwDataBaseID;  //ݿID
    DWORD dwRecordID; //¼ID
    NET_DVR_TIME struSnapTime;//ץʱ
    BYTE bySex; //Ա0-ã1-У2-Ů
    BYTE byRes1[3]; //
    BYTE byStartBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ʼ£磺201106
    BYTE byEndBirthDate[MAX_HUMAN_BIRTHDATE_LEN]; //ֹ£201106
    BYTE byAttribute1[NAME_LEN]; //1
    BYTE byAttribute2[NAME_LEN]; //2
    float fSimilarity; //ƶȣ[0.001,1]
    DWORD dwFacePicID; //ͼID
    DWORD dwFacePicLen;  //ͼݳ
    BYTE byRes[80];  //
    BYTE *pFacePic;    //ͼ
}NET_VCA_SEARCH_SNAPRECORD_RESULT, *LPNET_VCA_SEARCH_SNAPRECORD_RESULT;

typedef struct tagNET_VCA_DATARECORD_INFO
{ 
    DWORD dwSize; //ṹС
    DWORD dwRecordID; //¼IDʱЧ޸ʱЧ
    NET_VCA_HUMAN_ATTRIBUTE struAttribute;  //ԱϢ
    NET_VCA_REGISTER_PIC struRegisterPic;  //ԱͼƬϢ
    BYTE  byRemark1[NAME_LEN]; //עϢ1
    BYTE  byRemark2[64]; //עϢ2
    BYTE  byRes[32]; //
}NET_VCA_DATARECORD_INFO, *LPNET_VCA_DATARECORD_INFO;

typedef struct tagNET_VCA_FAST_DATARECORD_INFO
{ 
    DWORD dwSize; //ṹС
    NET_VCA_HUMAN_ATTRIBUTE struAttribute;  //ԱϢ
    BYTE  byRemark1[NAME_LEN]; //עϢ1
    BYTE  byRemark2[64]; //עϢ2
    DWORD dwImageLen;  //ͼݳ
    BYTE  byRes[80];  //
    BYTE *pImage;    //ͼ
}NET_VCA_FAST_DATARECORD_INFO, *LPNET_VCA_FAST_DATARECORD_INFO;

typedef struct tagNET_VCA_INQUIRE_DATARECORD_RESULT
{ 
    DWORD dwSize; //ṹС
    DWORD dwDataBaseID;  //ݿID
    DWORD dwRecordID; //¼ID
    NET_VCA_HUMAN_ATTRIBUTE struAttribute;  //ԱϢ
    BYTE  byRemark1[NAME_LEN]; //עϢ1
    BYTE  byRemark2[64]; //עϢ2
    DWORD dwFacePicID; //ͼID
    DWORD dwFacePicLen;  //ͼݳ
    BYTE byRes[80];  //
    BYTE *pFacePic;    //ͼ
}NET_VCA_INQUIRE_DATARECORD_RESULT, *LPNET_VCA_INQUIRE_DATARECORD_RESULT;

typedef struct tagNET_VCA_SEARCH_DATARECORD_RESULT
{ 
    DWORD dwSize; //ṹС
    DWORD dwDataBaseID;  //ݿID
    DWORD dwRecordID; //¼ID
    NET_VCA_HUMAN_ATTRIBUTE struAttribute;  //ԱϢ
    BYTE  byRemark1[NAME_LEN]; //עϢ1
    BYTE  byRemark2[64]; //עϢ2
    float fSimilarity; //ƶȣ[0.001,1]
    DWORD dwFacePicID; //ͼID
    DWORD dwFacePicLen;  //ͼݳ
    BYTE byRes[80];  //
    BYTE *pFacePic;    //ͼ
}NET_VCA_SEARCH_DATARECORD_RESULT, *LPNET_VCA_SEARCH_DATARECORD_RESULT;

typedef struct tagNET_VCA_DATARECORD_COND
{ 
    DWORD dwDataBaseID; //ݿID
    NET_VCA_HUMANATTRIBUTE_COND struAttribute;  //ԱϢ
    BYTE byRes[80];  //
}NET_VCA_DATARECORD_COND, *LPNET_VCA_DATARECORD_COND;

typedef union tagNET_VCA_DELETE_RECORD_COND_UNION
{ 
    NET_VCA_HUMANATTRIBUTE_COND struAttribute;  //ԱϢɾ
    DWORD dwRecordID; //¼IDɾ
}NET_VCA_DELETE_RECORD_COND_UNION, *LPNET_VCA_DELETE_RECORD_COND_UNION;

typedef struct tagNET_VCA_DELETE_RECORD_COND
{ 
    VCA_DELETE_RECORD_TYPE dwDeleteType; //ɾ¼
    NET_VCA_DELETE_RECORD_COND_UNION uDeleteCond;  //ɾ
    BYTE  byRes[40]; //
}NET_VCA_DELETE_RECORD_COND, *LPNET_VCA_DELETE_RECORD_COND;

typedef struct tagNET_VCA_SEARCH_FACEDB_COND
{ 
    DWORD dwDataBaseID; //ݿID
    NET_VCA_HUMANATTRIBUTE_COND struAttribute;  //ԱϢ
    NET_VCA_SEARCH_DATABASE_PARAM struSearchParam;  //
    DWORD dwMaxSearchNum; //
    WORD wThreshold;  //ֵ0-100
    BYTE  byRes[78]; //
}NET_VCA_SEARCH_FACEDB_COND, *LPNET_VCA_SEARCH_FACEDB_COND;

typedef struct tagNET_VCA_FIND_MATCHPIC_COND
{
    DWORD dwSize;
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    DWORD dwDataBaseID; //ݿID
    DWORD dwRecordID; //¼ID
    BYTE byRes[64]; //
}NET_VCA_FIND_MATCHPIC_COND, *LPNET_VCA_FIND_MATCHPIC_COND;

typedef struct tagNET_VCA_FIND_MATCHPIC_RESULT
{
    DWORD dwSize;
    DWORD dwDataBaseType; //ݿͣVCA_DATABASE_TYPE
    DWORD dwDataBaseID; //ݿID
    DWORD dwRecordID; //¼ID
    DWORD dwPicLen; //ͼƬ
    BYTE byRes[64]; //
    BYTE *pPicBuffer; //ͼƬָ
}NET_VCA_FIND_MATCHPIC_RESULT, *LPNET_VCA_FIND_MATCHPIC_RESULT;

typedef struct tagNET_DVR_REMOTECONTROL_ALARM_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    WORD wDealyTime; //ӳʱ䣬λs
    BYTE  byRes[30]; 
}NET_DVR_REMOTECONTROL_ALARM_PARAM, *LPNET_DVR_REMOTECONTROL_ALARM_PARAM;

typedef struct tagNET_DVR_REMOTECONTROL_STUDY_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    BYTE  byRes[16]; 
}NET_DVR_REMOTECONTROL_STUDY_PARAM, *LPNET_DVR_REMOTECONTROL_STUDY_PARAM;

typedef struct tagNET_DVR_WIRELESS_ALARM_STUDY_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    BYTE  byIndex;  //߱ţ1-8
    BYTE  byRes[15]; 
}NET_DVR_WIRELESS_ALARM_STUDY_PARAM, *LPNET_DVR_WIRELESS_ALARM_STUDY_PARAM;

#define MAX_AUX_ALARM_NUM 8 //
#define MAX_WIRELESS_ALARM_NUM 8 //߱
typedef enum _IPC_AUX_ALARM_TYPE_
{
    IPC_AUXALARM_UNKNOW = 0, //δ֪
        IPC_AUXALARM_PIR = 1, //PIR
        IPC_AUXALARM_WIRELESS = 2,   //߱
        IPC_AUXALARM_CALLHELP = 3  //ȱ
}IPC_AUX_ALARM_TYPE;

typedef struct tagNET_DVR_AUDIO_LIMIT_ALARM_CFG
{    
    DWORD    dwSize;
    BYTE    byEnable;//ʹ
    BYTE    byRes1[3];
    DWORD    dwDecibelLimit; //ֱ澯ֵ
    NET_DVR_HANDLEEXCEPTION_V30    struHandleException;  //쳣ʽ
    BYTE    byRes2[24];
}NET_IPC_AUDIO_LIMIT_ALARM_CFG,*LPNET_IPC_AUDIO_LIMIT_ALARM_CFG;

typedef struct tagNET_DVR_BUTTON_DOWN_ALARM_CFG
{    
    DWORD    dwSize;
    BYTE    byEnable;//ʹ
    BYTE    byRes1[3]; 
    NET_DVR_HANDLEEXCEPTION_V30    struHandleException;  //쳣ʽ
    BYTE    byRes2[24];
}NET_IPC_BUTTON_DOWN_ALARM_CFG,*LPNET_IPC_BUTTON_DOWN_ALARM_CFG;

typedef struct tagNET_IPC_PIR_ALARMCFG
{
    BYTE byAlarmName[NAME_LEN];    /*  */
    BYTE byAlarmHandle;            /* Ƿ 0- 1-*/
    BYTE byRes1[3];            
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */    
    BYTE byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ
    BYTE byRes[64];
}NET_IPC_PIR_ALARMCFG, *LPNET_IPC_PIR_ALARMCFG;

typedef struct tagNET_IPC_PIR_ALARMCFG_EX
{
    BYTE byAlarmName[NAME_LEN];    /*  */
    BYTE byAlarmHandle;            /* Ƿ 0- 1-*/
    BYTE byRes1[3];            
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */    
    BYTE byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];
    BYTE byRes[1464];
}NET_IPC_PIR_ALARMCFG_EX, *LPNET_IPC_PIR_ALARMCFG_EX;

//ȱ
typedef struct tagNET_IPC_CALLHELP_ALARMCFG
{
    BYTE byAlarmHandle;            /* Ƿ 0- 1-*/
    BYTE byRes1[3];            
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */    
    BYTE byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ
    BYTE byRes[64];
}NET_IPC_CALLHELP_ALARMCFG, *LPNET_IPC_CALLHELP_ALARMCFG;

typedef struct tagNET_IPC_SINGLE_WIRELESS_ALARMCFG
{
    BYTE byAlarmName[NAME_LEN];    /*  */
    BYTE byAlarmHandle;            /* Ƿ 0- 1-*/
    BYTE byID; //߱ID1-8
    BYTE byRes1[2];            
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    /* ʽ */
    BYTE byRelRecordChan[MAX_CHANNUM_V30]; //¼ͨ,Ϊ1ʾͨ    
    BYTE byRes[32];
}NET_IPC_SINGLE_WIRELESS_ALARMCFG, *LPNET_IPC_SINGLE_WIRELESS_ALARMCFG;

typedef struct tagNET_IPC_WIRELESS_ALARMCFG
{
    NET_IPC_SINGLE_WIRELESS_ALARMCFG struWirelessAlarm[MAX_WIRELESS_ALARM_NUM]; //߱
    BYTE byRes[32];
}NET_IPC_WIRELESS_ALARMCFG, *LPNET_IPC_WIRELESS_ALARMCFG;

typedef union tagNET_IPC_AUX_ALARMCFG_UNION
{
    DWORD uLen[472];
    NET_IPC_PIR_ALARMCFG_EX struPIRAlarm; //PIR
    NET_IPC_WIRELESS_ALARMCFG struWirelessAlarm; //߱
    NET_IPC_CALLHELP_ALARMCFG struCallHelpAlarm; //ȱ
}NET_IPC_AUX_ALARMCFG_UNION, *LPNET_IPC_AUX_ALARMCFG_UNION;

typedef struct tagNET_IPC_SINGLE_AUX_ALARMCFG
{
    BYTE byAlarmType;       //ͣIPC_AUX_ALARM_TYPE
    BYTE byRes1[3];            
    NET_IPC_AUX_ALARMCFG_UNION uAlarm; //
    BYTE byRes[16];
}NET_IPC_SINGLE_AUX_ALARMCFG, *LPNET_IPC_SINGLE_AUX_ALARMCFG;

typedef struct tagNET_IPC_AUX_ALARMCFG
{
    DWORD dwSize;
    NET_IPC_SINGLE_AUX_ALARMCFG struAlarm[MAX_AUX_ALARM_NUM]; //
    BYTE byRes[64];
}NET_IPC_AUX_ALARMCFG, *LPNET_IPC_AUX_ALARMCFG;

typedef union tagNET_IPC_AUXALARM_UPLOAD_UNION
{
    DWORD uLen[66];
    NET_IPC_PIR_ALARMCFG struPIRAlarm; //PIR
    NET_IPC_SINGLE_WIRELESS_ALARMCFG struWirelessAlarm; //߱
    NET_IPC_CALLHELP_ALARMCFG struCallHelpAlarm; //ȱ
}NET_IPC_AUXALARM_UPLOAD_UNION, *LPNET_IPC_AUXALARM_UPLOAD_UNION;

typedef struct tagNET_IPC_AUXALARM_RESULT
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    BYTE byAlarmType;       //ͣIPC_AUX_ALARM_TYPE
    BYTE byRes1[3];
    NET_IPC_AUXALARM_UPLOAD_UNION struAuxAlarm; //
    BYTE byDeviceID[NAME_LEN];/*豸ID*/
    BYTE byRes[32];
}NET_IPC_AUXALARM_RESULT, *LPNET_IPC_AUXALARM_RESULT;

typedef struct tagNET_DVR_PREVIEW_DISPLAYCFG
{
    DWORD  dwSize;         // ṹС 
    BYTE   byCorrectMode;   //Уģʽ0-У1-оƬУ
    BYTE   byMountType;     //װͣ0-1-棬2-ǽ
    /*
    0-ģʽ1+ȫ+3PTZ (ԭзʵʱģʽһ)
    1-ģʽ2+4PTZ(ԭʵʱģʽһ)
    2-ģʽ3()+()+3PTZ
    3-ģʽ4ȫչ(+)
    4-ģʽ54PTZ
    5-ģʽ6ۣ
    */
    BYTE   byRealTimeOutput;  //ʵʱ0 -ã1- 
    BYTE   byRes[61];
}NET_DVR_PREVIEW_DISPLAYCFG, *LPNET_DVR_PREVIEW_DISPLAYCFG;

typedef struct tagNET_DVR_REMOTECONTROL_PTZ_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    DWORD dwPTZCommand; //PTZ 
    NET_VCA_POINT struVcaPoint; //Ԥ
    DWORD dwSpeed; //ƵٶȣȡֵΧ[0,7]
    DWORD dwStop; //ֹͣʼ0-ʼ1-ֹͣ
    BYTE  byRes[32]; 
}NET_DVR_REMOTECONTROL_PTZ_PARAM, *LPNET_DVR_REMOTECONTROL_PTZ_PARAM;

typedef struct tagNET_DVR_PRESET_POINT_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    DWORD dwPTZPresetCmd; //Ԥõ 
    NET_VCA_POINT struVcaPoint; //Ԥ
    DWORD dwPresetIndex; //Ԥõţ1ʼ֧255Ԥõ
    WORD  wZoomCoordinate;///<Ԥõ㴰Zoomֵ
    BYTE  byRes[30];
}NET_DVR_PRESET_POINT_PARAM, *LPNET_DVR_PRESET_POINT_PARAM;

typedef struct tagNET_DVR_PTZ_CRUISE_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //ͨ
    DWORD dwPTZCruiseCmd; //Ѳ 
    NET_VCA_POINT struVcaPoint; //Ԥ
    WORD wCruiseRoute; //Ѳ·֧32·Ŵ1ʼ
    WORD wCruisePoint; //Ѳ㣬֧32㣨Ŵ1ʼ
    WORD wInput; //ͬѲʱֵͬԤõ(255)ʱ(255)ٶ(40)
    WORD wZoomCoordinate;///<Ԥõ㴰Zoomֵ
    BYTE  byRes[32];
}NET_DVR_PTZ_CRUISE_PARAM, *LPNET_DVR_PTZ_CRUISE_PARAM;

typedef struct tagNET_DVR_WPS_PARAM
{
    DWORD dwSize;
    BYTE byEnableWps; //WPS0-1-
    BYTE byRes[31]; 
}NET_DVR_WPS_PARAM, *LPNET_DVR_WPS_PARAM;

typedef struct tagNET_DVR_PIN_PARAM
{
    DWORD dwSize;
    BYTE byPIN[8]; //PIN
    BYTE byRes[32]; 
}NET_DVR_PIN_PARAM, *LPNET_DVR_PIN_PARAM;

typedef struct tagNET_DVR_WPS_CONNECT_PARAM_
{
    DWORD dwSize;
    BYTE byConnectType; //WPSӷʽ0-PBC,1-AP PIN
    BYTE byRes1[3];
    BYTE byPIN[8]; //PIN(WPSӷʽΪAP PINʱЧ)
    BYTE byEssid[IW_ESSID_MAX_SIZE]; //essid(WPSӷʽΪAP PINʱЧ)
    BYTE byRes[32]; 
}NET_DVR_WPS_CONNECT_PARAM, *LPNET_DVR_WPS_CONNECT_PARAM;

typedef struct tagNET_DVR_DECODER_JOINT_PARAM
{
    DWORD    dwSize;        // ṹС
    BYTE    byJointed;        //  0 ûй 1 Ѿ
    BYTE    byRes1[3];        // ֽ
    NET_DVR_IPADDR    struIP;    // IPַ
    WORD    wPort;            // Ķ˿ں
    WORD    wChannel;        // Ľͨ
    BYTE    sDeviceName[NAME_LEN];    //豸
    BYTE    sChanName[NAME_LEN];    //Ľͨ
    BYTE    byRes2[32];        // ֽ
}NET_DVR_DECODER_JOINT_PARAM, *LPNET_DVR_DECODER_JOINT_PARAM;

typedef struct tagNET_DVR_PIC_VIEW_PARAM
{
    DWORD    dwSize;
    NET_DVR_IPADDR    struCuIp; //CUIPַ
    WORD    wPort;/*CU˿*/
    BYTE    bySourceIndex;    //źԴͨ
    BYTE    byRes[29];
}NET_DVR_PIC_VIEW_PARAM, *LPNET_DVR_PIC_VIEW_PARAM;

#define DVCS_DEVICEID_LEN   16
//2012-03-13ͼƬעϢص
typedef struct tagNET_DVR_PICVIEW_CALLBACKPARAM
{
    DWORD    dwUserID;
    BYTE    sDeviceID[DVCS_DEVICEID_LEN];
    LONG    nPicViewHandle; //Ծ
    WORD    wSignalIndex;    //źԴ
    WORD    wHeadLen;        //ļͷ ˽еļͷ40
    BYTE    byHeadBuf[100]; //ļͷ
    BYTE    byRes2[32];
}NET_DVR_PICVIEW_CALLBACKPARAM, *LPNET_DVR_PICVIEW_CALLBACKPARAM;

#define DEVICEID_LEN      32

typedef struct tagNET_DVR_DEVICEID_INFO
{
    DWORD        dwSize;
    DWORD        dwDeviceIndex;    //豸
    BYTE        byWallNo;     //ǽţ1ʼ
    BYTE        byRes1[27];
    DWORD        dwChan;        //ͨ
    DWORD        dwInputSignalIndex; //źԴʽʹ
    BYTE        byRes2[60];
}NET_DVR_DEVICEID_INFO, *LPNET_DVR_DEVICEID_INFO;


typedef struct tagNET_DVR_SINGLE_NETPARAM
{
    DWORD  dwSize;
    BYTE   byUseDhcp;                 //ǷDHCP 0xff-Ч 0- 1-
    BYTE   byRes1[3];
    NET_DVR_IPADDR  struDevIP;       // 豸IPַ
    NET_DVR_IPADDR  struSubnetMask;  // 豸
    NET_DVR_IPADDR  struGateway;     // 豸
    WORD    wDevPort;                 // 豸˿ں
    BYTE    byMACAddr[MACADDR_LEN];   // MAC ַ(ֻܻȡ)
    BYTE    byRes2[16];
} NET_DVR_SINGLE_NETPARAM, *LPNET_DVR_SINGLE_NETPARAM;

typedef struct tagNET_DVR_CHAN_INFO
{
    DWORD    dwSize;
    BYTE    byValid;                //0-Ч 1-Ч
    BYTE    byRes1[3];
    BYTE    sChanName[NAME_LEN];    //ͨ
    NET_DVR_COLOR struVideoColor;   //źԴɫ
    WORD    wResolutionX;        //ǰֱ--- 
    WORD    wResolutionY;        //ǰֱ---
    BYTE   byRes2[40];
} NET_DVR_CHAN_INFO, *LPNET_DVR_CHAN_INFO;

//豸Ϣ
typedef struct tagNET_DVR_CODEDEV_INFO 
{
    NET_DVR_CHAN_INFO struChanInfo[MAX_CHANNUM/*16*/];/*豸ͨϢ*/ 
} NET_DVR_CODEDEV_INFO, *LPNET_DVR_CODEDEV_INFO;

//豸Ϣ
typedef struct tagNET_DVR_DECODEDEV_INFO 
{
    BYTE    byRes[1408];
} NET_DVR_DECODEDEV_INFO, *LPNET_DVR_DECODEDEV_INFO;

//źԴϢ
typedef struct tagNET_DVR_NETSIGNAL_INFO
{
    DWORD    dwSize;
    BYTE    byDevName[NAME_LEN/*32*/];//źԴ
    NET_DVR_PU_STREAM_CFG struPuStream;  
    BYTE    byValid;            //ǷЧ0-ЧɾʱΪ0  1-ЧӺ޸ʱΪ1/
    BYTE     byRes1[3];    //
    BYTE    sGroupName[NAME_LEN/*32*/];//źԴźԴ
    WORD    wResolutionX;        //ǰֱ--- 
    WORD    wResolutionY;        //ǰֱ---
    BYTE    byRes2[24];        
}NET_DVR_NETSIGNAL_INFO, *LPNET_DVR_NETSIGNAL_INFO;

typedef struct tagNET_DVR_NETSIGNALDEV_INFO
{
    NET_DVR_NETSIGNAL_INFO struDevInfo;
    BYTE    byRes1[816];
}NET_DVR_NETSIGNALDEV_INFO, *LPNET_DVR_NETSIGNALDEV_INFO;

typedef union tagNET_DVR_DIFFDEV_INFO 
{
    NET_DVR_CODEDEV_INFO struCodeDevInfo;        //豸Ϣ
    NET_DVR_DECODEDEV_INFO struDecodeDevInfo;    //豸Ϣ
    NET_DVR_NETSIGNALDEV_INFO struNetSignalInfo;    //źԴϢ
} NET_DVR_DIFFDEV_INFO, *LPNET_DVR_DIFFDEV_INFO;

/*ע豸Ϣ*/
typedef enum tagNET_DVCS_DEVICE_TYPE
{
    NET_DVR_BNC_PROC = 1,                       /* BNC */
        NET_DVR_RGB_PROC,                       /* RGB */
        NET_DVR_STP_PROC,                       /* ת봦 */
        NET_DVR_DISP_PROC,                      /* ʾ */
        NET_DVR_NETSIGNAL,                        //źԴ
        NET_DVR_SDI_PROC,                       //SDI
        NET_DVR_BIW_PROC,                       //8·BNC
        NET_DVR_DON_PROC,                        //ʾ
        NET_DVR_TVI_PROC,                       //TVI
        NET_DVR_DI2_PROC                        //2·DVI
}NET_DVCS_DEVICE_TYPE;

typedef struct  tagNET_DVR_SINGLE_DEV_INFO 
{
    DWORD    dwSize;
    DWORD    dwSoftVersion;            /*豸汾(ֻܻȡ) 8λΪ汾ţθ8λΪΰ汾ţ16λΪ޸汾*/
    DWORD    dwSoftwareBuildDate;         //汾Build, 0xYYYYMMDD
    BYTE    byUseInSys;                /*Ƿϵͳʹ*/
    BYTE    byDevStatus;            /*豸ǰ״̬0-ߣ1-(ֻܻȡ)*/ 
    BYTE    byDeviceType;            /*豸(ֻܻȡ)  DEVICE_TYPE*/ 
    BYTE    byRes1[17];
    BYTE    sDevName[NAME_LEN];     /*豸*/
    NET_DVR_SINGLE_NETPARAM struEtherNet[MAX_ETHERNET]; /*豸*/
    BYTE    sSerialNumber[SERIALNO_LEN];    /*豸к*/
    NET_DVR_DIFFDEV_INFO  struSubDevInfo;        /*豸Ϣ*/ 
    DWORD    dwDeviceIndex;//豸ţÿ豸Ψһȷ
    BYTE    byRes2[48];
} NET_DVR_SINGLE_DEV_INFO, *LPNET_DVR_SINGLE_DEV_INFO;

typedef struct tagNET_DVR_DEVLIST
{
    DWORD        dwSize;
    DWORD        dwDevNums;//豸صķֲʽ豸
    BYTE          *pBuffer;
    BYTE        byRes1[3];
    DWORD         dwBufLen;//ָ볤ȣ
    BYTE        byRes2[64];
} NET_DVR_DEVLIST,*LPNET_DVR_DEVLIST;

typedef struct tagNET_DVR_DEV_BASE_INFO
{
    DWORD  dwSize;
    BYTE   byEnable;          /*Ƿϵͳʹ*/
    BYTE   byDeviceType;      /*豸(ֻܻȡ)*/ 
    BYTE   byRes1[2];
    BYTE   sDevName[NAME_LEN]; /*豸*/ 
    BYTE   byRes2[24];
} NET_DVR_DEV_BASE_INFO,*LPNET_DVR_DEV_BASE_INFO;

/*Ϣ*/
typedef  struct tagNET_DVR_NETPARAM
{    
    DWORD dwSize;
    NET_DVR_SINGLE_NETPARAM struEtherNet[MAX_ETHERNET];//̫    
    BYTE   byRes[64];
} NET_DVR_NETPARAM, *LPNET_DVR_NETPARAM;

// Ļ豸ϵ(16ֽ)
typedef struct tagNET_DVR_DISP_SCREEN
{
    DWORD    dwSize;
    WORD    wScreenID;        // ĻID, IDŴ1ʼ
    BYTE    byWallNo;        // ǽ
    BYTE    byRes1;            // 1
    DWORD    dwDeviceIndex;    // 豸
    BYTE    byRes2[16];        // 2
}NET_DVR_DISP_SCREEN, *LPNET_DVR_DISP_SCREEN;

// Ļ
typedef struct tagNET_DVR_TEXTSHOW
{
    DWORD dwSize;
    BYTE  byShowText;//Ƿʾ֣1-ʾ֣0-ʾ
    BYTE  byRes[35];
}NET_DVR_TEXTSHOW, *LPNET_DVR_TEXTSHOW;

typedef struct tagNET_DVR_SCREENLIST
{
    DWORD        dwSize;
    BYTE        byWallNo;    //ǽţ1ʼ
    BYTE        byRes[11];
    DWORD        dwScreenNums;//豸صӳʾ
    BYTE          *pBuffer;
    DWORD         dwBufLen;//ָ볤ȣ
} NET_DVR_SCREENLIST,*LPNET_DVR_SCREENLIST;

typedef struct tagNET_DVR_OPERATE_DEVICE
{
    DWORD    dwSize;
    DWORD    dwSubCommand;    //豸1-豸ʼ2-ֹͣ
    DWORD    dwDeviceIndex;//豸
    BYTE    byRes[44];
}NET_DVR_OPERATE_DEVICE, *LPNET_DVR_OPERATE_DEVICE;

//豸
typedef struct tagNET_DVR_UPGRADE_STATE
{
    DWORD    dwProgress; // 0-100
    BYTE     byState;  //ȣ1- 2- 3-ʧ
    BYTE    byRes2[31];
}NET_DVR_UPGRADE_STATE, *LPNET_DVR_UPGRADE_STATE;
typedef void (CALLBACK *DVCS_UPGRADESTATE_CB)(LONG nUpgradeHandle, BYTE *pBuffer, DWORD dwBufSize, void* pUser);

typedef enum
{
    NET_DVR_DATA_BMP = 0,
        NET_DVR_START_CALLBACK, 
        NET_DVR_STREAM_SYSHEAD,
        NET_DVR_STREAM_DATA
}PIC_PREVIEW_DATATYPE;

typedef struct tagNET_DVR_START_PIC_VIEW_INFO
{
    DWORD    dwSize;
    DWORD    dwSignalIndex;    //źԴţòڴ豸ֵΪ0
    DWORD    dwDeviceIndex;//豸
    BYTE    byRes1[12];
    BYTE    byChanIndex;    //ͨ
    BYTE    byRes2[3];
    //Ƶۺƽ̨Բ
    DWORD   dwScreenNum; //ţ㿪ʼ
    DWORD   dwLayer;     //ͼţ㿪ʼ
    DWORD   dwResolution;//Էֱ,1-QCIF,2-CIF,3-D1
    BYTE    byFrame;//֡ʣλ֡/
    BYTE    bySupportStreamView; //ͻǷ֧ԣ0-֧֣1-֧
    BYTE    byRes3[14];
}NET_DVR_START_PIC_VIEW_INFO, *LPNET_DVR_START_PIC_VIEW_INFO;

typedef struct tagNET_DVR_DVCS_STATE_ALARM
{
    DWORD    dwSize;
    BYTE    byAlarmType;        // ,1-豸ߣ2-豸 3- 4- 5-Ա½ 6-Ԥʼ,7-Ԥ8-ֱʱ仯9-ͼиʧܣ10-豸Դ㣬11-¶쳣  12-ڴСźԴֱʲ*/
    BYTE    byDeviceType;        // 豸 NET_DVCS_DEVICE_TYPE */ 
    BYTE    byWallNo;            // ǽţ1ʼ 0ʾЧ
    BYTE    byDeviceChanIndex;     // 豸ͨţ0ʾЧֵʾͨ
    DWORD    dwDeviceIndex;        // 豸ţ 0ʾЧ
    WORD    wResolutionX;        // ֱ-  0ʾЧ
    WORD    wResolutionY;        // ֱ-  0ʾЧ
    WORD    wTemperature;       // 豸¶ λ϶, 0ʾЧ 
    BYTE    byRes[86];
}NET_DVR_DVCS_STATE_ALARM, *LPNET_DVR_DVCS_STATE_ALARM;

typedef struct tagNET_DVR_PIC_ADJUST
{
    DWORD        dwSize;
    BYTE        bySubCommand;        //궨DECODEPIC_LEFTADJUST
    BYTE        byScale;            //ֵ
    BYTE        byPictureProportion;    //ͼű 0-Ч 1-4:3, 2-16:9
    BYTE        byRes[29];            
}NET_DVR_PIC_ADJUST, *LPNET_DVR_PIC_ADJUST;

typedef struct tagNET_DVR_PICTURE_PARAM
{
    DWORD    dwSize;        
    BYTE    byControlCommand;    //л1-ʾ2-أ3-ȫɾGIFͼƬ    
    BYTE    byUseType;            //ͼƬͣ1-OSD 2-ͼ3-GIF
    BYTE    byWallNo;            //ǽǽţ1ʼ
    BYTE    byPictureNo;        //ͼƬ
    BYTE    byRes[64];
}NET_DVR_PICTURE_PARAM, *LPNET_DVR_PICTURE_PARAM;

// 76SP豸POEͨӷʽ
typedef struct tagNET_DVR_POE_CHANNEL_ADD_MODE
{
    DWORD        dwSize;                  //ṹС
    BYTE         byAddMode;                 //ӷʽ 0: 弴 1: ֶ    
    BYTE          byRes1[127];              //
}NET_DVR_POE_CHANNEL_ADD_MODE, *LPNET_DVR_POE_CHANNEL_ADD_MODE;

#define MAX_ESATA_NUM 16
#define MAX_MINISAS_NUM 96

typedef struct tagNET_DVR_ESATA_MINISAS_USAGE
{
    DWORD        dwSize;
    BYTE        byESATAUsage[MAX_ESATA_NUM];        // ʾڼeSATA0Ĭϱ 1Ĭ¼
    BYTE        byMiniSASUsage[MAX_MINISAS_NUM];    // ʾڼminiSAS0Ĭϱ 1Ĭ¼
    BYTE         byRes[32];
}NET_DVR_ESATA_MINISAS_USAGE, *LPNET_DVR_ESATA_MINISAS_USAGE;

#define MAX_DISK_NUM 128

typedef struct tagNET_DVR_BACKUP_LOG_PARAM
{
    DWORD        dwSize;
    BYTE        byDiskDesc[DESC_LEN_32];        //ݴ
    BYTE        byHardDisk[MAX_DISK_NUM];        //豸ݵӲ̺ţݼȡǰ 
    BYTE        byBackupHardDiskNum;              //豸ݵӲ̸
    BYTE        byContinue;                        //Ƿݣ0-1-
    BYTE        byAllLogBackUp ;        /*Ƿȫݣ0-̺űݣ1-־Ϊ1ʱ豸ݵĴ̺źӲ̸Ч*/
    BYTE         byRes[29];
}NET_DVR_BACKUP_LOG_PARAM, *LPNET_DVR_BACKUP_LOG_PARAM;

typedef struct tagNET_DVR_DIGITAL_CHANNEL_STATE
{
    DWORD    dwSize;
    BYTE    byDigitalAudioChanTalkState[MAX_CHANNUM_V30];  //ʾͨĶԽ״̬ 0-δʹã1-ʹ, 0xffЧ
    BYTE    byDigitalChanState[MAX_CHANNUM_V30];  /*ͨ״̬ byDigitalChanErrState[0] 
                                               ʾһֵͨʾ״̬룬NET_SDK_DIGITAL_CHANNEL_STATUSԴƣ0xffʾЧͨδIPC*/
    BYTE    byDigitalAudioChanTalkStateEx[MAX_CHANNUM_V30*3];  //ʾͨĶԽ״̬ӵMAX_CHANNUM_V30+1 MAX_CHANNUM_V30*4 0-δʹã1-ʹ, 0xffЧ
    BYTE    byDigitalChanStateEx[MAX_CHANNUM_V30*3];  /*ͨ״̬ byDigitalChanErrStateEx[0]ʾڴӵMAX_CHANNUM_V30+1ֵͨʾ״̬룬NET_SDK_DIGITAL_CHANNEL_STATUSԴƣ0ʾЧ*/
    BYTE    byAnalogChanState[MAX_ANALOG_CHANNUM];//ʾģͨǷ,0-,1-
    BYTE    byRes[32];
}NET_DVR_DIGITAL_CHANNEL_STATE, *LPNET_DVR_DIGITAL_CHANNEL_STATE;

//ͨ״̬
typedef enum
{
    NET_SDK_DC_STATUS_CONNECTED = 1,                //
        NET_SDK_DC_STATUS_CONNECTING,                    //
        NET_SDK_DC_STATUS_BAND_WIDTH_EXCEED,        //ϵͳ
        NET_SDK_DC_STATUS_DOMAIN_ERROR,                //
        NET_SDK_DC_STATUS_CHANNEL_ERROR,                //ͨŴ
        NET_SDK_DC_STATUS_ACCOUNT_ERROR,                //û
        NET_SDK_DC_STATUS_STREAM_TYPE_NOT_SUPPORT,    //Ͳ֧
        NET_SDK_DC_STATUS_CONFLICT_WITH_DVR,            //豸IPַͻ
        NET_SDK_DC_STATUS_CONFLICT_WITH_IPC,            //IPC IPַͻ
        NET_SDK_DC_STATUS_NETWORK_UNREACHBALE,    //粻ɴ
        NET_SDK_DC_STATUS_IPC_NOT_EXIST,                //IPͨδ
        NET_SDK_DC_STATUS_IPC_EXCEPTION,                //IPͨ쳣
        NET_SDK_DC_STATUS_OTHER_ERROR,                //
        NET_SDK_DC_STATUS_RESOLUTION_NOT_SUPPORT,    //IPCֱʲ֧
        NET_SDK_DC_STATUS_IPC_LAN_ERR = 15,         //IPCNVRԲƥ
        NET_SDK_DC_STATUS_USER_LOCKED = 16,         //û
        NET_SDK_DC_STATUS_NOT_ACTIVATED = 17,        //豸δ
        NET_SDK_DC_STATUS_USER_NOT_EXIST = 18,      //û
    